/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

public class CSVReader
extends InputStreamReader {
    private String[] cols;
    private String[] cells;
    private int state = 0;
    private char pc;

    public CSVReader(InputStream in) throws FHIRException, IOException {
        super(in, "UTF-8");
        this.checkBOM();
    }

    private void checkBOM() throws FHIRException, IOException {
        if (this.peek() == '\ufeff') {
            this.next();
        }
    }

    public void readHeaders() throws IOException, FHIRException {
        this.cols = this.parseLine();
    }

    public boolean line() throws IOException, FHIRException {
        if (this.ready()) {
            this.cells = this.parseLine();
            return true;
        }
        return false;
    }

    public boolean has(String name) {
        for (int i = 0; i < this.cols.length; ++i) {
            if (!name.equals(this.cols[i].trim())) continue;
            return this.cell(name) != null;
        }
        return false;
    }

    public String cell(String name) {
        String s2;
        int index = -1;
        for (int i = 0; i < this.cols.length; ++i) {
            if (!name.equals(this.cols[i].trim())) continue;
            index = i;
        }
        if (index == -1) {
            throw new FHIRException("no cell " + name);
        }
        String string = s2 = this.cells.length >= index ? this.cells[index] : null;
        if (Utilities.noString(s2)) {
            return null;
        }
        if (s2.startsWith("\"") && s2.endsWith("\"")) {
            return s2.substring(1, s2.length() - 2);
        }
        return s2;
    }

    protected boolean parseBoolean(String column) {
        if (column == null) {
            return false;
        }
        return column.equalsIgnoreCase("y") || column.equalsIgnoreCase("yes") || column.equalsIgnoreCase("true") || column.equalsIgnoreCase("1");
    }

    protected static String getColumn(String[] titles, String[] values, String column) {
        int c = -1;
        for (int i = 0; i < titles.length; ++i) {
            if (!titles[i].equalsIgnoreCase(column)) continue;
            c = i;
        }
        if (c == -1) {
            return "";
        }
        if (values.length <= c) {
            return "";
        }
        return values[c];
    }

    public String[] parseLine() throws IOException, FHIRException {
        ArrayList<String> res = new ArrayList<String>();
        StringBuilder b = new StringBuilder();
        boolean inQuote = false;
        while (this.ready() && (inQuote || this.peek() != '\r' && this.peek() != '\n')) {
            char c = this.peek();
            this.next();
            if (c == '\"') {
                if (this.ready() && this.peek() == '\"') {
                    b.append(c);
                    this.next();
                    continue;
                }
                inQuote = !inQuote;
                continue;
            }
            if (!inQuote && c == ',') {
                res.add(b.toString().trim());
                b = new StringBuilder();
                continue;
            }
            b.append(c);
        }
        res.add(b.toString().trim());
        while (this.ready() && (this.peek() == '\r' || this.peek() == '\n')) {
            this.next();
        }
        String[] r = new String[]{};
        r = res.toArray(r);
        return r;
    }

    private char peek() throws FHIRException, IOException {
        if (this.state == 0) {
            this.next();
        }
        if (this.state == 1) {
            return this.pc;
        }
        throw new FHIRException("read past end of source");
    }

    private void next() throws FHIRException, IOException {
        if (this.state == 2) {
            throw new FHIRException("read past end of source");
        }
        this.state = 1;
        int i = this.read();
        if (i == -1) {
            this.state = 2;
        } else {
            this.pc = (char)i;
        }
    }

    public void checkColumn(int i, String name, String desc) throws FHIRException {
        if (this.cols.length < i) {
            throw new FHIRException("Error parsing " + desc + ": expected column " + name + " at col " + i + " but only found " + this.cols.length + " cols");
        }
        if (!this.cols[i - 1].equals(name)) {
            throw new FHIRException("Error parsing " + desc + ": expected column " + name + " at col " + i + " but found '" + this.cols[i - 1] + "'");
        }
    }

    public String value(int i) {
        if (i > this.cells.length) {
            return null;
        }
        if (Utilities.noString(this.cells[i - 1])) {
            return null;
        }
        return this.cells[i - 1];
    }
}

