/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;

public class Resolver {

    public static class ResourceWithReference {
        private String reference;
        private BaseWrappers.ResourceWrapper resource;

        public ResourceWithReference(String reference, BaseWrappers.ResourceWrapper resource) {
            this.reference = reference;
            this.resource = resource;
        }

        public String getReference() {
            return this.reference;
        }

        public BaseWrappers.ResourceWrapper getResource() {
            return this.resource;
        }
    }

    public static class ResourceContext {
        Bundle bundleResource;
        Element bundleElement;
        DomainResource resourceResource;
        Element resourceElement;

        public ResourceContext(Bundle bundle, DomainResource dr) {
            this.bundleResource = bundle;
            this.resourceResource = dr;
        }

        public ResourceContext(Element bundle, Element dr) {
            this.bundleElement = bundle;
            this.resourceElement = dr;
        }

        public ResourceContext(Object bundle, org.w3c.dom.Element doc) {
        }

        public Bundle getBundleResource() {
            return this.bundleResource;
        }

        public Element getBundleElement() {
            return this.bundleElement;
        }

        public DomainResource getResourceResource() {
            return this.resourceResource;
        }

        public Element getResourceElement() {
            return this.resourceElement;
        }

        public Bundle.BundleEntryComponent resolve(String value) {
            if (value.startsWith("#")) {
                if (this.resourceResource != null) {
                    for (Resource r : this.resourceResource.getContained()) {
                        if (!r.getId().equals(value.substring(1))) continue;
                        Bundle.BundleEntryComponent be = new Bundle.BundleEntryComponent();
                        be.setResource(r);
                        return be;
                    }
                }
                return null;
            }
            if (this.bundleResource != null) {
                for (Bundle.BundleEntryComponent be : this.bundleResource.getEntry()) {
                    if (be.getFullUrl().equals(value)) {
                        return be;
                    }
                    if (!value.equals(be.getResource().fhirType() + "/" + be.getResource().getId())) continue;
                    return be;
                }
            }
            return null;
        }

        public Element resolveElement(String value) {
            if (value.startsWith("#")) {
                if (this.resourceElement != null) {
                    for (Element r : this.resourceElement.getChildrenByName("contained")) {
                        if (!r.getChildValue("id").equals(value.substring(1))) continue;
                        return r;
                    }
                }
                return null;
            }
            if (this.bundleElement != null) {
                for (Element be : this.bundleElement.getChildren("entry")) {
                    Element res = be.getNamedChild("resource");
                    if (value.equals(be.getChildValue("fullUrl"))) {
                        return be;
                    }
                    if (!value.equals(res.fhirType() + "/" + res.getChildValue("id"))) continue;
                    return be;
                }
            }
            return null;
        }
    }

    public static interface IReferenceResolver {
        public ResourceWithReference resolve(String var1);
    }
}

