/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.utilities.xml.XmlGenerator;
import org.w3c.dom.Element;

public class DOMWrappers {

    public static class ResourceWrapperElement
    extends BaseWrappers.WrapperBaseImpl
    implements BaseWrappers.ResourceWrapper {
        private Element wrapped;
        private StructureDefinition definition;
        private List<BaseWrappers.ResourceWrapper> list;
        private List<BaseWrappers.PropertyWrapper> list2;

        public ResourceWrapperElement(ResourceRenderer renderer, Element wrapped, StructureDefinition definition) {
            super(renderer);
            this.wrapped = wrapped;
            this.definition = definition;
        }

        @Override
        public List<BaseWrappers.ResourceWrapper> getContained() {
            if (this.list == null) {
                ArrayList<Element> children = new ArrayList<Element>();
                XMLUtil.getNamedChildren(this.wrapped, "contained", children);
                this.list = new ArrayList<BaseWrappers.ResourceWrapper>();
                for (Element e : children) {
                    Element c = XMLUtil.getFirstChild(e);
                    this.list.add(new ResourceWrapperElement(this.renderer, c, this.renderer.getContext().getWorker().fetchTypeDefinition(c.getNodeName())));
                }
            }
            return this.list;
        }

        @Override
        public String getId() {
            return XMLUtil.getNamedChildValue(this.wrapped, "id");
        }

        @Override
        public XhtmlNode getNarrative() throws FHIRFormatError, IOException, FHIRException {
            Element txt = XMLUtil.getNamedChild(this.wrapped, "text");
            if (txt == null) {
                return null;
            }
            Element div = XMLUtil.getNamedChild(txt, "div");
            if (div == null) {
                return null;
            }
            try {
                return new XhtmlParser().parse(new XmlGenerator().generate(div), "div");
            }
            catch (FHIRFormatError e) {
                throw new FHIRFormatError(e.getMessage(), e);
            }
            catch (FHIRException e) {
                throw new FHIRException(e.getMessage(), e);
            }
        }

        @Override
        public String getName() {
            return this.wrapped.getNodeName();
        }

        @Override
        public List<BaseWrappers.PropertyWrapper> children() {
            if (this.list2 == null) {
                List<ElementDefinition> children = this.renderer.getContext().getProfileUtilities().getChildList(this.definition, this.definition.getSnapshot().getElement().get(0));
                this.list2 = new ArrayList<BaseWrappers.PropertyWrapper>();
                for (ElementDefinition child : children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    XMLUtil.getNamedChildrenWithWildcard(this.wrapped, this.tail(child.getPath()), elements);
                    this.list2.add(new PropertyWrapperElement(this.renderer, this.definition, child, elements));
                }
            }
            return this.list2;
        }

        @Override
        public void describe(XhtmlNode x) {
            throw new Error("Not done yet");
        }
    }

    public static class PropertyWrapperElement
    extends BaseWrappers.RendererWrapperImpl
    implements BaseWrappers.PropertyWrapper {
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<Element> values;
        private List<BaseWrappers.BaseWrapper> list;

        public PropertyWrapperElement(ResourceRenderer renderer, StructureDefinition structure, ElementDefinition definition, List<Element> values) {
            super(renderer);
            this.structure = structure;
            this.definition = definition;
            this.values = values;
        }

        @Override
        public String getName() {
            return this.tail(this.definition.getPath());
        }

        @Override
        public boolean hasValues() {
            return this.values.size() > 0;
        }

        @Override
        public List<BaseWrappers.BaseWrapper> getValues() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrappers.BaseWrapper>();
                for (Element e : this.values) {
                    this.list.add(new BaseWrapperElement(this.renderer, e, this.determineType(e), this.structure, this.definition));
                }
            }
            return this.list;
        }

        private String determineType(Element e) {
            if (this.definition.getType().isEmpty()) {
                return null;
            }
            if (this.definition.getType().size() == 1) {
                if (this.definition.getType().get(0).getWorkingCode().equals("Element") || this.definition.getType().get(0).getWorkingCode().equals("BackboneElement")) {
                    return null;
                }
                return this.definition.getType().get(0).getWorkingCode();
            }
            String t = e.getNodeName().substring(this.tail(this.definition.getPath()).length() - 3);
            if (this.isPrimitive(Utilities.uncapitalize(t))) {
                return Utilities.uncapitalize(t);
            }
            return t;
        }

        private boolean isPrimitive(String code) {
            StructureDefinition sd = this.renderer.getContext().getWorker().fetchTypeDefinition(code);
            return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
        }

        @Override
        public String getTypeCode() {
            if (this.definition == null || this.definition.getType().size() != 1) {
                throw new Error("not handled");
            }
            return this.definition.getType().get(0).getWorkingCode();
        }

        @Override
        public String getDefinition() {
            if (this.definition == null) {
                throw new Error("not handled");
            }
            return this.definition.getDefinition();
        }

        @Override
        public int getMinCardinality() {
            if (this.definition == null) {
                throw new Error("not handled");
            }
            return this.definition.getMin();
        }

        @Override
        public int getMaxCardinality() {
            if (this.definition == null) {
                throw new Error("not handled");
            }
            return this.definition.getMax().equals("*") ? Integer.MAX_VALUE : Integer.parseInt(this.definition.getMax());
        }

        @Override
        public StructureDefinition getStructure() {
            return this.structure;
        }

        @Override
        public BaseWrappers.BaseWrapper value() {
            if (this.getValues().size() != 1) {
                throw new Error("Access single value, but value count is " + this.getValues().size());
            }
            return this.getValues().get(0);
        }
    }

    public static class BaseWrapperElement
    extends BaseWrappers.WrapperBaseImpl
    implements BaseWrappers.BaseWrapper {
        private Element element;
        private String type;
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<ElementDefinition> children;
        private List<BaseWrappers.PropertyWrapper> list;

        public BaseWrapperElement(ResourceRenderer renderer, Element element, String type, StructureDefinition structure, ElementDefinition definition) {
            super(renderer);
            this.element = element;
            this.type = type;
            this.structure = structure;
            this.definition = definition;
        }

        @Override
        public Base getBase() throws UnsupportedEncodingException, IOException, FHIRException {
            String xml;
            if (this.type == null || this.type.equals("Resource") || this.type.equals("BackboneElement") || this.type.equals("Element")) {
                return null;
            }
            try {
                xml = new XmlGenerator().generate(this.element);
            }
            catch (FHIRException e) {
                throw new FHIRException(e.getMessage(), e);
            }
            return this.renderer.parseType(xml, this.type);
        }

        @Override
        public List<BaseWrappers.PropertyWrapper> children() {
            if (this.list == null) {
                this.children = this.renderer.getContext().getProfileUtilities().getChildList(this.structure, this.definition);
                this.list = new ArrayList<BaseWrappers.PropertyWrapper>();
                for (ElementDefinition child : this.children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    XMLUtil.getNamedChildrenWithWildcard(this.element, this.tail(child.getPath()), elements);
                    this.list.add(new PropertyWrapperElement(this.renderer, this.structure, child, elements));
                }
            }
            return this.list;
        }

        @Override
        public BaseWrappers.PropertyWrapper getChildByName(String name) {
            for (BaseWrappers.PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
            return null;
        }
    }
}

