/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openapi;

import com.google.gson.JsonObject;
import org.hl7.fhir.r5.openapi.BaseWriter;
import org.hl7.fhir.r5.openapi.SchemaWriter;

public class ParameterWriter
extends BaseWriter {
    public ParameterWriter(JsonObject object) {
        super(object);
    }

    public ParameterWriter in(ParameterLocation value) {
        this.object.addProperty("in", value.toString());
        return this;
    }

    public ParameterWriter name(String value) {
        this.object.addProperty("name", value);
        return this;
    }

    public ParameterWriter allowEmptyValue() {
        this.object.addProperty("allowEmptyValue", true);
        return this;
    }

    public ParameterWriter description(String value) {
        if (value != null) {
            this.object.addProperty("description", value);
        }
        return this;
    }

    public ParameterWriter required(boolean value) {
        this.object.addProperty("required", value);
        return this;
    }

    public ParameterWriter deprecated(boolean value) {
        this.object.addProperty("deprecated", value);
        return this;
    }

    public ParameterWriter allowEmptyValue(boolean value) {
        this.object.addProperty("allowEmptyValue", value);
        return this;
    }

    public ParameterWriter style(ParameterStyle value) {
        this.object.addProperty("style", value.toString());
        return this;
    }

    public ParameterWriter explode(boolean value) {
        this.object.addProperty("explode", value);
        return this;
    }

    public ParameterWriter allowReserved(boolean value) {
        this.object.addProperty("allowReserved", value);
        return this;
    }

    public ParameterWriter schema(JsonObject jsonSchema) {
        this.object.add("schema", jsonSchema);
        return this;
    }

    public SchemaWriter schema() {
        JsonObject so = new JsonObject();
        this.object.add("schema", so);
        return new SchemaWriter(so);
    }

    public ParameterWriter schemaRef(String name, String uri) {
        JsonObject schema = new JsonObject();
        schema.addProperty("$ref", uri);
        this.object.add("schema", schema);
        return this;
    }

    public ParameterWriter example(JsonObject example) {
        this.object.add("example", example);
        return this;
    }

    public static enum ParameterStyle {
        matrix,
        label,
        form,
        simple,
        spaceDelimited,
        pipeDelimited,
        deepObject;

    }

    public static enum ParameterLocation {
        query,
        header,
        path,
        cookie;

    }
}

