/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Subscription", profile="http://hl7.org/fhir/StructureDefinition/Subscription")
public class Subscription
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifiers (business identifier)", formalDefinition="A formal identifier that is used to identify this code system when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human readable name for this subscription", formalDefinition="A natural language name identifying the subscription.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="requested | active | error | off", formalDefinition="The status of the subscription, which marks the server state for managing the subscription.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-state")
    protected Enumeration<Enumerations.SubscriptionState> status;
    @Child(name="topic", type={SubscriptionTopic.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to the subscription topic being subscribed to", formalDefinition="The reference to the subscription topic to be notified about.")
    protected Reference topic;
    @Child(name="contact", type={ContactPoint.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for source (e.g. troubleshooting)", formalDefinition="Contact details for a human to contact about the subscription. The primary use of this for system administrator troubleshooting.")
    protected List<ContactPoint> contact;
    @Child(name="end", type={InstantType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When to automatically delete the subscription", formalDefinition="The time for the server to turn the subscription off.")
    protected InstantType end;
    @Child(name="reason", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description of why this subscription was created", formalDefinition="A description of why this subscription is defined.")
    protected StringType reason;
    @Child(name="filterBy", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Criteria for narrowing the subscription topic stream", formalDefinition="The filter properties to be applied to narrow the subscription topic stream.  When multiple filters are applied, evaluates to true if all the conditions are met; otherwise it returns false.   (i.e., logical AND).")
    protected List<SubscriptionFilterByComponent> filterBy;
    @Child(name="error", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Latest error code or note", formalDefinition="A record of the last error that occurred when the server processed a notification.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-error")
    protected List<CodeableConcept> error;
    @Child(name="channelType", type={Coding.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Channel type for notifications", formalDefinition="The type of channel to send notifications on.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-channel-type")
    protected Coding channelType;
    @Child(name="endpoint", type={UrlType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where the channel points to", formalDefinition="The url that describes the actual end-point to send messages to.")
    protected UrlType endpoint;
    @Child(name="header", type={StringType.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Usage depends on the channel type", formalDefinition="Additional headers / information to send as part of the notification.")
    protected List<StringType> header;
    @Child(name="heartbeatPeriod", type={UnsignedIntType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Interval in seconds to send 'heartbeat' notification", formalDefinition="If present,  a 'hearbeat\" notification (keepalive) is sent via this channel with an the interval period equal to this elements integer value in seconds.    If not present, a heartbeat notification is not sent.")
    protected UnsignedIntType heartbeatPeriod;
    @Child(name="timeout", type={UnsignedIntType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Timeout in seconds to attempt notification delivery", formalDefinition="If present, the maximum amount of time a server will allow before failing a notification attempt.")
    protected UnsignedIntType timeout;
    @Child(name="contentType", type={CodeType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="MIME type to send, or omit for no payload", formalDefinition="The mime type to send the payload in - either application/fhir+xml, or application/fhir+json. The MIME types \"text/plain\" and \"text/html\" may also be used for Email subscriptions.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
    protected CodeType contentType;
    @Child(name="content", type={CodeType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="empty | id-only | full-resource", formalDefinition="How much of the resource content to deliver in the notification payload. The choices are an empty payload, only the resource id, or the full resource content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-payload-content")
    protected Enumeration<SubscriptionPayloadContent> content;
    private static final long serialVersionUID = -779068822L;
    @SearchParamDefinition(name="contact", path="Subscription.contact", description="Contact details for the subscription", type="token")
    public static final String SP_CONTACT = "contact";
    public static final TokenClientParam CONTACT = new TokenClientParam("contact");
    @SearchParamDefinition(name="payload", path="", description="The mime-type of the notification payload", type="token")
    public static final String SP_PAYLOAD = "payload";
    public static final TokenClientParam PAYLOAD = new TokenClientParam("payload");
    @SearchParamDefinition(name="status", path="Subscription.status", description="The current state of the subscription", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="type", path="", description="The type of channel for the sent notifications", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="url", path="", description="The uri that will receive the notifications", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");

    public Subscription() {
    }

    public Subscription(Enumerations.SubscriptionState status, Reference topic, Coding channelType) {
        this.setStatus(status);
        this.setTopic(topic);
        this.setChannelType(channelType);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Subscription setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Subscription addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Subscription setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Subscription setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.SubscriptionState> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.SubscriptionState>(new Enumerations.SubscriptionStateEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Subscription setStatusElement(Enumeration<Enumerations.SubscriptionState> value) {
        this.status = value;
        return this;
    }

    public Enumerations.SubscriptionState getStatus() {
        return this.status == null ? null : (Enumerations.SubscriptionState)((Object)this.status.getValue());
    }

    public Subscription setStatus(Enumerations.SubscriptionState value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.SubscriptionState>(new Enumerations.SubscriptionStateEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Reference getTopic() {
        if (this.topic == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.topic");
            }
            if (Configuration.doAutoCreate()) {
                this.topic = new Reference();
            }
        }
        return this.topic;
    }

    public boolean hasTopic() {
        return this.topic != null && !this.topic.isEmpty();
    }

    public Subscription setTopic(Reference value) {
        this.topic = value;
        return this;
    }

    public List<ContactPoint> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        return this.contact;
    }

    public Subscription setContact(List<ContactPoint> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactPoint item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addContact() {
        ContactPoint t = new ContactPoint();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return t;
    }

    public Subscription addContact(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactPoint getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public InstantType getEndElement() {
        if (this.end == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.end");
            }
            if (Configuration.doAutoCreate()) {
                this.end = new InstantType();
            }
        }
        return this.end;
    }

    public boolean hasEndElement() {
        return this.end != null && !this.end.isEmpty();
    }

    public boolean hasEnd() {
        return this.end != null && !this.end.isEmpty();
    }

    public Subscription setEndElement(InstantType value) {
        this.end = value;
        return this;
    }

    public Date getEnd() {
        return this.end == null ? null : (Date)this.end.getValue();
    }

    public Subscription setEnd(Date value) {
        if (value == null) {
            this.end = null;
        } else {
            if (this.end == null) {
                this.end = new InstantType();
            }
            this.end.setValue(value);
        }
        return this;
    }

    public StringType getReasonElement() {
        if (this.reason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.reason");
            }
            if (Configuration.doAutoCreate()) {
                this.reason = new StringType();
            }
        }
        return this.reason;
    }

    public boolean hasReasonElement() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public Subscription setReasonElement(StringType value) {
        this.reason = value;
        return this;
    }

    public String getReason() {
        return this.reason == null ? null : (String)this.reason.getValue();
    }

    public Subscription setReason(String value) {
        if (Utilities.noString(value)) {
            this.reason = null;
        } else {
            if (this.reason == null) {
                this.reason = new StringType();
            }
            this.reason.setValue(value);
        }
        return this;
    }

    public List<SubscriptionFilterByComponent> getFilterBy() {
        if (this.filterBy == null) {
            this.filterBy = new ArrayList<SubscriptionFilterByComponent>();
        }
        return this.filterBy;
    }

    public Subscription setFilterBy(List<SubscriptionFilterByComponent> theFilterBy) {
        this.filterBy = theFilterBy;
        return this;
    }

    public boolean hasFilterBy() {
        if (this.filterBy == null) {
            return false;
        }
        for (SubscriptionFilterByComponent item : this.filterBy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubscriptionFilterByComponent addFilterBy() {
        SubscriptionFilterByComponent t = new SubscriptionFilterByComponent();
        if (this.filterBy == null) {
            this.filterBy = new ArrayList<SubscriptionFilterByComponent>();
        }
        this.filterBy.add(t);
        return t;
    }

    public Subscription addFilterBy(SubscriptionFilterByComponent t) {
        if (t == null) {
            return this;
        }
        if (this.filterBy == null) {
            this.filterBy = new ArrayList<SubscriptionFilterByComponent>();
        }
        this.filterBy.add(t);
        return this;
    }

    public SubscriptionFilterByComponent getFilterByFirstRep() {
        if (this.getFilterBy().isEmpty()) {
            this.addFilterBy();
        }
        return this.getFilterBy().get(0);
    }

    public List<CodeableConcept> getError() {
        if (this.error == null) {
            this.error = new ArrayList<CodeableConcept>();
        }
        return this.error;
    }

    public Subscription setError(List<CodeableConcept> theError) {
        this.error = theError;
        return this;
    }

    public boolean hasError() {
        if (this.error == null) {
            return false;
        }
        for (CodeableConcept item : this.error) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addError() {
        CodeableConcept t = new CodeableConcept();
        if (this.error == null) {
            this.error = new ArrayList<CodeableConcept>();
        }
        this.error.add(t);
        return t;
    }

    public Subscription addError(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.error == null) {
            this.error = new ArrayList<CodeableConcept>();
        }
        this.error.add(t);
        return this;
    }

    public CodeableConcept getErrorFirstRep() {
        if (this.getError().isEmpty()) {
            this.addError();
        }
        return this.getError().get(0);
    }

    public Coding getChannelType() {
        if (this.channelType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.channelType");
            }
            if (Configuration.doAutoCreate()) {
                this.channelType = new Coding();
            }
        }
        return this.channelType;
    }

    public boolean hasChannelType() {
        return this.channelType != null && !this.channelType.isEmpty();
    }

    public Subscription setChannelType(Coding value) {
        this.channelType = value;
        return this;
    }

    public UrlType getEndpointElement() {
        if (this.endpoint == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.endpoint");
            }
            if (Configuration.doAutoCreate()) {
                this.endpoint = new UrlType();
            }
        }
        return this.endpoint;
    }

    public boolean hasEndpointElement() {
        return this.endpoint != null && !this.endpoint.isEmpty();
    }

    public boolean hasEndpoint() {
        return this.endpoint != null && !this.endpoint.isEmpty();
    }

    public Subscription setEndpointElement(UrlType value) {
        this.endpoint = value;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint == null ? null : (String)this.endpoint.getValue();
    }

    public Subscription setEndpoint(String value) {
        if (Utilities.noString(value)) {
            this.endpoint = null;
        } else {
            if (this.endpoint == null) {
                this.endpoint = new UrlType();
            }
            this.endpoint.setValue(value);
        }
        return this;
    }

    public List<StringType> getHeader() {
        if (this.header == null) {
            this.header = new ArrayList<StringType>();
        }
        return this.header;
    }

    public Subscription setHeader(List<StringType> theHeader) {
        this.header = theHeader;
        return this;
    }

    public boolean hasHeader() {
        if (this.header == null) {
            return false;
        }
        for (StringType item : this.header) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addHeaderElement() {
        StringType t = new StringType();
        if (this.header == null) {
            this.header = new ArrayList<StringType>();
        }
        this.header.add(t);
        return t;
    }

    public Subscription addHeader(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.header == null) {
            this.header = new ArrayList<StringType>();
        }
        this.header.add(t);
        return this;
    }

    public boolean hasHeader(String value) {
        if (this.header == null) {
            return false;
        }
        for (StringType v : this.header) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public UnsignedIntType getHeartbeatPeriodElement() {
        if (this.heartbeatPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.heartbeatPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.heartbeatPeriod = new UnsignedIntType();
            }
        }
        return this.heartbeatPeriod;
    }

    public boolean hasHeartbeatPeriodElement() {
        return this.heartbeatPeriod != null && !this.heartbeatPeriod.isEmpty();
    }

    public boolean hasHeartbeatPeriod() {
        return this.heartbeatPeriod != null && !this.heartbeatPeriod.isEmpty();
    }

    public Subscription setHeartbeatPeriodElement(UnsignedIntType value) {
        this.heartbeatPeriod = value;
        return this;
    }

    public int getHeartbeatPeriod() {
        return this.heartbeatPeriod == null || this.heartbeatPeriod.isEmpty() ? 0 : (Integer)this.heartbeatPeriod.getValue();
    }

    public Subscription setHeartbeatPeriod(int value) {
        if (this.heartbeatPeriod == null) {
            this.heartbeatPeriod = new UnsignedIntType();
        }
        this.heartbeatPeriod.setValue((Object)value);
        return this;
    }

    public UnsignedIntType getTimeoutElement() {
        if (this.timeout == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.timeout");
            }
            if (Configuration.doAutoCreate()) {
                this.timeout = new UnsignedIntType();
            }
        }
        return this.timeout;
    }

    public boolean hasTimeoutElement() {
        return this.timeout != null && !this.timeout.isEmpty();
    }

    public boolean hasTimeout() {
        return this.timeout != null && !this.timeout.isEmpty();
    }

    public Subscription setTimeoutElement(UnsignedIntType value) {
        this.timeout = value;
        return this;
    }

    public int getTimeout() {
        return this.timeout == null || this.timeout.isEmpty() ? 0 : (Integer)this.timeout.getValue();
    }

    public Subscription setTimeout(int value) {
        if (this.timeout == null) {
            this.timeout = new UnsignedIntType();
        }
        this.timeout.setValue((Object)value);
        return this;
    }

    public CodeType getContentTypeElement() {
        if (this.contentType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.contentType");
            }
            if (Configuration.doAutoCreate()) {
                this.contentType = new CodeType();
            }
        }
        return this.contentType;
    }

    public boolean hasContentTypeElement() {
        return this.contentType != null && !this.contentType.isEmpty();
    }

    public boolean hasContentType() {
        return this.contentType != null && !this.contentType.isEmpty();
    }

    public Subscription setContentTypeElement(CodeType value) {
        this.contentType = value;
        return this;
    }

    public String getContentType() {
        return this.contentType == null ? null : (String)this.contentType.getValue();
    }

    public Subscription setContentType(String value) {
        if (Utilities.noString(value)) {
            this.contentType = null;
        } else {
            if (this.contentType == null) {
                this.contentType = new CodeType();
            }
            this.contentType.setValue(value);
        }
        return this;
    }

    public Enumeration<SubscriptionPayloadContent> getContentElement() {
        if (this.content == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.content");
            }
            if (Configuration.doAutoCreate()) {
                this.content = new Enumeration<SubscriptionPayloadContent>(new SubscriptionPayloadContentEnumFactory());
            }
        }
        return this.content;
    }

    public boolean hasContentElement() {
        return this.content != null && !this.content.isEmpty();
    }

    public boolean hasContent() {
        return this.content != null && !this.content.isEmpty();
    }

    public Subscription setContentElement(Enumeration<SubscriptionPayloadContent> value) {
        this.content = value;
        return this;
    }

    public SubscriptionPayloadContent getContent() {
        return this.content == null ? null : (SubscriptionPayloadContent)((Object)this.content.getValue());
    }

    public Subscription setContent(SubscriptionPayloadContent value) {
        if (value == null) {
            this.content = null;
        } else {
            if (this.content == null) {
                this.content = new Enumeration<SubscriptionPayloadContent>(new SubscriptionPayloadContentEnumFactory());
            }
            this.content.setValue((Object)value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "A formal identifier that is used to identify this code system when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("name", "string", "A natural language name identifying the subscription.", 0, 1, this.name));
        children.add(new Property(SP_STATUS, "code", "The status of the subscription, which marks the server state for managing the subscription.", 0, 1, this.status));
        children.add(new Property("topic", "Reference(SubscriptionTopic)", "The reference to the subscription topic to be notified about.", 0, 1, this.topic));
        children.add(new Property(SP_CONTACT, "ContactPoint", "Contact details for a human to contact about the subscription. The primary use of this for system administrator troubleshooting.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("end", "instant", "The time for the server to turn the subscription off.", 0, 1, this.end));
        children.add(new Property("reason", "string", "A description of why this subscription is defined.", 0, 1, this.reason));
        children.add(new Property("filterBy", "", "The filter properties to be applied to narrow the subscription topic stream.  When multiple filters are applied, evaluates to true if all the conditions are met; otherwise it returns false.   (i.e., logical AND).", 0, Integer.MAX_VALUE, this.filterBy));
        children.add(new Property("error", "CodeableConcept", "A record of the last error that occurred when the server processed a notification.", 0, Integer.MAX_VALUE, this.error));
        children.add(new Property("channelType", "Coding", "The type of channel to send notifications on.", 0, 1, this.channelType));
        children.add(new Property("endpoint", SP_URL, "The url that describes the actual end-point to send messages to.", 0, 1, this.endpoint));
        children.add(new Property("header", "string", "Additional headers / information to send as part of the notification.", 0, Integer.MAX_VALUE, this.header));
        children.add(new Property("heartbeatPeriod", "unsignedInt", "If present,  a 'hearbeat\" notification (keepalive) is sent via this channel with an the interval period equal to this elements integer value in seconds.    If not present, a heartbeat notification is not sent.", 0, 1, this.heartbeatPeriod));
        children.add(new Property("timeout", "unsignedInt", "If present, the maximum amount of time a server will allow before failing a notification attempt.", 0, 1, this.timeout));
        children.add(new Property("contentType", "code", "The mime type to send the payload in - either application/fhir+xml, or application/fhir+json. The MIME types \"text/plain\" and \"text/html\" may also be used for Email subscriptions.", 0, 1, this.contentType));
        children.add(new Property("content", "code", "How much of the resource content to deliver in the notification payload. The choices are an empty payload, only the resource id, or the full resource content.", 0, 1, this.content));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property("identifier", "Identifier", "A formal identifier that is used to identify this code system when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3373707: {
                return new Property("name", "string", "A natural language name identifying the subscription.", 0, 1, this.name);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the subscription, which marks the server state for managing the subscription.", 0, 1, this.status);
            }
            case 110546223: {
                return new Property("topic", "Reference(SubscriptionTopic)", "The reference to the subscription topic to be notified about.", 0, 1, this.topic);
            }
            case 951526432: {
                return new Property(SP_CONTACT, "ContactPoint", "Contact details for a human to contact about the subscription. The primary use of this for system administrator troubleshooting.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 100571: {
                return new Property("end", "instant", "The time for the server to turn the subscription off.", 0, 1, this.end);
            }
            case -934964668: {
                return new Property("reason", "string", "A description of why this subscription is defined.", 0, 1, this.reason);
            }
            case -721168913: {
                return new Property("filterBy", "", "The filter properties to be applied to narrow the subscription topic stream.  When multiple filters are applied, evaluates to true if all the conditions are met; otherwise it returns false.   (i.e., logical AND).", 0, Integer.MAX_VALUE, this.filterBy);
            }
            case 96784904: {
                return new Property("error", "CodeableConcept", "A record of the last error that occurred when the server processed a notification.", 0, Integer.MAX_VALUE, this.error);
            }
            case 274155229: {
                return new Property("channelType", "Coding", "The type of channel to send notifications on.", 0, 1, this.channelType);
            }
            case 1741102485: {
                return new Property("endpoint", SP_URL, "The url that describes the actual end-point to send messages to.", 0, 1, this.endpoint);
            }
            case -1221270899: {
                return new Property("header", "string", "Additional headers / information to send as part of the notification.", 0, Integer.MAX_VALUE, this.header);
            }
            case -938465827: {
                return new Property("heartbeatPeriod", "unsignedInt", "If present,  a 'hearbeat\" notification (keepalive) is sent via this channel with an the interval period equal to this elements integer value in seconds.    If not present, a heartbeat notification is not sent.", 0, 1, this.heartbeatPeriod);
            }
            case -1313911455: {
                return new Property("timeout", "unsignedInt", "If present, the maximum amount of time a server will allow before failing a notification attempt.", 0, 1, this.timeout);
            }
            case -389131437: {
                return new Property("contentType", "code", "The mime type to send the payload in - either application/fhir+xml, or application/fhir+json. The MIME types \"text/plain\" and \"text/html\" may also be used for Email subscriptions.", 0, 1, this.contentType);
            }
            case 951530617: {
                return new Property("content", "code", "How much of the resource content to deliver in the notification payload. The choices are an empty payload, only the resource id, or the full resource content.", 0, 1, this.content);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 110546223: {
                Base[] baseArray;
                if (this.topic == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.topic;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 100571: {
                Base[] baseArray;
                if (this.end == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.end;
                }
                return baseArray;
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.reason;
                }
                return baseArray;
            }
            case -721168913: {
                return this.filterBy == null ? new Base[]{} : this.filterBy.toArray(new Base[this.filterBy.size()]);
            }
            case 96784904: {
                return this.error == null ? new Base[]{} : this.error.toArray(new Base[this.error.size()]);
            }
            case 274155229: {
                Base[] baseArray;
                if (this.channelType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.channelType;
                }
                return baseArray;
            }
            case 1741102485: {
                Base[] baseArray;
                if (this.endpoint == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.endpoint;
                }
                return baseArray;
            }
            case -1221270899: {
                return this.header == null ? new Base[]{} : this.header.toArray(new Base[this.header.size()]);
            }
            case -938465827: {
                Base[] baseArray;
                if (this.heartbeatPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.heartbeatPeriod;
                }
                return baseArray;
            }
            case -1313911455: {
                Base[] baseArray;
                if (this.timeout == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.timeout;
                }
                return baseArray;
            }
            case -389131437: {
                Base[] baseArray;
                if (this.contentType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.contentType;
                }
                return baseArray;
            }
            case 951530617: {
                Base[] baseArray;
                if (this.content == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.content;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.SubscriptionStateEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 110546223: {
                this.topic = TypeConvertor.castToReference(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactPoint(value));
                return value;
            }
            case 100571: {
                this.end = TypeConvertor.castToInstant(value);
                return value;
            }
            case -934964668: {
                this.reason = TypeConvertor.castToString(value);
                return value;
            }
            case -721168913: {
                this.getFilterBy().add((SubscriptionFilterByComponent)((Object)value));
                return value;
            }
            case 96784904: {
                this.getError().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 274155229: {
                this.channelType = TypeConvertor.castToCoding(value);
                return value;
            }
            case 1741102485: {
                this.endpoint = TypeConvertor.castToUrl(value);
                return value;
            }
            case -1221270899: {
                this.getHeader().add(TypeConvertor.castToString(value));
                return value;
            }
            case -938465827: {
                this.heartbeatPeriod = TypeConvertor.castToUnsignedInt(value);
                return value;
            }
            case -1313911455: {
                this.timeout = TypeConvertor.castToUnsignedInt(value);
                return value;
            }
            case -389131437: {
                this.contentType = TypeConvertor.castToCode(value);
                return value;
            }
            case 951530617: {
                value = new SubscriptionPayloadContentEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.content = value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("name")) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.SubscriptionStateEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("topic")) {
            this.topic = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_CONTACT)) {
            this.getContact().add(TypeConvertor.castToContactPoint(value));
        } else if (name.equals("end")) {
            this.end = TypeConvertor.castToInstant(value);
        } else if (name.equals("reason")) {
            this.reason = TypeConvertor.castToString(value);
        } else if (name.equals("filterBy")) {
            this.getFilterBy().add((SubscriptionFilterByComponent)((Object)value));
        } else if (name.equals("error")) {
            this.getError().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("channelType")) {
            this.channelType = TypeConvertor.castToCoding(value);
        } else if (name.equals("endpoint")) {
            this.endpoint = TypeConvertor.castToUrl(value);
        } else if (name.equals("header")) {
            this.getHeader().add(TypeConvertor.castToString(value));
        } else if (name.equals("heartbeatPeriod")) {
            this.heartbeatPeriod = TypeConvertor.castToUnsignedInt(value);
        } else if (name.equals("timeout")) {
            this.timeout = TypeConvertor.castToUnsignedInt(value);
        } else if (name.equals("contentType")) {
            this.contentType = TypeConvertor.castToCode(value);
        } else if (name.equals("content")) {
            value = new SubscriptionPayloadContentEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.content = value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 110546223: {
                return this.getTopic();
            }
            case 951526432: {
                return this.addContact();
            }
            case 100571: {
                return this.getEndElement();
            }
            case -934964668: {
                return this.getReasonElement();
            }
            case -721168913: {
                return this.addFilterBy();
            }
            case 96784904: {
                return this.addError();
            }
            case 274155229: {
                return this.getChannelType();
            }
            case 1741102485: {
                return this.getEndpointElement();
            }
            case -1221270899: {
                return this.addHeaderElement();
            }
            case -938465827: {
                return this.getHeartbeatPeriodElement();
            }
            case -1313911455: {
                return this.getTimeoutElement();
            }
            case -389131437: {
                return this.getContentTypeElement();
            }
            case 951530617: {
                return this.getContentElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 110546223: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[]{"ContactPoint"};
            }
            case 100571: {
                return new String[]{"instant"};
            }
            case -934964668: {
                return new String[]{"string"};
            }
            case -721168913: {
                return new String[0];
            }
            case 96784904: {
                return new String[]{"CodeableConcept"};
            }
            case 274155229: {
                return new String[]{"Coding"};
            }
            case 1741102485: {
                return new String[]{SP_URL};
            }
            case -1221270899: {
                return new String[]{"string"};
            }
            case -938465827: {
                return new String[]{"unsignedInt"};
            }
            case -1313911455: {
                return new String[]{"unsignedInt"};
            }
            case -389131437: {
                return new String[]{"code"};
            }
            case 951530617: {
                return new String[]{"code"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            return this.addIdentifier();
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type Subscription.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Subscription.status");
        }
        if (name.equals("topic")) {
            this.topic = new Reference();
            return this.topic;
        }
        if (name.equals(SP_CONTACT)) {
            return this.addContact();
        }
        if (name.equals("end")) {
            throw new FHIRException("Cannot call addChild on a primitive type Subscription.end");
        }
        if (name.equals("reason")) {
            throw new FHIRException("Cannot call addChild on a primitive type Subscription.reason");
        }
        if (name.equals("filterBy")) {
            return this.addFilterBy();
        }
        if (name.equals("error")) {
            return this.addError();
        }
        if (name.equals("channelType")) {
            this.channelType = new Coding();
            return this.channelType;
        }
        if (name.equals("endpoint")) {
            throw new FHIRException("Cannot call addChild on a primitive type Subscription.endpoint");
        }
        if (name.equals("header")) {
            throw new FHIRException("Cannot call addChild on a primitive type Subscription.header");
        }
        if (name.equals("heartbeatPeriod")) {
            throw new FHIRException("Cannot call addChild on a primitive type Subscription.heartbeatPeriod");
        }
        if (name.equals("timeout")) {
            throw new FHIRException("Cannot call addChild on a primitive type Subscription.timeout");
        }
        if (name.equals("contentType")) {
            throw new FHIRException("Cannot call addChild on a primitive type Subscription.contentType");
        }
        if (name.equals("content")) {
            throw new FHIRException("Cannot call addChild on a primitive type Subscription.content");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Subscription";
    }

    @Override
    public Subscription copy() {
        Subscription dst = new Subscription();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Subscription dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        Reference reference = dst.topic = this.topic == null ? null : this.topic.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.contact) {
                dst.contact.add(contactPoint.copy());
            }
        }
        dst.end = this.end == null ? null : this.end.copy();
        StringType stringType = dst.reason = this.reason == null ? null : this.reason.copy();
        if (this.filterBy != null) {
            dst.filterBy = new ArrayList<SubscriptionFilterByComponent>();
            for (SubscriptionFilterByComponent subscriptionFilterByComponent : this.filterBy) {
                dst.filterBy.add(subscriptionFilterByComponent.copy());
            }
        }
        if (this.error != null) {
            dst.error = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.error) {
                dst.error.add(codeableConcept.copy());
            }
        }
        dst.channelType = this.channelType == null ? null : this.channelType.copy();
        UrlType urlType = dst.endpoint = this.endpoint == null ? null : this.endpoint.copy();
        if (this.header != null) {
            dst.header = new ArrayList<StringType>();
            for (StringType stringType2 : this.header) {
                dst.header.add(stringType2.copy());
            }
        }
        dst.heartbeatPeriod = this.heartbeatPeriod == null ? null : this.heartbeatPeriod.copy();
        dst.timeout = this.timeout == null ? null : this.timeout.copy();
        dst.contentType = this.contentType == null ? null : this.contentType.copy();
        dst.content = this.content == null ? null : this.content.copy();
    }

    protected Subscription typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Subscription)) {
            return false;
        }
        Subscription o = (Subscription)other_;
        return Subscription.compareDeep(this.identifier, o.identifier, true) && Subscription.compareDeep(this.name, o.name, true) && Subscription.compareDeep(this.status, o.status, true) && Subscription.compareDeep(this.topic, o.topic, true) && Subscription.compareDeep(this.contact, o.contact, true) && Subscription.compareDeep(this.end, o.end, true) && Subscription.compareDeep(this.reason, o.reason, true) && Subscription.compareDeep(this.filterBy, o.filterBy, true) && Subscription.compareDeep(this.error, o.error, true) && Subscription.compareDeep(this.channelType, o.channelType, true) && Subscription.compareDeep(this.endpoint, o.endpoint, true) && Subscription.compareDeep(this.header, o.header, true) && Subscription.compareDeep(this.heartbeatPeriod, o.heartbeatPeriod, true) && Subscription.compareDeep(this.timeout, o.timeout, true) && Subscription.compareDeep(this.contentType, o.contentType, true) && Subscription.compareDeep(this.content, o.content, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Subscription)) {
            return false;
        }
        Subscription o = (Subscription)other_;
        return Subscription.compareValues(this.name, o.name, true) && Subscription.compareValues(this.status, o.status, true) && Subscription.compareValues(this.end, o.end, true) && Subscription.compareValues(this.reason, o.reason, true) && Subscription.compareValues(this.endpoint, o.endpoint, true) && Subscription.compareValues(this.header, o.header, true) && Subscription.compareValues(this.heartbeatPeriod, o.heartbeatPeriod, true) && Subscription.compareValues(this.timeout, o.timeout, true) && Subscription.compareValues(this.contentType, o.contentType, true) && Subscription.compareValues(this.content, o.content, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.name, this.status, this.topic, this.contact, this.end, this.reason, this.filterBy, this.error, this.channelType, this.endpoint, this.header, this.heartbeatPeriod, this.timeout, this.contentType, this.content);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Subscription;
    }

    @Block
    public static class SubscriptionFilterByComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="searchParamName", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Filter label defined in SubscriptionTopic", formalDefinition="The filter label (=key) as defined in the `SubscriptionTopic.canfilterBy.searchParamName`  element.")
        protected StringType searchParamName;
        @Child(name="searchModifier", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="= | eq | ne | gt | lt | ge | le | sa | eb | ap | above | below | in | not-in | of-type", formalDefinition="The operator to apply to the filter value when determining matches (Search modifiers).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-search-modifier")
        protected Enumeration<Enumerations.SubscriptionSearchModifier> searchModifier;
        @Child(name="value", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Literal value or resource path", formalDefinition="The literal value or resource path as is legal in search - for example, \"Patient/123\" or \"le1950\".")
        protected StringType value;
        private static final long serialVersionUID = -1346206527L;

        public SubscriptionFilterByComponent() {
        }

        public SubscriptionFilterByComponent(String searchParamName, String value) {
            this.setSearchParamName(searchParamName);
            this.setValue(value);
        }

        public StringType getSearchParamNameElement() {
            if (this.searchParamName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionFilterByComponent.searchParamName");
                }
                if (Configuration.doAutoCreate()) {
                    this.searchParamName = new StringType();
                }
            }
            return this.searchParamName;
        }

        public boolean hasSearchParamNameElement() {
            return this.searchParamName != null && !this.searchParamName.isEmpty();
        }

        public boolean hasSearchParamName() {
            return this.searchParamName != null && !this.searchParamName.isEmpty();
        }

        public SubscriptionFilterByComponent setSearchParamNameElement(StringType value) {
            this.searchParamName = value;
            return this;
        }

        public String getSearchParamName() {
            return this.searchParamName == null ? null : (String)this.searchParamName.getValue();
        }

        public SubscriptionFilterByComponent setSearchParamName(String value) {
            if (this.searchParamName == null) {
                this.searchParamName = new StringType();
            }
            this.searchParamName.setValue(value);
            return this;
        }

        public Enumeration<Enumerations.SubscriptionSearchModifier> getSearchModifierElement() {
            if (this.searchModifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionFilterByComponent.searchModifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.searchModifier = new Enumeration<Enumerations.SubscriptionSearchModifier>(new Enumerations.SubscriptionSearchModifierEnumFactory());
                }
            }
            return this.searchModifier;
        }

        public boolean hasSearchModifierElement() {
            return this.searchModifier != null && !this.searchModifier.isEmpty();
        }

        public boolean hasSearchModifier() {
            return this.searchModifier != null && !this.searchModifier.isEmpty();
        }

        public SubscriptionFilterByComponent setSearchModifierElement(Enumeration<Enumerations.SubscriptionSearchModifier> value) {
            this.searchModifier = value;
            return this;
        }

        public Enumerations.SubscriptionSearchModifier getSearchModifier() {
            return this.searchModifier == null ? null : (Enumerations.SubscriptionSearchModifier)((Object)this.searchModifier.getValue());
        }

        public SubscriptionFilterByComponent setSearchModifier(Enumerations.SubscriptionSearchModifier value) {
            if (value == null) {
                this.searchModifier = null;
            } else {
                if (this.searchModifier == null) {
                    this.searchModifier = new Enumeration<Enumerations.SubscriptionSearchModifier>(new Enumerations.SubscriptionSearchModifierEnumFactory());
                }
                this.searchModifier.setValue((Object)value);
            }
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionFilterByComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public SubscriptionFilterByComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public SubscriptionFilterByComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("searchParamName", "string", "The filter label (=key) as defined in the `SubscriptionTopic.canfilterBy.searchParamName`  element.", 0, 1, this.searchParamName));
            children.add(new Property("searchModifier", "code", "The operator to apply to the filter value when determining matches (Search modifiers).", 0, 1, this.searchModifier));
            children.add(new Property("value", "string", "The literal value or resource path as is legal in search - for example, \"Patient/123\" or \"le1950\".", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 83857392: {
                    return new Property("searchParamName", "string", "The filter label (=key) as defined in the `SubscriptionTopic.canfilterBy.searchParamName`  element.", 0, 1, this.searchParamName);
                }
                case 1540924575: {
                    return new Property("searchModifier", "code", "The operator to apply to the filter value when determining matches (Search modifiers).", 0, 1, this.searchModifier);
                }
                case 111972721: {
                    return new Property("value", "string", "The literal value or resource path as is legal in search - for example, \"Patient/123\" or \"le1950\".", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 83857392: {
                    Base[] baseArray;
                    if (this.searchParamName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.searchParamName;
                    }
                    return baseArray;
                }
                case 1540924575: {
                    Base[] baseArray;
                    if (this.searchModifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.searchModifier;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 83857392: {
                    this.searchParamName = TypeConvertor.castToString(value);
                    return value;
                }
                case 1540924575: {
                    value = new Enumerations.SubscriptionSearchModifierEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.searchModifier = value;
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("searchParamName")) {
                this.searchParamName = TypeConvertor.castToString(value);
            } else if (name.equals("searchModifier")) {
                value = new Enumerations.SubscriptionSearchModifierEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.searchModifier = value;
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 83857392: {
                    return this.getSearchParamNameElement();
                }
                case 1540924575: {
                    return this.getSearchModifierElement();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 83857392: {
                    return new String[]{"string"};
                }
                case 1540924575: {
                    return new String[]{"code"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("searchParamName")) {
                throw new FHIRException("Cannot call addChild on a primitive type Subscription.filterBy.searchParamName");
            }
            if (name.equals("searchModifier")) {
                throw new FHIRException("Cannot call addChild on a primitive type Subscription.filterBy.searchModifier");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type Subscription.filterBy.value");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionFilterByComponent copy() {
            SubscriptionFilterByComponent dst = new SubscriptionFilterByComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionFilterByComponent dst) {
            super.copyValues(dst);
            dst.searchParamName = this.searchParamName == null ? null : this.searchParamName.copy();
            dst.searchModifier = this.searchModifier == null ? null : this.searchModifier.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionFilterByComponent)) {
                return false;
            }
            SubscriptionFilterByComponent o = (SubscriptionFilterByComponent)other_;
            return SubscriptionFilterByComponent.compareDeep(this.searchParamName, o.searchParamName, true) && SubscriptionFilterByComponent.compareDeep(this.searchModifier, o.searchModifier, true) && SubscriptionFilterByComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionFilterByComponent)) {
                return false;
            }
            SubscriptionFilterByComponent o = (SubscriptionFilterByComponent)other_;
            return SubscriptionFilterByComponent.compareValues(this.searchParamName, o.searchParamName, true) && SubscriptionFilterByComponent.compareValues(this.searchModifier, o.searchModifier, true) && SubscriptionFilterByComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.searchParamName, this.searchModifier, this.value);
        }

        @Override
        public String fhirType() {
            return "Subscription.filterBy";
        }
    }

    public static class SubscriptionPayloadContentEnumFactory
    implements EnumFactory<SubscriptionPayloadContent> {
        @Override
        public SubscriptionPayloadContent fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("empty".equals(codeString)) {
                return SubscriptionPayloadContent.EMPTY;
            }
            if ("id-only".equals(codeString)) {
                return SubscriptionPayloadContent.IDONLY;
            }
            if ("full-resource".equals(codeString)) {
                return SubscriptionPayloadContent.FULLRESOURCE;
            }
            throw new IllegalArgumentException("Unknown SubscriptionPayloadContent code '" + codeString + "'");
        }

        public Enumeration<SubscriptionPayloadContent> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SubscriptionPayloadContent>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("empty".equals(codeString)) {
                return new Enumeration<SubscriptionPayloadContent>(this, SubscriptionPayloadContent.EMPTY);
            }
            if ("id-only".equals(codeString)) {
                return new Enumeration<SubscriptionPayloadContent>(this, SubscriptionPayloadContent.IDONLY);
            }
            if ("full-resource".equals(codeString)) {
                return new Enumeration<SubscriptionPayloadContent>(this, SubscriptionPayloadContent.FULLRESOURCE);
            }
            throw new FHIRException("Unknown SubscriptionPayloadContent code '" + codeString + "'");
        }

        @Override
        public String toCode(SubscriptionPayloadContent code) {
            if (code == SubscriptionPayloadContent.EMPTY) {
                return "empty";
            }
            if (code == SubscriptionPayloadContent.IDONLY) {
                return "id-only";
            }
            if (code == SubscriptionPayloadContent.FULLRESOURCE) {
                return "full-resource";
            }
            return "?";
        }

        @Override
        public String toSystem(SubscriptionPayloadContent code) {
            return code.getSystem();
        }
    }

    public static enum SubscriptionPayloadContent {
        EMPTY,
        IDONLY,
        FULLRESOURCE,
        NULL;


        public static SubscriptionPayloadContent fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("empty".equals(codeString)) {
                return EMPTY;
            }
            if ("id-only".equals(codeString)) {
                return IDONLY;
            }
            if ("full-resource".equals(codeString)) {
                return FULLRESOURCE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SubscriptionPayloadContent code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EMPTY: {
                    return "empty";
                }
                case IDONLY: {
                    return "id-only";
                }
                case FULLRESOURCE: {
                    return "full-resource";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EMPTY: {
                    return "http://hl7.org/fhir/subscription-payload-content";
                }
                case IDONLY: {
                    return "http://hl7.org/fhir/subscription-payload-content";
                }
                case FULLRESOURCE: {
                    return "http://hl7.org/fhir/subscription-payload-content";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EMPTY: {
                    return "No resource content is transacted in the notification payload.";
                }
                case IDONLY: {
                    return "Only the resource id is transacted in the notification payload.";
                }
                case FULLRESOURCE: {
                    return "The entire resource is transacted in the notification payload.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EMPTY: {
                    return "empty";
                }
                case IDONLY: {
                    return "id-only";
                }
                case FULLRESOURCE: {
                    return "full-resource";
                }
            }
            return "?";
        }
    }
}

