/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Questionnaire", profile="http://hl7.org/fhir/StructureDefinition/Questionnaire")
public class Questionnaire
extends MetadataResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this questionnaire, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this questionnaire when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this questionnaire is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the questionnaire is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the questionnaire", formalDefinition="A formal identifier that is used to identify this questionnaire when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the questionnaire", formalDefinition="The identifier that is used to identify this version of the questionnaire when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the questionnaire author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this questionnaire (computer friendly)", formalDefinition="A natural language name identifying the questionnaire. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this questionnaire (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the questionnaire.")
    protected StringType title;
    @Child(name="derivedFrom", type={CanonicalType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instantiates protocol or definition", formalDefinition="The URL of a Questionnaire that this Questionnaire is based on.")
    protected List<CanonicalType> derivedFrom;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this questionnaire. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this questionnaire is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="subjectType", type={CodeType.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Resource that can be subject of QuestionnaireResponse", formalDefinition="The types of subjects that can be the subject of responses created for the questionnaire.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
    protected List<CodeType> subjectType;
    @Child(name="date", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the questionnaire was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the questionnaire changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the organization or individual that published the questionnaire.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the questionnaire", formalDefinition="A free text natural language description of the questionnaire from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate questionnaire instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for questionnaire (if applicable)", formalDefinition="A legal or geographic region in which the questionnaire is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this questionnaire is defined", formalDefinition="Explanation of why this questionnaire is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the questionnaire and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the questionnaire.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the questionnaire was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the questionnaire was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the questionnaire is expected to be used", formalDefinition="The period during which the questionnaire content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="code", type={Coding.class}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Concept that represents the overall questionnaire", formalDefinition="An identifier for this question or group of questions in a particular terminology such as LOINC.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/questionnaire-questions")
    protected List<Coding> code;
    @Child(name="item", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Questions and sections within the Questionnaire", formalDefinition="A particular question, question grouping or display text that is part of the questionnaire.")
    protected List<QuestionnaireItemComponent> item;
    private static final long serialVersionUID = -2135957722L;
    @SearchParamDefinition(name="code", path="Questionnaire.item.code", description="A code that corresponds to one of its items in the questionnaire", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="context-quantity", path="(Questionnaire.useContext.value as Quantity) | (Questionnaire.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the questionnaire", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="Questionnaire.useContext", description="A use context type and quantity- or range-based value assigned to the questionnaire", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="Questionnaire.useContext", description="A use context type and value assigned to the questionnaire", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="Questionnaire.useContext.code", description="A type of use context assigned to the questionnaire", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(Questionnaire.useContext.value as CodeableConcept)", description="A use context assigned to the questionnaire", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="Questionnaire.date", description="The questionnaire publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="definition", path="Questionnaire.item.definition", description="ElementDefinition - details for the item", type="uri")
    public static final String SP_DEFINITION = "definition";
    public static final UriClientParam DEFINITION = new UriClientParam("definition");
    @SearchParamDefinition(name="description", path="Questionnaire.description", description="The description of the questionnaire", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="effective", path="Questionnaire.effectivePeriod", description="The time during which the questionnaire is intended to be in use", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="identifier", path="Questionnaire.identifier", description="External identifier for the questionnaire", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="Questionnaire.jurisdiction", description="Intended jurisdiction for the questionnaire", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="Questionnaire.name", description="Computationally friendly name of the questionnaire", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="Questionnaire.publisher", description="Name of the publisher of the questionnaire", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="Questionnaire.status", description="The current status of the questionnaire", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject-type", path="Questionnaire.subjectType", description="Resource that can be subject of QuestionnaireResponse", type="token")
    public static final String SP_SUBJECT_TYPE = "subject-type";
    public static final TokenClientParam SUBJECT_TYPE = new TokenClientParam("subject-type");
    @SearchParamDefinition(name="title", path="Questionnaire.title", description="The human-friendly name of the questionnaire", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="Questionnaire.url", description="The uri that identifies the questionnaire", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="Questionnaire.version", description="The business version of the questionnaire", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public Questionnaire() {
    }

    public Questionnaire(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public Questionnaire setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public Questionnaire setUrl(String value) {
        if (Utilities.noString(value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public Questionnaire setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public Questionnaire addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public Questionnaire setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public Questionnaire setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public Questionnaire setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public Questionnaire setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public Questionnaire setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public Questionnaire setTitle(String value) {
        if (Utilities.noString(value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public List<CanonicalType> getDerivedFrom() {
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<CanonicalType>();
        }
        return this.derivedFrom;
    }

    public Questionnaire setDerivedFrom(List<CanonicalType> theDerivedFrom) {
        this.derivedFrom = theDerivedFrom;
        return this;
    }

    public boolean hasDerivedFrom() {
        if (this.derivedFrom == null) {
            return false;
        }
        for (CanonicalType item : this.derivedFrom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addDerivedFromElement() {
        CanonicalType t = new CanonicalType();
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<CanonicalType>();
        }
        this.derivedFrom.add(t);
        return t;
    }

    public Questionnaire addDerivedFrom(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<CanonicalType>();
        }
        this.derivedFrom.add(t);
        return this;
    }

    public boolean hasDerivedFrom(String value) {
        if (this.derivedFrom == null) {
            return false;
        }
        for (CanonicalType v : this.derivedFrom) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public Questionnaire setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public Questionnaire setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public Questionnaire setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public Questionnaire setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public List<CodeType> getSubjectType() {
        if (this.subjectType == null) {
            this.subjectType = new ArrayList<CodeType>();
        }
        return this.subjectType;
    }

    public Questionnaire setSubjectType(List<CodeType> theSubjectType) {
        this.subjectType = theSubjectType;
        return this;
    }

    public boolean hasSubjectType() {
        if (this.subjectType == null) {
            return false;
        }
        for (CodeType item : this.subjectType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addSubjectTypeElement() {
        CodeType t = new CodeType();
        if (this.subjectType == null) {
            this.subjectType = new ArrayList<CodeType>();
        }
        this.subjectType.add(t);
        return t;
    }

    public Questionnaire addSubjectType(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.subjectType == null) {
            this.subjectType = new ArrayList<CodeType>();
        }
        this.subjectType.add(t);
        return this;
    }

    public boolean hasSubjectType(String value) {
        if (this.subjectType == null) {
            return false;
        }
        for (CodeType v : this.subjectType) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public Questionnaire setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public Questionnaire setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public Questionnaire setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public Questionnaire setPublisher(String value) {
        if (Utilities.noString(value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public Questionnaire setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public Questionnaire addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public Questionnaire setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public Questionnaire setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public Questionnaire setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public Questionnaire addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public Questionnaire setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public Questionnaire addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public Questionnaire setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public Questionnaire setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public Questionnaire setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public Questionnaire setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    @Override
    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public Questionnaire setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    @Override
    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    @Override
    public Questionnaire setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    @Override
    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public Questionnaire setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    @Override
    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    @Override
    public Questionnaire setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    @Override
    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    @Override
    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    @Override
    public Questionnaire setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    public List<Coding> getCode() {
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        return this.code;
    }

    public Questionnaire setCode(List<Coding> theCode) {
        this.code = theCode;
        return this;
    }

    public boolean hasCode() {
        if (this.code == null) {
            return false;
        }
        for (Coding item : this.code) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addCode() {
        Coding t = new Coding();
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        this.code.add(t);
        return t;
    }

    public Questionnaire addCode(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        this.code.add(t);
        return this;
    }

    public Coding getCodeFirstRep() {
        if (this.getCode().isEmpty()) {
            this.addCode();
        }
        return this.getCode().get(0);
    }

    public List<QuestionnaireItemComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<QuestionnaireItemComponent>();
        }
        return this.item;
    }

    public Questionnaire setItem(List<QuestionnaireItemComponent> theItem) {
        this.item = theItem;
        return this;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (QuestionnaireItemComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public QuestionnaireItemComponent addItem() {
        QuestionnaireItemComponent t = new QuestionnaireItemComponent();
        if (this.item == null) {
            this.item = new ArrayList<QuestionnaireItemComponent>();
        }
        this.item.add(t);
        return t;
    }

    public Questionnaire addItem(QuestionnaireItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<QuestionnaireItemComponent>();
        }
        this.item.add(t);
        return this;
    }

    public QuestionnaireItemComponent getItemFirstRep() {
        if (this.getItem().isEmpty()) {
            this.addItem();
        }
        return this.getItem().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this questionnaire when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this questionnaire is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the questionnaire is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this questionnaire when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the questionnaire when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the questionnaire author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the questionnaire. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the questionnaire.", 0, 1, this.title));
        children.add(new Property("derivedFrom", "canonical(Questionnaire)", "The URL of a Questionnaire that this Questionnaire is based on.", 0, Integer.MAX_VALUE, this.derivedFrom));
        children.add(new Property(SP_STATUS, SP_CODE, "The status of this questionnaire. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this questionnaire is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property("subjectType", SP_CODE, "The types of subjects that can be the subject of responses created for the questionnaire.", 0, Integer.MAX_VALUE, this.subjectType));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the questionnaire was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the questionnaire changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the questionnaire.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the questionnaire from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate questionnaire instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the questionnaire is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this questionnaire is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the questionnaire and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the questionnaire.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the questionnaire content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property(SP_CODE, "Coding", "An identifier for this question or group of questions in a particular terminology such as LOINC.", 0, Integer.MAX_VALUE, this.code));
        children.add(new Property("item", "", "A particular question, question grouping or display text that is part of the questionnaire.", 0, Integer.MAX_VALUE, this.item));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this questionnaire when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this questionnaire is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the questionnaire is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this questionnaire when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the questionnaire when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the questionnaire author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the questionnaire. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the questionnaire.", 0, 1, this.title);
            }
            case 1077922663: {
                return new Property("derivedFrom", "canonical(Questionnaire)", "The URL of a Questionnaire that this Questionnaire is based on.", 0, Integer.MAX_VALUE, this.derivedFrom);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The status of this questionnaire. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this questionnaire is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case -603200890: {
                return new Property("subjectType", SP_CODE, "The types of subjects that can be the subject of responses created for the questionnaire.", 0, Integer.MAX_VALUE, this.subjectType);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the questionnaire was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the questionnaire changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the questionnaire.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the questionnaire from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate questionnaire instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the questionnaire is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this questionnaire is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the questionnaire and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the questionnaire.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the questionnaire content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case 3059181: {
                return new Property(SP_CODE, "Coding", "An identifier for this question or group of questions in a particular terminology such as LOINC.", 0, Integer.MAX_VALUE, this.code);
            }
            case 3242771: {
                return new Property("item", "", "A particular question, question grouping or display text that is part of the questionnaire.", 0, Integer.MAX_VALUE, this.item);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case 1077922663: {
                return this.derivedFrom == null ? new Base[]{} : this.derivedFrom.toArray(new Base[this.derivedFrom.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case -603200890: {
                return this.subjectType == null ? new Base[]{} : this.subjectType.toArray(new Base[this.subjectType.size()]);
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case 3059181: {
                return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
            }
            case 3242771: {
                return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case 1077922663: {
                this.getDerivedFrom().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -603200890: {
                this.getSubjectType().add(TypeConvertor.castToCode(value));
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 3059181: {
                this.getCode().add(TypeConvertor.castToCoding(value));
                return value;
            }
            case 3242771: {
                this.getItem().add((QuestionnaireItemComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals("subjectType")) {
            this.getSubjectType().add(TypeConvertor.castToCode(value));
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_CODE)) {
            this.getCode().add(TypeConvertor.castToCoding(value));
        } else if (name.equals("item")) {
            this.getItem().add((QuestionnaireItemComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case 1077922663: {
                return this.addDerivedFromElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case -603200890: {
                return this.addSubjectTypeElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case 3059181: {
                return this.addCode();
            }
            case 3242771: {
                return this.addItem();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case 1077922663: {
                return new String[]{"canonical"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case -603200890: {
                return new String[]{SP_CODE};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case 3059181: {
                return new String[]{"Coding"};
            }
            case 3242771: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.title");
        }
        if (name.equals("derivedFrom")) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.derivedFrom");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.experimental");
        }
        if (name.equals("subjectType")) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.subjectType");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals(SP_CODE)) {
            return this.addCode();
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Questionnaire";
    }

    @Override
    public Questionnaire copy() {
        Questionnaire dst = new Questionnaire();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Questionnaire dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        StringType stringType = dst.title = this.title == null ? null : this.title.copy();
        if (this.derivedFrom != null) {
            dst.derivedFrom = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.derivedFrom) {
                dst.derivedFrom.add(canonicalType.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        BooleanType booleanType = dst.experimental = this.experimental == null ? null : this.experimental.copy();
        if (this.subjectType != null) {
            dst.subjectType = new ArrayList<CodeType>();
            for (CodeType codeType : this.subjectType) {
                dst.subjectType.add(codeType.copy());
            }
        }
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType2 = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.code != null) {
            dst.code = new ArrayList<Coding>();
            for (Coding coding : this.code) {
                dst.code.add(coding.copy());
            }
        }
        if (this.item != null) {
            dst.item = new ArrayList<QuestionnaireItemComponent>();
            for (QuestionnaireItemComponent questionnaireItemComponent : this.item) {
                dst.item.add(questionnaireItemComponent.copy());
            }
        }
    }

    protected Questionnaire typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Questionnaire)) {
            return false;
        }
        Questionnaire o = (Questionnaire)other_;
        return Questionnaire.compareDeep(this.url, o.url, true) && Questionnaire.compareDeep(this.identifier, o.identifier, true) && Questionnaire.compareDeep(this.version, o.version, true) && Questionnaire.compareDeep(this.name, o.name, true) && Questionnaire.compareDeep(this.title, o.title, true) && Questionnaire.compareDeep(this.derivedFrom, o.derivedFrom, true) && Questionnaire.compareDeep(this.status, o.status, true) && Questionnaire.compareDeep(this.experimental, o.experimental, true) && Questionnaire.compareDeep(this.subjectType, o.subjectType, true) && Questionnaire.compareDeep(this.date, o.date, true) && Questionnaire.compareDeep(this.publisher, o.publisher, true) && Questionnaire.compareDeep(this.contact, o.contact, true) && Questionnaire.compareDeep(this.description, o.description, true) && Questionnaire.compareDeep(this.useContext, o.useContext, true) && Questionnaire.compareDeep(this.jurisdiction, o.jurisdiction, true) && Questionnaire.compareDeep(this.purpose, o.purpose, true) && Questionnaire.compareDeep(this.copyright, o.copyright, true) && Questionnaire.compareDeep(this.approvalDate, o.approvalDate, true) && Questionnaire.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && Questionnaire.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && Questionnaire.compareDeep(this.code, o.code, true) && Questionnaire.compareDeep(this.item, o.item, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Questionnaire)) {
            return false;
        }
        Questionnaire o = (Questionnaire)other_;
        return Questionnaire.compareValues(this.url, o.url, true) && Questionnaire.compareValues(this.version, o.version, true) && Questionnaire.compareValues(this.name, o.name, true) && Questionnaire.compareValues(this.title, o.title, true) && Questionnaire.compareValues(this.derivedFrom, o.derivedFrom, true) && Questionnaire.compareValues(this.status, o.status, true) && Questionnaire.compareValues(this.experimental, o.experimental, true) && Questionnaire.compareValues(this.subjectType, o.subjectType, true) && Questionnaire.compareValues(this.date, o.date, true) && Questionnaire.compareValues(this.publisher, o.publisher, true) && Questionnaire.compareValues(this.description, o.description, true) && Questionnaire.compareValues(this.purpose, o.purpose, true) && Questionnaire.compareValues(this.copyright, o.copyright, true) && Questionnaire.compareValues(this.approvalDate, o.approvalDate, true) && Questionnaire.compareValues(this.lastReviewDate, o.lastReviewDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.url, this.identifier, this.version, this.name, this.title, this.derivedFrom, this.status, this.experimental, this.subjectType, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.code, this.item);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Questionnaire;
    }

    public QuestionnaireItemComponent getQuestion(String linkId) {
        if (linkId == null) {
            return null;
        }
        for (QuestionnaireItemComponent i : this.getItem()) {
            if (i.getLinkId().equals(linkId)) {
                return i;
            }
            QuestionnaireItemComponent t = i.getQuestion(linkId);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public QuestionnaireItemComponent getCommonGroup(QuestionnaireItemComponent q1, QuestionnaireItemComponent q2) {
        for (QuestionnaireItemComponent i : this.getItem()) {
            QuestionnaireItemComponent t = i.getCommonGroup(q1, q2);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Block
    public static class QuestionnaireItemInitialComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={BooleanType.class, DecimalType.class, IntegerType.class, DateType.class, DateTimeType.class, TimeType.class, StringType.class, UriType.class, Attachment.class, Coding.class, Quantity.class, Reference.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Actual value for initializing the question", formalDefinition="The actual value to for an initial answer.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/questionnaire-answers")
        protected DataType value;
        private static final long serialVersionUID = -1135414639L;

        public QuestionnaireItemInitialComponent() {
        }

        public QuestionnaireItemInitialComponent(DataType value) {
            this.setValue(value);
        }

        public DataType getValue() {
            return this.value;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new TimeType();
            }
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this != null && this.value instanceof TimeType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public UriType getValueUriType() throws FHIRException {
            if (this.value == null) {
                this.value = new UriType();
            }
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this != null && this.value instanceof UriType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this != null && this.value instanceof Coding;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public QuestionnaireItemInitialComponent setValue(DataType value) {
            if (!(value == null || value instanceof BooleanType || value instanceof DecimalType || value instanceof IntegerType || value instanceof DateType || value instanceof DateTimeType || value instanceof TimeType || value instanceof StringType || value instanceof UriType || value instanceof Attachment || value instanceof Coding || value instanceof Quantity || value instanceof Reference)) {
                throw new Error("Not the right type for Questionnaire.item.initial.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "The actual value to for an initial answer.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1410166417: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "The actual value to for an initial answer.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "The actual value to for an initial answer.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The actual value to for an initial answer.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "decimal", "The actual value to for an initial answer.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "The actual value to for an initial answer.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", Questionnaire.SP_DATE, "The actual value to for an initial answer.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The actual value to for an initial answer.", 0, 1, this.value);
                }
                case -765708322: {
                    return new Property("value[x]", "time", "The actual value to for an initial answer.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The actual value to for an initial answer.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "uri", "The actual value to for an initial answer.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "The actual value to for an initial answer.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "The actual value to for an initial answer.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The actual value to for an initial answer.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "Reference(Any)", "The actual value to for an initial answer.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("value[x]")) {
                return super.setProperty(name, value);
            }
            this.value = TypeConvertor.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return new String[]{"boolean", "decimal", "integer", Questionnaire.SP_DATE, "dateTime", "time", "string", "uri", "Attachment", "Coding", "Quantity", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public QuestionnaireItemInitialComponent copy() {
            QuestionnaireItemInitialComponent dst = new QuestionnaireItemInitialComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(QuestionnaireItemInitialComponent dst) {
            super.copyValues(dst);
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof QuestionnaireItemInitialComponent)) {
                return false;
            }
            QuestionnaireItemInitialComponent o = (QuestionnaireItemInitialComponent)other_;
            return QuestionnaireItemInitialComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof QuestionnaireItemInitialComponent)) {
                return false;
            }
            QuestionnaireItemInitialComponent o = (QuestionnaireItemInitialComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.value);
        }

        @Override
        public String fhirType() {
            return "Questionnaire.item.initial";
        }
    }

    @Block
    public static class QuestionnaireItemAnswerOptionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={IntegerType.class, DateType.class, TimeType.class, StringType.class, Coding.class, Reference.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Answer value", formalDefinition="A potential answer that's allowed as the answer to this question.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/questionnaire-answers")
        protected DataType value;
        @Child(name="initialSelected", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether option is selected by default", formalDefinition="Indicates whether the answer value is selected when the list of possible answers is initially shown.")
        protected BooleanType initialSelected;
        private static final long serialVersionUID = -504460934L;

        public QuestionnaireItemAnswerOptionComponent() {
        }

        public QuestionnaireItemAnswerOptionComponent(DataType value) {
            this.setValue(value);
        }

        public DataType getValue() {
            return this.value;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new TimeType();
            }
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this != null && this.value instanceof TimeType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this != null && this.value instanceof Coding;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public QuestionnaireItemAnswerOptionComponent setValue(DataType value) {
            if (!(value == null || value instanceof IntegerType || value instanceof DateType || value instanceof TimeType || value instanceof StringType || value instanceof Coding || value instanceof Reference)) {
                throw new Error("Not the right type for Questionnaire.item.answerOption.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public BooleanType getInitialSelectedElement() {
            if (this.initialSelected == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemAnswerOptionComponent.initialSelected");
                }
                if (Configuration.doAutoCreate()) {
                    this.initialSelected = new BooleanType();
                }
            }
            return this.initialSelected;
        }

        public boolean hasInitialSelectedElement() {
            return this.initialSelected != null && !this.initialSelected.isEmpty();
        }

        public boolean hasInitialSelected() {
            return this.initialSelected != null && !this.initialSelected.isEmpty();
        }

        public QuestionnaireItemAnswerOptionComponent setInitialSelectedElement(BooleanType value) {
            this.initialSelected = value;
            return this;
        }

        public boolean getInitialSelected() {
            return this.initialSelected == null || this.initialSelected.isEmpty() ? false : (Boolean)this.initialSelected.getValue();
        }

        public QuestionnaireItemAnswerOptionComponent setInitialSelected(boolean value) {
            if (this.initialSelected == null) {
                this.initialSelected = new BooleanType();
            }
            this.initialSelected.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("value[x]", "integer|date|time|string|Coding|Reference(Any)", "A potential answer that's allowed as the answer to this question.", 0, 1, this.value));
            children.add(new Property("initialSelected", "boolean", "Indicates whether the answer value is selected when the list of possible answers is initially shown.", 0, 1, this.initialSelected));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1410166417: {
                    return new Property("value[x]", "integer|date|time|string|Coding|Reference(Any)", "A potential answer that's allowed as the answer to this question.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "integer|date|time|string|Coding|Reference(Any)", "A potential answer that's allowed as the answer to this question.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "A potential answer that's allowed as the answer to this question.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", Questionnaire.SP_DATE, "A potential answer that's allowed as the answer to this question.", 0, 1, this.value);
                }
                case -765708322: {
                    return new Property("value[x]", "time", "A potential answer that's allowed as the answer to this question.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "A potential answer that's allowed as the answer to this question.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "A potential answer that's allowed as the answer to this question.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "Reference(Any)", "A potential answer that's allowed as the answer to this question.", 0, 1, this.value);
                }
                case -1310184961: {
                    return new Property("initialSelected", "boolean", "Indicates whether the answer value is selected when the list of possible answers is initially shown.", 0, 1, this.initialSelected);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
                case -1310184961: {
                    Base[] baseArray;
                    if (this.initialSelected == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.initialSelected;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
                case -1310184961: {
                    this.initialSelected = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else if (name.equals("initialSelected")) {
                this.initialSelected = TypeConvertor.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -1310184961: {
                    return this.getInitialSelectedElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return new String[]{"integer", Questionnaire.SP_DATE, "time", "string", "Coding", "Reference"};
                }
                case -1310184961: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("initialSelected")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.item.answerOption.initialSelected");
            }
            return super.addChild(name);
        }

        @Override
        public QuestionnaireItemAnswerOptionComponent copy() {
            QuestionnaireItemAnswerOptionComponent dst = new QuestionnaireItemAnswerOptionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(QuestionnaireItemAnswerOptionComponent dst) {
            super.copyValues(dst);
            dst.value = this.value == null ? null : this.value.copy();
            dst.initialSelected = this.initialSelected == null ? null : this.initialSelected.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof QuestionnaireItemAnswerOptionComponent)) {
                return false;
            }
            QuestionnaireItemAnswerOptionComponent o = (QuestionnaireItemAnswerOptionComponent)other_;
            return QuestionnaireItemAnswerOptionComponent.compareDeep(this.value, o.value, true) && QuestionnaireItemAnswerOptionComponent.compareDeep(this.initialSelected, o.initialSelected, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof QuestionnaireItemAnswerOptionComponent)) {
                return false;
            }
            QuestionnaireItemAnswerOptionComponent o = (QuestionnaireItemAnswerOptionComponent)other_;
            return QuestionnaireItemAnswerOptionComponent.compareValues(this.initialSelected, o.initialSelected, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.value, this.initialSelected);
        }

        @Override
        public String fhirType() {
            return "Questionnaire.item.answerOption";
        }
    }

    @Block
    public static class QuestionnaireItemEnableWhenComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="question", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Question that determines whether item is enabled", formalDefinition="The linkId for the question whose answer (or lack of answer) governs whether this item is enabled.")
        protected StringType question;
        @Child(name="operator", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="exists | = | != | > | < | >= | <=", formalDefinition="Specifies the criteria by which the question is enabled.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/questionnaire-enable-operator")
        protected Enumeration<QuestionnaireItemOperator> operator;
        @Child(name="answer", type={BooleanType.class, DecimalType.class, IntegerType.class, DateType.class, DateTimeType.class, TimeType.class, StringType.class, Coding.class, Quantity.class, Reference.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value for question comparison based on operator", formalDefinition="A value that the referenced question is tested using the specified operator in order for the item to be enabled.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/questionnaire-answers")
        protected DataType answer;
        private static final long serialVersionUID = 1909865374L;

        public QuestionnaireItemEnableWhenComponent() {
        }

        public QuestionnaireItemEnableWhenComponent(String question, QuestionnaireItemOperator operator, DataType answer) {
            this.setQuestion(question);
            this.setOperator(operator);
            this.setAnswer(answer);
        }

        public StringType getQuestionElement() {
            if (this.question == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemEnableWhenComponent.question");
                }
                if (Configuration.doAutoCreate()) {
                    this.question = new StringType();
                }
            }
            return this.question;
        }

        public boolean hasQuestionElement() {
            return this.question != null && !this.question.isEmpty();
        }

        public boolean hasQuestion() {
            return this.question != null && !this.question.isEmpty();
        }

        public QuestionnaireItemEnableWhenComponent setQuestionElement(StringType value) {
            this.question = value;
            return this;
        }

        public String getQuestion() {
            return this.question == null ? null : (String)this.question.getValue();
        }

        public QuestionnaireItemEnableWhenComponent setQuestion(String value) {
            if (this.question == null) {
                this.question = new StringType();
            }
            this.question.setValue(value);
            return this;
        }

        public Enumeration<QuestionnaireItemOperator> getOperatorElement() {
            if (this.operator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemEnableWhenComponent.operator");
                }
                if (Configuration.doAutoCreate()) {
                    this.operator = new Enumeration<QuestionnaireItemOperator>(new QuestionnaireItemOperatorEnumFactory());
                }
            }
            return this.operator;
        }

        public boolean hasOperatorElement() {
            return this.operator != null && !this.operator.isEmpty();
        }

        public boolean hasOperator() {
            return this.operator != null && !this.operator.isEmpty();
        }

        public QuestionnaireItemEnableWhenComponent setOperatorElement(Enumeration<QuestionnaireItemOperator> value) {
            this.operator = value;
            return this;
        }

        public QuestionnaireItemOperator getOperator() {
            return this.operator == null ? null : (QuestionnaireItemOperator)((Object)this.operator.getValue());
        }

        public QuestionnaireItemEnableWhenComponent setOperator(QuestionnaireItemOperator value) {
            if (this.operator == null) {
                this.operator = new Enumeration<QuestionnaireItemOperator>(new QuestionnaireItemOperatorEnumFactory());
            }
            this.operator.setValue((Object)value);
            return this;
        }

        public DataType getAnswer() {
            return this.answer;
        }

        public BooleanType getAnswerBooleanType() throws FHIRException {
            if (this.answer == null) {
                this.answer = new BooleanType();
            }
            if (!(this.answer instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.answer;
        }

        public boolean hasAnswerBooleanType() {
            return this != null && this.answer instanceof BooleanType;
        }

        public DecimalType getAnswerDecimalType() throws FHIRException {
            if (this.answer == null) {
                this.answer = new DecimalType();
            }
            if (!(this.answer instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.answer;
        }

        public boolean hasAnswerDecimalType() {
            return this != null && this.answer instanceof DecimalType;
        }

        public IntegerType getAnswerIntegerType() throws FHIRException {
            if (this.answer == null) {
                this.answer = new IntegerType();
            }
            if (!(this.answer instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.answer;
        }

        public boolean hasAnswerIntegerType() {
            return this != null && this.answer instanceof IntegerType;
        }

        public DateType getAnswerDateType() throws FHIRException {
            if (this.answer == null) {
                this.answer = new DateType();
            }
            if (!(this.answer instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (DateType)this.answer;
        }

        public boolean hasAnswerDateType() {
            return this != null && this.answer instanceof DateType;
        }

        public DateTimeType getAnswerDateTimeType() throws FHIRException {
            if (this.answer == null) {
                this.answer = new DateTimeType();
            }
            if (!(this.answer instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.answer;
        }

        public boolean hasAnswerDateTimeType() {
            return this != null && this.answer instanceof DateTimeType;
        }

        public TimeType getAnswerTimeType() throws FHIRException {
            if (this.answer == null) {
                this.answer = new TimeType();
            }
            if (!(this.answer instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (TimeType)this.answer;
        }

        public boolean hasAnswerTimeType() {
            return this != null && this.answer instanceof TimeType;
        }

        public StringType getAnswerStringType() throws FHIRException {
            if (this.answer == null) {
                this.answer = new StringType();
            }
            if (!(this.answer instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (StringType)this.answer;
        }

        public boolean hasAnswerStringType() {
            return this != null && this.answer instanceof StringType;
        }

        public Coding getAnswerCoding() throws FHIRException {
            if (this.answer == null) {
                this.answer = new Coding();
            }
            if (!(this.answer instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (Coding)this.answer;
        }

        public boolean hasAnswerCoding() {
            return this != null && this.answer instanceof Coding;
        }

        public Quantity getAnswerQuantity() throws FHIRException {
            if (this.answer == null) {
                this.answer = new Quantity();
            }
            if (!(this.answer instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (Quantity)this.answer;
        }

        public boolean hasAnswerQuantity() {
            return this != null && this.answer instanceof Quantity;
        }

        public Reference getAnswerReference() throws FHIRException {
            if (this.answer == null) {
                this.answer = new Reference();
            }
            if (!(this.answer instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (Reference)this.answer;
        }

        public boolean hasAnswerReference() {
            return this != null && this.answer instanceof Reference;
        }

        public boolean hasAnswer() {
            return this.answer != null && !this.answer.isEmpty();
        }

        public QuestionnaireItemEnableWhenComponent setAnswer(DataType value) {
            if (!(value == null || value instanceof BooleanType || value instanceof DecimalType || value instanceof IntegerType || value instanceof DateType || value instanceof DateTimeType || value instanceof TimeType || value instanceof StringType || value instanceof Coding || value instanceof Quantity || value instanceof Reference)) {
                throw new Error("Not the right type for Questionnaire.item.enableWhen.answer[x]: " + value.fhirType());
            }
            this.answer = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("question", "string", "The linkId for the question whose answer (or lack of answer) governs whether this item is enabled.", 0, 1, this.question));
            children.add(new Property("operator", Questionnaire.SP_CODE, "Specifies the criteria by which the question is enabled.", 0, 1, this.operator));
            children.add(new Property("answer[x]", "boolean|decimal|integer|date|dateTime|time|string|Coding|Quantity|Reference(Any)", "A value that the referenced question is tested using the specified operator in order for the item to be enabled.", 0, 1, this.answer));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1165870106: {
                    return new Property("question", "string", "The linkId for the question whose answer (or lack of answer) governs whether this item is enabled.", 0, 1, this.question);
                }
                case -500553564: {
                    return new Property("operator", Questionnaire.SP_CODE, "Specifies the criteria by which the question is enabled.", 0, 1, this.operator);
                }
                case 1693524994: {
                    return new Property("answer[x]", "boolean|decimal|integer|date|dateTime|time|string|Coding|Quantity|Reference(Any)", "A value that the referenced question is tested using the specified operator in order for the item to be enabled.", 0, 1, this.answer);
                }
                case -1412808770: {
                    return new Property("answer[x]", "boolean|decimal|integer|date|dateTime|time|string|Coding|Quantity|Reference(Any)", "A value that the referenced question is tested using the specified operator in order for the item to be enabled.", 0, 1, this.answer);
                }
                case 1194603146: {
                    return new Property("answer[x]", "boolean", "A value that the referenced question is tested using the specified operator in order for the item to be enabled.", 0, 1, this.answer);
                }
                case -1622812237: {
                    return new Property("answer[x]", "decimal", "A value that the referenced question is tested using the specified operator in order for the item to be enabled.", 0, 1, this.answer);
                }
                case -1207023712: {
                    return new Property("answer[x]", "integer", "A value that the referenced question is tested using the specified operator in order for the item to be enabled.", 0, 1, this.answer);
                }
                case 958960780: {
                    return new Property("answer[x]", Questionnaire.SP_DATE, "A value that the referenced question is tested using the specified operator in order for the item to be enabled.", 0, 1, this.answer);
                }
                case -1835321991: {
                    return new Property("answer[x]", "dateTime", "A value that the referenced question is tested using the specified operator in order for the item to be enabled.", 0, 1, this.answer);
                }
                case 959444907: {
                    return new Property("answer[x]", "time", "A value that the referenced question is tested using the specified operator in order for the item to be enabled.", 0, 1, this.answer);
                }
                case -1409727121: {
                    return new Property("answer[x]", "string", "A value that the referenced question is tested using the specified operator in order for the item to be enabled.", 0, 1, this.answer);
                }
                case -1872828216: {
                    return new Property("answer[x]", "Coding", "A value that the referenced question is tested using the specified operator in order for the item to be enabled.", 0, 1, this.answer);
                }
                case -618108311: {
                    return new Property("answer[x]", "Quantity", "A value that the referenced question is tested using the specified operator in order for the item to be enabled.", 0, 1, this.answer);
                }
                case -1726221011: {
                    return new Property("answer[x]", "Reference(Any)", "A value that the referenced question is tested using the specified operator in order for the item to be enabled.", 0, 1, this.answer);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1165870106: {
                    Base[] baseArray;
                    if (this.question == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.question;
                    }
                    return baseArray;
                }
                case -500553564: {
                    Base[] baseArray;
                    if (this.operator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.operator;
                    }
                    return baseArray;
                }
                case -1412808770: {
                    Base[] baseArray;
                    if (this.answer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.answer;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1165870106: {
                    this.question = TypeConvertor.castToString(value);
                    return value;
                }
                case -500553564: {
                    value = new QuestionnaireItemOperatorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.operator = value;
                    return value;
                }
                case -1412808770: {
                    this.answer = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("question")) {
                this.question = TypeConvertor.castToString(value);
            } else if (name.equals("operator")) {
                value = new QuestionnaireItemOperatorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.operator = value;
            } else if (name.equals("answer[x]")) {
                this.answer = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1165870106: {
                    return this.getQuestionElement();
                }
                case -500553564: {
                    return this.getOperatorElement();
                }
                case 1693524994: {
                    return this.getAnswer();
                }
                case -1412808770: {
                    return this.getAnswer();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1165870106: {
                    return new String[]{"string"};
                }
                case -500553564: {
                    return new String[]{Questionnaire.SP_CODE};
                }
                case -1412808770: {
                    return new String[]{"boolean", "decimal", "integer", Questionnaire.SP_DATE, "dateTime", "time", "string", "Coding", "Quantity", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("question")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.item.enableWhen.question");
            }
            if (name.equals("operator")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.item.enableWhen.operator");
            }
            if (name.equals("answerBoolean")) {
                this.answer = new BooleanType();
                return this.answer;
            }
            if (name.equals("answerDecimal")) {
                this.answer = new DecimalType();
                return this.answer;
            }
            if (name.equals("answerInteger")) {
                this.answer = new IntegerType();
                return this.answer;
            }
            if (name.equals("answerDate")) {
                this.answer = new DateType();
                return this.answer;
            }
            if (name.equals("answerDateTime")) {
                this.answer = new DateTimeType();
                return this.answer;
            }
            if (name.equals("answerTime")) {
                this.answer = new TimeType();
                return this.answer;
            }
            if (name.equals("answerString")) {
                this.answer = new StringType();
                return this.answer;
            }
            if (name.equals("answerCoding")) {
                this.answer = new Coding();
                return this.answer;
            }
            if (name.equals("answerQuantity")) {
                this.answer = new Quantity();
                return this.answer;
            }
            if (name.equals("answerReference")) {
                this.answer = new Reference();
                return this.answer;
            }
            return super.addChild(name);
        }

        @Override
        public QuestionnaireItemEnableWhenComponent copy() {
            QuestionnaireItemEnableWhenComponent dst = new QuestionnaireItemEnableWhenComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(QuestionnaireItemEnableWhenComponent dst) {
            super.copyValues(dst);
            dst.question = this.question == null ? null : this.question.copy();
            dst.operator = this.operator == null ? null : this.operator.copy();
            dst.answer = this.answer == null ? null : this.answer.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof QuestionnaireItemEnableWhenComponent)) {
                return false;
            }
            QuestionnaireItemEnableWhenComponent o = (QuestionnaireItemEnableWhenComponent)other_;
            return QuestionnaireItemEnableWhenComponent.compareDeep(this.question, o.question, true) && QuestionnaireItemEnableWhenComponent.compareDeep(this.operator, o.operator, true) && QuestionnaireItemEnableWhenComponent.compareDeep(this.answer, o.answer, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof QuestionnaireItemEnableWhenComponent)) {
                return false;
            }
            QuestionnaireItemEnableWhenComponent o = (QuestionnaireItemEnableWhenComponent)other_;
            return QuestionnaireItemEnableWhenComponent.compareValues(this.question, o.question, true) && QuestionnaireItemEnableWhenComponent.compareValues(this.operator, o.operator, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.question, this.operator, this.answer);
        }

        @Override
        public String fhirType() {
            return "Questionnaire.item.enableWhen";
        }
    }

    @Block
    public static class QuestionnaireItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="linkId", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Unique id for item in questionnaire", formalDefinition="An identifier that is unique within the Questionnaire allowing linkage to the equivalent item in a QuestionnaireResponse resource.")
        protected StringType linkId;
        @Child(name="definition", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="ElementDefinition - details for the item", formalDefinition="This element is a URI that refers to an [ElementDefinition](elementdefinition.html) that provides information about this item, including information that might otherwise be included in the instance of the Questionnaire resource. A detailed description of the construction of the URI is shown in Comments, below. If this element is present then the following element values MAY be derived from the Element Definition if the corresponding elements of this Questionnaire resource instance have no value:\n\n* code (ElementDefinition.code) \n* type (ElementDefinition.type) \n* required (ElementDefinition.min) \n* repeats (ElementDefinition.max) \n* maxLength (ElementDefinition.maxLength) \n* answerValueSet (ElementDefinition.binding)\n* options (ElementDefinition.binding).")
        protected UriType definition;
        @Child(name="code", type={Coding.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Corresponding concept for this item in a terminology", formalDefinition="A terminology code that corresponds to this group or question (e.g. a code from LOINC, which defines many questions and answers).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/questionnaire-questions")
        protected List<Coding> code;
        @Child(name="prefix", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. \"1(a)\", \"2.5.3\"", formalDefinition="A short label for a particular group, question or set of display text within the questionnaire used for reference by the individual completing the questionnaire.")
        protected StringType prefix;
        @Child(name="text", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Primary text for the item", formalDefinition="The name of a section, the text of a question or text content for a display item.")
        protected StringType text;
        @Child(name="type", type={CodeType.class}, order=6, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="group | display | boolean | decimal | integer | date | dateTime +", formalDefinition="The type of questionnaire item this is - whether text for display, a grouping of other items or a particular type of data to be captured (string, integer, coded choice, etc.).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/item-type")
        protected Enumeration<QuestionnaireItemType> type;
        @Child(name="enableWhen", type={}, order=7, min=0, max=-1, modifier=true, summary=false)
        @Description(shortDefinition="Only allow data when", formalDefinition="A constraint indicating that this item should only be enabled (displayed/allow answers to be captured) when the specified condition is true.")
        protected List<QuestionnaireItemEnableWhenComponent> enableWhen;
        @Child(name="enableBehavior", type={CodeType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="all | any", formalDefinition="Controls how multiple enableWhen values are interpreted -  whether all or any must be true.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/questionnaire-enable-behavior")
        protected Enumeration<EnableWhenBehavior> enableBehavior;
        @Child(name="required", type={BooleanType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the item must be included in data results", formalDefinition="An indication, if true, that the item must be present in a \"completed\" QuestionnaireResponse.  If false, the item may be skipped when answering the questionnaire.")
        protected BooleanType required;
        @Child(name="repeats", type={BooleanType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the item may repeat", formalDefinition="An indication, if true, that the item may occur multiple times in the response, collecting multiple answers for questions or multiple sets of answers for groups.")
        protected BooleanType repeats;
        @Child(name="readOnly", type={BooleanType.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Don't allow human editing", formalDefinition="An indication, when true, that the value cannot be changed by a human respondent to the Questionnaire.")
        protected BooleanType readOnly;
        @Child(name="maxLength", type={IntegerType.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="No more than this many characters", formalDefinition="The maximum number of characters that are permitted in the answer to be considered a \"valid\" QuestionnaireResponse.")
        protected IntegerType maxLength;
        @Child(name="answerValueSet", type={CanonicalType.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Valueset containing permitted answers", formalDefinition="A reference to a value set containing a list of codes representing permitted answers for a \"choice\" or \"open-choice\" question.")
        protected CanonicalType answerValueSet;
        @Child(name="answerOption", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Permitted answer", formalDefinition="One of the permitted answers for a \"choice\" or \"open-choice\" question.")
        protected List<QuestionnaireItemAnswerOptionComponent> answerOption;
        @Child(name="initial", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Initial value(s) when item is first rendered", formalDefinition="One or more values that should be pre-populated in the answer when initially rendering the questionnaire for user input.")
        protected List<QuestionnaireItemInitialComponent> initial;
        @Child(name="item", type={QuestionnaireItemComponent.class}, order=16, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested questionnaire items", formalDefinition="Text, questions and other groups to be nested beneath a question or group.")
        protected List<QuestionnaireItemComponent> item;
        private static final long serialVersionUID = -1503380450L;

        public QuestionnaireItemComponent() {
        }

        public QuestionnaireItemComponent(String linkId, QuestionnaireItemType type) {
            this.setLinkId(linkId);
            this.setType(type);
        }

        public StringType getLinkIdElement() {
            if (this.linkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.linkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.linkId = new StringType();
                }
            }
            return this.linkId;
        }

        public boolean hasLinkIdElement() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public boolean hasLinkId() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public QuestionnaireItemComponent setLinkIdElement(StringType value) {
            this.linkId = value;
            return this;
        }

        public String getLinkId() {
            return this.linkId == null ? null : (String)this.linkId.getValue();
        }

        public QuestionnaireItemComponent setLinkId(String value) {
            if (this.linkId == null) {
                this.linkId = new StringType();
            }
            this.linkId.setValue(value);
            return this;
        }

        public UriType getDefinitionElement() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new UriType();
                }
            }
            return this.definition;
        }

        public boolean hasDefinitionElement() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public QuestionnaireItemComponent setDefinitionElement(UriType value) {
            this.definition = value;
            return this;
        }

        public String getDefinition() {
            return this.definition == null ? null : (String)this.definition.getValue();
        }

        public QuestionnaireItemComponent setDefinition(String value) {
            if (Utilities.noString(value)) {
                this.definition = null;
            } else {
                if (this.definition == null) {
                    this.definition = new UriType();
                }
                this.definition.setValue(value);
            }
            return this;
        }

        public List<Coding> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<Coding>();
            }
            return this.code;
        }

        public QuestionnaireItemComponent setCode(List<Coding> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (Coding item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addCode() {
            Coding t = new Coding();
            if (this.code == null) {
                this.code = new ArrayList<Coding>();
            }
            this.code.add(t);
            return t;
        }

        public QuestionnaireItemComponent addCode(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<Coding>();
            }
            this.code.add(t);
            return this;
        }

        public Coding getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public StringType getPrefixElement() {
            if (this.prefix == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.prefix");
                }
                if (Configuration.doAutoCreate()) {
                    this.prefix = new StringType();
                }
            }
            return this.prefix;
        }

        public boolean hasPrefixElement() {
            return this.prefix != null && !this.prefix.isEmpty();
        }

        public boolean hasPrefix() {
            return this.prefix != null && !this.prefix.isEmpty();
        }

        public QuestionnaireItemComponent setPrefixElement(StringType value) {
            this.prefix = value;
            return this;
        }

        public String getPrefix() {
            return this.prefix == null ? null : (String)this.prefix.getValue();
        }

        public QuestionnaireItemComponent setPrefix(String value) {
            if (Utilities.noString(value)) {
                this.prefix = null;
            } else {
                if (this.prefix == null) {
                    this.prefix = new StringType();
                }
                this.prefix.setValue(value);
            }
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public QuestionnaireItemComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public QuestionnaireItemComponent setText(String value) {
            if (Utilities.noString(value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public Enumeration<QuestionnaireItemType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<QuestionnaireItemType>(new QuestionnaireItemTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public QuestionnaireItemComponent setTypeElement(Enumeration<QuestionnaireItemType> value) {
            this.type = value;
            return this;
        }

        public QuestionnaireItemType getType() {
            return this.type == null ? null : (QuestionnaireItemType)((Object)this.type.getValue());
        }

        public QuestionnaireItemComponent setType(QuestionnaireItemType value) {
            if (this.type == null) {
                this.type = new Enumeration<QuestionnaireItemType>(new QuestionnaireItemTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public List<QuestionnaireItemEnableWhenComponent> getEnableWhen() {
            if (this.enableWhen == null) {
                this.enableWhen = new ArrayList<QuestionnaireItemEnableWhenComponent>();
            }
            return this.enableWhen;
        }

        public QuestionnaireItemComponent setEnableWhen(List<QuestionnaireItemEnableWhenComponent> theEnableWhen) {
            this.enableWhen = theEnableWhen;
            return this;
        }

        public boolean hasEnableWhen() {
            if (this.enableWhen == null) {
                return false;
            }
            for (QuestionnaireItemEnableWhenComponent item : this.enableWhen) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionnaireItemEnableWhenComponent addEnableWhen() {
            QuestionnaireItemEnableWhenComponent t = new QuestionnaireItemEnableWhenComponent();
            if (this.enableWhen == null) {
                this.enableWhen = new ArrayList<QuestionnaireItemEnableWhenComponent>();
            }
            this.enableWhen.add(t);
            return t;
        }

        public QuestionnaireItemComponent addEnableWhen(QuestionnaireItemEnableWhenComponent t) {
            if (t == null) {
                return this;
            }
            if (this.enableWhen == null) {
                this.enableWhen = new ArrayList<QuestionnaireItemEnableWhenComponent>();
            }
            this.enableWhen.add(t);
            return this;
        }

        public QuestionnaireItemEnableWhenComponent getEnableWhenFirstRep() {
            if (this.getEnableWhen().isEmpty()) {
                this.addEnableWhen();
            }
            return this.getEnableWhen().get(0);
        }

        public Enumeration<EnableWhenBehavior> getEnableBehaviorElement() {
            if (this.enableBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.enableBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.enableBehavior = new Enumeration<EnableWhenBehavior>(new EnableWhenBehaviorEnumFactory());
                }
            }
            return this.enableBehavior;
        }

        public boolean hasEnableBehaviorElement() {
            return this.enableBehavior != null && !this.enableBehavior.isEmpty();
        }

        public boolean hasEnableBehavior() {
            return this.enableBehavior != null && !this.enableBehavior.isEmpty();
        }

        public QuestionnaireItemComponent setEnableBehaviorElement(Enumeration<EnableWhenBehavior> value) {
            this.enableBehavior = value;
            return this;
        }

        public EnableWhenBehavior getEnableBehavior() {
            return this.enableBehavior == null ? null : (EnableWhenBehavior)((Object)this.enableBehavior.getValue());
        }

        public QuestionnaireItemComponent setEnableBehavior(EnableWhenBehavior value) {
            if (value == null) {
                this.enableBehavior = null;
            } else {
                if (this.enableBehavior == null) {
                    this.enableBehavior = new Enumeration<EnableWhenBehavior>(new EnableWhenBehaviorEnumFactory());
                }
                this.enableBehavior.setValue((Object)value);
            }
            return this;
        }

        public BooleanType getRequiredElement() {
            if (this.required == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.required");
                }
                if (Configuration.doAutoCreate()) {
                    this.required = new BooleanType();
                }
            }
            return this.required;
        }

        public boolean hasRequiredElement() {
            return this.required != null && !this.required.isEmpty();
        }

        public boolean hasRequired() {
            return this.required != null && !this.required.isEmpty();
        }

        public QuestionnaireItemComponent setRequiredElement(BooleanType value) {
            this.required = value;
            return this;
        }

        public boolean getRequired() {
            return this.required == null || this.required.isEmpty() ? false : (Boolean)this.required.getValue();
        }

        public QuestionnaireItemComponent setRequired(boolean value) {
            if (this.required == null) {
                this.required = new BooleanType();
            }
            this.required.setValue((Object)value);
            return this;
        }

        public BooleanType getRepeatsElement() {
            if (this.repeats == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.repeats");
                }
                if (Configuration.doAutoCreate()) {
                    this.repeats = new BooleanType();
                }
            }
            return this.repeats;
        }

        public boolean hasRepeatsElement() {
            return this.repeats != null && !this.repeats.isEmpty();
        }

        public boolean hasRepeats() {
            return this.repeats != null && !this.repeats.isEmpty();
        }

        public QuestionnaireItemComponent setRepeatsElement(BooleanType value) {
            this.repeats = value;
            return this;
        }

        public boolean getRepeats() {
            return this.repeats == null || this.repeats.isEmpty() ? false : (Boolean)this.repeats.getValue();
        }

        public QuestionnaireItemComponent setRepeats(boolean value) {
            if (this.repeats == null) {
                this.repeats = new BooleanType();
            }
            this.repeats.setValue((Object)value);
            return this;
        }

        public BooleanType getReadOnlyElement() {
            if (this.readOnly == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.readOnly");
                }
                if (Configuration.doAutoCreate()) {
                    this.readOnly = new BooleanType();
                }
            }
            return this.readOnly;
        }

        public boolean hasReadOnlyElement() {
            return this.readOnly != null && !this.readOnly.isEmpty();
        }

        public boolean hasReadOnly() {
            return this.readOnly != null && !this.readOnly.isEmpty();
        }

        public QuestionnaireItemComponent setReadOnlyElement(BooleanType value) {
            this.readOnly = value;
            return this;
        }

        public boolean getReadOnly() {
            return this.readOnly == null || this.readOnly.isEmpty() ? false : (Boolean)this.readOnly.getValue();
        }

        public QuestionnaireItemComponent setReadOnly(boolean value) {
            if (this.readOnly == null) {
                this.readOnly = new BooleanType();
            }
            this.readOnly.setValue((Object)value);
            return this;
        }

        public IntegerType getMaxLengthElement() {
            if (this.maxLength == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.maxLength");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxLength = new IntegerType();
                }
            }
            return this.maxLength;
        }

        public boolean hasMaxLengthElement() {
            return this.maxLength != null && !this.maxLength.isEmpty();
        }

        public boolean hasMaxLength() {
            return this.maxLength != null && !this.maxLength.isEmpty();
        }

        public QuestionnaireItemComponent setMaxLengthElement(IntegerType value) {
            this.maxLength = value;
            return this;
        }

        public int getMaxLength() {
            return this.maxLength == null || this.maxLength.isEmpty() ? 0 : (Integer)this.maxLength.getValue();
        }

        public QuestionnaireItemComponent setMaxLength(int value) {
            if (this.maxLength == null) {
                this.maxLength = new IntegerType();
            }
            this.maxLength.setValue((Object)value);
            return this;
        }

        public CanonicalType getAnswerValueSetElement() {
            if (this.answerValueSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.answerValueSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.answerValueSet = new CanonicalType();
                }
            }
            return this.answerValueSet;
        }

        public boolean hasAnswerValueSetElement() {
            return this.answerValueSet != null && !this.answerValueSet.isEmpty();
        }

        public boolean hasAnswerValueSet() {
            return this.answerValueSet != null && !this.answerValueSet.isEmpty();
        }

        public QuestionnaireItemComponent setAnswerValueSetElement(CanonicalType value) {
            this.answerValueSet = value;
            return this;
        }

        public String getAnswerValueSet() {
            return this.answerValueSet == null ? null : (String)this.answerValueSet.getValue();
        }

        public QuestionnaireItemComponent setAnswerValueSet(String value) {
            if (Utilities.noString(value)) {
                this.answerValueSet = null;
            } else {
                if (this.answerValueSet == null) {
                    this.answerValueSet = new CanonicalType();
                }
                this.answerValueSet.setValue(value);
            }
            return this;
        }

        public List<QuestionnaireItemAnswerOptionComponent> getAnswerOption() {
            if (this.answerOption == null) {
                this.answerOption = new ArrayList<QuestionnaireItemAnswerOptionComponent>();
            }
            return this.answerOption;
        }

        public QuestionnaireItemComponent setAnswerOption(List<QuestionnaireItemAnswerOptionComponent> theAnswerOption) {
            this.answerOption = theAnswerOption;
            return this;
        }

        public boolean hasAnswerOption() {
            if (this.answerOption == null) {
                return false;
            }
            for (QuestionnaireItemAnswerOptionComponent item : this.answerOption) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionnaireItemAnswerOptionComponent addAnswerOption() {
            QuestionnaireItemAnswerOptionComponent t = new QuestionnaireItemAnswerOptionComponent();
            if (this.answerOption == null) {
                this.answerOption = new ArrayList<QuestionnaireItemAnswerOptionComponent>();
            }
            this.answerOption.add(t);
            return t;
        }

        public QuestionnaireItemComponent addAnswerOption(QuestionnaireItemAnswerOptionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.answerOption == null) {
                this.answerOption = new ArrayList<QuestionnaireItemAnswerOptionComponent>();
            }
            this.answerOption.add(t);
            return this;
        }

        public QuestionnaireItemAnswerOptionComponent getAnswerOptionFirstRep() {
            if (this.getAnswerOption().isEmpty()) {
                this.addAnswerOption();
            }
            return this.getAnswerOption().get(0);
        }

        public List<QuestionnaireItemInitialComponent> getInitial() {
            if (this.initial == null) {
                this.initial = new ArrayList<QuestionnaireItemInitialComponent>();
            }
            return this.initial;
        }

        public QuestionnaireItemComponent setInitial(List<QuestionnaireItemInitialComponent> theInitial) {
            this.initial = theInitial;
            return this;
        }

        public boolean hasInitial() {
            if (this.initial == null) {
                return false;
            }
            for (QuestionnaireItemInitialComponent item : this.initial) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionnaireItemInitialComponent addInitial() {
            QuestionnaireItemInitialComponent t = new QuestionnaireItemInitialComponent();
            if (this.initial == null) {
                this.initial = new ArrayList<QuestionnaireItemInitialComponent>();
            }
            this.initial.add(t);
            return t;
        }

        public QuestionnaireItemComponent addInitial(QuestionnaireItemInitialComponent t) {
            if (t == null) {
                return this;
            }
            if (this.initial == null) {
                this.initial = new ArrayList<QuestionnaireItemInitialComponent>();
            }
            this.initial.add(t);
            return this;
        }

        public QuestionnaireItemInitialComponent getInitialFirstRep() {
            if (this.getInitial().isEmpty()) {
                this.addInitial();
            }
            return this.getInitial().get(0);
        }

        public List<QuestionnaireItemComponent> getItem() {
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireItemComponent>();
            }
            return this.item;
        }

        public QuestionnaireItemComponent setItem(List<QuestionnaireItemComponent> theItem) {
            this.item = theItem;
            return this;
        }

        public boolean hasItem() {
            if (this.item == null) {
                return false;
            }
            for (QuestionnaireItemComponent item : this.item) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionnaireItemComponent addItem() {
            QuestionnaireItemComponent t = new QuestionnaireItemComponent();
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireItemComponent>();
            }
            this.item.add(t);
            return t;
        }

        public QuestionnaireItemComponent addItem(QuestionnaireItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireItemComponent>();
            }
            this.item.add(t);
            return this;
        }

        public QuestionnaireItemComponent getItemFirstRep() {
            if (this.getItem().isEmpty()) {
                this.addItem();
            }
            return this.getItem().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("linkId", "string", "An identifier that is unique within the Questionnaire allowing linkage to the equivalent item in a QuestionnaireResponse resource.", 0, 1, this.linkId));
            children.add(new Property(Questionnaire.SP_DEFINITION, "uri", "This element is a URI that refers to an [ElementDefinition](elementdefinition.html) that provides information about this item, including information that might otherwise be included in the instance of the Questionnaire resource. A detailed description of the construction of the URI is shown in Comments, below. If this element is present then the following element values MAY be derived from the Element Definition if the corresponding elements of this Questionnaire resource instance have no value:\n\n* code (ElementDefinition.code) \n* type (ElementDefinition.type) \n* required (ElementDefinition.min) \n* repeats (ElementDefinition.max) \n* maxLength (ElementDefinition.maxLength) \n* answerValueSet (ElementDefinition.binding)\n* options (ElementDefinition.binding).", 0, 1, this.definition));
            children.add(new Property(Questionnaire.SP_CODE, "Coding", "A terminology code that corresponds to this group or question (e.g. a code from LOINC, which defines many questions and answers).", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property("prefix", "string", "A short label for a particular group, question or set of display text within the questionnaire used for reference by the individual completing the questionnaire.", 0, 1, this.prefix));
            children.add(new Property("text", "string", "The name of a section, the text of a question or text content for a display item.", 0, 1, this.text));
            children.add(new Property("type", Questionnaire.SP_CODE, "The type of questionnaire item this is - whether text for display, a grouping of other items or a particular type of data to be captured (string, integer, coded choice, etc.).", 0, 1, this.type));
            children.add(new Property("enableWhen", "", "A constraint indicating that this item should only be enabled (displayed/allow answers to be captured) when the specified condition is true.", 0, Integer.MAX_VALUE, this.enableWhen));
            children.add(new Property("enableBehavior", Questionnaire.SP_CODE, "Controls how multiple enableWhen values are interpreted -  whether all or any must be true.", 0, 1, this.enableBehavior));
            children.add(new Property("required", "boolean", "An indication, if true, that the item must be present in a \"completed\" QuestionnaireResponse.  If false, the item may be skipped when answering the questionnaire.", 0, 1, this.required));
            children.add(new Property("repeats", "boolean", "An indication, if true, that the item may occur multiple times in the response, collecting multiple answers for questions or multiple sets of answers for groups.", 0, 1, this.repeats));
            children.add(new Property("readOnly", "boolean", "An indication, when true, that the value cannot be changed by a human respondent to the Questionnaire.", 0, 1, this.readOnly));
            children.add(new Property("maxLength", "integer", "The maximum number of characters that are permitted in the answer to be considered a \"valid\" QuestionnaireResponse.", 0, 1, this.maxLength));
            children.add(new Property("answerValueSet", "canonical(ValueSet)", "A reference to a value set containing a list of codes representing permitted answers for a \"choice\" or \"open-choice\" question.", 0, 1, this.answerValueSet));
            children.add(new Property("answerOption", "", "One of the permitted answers for a \"choice\" or \"open-choice\" question.", 0, Integer.MAX_VALUE, this.answerOption));
            children.add(new Property("initial", "", "One or more values that should be pre-populated in the answer when initially rendering the questionnaire for user input.", 0, Integer.MAX_VALUE, this.initial));
            children.add(new Property("item", "@Questionnaire.item", "Text, questions and other groups to be nested beneath a question or group.", 0, Integer.MAX_VALUE, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1102667083: {
                    return new Property("linkId", "string", "An identifier that is unique within the Questionnaire allowing linkage to the equivalent item in a QuestionnaireResponse resource.", 0, 1, this.linkId);
                }
                case -1014418093: {
                    return new Property(Questionnaire.SP_DEFINITION, "uri", "This element is a URI that refers to an [ElementDefinition](elementdefinition.html) that provides information about this item, including information that might otherwise be included in the instance of the Questionnaire resource. A detailed description of the construction of the URI is shown in Comments, below. If this element is present then the following element values MAY be derived from the Element Definition if the corresponding elements of this Questionnaire resource instance have no value:\n\n* code (ElementDefinition.code) \n* type (ElementDefinition.type) \n* required (ElementDefinition.min) \n* repeats (ElementDefinition.max) \n* maxLength (ElementDefinition.maxLength) \n* answerValueSet (ElementDefinition.binding)\n* options (ElementDefinition.binding).", 0, 1, this.definition);
                }
                case 3059181: {
                    return new Property(Questionnaire.SP_CODE, "Coding", "A terminology code that corresponds to this group or question (e.g. a code from LOINC, which defines many questions and answers).", 0, Integer.MAX_VALUE, this.code);
                }
                case -980110702: {
                    return new Property("prefix", "string", "A short label for a particular group, question or set of display text within the questionnaire used for reference by the individual completing the questionnaire.", 0, 1, this.prefix);
                }
                case 3556653: {
                    return new Property("text", "string", "The name of a section, the text of a question or text content for a display item.", 0, 1, this.text);
                }
                case 3575610: {
                    return new Property("type", Questionnaire.SP_CODE, "The type of questionnaire item this is - whether text for display, a grouping of other items or a particular type of data to be captured (string, integer, coded choice, etc.).", 0, 1, this.type);
                }
                case 1893321565: {
                    return new Property("enableWhen", "", "A constraint indicating that this item should only be enabled (displayed/allow answers to be captured) when the specified condition is true.", 0, Integer.MAX_VALUE, this.enableWhen);
                }
                case 1854802165: {
                    return new Property("enableBehavior", Questionnaire.SP_CODE, "Controls how multiple enableWhen values are interpreted -  whether all or any must be true.", 0, 1, this.enableBehavior);
                }
                case -393139297: {
                    return new Property("required", "boolean", "An indication, if true, that the item must be present in a \"completed\" QuestionnaireResponse.  If false, the item may be skipped when answering the questionnaire.", 0, 1, this.required);
                }
                case 1094288952: {
                    return new Property("repeats", "boolean", "An indication, if true, that the item may occur multiple times in the response, collecting multiple answers for questions or multiple sets of answers for groups.", 0, 1, this.repeats);
                }
                case -867683742: {
                    return new Property("readOnly", "boolean", "An indication, when true, that the value cannot be changed by a human respondent to the Questionnaire.", 0, 1, this.readOnly);
                }
                case -791400086: {
                    return new Property("maxLength", "integer", "The maximum number of characters that are permitted in the answer to be considered a \"valid\" QuestionnaireResponse.", 0, 1, this.maxLength);
                }
                case -743278833: {
                    return new Property("answerValueSet", "canonical(ValueSet)", "A reference to a value set containing a list of codes representing permitted answers for a \"choice\" or \"open-choice\" question.", 0, 1, this.answerValueSet);
                }
                case -1527878189: {
                    return new Property("answerOption", "", "One of the permitted answers for a \"choice\" or \"open-choice\" question.", 0, Integer.MAX_VALUE, this.answerOption);
                }
                case 1948342084: {
                    return new Property("initial", "", "One or more values that should be pre-populated in the answer when initially rendering the questionnaire for user input.", 0, Integer.MAX_VALUE, this.initial);
                }
                case 3242771: {
                    return new Property("item", "@Questionnaire.item", "Text, questions and other groups to be nested beneath a question or group.", 0, Integer.MAX_VALUE, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    Base[] baseArray;
                    if (this.linkId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.linkId;
                    }
                    return baseArray;
                }
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.definition;
                    }
                    return baseArray;
                }
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case -980110702: {
                    Base[] baseArray;
                    if (this.prefix == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.prefix;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.text;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.type;
                    }
                    return baseArray;
                }
                case 1893321565: {
                    return this.enableWhen == null ? new Base[]{} : this.enableWhen.toArray(new Base[this.enableWhen.size()]);
                }
                case 1854802165: {
                    Base[] baseArray;
                    if (this.enableBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.enableBehavior;
                    }
                    return baseArray;
                }
                case -393139297: {
                    Base[] baseArray;
                    if (this.required == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.required;
                    }
                    return baseArray;
                }
                case 1094288952: {
                    Base[] baseArray;
                    if (this.repeats == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.repeats;
                    }
                    return baseArray;
                }
                case -867683742: {
                    Base[] baseArray;
                    if (this.readOnly == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.readOnly;
                    }
                    return baseArray;
                }
                case -791400086: {
                    Base[] baseArray;
                    if (this.maxLength == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.maxLength;
                    }
                    return baseArray;
                }
                case -743278833: {
                    Base[] baseArray;
                    if (this.answerValueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.answerValueSet;
                    }
                    return baseArray;
                }
                case -1527878189: {
                    return this.answerOption == null ? new Base[]{} : this.answerOption.toArray(new Base[this.answerOption.size()]);
                }
                case 1948342084: {
                    return this.initial == null ? new Base[]{} : this.initial.toArray(new Base[this.initial.size()]);
                }
                case 3242771: {
                    return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    this.linkId = TypeConvertor.castToString(value);
                    return value;
                }
                case -1014418093: {
                    this.definition = TypeConvertor.castToUri(value);
                    return value;
                }
                case 3059181: {
                    this.getCode().add(TypeConvertor.castToCoding(value));
                    return value;
                }
                case -980110702: {
                    this.prefix = TypeConvertor.castToString(value);
                    return value;
                }
                case 3556653: {
                    this.text = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    value = new QuestionnaireItemTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 1893321565: {
                    this.getEnableWhen().add((QuestionnaireItemEnableWhenComponent)((Object)value));
                    return value;
                }
                case 1854802165: {
                    value = new EnableWhenBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.enableBehavior = value;
                    return value;
                }
                case -393139297: {
                    this.required = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 1094288952: {
                    this.repeats = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -867683742: {
                    this.readOnly = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -791400086: {
                    this.maxLength = TypeConvertor.castToInteger(value);
                    return value;
                }
                case -743278833: {
                    this.answerValueSet = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case -1527878189: {
                    this.getAnswerOption().add((QuestionnaireItemAnswerOptionComponent)((Object)value));
                    return value;
                }
                case 1948342084: {
                    this.getInitial().add((QuestionnaireItemInitialComponent)((Object)value));
                    return value;
                }
                case 3242771: {
                    this.getItem().add((QuestionnaireItemComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("linkId")) {
                this.linkId = TypeConvertor.castToString(value);
            } else if (name.equals(Questionnaire.SP_DEFINITION)) {
                this.definition = TypeConvertor.castToUri(value);
            } else if (name.equals(Questionnaire.SP_CODE)) {
                this.getCode().add(TypeConvertor.castToCoding(value));
            } else if (name.equals("prefix")) {
                this.prefix = TypeConvertor.castToString(value);
            } else if (name.equals("text")) {
                this.text = TypeConvertor.castToString(value);
            } else if (name.equals("type")) {
                value = new QuestionnaireItemTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("enableWhen")) {
                this.getEnableWhen().add((QuestionnaireItemEnableWhenComponent)((Object)value));
            } else if (name.equals("enableBehavior")) {
                value = new EnableWhenBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.enableBehavior = value;
            } else if (name.equals("required")) {
                this.required = TypeConvertor.castToBoolean(value);
            } else if (name.equals("repeats")) {
                this.repeats = TypeConvertor.castToBoolean(value);
            } else if (name.equals("readOnly")) {
                this.readOnly = TypeConvertor.castToBoolean(value);
            } else if (name.equals("maxLength")) {
                this.maxLength = TypeConvertor.castToInteger(value);
            } else if (name.equals("answerValueSet")) {
                this.answerValueSet = TypeConvertor.castToCanonical(value);
            } else if (name.equals("answerOption")) {
                this.getAnswerOption().add((QuestionnaireItemAnswerOptionComponent)((Object)value));
            } else if (name.equals("initial")) {
                this.getInitial().add((QuestionnaireItemInitialComponent)((Object)value));
            } else if (name.equals("item")) {
                this.getItem().add((QuestionnaireItemComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    return this.getLinkIdElement();
                }
                case -1014418093: {
                    return this.getDefinitionElement();
                }
                case 3059181: {
                    return this.addCode();
                }
                case -980110702: {
                    return this.getPrefixElement();
                }
                case 3556653: {
                    return this.getTextElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 1893321565: {
                    return this.addEnableWhen();
                }
                case 1854802165: {
                    return this.getEnableBehaviorElement();
                }
                case -393139297: {
                    return this.getRequiredElement();
                }
                case 1094288952: {
                    return this.getRepeatsElement();
                }
                case -867683742: {
                    return this.getReadOnlyElement();
                }
                case -791400086: {
                    return this.getMaxLengthElement();
                }
                case -743278833: {
                    return this.getAnswerValueSetElement();
                }
                case -1527878189: {
                    return this.addAnswerOption();
                }
                case 1948342084: {
                    return this.addInitial();
                }
                case 3242771: {
                    return this.addItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    return new String[]{"string"};
                }
                case -1014418093: {
                    return new String[]{"uri"};
                }
                case 3059181: {
                    return new String[]{"Coding"};
                }
                case -980110702: {
                    return new String[]{"string"};
                }
                case 3556653: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{Questionnaire.SP_CODE};
                }
                case 1893321565: {
                    return new String[0];
                }
                case 1854802165: {
                    return new String[]{Questionnaire.SP_CODE};
                }
                case -393139297: {
                    return new String[]{"boolean"};
                }
                case 1094288952: {
                    return new String[]{"boolean"};
                }
                case -867683742: {
                    return new String[]{"boolean"};
                }
                case -791400086: {
                    return new String[]{"integer"};
                }
                case -743278833: {
                    return new String[]{"canonical"};
                }
                case -1527878189: {
                    return new String[0];
                }
                case 1948342084: {
                    return new String[0];
                }
                case 3242771: {
                    return new String[]{"@Questionnaire.item"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.item.linkId");
            }
            if (name.equals(Questionnaire.SP_DEFINITION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.item.definition");
            }
            if (name.equals(Questionnaire.SP_CODE)) {
                return this.addCode();
            }
            if (name.equals("prefix")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.item.prefix");
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.item.text");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.item.type");
            }
            if (name.equals("enableWhen")) {
                return this.addEnableWhen();
            }
            if (name.equals("enableBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.item.enableBehavior");
            }
            if (name.equals("required")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.item.required");
            }
            if (name.equals("repeats")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.item.repeats");
            }
            if (name.equals("readOnly")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.item.readOnly");
            }
            if (name.equals("maxLength")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.item.maxLength");
            }
            if (name.equals("answerValueSet")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.item.answerValueSet");
            }
            if (name.equals("answerOption")) {
                return this.addAnswerOption();
            }
            if (name.equals("initial")) {
                return this.addInitial();
            }
            if (name.equals("item")) {
                return this.addItem();
            }
            return super.addChild(name);
        }

        @Override
        public QuestionnaireItemComponent copy() {
            QuestionnaireItemComponent dst = new QuestionnaireItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(QuestionnaireItemComponent dst) {
            super.copyValues(dst);
            dst.linkId = this.linkId == null ? null : this.linkId.copy();
            UriType uriType = dst.definition = this.definition == null ? null : this.definition.copy();
            if (this.code != null) {
                dst.code = new ArrayList<Coding>();
                for (Coding coding : this.code) {
                    dst.code.add(coding.copy());
                }
            }
            dst.prefix = this.prefix == null ? null : this.prefix.copy();
            dst.text = this.text == null ? null : this.text.copy();
            Enumeration<QuestionnaireItemType> enumeration = dst.type = this.type == null ? null : this.type.copy();
            if (this.enableWhen != null) {
                dst.enableWhen = new ArrayList<QuestionnaireItemEnableWhenComponent>();
                for (QuestionnaireItemEnableWhenComponent questionnaireItemEnableWhenComponent : this.enableWhen) {
                    dst.enableWhen.add(questionnaireItemEnableWhenComponent.copy());
                }
            }
            dst.enableBehavior = this.enableBehavior == null ? null : this.enableBehavior.copy();
            dst.required = this.required == null ? null : this.required.copy();
            dst.repeats = this.repeats == null ? null : this.repeats.copy();
            dst.readOnly = this.readOnly == null ? null : this.readOnly.copy();
            dst.maxLength = this.maxLength == null ? null : this.maxLength.copy();
            CanonicalType canonicalType = dst.answerValueSet = this.answerValueSet == null ? null : this.answerValueSet.copy();
            if (this.answerOption != null) {
                dst.answerOption = new ArrayList<QuestionnaireItemAnswerOptionComponent>();
                for (QuestionnaireItemAnswerOptionComponent questionnaireItemAnswerOptionComponent : this.answerOption) {
                    dst.answerOption.add(questionnaireItemAnswerOptionComponent.copy());
                }
            }
            if (this.initial != null) {
                dst.initial = new ArrayList<QuestionnaireItemInitialComponent>();
                for (QuestionnaireItemInitialComponent questionnaireItemInitialComponent : this.initial) {
                    dst.initial.add(questionnaireItemInitialComponent.copy());
                }
            }
            if (this.item != null) {
                dst.item = new ArrayList<QuestionnaireItemComponent>();
                for (QuestionnaireItemComponent questionnaireItemComponent : this.item) {
                    dst.item.add(questionnaireItemComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof QuestionnaireItemComponent)) {
                return false;
            }
            QuestionnaireItemComponent o = (QuestionnaireItemComponent)other_;
            return QuestionnaireItemComponent.compareDeep(this.linkId, o.linkId, true) && QuestionnaireItemComponent.compareDeep(this.definition, o.definition, true) && QuestionnaireItemComponent.compareDeep(this.code, o.code, true) && QuestionnaireItemComponent.compareDeep(this.prefix, o.prefix, true) && QuestionnaireItemComponent.compareDeep(this.text, o.text, true) && QuestionnaireItemComponent.compareDeep(this.type, o.type, true) && QuestionnaireItemComponent.compareDeep(this.enableWhen, o.enableWhen, true) && QuestionnaireItemComponent.compareDeep(this.enableBehavior, o.enableBehavior, true) && QuestionnaireItemComponent.compareDeep(this.required, o.required, true) && QuestionnaireItemComponent.compareDeep(this.repeats, o.repeats, true) && QuestionnaireItemComponent.compareDeep(this.readOnly, o.readOnly, true) && QuestionnaireItemComponent.compareDeep(this.maxLength, o.maxLength, true) && QuestionnaireItemComponent.compareDeep(this.answerValueSet, o.answerValueSet, true) && QuestionnaireItemComponent.compareDeep(this.answerOption, o.answerOption, true) && QuestionnaireItemComponent.compareDeep(this.initial, o.initial, true) && QuestionnaireItemComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof QuestionnaireItemComponent)) {
                return false;
            }
            QuestionnaireItemComponent o = (QuestionnaireItemComponent)other_;
            return QuestionnaireItemComponent.compareValues(this.linkId, o.linkId, true) && QuestionnaireItemComponent.compareValues(this.definition, o.definition, true) && QuestionnaireItemComponent.compareValues(this.prefix, o.prefix, true) && QuestionnaireItemComponent.compareValues(this.text, o.text, true) && QuestionnaireItemComponent.compareValues(this.type, o.type, true) && QuestionnaireItemComponent.compareValues(this.enableBehavior, o.enableBehavior, true) && QuestionnaireItemComponent.compareValues(this.required, o.required, true) && QuestionnaireItemComponent.compareValues(this.repeats, o.repeats, true) && QuestionnaireItemComponent.compareValues(this.readOnly, o.readOnly, true) && QuestionnaireItemComponent.compareValues(this.maxLength, o.maxLength, true) && QuestionnaireItemComponent.compareValues(this.answerValueSet, o.answerValueSet, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.linkId, this.definition, this.code, this.prefix, this.text, this.type, this.enableWhen, this.enableBehavior, this.required, this.repeats, this.readOnly, this.maxLength, this.answerValueSet, this.answerOption, this.initial, this.item);
        }

        @Override
        public String fhirType() {
            return "Questionnaire.item";
        }

        public QuestionnaireItemComponent getQuestion(String linkId) {
            if (linkId == null) {
                return null;
            }
            for (QuestionnaireItemComponent i : this.getItem()) {
                if (i.getLinkId().equals(linkId)) {
                    return i;
                }
                QuestionnaireItemComponent t = i.getQuestion(linkId);
                if (t == null) continue;
                return t;
            }
            return null;
        }

        public QuestionnaireItemComponent getCommonGroup(QuestionnaireItemComponent q1, QuestionnaireItemComponent q2) {
            if (q1 == null || q2 == null) {
                return null;
            }
            for (QuestionnaireItemComponent i : this.getItem()) {
                QuestionnaireItemComponent t = i.getCommonGroup(q1, q2);
                if (t == null) continue;
                return t;
            }
            if (this.containsQuestion(q1) && this.containsQuestion(q2)) {
                return this;
            }
            return null;
        }

        public boolean containsQuestion(QuestionnaireItemComponent q) {
            if (q == this) {
                return true;
            }
            for (QuestionnaireItemComponent i : this.getItem()) {
                if (!i.containsQuestion(q)) continue;
                return true;
            }
            return false;
        }
    }

    public static class QuestionnaireItemTypeEnumFactory
    implements EnumFactory<QuestionnaireItemType> {
        @Override
        public QuestionnaireItemType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("group".equals(codeString)) {
                return QuestionnaireItemType.GROUP;
            }
            if ("display".equals(codeString)) {
                return QuestionnaireItemType.DISPLAY;
            }
            if ("question".equals(codeString)) {
                return QuestionnaireItemType.QUESTION;
            }
            if ("boolean".equals(codeString)) {
                return QuestionnaireItemType.BOOLEAN;
            }
            if ("decimal".equals(codeString)) {
                return QuestionnaireItemType.DECIMAL;
            }
            if ("integer".equals(codeString)) {
                return QuestionnaireItemType.INTEGER;
            }
            if (Questionnaire.SP_DATE.equals(codeString)) {
                return QuestionnaireItemType.DATE;
            }
            if ("dateTime".equals(codeString)) {
                return QuestionnaireItemType.DATETIME;
            }
            if ("time".equals(codeString)) {
                return QuestionnaireItemType.TIME;
            }
            if ("string".equals(codeString)) {
                return QuestionnaireItemType.STRING;
            }
            if ("text".equals(codeString)) {
                return QuestionnaireItemType.TEXT;
            }
            if (Questionnaire.SP_URL.equals(codeString)) {
                return QuestionnaireItemType.URL;
            }
            if ("choice".equals(codeString)) {
                return QuestionnaireItemType.CHOICE;
            }
            if ("open-choice".equals(codeString)) {
                return QuestionnaireItemType.OPENCHOICE;
            }
            if ("attachment".equals(codeString)) {
                return QuestionnaireItemType.ATTACHMENT;
            }
            if ("reference".equals(codeString)) {
                return QuestionnaireItemType.REFERENCE;
            }
            if ("quantity".equals(codeString)) {
                return QuestionnaireItemType.QUANTITY;
            }
            throw new IllegalArgumentException("Unknown QuestionnaireItemType code '" + codeString + "'");
        }

        public Enumeration<QuestionnaireItemType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<QuestionnaireItemType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("group".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.GROUP);
            }
            if ("display".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.DISPLAY);
            }
            if ("question".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.QUESTION);
            }
            if ("boolean".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.BOOLEAN);
            }
            if ("decimal".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.DECIMAL);
            }
            if ("integer".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.INTEGER);
            }
            if (Questionnaire.SP_DATE.equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.DATE);
            }
            if ("dateTime".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.DATETIME);
            }
            if ("time".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.TIME);
            }
            if ("string".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.STRING);
            }
            if ("text".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.TEXT);
            }
            if (Questionnaire.SP_URL.equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.URL);
            }
            if ("choice".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.CHOICE);
            }
            if ("open-choice".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.OPENCHOICE);
            }
            if ("attachment".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.ATTACHMENT);
            }
            if ("reference".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.REFERENCE);
            }
            if ("quantity".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.QUANTITY);
            }
            throw new FHIRException("Unknown QuestionnaireItemType code '" + codeString + "'");
        }

        @Override
        public String toCode(QuestionnaireItemType code) {
            if (code == QuestionnaireItemType.GROUP) {
                return "group";
            }
            if (code == QuestionnaireItemType.DISPLAY) {
                return "display";
            }
            if (code == QuestionnaireItemType.QUESTION) {
                return "question";
            }
            if (code == QuestionnaireItemType.BOOLEAN) {
                return "boolean";
            }
            if (code == QuestionnaireItemType.DECIMAL) {
                return "decimal";
            }
            if (code == QuestionnaireItemType.INTEGER) {
                return "integer";
            }
            if (code == QuestionnaireItemType.DATE) {
                return Questionnaire.SP_DATE;
            }
            if (code == QuestionnaireItemType.DATETIME) {
                return "dateTime";
            }
            if (code == QuestionnaireItemType.TIME) {
                return "time";
            }
            if (code == QuestionnaireItemType.STRING) {
                return "string";
            }
            if (code == QuestionnaireItemType.TEXT) {
                return "text";
            }
            if (code == QuestionnaireItemType.URL) {
                return Questionnaire.SP_URL;
            }
            if (code == QuestionnaireItemType.CHOICE) {
                return "choice";
            }
            if (code == QuestionnaireItemType.OPENCHOICE) {
                return "open-choice";
            }
            if (code == QuestionnaireItemType.ATTACHMENT) {
                return "attachment";
            }
            if (code == QuestionnaireItemType.REFERENCE) {
                return "reference";
            }
            if (code == QuestionnaireItemType.QUANTITY) {
                return "quantity";
            }
            return "?";
        }

        @Override
        public String toSystem(QuestionnaireItemType code) {
            return code.getSystem();
        }
    }

    public static enum QuestionnaireItemType {
        GROUP,
        DISPLAY,
        QUESTION,
        BOOLEAN,
        DECIMAL,
        INTEGER,
        DATE,
        DATETIME,
        TIME,
        STRING,
        TEXT,
        URL,
        CHOICE,
        OPENCHOICE,
        ATTACHMENT,
        REFERENCE,
        QUANTITY,
        NULL;


        public static QuestionnaireItemType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("group".equals(codeString)) {
                return GROUP;
            }
            if ("display".equals(codeString)) {
                return DISPLAY;
            }
            if ("question".equals(codeString)) {
                return QUESTION;
            }
            if ("boolean".equals(codeString)) {
                return BOOLEAN;
            }
            if ("decimal".equals(codeString)) {
                return DECIMAL;
            }
            if ("integer".equals(codeString)) {
                return INTEGER;
            }
            if (Questionnaire.SP_DATE.equals(codeString)) {
                return DATE;
            }
            if ("dateTime".equals(codeString)) {
                return DATETIME;
            }
            if ("time".equals(codeString)) {
                return TIME;
            }
            if ("string".equals(codeString)) {
                return STRING;
            }
            if ("text".equals(codeString)) {
                return TEXT;
            }
            if (Questionnaire.SP_URL.equals(codeString)) {
                return URL;
            }
            if ("choice".equals(codeString)) {
                return CHOICE;
            }
            if ("open-choice".equals(codeString)) {
                return OPENCHOICE;
            }
            if ("attachment".equals(codeString)) {
                return ATTACHMENT;
            }
            if ("reference".equals(codeString)) {
                return REFERENCE;
            }
            if ("quantity".equals(codeString)) {
                return QUANTITY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown QuestionnaireItemType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case GROUP: {
                    return "group";
                }
                case DISPLAY: {
                    return "display";
                }
                case QUESTION: {
                    return "question";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case DECIMAL: {
                    return "decimal";
                }
                case INTEGER: {
                    return "integer";
                }
                case DATE: {
                    return Questionnaire.SP_DATE;
                }
                case DATETIME: {
                    return "dateTime";
                }
                case TIME: {
                    return "time";
                }
                case STRING: {
                    return "string";
                }
                case TEXT: {
                    return "text";
                }
                case URL: {
                    return Questionnaire.SP_URL;
                }
                case CHOICE: {
                    return "choice";
                }
                case OPENCHOICE: {
                    return "open-choice";
                }
                case ATTACHMENT: {
                    return "attachment";
                }
                case REFERENCE: {
                    return "reference";
                }
                case QUANTITY: {
                    return "quantity";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case GROUP: {
                    return "http://hl7.org/fhir/item-type";
                }
                case DISPLAY: {
                    return "http://hl7.org/fhir/item-type";
                }
                case QUESTION: {
                    return "http://hl7.org/fhir/item-type";
                }
                case BOOLEAN: {
                    return "http://hl7.org/fhir/item-type";
                }
                case DECIMAL: {
                    return "http://hl7.org/fhir/item-type";
                }
                case INTEGER: {
                    return "http://hl7.org/fhir/item-type";
                }
                case DATE: {
                    return "http://hl7.org/fhir/item-type";
                }
                case DATETIME: {
                    return "http://hl7.org/fhir/item-type";
                }
                case TIME: {
                    return "http://hl7.org/fhir/item-type";
                }
                case STRING: {
                    return "http://hl7.org/fhir/item-type";
                }
                case TEXT: {
                    return "http://hl7.org/fhir/item-type";
                }
                case URL: {
                    return "http://hl7.org/fhir/item-type";
                }
                case CHOICE: {
                    return "http://hl7.org/fhir/item-type";
                }
                case OPENCHOICE: {
                    return "http://hl7.org/fhir/item-type";
                }
                case ATTACHMENT: {
                    return "http://hl7.org/fhir/item-type";
                }
                case REFERENCE: {
                    return "http://hl7.org/fhir/item-type";
                }
                case QUANTITY: {
                    return "http://hl7.org/fhir/item-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case GROUP: {
                    return "An item with no direct answer but should have at least one child item.";
                }
                case DISPLAY: {
                    return "Text for display that will not capture an answer or have child items.";
                }
                case QUESTION: {
                    return "An item that defines a specific answer to be captured, and which may have child items. (the answer provided in the QuestionnaireResponse should be of the defined datatype).";
                }
                case BOOLEAN: {
                    return "Question with a yes/no answer (valueBoolean).";
                }
                case DECIMAL: {
                    return "Question with is a real number answer (valueDecimal).";
                }
                case INTEGER: {
                    return "Question with an integer answer (valueInteger).";
                }
                case DATE: {
                    return "Question with a date answer (valueDate).";
                }
                case DATETIME: {
                    return "Question with a date and time answer (valueDateTime).";
                }
                case TIME: {
                    return "Question with a time (hour:minute:second) answer independent of date. (valueTime).";
                }
                case STRING: {
                    return "Question with a short (few words to short sentence) free-text entry answer (valueString).";
                }
                case TEXT: {
                    return "Question with a long (potentially multi-paragraph) free-text entry answer (valueString).";
                }
                case URL: {
                    return "Question with a URL (website, FTP site, etc.) answer (valueUri).";
                }
                case CHOICE: {
                    return "Question with a Coding drawn from a list of possible answers (specified in either the answerOption property, or via the valueset referenced in the answerValueSet property) as an answer (valueCoding).";
                }
                case OPENCHOICE: {
                    return "Answer is a Coding drawn from a list of possible answers (as with the choice type) or a free-text entry in a string (valueCoding or valueString).";
                }
                case ATTACHMENT: {
                    return "Question with binary content such as an image, PDF, etc. as an answer (valueAttachment).";
                }
                case REFERENCE: {
                    return "Question with a reference to another resource (practitioner, organization, etc.) as an answer (valueReference).";
                }
                case QUANTITY: {
                    return "Question with a combination of a numeric value and unit, potentially with a comparator (<, >, etc.) as an answer. (valueQuantity) There is an extension 'http://hl7.org/fhir/StructureDefinition/questionnaire-unit' that can be used to define what unit should be captured (or the unit that has a ucum conversion from the provided unit).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case GROUP: {
                    return "Group";
                }
                case DISPLAY: {
                    return "Display";
                }
                case QUESTION: {
                    return "Question";
                }
                case BOOLEAN: {
                    return "Boolean";
                }
                case DECIMAL: {
                    return "Decimal";
                }
                case INTEGER: {
                    return "Integer";
                }
                case DATE: {
                    return "Date";
                }
                case DATETIME: {
                    return "Date Time";
                }
                case TIME: {
                    return "Time";
                }
                case STRING: {
                    return "String";
                }
                case TEXT: {
                    return "Text";
                }
                case URL: {
                    return "Url";
                }
                case CHOICE: {
                    return "Choice";
                }
                case OPENCHOICE: {
                    return "Open Choice";
                }
                case ATTACHMENT: {
                    return "Attachment";
                }
                case REFERENCE: {
                    return "Reference";
                }
                case QUANTITY: {
                    return "Quantity";
                }
            }
            return "?";
        }
    }

    public static class QuestionnaireItemOperatorEnumFactory
    implements EnumFactory<QuestionnaireItemOperator> {
        @Override
        public QuestionnaireItemOperator fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("exists".equals(codeString)) {
                return QuestionnaireItemOperator.EXISTS;
            }
            if ("=".equals(codeString)) {
                return QuestionnaireItemOperator.EQUAL;
            }
            if ("!=".equals(codeString)) {
                return QuestionnaireItemOperator.NOT_EQUAL;
            }
            if (">".equals(codeString)) {
                return QuestionnaireItemOperator.GREATER_THAN;
            }
            if ("<".equals(codeString)) {
                return QuestionnaireItemOperator.LESS_THAN;
            }
            if (">=".equals(codeString)) {
                return QuestionnaireItemOperator.GREATER_OR_EQUAL;
            }
            if ("<=".equals(codeString)) {
                return QuestionnaireItemOperator.LESS_OR_EQUAL;
            }
            throw new IllegalArgumentException("Unknown QuestionnaireItemOperator code '" + codeString + "'");
        }

        public Enumeration<QuestionnaireItemOperator> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<QuestionnaireItemOperator>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("exists".equals(codeString)) {
                return new Enumeration<QuestionnaireItemOperator>(this, QuestionnaireItemOperator.EXISTS);
            }
            if ("=".equals(codeString)) {
                return new Enumeration<QuestionnaireItemOperator>(this, QuestionnaireItemOperator.EQUAL);
            }
            if ("!=".equals(codeString)) {
                return new Enumeration<QuestionnaireItemOperator>(this, QuestionnaireItemOperator.NOT_EQUAL);
            }
            if (">".equals(codeString)) {
                return new Enumeration<QuestionnaireItemOperator>(this, QuestionnaireItemOperator.GREATER_THAN);
            }
            if ("<".equals(codeString)) {
                return new Enumeration<QuestionnaireItemOperator>(this, QuestionnaireItemOperator.LESS_THAN);
            }
            if (">=".equals(codeString)) {
                return new Enumeration<QuestionnaireItemOperator>(this, QuestionnaireItemOperator.GREATER_OR_EQUAL);
            }
            if ("<=".equals(codeString)) {
                return new Enumeration<QuestionnaireItemOperator>(this, QuestionnaireItemOperator.LESS_OR_EQUAL);
            }
            throw new FHIRException("Unknown QuestionnaireItemOperator code '" + codeString + "'");
        }

        @Override
        public String toCode(QuestionnaireItemOperator code) {
            if (code == QuestionnaireItemOperator.EXISTS) {
                return "exists";
            }
            if (code == QuestionnaireItemOperator.EQUAL) {
                return "=";
            }
            if (code == QuestionnaireItemOperator.NOT_EQUAL) {
                return "!=";
            }
            if (code == QuestionnaireItemOperator.GREATER_THAN) {
                return ">";
            }
            if (code == QuestionnaireItemOperator.LESS_THAN) {
                return "<";
            }
            if (code == QuestionnaireItemOperator.GREATER_OR_EQUAL) {
                return ">=";
            }
            if (code == QuestionnaireItemOperator.LESS_OR_EQUAL) {
                return "<=";
            }
            return "?";
        }

        @Override
        public String toSystem(QuestionnaireItemOperator code) {
            return code.getSystem();
        }
    }

    public static enum QuestionnaireItemOperator {
        EXISTS,
        EQUAL,
        NOT_EQUAL,
        GREATER_THAN,
        LESS_THAN,
        GREATER_OR_EQUAL,
        LESS_OR_EQUAL,
        NULL;


        public static QuestionnaireItemOperator fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("exists".equals(codeString)) {
                return EXISTS;
            }
            if ("=".equals(codeString)) {
                return EQUAL;
            }
            if ("!=".equals(codeString)) {
                return NOT_EQUAL;
            }
            if (">".equals(codeString)) {
                return GREATER_THAN;
            }
            if ("<".equals(codeString)) {
                return LESS_THAN;
            }
            if (">=".equals(codeString)) {
                return GREATER_OR_EQUAL;
            }
            if ("<=".equals(codeString)) {
                return LESS_OR_EQUAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown QuestionnaireItemOperator code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EXISTS: {
                    return "exists";
                }
                case EQUAL: {
                    return "=";
                }
                case NOT_EQUAL: {
                    return "!=";
                }
                case GREATER_THAN: {
                    return ">";
                }
                case LESS_THAN: {
                    return "<";
                }
                case GREATER_OR_EQUAL: {
                    return ">=";
                }
                case LESS_OR_EQUAL: {
                    return "<=";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EXISTS: {
                    return "http://hl7.org/fhir/questionnaire-enable-operator";
                }
                case EQUAL: {
                    return "http://hl7.org/fhir/questionnaire-enable-operator";
                }
                case NOT_EQUAL: {
                    return "http://hl7.org/fhir/questionnaire-enable-operator";
                }
                case GREATER_THAN: {
                    return "http://hl7.org/fhir/questionnaire-enable-operator";
                }
                case LESS_THAN: {
                    return "http://hl7.org/fhir/questionnaire-enable-operator";
                }
                case GREATER_OR_EQUAL: {
                    return "http://hl7.org/fhir/questionnaire-enable-operator";
                }
                case LESS_OR_EQUAL: {
                    return "http://hl7.org/fhir/questionnaire-enable-operator";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EXISTS: {
                    return "True if whether an answer exists is equal to the enableWhen answer (which must be a boolean).";
                }
                case EQUAL: {
                    return "True if whether at least one answer has a value that is equal to the enableWhen answer.";
                }
                case NOT_EQUAL: {
                    return "True if whether at least no answer has a value that is equal to the enableWhen answer.";
                }
                case GREATER_THAN: {
                    return "True if whether at least no answer has a value that is greater than the enableWhen answer.";
                }
                case LESS_THAN: {
                    return "True if whether at least no answer has a value that is less than the enableWhen answer.";
                }
                case GREATER_OR_EQUAL: {
                    return "True if whether at least no answer has a value that is greater or equal to the enableWhen answer.";
                }
                case LESS_OR_EQUAL: {
                    return "True if whether at least no answer has a value that is less or equal to the enableWhen answer.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EXISTS: {
                    return "Exists";
                }
                case EQUAL: {
                    return "Equals";
                }
                case NOT_EQUAL: {
                    return "Not Equals";
                }
                case GREATER_THAN: {
                    return "Greater Than";
                }
                case LESS_THAN: {
                    return "Less Than";
                }
                case GREATER_OR_EQUAL: {
                    return "Greater or Equals";
                }
                case LESS_OR_EQUAL: {
                    return "Less or Equals";
                }
            }
            return "?";
        }
    }

    public static class EnableWhenBehaviorEnumFactory
    implements EnumFactory<EnableWhenBehavior> {
        @Override
        public EnableWhenBehavior fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("all".equals(codeString)) {
                return EnableWhenBehavior.ALL;
            }
            if ("any".equals(codeString)) {
                return EnableWhenBehavior.ANY;
            }
            throw new IllegalArgumentException("Unknown EnableWhenBehavior code '" + codeString + "'");
        }

        public Enumeration<EnableWhenBehavior> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EnableWhenBehavior>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("all".equals(codeString)) {
                return new Enumeration<EnableWhenBehavior>(this, EnableWhenBehavior.ALL);
            }
            if ("any".equals(codeString)) {
                return new Enumeration<EnableWhenBehavior>(this, EnableWhenBehavior.ANY);
            }
            throw new FHIRException("Unknown EnableWhenBehavior code '" + codeString + "'");
        }

        @Override
        public String toCode(EnableWhenBehavior code) {
            if (code == EnableWhenBehavior.ALL) {
                return "all";
            }
            if (code == EnableWhenBehavior.ANY) {
                return "any";
            }
            return "?";
        }

        @Override
        public String toSystem(EnableWhenBehavior code) {
            return code.getSystem();
        }
    }

    public static enum EnableWhenBehavior {
        ALL,
        ANY,
        NULL;


        public static EnableWhenBehavior fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("all".equals(codeString)) {
                return ALL;
            }
            if ("any".equals(codeString)) {
                return ANY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EnableWhenBehavior code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ALL: {
                    return "all";
                }
                case ANY: {
                    return "any";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ALL: {
                    return "http://hl7.org/fhir/questionnaire-enable-behavior";
                }
                case ANY: {
                    return "http://hl7.org/fhir/questionnaire-enable-behavior";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ALL: {
                    return "Enable the question when all the enableWhen criteria are satisfied.";
                }
                case ANY: {
                    return "Enable the question when any of the enableWhen criteria are satisfied.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ALL: {
                    return "All";
                }
                case ANY: {
                    return "Any";
                }
            }
            return "?";
        }
    }
}

