/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MarketingStatus;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicinalProductDefinition", profile="http://hl7.org/fhir/StructureDefinition/MedicinalProductDefinition")
public class MedicinalProductDefinition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for this product. Could be an MPID", formalDefinition="Business identifier for this product. Could be an MPID.")
    protected List<Identifier> identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Regulatory type, e.g. Investigational or Authorized", formalDefinition="Regulatory type, e.g. Investigational or Authorized.")
    protected CodeableConcept type;
    @Child(name="domain", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If this medicine applies to human or veterinary uses", formalDefinition="If this medicine applies to human or veterinary uses.")
    protected CodeableConcept domain;
    @Child(name="version", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A business level identifier of the product", formalDefinition="A business level identifier of the product.")
    protected StringType version;
    @Child(name="status", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The status within the lifecycle of this product. A high level status, this is not intended to duplicate details carried elswhere such as legal status, or authorization status", formalDefinition="The status within the lifecycle of this product. A high level status, this is not intended to duplicate details carried elswhere such as legal status, or authorization status.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected CodeableConcept status;
    @Child(name="statusDate", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date at which the given status became applicable", formalDefinition="The date at which the given status became applicable.")
    protected DateTimeType statusDate;
    @Child(name="description", type={MarkdownType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="General description of this product", formalDefinition="General description of this product.")
    protected MarkdownType description;
    @Child(name="combinedPharmaceuticalDoseForm", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The dose form for a single part product, or combined form of a multiple part product", formalDefinition="The dose form for a single part product, or combined form of a multiple part product.")
    protected CodeableConcept combinedPharmaceuticalDoseForm;
    @Child(name="indication", type={MarkdownType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="General combined description of indication(s) for this product. See also MedicinalProductDefinitionIndication", formalDefinition="General combined description of indication(s) for this product. See also MedicinalProductDefinitionIndication.")
    protected MarkdownType indication;
    @Child(name="legalStatusOfSupply", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The legal status of supply of the medicinal product as classified by the regulator", formalDefinition="The legal status of supply of the medicinal product as classified by the regulator.")
    protected CodeableConcept legalStatusOfSupply;
    @Child(name="additionalMonitoringIndicator", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the Medicinal Product is subject to additional monitoring for regulatory reasons", formalDefinition="Whether the Medicinal Product is subject to additional monitoring for regulatory reasons.")
    protected CodeableConcept additionalMonitoringIndicator;
    @Child(name="specialMeasures", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the Medicinal Product is subject to special measures for regulatory reasons", formalDefinition="Whether the Medicinal Product is subject to special measures for regulatory reasons.")
    protected List<CodeableConcept> specialMeasures;
    @Child(name="paediatricUseIndicator", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If authorised for use in children", formalDefinition="If authorised for use in children.")
    protected CodeableConcept paediatricUseIndicator;
    @Child(name="productClassification", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Allows the product to be classified by various systems", formalDefinition="Allows the product to be classified by various systems.")
    protected List<CodeableConcept> productClassification;
    @Child(name="characteristic", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Allows the key product features to be recorded, such as \"suger free\", \"modified release\", \"parallel import\"", formalDefinition="Allows the key product features to be recorded, such as \"suger free\", \"modified release\", \"parallel import\".")
    protected List<CodeableConcept> characteristic;
    @Child(name="marketingStatus", type={MarketingStatus.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Marketing status of the medicinal product, in contrast to marketing authorizaton", formalDefinition="Marketing status of the medicinal product, in contrast to marketing authorizaton.")
    protected List<MarketingStatus> marketingStatus;
    @Child(name="pharmaceuticalProduct", type={AdministrableProductDefinition.class}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Pharmaceutical aspects of product", formalDefinition="Pharmaceutical aspects of product.")
    protected List<Reference> pharmaceuticalProduct;
    @Child(name="packagedMedicinalProduct", type={PackagedProductDefinition.class}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Package representation for the product", formalDefinition="Package representation for the product.")
    protected List<Reference> packagedMedicinalProduct;
    @Child(name="ingredient", type={Ingredient.class}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The ingredients of this medicinal product - when not specified elsewhere. This is only needed if the ingredients are not specified by the pharmaceuticalProduct or packagedMedicinalProduct references above. In cases where those levels of detail are not used, the ingredients may be specified directly here", formalDefinition="The ingredients of this medicinal product - when not specified elsewhere. This is only needed if the ingredients are not specified by the pharmaceuticalProduct or packagedMedicinalProduct references above. In cases where those levels of detail are not used, the ingredients may be specified directly here.")
    protected List<Reference> ingredient;
    @Child(name="attachedDocument", type={DocumentReference.class}, order=19, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Supporting documentation, typically for regulatory submission", formalDefinition="Supporting documentation, typically for regulatory submission.")
    protected List<Reference> attachedDocument;
    @Child(name="masterFile", type={DocumentReference.class}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A master file for to the medicinal product (e.g. Pharmacovigilance System Master File)", formalDefinition="A master file for to the medicinal product (e.g. Pharmacovigilance System Master File).")
    protected List<Reference> masterFile;
    @Child(name="contact", type={}, order=21, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A product specific contact, person (in a role), or an organization", formalDefinition="A product specific contact, person (in a role), or an organization.")
    protected List<MedicinalProductDefinitionContactComponent> contact;
    @Child(name="clinicalTrial", type={ResearchStudy.class}, order=22, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Clinical trials or studies that this product is involved in", formalDefinition="Clinical trials or studies that this product is involved in.")
    protected List<Reference> clinicalTrial;
    @Child(name="name", type={}, order=23, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The product's name, including full name and possibly coded parts", formalDefinition="The product's name, including full name and possibly coded parts.")
    protected List<MedicinalProductDefinitionNameComponent> name;
    @Child(name="crossReference", type={}, order=24, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to another product, e.g. for linking authorised to investigational product", formalDefinition="Reference to another product, e.g. for linking authorised to investigational product.")
    protected List<MedicinalProductDefinitionCrossReferenceComponent> crossReference;
    @Child(name="manufacturingBusinessOperation", type={}, order=25, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An operation applied to the product, for manufacturing or adminsitrative purpose", formalDefinition="An operation applied to the product, for manufacturing or adminsitrative purpose.")
    protected List<MedicinalProductDefinitionManufacturingBusinessOperationComponent> manufacturingBusinessOperation;
    private static final long serialVersionUID = -585909008L;
    @SearchParamDefinition(name="characteristic", path="MedicinalProductDefinition.characteristic", description="Allows the key product features to be recorded, such as \"suger free\", \"modified release\", \"parallel import\"", type="token")
    public static final String SP_CHARACTERISTIC = "characteristic";
    public static final TokenClientParam CHARACTERISTIC = new TokenClientParam("characteristic");
    @SearchParamDefinition(name="contact", path="MedicinalProductDefinition.contact.contact", description="A product specific contact, person (in a role), or an organization", type="reference", target={Organization.class, PractitionerRole.class})
    public static final String SP_CONTACT = "contact";
    public static final ReferenceClientParam CONTACT = new ReferenceClientParam("contact");
    public static final Include INCLUDE_CONTACT = new Include("MedicinalProductDefinition:contact").toLocked();
    @SearchParamDefinition(name="domain", path="MedicinalProductDefinition.domain", description="If this medicine applies to human or veterinary uses", type="token")
    public static final String SP_DOMAIN = "domain";
    public static final TokenClientParam DOMAIN = new TokenClientParam("domain");
    @SearchParamDefinition(name="identifier", path="MedicinalProductDefinition.identifier", description="Business identifier for this product. Could be an MPID", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="master-file", path="MedicinalProductDefinition.masterFile", description="A master file for to the medicinal product (e.g. Pharmacovigilance System Master File)", type="reference", target={DocumentReference.class})
    public static final String SP_MASTER_FILE = "master-file";
    public static final ReferenceClientParam MASTER_FILE = new ReferenceClientParam("master-file");
    public static final Include INCLUDE_MASTER_FILE = new Include("MedicinalProductDefinition:master-file").toLocked();
    @SearchParamDefinition(name="name-language", path="MedicinalProductDefinition.name.countryLanguage.language", description="Language code for this name", type="token")
    public static final String SP_NAME_LANGUAGE = "name-language";
    public static final TokenClientParam NAME_LANGUAGE = new TokenClientParam("name-language");
    @SearchParamDefinition(name="name", path="MedicinalProductDefinition.name.productName", description="The full product name", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="product-classification", path="MedicinalProductDefinition.productClassification", description="Allows the product to be classified by various systems", type="token")
    public static final String SP_PRODUCT_CLASSIFICATION = "product-classification";
    public static final TokenClientParam PRODUCT_CLASSIFICATION = new TokenClientParam("product-classification");
    @SearchParamDefinition(name="status", path="MedicinalProductDefinition.status", description="The status within the lifecycle of this product. A high level status, this is not intended to duplicate details carried elswhere such as legal status, or authorization status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="type", path="MedicinalProductDefinition.type", description="Regulatory type, e.g. Investigational or Authorized", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public MedicinalProductDefinition() {
    }

    public MedicinalProductDefinition(MedicinalProductDefinitionNameComponent name) {
        this.addName(name);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicinalProductDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicinalProductDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public MedicinalProductDefinition setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getDomain() {
        if (this.domain == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.domain");
            }
            if (Configuration.doAutoCreate()) {
                this.domain = new CodeableConcept();
            }
        }
        return this.domain;
    }

    public boolean hasDomain() {
        return this.domain != null && !this.domain.isEmpty();
    }

    public MedicinalProductDefinition setDomain(CodeableConcept value) {
        this.domain = value;
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public MedicinalProductDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public MedicinalProductDefinition setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public CodeableConcept getStatus() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeableConcept();
            }
        }
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicinalProductDefinition setStatus(CodeableConcept value) {
        this.status = value;
        return this;
    }

    public DateTimeType getStatusDateElement() {
        if (this.statusDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.statusDate");
            }
            if (Configuration.doAutoCreate()) {
                this.statusDate = new DateTimeType();
            }
        }
        return this.statusDate;
    }

    public boolean hasStatusDateElement() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public boolean hasStatusDate() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public MedicinalProductDefinition setStatusDateElement(DateTimeType value) {
        this.statusDate = value;
        return this;
    }

    public Date getStatusDate() {
        return this.statusDate == null ? null : (Date)this.statusDate.getValue();
    }

    public MedicinalProductDefinition setStatusDate(Date value) {
        if (value == null) {
            this.statusDate = null;
        } else {
            if (this.statusDate == null) {
                this.statusDate = new DateTimeType();
            }
            this.statusDate.setValue(value);
        }
        return this;
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public MedicinalProductDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public MedicinalProductDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public CodeableConcept getCombinedPharmaceuticalDoseForm() {
        if (this.combinedPharmaceuticalDoseForm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.combinedPharmaceuticalDoseForm");
            }
            if (Configuration.doAutoCreate()) {
                this.combinedPharmaceuticalDoseForm = new CodeableConcept();
            }
        }
        return this.combinedPharmaceuticalDoseForm;
    }

    public boolean hasCombinedPharmaceuticalDoseForm() {
        return this.combinedPharmaceuticalDoseForm != null && !this.combinedPharmaceuticalDoseForm.isEmpty();
    }

    public MedicinalProductDefinition setCombinedPharmaceuticalDoseForm(CodeableConcept value) {
        this.combinedPharmaceuticalDoseForm = value;
        return this;
    }

    public MarkdownType getIndicationElement() {
        if (this.indication == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.indication");
            }
            if (Configuration.doAutoCreate()) {
                this.indication = new MarkdownType();
            }
        }
        return this.indication;
    }

    public boolean hasIndicationElement() {
        return this.indication != null && !this.indication.isEmpty();
    }

    public boolean hasIndication() {
        return this.indication != null && !this.indication.isEmpty();
    }

    public MedicinalProductDefinition setIndicationElement(MarkdownType value) {
        this.indication = value;
        return this;
    }

    public String getIndication() {
        return this.indication == null ? null : (String)this.indication.getValue();
    }

    public MedicinalProductDefinition setIndication(String value) {
        if (value == null) {
            this.indication = null;
        } else {
            if (this.indication == null) {
                this.indication = new MarkdownType();
            }
            this.indication.setValue(value);
        }
        return this;
    }

    public CodeableConcept getLegalStatusOfSupply() {
        if (this.legalStatusOfSupply == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.legalStatusOfSupply");
            }
            if (Configuration.doAutoCreate()) {
                this.legalStatusOfSupply = new CodeableConcept();
            }
        }
        return this.legalStatusOfSupply;
    }

    public boolean hasLegalStatusOfSupply() {
        return this.legalStatusOfSupply != null && !this.legalStatusOfSupply.isEmpty();
    }

    public MedicinalProductDefinition setLegalStatusOfSupply(CodeableConcept value) {
        this.legalStatusOfSupply = value;
        return this;
    }

    public CodeableConcept getAdditionalMonitoringIndicator() {
        if (this.additionalMonitoringIndicator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.additionalMonitoringIndicator");
            }
            if (Configuration.doAutoCreate()) {
                this.additionalMonitoringIndicator = new CodeableConcept();
            }
        }
        return this.additionalMonitoringIndicator;
    }

    public boolean hasAdditionalMonitoringIndicator() {
        return this.additionalMonitoringIndicator != null && !this.additionalMonitoringIndicator.isEmpty();
    }

    public MedicinalProductDefinition setAdditionalMonitoringIndicator(CodeableConcept value) {
        this.additionalMonitoringIndicator = value;
        return this;
    }

    public List<CodeableConcept> getSpecialMeasures() {
        if (this.specialMeasures == null) {
            this.specialMeasures = new ArrayList<CodeableConcept>();
        }
        return this.specialMeasures;
    }

    public MedicinalProductDefinition setSpecialMeasures(List<CodeableConcept> theSpecialMeasures) {
        this.specialMeasures = theSpecialMeasures;
        return this;
    }

    public boolean hasSpecialMeasures() {
        if (this.specialMeasures == null) {
            return false;
        }
        for (CodeableConcept item : this.specialMeasures) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialMeasures() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialMeasures == null) {
            this.specialMeasures = new ArrayList<CodeableConcept>();
        }
        this.specialMeasures.add(t);
        return t;
    }

    public MedicinalProductDefinition addSpecialMeasures(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialMeasures == null) {
            this.specialMeasures = new ArrayList<CodeableConcept>();
        }
        this.specialMeasures.add(t);
        return this;
    }

    public CodeableConcept getSpecialMeasuresFirstRep() {
        if (this.getSpecialMeasures().isEmpty()) {
            this.addSpecialMeasures();
        }
        return this.getSpecialMeasures().get(0);
    }

    public CodeableConcept getPaediatricUseIndicator() {
        if (this.paediatricUseIndicator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.paediatricUseIndicator");
            }
            if (Configuration.doAutoCreate()) {
                this.paediatricUseIndicator = new CodeableConcept();
            }
        }
        return this.paediatricUseIndicator;
    }

    public boolean hasPaediatricUseIndicator() {
        return this.paediatricUseIndicator != null && !this.paediatricUseIndicator.isEmpty();
    }

    public MedicinalProductDefinition setPaediatricUseIndicator(CodeableConcept value) {
        this.paediatricUseIndicator = value;
        return this;
    }

    public List<CodeableConcept> getProductClassification() {
        if (this.productClassification == null) {
            this.productClassification = new ArrayList<CodeableConcept>();
        }
        return this.productClassification;
    }

    public MedicinalProductDefinition setProductClassification(List<CodeableConcept> theProductClassification) {
        this.productClassification = theProductClassification;
        return this;
    }

    public boolean hasProductClassification() {
        if (this.productClassification == null) {
            return false;
        }
        for (CodeableConcept item : this.productClassification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addProductClassification() {
        CodeableConcept t = new CodeableConcept();
        if (this.productClassification == null) {
            this.productClassification = new ArrayList<CodeableConcept>();
        }
        this.productClassification.add(t);
        return t;
    }

    public MedicinalProductDefinition addProductClassification(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.productClassification == null) {
            this.productClassification = new ArrayList<CodeableConcept>();
        }
        this.productClassification.add(t);
        return this;
    }

    public CodeableConcept getProductClassificationFirstRep() {
        if (this.getProductClassification().isEmpty()) {
            this.addProductClassification();
        }
        return this.getProductClassification().get(0);
    }

    public List<CodeableConcept> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        return this.characteristic;
    }

    public MedicinalProductDefinition setCharacteristic(List<CodeableConcept> theCharacteristic) {
        this.characteristic = theCharacteristic;
        return this;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (CodeableConcept item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCharacteristic() {
        CodeableConcept t = new CodeableConcept();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        this.characteristic.add(t);
        return t;
    }

    public MedicinalProductDefinition addCharacteristic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        this.characteristic.add(t);
        return this;
    }

    public CodeableConcept getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    public List<MarketingStatus> getMarketingStatus() {
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        return this.marketingStatus;
    }

    public MedicinalProductDefinition setMarketingStatus(List<MarketingStatus> theMarketingStatus) {
        this.marketingStatus = theMarketingStatus;
        return this;
    }

    public boolean hasMarketingStatus() {
        if (this.marketingStatus == null) {
            return false;
        }
        for (MarketingStatus item : this.marketingStatus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MarketingStatus addMarketingStatus() {
        MarketingStatus t = new MarketingStatus();
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return t;
    }

    public MedicinalProductDefinition addMarketingStatus(MarketingStatus t) {
        if (t == null) {
            return this;
        }
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return this;
    }

    public MarketingStatus getMarketingStatusFirstRep() {
        if (this.getMarketingStatus().isEmpty()) {
            this.addMarketingStatus();
        }
        return this.getMarketingStatus().get(0);
    }

    public List<Reference> getPharmaceuticalProduct() {
        if (this.pharmaceuticalProduct == null) {
            this.pharmaceuticalProduct = new ArrayList<Reference>();
        }
        return this.pharmaceuticalProduct;
    }

    public MedicinalProductDefinition setPharmaceuticalProduct(List<Reference> thePharmaceuticalProduct) {
        this.pharmaceuticalProduct = thePharmaceuticalProduct;
        return this;
    }

    public boolean hasPharmaceuticalProduct() {
        if (this.pharmaceuticalProduct == null) {
            return false;
        }
        for (Reference item : this.pharmaceuticalProduct) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPharmaceuticalProduct() {
        Reference t = new Reference();
        if (this.pharmaceuticalProduct == null) {
            this.pharmaceuticalProduct = new ArrayList<Reference>();
        }
        this.pharmaceuticalProduct.add(t);
        return t;
    }

    public MedicinalProductDefinition addPharmaceuticalProduct(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.pharmaceuticalProduct == null) {
            this.pharmaceuticalProduct = new ArrayList<Reference>();
        }
        this.pharmaceuticalProduct.add(t);
        return this;
    }

    public Reference getPharmaceuticalProductFirstRep() {
        if (this.getPharmaceuticalProduct().isEmpty()) {
            this.addPharmaceuticalProduct();
        }
        return this.getPharmaceuticalProduct().get(0);
    }

    public List<Reference> getPackagedMedicinalProduct() {
        if (this.packagedMedicinalProduct == null) {
            this.packagedMedicinalProduct = new ArrayList<Reference>();
        }
        return this.packagedMedicinalProduct;
    }

    public MedicinalProductDefinition setPackagedMedicinalProduct(List<Reference> thePackagedMedicinalProduct) {
        this.packagedMedicinalProduct = thePackagedMedicinalProduct;
        return this;
    }

    public boolean hasPackagedMedicinalProduct() {
        if (this.packagedMedicinalProduct == null) {
            return false;
        }
        for (Reference item : this.packagedMedicinalProduct) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPackagedMedicinalProduct() {
        Reference t = new Reference();
        if (this.packagedMedicinalProduct == null) {
            this.packagedMedicinalProduct = new ArrayList<Reference>();
        }
        this.packagedMedicinalProduct.add(t);
        return t;
    }

    public MedicinalProductDefinition addPackagedMedicinalProduct(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.packagedMedicinalProduct == null) {
            this.packagedMedicinalProduct = new ArrayList<Reference>();
        }
        this.packagedMedicinalProduct.add(t);
        return this;
    }

    public Reference getPackagedMedicinalProductFirstRep() {
        if (this.getPackagedMedicinalProduct().isEmpty()) {
            this.addPackagedMedicinalProduct();
        }
        return this.getPackagedMedicinalProduct().get(0);
    }

    public List<Reference> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        return this.ingredient;
    }

    public MedicinalProductDefinition setIngredient(List<Reference> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (Reference item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addIngredient() {
        Reference t = new Reference();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        this.ingredient.add(t);
        return t;
    }

    public MedicinalProductDefinition addIngredient(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        this.ingredient.add(t);
        return this;
    }

    public Reference getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public List<Reference> getAttachedDocument() {
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        return this.attachedDocument;
    }

    public MedicinalProductDefinition setAttachedDocument(List<Reference> theAttachedDocument) {
        this.attachedDocument = theAttachedDocument;
        return this;
    }

    public boolean hasAttachedDocument() {
        if (this.attachedDocument == null) {
            return false;
        }
        for (Reference item : this.attachedDocument) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAttachedDocument() {
        Reference t = new Reference();
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        this.attachedDocument.add(t);
        return t;
    }

    public MedicinalProductDefinition addAttachedDocument(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        this.attachedDocument.add(t);
        return this;
    }

    public Reference getAttachedDocumentFirstRep() {
        if (this.getAttachedDocument().isEmpty()) {
            this.addAttachedDocument();
        }
        return this.getAttachedDocument().get(0);
    }

    public List<Reference> getMasterFile() {
        if (this.masterFile == null) {
            this.masterFile = new ArrayList<Reference>();
        }
        return this.masterFile;
    }

    public MedicinalProductDefinition setMasterFile(List<Reference> theMasterFile) {
        this.masterFile = theMasterFile;
        return this;
    }

    public boolean hasMasterFile() {
        if (this.masterFile == null) {
            return false;
        }
        for (Reference item : this.masterFile) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addMasterFile() {
        Reference t = new Reference();
        if (this.masterFile == null) {
            this.masterFile = new ArrayList<Reference>();
        }
        this.masterFile.add(t);
        return t;
    }

    public MedicinalProductDefinition addMasterFile(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.masterFile == null) {
            this.masterFile = new ArrayList<Reference>();
        }
        this.masterFile.add(t);
        return this;
    }

    public Reference getMasterFileFirstRep() {
        if (this.getMasterFile().isEmpty()) {
            this.addMasterFile();
        }
        return this.getMasterFile().get(0);
    }

    public List<MedicinalProductDefinitionContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<MedicinalProductDefinitionContactComponent>();
        }
        return this.contact;
    }

    public MedicinalProductDefinition setContact(List<MedicinalProductDefinitionContactComponent> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (MedicinalProductDefinitionContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductDefinitionContactComponent addContact() {
        MedicinalProductDefinitionContactComponent t = new MedicinalProductDefinitionContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<MedicinalProductDefinitionContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public MedicinalProductDefinition addContact(MedicinalProductDefinitionContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<MedicinalProductDefinitionContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public MedicinalProductDefinitionContactComponent getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public List<Reference> getClinicalTrial() {
        if (this.clinicalTrial == null) {
            this.clinicalTrial = new ArrayList<Reference>();
        }
        return this.clinicalTrial;
    }

    public MedicinalProductDefinition setClinicalTrial(List<Reference> theClinicalTrial) {
        this.clinicalTrial = theClinicalTrial;
        return this;
    }

    public boolean hasClinicalTrial() {
        if (this.clinicalTrial == null) {
            return false;
        }
        for (Reference item : this.clinicalTrial) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addClinicalTrial() {
        Reference t = new Reference();
        if (this.clinicalTrial == null) {
            this.clinicalTrial = new ArrayList<Reference>();
        }
        this.clinicalTrial.add(t);
        return t;
    }

    public MedicinalProductDefinition addClinicalTrial(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.clinicalTrial == null) {
            this.clinicalTrial = new ArrayList<Reference>();
        }
        this.clinicalTrial.add(t);
        return this;
    }

    public Reference getClinicalTrialFirstRep() {
        if (this.getClinicalTrial().isEmpty()) {
            this.addClinicalTrial();
        }
        return this.getClinicalTrial().get(0);
    }

    public List<MedicinalProductDefinitionNameComponent> getName() {
        if (this.name == null) {
            this.name = new ArrayList<MedicinalProductDefinitionNameComponent>();
        }
        return this.name;
    }

    public MedicinalProductDefinition setName(List<MedicinalProductDefinitionNameComponent> theName) {
        this.name = theName;
        return this;
    }

    public boolean hasName() {
        if (this.name == null) {
            return false;
        }
        for (MedicinalProductDefinitionNameComponent item : this.name) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductDefinitionNameComponent addName() {
        MedicinalProductDefinitionNameComponent t = new MedicinalProductDefinitionNameComponent();
        if (this.name == null) {
            this.name = new ArrayList<MedicinalProductDefinitionNameComponent>();
        }
        this.name.add(t);
        return t;
    }

    public MedicinalProductDefinition addName(MedicinalProductDefinitionNameComponent t) {
        if (t == null) {
            return this;
        }
        if (this.name == null) {
            this.name = new ArrayList<MedicinalProductDefinitionNameComponent>();
        }
        this.name.add(t);
        return this;
    }

    public MedicinalProductDefinitionNameComponent getNameFirstRep() {
        if (this.getName().isEmpty()) {
            this.addName();
        }
        return this.getName().get(0);
    }

    public List<MedicinalProductDefinitionCrossReferenceComponent> getCrossReference() {
        if (this.crossReference == null) {
            this.crossReference = new ArrayList<MedicinalProductDefinitionCrossReferenceComponent>();
        }
        return this.crossReference;
    }

    public MedicinalProductDefinition setCrossReference(List<MedicinalProductDefinitionCrossReferenceComponent> theCrossReference) {
        this.crossReference = theCrossReference;
        return this;
    }

    public boolean hasCrossReference() {
        if (this.crossReference == null) {
            return false;
        }
        for (MedicinalProductDefinitionCrossReferenceComponent item : this.crossReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductDefinitionCrossReferenceComponent addCrossReference() {
        MedicinalProductDefinitionCrossReferenceComponent t = new MedicinalProductDefinitionCrossReferenceComponent();
        if (this.crossReference == null) {
            this.crossReference = new ArrayList<MedicinalProductDefinitionCrossReferenceComponent>();
        }
        this.crossReference.add(t);
        return t;
    }

    public MedicinalProductDefinition addCrossReference(MedicinalProductDefinitionCrossReferenceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.crossReference == null) {
            this.crossReference = new ArrayList<MedicinalProductDefinitionCrossReferenceComponent>();
        }
        this.crossReference.add(t);
        return this;
    }

    public MedicinalProductDefinitionCrossReferenceComponent getCrossReferenceFirstRep() {
        if (this.getCrossReference().isEmpty()) {
            this.addCrossReference();
        }
        return this.getCrossReference().get(0);
    }

    public List<MedicinalProductDefinitionManufacturingBusinessOperationComponent> getManufacturingBusinessOperation() {
        if (this.manufacturingBusinessOperation == null) {
            this.manufacturingBusinessOperation = new ArrayList<MedicinalProductDefinitionManufacturingBusinessOperationComponent>();
        }
        return this.manufacturingBusinessOperation;
    }

    public MedicinalProductDefinition setManufacturingBusinessOperation(List<MedicinalProductDefinitionManufacturingBusinessOperationComponent> theManufacturingBusinessOperation) {
        this.manufacturingBusinessOperation = theManufacturingBusinessOperation;
        return this;
    }

    public boolean hasManufacturingBusinessOperation() {
        if (this.manufacturingBusinessOperation == null) {
            return false;
        }
        for (MedicinalProductDefinitionManufacturingBusinessOperationComponent item : this.manufacturingBusinessOperation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductDefinitionManufacturingBusinessOperationComponent addManufacturingBusinessOperation() {
        MedicinalProductDefinitionManufacturingBusinessOperationComponent t = new MedicinalProductDefinitionManufacturingBusinessOperationComponent();
        if (this.manufacturingBusinessOperation == null) {
            this.manufacturingBusinessOperation = new ArrayList<MedicinalProductDefinitionManufacturingBusinessOperationComponent>();
        }
        this.manufacturingBusinessOperation.add(t);
        return t;
    }

    public MedicinalProductDefinition addManufacturingBusinessOperation(MedicinalProductDefinitionManufacturingBusinessOperationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturingBusinessOperation == null) {
            this.manufacturingBusinessOperation = new ArrayList<MedicinalProductDefinitionManufacturingBusinessOperationComponent>();
        }
        this.manufacturingBusinessOperation.add(t);
        return this;
    }

    public MedicinalProductDefinitionManufacturingBusinessOperationComponent getManufacturingBusinessOperationFirstRep() {
        if (this.getManufacturingBusinessOperation().isEmpty()) {
            this.addManufacturingBusinessOperation();
        }
        return this.getManufacturingBusinessOperation().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this product. Could be an MPID.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Regulatory type, e.g. Investigational or Authorized.", 0, 1, this.type));
        children.add(new Property(SP_DOMAIN, "CodeableConcept", "If this medicine applies to human or veterinary uses.", 0, 1, this.domain));
        children.add(new Property("version", "string", "A business level identifier of the product.", 0, 1, this.version));
        children.add(new Property(SP_STATUS, "CodeableConcept", "The status within the lifecycle of this product. A high level status, this is not intended to duplicate details carried elswhere such as legal status, or authorization status.", 0, 1, this.status));
        children.add(new Property("statusDate", "dateTime", "The date at which the given status became applicable.", 0, 1, this.statusDate));
        children.add(new Property("description", "markdown", "General description of this product.", 0, 1, this.description));
        children.add(new Property("combinedPharmaceuticalDoseForm", "CodeableConcept", "The dose form for a single part product, or combined form of a multiple part product.", 0, 1, this.combinedPharmaceuticalDoseForm));
        children.add(new Property("indication", "markdown", "General combined description of indication(s) for this product. See also MedicinalProductDefinitionIndication.", 0, 1, this.indication));
        children.add(new Property("legalStatusOfSupply", "CodeableConcept", "The legal status of supply of the medicinal product as classified by the regulator.", 0, 1, this.legalStatusOfSupply));
        children.add(new Property("additionalMonitoringIndicator", "CodeableConcept", "Whether the Medicinal Product is subject to additional monitoring for regulatory reasons.", 0, 1, this.additionalMonitoringIndicator));
        children.add(new Property("specialMeasures", "CodeableConcept", "Whether the Medicinal Product is subject to special measures for regulatory reasons.", 0, Integer.MAX_VALUE, this.specialMeasures));
        children.add(new Property("paediatricUseIndicator", "CodeableConcept", "If authorised for use in children.", 0, 1, this.paediatricUseIndicator));
        children.add(new Property("productClassification", "CodeableConcept", "Allows the product to be classified by various systems.", 0, Integer.MAX_VALUE, this.productClassification));
        children.add(new Property(SP_CHARACTERISTIC, "CodeableConcept", "Allows the key product features to be recorded, such as \"suger free\", \"modified release\", \"parallel import\".", 0, Integer.MAX_VALUE, this.characteristic));
        children.add(new Property("marketingStatus", "MarketingStatus", "Marketing status of the medicinal product, in contrast to marketing authorizaton.", 0, Integer.MAX_VALUE, this.marketingStatus));
        children.add(new Property("pharmaceuticalProduct", "Reference(AdministrableProductDefinition)", "Pharmaceutical aspects of product.", 0, Integer.MAX_VALUE, this.pharmaceuticalProduct));
        children.add(new Property("packagedMedicinalProduct", "Reference(PackagedProductDefinition)", "Package representation for the product.", 0, Integer.MAX_VALUE, this.packagedMedicinalProduct));
        children.add(new Property("ingredient", "Reference(Ingredient)", "The ingredients of this medicinal product - when not specified elsewhere. This is only needed if the ingredients are not specified by the pharmaceuticalProduct or packagedMedicinalProduct references above. In cases where those levels of detail are not used, the ingredients may be specified directly here.", 0, Integer.MAX_VALUE, this.ingredient));
        children.add(new Property("attachedDocument", "Reference(DocumentReference)", "Supporting documentation, typically for regulatory submission.", 0, Integer.MAX_VALUE, this.attachedDocument));
        children.add(new Property("masterFile", "Reference(DocumentReference)", "A master file for to the medicinal product (e.g. Pharmacovigilance System Master File).", 0, Integer.MAX_VALUE, this.masterFile));
        children.add(new Property(SP_CONTACT, "", "A product specific contact, person (in a role), or an organization.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("clinicalTrial", "Reference(ResearchStudy)", "Clinical trials or studies that this product is involved in.", 0, Integer.MAX_VALUE, this.clinicalTrial));
        children.add(new Property(SP_NAME, "", "The product's name, including full name and possibly coded parts.", 0, Integer.MAX_VALUE, this.name));
        children.add(new Property("crossReference", "", "Reference to another product, e.g. for linking authorised to investigational product.", 0, Integer.MAX_VALUE, this.crossReference));
        children.add(new Property("manufacturingBusinessOperation", "", "An operation applied to the product, for manufacturing or adminsitrative purpose.", 0, Integer.MAX_VALUE, this.manufacturingBusinessOperation));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this product. Could be an MPID.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Regulatory type, e.g. Investigational or Authorized.", 0, 1, this.type);
            }
            case -1326197564: {
                return new Property(SP_DOMAIN, "CodeableConcept", "If this medicine applies to human or veterinary uses.", 0, 1, this.domain);
            }
            case 351608024: {
                return new Property("version", "string", "A business level identifier of the product.", 0, 1, this.version);
            }
            case -892481550: {
                return new Property(SP_STATUS, "CodeableConcept", "The status within the lifecycle of this product. A high level status, this is not intended to duplicate details carried elswhere such as legal status, or authorization status.", 0, 1, this.status);
            }
            case 247524032: {
                return new Property("statusDate", "dateTime", "The date at which the given status became applicable.", 0, 1, this.statusDate);
            }
            case -1724546052: {
                return new Property("description", "markdown", "General description of this product.", 0, 1, this.description);
            }
            case -1992898487: {
                return new Property("combinedPharmaceuticalDoseForm", "CodeableConcept", "The dose form for a single part product, or combined form of a multiple part product.", 0, 1, this.combinedPharmaceuticalDoseForm);
            }
            case -597168804: {
                return new Property("indication", "markdown", "General combined description of indication(s) for this product. See also MedicinalProductDefinitionIndication.", 0, 1, this.indication);
            }
            case -844874031: {
                return new Property("legalStatusOfSupply", "CodeableConcept", "The legal status of supply of the medicinal product as classified by the regulator.", 0, 1, this.legalStatusOfSupply);
            }
            case 1935999744: {
                return new Property("additionalMonitoringIndicator", "CodeableConcept", "Whether the Medicinal Product is subject to additional monitoring for regulatory reasons.", 0, 1, this.additionalMonitoringIndicator);
            }
            case 975102638: {
                return new Property("specialMeasures", "CodeableConcept", "Whether the Medicinal Product is subject to special measures for regulatory reasons.", 0, Integer.MAX_VALUE, this.specialMeasures);
            }
            case -1019867160: {
                return new Property("paediatricUseIndicator", "CodeableConcept", "If authorised for use in children.", 0, 1, this.paediatricUseIndicator);
            }
            case 1247936181: {
                return new Property("productClassification", "CodeableConcept", "Allows the product to be classified by various systems.", 0, Integer.MAX_VALUE, this.productClassification);
            }
            case 366313883: {
                return new Property(SP_CHARACTERISTIC, "CodeableConcept", "Allows the key product features to be recorded, such as \"suger free\", \"modified release\", \"parallel import\".", 0, Integer.MAX_VALUE, this.characteristic);
            }
            case 70767032: {
                return new Property("marketingStatus", "MarketingStatus", "Marketing status of the medicinal product, in contrast to marketing authorizaton.", 0, Integer.MAX_VALUE, this.marketingStatus);
            }
            case 443273260: {
                return new Property("pharmaceuticalProduct", "Reference(AdministrableProductDefinition)", "Pharmaceutical aspects of product.", 0, Integer.MAX_VALUE, this.pharmaceuticalProduct);
            }
            case -361025513: {
                return new Property("packagedMedicinalProduct", "Reference(PackagedProductDefinition)", "Package representation for the product.", 0, Integer.MAX_VALUE, this.packagedMedicinalProduct);
            }
            case -206409263: {
                return new Property("ingredient", "Reference(Ingredient)", "The ingredients of this medicinal product - when not specified elsewhere. This is only needed if the ingredients are not specified by the pharmaceuticalProduct or packagedMedicinalProduct references above. In cases where those levels of detail are not used, the ingredients may be specified directly here.", 0, Integer.MAX_VALUE, this.ingredient);
            }
            case -513945889: {
                return new Property("attachedDocument", "Reference(DocumentReference)", "Supporting documentation, typically for regulatory submission.", 0, Integer.MAX_VALUE, this.attachedDocument);
            }
            case -2039573762: {
                return new Property("masterFile", "Reference(DocumentReference)", "A master file for to the medicinal product (e.g. Pharmacovigilance System Master File).", 0, Integer.MAX_VALUE, this.masterFile);
            }
            case 951526432: {
                return new Property(SP_CONTACT, "", "A product specific contact, person (in a role), or an organization.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 1232866243: {
                return new Property("clinicalTrial", "Reference(ResearchStudy)", "Clinical trials or studies that this product is involved in.", 0, Integer.MAX_VALUE, this.clinicalTrial);
            }
            case 3373707: {
                return new Property(SP_NAME, "", "The product's name, including full name and possibly coded parts.", 0, Integer.MAX_VALUE, this.name);
            }
            case -986968341: {
                return new Property("crossReference", "", "Reference to another product, e.g. for linking authorised to investigational product.", 0, Integer.MAX_VALUE, this.crossReference);
            }
            case -171103255: {
                return new Property("manufacturingBusinessOperation", "", "An operation applied to the product, for manufacturing or adminsitrative purpose.", 0, Integer.MAX_VALUE, this.manufacturingBusinessOperation);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -1326197564: {
                Base[] baseArray;
                if (this.domain == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.domain;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.version;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case 247524032: {
                Base[] baseArray;
                if (this.statusDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.statusDate;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.description;
                }
                return baseArray;
            }
            case -1992898487: {
                Base[] baseArray;
                if (this.combinedPharmaceuticalDoseForm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.combinedPharmaceuticalDoseForm;
                }
                return baseArray;
            }
            case -597168804: {
                Base[] baseArray;
                if (this.indication == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.indication;
                }
                return baseArray;
            }
            case -844874031: {
                Base[] baseArray;
                if (this.legalStatusOfSupply == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.legalStatusOfSupply;
                }
                return baseArray;
            }
            case 1935999744: {
                Base[] baseArray;
                if (this.additionalMonitoringIndicator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.additionalMonitoringIndicator;
                }
                return baseArray;
            }
            case 975102638: {
                return this.specialMeasures == null ? new Base[]{} : this.specialMeasures.toArray(new Base[this.specialMeasures.size()]);
            }
            case -1019867160: {
                Base[] baseArray;
                if (this.paediatricUseIndicator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.paediatricUseIndicator;
                }
                return baseArray;
            }
            case 1247936181: {
                return this.productClassification == null ? new Base[]{} : this.productClassification.toArray(new Base[this.productClassification.size()]);
            }
            case 366313883: {
                return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
            }
            case 70767032: {
                return this.marketingStatus == null ? new Base[]{} : this.marketingStatus.toArray(new Base[this.marketingStatus.size()]);
            }
            case 443273260: {
                return this.pharmaceuticalProduct == null ? new Base[]{} : this.pharmaceuticalProduct.toArray(new Base[this.pharmaceuticalProduct.size()]);
            }
            case -361025513: {
                return this.packagedMedicinalProduct == null ? new Base[]{} : this.packagedMedicinalProduct.toArray(new Base[this.packagedMedicinalProduct.size()]);
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
            case -513945889: {
                return this.attachedDocument == null ? new Base[]{} : this.attachedDocument.toArray(new Base[this.attachedDocument.size()]);
            }
            case -2039573762: {
                return this.masterFile == null ? new Base[]{} : this.masterFile.toArray(new Base[this.masterFile.size()]);
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1232866243: {
                return this.clinicalTrial == null ? new Base[]{} : this.clinicalTrial.toArray(new Base[this.clinicalTrial.size()]);
            }
            case 3373707: {
                return this.name == null ? new Base[]{} : this.name.toArray(new Base[this.name.size()]);
            }
            case -986968341: {
                return this.crossReference == null ? new Base[]{} : this.crossReference.toArray(new Base[this.crossReference.size()]);
            }
            case -171103255: {
                return this.manufacturingBusinessOperation == null ? new Base[]{} : this.manufacturingBusinessOperation.toArray(new Base[this.manufacturingBusinessOperation.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1326197564: {
                this.domain = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 247524032: {
                this.statusDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -1992898487: {
                this.combinedPharmaceuticalDoseForm = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -597168804: {
                this.indication = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -844874031: {
                this.legalStatusOfSupply = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1935999744: {
                this.additionalMonitoringIndicator = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 975102638: {
                this.getSpecialMeasures().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1019867160: {
                this.paediatricUseIndicator = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1247936181: {
                this.getProductClassification().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 366313883: {
                this.getCharacteristic().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 70767032: {
                this.getMarketingStatus().add(TypeConvertor.castToMarketingStatus(value));
                return value;
            }
            case 443273260: {
                this.getPharmaceuticalProduct().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -361025513: {
                this.getPackagedMedicinalProduct().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -206409263: {
                this.getIngredient().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -513945889: {
                this.getAttachedDocument().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -2039573762: {
                this.getMasterFile().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 951526432: {
                this.getContact().add((MedicinalProductDefinitionContactComponent)value);
                return value;
            }
            case 1232866243: {
                this.getClinicalTrial().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3373707: {
                this.getName().add((MedicinalProductDefinitionNameComponent)value);
                return value;
            }
            case -986968341: {
                this.getCrossReference().add((MedicinalProductDefinitionCrossReferenceComponent)value);
                return value;
            }
            case -171103255: {
                this.getManufacturingBusinessOperation().add((MedicinalProductDefinitionManufacturingBusinessOperationComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_DOMAIN)) {
            this.domain = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("version")) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("statusDate")) {
            this.statusDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("combinedPharmaceuticalDoseForm")) {
            this.combinedPharmaceuticalDoseForm = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("indication")) {
            this.indication = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("legalStatusOfSupply")) {
            this.legalStatusOfSupply = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("additionalMonitoringIndicator")) {
            this.additionalMonitoringIndicator = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("specialMeasures")) {
            this.getSpecialMeasures().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("paediatricUseIndicator")) {
            this.paediatricUseIndicator = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("productClassification")) {
            this.getProductClassification().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_CHARACTERISTIC)) {
            this.getCharacteristic().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("marketingStatus")) {
            this.getMarketingStatus().add(TypeConvertor.castToMarketingStatus(value));
        } else if (name.equals("pharmaceuticalProduct")) {
            this.getPharmaceuticalProduct().add(TypeConvertor.castToReference(value));
        } else if (name.equals("packagedMedicinalProduct")) {
            this.getPackagedMedicinalProduct().add(TypeConvertor.castToReference(value));
        } else if (name.equals("ingredient")) {
            this.getIngredient().add(TypeConvertor.castToReference(value));
        } else if (name.equals("attachedDocument")) {
            this.getAttachedDocument().add(TypeConvertor.castToReference(value));
        } else if (name.equals("masterFile")) {
            this.getMasterFile().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_CONTACT)) {
            this.getContact().add((MedicinalProductDefinitionContactComponent)value);
        } else if (name.equals("clinicalTrial")) {
            this.getClinicalTrial().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_NAME)) {
            this.getName().add((MedicinalProductDefinitionNameComponent)value);
        } else if (name.equals("crossReference")) {
            this.getCrossReference().add((MedicinalProductDefinitionCrossReferenceComponent)value);
        } else if (name.equals("manufacturingBusinessOperation")) {
            this.getManufacturingBusinessOperation().add((MedicinalProductDefinitionManufacturingBusinessOperationComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3575610: {
                return this.getType();
            }
            case -1326197564: {
                return this.getDomain();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -892481550: {
                return this.getStatus();
            }
            case 247524032: {
                return this.getStatusDateElement();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -1992898487: {
                return this.getCombinedPharmaceuticalDoseForm();
            }
            case -597168804: {
                return this.getIndicationElement();
            }
            case -844874031: {
                return this.getLegalStatusOfSupply();
            }
            case 1935999744: {
                return this.getAdditionalMonitoringIndicator();
            }
            case 975102638: {
                return this.addSpecialMeasures();
            }
            case -1019867160: {
                return this.getPaediatricUseIndicator();
            }
            case 1247936181: {
                return this.addProductClassification();
            }
            case 366313883: {
                return this.addCharacteristic();
            }
            case 70767032: {
                return this.addMarketingStatus();
            }
            case 443273260: {
                return this.addPharmaceuticalProduct();
            }
            case -361025513: {
                return this.addPackagedMedicinalProduct();
            }
            case -206409263: {
                return this.addIngredient();
            }
            case -513945889: {
                return this.addAttachedDocument();
            }
            case -2039573762: {
                return this.addMasterFile();
            }
            case 951526432: {
                return this.addContact();
            }
            case 1232866243: {
                return this.addClinicalTrial();
            }
            case 3373707: {
                return this.addName();
            }
            case -986968341: {
                return this.addCrossReference();
            }
            case -171103255: {
                return this.addManufacturingBusinessOperation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1326197564: {
                return new String[]{"CodeableConcept"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"CodeableConcept"};
            }
            case 247524032: {
                return new String[]{"dateTime"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -1992898487: {
                return new String[]{"CodeableConcept"};
            }
            case -597168804: {
                return new String[]{"markdown"};
            }
            case -844874031: {
                return new String[]{"CodeableConcept"};
            }
            case 1935999744: {
                return new String[]{"CodeableConcept"};
            }
            case 975102638: {
                return new String[]{"CodeableConcept"};
            }
            case -1019867160: {
                return new String[]{"CodeableConcept"};
            }
            case 1247936181: {
                return new String[]{"CodeableConcept"};
            }
            case 366313883: {
                return new String[]{"CodeableConcept"};
            }
            case 70767032: {
                return new String[]{"MarketingStatus"};
            }
            case 443273260: {
                return new String[]{"Reference"};
            }
            case -361025513: {
                return new String[]{"Reference"};
            }
            case -206409263: {
                return new String[]{"Reference"};
            }
            case -513945889: {
                return new String[]{"Reference"};
            }
            case -2039573762: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[0];
            }
            case 1232866243: {
                return new String[]{"Reference"};
            }
            case 3373707: {
                return new String[0];
            }
            case -986968341: {
                return new String[0];
            }
            case -171103255: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_DOMAIN)) {
            this.domain = new CodeableConcept();
            return this.domain;
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductDefinition.version");
        }
        if (name.equals(SP_STATUS)) {
            this.status = new CodeableConcept();
            return this.status;
        }
        if (name.equals("statusDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductDefinition.statusDate");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductDefinition.description");
        }
        if (name.equals("combinedPharmaceuticalDoseForm")) {
            this.combinedPharmaceuticalDoseForm = new CodeableConcept();
            return this.combinedPharmaceuticalDoseForm;
        }
        if (name.equals("indication")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductDefinition.indication");
        }
        if (name.equals("legalStatusOfSupply")) {
            this.legalStatusOfSupply = new CodeableConcept();
            return this.legalStatusOfSupply;
        }
        if (name.equals("additionalMonitoringIndicator")) {
            this.additionalMonitoringIndicator = new CodeableConcept();
            return this.additionalMonitoringIndicator;
        }
        if (name.equals("specialMeasures")) {
            return this.addSpecialMeasures();
        }
        if (name.equals("paediatricUseIndicator")) {
            this.paediatricUseIndicator = new CodeableConcept();
            return this.paediatricUseIndicator;
        }
        if (name.equals("productClassification")) {
            return this.addProductClassification();
        }
        if (name.equals(SP_CHARACTERISTIC)) {
            return this.addCharacteristic();
        }
        if (name.equals("marketingStatus")) {
            return this.addMarketingStatus();
        }
        if (name.equals("pharmaceuticalProduct")) {
            return this.addPharmaceuticalProduct();
        }
        if (name.equals("packagedMedicinalProduct")) {
            return this.addPackagedMedicinalProduct();
        }
        if (name.equals("ingredient")) {
            return this.addIngredient();
        }
        if (name.equals("attachedDocument")) {
            return this.addAttachedDocument();
        }
        if (name.equals("masterFile")) {
            return this.addMasterFile();
        }
        if (name.equals(SP_CONTACT)) {
            return this.addContact();
        }
        if (name.equals("clinicalTrial")) {
            return this.addClinicalTrial();
        }
        if (name.equals(SP_NAME)) {
            return this.addName();
        }
        if (name.equals("crossReference")) {
            return this.addCrossReference();
        }
        if (name.equals("manufacturingBusinessOperation")) {
            return this.addManufacturingBusinessOperation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicinalProductDefinition";
    }

    @Override
    public MedicinalProductDefinition copy() {
        MedicinalProductDefinition dst = new MedicinalProductDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MedicinalProductDefinition dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.domain = this.domain == null ? null : this.domain.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.statusDate = this.statusDate == null ? null : this.statusDate.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.combinedPharmaceuticalDoseForm = this.combinedPharmaceuticalDoseForm == null ? null : this.combinedPharmaceuticalDoseForm.copy();
        dst.indication = this.indication == null ? null : this.indication.copy();
        dst.legalStatusOfSupply = this.legalStatusOfSupply == null ? null : this.legalStatusOfSupply.copy();
        CodeableConcept codeableConcept = dst.additionalMonitoringIndicator = this.additionalMonitoringIndicator == null ? null : this.additionalMonitoringIndicator.copy();
        if (this.specialMeasures != null) {
            dst.specialMeasures = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.specialMeasures) {
                dst.specialMeasures.add(codeableConcept2.copy());
            }
        }
        CodeableConcept codeableConcept3 = dst.paediatricUseIndicator = this.paediatricUseIndicator == null ? null : this.paediatricUseIndicator.copy();
        if (this.productClassification != null) {
            dst.productClassification = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.productClassification) {
                dst.productClassification.add(codeableConcept4.copy());
            }
        }
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept5 : this.characteristic) {
                dst.characteristic.add(codeableConcept5.copy());
            }
        }
        if (this.marketingStatus != null) {
            dst.marketingStatus = new ArrayList<MarketingStatus>();
            for (MarketingStatus marketingStatus : this.marketingStatus) {
                dst.marketingStatus.add(marketingStatus.copy());
            }
        }
        if (this.pharmaceuticalProduct != null) {
            dst.pharmaceuticalProduct = new ArrayList<Reference>();
            for (Reference reference : this.pharmaceuticalProduct) {
                dst.pharmaceuticalProduct.add(reference.copy());
            }
        }
        if (this.packagedMedicinalProduct != null) {
            dst.packagedMedicinalProduct = new ArrayList<Reference>();
            for (Reference reference : this.packagedMedicinalProduct) {
                dst.packagedMedicinalProduct.add(reference.copy());
            }
        }
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<Reference>();
            for (Reference reference : this.ingredient) {
                dst.ingredient.add(reference.copy());
            }
        }
        if (this.attachedDocument != null) {
            dst.attachedDocument = new ArrayList<Reference>();
            for (Reference reference : this.attachedDocument) {
                dst.attachedDocument.add(reference.copy());
            }
        }
        if (this.masterFile != null) {
            dst.masterFile = new ArrayList<Reference>();
            for (Reference reference : this.masterFile) {
                dst.masterFile.add(reference.copy());
            }
        }
        if (this.contact != null) {
            dst.contact = new ArrayList<MedicinalProductDefinitionContactComponent>();
            for (MedicinalProductDefinitionContactComponent medicinalProductDefinitionContactComponent : this.contact) {
                dst.contact.add(medicinalProductDefinitionContactComponent.copy());
            }
        }
        if (this.clinicalTrial != null) {
            dst.clinicalTrial = new ArrayList<Reference>();
            for (Reference reference : this.clinicalTrial) {
                dst.clinicalTrial.add(reference.copy());
            }
        }
        if (this.name != null) {
            dst.name = new ArrayList<MedicinalProductDefinitionNameComponent>();
            for (MedicinalProductDefinitionNameComponent medicinalProductDefinitionNameComponent : this.name) {
                dst.name.add(medicinalProductDefinitionNameComponent.copy());
            }
        }
        if (this.crossReference != null) {
            dst.crossReference = new ArrayList<MedicinalProductDefinitionCrossReferenceComponent>();
            for (MedicinalProductDefinitionCrossReferenceComponent medicinalProductDefinitionCrossReferenceComponent : this.crossReference) {
                dst.crossReference.add(medicinalProductDefinitionCrossReferenceComponent.copy());
            }
        }
        if (this.manufacturingBusinessOperation != null) {
            dst.manufacturingBusinessOperation = new ArrayList<MedicinalProductDefinitionManufacturingBusinessOperationComponent>();
            for (MedicinalProductDefinitionManufacturingBusinessOperationComponent medicinalProductDefinitionManufacturingBusinessOperationComponent : this.manufacturingBusinessOperation) {
                dst.manufacturingBusinessOperation.add(medicinalProductDefinitionManufacturingBusinessOperationComponent.copy());
            }
        }
    }

    protected MedicinalProductDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductDefinition)) {
            return false;
        }
        MedicinalProductDefinition o = (MedicinalProductDefinition)other_;
        return MedicinalProductDefinition.compareDeep(this.identifier, o.identifier, true) && MedicinalProductDefinition.compareDeep(this.type, o.type, true) && MedicinalProductDefinition.compareDeep(this.domain, o.domain, true) && MedicinalProductDefinition.compareDeep(this.version, o.version, true) && MedicinalProductDefinition.compareDeep(this.status, o.status, true) && MedicinalProductDefinition.compareDeep(this.statusDate, o.statusDate, true) && MedicinalProductDefinition.compareDeep(this.description, o.description, true) && MedicinalProductDefinition.compareDeep(this.combinedPharmaceuticalDoseForm, o.combinedPharmaceuticalDoseForm, true) && MedicinalProductDefinition.compareDeep(this.indication, o.indication, true) && MedicinalProductDefinition.compareDeep(this.legalStatusOfSupply, o.legalStatusOfSupply, true) && MedicinalProductDefinition.compareDeep(this.additionalMonitoringIndicator, o.additionalMonitoringIndicator, true) && MedicinalProductDefinition.compareDeep(this.specialMeasures, o.specialMeasures, true) && MedicinalProductDefinition.compareDeep(this.paediatricUseIndicator, o.paediatricUseIndicator, true) && MedicinalProductDefinition.compareDeep(this.productClassification, o.productClassification, true) && MedicinalProductDefinition.compareDeep(this.characteristic, o.characteristic, true) && MedicinalProductDefinition.compareDeep(this.marketingStatus, o.marketingStatus, true) && MedicinalProductDefinition.compareDeep(this.pharmaceuticalProduct, o.pharmaceuticalProduct, true) && MedicinalProductDefinition.compareDeep(this.packagedMedicinalProduct, o.packagedMedicinalProduct, true) && MedicinalProductDefinition.compareDeep(this.ingredient, o.ingredient, true) && MedicinalProductDefinition.compareDeep(this.attachedDocument, o.attachedDocument, true) && MedicinalProductDefinition.compareDeep(this.masterFile, o.masterFile, true) && MedicinalProductDefinition.compareDeep(this.contact, o.contact, true) && MedicinalProductDefinition.compareDeep(this.clinicalTrial, o.clinicalTrial, true) && MedicinalProductDefinition.compareDeep(this.name, o.name, true) && MedicinalProductDefinition.compareDeep(this.crossReference, o.crossReference, true) && MedicinalProductDefinition.compareDeep(this.manufacturingBusinessOperation, o.manufacturingBusinessOperation, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductDefinition)) {
            return false;
        }
        MedicinalProductDefinition o = (MedicinalProductDefinition)other_;
        return MedicinalProductDefinition.compareValues(this.version, o.version, true) && MedicinalProductDefinition.compareValues(this.statusDate, o.statusDate, true) && MedicinalProductDefinition.compareValues(this.description, o.description, true) && MedicinalProductDefinition.compareValues(this.indication, o.indication, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.type, this.domain, this.version, this.status, this.statusDate, this.description, this.combinedPharmaceuticalDoseForm, this.indication, this.legalStatusOfSupply, this.additionalMonitoringIndicator, this.specialMeasures, this.paediatricUseIndicator, this.productClassification, this.characteristic, this.marketingStatus, this.pharmaceuticalProduct, this.packagedMedicinalProduct, this.ingredient, this.attachedDocument, this.masterFile, this.contact, this.clinicalTrial, this.name, this.crossReference, this.manufacturingBusinessOperation);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicinalProductDefinition;
    }

    @Block
    public static class MedicinalProductDefinitionManufacturingBusinessOperationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableReference.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of manufacturing operation e.g. manufacturing itself, re-packaging. This may be a subtype of some other wider scope of authorized operation, referenced by the authorization attribute", formalDefinition="The type of manufacturing operation e.g. manufacturing itself, re-packaging. This may be a subtype of some other wider scope of authorized operation, referenced by the authorization attribute.")
        protected CodeableReference type;
        @Child(name="effectiveDate", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Date range of applicability", formalDefinition="Date range of applicability.")
        protected Period effectiveDate;
        @Child(name="manufacturer", type={Organization.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The manufacturer or establishment associated with the process", formalDefinition="The manufacturer or establishment associated with the process.")
        protected List<Reference> manufacturer;
        @Child(name="authorization", type={RegulatedAuthorization.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="An authorization for this process, either as a logical reference, holding just an identifier, or a full refererence to a resource that captures the details. The authorization mayu possibly apply to several products or a wider scope of process of which this is a part", formalDefinition="An authorization for this process, either as a logical reference, holding just an identifier, or a full refererence to a resource that captures the details. The authorization mayu possibly apply to several products or a wider scope of process of which this is a part.")
        protected Reference authorization;
        @Child(name="confidentialityIndicator", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="To indicate if this proces is commercially confidential", formalDefinition="To indicate if this proces is commercially confidential.")
        protected CodeableConcept confidentialityIndicator;
        private static final long serialVersionUID = 1855392466L;

        public CodeableReference getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionManufacturingBusinessOperationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableReference();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductDefinitionManufacturingBusinessOperationComponent setType(CodeableReference value) {
            this.type = value;
            return this;
        }

        public Period getEffectiveDate() {
            if (this.effectiveDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionManufacturingBusinessOperationComponent.effectiveDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.effectiveDate = new Period();
                }
            }
            return this.effectiveDate;
        }

        public boolean hasEffectiveDate() {
            return this.effectiveDate != null && !this.effectiveDate.isEmpty();
        }

        public MedicinalProductDefinitionManufacturingBusinessOperationComponent setEffectiveDate(Period value) {
            this.effectiveDate = value;
            return this;
        }

        public List<Reference> getManufacturer() {
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            return this.manufacturer;
        }

        public MedicinalProductDefinitionManufacturingBusinessOperationComponent setManufacturer(List<Reference> theManufacturer) {
            this.manufacturer = theManufacturer;
            return this;
        }

        public boolean hasManufacturer() {
            if (this.manufacturer == null) {
                return false;
            }
            for (Reference item : this.manufacturer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addManufacturer() {
            Reference t = new Reference();
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            this.manufacturer.add(t);
            return t;
        }

        public MedicinalProductDefinitionManufacturingBusinessOperationComponent addManufacturer(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            this.manufacturer.add(t);
            return this;
        }

        public Reference getManufacturerFirstRep() {
            if (this.getManufacturer().isEmpty()) {
                this.addManufacturer();
            }
            return this.getManufacturer().get(0);
        }

        public Reference getAuthorization() {
            if (this.authorization == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionManufacturingBusinessOperationComponent.authorization");
                }
                if (Configuration.doAutoCreate()) {
                    this.authorization = new Reference();
                }
            }
            return this.authorization;
        }

        public boolean hasAuthorization() {
            return this.authorization != null && !this.authorization.isEmpty();
        }

        public MedicinalProductDefinitionManufacturingBusinessOperationComponent setAuthorization(Reference value) {
            this.authorization = value;
            return this;
        }

        public CodeableConcept getConfidentialityIndicator() {
            if (this.confidentialityIndicator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionManufacturingBusinessOperationComponent.confidentialityIndicator");
                }
                if (Configuration.doAutoCreate()) {
                    this.confidentialityIndicator = new CodeableConcept();
                }
            }
            return this.confidentialityIndicator;
        }

        public boolean hasConfidentialityIndicator() {
            return this.confidentialityIndicator != null && !this.confidentialityIndicator.isEmpty();
        }

        public MedicinalProductDefinitionManufacturingBusinessOperationComponent setConfidentialityIndicator(CodeableConcept value) {
            this.confidentialityIndicator = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(MedicinalProductDefinition.SP_TYPE, "CodeableReference(ActivityDefinition)", "The type of manufacturing operation e.g. manufacturing itself, re-packaging. This may be a subtype of some other wider scope of authorized operation, referenced by the authorization attribute.", 0, 1, this.type));
            children.add(new Property("effectiveDate", "Period", "Date range of applicability.", 0, 1, this.effectiveDate));
            children.add(new Property("manufacturer", "Reference(Organization)", "The manufacturer or establishment associated with the process.", 0, Integer.MAX_VALUE, this.manufacturer));
            children.add(new Property("authorization", "Reference(RegulatedAuthorization)", "An authorization for this process, either as a logical reference, holding just an identifier, or a full refererence to a resource that captures the details. The authorization mayu possibly apply to several products or a wider scope of process of which this is a part.", 0, 1, this.authorization));
            children.add(new Property("confidentialityIndicator", "CodeableConcept", "To indicate if this proces is commercially confidential.", 0, 1, this.confidentialityIndicator));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(MedicinalProductDefinition.SP_TYPE, "CodeableReference(ActivityDefinition)", "The type of manufacturing operation e.g. manufacturing itself, re-packaging. This may be a subtype of some other wider scope of authorized operation, referenced by the authorization attribute.", 0, 1, this.type);
                }
                case -930389515: {
                    return new Property("effectiveDate", "Period", "Date range of applicability.", 0, 1, this.effectiveDate);
                }
                case -1969347631: {
                    return new Property("manufacturer", "Reference(Organization)", "The manufacturer or establishment associated with the process.", 0, Integer.MAX_VALUE, this.manufacturer);
                }
                case -1385570183: {
                    return new Property("authorization", "Reference(RegulatedAuthorization)", "An authorization for this process, either as a logical reference, holding just an identifier, or a full refererence to a resource that captures the details. The authorization mayu possibly apply to several products or a wider scope of process of which this is a part.", 0, 1, this.authorization);
                }
                case -1449404791: {
                    return new Property("confidentialityIndicator", "CodeableConcept", "To indicate if this proces is commercially confidential.", 0, 1, this.confidentialityIndicator);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -930389515: {
                    Base[] baseArray;
                    if (this.effectiveDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.effectiveDate;
                    }
                    return baseArray;
                }
                case -1969347631: {
                    return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
                }
                case -1385570183: {
                    Base[] baseArray;
                    if (this.authorization == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.authorization;
                    }
                    return baseArray;
                }
                case -1449404791: {
                    Base[] baseArray;
                    if (this.confidentialityIndicator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.confidentialityIndicator;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -930389515: {
                    this.effectiveDate = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case -1969347631: {
                    this.getManufacturer().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -1385570183: {
                    this.authorization = TypeConvertor.castToReference(value);
                    return value;
                }
                case -1449404791: {
                    this.confidentialityIndicator = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("effectiveDate")) {
                this.effectiveDate = TypeConvertor.castToPeriod(value);
            } else if (name.equals("manufacturer")) {
                this.getManufacturer().add(TypeConvertor.castToReference(value));
            } else if (name.equals("authorization")) {
                this.authorization = TypeConvertor.castToReference(value);
            } else if (name.equals("confidentialityIndicator")) {
                this.confidentialityIndicator = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -930389515: {
                    return this.getEffectiveDate();
                }
                case -1969347631: {
                    return this.addManufacturer();
                }
                case -1385570183: {
                    return this.getAuthorization();
                }
                case -1449404791: {
                    return this.getConfidentialityIndicator();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableReference"};
                }
                case -930389515: {
                    return new String[]{"Period"};
                }
                case -1969347631: {
                    return new String[]{"Reference"};
                }
                case -1385570183: {
                    return new String[]{"Reference"};
                }
                case -1449404791: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = new CodeableReference();
                return this.type;
            }
            if (name.equals("effectiveDate")) {
                this.effectiveDate = new Period();
                return this.effectiveDate;
            }
            if (name.equals("manufacturer")) {
                return this.addManufacturer();
            }
            if (name.equals("authorization")) {
                this.authorization = new Reference();
                return this.authorization;
            }
            if (name.equals("confidentialityIndicator")) {
                this.confidentialityIndicator = new CodeableConcept();
                return this.confidentialityIndicator;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductDefinitionManufacturingBusinessOperationComponent copy() {
            MedicinalProductDefinitionManufacturingBusinessOperationComponent dst = new MedicinalProductDefinitionManufacturingBusinessOperationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductDefinitionManufacturingBusinessOperationComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            Period period = dst.effectiveDate = this.effectiveDate == null ? null : this.effectiveDate.copy();
            if (this.manufacturer != null) {
                dst.manufacturer = new ArrayList<Reference>();
                for (Reference i : this.manufacturer) {
                    dst.manufacturer.add(i.copy());
                }
            }
            dst.authorization = this.authorization == null ? null : this.authorization.copy();
            dst.confidentialityIndicator = this.confidentialityIndicator == null ? null : this.confidentialityIndicator.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionManufacturingBusinessOperationComponent)) {
                return false;
            }
            MedicinalProductDefinitionManufacturingBusinessOperationComponent o = (MedicinalProductDefinitionManufacturingBusinessOperationComponent)other_;
            return MedicinalProductDefinitionManufacturingBusinessOperationComponent.compareDeep(this.type, o.type, true) && MedicinalProductDefinitionManufacturingBusinessOperationComponent.compareDeep(this.effectiveDate, o.effectiveDate, true) && MedicinalProductDefinitionManufacturingBusinessOperationComponent.compareDeep(this.manufacturer, o.manufacturer, true) && MedicinalProductDefinitionManufacturingBusinessOperationComponent.compareDeep(this.authorization, o.authorization, true) && MedicinalProductDefinitionManufacturingBusinessOperationComponent.compareDeep(this.confidentialityIndicator, o.confidentialityIndicator, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionManufacturingBusinessOperationComponent)) {
                return false;
            }
            MedicinalProductDefinitionManufacturingBusinessOperationComponent o = (MedicinalProductDefinitionManufacturingBusinessOperationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.effectiveDate, this.manufacturer, this.authorization, this.confidentialityIndicator);
        }

        @Override
        public String fhirType() {
            return "MedicinalProductDefinition.manufacturingBusinessOperation";
        }
    }

    @Block
    public static class MedicinalProductDefinitionCrossReferenceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="product", type={Identifier.class, MedicinalProductDefinition.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to another product, e.g. for linking authorised to investigational product", formalDefinition="Reference to another product, e.g. for linking authorised to investigational product.")
        protected DataType product;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of relationship, for instance branded to generic, product to development product (investigational), parallel import version", formalDefinition="The type of relationship, for instance branded to generic, product to development product (investigational), parallel import version.")
        protected CodeableConcept type;
        private static final long serialVersionUID = 606573338L;

        public MedicinalProductDefinitionCrossReferenceComponent() {
        }

        public MedicinalProductDefinitionCrossReferenceComponent(DataType product) {
            this.setProduct(product);
        }

        public DataType getProduct() {
            return this.product;
        }

        public Identifier getProductIdentifier() throws FHIRException {
            if (this.product == null) {
                this.product = new Identifier();
            }
            if (!(this.product instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.product.getClass().getName() + " was encountered");
            }
            return (Identifier)this.product;
        }

        public boolean hasProductIdentifier() {
            return this != null && this.product instanceof Identifier;
        }

        public Reference getProductReference() throws FHIRException {
            if (this.product == null) {
                this.product = new Reference();
            }
            if (!(this.product instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.product.getClass().getName() + " was encountered");
            }
            return (Reference)this.product;
        }

        public boolean hasProductReference() {
            return this != null && this.product instanceof Reference;
        }

        public boolean hasProduct() {
            return this.product != null && !this.product.isEmpty();
        }

        public MedicinalProductDefinitionCrossReferenceComponent setProduct(DataType value) {
            if (value != null && !(value instanceof Identifier) && !(value instanceof Reference)) {
                throw new Error("Not the right type for MedicinalProductDefinition.crossReference.product[x]: " + value.fhirType());
            }
            this.product = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionCrossReferenceComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductDefinitionCrossReferenceComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("product[x]", "Identifier|Reference(MedicinalProductDefinition)", "Reference to another product, e.g. for linking authorised to investigational product.", 0, 1, this.product));
            children.add(new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "The type of relationship, for instance branded to generic, product to development product (investigational), parallel import version.", 0, 1, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1753005361: {
                    return new Property("product[x]", "Identifier|Reference(MedicinalProductDefinition)", "Reference to another product, e.g. for linking authorised to investigational product.", 0, 1, this.product);
                }
                case -309474065: {
                    return new Property("product[x]", "Identifier|Reference(MedicinalProductDefinition)", "Reference to another product, e.g. for linking authorised to investigational product.", 0, 1, this.product);
                }
                case 2006726392: {
                    return new Property("product[x]", "Identifier", "Reference to another product, e.g. for linking authorised to investigational product.", 0, 1, this.product);
                }
                case -669667556: {
                    return new Property("product[x]", "Reference(MedicinalProductDefinition)", "Reference to another product, e.g. for linking authorised to investigational product.", 0, 1, this.product);
                }
                case 3575610: {
                    return new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "The type of relationship, for instance branded to generic, product to development product (investigational), parallel import version.", 0, 1, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -309474065: {
                    Base[] baseArray;
                    if (this.product == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.product;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -309474065: {
                    this.product = TypeConvertor.castToType(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("product[x]")) {
                this.product = TypeConvertor.castToType(value);
            } else if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1753005361: {
                    return this.getProduct();
                }
                case -309474065: {
                    return this.getProduct();
                }
                case 3575610: {
                    return this.getType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -309474065: {
                    return new String[]{"Identifier", "Reference"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("productIdentifier")) {
                this.product = new Identifier();
                return this.product;
            }
            if (name.equals("productReference")) {
                this.product = new Reference();
                return this.product;
            }
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductDefinitionCrossReferenceComponent copy() {
            MedicinalProductDefinitionCrossReferenceComponent dst = new MedicinalProductDefinitionCrossReferenceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductDefinitionCrossReferenceComponent dst) {
            super.copyValues(dst);
            dst.product = this.product == null ? null : this.product.copy();
            dst.type = this.type == null ? null : this.type.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionCrossReferenceComponent)) {
                return false;
            }
            MedicinalProductDefinitionCrossReferenceComponent o = (MedicinalProductDefinitionCrossReferenceComponent)other_;
            return MedicinalProductDefinitionCrossReferenceComponent.compareDeep(this.product, o.product, true) && MedicinalProductDefinitionCrossReferenceComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionCrossReferenceComponent)) {
                return false;
            }
            MedicinalProductDefinitionCrossReferenceComponent o = (MedicinalProductDefinitionCrossReferenceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.product, this.type);
        }

        @Override
        public String fhirType() {
            return "MedicinalProductDefinition.crossReference";
        }
    }

    @Block
    public static class MedicinalProductDefinitionNameCountryLanguageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="country", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Country code for where this name applies", formalDefinition="Country code for where this name applies.")
        protected CodeableConcept country;
        @Child(name="jurisdiction", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Jurisdiction code for where this name applies", formalDefinition="Jurisdiction code for where this name applies.")
        protected CodeableConcept jurisdiction;
        @Child(name="language", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Language code for this name", formalDefinition="Language code for this name.")
        protected CodeableConcept language;
        private static final long serialVersionUID = 1627157564L;

        public MedicinalProductDefinitionNameCountryLanguageComponent() {
        }

        public MedicinalProductDefinitionNameCountryLanguageComponent(CodeableConcept country, CodeableConcept language) {
            this.setCountry(country);
            this.setLanguage(language);
        }

        public CodeableConcept getCountry() {
            if (this.country == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionNameCountryLanguageComponent.country");
                }
                if (Configuration.doAutoCreate()) {
                    this.country = new CodeableConcept();
                }
            }
            return this.country;
        }

        public boolean hasCountry() {
            return this.country != null && !this.country.isEmpty();
        }

        public MedicinalProductDefinitionNameCountryLanguageComponent setCountry(CodeableConcept value) {
            this.country = value;
            return this;
        }

        public CodeableConcept getJurisdiction() {
            if (this.jurisdiction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionNameCountryLanguageComponent.jurisdiction");
                }
                if (Configuration.doAutoCreate()) {
                    this.jurisdiction = new CodeableConcept();
                }
            }
            return this.jurisdiction;
        }

        public boolean hasJurisdiction() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public MedicinalProductDefinitionNameCountryLanguageComponent setJurisdiction(CodeableConcept value) {
            this.jurisdiction = value;
            return this;
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionNameCountryLanguageComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public MedicinalProductDefinitionNameCountryLanguageComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("country", "CodeableConcept", "Country code for where this name applies.", 0, 1, this.country));
            children.add(new Property("jurisdiction", "CodeableConcept", "Jurisdiction code for where this name applies.", 0, 1, this.jurisdiction));
            children.add(new Property("language", "CodeableConcept", "Language code for this name.", 0, 1, this.language));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 957831062: {
                    return new Property("country", "CodeableConcept", "Country code for where this name applies.", 0, 1, this.country);
                }
                case -507075711: {
                    return new Property("jurisdiction", "CodeableConcept", "Jurisdiction code for where this name applies.", 0, 1, this.jurisdiction);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "Language code for this name.", 0, 1, this.language);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 957831062: {
                    Base[] baseArray;
                    if (this.country == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.country;
                    }
                    return baseArray;
                }
                case -507075711: {
                    Base[] baseArray;
                    if (this.jurisdiction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.jurisdiction;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.language;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 957831062: {
                    this.country = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -507075711: {
                    this.jurisdiction = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1613589672: {
                    this.language = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("country")) {
                this.country = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("jurisdiction")) {
                this.jurisdiction = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("language")) {
                this.language = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 957831062: {
                    return this.getCountry();
                }
                case -507075711: {
                    return this.getJurisdiction();
                }
                case -1613589672: {
                    return this.getLanguage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 957831062: {
                    return new String[]{"CodeableConcept"};
                }
                case -507075711: {
                    return new String[]{"CodeableConcept"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("country")) {
                this.country = new CodeableConcept();
                return this.country;
            }
            if (name.equals("jurisdiction")) {
                this.jurisdiction = new CodeableConcept();
                return this.jurisdiction;
            }
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductDefinitionNameCountryLanguageComponent copy() {
            MedicinalProductDefinitionNameCountryLanguageComponent dst = new MedicinalProductDefinitionNameCountryLanguageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductDefinitionNameCountryLanguageComponent dst) {
            super.copyValues(dst);
            dst.country = this.country == null ? null : this.country.copy();
            dst.jurisdiction = this.jurisdiction == null ? null : this.jurisdiction.copy();
            dst.language = this.language == null ? null : this.language.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionNameCountryLanguageComponent)) {
                return false;
            }
            MedicinalProductDefinitionNameCountryLanguageComponent o = (MedicinalProductDefinitionNameCountryLanguageComponent)other_;
            return MedicinalProductDefinitionNameCountryLanguageComponent.compareDeep(this.country, o.country, true) && MedicinalProductDefinitionNameCountryLanguageComponent.compareDeep(this.jurisdiction, o.jurisdiction, true) && MedicinalProductDefinitionNameCountryLanguageComponent.compareDeep(this.language, o.language, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionNameCountryLanguageComponent)) {
                return false;
            }
            MedicinalProductDefinitionNameCountryLanguageComponent o = (MedicinalProductDefinitionNameCountryLanguageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.country, this.jurisdiction, this.language);
        }

        @Override
        public String fhirType() {
            return "MedicinalProductDefinition.name.countryLanguage";
        }
    }

    @Block
    public static class MedicinalProductDefinitionNameNamePartComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="part", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A fragment of a product name", formalDefinition="A fragment of a product name.")
        protected StringType part;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Idenifying type for this part of the name (e.g. strength part)", formalDefinition="Idenifying type for this part of the name (e.g. strength part).")
        protected CodeableConcept type;
        private static final long serialVersionUID = -1359126549L;

        public MedicinalProductDefinitionNameNamePartComponent() {
        }

        public MedicinalProductDefinitionNameNamePartComponent(String part, CodeableConcept type) {
            this.setPart(part);
            this.setType(type);
        }

        public StringType getPartElement() {
            if (this.part == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionNameNamePartComponent.part");
                }
                if (Configuration.doAutoCreate()) {
                    this.part = new StringType();
                }
            }
            return this.part;
        }

        public boolean hasPartElement() {
            return this.part != null && !this.part.isEmpty();
        }

        public boolean hasPart() {
            return this.part != null && !this.part.isEmpty();
        }

        public MedicinalProductDefinitionNameNamePartComponent setPartElement(StringType value) {
            this.part = value;
            return this;
        }

        public String getPart() {
            return this.part == null ? null : (String)this.part.getValue();
        }

        public MedicinalProductDefinitionNameNamePartComponent setPart(String value) {
            if (this.part == null) {
                this.part = new StringType();
            }
            this.part.setValue(value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionNameNamePartComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductDefinitionNameNamePartComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("part", "string", "A fragment of a product name.", 0, 1, this.part));
            children.add(new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "Idenifying type for this part of the name (e.g. strength part).", 0, 1, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3433459: {
                    return new Property("part", "string", "A fragment of a product name.", 0, 1, this.part);
                }
                case 3575610: {
                    return new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "Idenifying type for this part of the name (e.g. strength part).", 0, 1, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    Base[] baseArray;
                    if (this.part == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.part;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    this.part = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("part")) {
                this.part = TypeConvertor.castToString(value);
            } else if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    return this.getPartElement();
                }
                case 3575610: {
                    return this.getType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("part")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductDefinition.name.namePart.part");
            }
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductDefinitionNameNamePartComponent copy() {
            MedicinalProductDefinitionNameNamePartComponent dst = new MedicinalProductDefinitionNameNamePartComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductDefinitionNameNamePartComponent dst) {
            super.copyValues(dst);
            dst.part = this.part == null ? null : this.part.copy();
            dst.type = this.type == null ? null : this.type.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionNameNamePartComponent)) {
                return false;
            }
            MedicinalProductDefinitionNameNamePartComponent o = (MedicinalProductDefinitionNameNamePartComponent)other_;
            return MedicinalProductDefinitionNameNamePartComponent.compareDeep(this.part, o.part, true) && MedicinalProductDefinitionNameNamePartComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionNameNamePartComponent)) {
                return false;
            }
            MedicinalProductDefinitionNameNamePartComponent o = (MedicinalProductDefinitionNameNamePartComponent)other_;
            return MedicinalProductDefinitionNameNamePartComponent.compareValues(this.part, o.part, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.part, this.type);
        }

        @Override
        public String fhirType() {
            return "MedicinalProductDefinition.name.namePart";
        }
    }

    @Block
    public static class MedicinalProductDefinitionNameComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="productName", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The full product name", formalDefinition="The full product name.")
        protected StringType productName;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of product name, such as rINN, BAN, Proprietary, Non-Proprietary", formalDefinition="Type of product name, such as rINN, BAN, Proprietary, Non-Proprietary.")
        protected CodeableConcept type;
        @Child(name="namePart", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Coding words or phrases of the name", formalDefinition="Coding words or phrases of the name.")
        protected List<MedicinalProductDefinitionNameNamePartComponent> namePart;
        @Child(name="countryLanguage", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Country where the name applies", formalDefinition="Country where the name applies.")
        protected List<MedicinalProductDefinitionNameCountryLanguageComponent> countryLanguage;
        private static final long serialVersionUID = 829861294L;

        public MedicinalProductDefinitionNameComponent() {
        }

        public MedicinalProductDefinitionNameComponent(String productName) {
            this.setProductName(productName);
        }

        public StringType getProductNameElement() {
            if (this.productName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionNameComponent.productName");
                }
                if (Configuration.doAutoCreate()) {
                    this.productName = new StringType();
                }
            }
            return this.productName;
        }

        public boolean hasProductNameElement() {
            return this.productName != null && !this.productName.isEmpty();
        }

        public boolean hasProductName() {
            return this.productName != null && !this.productName.isEmpty();
        }

        public MedicinalProductDefinitionNameComponent setProductNameElement(StringType value) {
            this.productName = value;
            return this;
        }

        public String getProductName() {
            return this.productName == null ? null : (String)this.productName.getValue();
        }

        public MedicinalProductDefinitionNameComponent setProductName(String value) {
            if (this.productName == null) {
                this.productName = new StringType();
            }
            this.productName.setValue(value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionNameComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductDefinitionNameComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<MedicinalProductDefinitionNameNamePartComponent> getNamePart() {
            if (this.namePart == null) {
                this.namePart = new ArrayList<MedicinalProductDefinitionNameNamePartComponent>();
            }
            return this.namePart;
        }

        public MedicinalProductDefinitionNameComponent setNamePart(List<MedicinalProductDefinitionNameNamePartComponent> theNamePart) {
            this.namePart = theNamePart;
            return this;
        }

        public boolean hasNamePart() {
            if (this.namePart == null) {
                return false;
            }
            for (MedicinalProductDefinitionNameNamePartComponent item : this.namePart) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductDefinitionNameNamePartComponent addNamePart() {
            MedicinalProductDefinitionNameNamePartComponent t = new MedicinalProductDefinitionNameNamePartComponent();
            if (this.namePart == null) {
                this.namePart = new ArrayList<MedicinalProductDefinitionNameNamePartComponent>();
            }
            this.namePart.add(t);
            return t;
        }

        public MedicinalProductDefinitionNameComponent addNamePart(MedicinalProductDefinitionNameNamePartComponent t) {
            if (t == null) {
                return this;
            }
            if (this.namePart == null) {
                this.namePart = new ArrayList<MedicinalProductDefinitionNameNamePartComponent>();
            }
            this.namePart.add(t);
            return this;
        }

        public MedicinalProductDefinitionNameNamePartComponent getNamePartFirstRep() {
            if (this.getNamePart().isEmpty()) {
                this.addNamePart();
            }
            return this.getNamePart().get(0);
        }

        public List<MedicinalProductDefinitionNameCountryLanguageComponent> getCountryLanguage() {
            if (this.countryLanguage == null) {
                this.countryLanguage = new ArrayList<MedicinalProductDefinitionNameCountryLanguageComponent>();
            }
            return this.countryLanguage;
        }

        public MedicinalProductDefinitionNameComponent setCountryLanguage(List<MedicinalProductDefinitionNameCountryLanguageComponent> theCountryLanguage) {
            this.countryLanguage = theCountryLanguage;
            return this;
        }

        public boolean hasCountryLanguage() {
            if (this.countryLanguage == null) {
                return false;
            }
            for (MedicinalProductDefinitionNameCountryLanguageComponent item : this.countryLanguage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductDefinitionNameCountryLanguageComponent addCountryLanguage() {
            MedicinalProductDefinitionNameCountryLanguageComponent t = new MedicinalProductDefinitionNameCountryLanguageComponent();
            if (this.countryLanguage == null) {
                this.countryLanguage = new ArrayList<MedicinalProductDefinitionNameCountryLanguageComponent>();
            }
            this.countryLanguage.add(t);
            return t;
        }

        public MedicinalProductDefinitionNameComponent addCountryLanguage(MedicinalProductDefinitionNameCountryLanguageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.countryLanguage == null) {
                this.countryLanguage = new ArrayList<MedicinalProductDefinitionNameCountryLanguageComponent>();
            }
            this.countryLanguage.add(t);
            return this;
        }

        public MedicinalProductDefinitionNameCountryLanguageComponent getCountryLanguageFirstRep() {
            if (this.getCountryLanguage().isEmpty()) {
                this.addCountryLanguage();
            }
            return this.getCountryLanguage().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("productName", "string", "The full product name.", 0, 1, this.productName));
            children.add(new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "Type of product name, such as rINN, BAN, Proprietary, Non-Proprietary.", 0, 1, this.type));
            children.add(new Property("namePart", "", "Coding words or phrases of the name.", 0, Integer.MAX_VALUE, this.namePart));
            children.add(new Property("countryLanguage", "", "Country where the name applies.", 0, Integer.MAX_VALUE, this.countryLanguage));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1491817446: {
                    return new Property("productName", "string", "The full product name.", 0, 1, this.productName);
                }
                case 3575610: {
                    return new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "Type of product name, such as rINN, BAN, Proprietary, Non-Proprietary.", 0, 1, this.type);
                }
                case 1840452894: {
                    return new Property("namePart", "", "Coding words or phrases of the name.", 0, Integer.MAX_VALUE, this.namePart);
                }
                case -141141746: {
                    return new Property("countryLanguage", "", "Country where the name applies.", 0, Integer.MAX_VALUE, this.countryLanguage);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1491817446: {
                    Base[] baseArray;
                    if (this.productName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.productName;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 1840452894: {
                    return this.namePart == null ? new Base[]{} : this.namePart.toArray(new Base[this.namePart.size()]);
                }
                case -141141746: {
                    return this.countryLanguage == null ? new Base[]{} : this.countryLanguage.toArray(new Base[this.countryLanguage.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1491817446: {
                    this.productName = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1840452894: {
                    this.getNamePart().add((MedicinalProductDefinitionNameNamePartComponent)value);
                    return value;
                }
                case -141141746: {
                    this.getCountryLanguage().add((MedicinalProductDefinitionNameCountryLanguageComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("productName")) {
                this.productName = TypeConvertor.castToString(value);
            } else if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("namePart")) {
                this.getNamePart().add((MedicinalProductDefinitionNameNamePartComponent)value);
            } else if (name.equals("countryLanguage")) {
                this.getCountryLanguage().add((MedicinalProductDefinitionNameCountryLanguageComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1491817446: {
                    return this.getProductNameElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case 1840452894: {
                    return this.addNamePart();
                }
                case -141141746: {
                    return this.addCountryLanguage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1491817446: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1840452894: {
                    return new String[0];
                }
                case -141141746: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("productName")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductDefinition.name.productName");
            }
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("namePart")) {
                return this.addNamePart();
            }
            if (name.equals("countryLanguage")) {
                return this.addCountryLanguage();
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductDefinitionNameComponent copy() {
            MedicinalProductDefinitionNameComponent dst = new MedicinalProductDefinitionNameComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductDefinitionNameComponent dst) {
            super.copyValues(dst);
            dst.productName = this.productName == null ? null : this.productName.copy();
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.namePart != null) {
                dst.namePart = new ArrayList<MedicinalProductDefinitionNameNamePartComponent>();
                for (MedicinalProductDefinitionNameNamePartComponent medicinalProductDefinitionNameNamePartComponent : this.namePart) {
                    dst.namePart.add(medicinalProductDefinitionNameNamePartComponent.copy());
                }
            }
            if (this.countryLanguage != null) {
                dst.countryLanguage = new ArrayList<MedicinalProductDefinitionNameCountryLanguageComponent>();
                for (MedicinalProductDefinitionNameCountryLanguageComponent medicinalProductDefinitionNameCountryLanguageComponent : this.countryLanguage) {
                    dst.countryLanguage.add(medicinalProductDefinitionNameCountryLanguageComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionNameComponent)) {
                return false;
            }
            MedicinalProductDefinitionNameComponent o = (MedicinalProductDefinitionNameComponent)other_;
            return MedicinalProductDefinitionNameComponent.compareDeep(this.productName, o.productName, true) && MedicinalProductDefinitionNameComponent.compareDeep(this.type, o.type, true) && MedicinalProductDefinitionNameComponent.compareDeep(this.namePart, o.namePart, true) && MedicinalProductDefinitionNameComponent.compareDeep(this.countryLanguage, o.countryLanguage, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionNameComponent)) {
                return false;
            }
            MedicinalProductDefinitionNameComponent o = (MedicinalProductDefinitionNameComponent)other_;
            return MedicinalProductDefinitionNameComponent.compareValues(this.productName, o.productName, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.productName, this.type, this.namePart, this.countryLanguage);
        }

        @Override
        public String fhirType() {
            return "MedicinalProductDefinition.name";
        }
    }

    @Block
    public static class MedicinalProductDefinitionContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Allows the contact to be classified, for example QPPV, Pharmacovigilence Enquiry Information", formalDefinition="Allows the contact to be classified, for example QPPV, Pharmacovigilence Enquiry Information.")
        protected CodeableConcept type;
        @Child(name="contact", type={Organization.class, PractitionerRole.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A product specific contact, person (in a role), or an organization", formalDefinition="A product specific contact, person (in a role), or an organization.")
        protected Reference contact;
        private static final long serialVersionUID = -587616244L;

        public MedicinalProductDefinitionContactComponent() {
        }

        public MedicinalProductDefinitionContactComponent(Reference contact) {
            this.setContact(contact);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionContactComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductDefinitionContactComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Reference getContact() {
            if (this.contact == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionContactComponent.contact");
                }
                if (Configuration.doAutoCreate()) {
                    this.contact = new Reference();
                }
            }
            return this.contact;
        }

        public boolean hasContact() {
            return this.contact != null && !this.contact.isEmpty();
        }

        public MedicinalProductDefinitionContactComponent setContact(Reference value) {
            this.contact = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "Allows the contact to be classified, for example QPPV, Pharmacovigilence Enquiry Information.", 0, 1, this.type));
            children.add(new Property(MedicinalProductDefinition.SP_CONTACT, "Reference(Organization|PractitionerRole)", "A product specific contact, person (in a role), or an organization.", 0, 1, this.contact));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "Allows the contact to be classified, for example QPPV, Pharmacovigilence Enquiry Information.", 0, 1, this.type);
                }
                case 951526432: {
                    return new Property(MedicinalProductDefinition.SP_CONTACT, "Reference(Organization|PractitionerRole)", "A product specific contact, person (in a role), or an organization.", 0, 1, this.contact);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 951526432: {
                    Base[] baseArray;
                    if (this.contact == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.contact;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 951526432: {
                    this.contact = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(MedicinalProductDefinition.SP_CONTACT)) {
                this.contact = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 951526432: {
                    return this.getContact();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 951526432: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(MedicinalProductDefinition.SP_CONTACT)) {
                this.contact = new Reference();
                return this.contact;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductDefinitionContactComponent copy() {
            MedicinalProductDefinitionContactComponent dst = new MedicinalProductDefinitionContactComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductDefinitionContactComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.contact = this.contact == null ? null : this.contact.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionContactComponent)) {
                return false;
            }
            MedicinalProductDefinitionContactComponent o = (MedicinalProductDefinitionContactComponent)other_;
            return MedicinalProductDefinitionContactComponent.compareDeep(this.type, o.type, true) && MedicinalProductDefinitionContactComponent.compareDeep(this.contact, o.contact, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionContactComponent)) {
                return false;
            }
            MedicinalProductDefinitionContactComponent o = (MedicinalProductDefinitionContactComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.contact);
        }

        @Override
        public String fhirType() {
            return "MedicinalProductDefinition.contact";
        }
    }
}

