/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="DeviceMetric", profile="http://hl7.org/fhir/StructureDefinition/DeviceMetric")
public class DeviceMetric
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instance identifier", formalDefinition="Unique instance identifiers assigned to a device by the device or gateway software, manufacturers, other organizations or owners. For example: handle ID.")
    protected List<Identifier> identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identity of metric, for example Heart Rate or PEEP Setting", formalDefinition="Describes the type of the metric. For example: Heart Rate, PEEP Setting, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/devicemetric-type")
    protected CodeableConcept type;
    @Child(name="unit", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unit of Measure for the Metric", formalDefinition="Describes the unit that an observed value determined for this metric will have. For example: Percent, Seconds, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/devicemetric-type")
    protected CodeableConcept unit;
    @Child(name="source", type={Device.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Describes the link to the source Device", formalDefinition="Describes the link to the  Device that this DeviceMetric belongs to and that contains administrative device information such as manufacturer, serial number, etc.")
    protected Reference source;
    @Child(name="parent", type={Device.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Describes the link to the parent Device", formalDefinition="Describes the link to the  Device that this DeviceMetric belongs to and that provide information about the location of this DeviceMetric in the containment structure of the parent Device. An example would be a Device that represents a Channel. This reference can be used by a client application to distinguish DeviceMetrics that have the same type, but should be interpreted based on their containment location.")
    protected Reference parent;
    @Child(name="operationalStatus", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="on | off | standby | entered-in-error", formalDefinition="Indicates current operational state of the device. For example: On, Off, Standby, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/metric-operational-status")
    protected Enumeration<DeviceMetricOperationalStatus> operationalStatus;
    @Child(name="color", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="black | red | green | yellow | blue | magenta | cyan | white", formalDefinition="Describes the color representation for the metric. This is often used to aid clinicians to track and identify parameter types by color. In practice, consider a Patient Monitor that has ECG/HR and Pleth for example; the parameters are displayed in different characteristic colors, such as HR-blue, BP-green, and PR and SpO2- magenta.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/metric-color")
    protected Enumeration<DeviceMetricColor> color;
    @Child(name="category", type={CodeType.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="measurement | setting | calculation | unspecified", formalDefinition="Indicates the category of the observation generation process. A DeviceMetric can be for example a setting, measurement, or calculation.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/metric-category")
    protected Enumeration<DeviceMetricCategory> category;
    @Child(name="measurementPeriod", type={Timing.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Describes the measurement repetition time", formalDefinition="Describes the measurement repetition time. This is not necessarily the same as the update period. The measurement repetition time can range from milliseconds up to hours. An example for a measurement repetition time in the range of milliseconds is the sampling rate of an ECG. An example for a measurement repetition time in the range of hours is a NIBP that is triggered automatically every hour. The update period may be different than the measurement repetition time, if the device does not update the published observed value with the same frequency as it was measured.")
    protected Timing measurementPeriod;
    @Child(name="calibration", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Describes the calibrations that have been performed or that are required to be performed", formalDefinition="Describes the calibrations that have been performed or that are required to be performed.")
    protected List<DeviceMetricCalibrationComponent> calibration;
    private static final long serialVersionUID = 2132964036L;
    @SearchParamDefinition(name="category", path="DeviceMetric.category", description="The category of the metric", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="identifier", path="DeviceMetric.identifier", description="The identifier of the metric", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="parent", path="DeviceMetric.parent", description="The parent DeviceMetric resource", type="reference", target={Device.class})
    public static final String SP_PARENT = "parent";
    public static final ReferenceClientParam PARENT = new ReferenceClientParam("parent");
    public static final Include INCLUDE_PARENT = new Include("DeviceMetric:parent").toLocked();
    @SearchParamDefinition(name="source", path="DeviceMetric.source", description="The device resource", type="reference", target={Device.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("DeviceMetric:source").toLocked();
    @SearchParamDefinition(name="type", path="DeviceMetric.type", description="The component type", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public DeviceMetric() {
    }

    public DeviceMetric(CodeableConcept type, DeviceMetricCategory category) {
        this.setType(type);
        this.setCategory(category);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DeviceMetric setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DeviceMetric addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceMetric.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public DeviceMetric setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getUnit() {
        if (this.unit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceMetric.unit");
            }
            if (Configuration.doAutoCreate()) {
                this.unit = new CodeableConcept();
            }
        }
        return this.unit;
    }

    public boolean hasUnit() {
        return this.unit != null && !this.unit.isEmpty();
    }

    public DeviceMetric setUnit(CodeableConcept value) {
        this.unit = value;
        return this;
    }

    public Reference getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceMetric.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new Reference();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public DeviceMetric setSource(Reference value) {
        this.source = value;
        return this;
    }

    public Reference getParent() {
        if (this.parent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceMetric.parent");
            }
            if (Configuration.doAutoCreate()) {
                this.parent = new Reference();
            }
        }
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null && !this.parent.isEmpty();
    }

    public DeviceMetric setParent(Reference value) {
        this.parent = value;
        return this;
    }

    public Enumeration<DeviceMetricOperationalStatus> getOperationalStatusElement() {
        if (this.operationalStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceMetric.operationalStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.operationalStatus = new Enumeration<DeviceMetricOperationalStatus>(new DeviceMetricOperationalStatusEnumFactory());
            }
        }
        return this.operationalStatus;
    }

    public boolean hasOperationalStatusElement() {
        return this.operationalStatus != null && !this.operationalStatus.isEmpty();
    }

    public boolean hasOperationalStatus() {
        return this.operationalStatus != null && !this.operationalStatus.isEmpty();
    }

    public DeviceMetric setOperationalStatusElement(Enumeration<DeviceMetricOperationalStatus> value) {
        this.operationalStatus = value;
        return this;
    }

    public DeviceMetricOperationalStatus getOperationalStatus() {
        return this.operationalStatus == null ? null : (DeviceMetricOperationalStatus)((Object)this.operationalStatus.getValue());
    }

    public DeviceMetric setOperationalStatus(DeviceMetricOperationalStatus value) {
        if (value == null) {
            this.operationalStatus = null;
        } else {
            if (this.operationalStatus == null) {
                this.operationalStatus = new Enumeration<DeviceMetricOperationalStatus>(new DeviceMetricOperationalStatusEnumFactory());
            }
            this.operationalStatus.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<DeviceMetricColor> getColorElement() {
        if (this.color == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceMetric.color");
            }
            if (Configuration.doAutoCreate()) {
                this.color = new Enumeration<DeviceMetricColor>(new DeviceMetricColorEnumFactory());
            }
        }
        return this.color;
    }

    public boolean hasColorElement() {
        return this.color != null && !this.color.isEmpty();
    }

    public boolean hasColor() {
        return this.color != null && !this.color.isEmpty();
    }

    public DeviceMetric setColorElement(Enumeration<DeviceMetricColor> value) {
        this.color = value;
        return this;
    }

    public DeviceMetricColor getColor() {
        return this.color == null ? null : (DeviceMetricColor)((Object)this.color.getValue());
    }

    public DeviceMetric setColor(DeviceMetricColor value) {
        if (value == null) {
            this.color = null;
        } else {
            if (this.color == null) {
                this.color = new Enumeration<DeviceMetricColor>(new DeviceMetricColorEnumFactory());
            }
            this.color.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<DeviceMetricCategory> getCategoryElement() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceMetric.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new Enumeration<DeviceMetricCategory>(new DeviceMetricCategoryEnumFactory());
            }
        }
        return this.category;
    }

    public boolean hasCategoryElement() {
        return this.category != null && !this.category.isEmpty();
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public DeviceMetric setCategoryElement(Enumeration<DeviceMetricCategory> value) {
        this.category = value;
        return this;
    }

    public DeviceMetricCategory getCategory() {
        return this.category == null ? null : (DeviceMetricCategory)((Object)this.category.getValue());
    }

    public DeviceMetric setCategory(DeviceMetricCategory value) {
        if (this.category == null) {
            this.category = new Enumeration<DeviceMetricCategory>(new DeviceMetricCategoryEnumFactory());
        }
        this.category.setValue((Object)value);
        return this;
    }

    public Timing getMeasurementPeriod() {
        if (this.measurementPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceMetric.measurementPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.measurementPeriod = new Timing();
            }
        }
        return this.measurementPeriod;
    }

    public boolean hasMeasurementPeriod() {
        return this.measurementPeriod != null && !this.measurementPeriod.isEmpty();
    }

    public DeviceMetric setMeasurementPeriod(Timing value) {
        this.measurementPeriod = value;
        return this;
    }

    public List<DeviceMetricCalibrationComponent> getCalibration() {
        if (this.calibration == null) {
            this.calibration = new ArrayList<DeviceMetricCalibrationComponent>();
        }
        return this.calibration;
    }

    public DeviceMetric setCalibration(List<DeviceMetricCalibrationComponent> theCalibration) {
        this.calibration = theCalibration;
        return this;
    }

    public boolean hasCalibration() {
        if (this.calibration == null) {
            return false;
        }
        for (DeviceMetricCalibrationComponent item : this.calibration) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceMetricCalibrationComponent addCalibration() {
        DeviceMetricCalibrationComponent t = new DeviceMetricCalibrationComponent();
        if (this.calibration == null) {
            this.calibration = new ArrayList<DeviceMetricCalibrationComponent>();
        }
        this.calibration.add(t);
        return t;
    }

    public DeviceMetric addCalibration(DeviceMetricCalibrationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.calibration == null) {
            this.calibration = new ArrayList<DeviceMetricCalibrationComponent>();
        }
        this.calibration.add(t);
        return this;
    }

    public DeviceMetricCalibrationComponent getCalibrationFirstRep() {
        if (this.getCalibration().isEmpty()) {
            this.addCalibration();
        }
        return this.getCalibration().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by the device or gateway software, manufacturers, other organizations or owners. For example: handle ID.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Describes the type of the metric. For example: Heart Rate, PEEP Setting, etc.", 0, 1, this.type));
        children.add(new Property("unit", "CodeableConcept", "Describes the unit that an observed value determined for this metric will have. For example: Percent, Seconds, etc.", 0, 1, this.unit));
        children.add(new Property(SP_SOURCE, "Reference(Device)", "Describes the link to the  Device that this DeviceMetric belongs to and that contains administrative device information such as manufacturer, serial number, etc.", 0, 1, this.source));
        children.add(new Property(SP_PARENT, "Reference(Device)", "Describes the link to the  Device that this DeviceMetric belongs to and that provide information about the location of this DeviceMetric in the containment structure of the parent Device. An example would be a Device that represents a Channel. This reference can be used by a client application to distinguish DeviceMetrics that have the same type, but should be interpreted based on their containment location.", 0, 1, this.parent));
        children.add(new Property("operationalStatus", "code", "Indicates current operational state of the device. For example: On, Off, Standby, etc.", 0, 1, this.operationalStatus));
        children.add(new Property("color", "code", "Describes the color representation for the metric. This is often used to aid clinicians to track and identify parameter types by color. In practice, consider a Patient Monitor that has ECG/HR and Pleth for example; the parameters are displayed in different characteristic colors, such as HR-blue, BP-green, and PR and SpO2- magenta.", 0, 1, this.color));
        children.add(new Property(SP_CATEGORY, "code", "Indicates the category of the observation generation process. A DeviceMetric can be for example a setting, measurement, or calculation.", 0, 1, this.category));
        children.add(new Property("measurementPeriod", "Timing", "Describes the measurement repetition time. This is not necessarily the same as the update period. The measurement repetition time can range from milliseconds up to hours. An example for a measurement repetition time in the range of milliseconds is the sampling rate of an ECG. An example for a measurement repetition time in the range of hours is a NIBP that is triggered automatically every hour. The update period may be different than the measurement repetition time, if the device does not update the published observed value with the same frequency as it was measured.", 0, 1, this.measurementPeriod));
        children.add(new Property("calibration", "", "Describes the calibrations that have been performed or that are required to be performed.", 0, Integer.MAX_VALUE, this.calibration));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by the device or gateway software, manufacturers, other organizations or owners. For example: handle ID.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Describes the type of the metric. For example: Heart Rate, PEEP Setting, etc.", 0, 1, this.type);
            }
            case 3594628: {
                return new Property("unit", "CodeableConcept", "Describes the unit that an observed value determined for this metric will have. For example: Percent, Seconds, etc.", 0, 1, this.unit);
            }
            case -896505829: {
                return new Property(SP_SOURCE, "Reference(Device)", "Describes the link to the  Device that this DeviceMetric belongs to and that contains administrative device information such as manufacturer, serial number, etc.", 0, 1, this.source);
            }
            case -995424086: {
                return new Property(SP_PARENT, "Reference(Device)", "Describes the link to the  Device that this DeviceMetric belongs to and that provide information about the location of this DeviceMetric in the containment structure of the parent Device. An example would be a Device that represents a Channel. This reference can be used by a client application to distinguish DeviceMetrics that have the same type, but should be interpreted based on their containment location.", 0, 1, this.parent);
            }
            case -2103166364: {
                return new Property("operationalStatus", "code", "Indicates current operational state of the device. For example: On, Off, Standby, etc.", 0, 1, this.operationalStatus);
            }
            case 94842723: {
                return new Property("color", "code", "Describes the color representation for the metric. This is often used to aid clinicians to track and identify parameter types by color. In practice, consider a Patient Monitor that has ECG/HR and Pleth for example; the parameters are displayed in different characteristic colors, such as HR-blue, BP-green, and PR and SpO2- magenta.", 0, 1, this.color);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "code", "Indicates the category of the observation generation process. A DeviceMetric can be for example a setting, measurement, or calculation.", 0, 1, this.category);
            }
            case -1300332387: {
                return new Property("measurementPeriod", "Timing", "Describes the measurement repetition time. This is not necessarily the same as the update period. The measurement repetition time can range from milliseconds up to hours. An example for a measurement repetition time in the range of milliseconds is the sampling rate of an ECG. An example for a measurement repetition time in the range of hours is a NIBP that is triggered automatically every hour. The update period may be different than the measurement repetition time, if the device does not update the published observed value with the same frequency as it was measured.", 0, 1, this.measurementPeriod);
            }
            case 1421318634: {
                return new Property("calibration", "", "Describes the calibrations that have been performed or that are required to be performed.", 0, Integer.MAX_VALUE, this.calibration);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case 3594628: {
                Base[] baseArray;
                if (this.unit == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.unit;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.source;
                }
                return baseArray;
            }
            case -995424086: {
                Base[] baseArray;
                if (this.parent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.parent;
                }
                return baseArray;
            }
            case -2103166364: {
                Base[] baseArray;
                if (this.operationalStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.operationalStatus;
                }
                return baseArray;
            }
            case 94842723: {
                Base[] baseArray;
                if (this.color == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.color;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.category;
                }
                return baseArray;
            }
            case -1300332387: {
                Base[] baseArray;
                if (this.measurementPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.measurementPeriod;
                }
                return baseArray;
            }
            case 1421318634: {
                return this.calibration == null ? new Base[]{} : this.calibration.toArray(new Base[this.calibration.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3594628: {
                this.unit = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -896505829: {
                this.source = TypeConvertor.castToReference(value);
                return value;
            }
            case -995424086: {
                this.parent = TypeConvertor.castToReference(value);
                return value;
            }
            case -2103166364: {
                value = new DeviceMetricOperationalStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.operationalStatus = value;
                return value;
            }
            case 94842723: {
                value = new DeviceMetricColorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.color = value;
                return value;
            }
            case 50511102: {
                value = new DeviceMetricCategoryEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.category = value;
                return value;
            }
            case -1300332387: {
                this.measurementPeriod = TypeConvertor.castToTiming(value);
                return value;
            }
            case 1421318634: {
                this.getCalibration().add((DeviceMetricCalibrationComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("unit")) {
            this.unit = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SOURCE)) {
            this.source = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_PARENT)) {
            this.parent = TypeConvertor.castToReference(value);
        } else if (name.equals("operationalStatus")) {
            value = new DeviceMetricOperationalStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.operationalStatus = value;
        } else if (name.equals("color")) {
            value = new DeviceMetricColorEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.color = value;
        } else if (name.equals(SP_CATEGORY)) {
            value = new DeviceMetricCategoryEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.category = value;
        } else if (name.equals("measurementPeriod")) {
            this.measurementPeriod = TypeConvertor.castToTiming(value);
        } else if (name.equals("calibration")) {
            this.getCalibration().add((DeviceMetricCalibrationComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3575610: {
                return this.getType();
            }
            case 3594628: {
                return this.getUnit();
            }
            case -896505829: {
                return this.getSource();
            }
            case -995424086: {
                return this.getParent();
            }
            case -2103166364: {
                return this.getOperationalStatusElement();
            }
            case 94842723: {
                return this.getColorElement();
            }
            case 50511102: {
                return this.getCategoryElement();
            }
            case -1300332387: {
                return this.getMeasurementPeriod();
            }
            case 1421318634: {
                return this.addCalibration();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 3594628: {
                return new String[]{"CodeableConcept"};
            }
            case -896505829: {
                return new String[]{"Reference"};
            }
            case -995424086: {
                return new String[]{"Reference"};
            }
            case -2103166364: {
                return new String[]{"code"};
            }
            case 94842723: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[]{"code"};
            }
            case -1300332387: {
                return new String[]{"Timing"};
            }
            case 1421318634: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("unit")) {
            this.unit = new CodeableConcept();
            return this.unit;
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals(SP_PARENT)) {
            this.parent = new Reference();
            return this.parent;
        }
        if (name.equals("operationalStatus")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceMetric.operationalStatus");
        }
        if (name.equals("color")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceMetric.color");
        }
        if (name.equals(SP_CATEGORY)) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceMetric.category");
        }
        if (name.equals("measurementPeriod")) {
            this.measurementPeriod = new Timing();
            return this.measurementPeriod;
        }
        if (name.equals("calibration")) {
            return this.addCalibration();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DeviceMetric";
    }

    @Override
    public DeviceMetric copy() {
        DeviceMetric dst = new DeviceMetric();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DeviceMetric dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.unit = this.unit == null ? null : this.unit.copy();
        dst.source = this.source == null ? null : this.source.copy();
        dst.parent = this.parent == null ? null : this.parent.copy();
        dst.operationalStatus = this.operationalStatus == null ? null : this.operationalStatus.copy();
        dst.color = this.color == null ? null : this.color.copy();
        dst.category = this.category == null ? null : this.category.copy();
        Timing timing = dst.measurementPeriod = this.measurementPeriod == null ? null : this.measurementPeriod.copy();
        if (this.calibration != null) {
            dst.calibration = new ArrayList<DeviceMetricCalibrationComponent>();
            for (DeviceMetricCalibrationComponent deviceMetricCalibrationComponent : this.calibration) {
                dst.calibration.add(deviceMetricCalibrationComponent.copy());
            }
        }
    }

    protected DeviceMetric typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceMetric)) {
            return false;
        }
        DeviceMetric o = (DeviceMetric)other_;
        return DeviceMetric.compareDeep(this.identifier, o.identifier, true) && DeviceMetric.compareDeep(this.type, o.type, true) && DeviceMetric.compareDeep(this.unit, o.unit, true) && DeviceMetric.compareDeep(this.source, o.source, true) && DeviceMetric.compareDeep(this.parent, o.parent, true) && DeviceMetric.compareDeep(this.operationalStatus, o.operationalStatus, true) && DeviceMetric.compareDeep(this.color, o.color, true) && DeviceMetric.compareDeep(this.category, o.category, true) && DeviceMetric.compareDeep(this.measurementPeriod, o.measurementPeriod, true) && DeviceMetric.compareDeep(this.calibration, o.calibration, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceMetric)) {
            return false;
        }
        DeviceMetric o = (DeviceMetric)other_;
        return DeviceMetric.compareValues(this.operationalStatus, o.operationalStatus, true) && DeviceMetric.compareValues(this.color, o.color, true) && DeviceMetric.compareValues(this.category, o.category, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.type, this.unit, this.source, this.parent, this.operationalStatus, this.color, this.category, this.measurementPeriod, this.calibration);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DeviceMetric;
    }

    @Block
    public static class DeviceMetricCalibrationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="unspecified | offset | gain | two-point", formalDefinition="Describes the type of the calibration method.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/metric-calibration-type")
        protected Enumeration<DeviceMetricCalibrationType> type;
        @Child(name="state", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="not-calibrated | calibration-required | calibrated | unspecified", formalDefinition="Describes the state of the calibration.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/metric-calibration-state")
        protected Enumeration<DeviceMetricCalibrationState> state;
        @Child(name="time", type={InstantType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Describes the time last calibration has been performed", formalDefinition="Describes the time last calibration has been performed.")
        protected InstantType time;
        private static final long serialVersionUID = 1163986578L;

        public Enumeration<DeviceMetricCalibrationType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceMetricCalibrationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<DeviceMetricCalibrationType>(new DeviceMetricCalibrationTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DeviceMetricCalibrationComponent setTypeElement(Enumeration<DeviceMetricCalibrationType> value) {
            this.type = value;
            return this;
        }

        public DeviceMetricCalibrationType getType() {
            return this.type == null ? null : (DeviceMetricCalibrationType)((Object)this.type.getValue());
        }

        public DeviceMetricCalibrationComponent setType(DeviceMetricCalibrationType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<DeviceMetricCalibrationType>(new DeviceMetricCalibrationTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<DeviceMetricCalibrationState> getStateElement() {
            if (this.state == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceMetricCalibrationComponent.state");
                }
                if (Configuration.doAutoCreate()) {
                    this.state = new Enumeration<DeviceMetricCalibrationState>(new DeviceMetricCalibrationStateEnumFactory());
                }
            }
            return this.state;
        }

        public boolean hasStateElement() {
            return this.state != null && !this.state.isEmpty();
        }

        public boolean hasState() {
            return this.state != null && !this.state.isEmpty();
        }

        public DeviceMetricCalibrationComponent setStateElement(Enumeration<DeviceMetricCalibrationState> value) {
            this.state = value;
            return this;
        }

        public DeviceMetricCalibrationState getState() {
            return this.state == null ? null : (DeviceMetricCalibrationState)((Object)this.state.getValue());
        }

        public DeviceMetricCalibrationComponent setState(DeviceMetricCalibrationState value) {
            if (value == null) {
                this.state = null;
            } else {
                if (this.state == null) {
                    this.state = new Enumeration<DeviceMetricCalibrationState>(new DeviceMetricCalibrationStateEnumFactory());
                }
                this.state.setValue((Object)value);
            }
            return this;
        }

        public InstantType getTimeElement() {
            if (this.time == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceMetricCalibrationComponent.time");
                }
                if (Configuration.doAutoCreate()) {
                    this.time = new InstantType();
                }
            }
            return this.time;
        }

        public boolean hasTimeElement() {
            return this.time != null && !this.time.isEmpty();
        }

        public boolean hasTime() {
            return this.time != null && !this.time.isEmpty();
        }

        public DeviceMetricCalibrationComponent setTimeElement(InstantType value) {
            this.time = value;
            return this;
        }

        public Date getTime() {
            return this.time == null ? null : (Date)this.time.getValue();
        }

        public DeviceMetricCalibrationComponent setTime(Date value) {
            if (value == null) {
                this.time = null;
            } else {
                if (this.time == null) {
                    this.time = new InstantType();
                }
                this.time.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DeviceMetric.SP_TYPE, "code", "Describes the type of the calibration method.", 0, 1, this.type));
            children.add(new Property("state", "code", "Describes the state of the calibration.", 0, 1, this.state));
            children.add(new Property("time", "instant", "Describes the time last calibration has been performed.", 0, 1, this.time));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(DeviceMetric.SP_TYPE, "code", "Describes the type of the calibration method.", 0, 1, this.type);
                }
                case 109757585: {
                    return new Property("state", "code", "Describes the state of the calibration.", 0, 1, this.state);
                }
                case 3560141: {
                    return new Property("time", "instant", "Describes the time last calibration has been performed.", 0, 1, this.time);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 109757585: {
                    Base[] baseArray;
                    if (this.state == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.state;
                    }
                    return baseArray;
                }
                case 3560141: {
                    Base[] baseArray;
                    if (this.time == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.time;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new DeviceMetricCalibrationTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 109757585: {
                    value = new DeviceMetricCalibrationStateEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.state = value;
                    return value;
                }
                case 3560141: {
                    this.time = TypeConvertor.castToInstant(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DeviceMetric.SP_TYPE)) {
                value = new DeviceMetricCalibrationTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("state")) {
                value = new DeviceMetricCalibrationStateEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.state = value;
            } else if (name.equals("time")) {
                this.time = TypeConvertor.castToInstant(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 109757585: {
                    return this.getStateElement();
                }
                case 3560141: {
                    return this.getTimeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 109757585: {
                    return new String[]{"code"};
                }
                case 3560141: {
                    return new String[]{"instant"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DeviceMetric.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceMetric.calibration.type");
            }
            if (name.equals("state")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceMetric.calibration.state");
            }
            if (name.equals("time")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceMetric.calibration.time");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceMetricCalibrationComponent copy() {
            DeviceMetricCalibrationComponent dst = new DeviceMetricCalibrationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceMetricCalibrationComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.state = this.state == null ? null : this.state.copy();
            dst.time = this.time == null ? null : this.time.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceMetricCalibrationComponent)) {
                return false;
            }
            DeviceMetricCalibrationComponent o = (DeviceMetricCalibrationComponent)other_;
            return DeviceMetricCalibrationComponent.compareDeep(this.type, o.type, true) && DeviceMetricCalibrationComponent.compareDeep(this.state, o.state, true) && DeviceMetricCalibrationComponent.compareDeep(this.time, o.time, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceMetricCalibrationComponent)) {
                return false;
            }
            DeviceMetricCalibrationComponent o = (DeviceMetricCalibrationComponent)other_;
            return DeviceMetricCalibrationComponent.compareValues(this.type, o.type, true) && DeviceMetricCalibrationComponent.compareValues(this.state, o.state, true) && DeviceMetricCalibrationComponent.compareValues(this.time, o.time, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.state, this.time);
        }

        @Override
        public String fhirType() {
            return "DeviceMetric.calibration";
        }
    }

    public static class DeviceMetricOperationalStatusEnumFactory
    implements EnumFactory<DeviceMetricOperationalStatus> {
        @Override
        public DeviceMetricOperationalStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("on".equals(codeString)) {
                return DeviceMetricOperationalStatus.ON;
            }
            if ("off".equals(codeString)) {
                return DeviceMetricOperationalStatus.OFF;
            }
            if ("standby".equals(codeString)) {
                return DeviceMetricOperationalStatus.STANDBY;
            }
            if ("entered-in-error".equals(codeString)) {
                return DeviceMetricOperationalStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown DeviceMetricOperationalStatus code '" + codeString + "'");
        }

        public Enumeration<DeviceMetricOperationalStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DeviceMetricOperationalStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("on".equals(codeString)) {
                return new Enumeration<DeviceMetricOperationalStatus>(this, DeviceMetricOperationalStatus.ON);
            }
            if ("off".equals(codeString)) {
                return new Enumeration<DeviceMetricOperationalStatus>(this, DeviceMetricOperationalStatus.OFF);
            }
            if ("standby".equals(codeString)) {
                return new Enumeration<DeviceMetricOperationalStatus>(this, DeviceMetricOperationalStatus.STANDBY);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<DeviceMetricOperationalStatus>(this, DeviceMetricOperationalStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown DeviceMetricOperationalStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceMetricOperationalStatus code) {
            if (code == DeviceMetricOperationalStatus.ON) {
                return "on";
            }
            if (code == DeviceMetricOperationalStatus.OFF) {
                return "off";
            }
            if (code == DeviceMetricOperationalStatus.STANDBY) {
                return "standby";
            }
            if (code == DeviceMetricOperationalStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(DeviceMetricOperationalStatus code) {
            return code.getSystem();
        }
    }

    public static enum DeviceMetricOperationalStatus {
        ON,
        OFF,
        STANDBY,
        ENTEREDINERROR,
        NULL;


        public static DeviceMetricOperationalStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("on".equals(codeString)) {
                return ON;
            }
            if ("off".equals(codeString)) {
                return OFF;
            }
            if ("standby".equals(codeString)) {
                return STANDBY;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DeviceMetricOperationalStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ON: {
                    return "on";
                }
                case OFF: {
                    return "off";
                }
                case STANDBY: {
                    return "standby";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ON: {
                    return "http://hl7.org/fhir/metric-operational-status";
                }
                case OFF: {
                    return "http://hl7.org/fhir/metric-operational-status";
                }
                case STANDBY: {
                    return "http://hl7.org/fhir/metric-operational-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/metric-operational-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ON: {
                    return "The DeviceMetric is operating and will generate DeviceObservations.";
                }
                case OFF: {
                    return "The DeviceMetric is not operating.";
                }
                case STANDBY: {
                    return "The DeviceMetric is operating, but will not generate any DeviceObservations.";
                }
                case ENTEREDINERROR: {
                    return "The DeviceMetric was entered in error.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ON: {
                    return "On";
                }
                case OFF: {
                    return "Off";
                }
                case STANDBY: {
                    return "Standby";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
            }
            return "?";
        }
    }

    public static class DeviceMetricColorEnumFactory
    implements EnumFactory<DeviceMetricColor> {
        @Override
        public DeviceMetricColor fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("black".equals(codeString)) {
                return DeviceMetricColor.BLACK;
            }
            if ("red".equals(codeString)) {
                return DeviceMetricColor.RED;
            }
            if ("green".equals(codeString)) {
                return DeviceMetricColor.GREEN;
            }
            if ("yellow".equals(codeString)) {
                return DeviceMetricColor.YELLOW;
            }
            if ("blue".equals(codeString)) {
                return DeviceMetricColor.BLUE;
            }
            if ("magenta".equals(codeString)) {
                return DeviceMetricColor.MAGENTA;
            }
            if ("cyan".equals(codeString)) {
                return DeviceMetricColor.CYAN;
            }
            if ("white".equals(codeString)) {
                return DeviceMetricColor.WHITE;
            }
            throw new IllegalArgumentException("Unknown DeviceMetricColor code '" + codeString + "'");
        }

        public Enumeration<DeviceMetricColor> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DeviceMetricColor>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("black".equals(codeString)) {
                return new Enumeration<DeviceMetricColor>(this, DeviceMetricColor.BLACK);
            }
            if ("red".equals(codeString)) {
                return new Enumeration<DeviceMetricColor>(this, DeviceMetricColor.RED);
            }
            if ("green".equals(codeString)) {
                return new Enumeration<DeviceMetricColor>(this, DeviceMetricColor.GREEN);
            }
            if ("yellow".equals(codeString)) {
                return new Enumeration<DeviceMetricColor>(this, DeviceMetricColor.YELLOW);
            }
            if ("blue".equals(codeString)) {
                return new Enumeration<DeviceMetricColor>(this, DeviceMetricColor.BLUE);
            }
            if ("magenta".equals(codeString)) {
                return new Enumeration<DeviceMetricColor>(this, DeviceMetricColor.MAGENTA);
            }
            if ("cyan".equals(codeString)) {
                return new Enumeration<DeviceMetricColor>(this, DeviceMetricColor.CYAN);
            }
            if ("white".equals(codeString)) {
                return new Enumeration<DeviceMetricColor>(this, DeviceMetricColor.WHITE);
            }
            throw new FHIRException("Unknown DeviceMetricColor code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceMetricColor code) {
            if (code == DeviceMetricColor.BLACK) {
                return "black";
            }
            if (code == DeviceMetricColor.RED) {
                return "red";
            }
            if (code == DeviceMetricColor.GREEN) {
                return "green";
            }
            if (code == DeviceMetricColor.YELLOW) {
                return "yellow";
            }
            if (code == DeviceMetricColor.BLUE) {
                return "blue";
            }
            if (code == DeviceMetricColor.MAGENTA) {
                return "magenta";
            }
            if (code == DeviceMetricColor.CYAN) {
                return "cyan";
            }
            if (code == DeviceMetricColor.WHITE) {
                return "white";
            }
            return "?";
        }

        @Override
        public String toSystem(DeviceMetricColor code) {
            return code.getSystem();
        }
    }

    public static enum DeviceMetricColor {
        BLACK,
        RED,
        GREEN,
        YELLOW,
        BLUE,
        MAGENTA,
        CYAN,
        WHITE,
        NULL;


        public static DeviceMetricColor fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("black".equals(codeString)) {
                return BLACK;
            }
            if ("red".equals(codeString)) {
                return RED;
            }
            if ("green".equals(codeString)) {
                return GREEN;
            }
            if ("yellow".equals(codeString)) {
                return YELLOW;
            }
            if ("blue".equals(codeString)) {
                return BLUE;
            }
            if ("magenta".equals(codeString)) {
                return MAGENTA;
            }
            if ("cyan".equals(codeString)) {
                return CYAN;
            }
            if ("white".equals(codeString)) {
                return WHITE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DeviceMetricColor code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case BLACK: {
                    return "black";
                }
                case RED: {
                    return "red";
                }
                case GREEN: {
                    return "green";
                }
                case YELLOW: {
                    return "yellow";
                }
                case BLUE: {
                    return "blue";
                }
                case MAGENTA: {
                    return "magenta";
                }
                case CYAN: {
                    return "cyan";
                }
                case WHITE: {
                    return "white";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case BLACK: {
                    return "http://hl7.org/fhir/metric-color";
                }
                case RED: {
                    return "http://hl7.org/fhir/metric-color";
                }
                case GREEN: {
                    return "http://hl7.org/fhir/metric-color";
                }
                case YELLOW: {
                    return "http://hl7.org/fhir/metric-color";
                }
                case BLUE: {
                    return "http://hl7.org/fhir/metric-color";
                }
                case MAGENTA: {
                    return "http://hl7.org/fhir/metric-color";
                }
                case CYAN: {
                    return "http://hl7.org/fhir/metric-color";
                }
                case WHITE: {
                    return "http://hl7.org/fhir/metric-color";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case BLACK: {
                    return "Color for representation - black.";
                }
                case RED: {
                    return "Color for representation - red.";
                }
                case GREEN: {
                    return "Color for representation - green.";
                }
                case YELLOW: {
                    return "Color for representation - yellow.";
                }
                case BLUE: {
                    return "Color for representation - blue.";
                }
                case MAGENTA: {
                    return "Color for representation - magenta.";
                }
                case CYAN: {
                    return "Color for representation - cyan.";
                }
                case WHITE: {
                    return "Color for representation - white.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case BLACK: {
                    return "Color Black";
                }
                case RED: {
                    return "Color Red";
                }
                case GREEN: {
                    return "Color Green";
                }
                case YELLOW: {
                    return "Color Yellow";
                }
                case BLUE: {
                    return "Color Blue";
                }
                case MAGENTA: {
                    return "Color Magenta";
                }
                case CYAN: {
                    return "Color Cyan";
                }
                case WHITE: {
                    return "Color White";
                }
            }
            return "?";
        }
    }

    public static class DeviceMetricCategoryEnumFactory
    implements EnumFactory<DeviceMetricCategory> {
        @Override
        public DeviceMetricCategory fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("measurement".equals(codeString)) {
                return DeviceMetricCategory.MEASUREMENT;
            }
            if ("setting".equals(codeString)) {
                return DeviceMetricCategory.SETTING;
            }
            if ("calculation".equals(codeString)) {
                return DeviceMetricCategory.CALCULATION;
            }
            if ("unspecified".equals(codeString)) {
                return DeviceMetricCategory.UNSPECIFIED;
            }
            throw new IllegalArgumentException("Unknown DeviceMetricCategory code '" + codeString + "'");
        }

        public Enumeration<DeviceMetricCategory> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DeviceMetricCategory>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("measurement".equals(codeString)) {
                return new Enumeration<DeviceMetricCategory>(this, DeviceMetricCategory.MEASUREMENT);
            }
            if ("setting".equals(codeString)) {
                return new Enumeration<DeviceMetricCategory>(this, DeviceMetricCategory.SETTING);
            }
            if ("calculation".equals(codeString)) {
                return new Enumeration<DeviceMetricCategory>(this, DeviceMetricCategory.CALCULATION);
            }
            if ("unspecified".equals(codeString)) {
                return new Enumeration<DeviceMetricCategory>(this, DeviceMetricCategory.UNSPECIFIED);
            }
            throw new FHIRException("Unknown DeviceMetricCategory code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceMetricCategory code) {
            if (code == DeviceMetricCategory.MEASUREMENT) {
                return "measurement";
            }
            if (code == DeviceMetricCategory.SETTING) {
                return "setting";
            }
            if (code == DeviceMetricCategory.CALCULATION) {
                return "calculation";
            }
            if (code == DeviceMetricCategory.UNSPECIFIED) {
                return "unspecified";
            }
            return "?";
        }

        @Override
        public String toSystem(DeviceMetricCategory code) {
            return code.getSystem();
        }
    }

    public static enum DeviceMetricCategory {
        MEASUREMENT,
        SETTING,
        CALCULATION,
        UNSPECIFIED,
        NULL;


        public static DeviceMetricCategory fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("measurement".equals(codeString)) {
                return MEASUREMENT;
            }
            if ("setting".equals(codeString)) {
                return SETTING;
            }
            if ("calculation".equals(codeString)) {
                return CALCULATION;
            }
            if ("unspecified".equals(codeString)) {
                return UNSPECIFIED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DeviceMetricCategory code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MEASUREMENT: {
                    return "measurement";
                }
                case SETTING: {
                    return "setting";
                }
                case CALCULATION: {
                    return "calculation";
                }
                case UNSPECIFIED: {
                    return "unspecified";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MEASUREMENT: {
                    return "http://hl7.org/fhir/metric-category";
                }
                case SETTING: {
                    return "http://hl7.org/fhir/metric-category";
                }
                case CALCULATION: {
                    return "http://hl7.org/fhir/metric-category";
                }
                case UNSPECIFIED: {
                    return "http://hl7.org/fhir/metric-category";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MEASUREMENT: {
                    return "DeviceObservations generated for this DeviceMetric are measured.";
                }
                case SETTING: {
                    return "DeviceObservations generated for this DeviceMetric is a setting that will influence the behavior of the Device.";
                }
                case CALCULATION: {
                    return "DeviceObservations generated for this DeviceMetric are calculated.";
                }
                case UNSPECIFIED: {
                    return "The category of this DeviceMetric is unspecified.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MEASUREMENT: {
                    return "Measurement";
                }
                case SETTING: {
                    return "Setting";
                }
                case CALCULATION: {
                    return "Calculation";
                }
                case UNSPECIFIED: {
                    return "Unspecified";
                }
            }
            return "?";
        }
    }

    public static class DeviceMetricCalibrationTypeEnumFactory
    implements EnumFactory<DeviceMetricCalibrationType> {
        @Override
        public DeviceMetricCalibrationType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("unspecified".equals(codeString)) {
                return DeviceMetricCalibrationType.UNSPECIFIED;
            }
            if ("offset".equals(codeString)) {
                return DeviceMetricCalibrationType.OFFSET;
            }
            if ("gain".equals(codeString)) {
                return DeviceMetricCalibrationType.GAIN;
            }
            if ("two-point".equals(codeString)) {
                return DeviceMetricCalibrationType.TWOPOINT;
            }
            throw new IllegalArgumentException("Unknown DeviceMetricCalibrationType code '" + codeString + "'");
        }

        public Enumeration<DeviceMetricCalibrationType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DeviceMetricCalibrationType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("unspecified".equals(codeString)) {
                return new Enumeration<DeviceMetricCalibrationType>(this, DeviceMetricCalibrationType.UNSPECIFIED);
            }
            if ("offset".equals(codeString)) {
                return new Enumeration<DeviceMetricCalibrationType>(this, DeviceMetricCalibrationType.OFFSET);
            }
            if ("gain".equals(codeString)) {
                return new Enumeration<DeviceMetricCalibrationType>(this, DeviceMetricCalibrationType.GAIN);
            }
            if ("two-point".equals(codeString)) {
                return new Enumeration<DeviceMetricCalibrationType>(this, DeviceMetricCalibrationType.TWOPOINT);
            }
            throw new FHIRException("Unknown DeviceMetricCalibrationType code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceMetricCalibrationType code) {
            if (code == DeviceMetricCalibrationType.UNSPECIFIED) {
                return "unspecified";
            }
            if (code == DeviceMetricCalibrationType.OFFSET) {
                return "offset";
            }
            if (code == DeviceMetricCalibrationType.GAIN) {
                return "gain";
            }
            if (code == DeviceMetricCalibrationType.TWOPOINT) {
                return "two-point";
            }
            return "?";
        }

        @Override
        public String toSystem(DeviceMetricCalibrationType code) {
            return code.getSystem();
        }
    }

    public static enum DeviceMetricCalibrationType {
        UNSPECIFIED,
        OFFSET,
        GAIN,
        TWOPOINT,
        NULL;


        public static DeviceMetricCalibrationType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("unspecified".equals(codeString)) {
                return UNSPECIFIED;
            }
            if ("offset".equals(codeString)) {
                return OFFSET;
            }
            if ("gain".equals(codeString)) {
                return GAIN;
            }
            if ("two-point".equals(codeString)) {
                return TWOPOINT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DeviceMetricCalibrationType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case UNSPECIFIED: {
                    return "unspecified";
                }
                case OFFSET: {
                    return "offset";
                }
                case GAIN: {
                    return "gain";
                }
                case TWOPOINT: {
                    return "two-point";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case UNSPECIFIED: {
                    return "http://hl7.org/fhir/metric-calibration-type";
                }
                case OFFSET: {
                    return "http://hl7.org/fhir/metric-calibration-type";
                }
                case GAIN: {
                    return "http://hl7.org/fhir/metric-calibration-type";
                }
                case TWOPOINT: {
                    return "http://hl7.org/fhir/metric-calibration-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case UNSPECIFIED: {
                    return "Metric calibration method has not been identified.";
                }
                case OFFSET: {
                    return "Offset metric calibration method.";
                }
                case GAIN: {
                    return "Gain metric calibration method.";
                }
                case TWOPOINT: {
                    return "Two-point metric calibration method.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case UNSPECIFIED: {
                    return "Unspecified";
                }
                case OFFSET: {
                    return "Offset";
                }
                case GAIN: {
                    return "Gain";
                }
                case TWOPOINT: {
                    return "Two Point";
                }
            }
            return "?";
        }
    }

    public static class DeviceMetricCalibrationStateEnumFactory
    implements EnumFactory<DeviceMetricCalibrationState> {
        @Override
        public DeviceMetricCalibrationState fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("not-calibrated".equals(codeString)) {
                return DeviceMetricCalibrationState.NOTCALIBRATED;
            }
            if ("calibration-required".equals(codeString)) {
                return DeviceMetricCalibrationState.CALIBRATIONREQUIRED;
            }
            if ("calibrated".equals(codeString)) {
                return DeviceMetricCalibrationState.CALIBRATED;
            }
            if ("unspecified".equals(codeString)) {
                return DeviceMetricCalibrationState.UNSPECIFIED;
            }
            throw new IllegalArgumentException("Unknown DeviceMetricCalibrationState code '" + codeString + "'");
        }

        public Enumeration<DeviceMetricCalibrationState> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DeviceMetricCalibrationState>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-calibrated".equals(codeString)) {
                return new Enumeration<DeviceMetricCalibrationState>(this, DeviceMetricCalibrationState.NOTCALIBRATED);
            }
            if ("calibration-required".equals(codeString)) {
                return new Enumeration<DeviceMetricCalibrationState>(this, DeviceMetricCalibrationState.CALIBRATIONREQUIRED);
            }
            if ("calibrated".equals(codeString)) {
                return new Enumeration<DeviceMetricCalibrationState>(this, DeviceMetricCalibrationState.CALIBRATED);
            }
            if ("unspecified".equals(codeString)) {
                return new Enumeration<DeviceMetricCalibrationState>(this, DeviceMetricCalibrationState.UNSPECIFIED);
            }
            throw new FHIRException("Unknown DeviceMetricCalibrationState code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceMetricCalibrationState code) {
            if (code == DeviceMetricCalibrationState.NOTCALIBRATED) {
                return "not-calibrated";
            }
            if (code == DeviceMetricCalibrationState.CALIBRATIONREQUIRED) {
                return "calibration-required";
            }
            if (code == DeviceMetricCalibrationState.CALIBRATED) {
                return "calibrated";
            }
            if (code == DeviceMetricCalibrationState.UNSPECIFIED) {
                return "unspecified";
            }
            return "?";
        }

        @Override
        public String toSystem(DeviceMetricCalibrationState code) {
            return code.getSystem();
        }
    }

    public static enum DeviceMetricCalibrationState {
        NOTCALIBRATED,
        CALIBRATIONREQUIRED,
        CALIBRATED,
        UNSPECIFIED,
        NULL;


        public static DeviceMetricCalibrationState fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-calibrated".equals(codeString)) {
                return NOTCALIBRATED;
            }
            if ("calibration-required".equals(codeString)) {
                return CALIBRATIONREQUIRED;
            }
            if ("calibrated".equals(codeString)) {
                return CALIBRATED;
            }
            if ("unspecified".equals(codeString)) {
                return UNSPECIFIED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DeviceMetricCalibrationState code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NOTCALIBRATED: {
                    return "not-calibrated";
                }
                case CALIBRATIONREQUIRED: {
                    return "calibration-required";
                }
                case CALIBRATED: {
                    return "calibrated";
                }
                case UNSPECIFIED: {
                    return "unspecified";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NOTCALIBRATED: {
                    return "http://hl7.org/fhir/metric-calibration-state";
                }
                case CALIBRATIONREQUIRED: {
                    return "http://hl7.org/fhir/metric-calibration-state";
                }
                case CALIBRATED: {
                    return "http://hl7.org/fhir/metric-calibration-state";
                }
                case UNSPECIFIED: {
                    return "http://hl7.org/fhir/metric-calibration-state";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NOTCALIBRATED: {
                    return "The metric has not been calibrated.";
                }
                case CALIBRATIONREQUIRED: {
                    return "The metric needs to be calibrated.";
                }
                case CALIBRATED: {
                    return "The metric has been calibrated.";
                }
                case UNSPECIFIED: {
                    return "The state of calibration of this metric is unspecified.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NOTCALIBRATED: {
                    return "Not Calibrated";
                }
                case CALIBRATIONREQUIRED: {
                    return "Calibration Required";
                }
                case CALIBRATED: {
                    return "Calibrated";
                }
                case UNSPECIFIED: {
                    return "Unspecified";
                }
            }
            return "?";
        }
    }
}

