/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="CatalogEntry", profile="http://hl7.org/fhir/StructureDefinition/CatalogEntry")
public class CatalogEntry
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier of the catalog entry", formalDefinition="Business identifier uniquely assigned to the catalog entry.")
    protected List<Identifier> identifier;
    @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Displayable name assigned to the catalog entry", formalDefinition="The name of this catalog entry announces the item that is represented by the entry.")
    protected StringType name;
    @Child(name="type", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="ActivityDefinition | PlanDefinition | SpecimenDefinition | ObservationDefinition | DeviceDefinition | Organization | Practitioner | PractitionerRole | HealthcareService | MedicationKnowledge | Medication | Substance | Location", formalDefinition="The type of resource that is represented by this catalog entry.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/catalogentry-type")
    protected Enumeration<CatalogEntryType> type;
    @Child(name="status", type={CodeType.class}, order=3, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired", formalDefinition="Indicates whether this catalog entry is open to public usage (active) or not (draft or retired).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/catalogentry-status")
    protected Enumeration<CatalogEntryStatus> status;
    @Child(name="effectivePeriod", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When this catalog entry is expected to be active", formalDefinition="Period of usability of the catalog entry.")
    protected Period effectivePeriod;
    @Child(name="orderable", type={BooleanType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Is orderable", formalDefinition="Indicates whether or not the entry represents an item that is orderable.")
    protected BooleanType orderable;
    @Child(name="referencedItem", type={DeviceDefinition.class, Organization.class, Practitioner.class, PractitionerRole.class, HealthcareService.class, ActivityDefinition.class, PlanDefinition.class, SpecimenDefinition.class, ObservationDefinition.class, MedicationKnowledge.class, Substance.class, Location.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Item attached to this entry of the catalog", formalDefinition="The item (resource) that this entry of the catalog represents.")
    protected Reference referencedItem;
    @Child(name="relatedEntry", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Another entry of the catalog related to this one", formalDefinition="Used for example, to point to a substance, or to a device used to administer a medication.")
    protected List<CatalogEntryRelatedEntryComponent> relatedEntry;
    @Child(name="updatedBy", type={Person.class, Device.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Last updater of this catalog entry", formalDefinition="Last actor who recorded (created or updated) this catalog entry.")
    protected Reference updatedBy;
    @Child(name="note", type={Annotation.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Notes and comments about this catalog entry", formalDefinition="Notes and comments about this catalog entry.")
    protected List<Annotation> note;
    @Child(name="estimatedDuration", type={Duration.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Estimated duration of the orderable item", formalDefinition="Estimated duration of the orderable item of this  entry of the catalog.")
    protected Duration estimatedDuration;
    @Child(name="billingCode", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Billing code in the context of this catalog entry", formalDefinition="Billing code associated to the  item in the context of this  entry of the catalog.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/cpt-all")
    protected List<CodeableConcept> billingCode;
    @Child(name="billingSummary", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Billing summary in the context of this catalog entry", formalDefinition="Billing summary attached to the  item in the context of this  entry of the catalog.")
    protected StringType billingSummary;
    @Child(name="scheduleSummary", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Schedule summary for the catalog entry", formalDefinition="Schedule summary for the  item in the context of this  entry of the catalog.")
    protected StringType scheduleSummary;
    @Child(name="limitationSummary", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Summary of limitations for the catalog entry", formalDefinition="Summary of limitations for the  item in the context of this  entry of the catalog.")
    protected StringType limitationSummary;
    @Child(name="regulatorySummary", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Regulatory  summary for the catalog entry", formalDefinition="Regulatory summary for the  item in the context of this  entry of the catalog.")
    protected StringType regulatorySummary;
    private static final long serialVersionUID = -2010989359L;
    @SearchParamDefinition(name="identifier", path="CatalogEntry.identifier", description="Business identifier of the catalog entry", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="CatalogEntry.name", description="Displayable name assigned to the catalog entry", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="orderable", path="CatalogEntry.orderable", description="Is orderable", type="token")
    public static final String SP_ORDERABLE = "orderable";
    public static final TokenClientParam ORDERABLE = new TokenClientParam("orderable");
    @SearchParamDefinition(name="referenced-item", path="CatalogEntry.referencedItem", description="Item attached to this entry of the catalog", type="reference", target={ActivityDefinition.class, DeviceDefinition.class, HealthcareService.class, Location.class, MedicationKnowledge.class, ObservationDefinition.class, Organization.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, SpecimenDefinition.class, Substance.class})
    public static final String SP_REFERENCED_ITEM = "referenced-item";
    public static final ReferenceClientParam REFERENCED_ITEM = new ReferenceClientParam("referenced-item");
    public static final Include INCLUDE_REFERENCED_ITEM = new Include("CatalogEntry:referenced-item").toLocked();
    @SearchParamDefinition(name="related-entry", path="CatalogEntry.relatedEntry.target", description="The reference to the related entry", type="reference", target={CatalogEntry.class})
    public static final String SP_RELATED_ENTRY = "related-entry";
    public static final ReferenceClientParam RELATED_ENTRY = new ReferenceClientParam("related-entry");
    public static final Include INCLUDE_RELATED_ENTRY = new Include("CatalogEntry:related-entry").toLocked();
    @SearchParamDefinition(name="status", path="CatalogEntry.status", description="Usability status of this entry in the catalog", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="type", path="CatalogEntry.type", description="ActivityDefinition | PlanDefinition | SpecimenDefinition | ObservationDefinition | DeviceDefinition | Organization | Practitioner | PractitionerRole | HealthcareService | MedicationKnowledge | Medication | Substance | Location", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public CatalogEntry() {
    }

    public CatalogEntry(boolean orderable, Reference referencedItem) {
        this.setOrderable(orderable);
        this.setReferencedItem(referencedItem);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public CatalogEntry setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public CatalogEntry addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public CatalogEntry setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public CatalogEntry setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public Enumeration<CatalogEntryType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<CatalogEntryType>(new CatalogEntryTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public CatalogEntry setTypeElement(Enumeration<CatalogEntryType> value) {
        this.type = value;
        return this;
    }

    public CatalogEntryType getType() {
        return this.type == null ? null : (CatalogEntryType)((Object)this.type.getValue());
    }

    public CatalogEntry setType(CatalogEntryType value) {
        if (value == null) {
            this.type = null;
        } else {
            if (this.type == null) {
                this.type = new Enumeration<CatalogEntryType>(new CatalogEntryTypeEnumFactory());
            }
            this.type.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<CatalogEntryStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<CatalogEntryStatus>(new CatalogEntryStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public CatalogEntry setStatusElement(Enumeration<CatalogEntryStatus> value) {
        this.status = value;
        return this;
    }

    public CatalogEntryStatus getStatus() {
        return this.status == null ? null : (CatalogEntryStatus)((Object)this.status.getValue());
    }

    public CatalogEntry setStatus(CatalogEntryStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<CatalogEntryStatus>(new CatalogEntryStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public CatalogEntry setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    public BooleanType getOrderableElement() {
        if (this.orderable == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.orderable");
            }
            if (Configuration.doAutoCreate()) {
                this.orderable = new BooleanType();
            }
        }
        return this.orderable;
    }

    public boolean hasOrderableElement() {
        return this.orderable != null && !this.orderable.isEmpty();
    }

    public boolean hasOrderable() {
        return this.orderable != null && !this.orderable.isEmpty();
    }

    public CatalogEntry setOrderableElement(BooleanType value) {
        this.orderable = value;
        return this;
    }

    public boolean getOrderable() {
        return this.orderable == null || this.orderable.isEmpty() ? false : (Boolean)this.orderable.getValue();
    }

    public CatalogEntry setOrderable(boolean value) {
        if (this.orderable == null) {
            this.orderable = new BooleanType();
        }
        this.orderable.setValue((Object)value);
        return this;
    }

    public Reference getReferencedItem() {
        if (this.referencedItem == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.referencedItem");
            }
            if (Configuration.doAutoCreate()) {
                this.referencedItem = new Reference();
            }
        }
        return this.referencedItem;
    }

    public boolean hasReferencedItem() {
        return this.referencedItem != null && !this.referencedItem.isEmpty();
    }

    public CatalogEntry setReferencedItem(Reference value) {
        this.referencedItem = value;
        return this;
    }

    public List<CatalogEntryRelatedEntryComponent> getRelatedEntry() {
        if (this.relatedEntry == null) {
            this.relatedEntry = new ArrayList<CatalogEntryRelatedEntryComponent>();
        }
        return this.relatedEntry;
    }

    public CatalogEntry setRelatedEntry(List<CatalogEntryRelatedEntryComponent> theRelatedEntry) {
        this.relatedEntry = theRelatedEntry;
        return this;
    }

    public boolean hasRelatedEntry() {
        if (this.relatedEntry == null) {
            return false;
        }
        for (CatalogEntryRelatedEntryComponent item : this.relatedEntry) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CatalogEntryRelatedEntryComponent addRelatedEntry() {
        CatalogEntryRelatedEntryComponent t = new CatalogEntryRelatedEntryComponent();
        if (this.relatedEntry == null) {
            this.relatedEntry = new ArrayList<CatalogEntryRelatedEntryComponent>();
        }
        this.relatedEntry.add(t);
        return t;
    }

    public CatalogEntry addRelatedEntry(CatalogEntryRelatedEntryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relatedEntry == null) {
            this.relatedEntry = new ArrayList<CatalogEntryRelatedEntryComponent>();
        }
        this.relatedEntry.add(t);
        return this;
    }

    public CatalogEntryRelatedEntryComponent getRelatedEntryFirstRep() {
        if (this.getRelatedEntry().isEmpty()) {
            this.addRelatedEntry();
        }
        return this.getRelatedEntry().get(0);
    }

    public Reference getUpdatedBy() {
        if (this.updatedBy == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.updatedBy");
            }
            if (Configuration.doAutoCreate()) {
                this.updatedBy = new Reference();
            }
        }
        return this.updatedBy;
    }

    public boolean hasUpdatedBy() {
        return this.updatedBy != null && !this.updatedBy.isEmpty();
    }

    public CatalogEntry setUpdatedBy(Reference value) {
        this.updatedBy = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public CatalogEntry setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public CatalogEntry addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public Duration getEstimatedDuration() {
        if (this.estimatedDuration == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.estimatedDuration");
            }
            if (Configuration.doAutoCreate()) {
                this.estimatedDuration = new Duration();
            }
        }
        return this.estimatedDuration;
    }

    public boolean hasEstimatedDuration() {
        return this.estimatedDuration != null && !this.estimatedDuration.isEmpty();
    }

    public CatalogEntry setEstimatedDuration(Duration value) {
        this.estimatedDuration = value;
        return this;
    }

    public List<CodeableConcept> getBillingCode() {
        if (this.billingCode == null) {
            this.billingCode = new ArrayList<CodeableConcept>();
        }
        return this.billingCode;
    }

    public CatalogEntry setBillingCode(List<CodeableConcept> theBillingCode) {
        this.billingCode = theBillingCode;
        return this;
    }

    public boolean hasBillingCode() {
        if (this.billingCode == null) {
            return false;
        }
        for (CodeableConcept item : this.billingCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addBillingCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.billingCode == null) {
            this.billingCode = new ArrayList<CodeableConcept>();
        }
        this.billingCode.add(t);
        return t;
    }

    public CatalogEntry addBillingCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.billingCode == null) {
            this.billingCode = new ArrayList<CodeableConcept>();
        }
        this.billingCode.add(t);
        return this;
    }

    public CodeableConcept getBillingCodeFirstRep() {
        if (this.getBillingCode().isEmpty()) {
            this.addBillingCode();
        }
        return this.getBillingCode().get(0);
    }

    public StringType getBillingSummaryElement() {
        if (this.billingSummary == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.billingSummary");
            }
            if (Configuration.doAutoCreate()) {
                this.billingSummary = new StringType();
            }
        }
        return this.billingSummary;
    }

    public boolean hasBillingSummaryElement() {
        return this.billingSummary != null && !this.billingSummary.isEmpty();
    }

    public boolean hasBillingSummary() {
        return this.billingSummary != null && !this.billingSummary.isEmpty();
    }

    public CatalogEntry setBillingSummaryElement(StringType value) {
        this.billingSummary = value;
        return this;
    }

    public String getBillingSummary() {
        return this.billingSummary == null ? null : (String)this.billingSummary.getValue();
    }

    public CatalogEntry setBillingSummary(String value) {
        if (Utilities.noString(value)) {
            this.billingSummary = null;
        } else {
            if (this.billingSummary == null) {
                this.billingSummary = new StringType();
            }
            this.billingSummary.setValue(value);
        }
        return this;
    }

    public StringType getScheduleSummaryElement() {
        if (this.scheduleSummary == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.scheduleSummary");
            }
            if (Configuration.doAutoCreate()) {
                this.scheduleSummary = new StringType();
            }
        }
        return this.scheduleSummary;
    }

    public boolean hasScheduleSummaryElement() {
        return this.scheduleSummary != null && !this.scheduleSummary.isEmpty();
    }

    public boolean hasScheduleSummary() {
        return this.scheduleSummary != null && !this.scheduleSummary.isEmpty();
    }

    public CatalogEntry setScheduleSummaryElement(StringType value) {
        this.scheduleSummary = value;
        return this;
    }

    public String getScheduleSummary() {
        return this.scheduleSummary == null ? null : (String)this.scheduleSummary.getValue();
    }

    public CatalogEntry setScheduleSummary(String value) {
        if (Utilities.noString(value)) {
            this.scheduleSummary = null;
        } else {
            if (this.scheduleSummary == null) {
                this.scheduleSummary = new StringType();
            }
            this.scheduleSummary.setValue(value);
        }
        return this;
    }

    public StringType getLimitationSummaryElement() {
        if (this.limitationSummary == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.limitationSummary");
            }
            if (Configuration.doAutoCreate()) {
                this.limitationSummary = new StringType();
            }
        }
        return this.limitationSummary;
    }

    public boolean hasLimitationSummaryElement() {
        return this.limitationSummary != null && !this.limitationSummary.isEmpty();
    }

    public boolean hasLimitationSummary() {
        return this.limitationSummary != null && !this.limitationSummary.isEmpty();
    }

    public CatalogEntry setLimitationSummaryElement(StringType value) {
        this.limitationSummary = value;
        return this;
    }

    public String getLimitationSummary() {
        return this.limitationSummary == null ? null : (String)this.limitationSummary.getValue();
    }

    public CatalogEntry setLimitationSummary(String value) {
        if (Utilities.noString(value)) {
            this.limitationSummary = null;
        } else {
            if (this.limitationSummary == null) {
                this.limitationSummary = new StringType();
            }
            this.limitationSummary.setValue(value);
        }
        return this;
    }

    public StringType getRegulatorySummaryElement() {
        if (this.regulatorySummary == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.regulatorySummary");
            }
            if (Configuration.doAutoCreate()) {
                this.regulatorySummary = new StringType();
            }
        }
        return this.regulatorySummary;
    }

    public boolean hasRegulatorySummaryElement() {
        return this.regulatorySummary != null && !this.regulatorySummary.isEmpty();
    }

    public boolean hasRegulatorySummary() {
        return this.regulatorySummary != null && !this.regulatorySummary.isEmpty();
    }

    public CatalogEntry setRegulatorySummaryElement(StringType value) {
        this.regulatorySummary = value;
        return this;
    }

    public String getRegulatorySummary() {
        return this.regulatorySummary == null ? null : (String)this.regulatorySummary.getValue();
    }

    public CatalogEntry setRegulatorySummary(String value) {
        if (Utilities.noString(value)) {
            this.regulatorySummary = null;
        } else {
            if (this.regulatorySummary == null) {
                this.regulatorySummary = new StringType();
            }
            this.regulatorySummary.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier uniquely assigned to the catalog entry.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_NAME, "string", "The name of this catalog entry announces the item that is represented by the entry.", 0, 1, this.name));
        children.add(new Property(SP_TYPE, "code", "The type of resource that is represented by this catalog entry.", 0, 1, this.type));
        children.add(new Property(SP_STATUS, "code", "Indicates whether this catalog entry is open to public usage (active) or not (draft or retired).", 0, 1, this.status));
        children.add(new Property("effectivePeriod", "Period", "Period of usability of the catalog entry.", 0, 1, this.effectivePeriod));
        children.add(new Property(SP_ORDERABLE, "boolean", "Indicates whether or not the entry represents an item that is orderable.", 0, 1, this.orderable));
        children.add(new Property("referencedItem", "Reference(DeviceDefinition|Organization|Practitioner|PractitionerRole|HealthcareService|ActivityDefinition|PlanDefinition|SpecimenDefinition|ObservationDefinition|MedicationKnowledge|Substance|Location)", "The item (resource) that this entry of the catalog represents.", 0, 1, this.referencedItem));
        children.add(new Property("relatedEntry", "", "Used for example, to point to a substance, or to a device used to administer a medication.", 0, Integer.MAX_VALUE, this.relatedEntry));
        children.add(new Property("updatedBy", "Reference(Person|Device)", "Last actor who recorded (created or updated) this catalog entry.", 0, 1, this.updatedBy));
        children.add(new Property("note", "Annotation", "Notes and comments about this catalog entry.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("estimatedDuration", "Duration", "Estimated duration of the orderable item of this  entry of the catalog.", 0, 1, this.estimatedDuration));
        children.add(new Property("billingCode", "CodeableConcept", "Billing code associated to the  item in the context of this  entry of the catalog.", 0, Integer.MAX_VALUE, this.billingCode));
        children.add(new Property("billingSummary", "string", "Billing summary attached to the  item in the context of this  entry of the catalog.", 0, 1, this.billingSummary));
        children.add(new Property("scheduleSummary", "string", "Schedule summary for the  item in the context of this  entry of the catalog.", 0, 1, this.scheduleSummary));
        children.add(new Property("limitationSummary", "string", "Summary of limitations for the  item in the context of this  entry of the catalog.", 0, 1, this.limitationSummary));
        children.add(new Property("regulatorySummary", "string", "Regulatory summary for the  item in the context of this  entry of the catalog.", 0, 1, this.regulatorySummary));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier uniquely assigned to the catalog entry.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "The name of this catalog entry announces the item that is represented by the entry.", 0, 1, this.name);
            }
            case 3575610: {
                return new Property(SP_TYPE, "code", "The type of resource that is represented by this catalog entry.", 0, 1, this.type);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Indicates whether this catalog entry is open to public usage (active) or not (draft or retired).", 0, 1, this.status);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "Period of usability of the catalog entry.", 0, 1, this.effectivePeriod);
            }
            case -391199320: {
                return new Property(SP_ORDERABLE, "boolean", "Indicates whether or not the entry represents an item that is orderable.", 0, 1, this.orderable);
            }
            case -1896630996: {
                return new Property("referencedItem", "Reference(DeviceDefinition|Organization|Practitioner|PractitionerRole|HealthcareService|ActivityDefinition|PlanDefinition|SpecimenDefinition|ObservationDefinition|MedicationKnowledge|Substance|Location)", "The item (resource) that this entry of the catalog represents.", 0, 1, this.referencedItem);
            }
            case 130178823: {
                return new Property("relatedEntry", "", "Used for example, to point to a substance, or to a device used to administer a medication.", 0, Integer.MAX_VALUE, this.relatedEntry);
            }
            case -1949194638: {
                return new Property("updatedBy", "Reference(Person|Device)", "Last actor who recorded (created or updated) this catalog entry.", 0, 1, this.updatedBy);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Notes and comments about this catalog entry.", 0, Integer.MAX_VALUE, this.note);
            }
            case 1266497008: {
                return new Property("estimatedDuration", "Duration", "Estimated duration of the orderable item of this  entry of the catalog.", 0, 1, this.estimatedDuration);
            }
            case 91787016: {
                return new Property("billingCode", "CodeableConcept", "Billing code associated to the  item in the context of this  entry of the catalog.", 0, Integer.MAX_VALUE, this.billingCode);
            }
            case 28404907: {
                return new Property("billingSummary", "string", "Billing summary attached to the  item in the context of this  entry of the catalog.", 0, 1, this.billingSummary);
            }
            case -255728369: {
                return new Property("scheduleSummary", "string", "Schedule summary for the  item in the context of this  entry of the catalog.", 0, 1, this.scheduleSummary);
            }
            case -79871444: {
                return new Property("limitationSummary", "string", "Summary of limitations for the  item in the context of this  entry of the catalog.", 0, 1, this.limitationSummary);
            }
            case 1296867822: {
                return new Property("regulatorySummary", "string", "Regulatory summary for the  item in the context of this  entry of the catalog.", 0, 1, this.regulatorySummary);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.name;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case -391199320: {
                Base[] baseArray;
                if (this.orderable == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.orderable;
                }
                return baseArray;
            }
            case -1896630996: {
                Base[] baseArray;
                if (this.referencedItem == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.referencedItem;
                }
                return baseArray;
            }
            case 130178823: {
                return this.relatedEntry == null ? new Base[]{} : this.relatedEntry.toArray(new Base[this.relatedEntry.size()]);
            }
            case -1949194638: {
                Base[] baseArray;
                if (this.updatedBy == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.updatedBy;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 1266497008: {
                Base[] baseArray;
                if (this.estimatedDuration == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.estimatedDuration;
                }
                return baseArray;
            }
            case 91787016: {
                return this.billingCode == null ? new Base[]{} : this.billingCode.toArray(new Base[this.billingCode.size()]);
            }
            case 28404907: {
                Base[] baseArray;
                if (this.billingSummary == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.billingSummary;
                }
                return baseArray;
            }
            case -255728369: {
                Base[] baseArray;
                if (this.scheduleSummary == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.scheduleSummary;
                }
                return baseArray;
            }
            case -79871444: {
                Base[] baseArray;
                if (this.limitationSummary == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.limitationSummary;
                }
                return baseArray;
            }
            case 1296867822: {
                Base[] baseArray;
                if (this.regulatorySummary == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.regulatorySummary;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 3575610: {
                value = new CatalogEntryTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
                return value;
            }
            case -892481550: {
                value = new CatalogEntryStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -403934648: {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -391199320: {
                this.orderable = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -1896630996: {
                this.referencedItem = TypeConvertor.castToReference(value);
                return value;
            }
            case 130178823: {
                this.getRelatedEntry().add((CatalogEntryRelatedEntryComponent)((Object)value));
                return value;
            }
            case -1949194638: {
                this.updatedBy = TypeConvertor.castToReference(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 1266497008: {
                this.estimatedDuration = TypeConvertor.castToDuration(value);
                return value;
            }
            case 91787016: {
                this.getBillingCode().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 28404907: {
                this.billingSummary = TypeConvertor.castToString(value);
                return value;
            }
            case -255728369: {
                this.scheduleSummary = TypeConvertor.castToString(value);
                return value;
            }
            case -79871444: {
                this.limitationSummary = TypeConvertor.castToString(value);
                return value;
            }
            case 1296867822: {
                this.regulatorySummary = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TYPE)) {
            value = new CatalogEntryTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.type = value;
        } else if (name.equals(SP_STATUS)) {
            value = new CatalogEntryStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_ORDERABLE)) {
            this.orderable = TypeConvertor.castToBoolean(value);
        } else if (name.equals("referencedItem")) {
            this.referencedItem = TypeConvertor.castToReference(value);
        } else if (name.equals("relatedEntry")) {
            this.getRelatedEntry().add((CatalogEntryRelatedEntryComponent)((Object)value));
        } else if (name.equals("updatedBy")) {
            this.updatedBy = TypeConvertor.castToReference(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("estimatedDuration")) {
            this.estimatedDuration = TypeConvertor.castToDuration(value);
        } else if (name.equals("billingCode")) {
            this.getBillingCode().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("billingSummary")) {
            this.billingSummary = TypeConvertor.castToString(value);
        } else if (name.equals("scheduleSummary")) {
            this.scheduleSummary = TypeConvertor.castToString(value);
        } else if (name.equals("limitationSummary")) {
            this.limitationSummary = TypeConvertor.castToString(value);
        } else if (name.equals("regulatorySummary")) {
            this.regulatorySummary = TypeConvertor.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case -391199320: {
                return this.getOrderableElement();
            }
            case -1896630996: {
                return this.getReferencedItem();
            }
            case 130178823: {
                return this.addRelatedEntry();
            }
            case -1949194638: {
                return this.getUpdatedBy();
            }
            case 3387378: {
                return this.addNote();
            }
            case 1266497008: {
                return this.getEstimatedDuration();
            }
            case 91787016: {
                return this.addBillingCode();
            }
            case 28404907: {
                return this.getBillingSummaryElement();
            }
            case -255728369: {
                return this.getScheduleSummaryElement();
            }
            case -79871444: {
                return this.getLimitationSummaryElement();
            }
            case 1296867822: {
                return this.getRegulatorySummaryElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case -391199320: {
                return new String[]{"boolean"};
            }
            case -1896630996: {
                return new String[]{"Reference"};
            }
            case 130178823: {
                return new String[0];
            }
            case -1949194638: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 1266497008: {
                return new String[]{"Duration"};
            }
            case 91787016: {
                return new String[]{"CodeableConcept"};
            }
            case 28404907: {
                return new String[]{"string"};
            }
            case -255728369: {
                return new String[]{"string"};
            }
            case -79871444: {
                return new String[]{"string"};
            }
            case 1296867822: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type CatalogEntry.name");
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a primitive type CatalogEntry.type");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type CatalogEntry.status");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals(SP_ORDERABLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type CatalogEntry.orderable");
        }
        if (name.equals("referencedItem")) {
            this.referencedItem = new Reference();
            return this.referencedItem;
        }
        if (name.equals("relatedEntry")) {
            return this.addRelatedEntry();
        }
        if (name.equals("updatedBy")) {
            this.updatedBy = new Reference();
            return this.updatedBy;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("estimatedDuration")) {
            this.estimatedDuration = new Duration();
            return this.estimatedDuration;
        }
        if (name.equals("billingCode")) {
            return this.addBillingCode();
        }
        if (name.equals("billingSummary")) {
            throw new FHIRException("Cannot call addChild on a primitive type CatalogEntry.billingSummary");
        }
        if (name.equals("scheduleSummary")) {
            throw new FHIRException("Cannot call addChild on a primitive type CatalogEntry.scheduleSummary");
        }
        if (name.equals("limitationSummary")) {
            throw new FHIRException("Cannot call addChild on a primitive type CatalogEntry.limitationSummary");
        }
        if (name.equals("regulatorySummary")) {
            throw new FHIRException("Cannot call addChild on a primitive type CatalogEntry.regulatorySummary");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CatalogEntry";
    }

    @Override
    public CatalogEntry copy() {
        CatalogEntry dst = new CatalogEntry();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CatalogEntry dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.name = this.name == null ? null : this.name.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        dst.orderable = this.orderable == null ? null : this.orderable.copy();
        Reference reference = dst.referencedItem = this.referencedItem == null ? null : this.referencedItem.copy();
        if (this.relatedEntry != null) {
            dst.relatedEntry = new ArrayList<CatalogEntryRelatedEntryComponent>();
            for (CatalogEntryRelatedEntryComponent catalogEntryRelatedEntryComponent : this.relatedEntry) {
                dst.relatedEntry.add(catalogEntryRelatedEntryComponent.copy());
            }
        }
        Reference reference2 = dst.updatedBy = this.updatedBy == null ? null : this.updatedBy.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        Duration duration = dst.estimatedDuration = this.estimatedDuration == null ? null : this.estimatedDuration.copy();
        if (this.billingCode != null) {
            dst.billingCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.billingCode) {
                dst.billingCode.add(codeableConcept.copy());
            }
        }
        dst.billingSummary = this.billingSummary == null ? null : this.billingSummary.copy();
        dst.scheduleSummary = this.scheduleSummary == null ? null : this.scheduleSummary.copy();
        dst.limitationSummary = this.limitationSummary == null ? null : this.limitationSummary.copy();
        dst.regulatorySummary = this.regulatorySummary == null ? null : this.regulatorySummary.copy();
    }

    protected CatalogEntry typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CatalogEntry)) {
            return false;
        }
        CatalogEntry o = (CatalogEntry)other_;
        return CatalogEntry.compareDeep(this.identifier, o.identifier, true) && CatalogEntry.compareDeep(this.name, o.name, true) && CatalogEntry.compareDeep(this.type, o.type, true) && CatalogEntry.compareDeep(this.status, o.status, true) && CatalogEntry.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && CatalogEntry.compareDeep(this.orderable, o.orderable, true) && CatalogEntry.compareDeep(this.referencedItem, o.referencedItem, true) && CatalogEntry.compareDeep(this.relatedEntry, o.relatedEntry, true) && CatalogEntry.compareDeep(this.updatedBy, o.updatedBy, true) && CatalogEntry.compareDeep(this.note, o.note, true) && CatalogEntry.compareDeep(this.estimatedDuration, o.estimatedDuration, true) && CatalogEntry.compareDeep(this.billingCode, o.billingCode, true) && CatalogEntry.compareDeep(this.billingSummary, o.billingSummary, true) && CatalogEntry.compareDeep(this.scheduleSummary, o.scheduleSummary, true) && CatalogEntry.compareDeep(this.limitationSummary, o.limitationSummary, true) && CatalogEntry.compareDeep(this.regulatorySummary, o.regulatorySummary, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CatalogEntry)) {
            return false;
        }
        CatalogEntry o = (CatalogEntry)other_;
        return CatalogEntry.compareValues(this.name, o.name, true) && CatalogEntry.compareValues(this.type, o.type, true) && CatalogEntry.compareValues(this.status, o.status, true) && CatalogEntry.compareValues(this.orderable, o.orderable, true) && CatalogEntry.compareValues(this.billingSummary, o.billingSummary, true) && CatalogEntry.compareValues(this.scheduleSummary, o.scheduleSummary, true) && CatalogEntry.compareValues(this.limitationSummary, o.limitationSummary, true) && CatalogEntry.compareValues(this.regulatorySummary, o.regulatorySummary, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.name, this.type, this.status, this.effectivePeriod, this.orderable, this.referencedItem, this.relatedEntry, this.updatedBy, this.note, this.estimatedDuration, this.billingCode, this.billingSummary, this.scheduleSummary, this.limitationSummary, this.regulatorySummary);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CatalogEntry;
    }

    @Block
    public static class CatalogEntryRelatedEntryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="relationship", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="triggers | is-replaced-by | excludes | includes", formalDefinition="The type of relationship to the related entry.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/catalogentry-relation-type")
        protected Enumeration<CatalogEntryRelationType> relationship;
        @Child(name="target", type={CatalogEntry.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The reference to the related entry", formalDefinition="The reference to the related entry.")
        protected Reference target;
        private static final long serialVersionUID = -1175541480L;

        public CatalogEntryRelatedEntryComponent() {
        }

        public CatalogEntryRelatedEntryComponent(CatalogEntryRelationType relationship, Reference target) {
            this.setRelationship(relationship);
            this.setTarget(target);
        }

        public Enumeration<CatalogEntryRelationType> getRelationshipElement() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CatalogEntryRelatedEntryComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new Enumeration<CatalogEntryRelationType>(new CatalogEntryRelationTypeEnumFactory());
                }
            }
            return this.relationship;
        }

        public boolean hasRelationshipElement() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public CatalogEntryRelatedEntryComponent setRelationshipElement(Enumeration<CatalogEntryRelationType> value) {
            this.relationship = value;
            return this;
        }

        public CatalogEntryRelationType getRelationship() {
            return this.relationship == null ? null : (CatalogEntryRelationType)((Object)this.relationship.getValue());
        }

        public CatalogEntryRelatedEntryComponent setRelationship(CatalogEntryRelationType value) {
            if (this.relationship == null) {
                this.relationship = new Enumeration<CatalogEntryRelationType>(new CatalogEntryRelationTypeEnumFactory());
            }
            this.relationship.setValue((Object)value);
            return this;
        }

        public Reference getTarget() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CatalogEntryRelatedEntryComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new Reference();
                }
            }
            return this.target;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public CatalogEntryRelatedEntryComponent setTarget(Reference value) {
            this.target = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("relationship", "code", "The type of relationship to the related entry.", 0, 1, this.relationship));
            children.add(new Property("target", "Reference(CatalogEntry)", "The reference to the related entry.", 0, 1, this.target));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -261851592: {
                    return new Property("relationship", "code", "The type of relationship to the related entry.", 0, 1, this.relationship);
                }
                case -880905839: {
                    return new Property("target", "Reference(CatalogEntry)", "The reference to the related entry.", 0, 1, this.target);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.relationship;
                    }
                    return baseArray;
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.target;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -261851592: {
                    value = new CatalogEntryRelationTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.relationship = value;
                    return value;
                }
                case -880905839: {
                    this.target = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("relationship")) {
                value = new CatalogEntryRelationTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.relationship = value;
            } else if (name.equals("target")) {
                this.target = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -261851592: {
                    return this.getRelationshipElement();
                }
                case -880905839: {
                    return this.getTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -261851592: {
                    return new String[]{"code"};
                }
                case -880905839: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("relationship")) {
                throw new FHIRException("Cannot call addChild on a primitive type CatalogEntry.relatedEntry.relationship");
            }
            if (name.equals("target")) {
                this.target = new Reference();
                return this.target;
            }
            return super.addChild(name);
        }

        @Override
        public CatalogEntryRelatedEntryComponent copy() {
            CatalogEntryRelatedEntryComponent dst = new CatalogEntryRelatedEntryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CatalogEntryRelatedEntryComponent dst) {
            super.copyValues(dst);
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            dst.target = this.target == null ? null : this.target.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CatalogEntryRelatedEntryComponent)) {
                return false;
            }
            CatalogEntryRelatedEntryComponent o = (CatalogEntryRelatedEntryComponent)other_;
            return CatalogEntryRelatedEntryComponent.compareDeep(this.relationship, o.relationship, true) && CatalogEntryRelatedEntryComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CatalogEntryRelatedEntryComponent)) {
                return false;
            }
            CatalogEntryRelatedEntryComponent o = (CatalogEntryRelatedEntryComponent)other_;
            return CatalogEntryRelatedEntryComponent.compareValues(this.relationship, o.relationship, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.relationship, this.target);
        }

        @Override
        public String fhirType() {
            return "CatalogEntry.relatedEntry";
        }
    }

    public static class CatalogEntryTypeEnumFactory
    implements EnumFactory<CatalogEntryType> {
        @Override
        public CatalogEntryType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("ActivityDefinition".equals(codeString)) {
                return CatalogEntryType.ACTIVITYDEFINITION;
            }
            if ("PlanDefinition".equals(codeString)) {
                return CatalogEntryType.PLANDEFINITION;
            }
            if ("SpecimenDefinition".equals(codeString)) {
                return CatalogEntryType.SPECIMENDEFINITION;
            }
            if ("ObservationDefinition".equals(codeString)) {
                return CatalogEntryType.OBSERVATIONDEFINITION;
            }
            if ("DeviceDefinition".equals(codeString)) {
                return CatalogEntryType.DEVICEDEFINITION;
            }
            if ("Organization".equals(codeString)) {
                return CatalogEntryType.ORGANIZATION;
            }
            if ("Practitioner".equals(codeString)) {
                return CatalogEntryType.PRACTITIONER;
            }
            if ("PractitionerRole".equals(codeString)) {
                return CatalogEntryType.PRACTITIONERROLE;
            }
            if ("HealthcareService".equals(codeString)) {
                return CatalogEntryType.HEALTHCARESERVICE;
            }
            if ("MedicationKnowledge".equals(codeString)) {
                return CatalogEntryType.MEDICATIONKNOWLEDGE;
            }
            if ("Medication".equals(codeString)) {
                return CatalogEntryType.MEDICATION;
            }
            if ("Substance".equals(codeString)) {
                return CatalogEntryType.SUBSTANCE;
            }
            if ("Location".equals(codeString)) {
                return CatalogEntryType.LOCATION;
            }
            throw new IllegalArgumentException("Unknown CatalogEntryType code '" + codeString + "'");
        }

        public Enumeration<CatalogEntryType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CatalogEntryType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("ActivityDefinition".equals(codeString)) {
                return new Enumeration<CatalogEntryType>(this, CatalogEntryType.ACTIVITYDEFINITION);
            }
            if ("PlanDefinition".equals(codeString)) {
                return new Enumeration<CatalogEntryType>(this, CatalogEntryType.PLANDEFINITION);
            }
            if ("SpecimenDefinition".equals(codeString)) {
                return new Enumeration<CatalogEntryType>(this, CatalogEntryType.SPECIMENDEFINITION);
            }
            if ("ObservationDefinition".equals(codeString)) {
                return new Enumeration<CatalogEntryType>(this, CatalogEntryType.OBSERVATIONDEFINITION);
            }
            if ("DeviceDefinition".equals(codeString)) {
                return new Enumeration<CatalogEntryType>(this, CatalogEntryType.DEVICEDEFINITION);
            }
            if ("Organization".equals(codeString)) {
                return new Enumeration<CatalogEntryType>(this, CatalogEntryType.ORGANIZATION);
            }
            if ("Practitioner".equals(codeString)) {
                return new Enumeration<CatalogEntryType>(this, CatalogEntryType.PRACTITIONER);
            }
            if ("PractitionerRole".equals(codeString)) {
                return new Enumeration<CatalogEntryType>(this, CatalogEntryType.PRACTITIONERROLE);
            }
            if ("HealthcareService".equals(codeString)) {
                return new Enumeration<CatalogEntryType>(this, CatalogEntryType.HEALTHCARESERVICE);
            }
            if ("MedicationKnowledge".equals(codeString)) {
                return new Enumeration<CatalogEntryType>(this, CatalogEntryType.MEDICATIONKNOWLEDGE);
            }
            if ("Medication".equals(codeString)) {
                return new Enumeration<CatalogEntryType>(this, CatalogEntryType.MEDICATION);
            }
            if ("Substance".equals(codeString)) {
                return new Enumeration<CatalogEntryType>(this, CatalogEntryType.SUBSTANCE);
            }
            if ("Location".equals(codeString)) {
                return new Enumeration<CatalogEntryType>(this, CatalogEntryType.LOCATION);
            }
            throw new FHIRException("Unknown CatalogEntryType code '" + codeString + "'");
        }

        @Override
        public String toCode(CatalogEntryType code) {
            if (code == CatalogEntryType.ACTIVITYDEFINITION) {
                return "ActivityDefinition";
            }
            if (code == CatalogEntryType.PLANDEFINITION) {
                return "PlanDefinition";
            }
            if (code == CatalogEntryType.SPECIMENDEFINITION) {
                return "SpecimenDefinition";
            }
            if (code == CatalogEntryType.OBSERVATIONDEFINITION) {
                return "ObservationDefinition";
            }
            if (code == CatalogEntryType.DEVICEDEFINITION) {
                return "DeviceDefinition";
            }
            if (code == CatalogEntryType.ORGANIZATION) {
                return "Organization";
            }
            if (code == CatalogEntryType.PRACTITIONER) {
                return "Practitioner";
            }
            if (code == CatalogEntryType.PRACTITIONERROLE) {
                return "PractitionerRole";
            }
            if (code == CatalogEntryType.HEALTHCARESERVICE) {
                return "HealthcareService";
            }
            if (code == CatalogEntryType.MEDICATIONKNOWLEDGE) {
                return "MedicationKnowledge";
            }
            if (code == CatalogEntryType.MEDICATION) {
                return "Medication";
            }
            if (code == CatalogEntryType.SUBSTANCE) {
                return "Substance";
            }
            if (code == CatalogEntryType.LOCATION) {
                return "Location";
            }
            return "?";
        }

        @Override
        public String toSystem(CatalogEntryType code) {
            return code.getSystem();
        }
    }

    public static enum CatalogEntryType {
        ACTIVITYDEFINITION,
        PLANDEFINITION,
        SPECIMENDEFINITION,
        OBSERVATIONDEFINITION,
        DEVICEDEFINITION,
        ORGANIZATION,
        PRACTITIONER,
        PRACTITIONERROLE,
        HEALTHCARESERVICE,
        MEDICATIONKNOWLEDGE,
        MEDICATION,
        SUBSTANCE,
        LOCATION,
        NULL;


        public static CatalogEntryType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("ActivityDefinition".equals(codeString)) {
                return ACTIVITYDEFINITION;
            }
            if ("PlanDefinition".equals(codeString)) {
                return PLANDEFINITION;
            }
            if ("SpecimenDefinition".equals(codeString)) {
                return SPECIMENDEFINITION;
            }
            if ("ObservationDefinition".equals(codeString)) {
                return OBSERVATIONDEFINITION;
            }
            if ("DeviceDefinition".equals(codeString)) {
                return DEVICEDEFINITION;
            }
            if ("Organization".equals(codeString)) {
                return ORGANIZATION;
            }
            if ("Practitioner".equals(codeString)) {
                return PRACTITIONER;
            }
            if ("PractitionerRole".equals(codeString)) {
                return PRACTITIONERROLE;
            }
            if ("HealthcareService".equals(codeString)) {
                return HEALTHCARESERVICE;
            }
            if ("MedicationKnowledge".equals(codeString)) {
                return MEDICATIONKNOWLEDGE;
            }
            if ("Medication".equals(codeString)) {
                return MEDICATION;
            }
            if ("Substance".equals(codeString)) {
                return SUBSTANCE;
            }
            if ("Location".equals(codeString)) {
                return LOCATION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CatalogEntryType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVITYDEFINITION: {
                    return "ActivityDefinition";
                }
                case PLANDEFINITION: {
                    return "PlanDefinition";
                }
                case SPECIMENDEFINITION: {
                    return "SpecimenDefinition";
                }
                case OBSERVATIONDEFINITION: {
                    return "ObservationDefinition";
                }
                case DEVICEDEFINITION: {
                    return "DeviceDefinition";
                }
                case ORGANIZATION: {
                    return "Organization";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case PRACTITIONERROLE: {
                    return "PractitionerRole";
                }
                case HEALTHCARESERVICE: {
                    return "HealthcareService";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "MedicationKnowledge";
                }
                case MEDICATION: {
                    return "Medication";
                }
                case SUBSTANCE: {
                    return "Substance";
                }
                case LOCATION: {
                    return "Location";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVITYDEFINITION: {
                    return "http://hl7.org/fhir/catalogentry-type";
                }
                case PLANDEFINITION: {
                    return "http://hl7.org/fhir/catalogentry-type";
                }
                case SPECIMENDEFINITION: {
                    return "http://hl7.org/fhir/catalogentry-type";
                }
                case OBSERVATIONDEFINITION: {
                    return "http://hl7.org/fhir/catalogentry-type";
                }
                case DEVICEDEFINITION: {
                    return "http://hl7.org/fhir/catalogentry-type";
                }
                case ORGANIZATION: {
                    return "http://hl7.org/fhir/catalogentry-type";
                }
                case PRACTITIONER: {
                    return "http://hl7.org/fhir/catalogentry-type";
                }
                case PRACTITIONERROLE: {
                    return "http://hl7.org/fhir/catalogentry-type";
                }
                case HEALTHCARESERVICE: {
                    return "http://hl7.org/fhir/catalogentry-type";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "http://hl7.org/fhir/catalogentry-type";
                }
                case MEDICATION: {
                    return "http://hl7.org/fhir/catalogentry-type";
                }
                case SUBSTANCE: {
                    return "http://hl7.org/fhir/catalogentry-type";
                }
                case LOCATION: {
                    return "http://hl7.org/fhir/catalogentry-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVITYDEFINITION: {
                    return "";
                }
                case PLANDEFINITION: {
                    return "";
                }
                case SPECIMENDEFINITION: {
                    return "";
                }
                case OBSERVATIONDEFINITION: {
                    return "";
                }
                case DEVICEDEFINITION: {
                    return "";
                }
                case ORGANIZATION: {
                    return "";
                }
                case PRACTITIONER: {
                    return "";
                }
                case PRACTITIONERROLE: {
                    return "";
                }
                case HEALTHCARESERVICE: {
                    return "";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "";
                }
                case MEDICATION: {
                    return "";
                }
                case SUBSTANCE: {
                    return "";
                }
                case LOCATION: {
                    return "";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVITYDEFINITION: {
                    return "ActivityDefinition";
                }
                case PLANDEFINITION: {
                    return "PlanDefinition";
                }
                case SPECIMENDEFINITION: {
                    return "SpecimenDefinition";
                }
                case OBSERVATIONDEFINITION: {
                    return "ObservationDefinition";
                }
                case DEVICEDEFINITION: {
                    return "DeviceDefinition";
                }
                case ORGANIZATION: {
                    return "Organization";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case PRACTITIONERROLE: {
                    return "PractitionerRole";
                }
                case HEALTHCARESERVICE: {
                    return "HealthcareService";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "MedicationKnowledge";
                }
                case MEDICATION: {
                    return "Medication";
                }
                case SUBSTANCE: {
                    return "Substance";
                }
                case LOCATION: {
                    return "Location";
                }
            }
            return "?";
        }
    }

    public static class CatalogEntryStatusEnumFactory
    implements EnumFactory<CatalogEntryStatus> {
        @Override
        public CatalogEntryStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return CatalogEntryStatus.DRAFT;
            }
            if ("active".equals(codeString)) {
                return CatalogEntryStatus.ACTIVE;
            }
            if ("retired".equals(codeString)) {
                return CatalogEntryStatus.RETIRED;
            }
            throw new IllegalArgumentException("Unknown CatalogEntryStatus code '" + codeString + "'");
        }

        public Enumeration<CatalogEntryStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CatalogEntryStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<CatalogEntryStatus>(this, CatalogEntryStatus.DRAFT);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<CatalogEntryStatus>(this, CatalogEntryStatus.ACTIVE);
            }
            if ("retired".equals(codeString)) {
                return new Enumeration<CatalogEntryStatus>(this, CatalogEntryStatus.RETIRED);
            }
            throw new FHIRException("Unknown CatalogEntryStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(CatalogEntryStatus code) {
            if (code == CatalogEntryStatus.DRAFT) {
                return "draft";
            }
            if (code == CatalogEntryStatus.ACTIVE) {
                return "active";
            }
            if (code == CatalogEntryStatus.RETIRED) {
                return "retired";
            }
            return "?";
        }

        @Override
        public String toSystem(CatalogEntryStatus code) {
            return code.getSystem();
        }
    }

    public static enum CatalogEntryStatus {
        DRAFT,
        ACTIVE,
        RETIRED,
        NULL;


        public static CatalogEntryStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("retired".equals(codeString)) {
                return RETIRED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CatalogEntryStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case ACTIVE: {
                    return "active";
                }
                case RETIRED: {
                    return "retired";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/catalogentry-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/catalogentry-status";
                }
                case RETIRED: {
                    return "http://hl7.org/fhir/catalogentry-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "";
                }
                case ACTIVE: {
                    return "";
                }
                case RETIRED: {
                    return "";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case ACTIVE: {
                    return "Active";
                }
                case RETIRED: {
                    return "Retired";
                }
            }
            return "?";
        }
    }

    public static class CatalogEntryRelationTypeEnumFactory
    implements EnumFactory<CatalogEntryRelationType> {
        @Override
        public CatalogEntryRelationType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("triggers".equals(codeString)) {
                return CatalogEntryRelationType.TRIGGERS;
            }
            if ("is-replaced-by".equals(codeString)) {
                return CatalogEntryRelationType.ISREPLACEDBY;
            }
            if ("excludes".equals(codeString)) {
                return CatalogEntryRelationType.EXCLUDES;
            }
            if ("includes".equals(codeString)) {
                return CatalogEntryRelationType.INCLUDES;
            }
            throw new IllegalArgumentException("Unknown CatalogEntryRelationType code '" + codeString + "'");
        }

        public Enumeration<CatalogEntryRelationType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CatalogEntryRelationType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("triggers".equals(codeString)) {
                return new Enumeration<CatalogEntryRelationType>(this, CatalogEntryRelationType.TRIGGERS);
            }
            if ("is-replaced-by".equals(codeString)) {
                return new Enumeration<CatalogEntryRelationType>(this, CatalogEntryRelationType.ISREPLACEDBY);
            }
            if ("excludes".equals(codeString)) {
                return new Enumeration<CatalogEntryRelationType>(this, CatalogEntryRelationType.EXCLUDES);
            }
            if ("includes".equals(codeString)) {
                return new Enumeration<CatalogEntryRelationType>(this, CatalogEntryRelationType.INCLUDES);
            }
            throw new FHIRException("Unknown CatalogEntryRelationType code '" + codeString + "'");
        }

        @Override
        public String toCode(CatalogEntryRelationType code) {
            if (code == CatalogEntryRelationType.TRIGGERS) {
                return "triggers";
            }
            if (code == CatalogEntryRelationType.ISREPLACEDBY) {
                return "is-replaced-by";
            }
            if (code == CatalogEntryRelationType.EXCLUDES) {
                return "excludes";
            }
            if (code == CatalogEntryRelationType.INCLUDES) {
                return "includes";
            }
            return "?";
        }

        @Override
        public String toSystem(CatalogEntryRelationType code) {
            return code.getSystem();
        }
    }

    public static enum CatalogEntryRelationType {
        TRIGGERS,
        ISREPLACEDBY,
        EXCLUDES,
        INCLUDES,
        NULL;


        public static CatalogEntryRelationType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("triggers".equals(codeString)) {
                return TRIGGERS;
            }
            if ("is-replaced-by".equals(codeString)) {
                return ISREPLACEDBY;
            }
            if ("excludes".equals(codeString)) {
                return EXCLUDES;
            }
            if ("includes".equals(codeString)) {
                return INCLUDES;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CatalogEntryRelationType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case TRIGGERS: {
                    return "triggers";
                }
                case ISREPLACEDBY: {
                    return "is-replaced-by";
                }
                case EXCLUDES: {
                    return "excludes";
                }
                case INCLUDES: {
                    return "includes";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case TRIGGERS: {
                    return "http://hl7.org/fhir/catalogentry-relation-type";
                }
                case ISREPLACEDBY: {
                    return "http://hl7.org/fhir/catalogentry-relation-type";
                }
                case EXCLUDES: {
                    return "http://hl7.org/fhir/catalogentry-relation-type";
                }
                case INCLUDES: {
                    return "http://hl7.org/fhir/catalogentry-relation-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case TRIGGERS: {
                    return "Depending on the context, the item of the related catalog entry may be added by the performer.";
                }
                case ISREPLACEDBY: {
                    return "the related catalog entry supersedes this one when it is not active.";
                }
                case EXCLUDES: {
                    return "The related catalog entry is excluded by this one.";
                }
                case INCLUDES: {
                    return "The item of the related catalog entry  will be part of the orders containing the current item.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case TRIGGERS: {
                    return "Triggers";
                }
                case ISREPLACEDBY: {
                    return "Is replaced by";
                }
                case EXCLUDES: {
                    return "Excludes";
                }
                case INCLUDES: {
                    return "Includes";
                }
            }
            return "?";
        }
    }
}

