/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import ca.uhn.fhir.parser.DataFormatException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.BaseWorkerContext;
import org.hl7.fhir.r5.context.HTMLClientLogger;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.TextClientLogger;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.ParserType;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.terminologies.TerminologyClient;
import org.hl7.fhir.r5.utils.INarrativeGenerator;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.r5.utils.NarrativeGenerator;
import org.hl7.fhir.utilities.CSFileInputStream;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.cache.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class SimpleWorkerContext
extends BaseWorkerContext
implements IWorkerContext,
ProfileUtilities.ProfileKnowledgeProvider {
    private Questionnaire questionnaire;
    private String revision;
    private String date;
    private IValidatorFactory validatorFactory;
    private boolean ignoreProfileErrors;
    private boolean progress;
    private List<String> loadedPackages = new ArrayList<String>();

    public SimpleWorkerContext() throws FileNotFoundException, IOException, FHIRException {
    }

    public SimpleWorkerContext(Locale locale) throws FileNotFoundException, IOException, FHIRException {
        super(locale);
    }

    public SimpleWorkerContext(SimpleWorkerContext other) throws FileNotFoundException, IOException, FHIRException {
        this.copy(other);
    }

    public SimpleWorkerContext(SimpleWorkerContext other, Locale locale) throws FileNotFoundException, IOException, FHIRException {
        super(locale);
        this.copy(other);
    }

    protected void copy(SimpleWorkerContext other) {
        super.copy(other);
        this.questionnaire = other.questionnaire;
        this.binaries.putAll(other.binaries);
        this.version = other.version;
        this.revision = other.revision;
        this.date = other.date;
        this.validatorFactory = other.validatorFactory;
    }

    public static SimpleWorkerContext fromPack(String path) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromPack(path, null);
        return res;
    }

    public static SimpleWorkerContext fromPackage(NpmPackage pi, boolean allowDuplicates) throws FileNotFoundException, IOException, FHIRException {
        return SimpleWorkerContext.fromPackage(pi, allowDuplicates, null);
    }

    public static SimpleWorkerContext fromPackage(NpmPackage pi, boolean allowDuplicates, ILoadFilter filter) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.setAllowLoadingDuplicates(allowDuplicates);
        res.loadFromPackage(pi, null, filter);
        return res;
    }

    public static SimpleWorkerContext fromPackage(NpmPackage pi) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromPackage(pi, null, new String[0]);
        return res;
    }

    public static SimpleWorkerContext fromPackage(NpmPackage pi, IWorkerContext.IContextResourceLoader loader) throws FileNotFoundException, IOException, FHIRException {
        return SimpleWorkerContext.fromPackage(pi, loader, null);
    }

    public static SimpleWorkerContext fromPackage(NpmPackage pi, IWorkerContext.IContextResourceLoader loader, ILoadFilter filter) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.setAllowLoadingDuplicates(true);
        res.version = pi.getNpm().get("version").getAsString();
        res.loadFromPackage(pi, loader, filter);
        res.finishLoading();
        return res;
    }

    public static SimpleWorkerContext fromPack(String path, boolean allowDuplicates) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.setAllowLoadingDuplicates(allowDuplicates);
        res.loadFromPack(path, null);
        return res;
    }

    public static SimpleWorkerContext fromPack(String path, IWorkerContext.IContextResourceLoader loader) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromPack(path, loader);
        return res;
    }

    public static SimpleWorkerContext fromClassPath() throws IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromStream(SimpleWorkerContext.class.getResourceAsStream("validation.json.zip"), null);
        return res;
    }

    public static SimpleWorkerContext fromClassPath(String name) throws IOException, FHIRException {
        InputStream s2 = SimpleWorkerContext.class.getResourceAsStream("/" + name);
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromStream(s2, null);
        return res;
    }

    public static SimpleWorkerContext fromDefinitions(Map<String, byte[]> source, IWorkerContext.IContextResourceLoader loader, IWorkerContext.PackageVersion pi) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        for (String name : source.keySet()) {
            try {
                res.loadDefinitionItem(name, new ByteArrayInputStream(source.get(name)), loader, null, pi);
            }
            catch (Exception e) {
                System.out.println("Error loading " + name + ": " + e.getMessage());
                throw new FHIRException("Error loading " + name + ": " + e.getMessage(), e);
            }
        }
        return res;
    }

    private void loadDefinitionItem(String name, InputStream stream, IWorkerContext.IContextResourceLoader loader, ILoadFilter filter, IWorkerContext.PackageVersion pi) throws IOException, FHIRException {
        if (name.endsWith(".xml")) {
            this.loadFromFile(stream, name, loader, filter);
        } else if (name.endsWith(".json")) {
            this.loadFromFileJson(stream, name, loader, filter, pi);
        } else if (name.equals("version.info")) {
            this.readVersionInfo(stream);
        } else {
            this.loadBytes(name, stream);
        }
    }

    public String connectToTSServer(TerminologyClient client, String log) {
        try {
            this.tlog("Connect to " + client.getAddress());
            this.txClient = client;
            this.txLog = log != null && log.endsWith(".txt") ? new TextClientLogger(log) : new HTMLClientLogger(log);
            this.txClient.setLogger(this.txLog);
            return this.txClient.getCapabilitiesStatementQuick().getSoftware().getVersion();
        }
        catch (Exception e) {
            throw new FHIRException(this.formatMessage("Unable_to_connect_to_terminology_server_Use_parameter_tx_na_tun_run_without_using_terminology_services_to_validate_LOINC_SNOMED_ICDX_etc_Error__", e.getMessage()), e);
        }
    }

    public void loadFromFile(InputStream stream, String name, IWorkerContext.IContextResourceLoader loader) throws IOException, FHIRException {
        this.loadFromFile(stream, name, null);
    }

    public void loadFromFile(InputStream stream, String name, IWorkerContext.IContextResourceLoader loader, ILoadFilter filter) throws IOException, FHIRException {
        Resource f;
        try {
            if (loader != null) {
                f = loader.loadBundle(stream, false);
            } else {
                XmlParser xml = new XmlParser();
                f = xml.parse(stream);
            }
        }
        catch (DataFormatException e1) {
            throw new FHIRFormatError(this.formatMessage("Error_parsing_", name, e1.getMessage()), e1);
        }
        catch (Exception e1) {
            throw new FHIRFormatError(this.formatMessage("Error_parsing_", name, e1.getMessage()), e1);
        }
        if (f instanceof Bundle) {
            Resource bnd = f;
            for (Bundle.BundleEntryComponent e : ((Bundle)bnd).getEntry()) {
                if (e.getFullUrl() == null) {
                    this.logger.logDebugMessage(IWorkerContext.ILoggingService.LogCategory.CONTEXT, "unidentified resource in " + name + " (no fullUrl)");
                }
                if (filter != null && !filter.isOkToLoad(e.getResource())) continue;
                this.cacheResource(e.getResource());
            }
        } else if (f instanceof CanonicalResource && (filter == null || filter.isOkToLoad(f))) {
            this.cacheResource(f);
        }
    }

    private void loadFromFileJson(InputStream stream, String name, IWorkerContext.IContextResourceLoader loader, ILoadFilter filter, IWorkerContext.PackageVersion pi) throws IOException, FHIRException {
        Bundle f = null;
        try {
            if (loader != null) {
                f = loader.loadBundle(stream, true);
            } else {
                JsonParser json = new JsonParser();
                Resource r = json.parse(stream);
                if (r instanceof Bundle) {
                    f = (Bundle)r;
                } else if (filter == null || filter.isOkToLoad(f)) {
                    this.cacheResourceFromPackage(r, pi);
                }
            }
        }
        catch (FHIRFormatError e1) {
            throw new FHIRFormatError(e1.getMessage(), e1);
        }
        if (f != null) {
            for (Bundle.BundleEntryComponent e : f.getEntry()) {
                if (filter != null && !filter.isOkToLoad(e.getResource())) continue;
                this.cacheResourceFromPackage(e.getResource(), pi);
            }
        }
    }

    private void loadFromPack(String path, IWorkerContext.IContextResourceLoader loader) throws FileNotFoundException, IOException, FHIRException {
        this.loadFromStream(new CSFileInputStream(path), loader);
    }

    public void loadFromPackage(NpmPackage pi, IWorkerContext.IContextResourceLoader loader, ILoadFilter filter) throws IOException {
        if (this.progress) {
            System.out.println("Load Package " + pi.name() + "#" + pi.version());
        }
        this.loadedPackages.add(pi.id() + "#" + pi.version());
        for (String s2 : pi.listResources(loader.getTypes())) {
            try {
                this.loadDefinitionItem(s2, pi.load("package", s2), loader, filter, new IWorkerContext.PackageVersion(pi.id(), pi.version()));
            }
            catch (IOException | FHIRException e) {
                throw new FHIRException(this.formatMessage("Error_reading__from_package__", s2, pi.name(), pi.version(), e.getMessage()), e);
            }
        }
        for (String s2 : pi.list("other")) {
            this.binaries.put(s2, TextFile.streamToBytes(pi.load("other", s2)));
        }
        if (this.version == null) {
            this.version = pi.version();
        }
    }

    @Override
    public void loadFromPackage(NpmPackage pi, IWorkerContext.IContextResourceLoader loader, String ... types) throws FileNotFoundException, IOException, FHIRException {
        if (this.progress) {
            System.out.println("Load Package " + pi.name() + "#" + pi.version());
        }
        this.loadedPackages.add(pi.id() + "#" + pi.version());
        if (types.length == 0) {
            types = new String[]{"StructureDefinition", "ValueSet", "CodeSystem", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"};
        }
        for (String s2 : pi.listResources(types)) {
            this.loadDefinitionItem(s2, pi.load("package", s2), loader, null, new IWorkerContext.PackageVersion(pi.id(), pi.version()));
        }
        for (String s2 : pi.list("other")) {
            this.binaries.put(s2, TextFile.streamToBytes(pi.load("other", s2)));
        }
        if (this.version == null) {
            this.version = pi.version();
        }
    }

    public void loadFromFile(String file, IWorkerContext.IContextResourceLoader loader) throws IOException, FHIRException {
        this.loadDefinitionItem(file, new CSFileInputStream(file), loader, null, null);
    }

    private void loadFromStream(InputStream stream, IWorkerContext.IContextResourceLoader loader) throws IOException, FHIRException {
        ZipEntry ze;
        ZipInputStream zip = new ZipInputStream(stream);
        while ((ze = zip.getNextEntry()) != null) {
            this.loadDefinitionItem(ze.getName(), zip, loader, null, null);
            zip.closeEntry();
        }
        zip.close();
    }

    private void readVersionInfo(InputStream stream) throws IOException, DefinitionException {
        String[] vi;
        byte[] bytes = IOUtils.toByteArray(stream);
        this.binaries.put("version.info", bytes);
        for (String s2 : vi = new String(bytes).split("\\r?\\n")) {
            if (s2.startsWith("version=")) {
                if (this.version == null) {
                    this.version = s2.substring(8);
                } else if (!this.version.equals(s2.substring(8))) {
                    throw new DefinitionException(this.formatMessage("Version_mismatch_The_context_has_version__loaded_and_the_new_content_being_loaded_is_version_", this.version, s2.substring(8)));
                }
            }
            if (s2.startsWith("revision=")) {
                this.revision = s2.substring(9);
            }
            if (!s2.startsWith("date=")) continue;
            this.date = s2.substring(5);
        }
    }

    private void loadBytes(String name, InputStream stream) throws IOException {
        byte[] bytes = IOUtils.toByteArray(stream);
        this.binaries.put(name, bytes);
    }

    @Override
    public IParser getParser(ParserType type) {
        switch (type) {
            case JSON: {
                return this.newJsonParser();
            }
            case XML: {
                return this.newXmlParser();
            }
        }
        throw new Error(this.formatMessage("Parser_Type__not_supported", type.toString()));
    }

    @Override
    public IParser getParser(String type) {
        if (type.equalsIgnoreCase("JSON")) {
            return new JsonParser();
        }
        if (type.equalsIgnoreCase("XML")) {
            return new XmlParser();
        }
        throw new Error(this.formatMessage("Parser_Type__not_supported", type.toString()));
    }

    @Override
    public IParser newJsonParser() {
        return new JsonParser();
    }

    @Override
    public IParser newXmlParser() {
        return new XmlParser();
    }

    @Override
    public INarrativeGenerator getNarrativeGenerator(String prefix, String basePath) {
        return new NarrativeGenerator(prefix, basePath, this);
    }

    @Override
    public IResourceValidator newValidator() throws FHIRException {
        if (this.validatorFactory == null) {
            throw new Error(this.formatMessage("No_validator_configured", new Object[0]));
        }
        return this.validatorFactory.makeValidator(this);
    }

    @Override
    public List<String> getResourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (StructureDefinition sd : this.listStructures()) {
            if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            result.add(sd.getName());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List<String> getTypeNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (StructureDefinition sd : this.listStructures()) {
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            result.add(sd.getName());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public String getAbbreviation(String name) {
        return "xxx";
    }

    @Override
    public boolean isDatatype(String typeSimple) {
        return false;
    }

    @Override
    public boolean isResource(String t) {
        StructureDefinition sd;
        try {
            sd = this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + t);
        }
        catch (Exception e) {
            return false;
        }
        if (sd == null) {
            return false;
        }
        if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            return false;
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE;
    }

    @Override
    public boolean hasLinkFor(String typeSimple) {
        return false;
    }

    @Override
    public String getLinkFor(String corePath, String typeSimple) {
        return null;
    }

    @Override
    public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(StructureDefinition profile, ElementDefinition.ElementDefinitionBindingComponent binding, String path) {
        return null;
    }

    @Override
    public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(StructureDefinition profile, String url, String path) {
        return null;
    }

    @Override
    public String getLinkForProfile(StructureDefinition profile, String url) {
        return null;
    }

    public Questionnaire getQuestionnaire() {
        return this.questionnaire;
    }

    public void setQuestionnaire(Questionnaire questionnaire) {
        this.questionnaire = questionnaire;
    }

    @Override
    public List<StructureDefinition> allStructures() {
        ArrayList<StructureDefinition> result = new ArrayList<StructureDefinition>();
        HashSet<StructureDefinition> set = new HashSet<StructureDefinition>();
        for (StructureDefinition sd : this.listStructures()) {
            if (set.contains(sd)) continue;
            try {
                this.generateSnapshot(sd);
            }
            catch (Exception e) {
                System.out.println("Unable to generate snapshot for " + this.tail(sd.getUrl()) + " from " + this.tail(sd.getBaseDefinition()) + " because " + e.getMessage());
                e.printStackTrace();
            }
            result.add(sd);
            set.add(sd);
        }
        return result;
    }

    public void loadBinariesFromFolder(String folder) throws FileNotFoundException, Exception {
        for (String n : new File(folder).list()) {
            this.loadBytes(n, new FileInputStream(Utilities.path(folder, n)));
        }
    }

    public void loadBinariesFromFolder(NpmPackage pi) throws FileNotFoundException, Exception {
        for (String n : pi.list("other")) {
            this.loadBytes(n, pi.load("other", n));
        }
    }

    public void loadFromFolder(String folder) throws FileNotFoundException, Exception {
        for (String n : new File(folder).list()) {
            if (n.endsWith(".json")) {
                this.loadFromFile(Utilities.path(folder, n), new JsonParser());
                continue;
            }
            if (!n.endsWith(".xml")) continue;
            this.loadFromFile(Utilities.path(folder, n), new XmlParser());
        }
    }

    private void loadFromFile(String filename, IParser p) throws FileNotFoundException, Exception {
        try {
            Resource r = p.parse(new FileInputStream(filename));
            if (r.getResourceType() == ResourceType.Bundle) {
                for (Bundle.BundleEntryComponent e : ((Bundle)r).getEntry()) {
                    this.cacheResource(e.getResource());
                }
            } else {
                this.cacheResource(r);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public boolean prependLinks() {
        return false;
    }

    @Override
    public boolean hasCache() {
        return true;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public List<StructureMap> findTransformsforSource(String url) {
        ArrayList<StructureMap> res = new ArrayList<StructureMap>();
        for (StructureMap map : this.listTransforms()) {
            boolean match = false;
            boolean ok = true;
            for (StructureMap.StructureMapStructureComponent t : map.getStructure()) {
                if (t.getMode() != StructureMap.StructureMapModelMode.SOURCE) continue;
                match = match || t.getUrl().equals(url);
                ok = ok && t.getUrl().equals(url);
            }
            if (!match || !ok) continue;
            res.add(map);
        }
        return res;
    }

    public IValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public void setValidatorFactory(IValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
        T r = super.fetchResource(class_, uri);
        if (r instanceof StructureDefinition) {
            StructureDefinition p = (StructureDefinition)r;
            try {
                this.generateSnapshot(p);
            }
            catch (Exception e) {
                System.out.println("Unable to generate snapshot for " + uri + ": " + e.getMessage());
            }
        }
        return r;
    }

    @Override
    public StructureDefinition fetchRawProfile(String uri) {
        StructureDefinition r = super.fetchResource(StructureDefinition.class, uri);
        return r;
    }

    @Override
    public void generateSnapshot(StructureDefinition p) throws DefinitionException, FHIRException {
        this.generateSnapshot(p, false);
    }

    @Override
    public void generateSnapshot(StructureDefinition p, boolean logical) throws DefinitionException, FHIRException {
        if (!p.hasSnapshot() && (logical || p.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL)) {
            if (!p.hasBaseDefinition()) {
                throw new DefinitionException(this.formatMessage("Profile___has_no_base_and_no_snapshot", p.getName(), p.getUrl()));
            }
            StructureDefinition sd = this.fetchResource(StructureDefinition.class, p.getBaseDefinition());
            if (sd == null && "http://hl7.org/fhir/StructureDefinition/Base".equals(p.getBaseDefinition())) {
                sd = ProfileUtilities.makeBaseDefinition(p.getFhirVersion());
            }
            if (sd == null) {
                throw new DefinitionException(this.formatMessage("Profile___base__could_not_be_resolved", p.getName(), p.getUrl(), p.getBaseDefinition()));
            }
            ArrayList<ValidationMessage> msgs = new ArrayList<ValidationMessage>();
            ArrayList<String> errors = new ArrayList<String>();
            ProfileUtilities pu = new ProfileUtilities(this, msgs, this);
            pu.setAutoFixSliceNames(true);
            pu.setThrowException(false);
            if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
                pu.sortDifferential(sd, p, p.getUrl(), errors, true);
            }
            pu.setDebug(false);
            for (String err : errors) {
                msgs.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.EXCEPTION, p.getUserString("path"), "Error sorting Differential: " + err, ValidationMessage.IssueSeverity.ERROR));
            }
            pu.generateSnapshot(sd, p, p.getUrl(), Utilities.extractBaseUrl(sd.getUserString("path")), p.getName());
            for (ValidationMessage msg : msgs) {
                if ((this.ignoreProfileErrors || msg.getLevel() != ValidationMessage.IssueSeverity.ERROR) && msg.getLevel() != ValidationMessage.IssueSeverity.FATAL) continue;
                throw new DefinitionException(this.formatMessage("Profile___element__Error_generating_snapshot_", p.getName(), p.getUrl(), msg.getLocation(), msg.getMessage()));
            }
            if (!p.hasSnapshot()) {
                throw new FHIRException(this.formatMessage("Profile___Error_generating_snapshot", p.getName(), p.getUrl()));
            }
            pu = null;
        }
    }

    public boolean isIgnoreProfileErrors() {
        return this.ignoreProfileErrors;
    }

    public void setIgnoreProfileErrors(boolean ignoreProfileErrors) {
        this.ignoreProfileErrors = ignoreProfileErrors;
    }

    public String listMapUrls() {
        return Utilities.listCanonicalUrls(this.transforms.keys());
    }

    public boolean isProgress() {
        return this.progress;
    }

    public void setProgress(boolean progress) {
        this.progress = progress;
    }

    @Override
    public boolean hasPackage(String id, String ver) {
        return this.loadedPackages.contains(id + "#" + ver);
    }

    public static interface IValidatorFactory {
        public IResourceValidator makeValidator(IWorkerContext var1) throws FHIRException;
    }

    public static interface ILoadFilter {
        public boolean isOkToLoad(Resource var1);
    }
}

