/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.comparison;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class StructuralMatch<T> {
    private T left;
    private T right;
    private List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
    private List<StructuralMatch<T>> children = new ArrayList<StructuralMatch<T>>();

    public StructuralMatch() {
    }

    public StructuralMatch(T left, T right) {
        this.left = left;
        this.right = right;
    }

    public StructuralMatch(T left, T right, ValidationMessage msg) {
        this.left = left;
        this.right = right;
        if (msg != null) {
            this.messages.add(msg);
        }
    }

    public StructuralMatch(ValidationMessage msg, T right) {
        this.messages.add(msg);
        this.right = right;
    }

    public StructuralMatch(T left, ValidationMessage msg) {
        this.left = left;
        this.messages.add(msg);
    }

    public T getLeft() {
        return this.left;
    }

    public T getRight() {
        return this.right;
    }

    public List<StructuralMatch<T>> getChildren() {
        return this.children;
    }

    public T either() {
        return this.left != null ? this.left : this.right;
    }

    public boolean hasLeft() {
        return this.left != null;
    }

    public boolean hasRight() {
        return this.right != null;
    }

    public List<ValidationMessage> getMessages() {
        return this.messages;
    }
}

