/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.comparison;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.r5.comparison.ComparisonSession;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ResourceComparer {
    public static final String COLOR_NO_ROW_LEFT = "#ffffb3";
    public static final String COLOR_NO_CELL_LEFT = "#ffff4d";
    public static final String COLOR_NO_ROW_RIGHT = "#ffecb3";
    public static final String COLOR_NO_CELL_RIGHT = "#ffcc33";
    public static final String COLOR_DIFFERENT = "#f0b3ff";
    public static final String COLOR_ISSUE = "#ffad99";
    protected ComparisonSession session;

    public ResourceComparer(ComparisonSession session) {
        this.session = session;
    }

    public HierarchicalTableGenerator.Cell missingCell(HierarchicalTableGenerator gen) {
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "", null, null);
        return c;
    }

    public HierarchicalTableGenerator.Cell missingCell(HierarchicalTableGenerator gen, String color) {
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "", null, null);
        if (color != null) {
            c.setStyle("background-color: " + color);
        }
        return c;
    }

    public XhtmlNode renderErrors(ResourceComparison csc) {
        XhtmlNode div = new XhtmlNode(NodeType.Element, "div");
        XhtmlNode tbl = div.table("grid");
        for (ValidationMessage vm : csc.messages) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(vm.getLocation());
            tr.td().tx(vm.getMessage());
            tr.td().tx(vm.getLevel().getDisplay());
        }
        return div;
    }

    protected ValidationMessage vmI(ValidationMessage.IssueSeverity level, String message, String path) {
        ValidationMessage vm = new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path, message, level == ValidationMessage.IssueSeverity.NULL ? ValidationMessage.IssueSeverity.INFORMATION : level);
        return vm;
    }

    protected void vm(ValidationMessage.IssueSeverity level, String message, String path, List<ValidationMessage> genMessages, List<ValidationMessage> specMessages) {
        ValidationMessage vm = new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path, message, level == ValidationMessage.IssueSeverity.NULL ? ValidationMessage.IssueSeverity.INFORMATION : level);
        genMessages.add(vm);
        if (specMessages != null) {
            specMessages.add(vm);
        }
    }

    private String colorForLevel(ValidationMessage.IssueSeverity level) {
        switch (level) {
            case ERROR: {
                return "#ffcccc";
            }
            case FATAL: {
                return "#ff9999";
            }
            case WARNING: {
                return "#ffebcc";
            }
        }
        return "#ffffe6";
    }

    private String halfColorForLevel(ValidationMessage.IssueSeverity level) {
        switch (level) {
            case ERROR: {
                return "#ffeeee";
            }
            case FATAL: {
                return "#ffcccc";
            }
            case WARNING: {
                return "#fff4ee";
            }
        }
        return "#fffff2";
    }

    protected HierarchicalTableGenerator.Cell cellForMessages(HierarchicalTableGenerator gen, List<ValidationMessage> messages) {
        HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(gen);
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Piece piece = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "ul");
        cell.addPiece(piece);
        for (ValidationMessage msg : messages) {
            XhtmlNode li = new XhtmlNode(NodeType.Element, "li");
            piece.getChildren().add(li);
            li.style("background-color: " + this.halfColorForLevel(msg.getLevel()));
            li.tx(msg.getMessage());
        }
        return cell;
    }

    public class ResourceComparison {
        private String id;
        protected List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

        public List<ValidationMessage> getMessages() {
            return this.messages;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

