/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.comparison;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.comparison.CodeSystemComparer;
import org.hl7.fhir.r5.comparison.ProfileComparer;
import org.hl7.fhir.r5.comparison.ResourceComparer;
import org.hl7.fhir.r5.comparison.ValueSetComparer;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;

public class ComparisonSession {
    private Map<String, ResourceComparer.ResourceComparison> compares = new HashMap<String, ResourceComparer.ResourceComparison>();
    private IWorkerContext context;
    private String sessiondId;
    private int count;

    public ComparisonSession(IWorkerContext context) {
        this.context = context;
        this.sessiondId = UUID.randomUUID().toString().toLowerCase();
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    public ResourceComparer.ResourceComparison compare(String left, String right) throws DefinitionException, FHIRFormatError, IOException {
        CanonicalResource l = (CanonicalResource)this.context.fetchResource(Resource.class, left);
        if (l == null) {
            throw new DefinitionException("Unable to resolve " + left);
        }
        CanonicalResource r = (CanonicalResource)this.context.fetchResource(Resource.class, right);
        if (r == null) {
            throw new DefinitionException("Unable to resolve " + right);
        }
        return this.compare(l, r);
    }

    public ResourceComparer.ResourceComparison compare(CanonicalResource left, CanonicalResource right) throws DefinitionException, FHIRFormatError, IOException {
        String key = this.key(left.getUrl(), left.getVersion(), right.getUrl(), right.getVersion());
        if (this.compares.containsKey(key)) {
            return this.compares.get(key);
        }
        this.compares.put(key, null);
        if (left instanceof CodeSystem && right instanceof CodeSystem) {
            CodeSystemComparer cs = new CodeSystemComparer(this);
            CodeSystemComparer.CodeSystemComparison csc = cs.compare((CodeSystem)left, (CodeSystem)right);
            this.compares.put(key, csc);
            return csc;
        }
        if (left instanceof ValueSet && right instanceof ValueSet) {
            ValueSetComparer cs = new ValueSetComparer(this);
            ValueSetComparer.ValueSetComparison csc = cs.compare((ValueSet)left, (ValueSet)right);
            this.compares.put(key, csc);
            return csc;
        }
        if (left instanceof StructureDefinition && right instanceof StructureDefinition) {
            ProfileComparer cs = new ProfileComparer(this);
            ProfileComparer.ProfileComparison csc = cs.compare((StructureDefinition)left, (StructureDefinition)right);
            this.compares.put(key, csc);
            return csc;
        }
        throw new FHIRException("Unable to compare ");
    }

    private String key(String urlL, String verL, String urlR, String verR) {
        return urlL + "|" + verL + "||" + urlR + "|" + verR;
    }

    public void identify(CanonicalResource res) {
        ++this.count;
        res.setId(this.sessiondId + "-" + this.count);
        res.setUrl("http://hl7.org/fhir/comparison/" + res.fhirType() + "/" + res.getId());
    }

    public void identify(ResourceComparer.ResourceComparison res) {
        ++this.count;
        res.setId(this.sessiondId + "-" + this.count);
    }
}

