/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.comparison;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.comparison.ComparisonSession;
import org.hl7.fhir.r5.comparison.ResourceComparer;
import org.hl7.fhir.r5.comparison.StructuralMatch;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public abstract class CanonicalResourceComparer
extends ResourceComparer {
    public CanonicalResourceComparer(ComparisonSession session) {
        super(session);
    }

    protected void compareMetadata(CanonicalResource left, CanonicalResource right, Map<String, StructuralMatch<String>> comp, CanonicalResourceComparison<? extends CanonicalResource> res) {
        this.comparePrimitives("url", left.getUrlElement(), right.getUrlElement(), comp, ValidationMessage.IssueSeverity.INFORMATION, res);
        this.comparePrimitives("version", left.getVersionElement(), right.getVersionElement(), comp, ValidationMessage.IssueSeverity.INFORMATION, res);
        this.comparePrimitives("name", left.getNameElement(), right.getNameElement(), comp, ValidationMessage.IssueSeverity.INFORMATION, res);
        this.comparePrimitives("title", left.getTitleElement(), right.getTitleElement(), comp, ValidationMessage.IssueSeverity.INFORMATION, res);
        this.comparePrimitives("status", left.getStatusElement(), right.getStatusElement(), comp, ValidationMessage.IssueSeverity.INFORMATION, res);
        this.comparePrimitives("experimental", left.getExperimentalElement(), right.getExperimentalElement(), comp, ValidationMessage.IssueSeverity.WARNING, res);
        this.comparePrimitives("date", left.getDateElement(), right.getDateElement(), comp, ValidationMessage.IssueSeverity.INFORMATION, res);
        this.comparePrimitives("publisher", left.getPublisherElement(), right.getPublisherElement(), comp, ValidationMessage.IssueSeverity.INFORMATION, res);
        this.comparePrimitives("description", left.getDescriptionElement(), right.getDescriptionElement(), comp, ValidationMessage.IssueSeverity.NULL, res);
        this.comparePrimitives("purpose", left.getPurposeElement(), right.getPurposeElement(), comp, ValidationMessage.IssueSeverity.NULL, res);
        this.comparePrimitives("copyright", left.getCopyrightElement(), right.getCopyrightElement(), comp, ValidationMessage.IssueSeverity.INFORMATION, res);
    }

    protected void comparePrimitives(String name, PrimitiveType l, PrimitiveType r, Map<String, StructuralMatch<String>> comp, ValidationMessage.IssueSeverity level, CanonicalResourceComparison<? extends CanonicalResource> res) {
        StructuralMatch<Object> match = null;
        if (l.isEmpty() && r.isEmpty()) {
            match = new StructuralMatch<Object>(null, null, null);
        } else if (l.isEmpty()) {
            match = new StructuralMatch<String>(null, r.primitiveValue(), this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added this item", this.fhirType() + "." + name));
        } else if (r.isEmpty()) {
            match = new StructuralMatch<Object>(l.primitiveValue(), null, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed this item", this.fhirType() + "." + name));
        } else if (!l.hasValue() && !r.hasValue()) {
            match = new StructuralMatch<Object>(null, null, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "No Value", this.fhirType() + "." + name));
        } else if (!l.hasValue()) {
            match = new StructuralMatch<String>(null, r.primitiveValue(), this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "No Value on Left", this.fhirType() + "." + name));
        } else if (!r.hasValue()) {
            match = new StructuralMatch<Object>(l.primitiveValue(), null, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "No Value on Right", this.fhirType() + "." + name));
        } else if (l.getValue().equals(r.getValue())) {
            match = new StructuralMatch<String>(l.primitiveValue(), r.primitiveValue(), null);
        } else {
            match = new StructuralMatch<String>(l.primitiveValue(), r.primitiveValue(), this.vmI(level, "Values Differ", this.fhirType() + "." + name));
            if (level != ValidationMessage.IssueSeverity.NULL) {
                res.getMessages().add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, this.fhirType() + "." + name, "Values for " + name + " differ: '" + l.primitiveValue() + "' vs '" + r.primitiveValue() + "'", level));
            }
        }
        comp.put(name, match);
    }

    protected abstract String fhirType();

    public XhtmlNode renderMetadata(CanonicalResourceComparison<? extends CanonicalResource> comparison, String id, String prefix) throws FHIRException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(Utilities.path("[tmp]", "compare"), false);
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = hierarchicalTableGenerator.new HierarchicalTableGenerator.TableModel(id, true);
        model.setAlternating(true);
        List<HierarchicalTableGenerator.Title> list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(hierarchicalTableGenerator2.new HierarchicalTableGenerator.Title(null, null, "Name", "Property Name", null, 100));
        List<HierarchicalTableGenerator.Title> list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(hierarchicalTableGenerator3.new HierarchicalTableGenerator.Title(null, null, "Value", "The value of the property", null, 200, 2));
        List<HierarchicalTableGenerator.Title> list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(hierarchicalTableGenerator4.new HierarchicalTableGenerator.Title(null, null, "Comments", "Additional information about the comparison", null, 200));
        for (String n : this.sorted(comparison.getMetadata().keySet())) {
            StructuralMatch<String> t = comparison.getMetadata().get(n);
            this.addRow(gen, model.getRows(), n, t);
        }
        return gen.generate(model, prefix, 0, null);
    }

    private void addRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, String name, StructuralMatch<String> t) {
        HierarchicalTableGenerator.Row r = gen.new HierarchicalTableGenerator.Row();
        rows.add(r);
        List<HierarchicalTableGenerator.Cell> list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(hierarchicalTableGenerator.new HierarchicalTableGenerator.Cell(null, null, name, null, null));
        if (t.hasLeft() && t.hasRight()) {
            if (t.getLeft().equals(t.getRight())) {
                List<HierarchicalTableGenerator.Cell> list2 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                list2.add(hierarchicalTableGenerator2.new HierarchicalTableGenerator.Cell(null, null, t.getLeft(), null, null).span(2));
            } else {
                List<HierarchicalTableGenerator.Cell> list3 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator3);
                list3.add(hierarchicalTableGenerator3.new HierarchicalTableGenerator.Cell(null, null, t.getLeft(), null, null).setStyle("background-color: #f0b3ff"));
                List<HierarchicalTableGenerator.Cell> list4 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator4);
                list4.add(hierarchicalTableGenerator4.new HierarchicalTableGenerator.Cell(null, null, t.getRight(), null, null).setStyle("background-color: #f0b3ff"));
            }
        } else if (t.hasLeft()) {
            r.setColor("#ffecb3");
            List<HierarchicalTableGenerator.Cell> list5 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator5);
            list5.add(hierarchicalTableGenerator5.new HierarchicalTableGenerator.Cell(null, null, t.getLeft(), null, null));
            r.getCells().add(this.missingCell(gen));
        } else if (t.hasRight()) {
            r.setColor("#ffffb3");
            r.getCells().add(this.missingCell(gen));
            List<HierarchicalTableGenerator.Cell> list6 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator6);
            list6.add(hierarchicalTableGenerator6.new HierarchicalTableGenerator.Cell(null, null, t.getRight(), null, null));
        } else {
            r.getCells().add(this.missingCell(gen).span(2));
        }
        r.getCells().add(this.cellForMessages(gen, t.getMessages()));
    }

    private List<String> sorted(Set<String> keys) {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(keys);
        Collections.sort(res);
        return res;
    }

    public static class CanonicalResourceComparison<T extends CanonicalResource>
    extends ResourceComparer.ResourceComparison {
        protected T left;
        protected T right;
        protected T union;
        protected T intersection;
        protected Map<String, StructuralMatch<String>> metadata = new HashMap<String, StructuralMatch<String>>();
        final /* synthetic */ CanonicalResourceComparer this$0;

        public CanonicalResourceComparison(T left, T right) {
            this.this$0 = this$0;
            this.left = left;
            this.right = right;
        }

        public T getLeft() {
            return this.left;
        }

        public T getRight() {
            return this.right;
        }

        public T getUnion() {
            return this.union;
        }

        public T getIntersection() {
            return this.intersection;
        }

        public Map<String, StructuralMatch<String>> getMetadata() {
            return this.metadata;
        }

        public void setLeft(T left) {
            this.left = left;
        }

        public void setRight(T right) {
            this.right = right;
        }

        public void setUnion(T union) {
            this.union = union;
        }

        public void setIntersection(T intersection) {
            this.intersection = intersection;
        }
    }
}

