/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils.formats;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.utilities.TextStreamWriter;

public class CSVWriter
extends TextStreamWriter {
    private StructureDefinition def;
    private List<StructureDefinition.StructureDefinitionMappingComponent> mapKeys = new ArrayList<StructureDefinition.StructureDefinitionMappingComponent>();
    private List<CSVLine> lines = new ArrayList<CSVLine>();
    private XmlParser xml = new XmlParser();
    private JsonParser json = new JsonParser();
    private boolean asXml;

    public CSVWriter(OutputStream out, StructureDefinition def, boolean asXml) throws UnsupportedEncodingException {
        super(out);
        this.asXml = asXml;
        this.def = def;
        CSVLine header = new CSVLine();
        this.lines.add(header);
        header.addString("Path");
        header.addString("Slice Name");
        header.addString("Alias(s)");
        header.addString("Label");
        header.addString("Min");
        header.addString("Max");
        header.addString("Must Support?");
        header.addString("Is Modifier?");
        header.addString("Is Summary?");
        header.addString("Type(s)");
        header.addString("Short");
        header.addString("Definition");
        header.addString("Comments");
        header.addString("Requirements");
        header.addString("Default Value");
        header.addString("Meaning When Missing");
        header.addString("Fixed Value");
        header.addString("Pattern");
        header.addString("Example");
        header.addString("Minimum Value");
        header.addString("Maximum Value");
        header.addString("Maximum Length");
        header.addString("Binding Strength");
        header.addString("Binding Description");
        header.addString("Binding Value Set");
        header.addString("Code");
        header.addString("Slicing Discriminator");
        header.addString("Slicing Description");
        header.addString("Slicing Ordered");
        header.addString("Slicing Rules");
        header.addString("Base Path");
        header.addString("Base Min");
        header.addString("Base Max");
        header.addString("Condition(s)");
        header.addString("Constraint(s)");
        for (StructureDefinition.StructureDefinitionMappingComponent map : def.getMapping()) {
            header.addString("Mapping: " + map.getName());
        }
    }

    public void processElement(ElementDefinition ed) throws Exception {
        CSVLine line = new CSVLine();
        this.lines.add(line);
        line.addString(ed.getPath());
        line.addString(ed.getSliceName());
        line.addString(this.itemList(ed.getAlias()));
        line.addString(ed.getLabel());
        line.addValue(ed.getMin());
        line.addValue(ed.getMax());
        line.addString(ed.getMustSupport() ? "Y" : "");
        line.addString(ed.getIsModifier() ? "Y" : "");
        line.addString(ed.getIsSummary() ? "Y" : "");
        line.addString(this.itemList(ed.getType()));
        line.addString(ed.getShort());
        line.addString(ed.getDefinition());
        line.addString(ed.getComment());
        line.addString(ed.getRequirements());
        line.addString(ed.getDefaultValue() != null ? this.renderType(ed.getDefaultValue()) : "");
        line.addString(ed.getMeaningWhenMissing());
        line.addString(ed.hasFixed() ? this.renderType(ed.getFixed()) : "");
        line.addString(ed.hasPattern() ? this.renderType(ed.getPattern()) : "");
        line.addString(ed.hasExample() ? this.renderType(ed.getExample().get(0).getValue()) : "");
        line.addString(ed.hasMinValue() ? this.renderType(ed.getMinValue()) : "");
        line.addString(ed.hasMaxValue() ? this.renderType(ed.getMaxValue()) : "");
        line.addValue(ed.hasMaxLength() ? Integer.toString(ed.getMaxLength()) : "");
        if (ed.hasBinding()) {
            line.addString(ed.getBinding().getStrength() != null ? ed.getBinding().getStrength().toCode() : "");
            line.addString(ed.getBinding().getDescription());
            if (ed.getBinding().getValueSet() == null) {
                line.addString("");
            } else {
                line.addString(ed.getBinding().getValueSet());
            }
        } else {
            line.addValue("");
            line.addValue("");
            line.addValue("");
        }
        line.addString(this.itemList(ed.getCode()));
        if (ed.hasSlicing()) {
            line.addString(this.itemList(ed.getSlicing().getDiscriminator()));
            line.addString(ed.getSlicing().getDescription());
            line.addBoolean(ed.getSlicing().getOrdered());
            line.addString(ed.getSlicing().getRules() != null ? ed.getSlicing().getRules().toCode() : "");
        } else {
            line.addValue("");
            line.addValue("");
            line.addValue("");
        }
        if (ed.getBase() != null) {
            line.addString(ed.getBase().getPath());
            line.addValue(ed.getBase().getMin());
            line.addValue(ed.getBase().getMax());
        } else {
            line.addValue("");
            line.addValue("");
            line.addValue("");
        }
        line.addString(this.itemList(ed.getCondition()));
        line.addString(this.itemList(ed.getConstraint()));
        for (StructureDefinition.StructureDefinitionMappingComponent mapKey : this.def.getMapping()) {
            for (ElementDefinition.ElementDefinitionMappingComponent map : ed.getMapping()) {
                if (!map.getIdentity().equals(mapKey.getIdentity())) continue;
                line.addString(map.getMap());
            }
        }
    }

    private String itemList(List l) {
        StringBuilder s2 = new StringBuilder();
        for (int i = 0; i < l.size(); ++i) {
            Element c;
            Element t;
            Object o = l.get(i);
            String val = "";
            if (o instanceof StringType) {
                val = (String)((StringType)o).getValue();
            } else if (o instanceof UriType) {
                val = (String)((UriType)o).getValue();
            } else if (o instanceof IdType) {
                val = ((IdType)o).getValue();
            } else if (o instanceof Enumeration) {
                val = o.toString();
            } else if (o instanceof ElementDefinition.TypeRefComponent) {
                t = (ElementDefinition.TypeRefComponent)o;
                val = ((ElementDefinition.TypeRefComponent)t).getWorkingCode() + (((ElementDefinition.TypeRefComponent)t).getProfile() == null ? "" : " {" + ((ElementDefinition.TypeRefComponent)t).getProfile() + "}") + (((ElementDefinition.TypeRefComponent)t).getTargetProfile() == null ? "" : " {" + ((ElementDefinition.TypeRefComponent)t).getTargetProfile() + "}") + (((ElementDefinition.TypeRefComponent)t).getAggregation() == null || ((ElementDefinition.TypeRefComponent)t).getAggregation().isEmpty() ? "" : " (" + this.itemList(((ElementDefinition.TypeRefComponent)t).getAggregation()) + ")");
            } else if (o instanceof Coding) {
                t = (Coding)o;
                val = (((Coding)t).getSystem() == null ? "" : ((Coding)t).getSystem()) + (((Coding)t).getCode() == null ? "" : "#" + ((Coding)t).getCode()) + (((Coding)t).getDisplay() == null ? "" : " (" + ((Coding)t).getDisplay() + ")");
            } else if (o instanceof ElementDefinition.ElementDefinitionConstraintComponent) {
                c = (ElementDefinition.ElementDefinitionConstraintComponent)o;
                val = ((ElementDefinition.ElementDefinitionConstraintComponent)c).getKey() + ":" + ((ElementDefinition.ElementDefinitionConstraintComponent)c).getHuman() + " {" + ((ElementDefinition.ElementDefinitionConstraintComponent)c).getExpression() + "}";
            } else if (o instanceof ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent) {
                c = (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent)o;
                val = ((ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent)c).getType().toCode() + ":" + ((ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent)c).getPath() + "}";
            } else {
                val = o.toString();
                val = val.substring(val.indexOf("[") + 1);
                val = val.substring(0, val.indexOf("]"));
            }
            s2 = s2.append(val);
            if (i != 0) continue;
            s2.append("\n");
        }
        return s2.toString();
    }

    private String renderType(Type value) throws Exception {
        String s2 = null;
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        if (this.asXml) {
            this.xml.setOutputStyle(IParser.OutputStyle.PRETTY);
            this.xml.compose((OutputStream)bs, "", value);
            bs.close();
            s2 = bs.toString();
            s2 = s2.substring(s2.indexOf("\n") + 2);
        } else {
            this.json.setOutputStyle(IParser.OutputStyle.PRETTY);
            this.json.compose(bs, value, "");
            bs.close();
            s2 = bs.toString();
        }
        return s2;
    }

    public void dump() throws IOException {
        for (CSVLine l : this.lines) {
            this.ln(l.toString());
        }
        this.flush();
        this.close();
    }

    private class CSVLine {
        private String line = "";

        private CSVLine() {
        }

        public void addString(String s2) {
            this.line = this.line + (this.line.equals("") ? "" : ",") + "\"" + this.csvEscape(s2) + "\"";
        }

        public void addString(StringType s2) {
            this.addString(s2 == null ? "" : (String)s2.getValue());
        }

        public void addValue(String s2) {
            this.line = this.line + (this.line.equals("") ? "" : ",") + s2;
        }

        public void addValue(int s2) {
            this.line = this.line + (this.line.equals("") ? "" : ",") + s2;
        }

        public void addBoolean(boolean b) {
            this.addValue(b ? "Y" : "");
        }

        protected String csvEscape(String s2) {
            if (s2 == null) {
                return "";
            }
            if (s2.contains("\"")) {
                return s2.substring(0, s2.indexOf("\"")) + "\"\"" + this.csvEscape(s2.substring(s2.indexOf("\"") + 1));
            }
            return s2;
        }

        public String toString() {
            return this.line;
        }
    }
}

