/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.terminologies;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParserException;

public class LoincToDEConvertor {
    private String dest;
    private String definitions;
    private Document xml;
    private Bundle bundle;
    private DateTimeType now;

    public static void main(String[] args) throws FHIRFormatError, IOException, XmlPullParserException, SAXException, ParserConfigurationException {
        if (args.length == 0) {
            System.out.println("FHIR LOINC to CDE convertor. ");
            System.out.println("");
            System.out.println("This tool converts from LOINC to A set of DataElement definitions.");
            System.out.println("");
            System.out.println("Usage: [jar(path?)] [dest] (-defn [definitions]) where: ");
            System.out.println("* [dest] is a file name of the bundle to produce");
            System.out.println("* [definitions] is the file name of a file produced by exporting the main LOINC table from the mdb to XML");
            System.out.println("");
        } else {
            LoincToDEConvertor exe = new LoincToDEConvertor();
            exe.setDest(args[0]);
            for (int i = 1; i < args.length; ++i) {
                if (!args[i].equals("-defn")) continue;
                exe.setDefinitions(args[i + 1]);
            }
            exe.process();
        }
    }

    public String getDest() {
        return this.dest;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public String getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(String definitions) {
        this.definitions = definitions;
    }

    public Bundle process(String sourceFile) throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        this.definitions = sourceFile;
        this.log("Begin. Produce Loinc CDEs in " + this.dest + " from " + this.definitions);
        this.loadLoinc();
        this.log("LOINC loaded");
        this.now = DateTimeType.now();
        this.bundle = new Bundle();
        this.bundle.setType(Bundle.BundleType.COLLECTION);
        this.bundle.setId("http://hl7.org/fhir/commondataelement/loinc");
        this.bundle.setMeta(new Meta().setLastUpdatedElement(InstantType.now()));
        this.processLoincCodes();
        return this.bundle;
    }

    public void process() throws FHIRFormatError, IOException, XmlPullParserException, SAXException, ParserConfigurationException {
        this.log("Begin. Produce Loinc CDEs in " + this.dest + " from " + this.definitions);
        this.loadLoinc();
        this.log("LOINC loaded");
        this.now = DateTimeType.now();
        this.bundle = new Bundle();
        this.bundle.setId("http://hl7.org/fhir/commondataelement/loinc");
        this.bundle.setMeta(new Meta().setLastUpdatedElement(InstantType.now()));
        this.processLoincCodes();
        if (this.dest != null) {
            this.log("Saving...");
            this.saveBundle();
        }
        this.log("Done");
    }

    private void log(String string) {
        System.out.println(string);
    }

    private void loadLoinc() throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.xml = builder.parse(new FileInputStream(this.definitions));
    }

    private void saveBundle() throws FHIRFormatError, IOException, XmlPullParserException {
        XmlParser xml = new XmlParser();
        FileOutputStream s2 = new FileOutputStream(this.dest);
        xml.compose((OutputStream)s2, (Resource)this.bundle, true);
        s2.close();
    }

    private String col(Element row, String name) {
        Element e = XMLUtil.getNamedChild(row, name);
        if (e == null) {
            return null;
        }
        String text = e.getTextContent();
        return text;
    }

    private boolean hasCol(Element row, String name) {
        return Utilities.noString(this.col(row, name));
    }

    private void processLoincCodes() {
        Element row = XMLUtil.getFirstChild(this.xml.getDocumentElement());
        int i = 0;
        while (row != null) {
            if (++i % 1000 == 0) {
                System.out.print(".");
            }
            String code = this.col(row, "LOINC_NUM");
            String comp = this.col(row, "COMPONENT");
            row = XMLUtil.getNextSibling(row);
        }
        System.out.println("done");
    }

    private String makeType(String type, String id) {
        if (Utilities.noString(type)) {
            return null;
        }
        if (type.equals("PQ")) {
            return "Quantity";
        }
        if (type.equals("ED")) {
            return "Attachment";
        }
        if (type.equals("TS")) {
            return "dateTime";
        }
        if (type.equals("ST")) {
            return "string";
        }
        if (type.equals("II")) {
            return "Identifier";
        }
        if (type.equals("CWE")) {
            return "CodeableConcept";
        }
        if (type.equals("CD") || type.equals("CO")) {
            return "CodeableConcept";
        }
        if (type.equals("PN")) {
            return "HumanName";
        }
        if (type.equals("EN")) {
            return "HumanName";
        }
        if (type.equals("AD")) {
            return "Address";
        }
        if (type.equals("BL")) {
            return "boolean";
        }
        if (type.equals("GTS")) {
            return "Schedule";
        }
        if (type.equals("INT")) {
            return "integer";
        }
        if (type.equals("CS")) {
            return "code";
        }
        if (type.equals("IVL_TS")) {
            return "Period";
        }
        if (type.equals("MMAT") || type.equals("PRF") || type.equals("TX") || type.equals("DT") || type.equals("FT")) {
            return null;
        }
        throw new Error("unmapped type " + type + " for LOINC code " + id);
    }

    private CodeableConcept makeUnits(String text, String ucum) {
        if (Utilities.noString(text) && Utilities.noString(ucum)) {
            return null;
        }
        CodeableConcept cc = new CodeableConcept();
        cc.setText(text);
        cc.getCoding().add(new Coding().setCode(ucum).setSystem("http://unitsofmeasure.org"));
        return cc;
    }

    public Bundle getBundle() {
        return this.bundle;
    }
}

