/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum VisionProduct {
    LENS,
    CONTACT,
    NULL;


    public static VisionProduct fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("lens".equals(codeString)) {
            return LENS;
        }
        if ("contact".equals(codeString)) {
            return CONTACT;
        }
        throw new FHIRException("Unknown VisionProduct code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case LENS: {
                return "lens";
            }
            case CONTACT: {
                return "contact";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/ex-visionprescriptionproduct";
    }

    public String getDefinition() {
        switch (this) {
            case LENS: {
                return "A lens to be fitted to a frame to comprise a pair of glasses.";
            }
            case CONTACT: {
                return "A lens to be fitted for wearing directly on an eye.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case LENS: {
                return "Lens";
            }
            case CONTACT: {
                return "Contact Lens";
            }
        }
        return "?";
    }
}

