/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3Sequencing {
    A,
    D,
    N,
    NULL;


    public static V3Sequencing fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("A".equals(codeString)) {
            return A;
        }
        if ("D".equals(codeString)) {
            return D;
        }
        if ("N".equals(codeString)) {
            return N;
        }
        throw new FHIRException("Unknown V3Sequencing code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case A: {
                return "A";
            }
            case D: {
                return "D";
            }
            case N: {
                return "N";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-Sequencing";
    }

    public String getDefinition() {
        switch (this) {
            case A: {
                return "Ascending sequence order.";
            }
            case D: {
                return "Descending sequence order.";
            }
            case N: {
                return "No enforced sequence order.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case A: {
                return "Ascending";
            }
            case D: {
                return "Descending";
            }
            case N: {
                return "None";
            }
        }
        return "?";
    }
}

