/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3HL7ContextConductionStyle {
    C,
    I,
    V,
    NULL;


    public static V3HL7ContextConductionStyle fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("C".equals(codeString)) {
            return C;
        }
        if ("I".equals(codeString)) {
            return I;
        }
        if ("V".equals(codeString)) {
            return V;
        }
        throw new FHIRException("Unknown V3HL7ContextConductionStyle code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case C: {
                return "C";
            }
            case I: {
                return "I";
            }
            case V: {
                return "V";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-HL7ContextConductionStyle";
    }

    public String getDefinition() {
        switch (this) {
            case C: {
                return "Definition: Context conduction is defined using the contextConductionCode and contextConductionInd attributes on ActRelationship and Participation.\r\n\n                        \n                           UsageNotes: This approach is deprecated as of March, 2010.";
            }
            case I: {
                return "Definition: Context conduction is not explicitly defined.  The recipient of an instance must infer conduction based on the semantics of the model and what is deemed \"reasonable\".\r\n\n                        \n                           UsageNotes: Because this approach can lead to variation in instance interpretation, its use is discouraged.";
            }
            case V: {
                return "Definition: Context conduction is defined using the ActRelationship.blockedContextActRelationshipType and blockedContextParticipationType attributes and the \"conductible\" property on the ActRelationshipType and ParticipationType code systems.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case C: {
                return "conduction-indicator-based";
            }
            case I: {
                return "inferred";
            }
            case V: {
                return "vocabulary-based";
            }
        }
        return "?";
    }
}

