/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum StructureDefinitionKind {
    PRIMITIVETYPE,
    COMPLEXTYPE,
    RESOURCE,
    LOGICAL,
    NULL;


    public static StructureDefinitionKind fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("primitive-type".equals(codeString)) {
            return PRIMITIVETYPE;
        }
        if ("complex-type".equals(codeString)) {
            return COMPLEXTYPE;
        }
        if ("resource".equals(codeString)) {
            return RESOURCE;
        }
        if ("logical".equals(codeString)) {
            return LOGICAL;
        }
        throw new FHIRException("Unknown StructureDefinitionKind code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PRIMITIVETYPE: {
                return "primitive-type";
            }
            case COMPLEXTYPE: {
                return "complex-type";
            }
            case RESOURCE: {
                return "resource";
            }
            case LOGICAL: {
                return "logical";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/structure-definition-kind";
    }

    public String getDefinition() {
        switch (this) {
            case PRIMITIVETYPE: {
                return "A primitive type that has a value and an extension. These can be used throughout complex datatype, Resource and extension definitions. Only the base specification can define primitive types.";
            }
            case COMPLEXTYPE: {
                return "A  complex structure that defines a set of data elements that is suitable for use in 'resources'. The base specification defines a number of complex types, and other specifications can define additional types. These structures do not have a maintained identity.";
            }
            case RESOURCE: {
                return "A 'resource' - a directed acyclic graph of elements that aggregrates other types into an identifiable entity. The base FHIR resources are defined by the FHIR specification itself but other 'resources' can be defined in additional specifications (though these will not be recognised as 'resources' by the FHIR specification (i.e. they do not get end-points etc, or act as the targets of references in FHIR defined resources - though other specificatiosn can treat them this way).";
            }
            case LOGICAL: {
                return "A pattern or a template that is not intended to be a real resource or complex type.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PRIMITIVETYPE: {
                return "Primitive Data Type";
            }
            case COMPLEXTYPE: {
                return "Complex Data Type";
            }
            case RESOURCE: {
                return "Resource";
            }
            case LOGICAL: {
                return "Logical";
            }
        }
        return "?";
    }
}

