/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ResearchSubjectStatus {
    CANDIDATE,
    ELIGIBLE,
    FOLLOWUP,
    INELIGIBLE,
    NOTREGISTERED,
    OFFSTUDY,
    ONSTUDY,
    ONSTUDYINTERVENTION,
    ONSTUDYOBSERVATION,
    PENDINGONSTUDY,
    POTENTIALCANDIDATE,
    SCREENING,
    WITHDRAWN,
    NULL;


    public static ResearchSubjectStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("candidate".equals(codeString)) {
            return CANDIDATE;
        }
        if ("eligible".equals(codeString)) {
            return ELIGIBLE;
        }
        if ("follow-up".equals(codeString)) {
            return FOLLOWUP;
        }
        if ("ineligible".equals(codeString)) {
            return INELIGIBLE;
        }
        if ("not-registered".equals(codeString)) {
            return NOTREGISTERED;
        }
        if ("off-study".equals(codeString)) {
            return OFFSTUDY;
        }
        if ("on-study".equals(codeString)) {
            return ONSTUDY;
        }
        if ("on-study-intervention".equals(codeString)) {
            return ONSTUDYINTERVENTION;
        }
        if ("on-study-observation".equals(codeString)) {
            return ONSTUDYOBSERVATION;
        }
        if ("pending-on-study".equals(codeString)) {
            return PENDINGONSTUDY;
        }
        if ("potential-candidate".equals(codeString)) {
            return POTENTIALCANDIDATE;
        }
        if ("screening".equals(codeString)) {
            return SCREENING;
        }
        if ("withdrawn".equals(codeString)) {
            return WITHDRAWN;
        }
        throw new FHIRException("Unknown ResearchSubjectStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CANDIDATE: {
                return "candidate";
            }
            case ELIGIBLE: {
                return "eligible";
            }
            case FOLLOWUP: {
                return "follow-up";
            }
            case INELIGIBLE: {
                return "ineligible";
            }
            case NOTREGISTERED: {
                return "not-registered";
            }
            case OFFSTUDY: {
                return "off-study";
            }
            case ONSTUDY: {
                return "on-study";
            }
            case ONSTUDYINTERVENTION: {
                return "on-study-intervention";
            }
            case ONSTUDYOBSERVATION: {
                return "on-study-observation";
            }
            case PENDINGONSTUDY: {
                return "pending-on-study";
            }
            case POTENTIALCANDIDATE: {
                return "potential-candidate";
            }
            case SCREENING: {
                return "screening";
            }
            case WITHDRAWN: {
                return "withdrawn";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/research-subject-status";
    }

    public String getDefinition() {
        switch (this) {
            case CANDIDATE: {
                return "An identified person that can be considered for inclusion in a study.";
            }
            case ELIGIBLE: {
                return "A person that has met the eligibility criteria for inclusion in a study.";
            }
            case FOLLOWUP: {
                return "A person is no longer receiving study intervention and/or being evaluated with tests and procedures according to the protocol, but they are being monitored on a protocol-prescribed schedule.";
            }
            case INELIGIBLE: {
                return "A person who did not meet one or more criteria required for participation in a study is considered to have failed screening or\nis ineligible for the study.";
            }
            case NOTREGISTERED: {
                return "A person for whom registration was not completed.";
            }
            case OFFSTUDY: {
                return "A person that has ended their participation on a study either because their treatment/observation is complete or through not\nresponding, withdrawal, non-compliance and/or adverse event.";
            }
            case ONSTUDY: {
                return "A person that is enrolled or registered on a study.";
            }
            case ONSTUDYINTERVENTION: {
                return "The person is receiving the treatment or participating in an activity (e.g. yoga, diet, etc.) that the study is evaluating.";
            }
            case ONSTUDYOBSERVATION: {
                return "The subject is being evaluated via tests and assessments according to the study calendar, but is not receiving any intervention. Note that this state is study-dependent and might not exist in all studies.  A synonym for this is \"short-term follow-up\".";
            }
            case PENDINGONSTUDY: {
                return "A person is pre-registered for a study.";
            }
            case POTENTIALCANDIDATE: {
                return "A person that is potentially eligible for participation in the study.";
            }
            case SCREENING: {
                return "A person who is being evaluated for eligibility for a study.";
            }
            case WITHDRAWN: {
                return "The person has withdrawn their participation in the study before registration.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CANDIDATE: {
                return "Candidate";
            }
            case ELIGIBLE: {
                return "Eligible";
            }
            case FOLLOWUP: {
                return "Follow-up";
            }
            case INELIGIBLE: {
                return "Ineligible";
            }
            case NOTREGISTERED: {
                return "Not Registered";
            }
            case OFFSTUDY: {
                return "Off-study";
            }
            case ONSTUDY: {
                return "On-study";
            }
            case ONSTUDYINTERVENTION: {
                return "On-study-intervention";
            }
            case ONSTUDYOBSERVATION: {
                return "On-study-observation";
            }
            case PENDINGONSTUDY: {
                return "Pending on-study";
            }
            case POTENTIALCANDIDATE: {
                return "Potential Candidate";
            }
            case SCREENING: {
                return "Screening";
            }
            case WITHDRAWN: {
                return "Withdrawn";
            }
        }
        return "?";
    }
}

