/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ImmunizationProgramEligibility {
    INELIGIBLE,
    UNINSURED,
    NULL;


    public static ImmunizationProgramEligibility fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ineligible".equals(codeString)) {
            return INELIGIBLE;
        }
        if ("uninsured".equals(codeString)) {
            return UNINSURED;
        }
        throw new FHIRException("Unknown ImmunizationProgramEligibility code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INELIGIBLE: {
                return "ineligible";
            }
            case UNINSURED: {
                return "uninsured";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/immunization-program-eligibility";
    }

    public String getDefinition() {
        switch (this) {
            case INELIGIBLE: {
                return "The patient is not eligible for the funding program.";
            }
            case UNINSURED: {
                return "The patient is eligible for the funding program because they are uninsured.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INELIGIBLE: {
                return "Not Eligible";
            }
            case UNINSURED: {
                return "Uninsured";
            }
        }
        return "?";
    }
}

