/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HttpVerb {
    GET,
    HEAD,
    POST,
    PUT,
    DELETE,
    PATCH,
    NULL;


    public static HttpVerb fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("GET".equals(codeString)) {
            return GET;
        }
        if ("HEAD".equals(codeString)) {
            return HEAD;
        }
        if ("POST".equals(codeString)) {
            return POST;
        }
        if ("PUT".equals(codeString)) {
            return PUT;
        }
        if ("DELETE".equals(codeString)) {
            return DELETE;
        }
        if ("PATCH".equals(codeString)) {
            return PATCH;
        }
        throw new FHIRException("Unknown HttpVerb code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case GET: {
                return "GET";
            }
            case HEAD: {
                return "HEAD";
            }
            case POST: {
                return "POST";
            }
            case PUT: {
                return "PUT";
            }
            case DELETE: {
                return "DELETE";
            }
            case PATCH: {
                return "PATCH";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/http-verb";
    }

    public String getDefinition() {
        switch (this) {
            case GET: {
                return "HTTP GET Command.";
            }
            case HEAD: {
                return "HTTP HEAD Command.";
            }
            case POST: {
                return "HTTP POST Command.";
            }
            case PUT: {
                return "HTTP PUT Command.";
            }
            case DELETE: {
                return "HTTP DELETE Command.";
            }
            case PATCH: {
                return "HTTP PATCH Command.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case GET: {
                return "GET";
            }
            case HEAD: {
                return "HEAD";
            }
            case POST: {
                return "POST";
            }
            case PUT: {
                return "PUT";
            }
            case DELETE: {
                return "DELETE";
            }
            case PATCH: {
                return "PATCH";
            }
        }
        return "?";
    }
}

