/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CodesystemAltcodeKind {
    ALTERNATE,
    DEPRECATED,
    CASEINSENSITIVE,
    CASESENSITIVE,
    EXPRESSION,
    NULL;


    public static CodesystemAltcodeKind fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("alternate".equals(codeString)) {
            return ALTERNATE;
        }
        if ("deprecated".equals(codeString)) {
            return DEPRECATED;
        }
        if ("case-insensitive".equals(codeString)) {
            return CASEINSENSITIVE;
        }
        if ("case-sensitive".equals(codeString)) {
            return CASESENSITIVE;
        }
        if ("expression".equals(codeString)) {
            return EXPRESSION;
        }
        throw new FHIRException("Unknown CodesystemAltcodeKind code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ALTERNATE: {
                return "alternate";
            }
            case DEPRECATED: {
                return "deprecated";
            }
            case CASEINSENSITIVE: {
                return "case-insensitive";
            }
            case CASESENSITIVE: {
                return "case-sensitive";
            }
            case EXPRESSION: {
                return "expression";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/codesystem-altcode-kind";
    }

    public String getDefinition() {
        switch (this) {
            case ALTERNATE: {
                return "The code is an alternative code that can be used in any of the circumstances that the primary code can be used.";
            }
            case DEPRECATED: {
                return "The code should no longer be used, but was used in the past.";
            }
            case CASEINSENSITIVE: {
                return "The code is an alternative to be used when a case insensitive code is required (when the primary codes are case sensitive).";
            }
            case CASESENSITIVE: {
                return "The code is an alternative to be used when a case sensitive code is required (when the primary codes are case insensitive).";
            }
            case EXPRESSION: {
                return "The code is an alternative for the primary code that is built using the expression grammar defined by the code system.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ALTERNATE: {
                return "Alternate Code";
            }
            case DEPRECATED: {
                return "Deprecated";
            }
            case CASEINSENSITIVE: {
                return "Case Insensitive";
            }
            case CASESENSITIVE: {
                return "Case Sensitive";
            }
            case EXPRESSION: {
                return "Expression";
            }
        }
        return "?";
    }
}

