/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ClaimCareteamrole {
    PRIMARY,
    ASSIST,
    SUPERVISOR,
    OTHER,
    NULL;


    public static ClaimCareteamrole fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("primary".equals(codeString)) {
            return PRIMARY;
        }
        if ("assist".equals(codeString)) {
            return ASSIST;
        }
        if ("supervisor".equals(codeString)) {
            return SUPERVISOR;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        throw new FHIRException("Unknown ClaimCareteamrole code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PRIMARY: {
                return "primary";
            }
            case ASSIST: {
                return "assist";
            }
            case SUPERVISOR: {
                return "supervisor";
            }
            case OTHER: {
                return "other";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/claimcareteamrole";
    }

    public String getDefinition() {
        switch (this) {
            case PRIMARY: {
                return "The primary care provider.";
            }
            case ASSIST: {
                return "Assisting care provider.";
            }
            case SUPERVISOR: {
                return "Supervising care provider.";
            }
            case OTHER: {
                return "Other role on the care team.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PRIMARY: {
                return "Primary provider";
            }
            case ASSIST: {
                return "Assisting Provider";
            }
            case SUPERVISOR: {
                return "Supervising Provider";
            }
            case OTHER: {
                return "Other";
            }
        }
        return "?";
    }
}

