/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.StructureDefinition;

public class Property {
    private String name;
    private String typeCode;
    private String definition;
    private int minCardinality;
    private int maxCardinality;
    private List<Base> values = new ArrayList<Base>();
    private StructureDefinition structure;

    public Property(String name, String typeCode, String definition, int minCardinality, int maxCardinality, Base value) {
        this.name = name;
        this.typeCode = typeCode;
        this.definition = definition;
        this.minCardinality = minCardinality;
        this.maxCardinality = maxCardinality;
        if (value != null) {
            this.values.add(value);
        }
    }

    public Property(String name, String typeCode, String definition, int minCardinality, int maxCardinality, List<? extends Base> values) {
        this.name = name;
        this.typeCode = typeCode;
        this.definition = definition;
        this.minCardinality = minCardinality;
        this.maxCardinality = maxCardinality;
        if (values != null) {
            this.values.addAll(values);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getTypeCode() {
        return this.typeCode;
    }

    public String getDefinition() {
        return this.definition;
    }

    public int getMinCardinality() {
        return this.minCardinality;
    }

    public int getMaxCardinality() {
        return this.maxCardinality;
    }

    public List<Base> getValues() {
        return this.values;
    }

    public boolean hasValues() {
        for (Base e : this.getValues()) {
            if (e == null) continue;
            return true;
        }
        return false;
    }

    public StructureDefinition getStructure() {
        return this.structure;
    }

    public void setStructure(StructureDefinition structure) {
        this.structure = structure;
    }

    public boolean isList() {
        return this.maxCardinality > 1;
    }

    public String toString() {
        return this.name;
    }
}

