/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.PaymentReconciliation;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;

@ResourceDef(name="PaymentNotice", profile="http://hl7.org/fhir/StructureDefinition/PaymentNotice")
public class PaymentNotice
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier for the payment noctice", formalDefinition="A unique identifier assigned to this payment notice.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<PaymentNoticeStatus> status;
    @Child(name="request", type={Reference.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Request reference", formalDefinition="Reference of resource for which payment is being made.")
    protected Reference request;
    protected Resource requestTarget;
    @Child(name="response", type={Reference.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Response reference", formalDefinition="Reference of response to resource for which payment is being made.")
    protected Reference response;
    protected Resource responseTarget;
    @Child(name="created", type={DateTimeType.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Creation date", formalDefinition="The date when this resource was created.")
    protected DateTimeType created;
    @Child(name="provider", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Reference provider;
    protected Resource providerTarget;
    @Child(name="payment", type={PaymentReconciliation.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Payment reference", formalDefinition="A reference to the payment which is the subject of this notice.")
    protected Reference payment;
    protected PaymentReconciliation paymentTarget;
    @Child(name="paymentDate", type={DateType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Payment or clearing date", formalDefinition="The date when the above payment action occurred.")
    protected DateType paymentDate;
    @Child(name="payee", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Party being paid", formalDefinition="The party who will receive or has received payment that is the subject of this notification.")
    protected Reference payee;
    protected Resource payeeTarget;
    @Child(name="recipient", type={Organization.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Party being notified", formalDefinition="The party who is notified of the payment status.")
    protected Reference recipient;
    protected Organization recipientTarget;
    @Child(name="amount", type={Money.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Monetary amount of the payment", formalDefinition="The amount sent to the payee.")
    protected Money amount;
    @Child(name="paymentStatus", type={CodeableConcept.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Issued or cleared Status of the payment", formalDefinition="A code indicating whether payment has been sent or cleared.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/payment-status")
    protected CodeableConcept paymentStatus;
    private static final long serialVersionUID = -545198613L;
    @SearchParamDefinition(name="identifier", path="PaymentNotice.identifier", description="The business identifier of the notice", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="request", path="PaymentNotice.request", description="The Claim", type="reference")
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("PaymentNotice:request").toLocked();
    @SearchParamDefinition(name="provider", path="PaymentNotice.provider", description="The reference to the provider", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_PROVIDER = "provider";
    public static final ReferenceClientParam PROVIDER = new ReferenceClientParam("provider");
    public static final Include INCLUDE_PROVIDER = new Include("PaymentNotice:provider").toLocked();
    @SearchParamDefinition(name="created", path="PaymentNotice.created", description="Creation date fro the notice", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="response", path="PaymentNotice.response", description="The ClaimResponse", type="reference")
    public static final String SP_RESPONSE = "response";
    public static final ReferenceClientParam RESPONSE = new ReferenceClientParam("response");
    public static final Include INCLUDE_RESPONSE = new Include("PaymentNotice:response").toLocked();
    @SearchParamDefinition(name="payment-status", path="PaymentNotice.paymentStatus", description="The type of payment notice", type="token")
    public static final String SP_PAYMENT_STATUS = "payment-status";
    public static final TokenClientParam PAYMENT_STATUS = new TokenClientParam("payment-status");
    @SearchParamDefinition(name="status", path="PaymentNotice.status", description="The status of the payment notice", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public PaymentNotice() {
    }

    public PaymentNotice(Enumeration<PaymentNoticeStatus> status, DateTimeType created, Reference payment, Reference recipient, Money amount) {
        this.status = status;
        this.created = created;
        this.payment = payment;
        this.recipient = recipient;
        this.amount = amount;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public PaymentNotice setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public PaymentNotice addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<PaymentNoticeStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<PaymentNoticeStatus>(new PaymentNoticeStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public PaymentNotice setStatusElement(Enumeration<PaymentNoticeStatus> value) {
        this.status = value;
        return this;
    }

    public PaymentNoticeStatus getStatus() {
        return this.status == null ? null : (PaymentNoticeStatus)((Object)this.status.getValue());
    }

    public PaymentNotice setStatus(PaymentNoticeStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<PaymentNoticeStatus>(new PaymentNoticeStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public PaymentNotice setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public Resource getRequestTarget() {
        return this.requestTarget;
    }

    public PaymentNotice setRequestTarget(Resource value) {
        this.requestTarget = value;
        return this;
    }

    public Reference getResponse() {
        if (this.response == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.response");
            }
            if (Configuration.doAutoCreate()) {
                this.response = new Reference();
            }
        }
        return this.response;
    }

    public boolean hasResponse() {
        return this.response != null && !this.response.isEmpty();
    }

    public PaymentNotice setResponse(Reference value) {
        this.response = value;
        return this;
    }

    public Resource getResponseTarget() {
        return this.responseTarget;
    }

    public PaymentNotice setResponseTarget(Resource value) {
        this.responseTarget = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public PaymentNotice setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public PaymentNotice setCreated(Date value) {
        if (this.created == null) {
            this.created = new DateTimeType();
        }
        this.created.setValue(value);
        return this;
    }

    public Reference getProvider() {
        if (this.provider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.provider = new Reference();
            }
        }
        return this.provider;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public PaymentNotice setProvider(Reference value) {
        this.provider = value;
        return this;
    }

    public Resource getProviderTarget() {
        return this.providerTarget;
    }

    public PaymentNotice setProviderTarget(Resource value) {
        this.providerTarget = value;
        return this;
    }

    public Reference getPayment() {
        if (this.payment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.payment");
            }
            if (Configuration.doAutoCreate()) {
                this.payment = new Reference();
            }
        }
        return this.payment;
    }

    public boolean hasPayment() {
        return this.payment != null && !this.payment.isEmpty();
    }

    public PaymentNotice setPayment(Reference value) {
        this.payment = value;
        return this;
    }

    public PaymentReconciliation getPaymentTarget() {
        if (this.paymentTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.payment");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentTarget = new PaymentReconciliation();
            }
        }
        return this.paymentTarget;
    }

    public PaymentNotice setPaymentTarget(PaymentReconciliation value) {
        this.paymentTarget = value;
        return this;
    }

    public DateType getPaymentDateElement() {
        if (this.paymentDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.paymentDate");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentDate = new DateType();
            }
        }
        return this.paymentDate;
    }

    public boolean hasPaymentDateElement() {
        return this.paymentDate != null && !this.paymentDate.isEmpty();
    }

    public boolean hasPaymentDate() {
        return this.paymentDate != null && !this.paymentDate.isEmpty();
    }

    public PaymentNotice setPaymentDateElement(DateType value) {
        this.paymentDate = value;
        return this;
    }

    public Date getPaymentDate() {
        return this.paymentDate == null ? null : (Date)this.paymentDate.getValue();
    }

    public PaymentNotice setPaymentDate(Date value) {
        if (value == null) {
            this.paymentDate = null;
        } else {
            if (this.paymentDate == null) {
                this.paymentDate = new DateType();
            }
            this.paymentDate.setValue(value);
        }
        return this;
    }

    public Reference getPayee() {
        if (this.payee == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.payee");
            }
            if (Configuration.doAutoCreate()) {
                this.payee = new Reference();
            }
        }
        return this.payee;
    }

    public boolean hasPayee() {
        return this.payee != null && !this.payee.isEmpty();
    }

    public PaymentNotice setPayee(Reference value) {
        this.payee = value;
        return this;
    }

    public Resource getPayeeTarget() {
        return this.payeeTarget;
    }

    public PaymentNotice setPayeeTarget(Resource value) {
        this.payeeTarget = value;
        return this;
    }

    public Reference getRecipient() {
        if (this.recipient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.recipient");
            }
            if (Configuration.doAutoCreate()) {
                this.recipient = new Reference();
            }
        }
        return this.recipient;
    }

    public boolean hasRecipient() {
        return this.recipient != null && !this.recipient.isEmpty();
    }

    public PaymentNotice setRecipient(Reference value) {
        this.recipient = value;
        return this;
    }

    public Organization getRecipientTarget() {
        if (this.recipientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.recipient");
            }
            if (Configuration.doAutoCreate()) {
                this.recipientTarget = new Organization();
            }
        }
        return this.recipientTarget;
    }

    public PaymentNotice setRecipientTarget(Organization value) {
        this.recipientTarget = value;
        return this;
    }

    public Money getAmount() {
        if (this.amount == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.amount");
            }
            if (Configuration.doAutoCreate()) {
                this.amount = new Money();
            }
        }
        return this.amount;
    }

    public boolean hasAmount() {
        return this.amount != null && !this.amount.isEmpty();
    }

    public PaymentNotice setAmount(Money value) {
        this.amount = value;
        return this;
    }

    public CodeableConcept getPaymentStatus() {
        if (this.paymentStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.paymentStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentStatus = new CodeableConcept();
            }
        }
        return this.paymentStatus;
    }

    public boolean hasPaymentStatus() {
        return this.paymentStatus != null && !this.paymentStatus.isEmpty();
    }

    public PaymentNotice setPaymentStatus(CodeableConcept value) {
        this.paymentStatus = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this payment notice.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property(SP_REQUEST, "Reference(Any)", "Reference of resource for which payment is being made.", 0, 1, this.request));
        children.add(new Property(SP_RESPONSE, "Reference(Any)", "Reference of response to resource for which payment is being made.", 0, 1, this.response));
        children.add(new Property(SP_CREATED, "dateTime", "The date when this resource was created.", 0, 1, this.created));
        children.add(new Property(SP_PROVIDER, "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.provider));
        children.add(new Property("payment", "Reference(PaymentReconciliation)", "A reference to the payment which is the subject of this notice.", 0, 1, this.payment));
        children.add(new Property("paymentDate", "date", "The date when the above payment action occurred.", 0, 1, this.paymentDate));
        children.add(new Property("payee", "Reference(Practitioner|PractitionerRole|Organization)", "The party who will receive or has received payment that is the subject of this notification.", 0, 1, this.payee));
        children.add(new Property("recipient", "Reference(Organization)", "The party who is notified of the payment status.", 0, 1, this.recipient));
        children.add(new Property("amount", "Money", "The amount sent to the payee.", 0, 1, this.amount));
        children.add(new Property("paymentStatus", "CodeableConcept", "A code indicating whether payment has been sent or cleared.", 0, 1, this.paymentStatus));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this payment notice.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 1095692943: {
                return new Property(SP_REQUEST, "Reference(Any)", "Reference of resource for which payment is being made.", 0, 1, this.request);
            }
            case -340323263: {
                return new Property(SP_RESPONSE, "Reference(Any)", "Reference of response to resource for which payment is being made.", 0, 1, this.response);
            }
            case 1028554472: {
                return new Property(SP_CREATED, "dateTime", "The date when this resource was created.", 0, 1, this.created);
            }
            case -987494927: {
                return new Property(SP_PROVIDER, "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.provider);
            }
            case -786681338: {
                return new Property("payment", "Reference(PaymentReconciliation)", "A reference to the payment which is the subject of this notice.", 0, 1, this.payment);
            }
            case -1540873516: {
                return new Property("paymentDate", "date", "The date when the above payment action occurred.", 0, 1, this.paymentDate);
            }
            case 106443592: {
                return new Property("payee", "Reference(Practitioner|PractitionerRole|Organization)", "The party who will receive or has received payment that is the subject of this notification.", 0, 1, this.payee);
            }
            case 820081177: {
                return new Property("recipient", "Reference(Organization)", "The party who is notified of the payment status.", 0, 1, this.recipient);
            }
            case -1413853096: {
                return new Property("amount", "Money", "The amount sent to the payee.", 0, 1, this.amount);
            }
            case 1430704536: {
                return new Property("paymentStatus", "CodeableConcept", "A code indicating whether payment has been sent or cleared.", 0, 1, this.paymentStatus);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.request;
                }
                return baseArray;
            }
            case -340323263: {
                Base[] baseArray;
                if (this.response == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.response;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.created;
                }
                return baseArray;
            }
            case -987494927: {
                Base[] baseArray;
                if (this.provider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.provider;
                }
                return baseArray;
            }
            case -786681338: {
                Base[] baseArray;
                if (this.payment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.payment;
                }
                return baseArray;
            }
            case -1540873516: {
                Base[] baseArray;
                if (this.paymentDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.paymentDate;
                }
                return baseArray;
            }
            case 106443592: {
                Base[] baseArray;
                if (this.payee == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.payee;
                }
                return baseArray;
            }
            case 820081177: {
                Base[] baseArray;
                if (this.recipient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.recipient;
                }
                return baseArray;
            }
            case -1413853096: {
                Base[] baseArray;
                if (this.amount == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.amount;
                }
                return baseArray;
            }
            case 1430704536: {
                Base[] baseArray;
                if (this.paymentStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.paymentStatus;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new PaymentNoticeStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 1095692943: {
                this.request = this.castToReference(value);
                return value;
            }
            case -340323263: {
                this.response = this.castToReference(value);
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case -987494927: {
                this.provider = this.castToReference(value);
                return value;
            }
            case -786681338: {
                this.payment = this.castToReference(value);
                return value;
            }
            case -1540873516: {
                this.paymentDate = this.castToDate(value);
                return value;
            }
            case 106443592: {
                this.payee = this.castToReference(value);
                return value;
            }
            case 820081177: {
                this.recipient = this.castToReference(value);
                return value;
            }
            case -1413853096: {
                this.amount = this.castToMoney(value);
                return value;
            }
            case 1430704536: {
                this.paymentStatus = this.castToCodeableConcept(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new PaymentNoticeStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_REQUEST)) {
            this.request = this.castToReference(value);
        } else if (name.equals(SP_RESPONSE)) {
            this.response = this.castToReference(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals(SP_PROVIDER)) {
            this.provider = this.castToReference(value);
        } else if (name.equals("payment")) {
            this.payment = this.castToReference(value);
        } else if (name.equals("paymentDate")) {
            this.paymentDate = this.castToDate(value);
        } else if (name.equals("payee")) {
            this.payee = this.castToReference(value);
        } else if (name.equals("recipient")) {
            this.recipient = this.castToReference(value);
        } else if (name.equals("amount")) {
            this.amount = this.castToMoney(value);
        } else if (name.equals("paymentStatus")) {
            this.paymentStatus = this.castToCodeableConcept(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1095692943: {
                return this.getRequest();
            }
            case -340323263: {
                return this.getResponse();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case -987494927: {
                return this.getProvider();
            }
            case -786681338: {
                return this.getPayment();
            }
            case -1540873516: {
                return this.getPaymentDateElement();
            }
            case 106443592: {
                return this.getPayee();
            }
            case 820081177: {
                return this.getRecipient();
            }
            case -1413853096: {
                return this.getAmount();
            }
            case 1430704536: {
                return this.getPaymentStatus();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -340323263: {
                return new String[]{"Reference"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case -987494927: {
                return new String[]{"Reference"};
            }
            case -786681338: {
                return new String[]{"Reference"};
            }
            case -1540873516: {
                return new String[]{"date"};
            }
            case 106443592: {
                return new String[]{"Reference"};
            }
            case 820081177: {
                return new String[]{"Reference"};
            }
            case -1413853096: {
                return new String[]{"Money"};
            }
            case 1430704536: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentNotice.status");
        }
        if (name.equals(SP_REQUEST)) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals(SP_RESPONSE)) {
            this.response = new Reference();
            return this.response;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentNotice.created");
        }
        if (name.equals(SP_PROVIDER)) {
            this.provider = new Reference();
            return this.provider;
        }
        if (name.equals("payment")) {
            this.payment = new Reference();
            return this.payment;
        }
        if (name.equals("paymentDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentNotice.paymentDate");
        }
        if (name.equals("payee")) {
            this.payee = new Reference();
            return this.payee;
        }
        if (name.equals("recipient")) {
            this.recipient = new Reference();
            return this.recipient;
        }
        if (name.equals("amount")) {
            this.amount = new Money();
            return this.amount;
        }
        if (name.equals("paymentStatus")) {
            this.paymentStatus = new CodeableConcept();
            return this.paymentStatus;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PaymentNotice";
    }

    @Override
    public PaymentNotice copy() {
        PaymentNotice dst = new PaymentNotice();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(PaymentNotice dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier i : this.identifier) {
                dst.identifier.add(i.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.request = this.request == null ? null : this.request.copy();
        dst.response = this.response == null ? null : this.response.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
        dst.payment = this.payment == null ? null : this.payment.copy();
        dst.paymentDate = this.paymentDate == null ? null : this.paymentDate.copy();
        dst.payee = this.payee == null ? null : this.payee.copy();
        dst.recipient = this.recipient == null ? null : this.recipient.copy();
        dst.amount = this.amount == null ? null : this.amount.copy();
        dst.paymentStatus = this.paymentStatus == null ? null : this.paymentStatus.copy();
    }

    protected PaymentNotice typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PaymentNotice)) {
            return false;
        }
        PaymentNotice o = (PaymentNotice)other_;
        return PaymentNotice.compareDeep(this.identifier, o.identifier, true) && PaymentNotice.compareDeep(this.status, o.status, true) && PaymentNotice.compareDeep(this.request, o.request, true) && PaymentNotice.compareDeep(this.response, o.response, true) && PaymentNotice.compareDeep(this.created, o.created, true) && PaymentNotice.compareDeep(this.provider, o.provider, true) && PaymentNotice.compareDeep(this.payment, o.payment, true) && PaymentNotice.compareDeep(this.paymentDate, o.paymentDate, true) && PaymentNotice.compareDeep(this.payee, o.payee, true) && PaymentNotice.compareDeep(this.recipient, o.recipient, true) && PaymentNotice.compareDeep(this.amount, o.amount, true) && PaymentNotice.compareDeep(this.paymentStatus, o.paymentStatus, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PaymentNotice)) {
            return false;
        }
        PaymentNotice o = (PaymentNotice)other_;
        return PaymentNotice.compareValues(this.status, o.status, true) && PaymentNotice.compareValues(this.created, o.created, true) && PaymentNotice.compareValues(this.paymentDate, o.paymentDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.status, this.request, this.response, this.created, this.provider, this.payment, this.paymentDate, this.payee, this.recipient, this.amount, this.paymentStatus);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.PaymentNotice;
    }

    public static class PaymentNoticeStatusEnumFactory
    implements EnumFactory<PaymentNoticeStatus> {
        @Override
        public PaymentNoticeStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return PaymentNoticeStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return PaymentNoticeStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return PaymentNoticeStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return PaymentNoticeStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown PaymentNoticeStatus code '" + codeString + "'");
        }

        public Enumeration<PaymentNoticeStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<PaymentNoticeStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<PaymentNoticeStatus>(this, PaymentNoticeStatus.ACTIVE);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<PaymentNoticeStatus>(this, PaymentNoticeStatus.CANCELLED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<PaymentNoticeStatus>(this, PaymentNoticeStatus.DRAFT);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<PaymentNoticeStatus>(this, PaymentNoticeStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown PaymentNoticeStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(PaymentNoticeStatus code) {
            if (code == PaymentNoticeStatus.ACTIVE) {
                return "active";
            }
            if (code == PaymentNoticeStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == PaymentNoticeStatus.DRAFT) {
                return "draft";
            }
            if (code == PaymentNoticeStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(PaymentNoticeStatus code) {
            return code.getSystem();
        }
    }

    public static enum PaymentNoticeStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static PaymentNoticeStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown PaymentNoticeStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/fm-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The instance was entered in error.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

