/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.ListResource;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;

@ResourceDef(name="MeasureReport", profile="http://hl7.org/fhir/StructureDefinition/MeasureReport")
public class MeasureReport
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the MeasureReport", formalDefinition="A formal identifier that is used to identify this MeasureReport when it is represented in other formats or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="complete | pending | error", formalDefinition="The MeasureReport status. No data will be available until the MeasureReport status is complete.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-report-status")
    protected Enumeration<MeasureReportStatus> status;
    @Child(name="type", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="individual | subject-list | summary | data-collection", formalDefinition="The type of measure report. This may be an individual report, which provides the score for the measure for an individual member of the population; a subject-listing, which returns the list of members that meet the various criteria in the measure; a summary report, which returns a population count for each of the criteria in the measure; or a data-collection, which enables the MeasureReport to be used to exchange the data-of-interest for a quality measure.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-report-type")
    protected Enumeration<MeasureReportType> type;
    @Child(name="measure", type={CanonicalType.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What measure was calculated", formalDefinition="A reference to the Measure that was calculated to produce this report.")
    protected CanonicalType measure;
    @Child(name="subject", type={Patient.class, Practitioner.class, PractitionerRole.class, Location.class, Device.class, RelatedPerson.class, Group.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What individual(s) the report is for", formalDefinition="Optional subject identifying the individual or individuals the report is for.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="date", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the report was generated", formalDefinition="The date this measure report was generated.")
    protected DateTimeType date;
    @Child(name="reporter", type={Practitioner.class, PractitionerRole.class, Location.class, Organization.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is reporting the data", formalDefinition="The individual, location, or organization that is reporting the data.")
    protected Reference reporter;
    protected Resource reporterTarget;
    @Child(name="period", type={Period.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What period the report covers", formalDefinition="The reporting period for which the report was calculated.")
    protected Period period;
    @Child(name="improvementNotation", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="increase | decrease", formalDefinition="Whether improvement in the measure is noted by an increase or decrease in the measure score.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-improvement-notation")
    protected CodeableConcept improvementNotation;
    @Child(name="group", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Measure results for each group", formalDefinition="The results of the calculation, one for each population group in the measure.")
    protected List<MeasureReportGroupComponent> group;
    @Child(name="evaluatedResource", type={Reference.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What data was used to calculate the measure score", formalDefinition="A reference to a Bundle containing the Resources that were used in the calculation of this measure.")
    protected List<Reference> evaluatedResource;
    protected List<Resource> evaluatedResourceTarget;
    private static final long serialVersionUID = 355307999L;
    @SearchParamDefinition(name="date", path="MeasureReport.date", description="The date of the measure report", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="MeasureReport.identifier", description="External identifier of the measure report to be returned", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="period", path="MeasureReport.period", description="The period of the measure report", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="measure", path="MeasureReport.measure", description="The measure to return measure report results for", type="reference", target={Measure.class})
    public static final String SP_MEASURE = "measure";
    public static final ReferenceClientParam MEASURE = new ReferenceClientParam("measure");
    public static final Include INCLUDE_MEASURE = new Include("MeasureReport:measure").toLocked();
    @SearchParamDefinition(name="patient", path="MeasureReport.subject.where(resolve() is Patient)", description="The identity of a patient to search for individual measure report results for", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MeasureReport:patient").toLocked();
    @SearchParamDefinition(name="subject", path="MeasureReport.subject", description="The identity of a subject to search for individual measure report results for", type="reference", target={Device.class, Group.class, Location.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MeasureReport:subject").toLocked();
    @SearchParamDefinition(name="reporter", path="MeasureReport.reporter", description="The reporter to return measure report results for", type="reference", target={Location.class, Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_REPORTER = "reporter";
    public static final ReferenceClientParam REPORTER = new ReferenceClientParam("reporter");
    public static final Include INCLUDE_REPORTER = new Include("MeasureReport:reporter").toLocked();
    @SearchParamDefinition(name="status", path="MeasureReport.status", description="The status of the measure report", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="evaluated-resource", path="MeasureReport.evaluatedResource", description="An evaluated resource referenced by the measure report", type="reference")
    public static final String SP_EVALUATED_RESOURCE = "evaluated-resource";
    public static final ReferenceClientParam EVALUATED_RESOURCE = new ReferenceClientParam("evaluated-resource");
    public static final Include INCLUDE_EVALUATED_RESOURCE = new Include("MeasureReport:evaluated-resource").toLocked();

    public MeasureReport() {
    }

    public MeasureReport(Enumeration<MeasureReportStatus> status, Enumeration<MeasureReportType> type, CanonicalType measure, Period period) {
        this.status = status;
        this.type = type;
        this.measure = measure;
        this.period = period;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MeasureReport setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MeasureReport addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<MeasureReportStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MeasureReportStatus>(new MeasureReportStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MeasureReport setStatusElement(Enumeration<MeasureReportStatus> value) {
        this.status = value;
        return this;
    }

    public MeasureReportStatus getStatus() {
        return this.status == null ? null : (MeasureReportStatus)((Object)this.status.getValue());
    }

    public MeasureReport setStatus(MeasureReportStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<MeasureReportStatus>(new MeasureReportStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<MeasureReportType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<MeasureReportType>(new MeasureReportTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public MeasureReport setTypeElement(Enumeration<MeasureReportType> value) {
        this.type = value;
        return this;
    }

    public MeasureReportType getType() {
        return this.type == null ? null : (MeasureReportType)((Object)this.type.getValue());
    }

    public MeasureReport setType(MeasureReportType value) {
        if (this.type == null) {
            this.type = new Enumeration<MeasureReportType>(new MeasureReportTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public CanonicalType getMeasureElement() {
        if (this.measure == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.measure");
            }
            if (Configuration.doAutoCreate()) {
                this.measure = new CanonicalType();
            }
        }
        return this.measure;
    }

    public boolean hasMeasureElement() {
        return this.measure != null && !this.measure.isEmpty();
    }

    public boolean hasMeasure() {
        return this.measure != null && !this.measure.isEmpty();
    }

    public MeasureReport setMeasureElement(CanonicalType value) {
        this.measure = value;
        return this;
    }

    public String getMeasure() {
        return this.measure == null ? null : (String)this.measure.getValue();
    }

    public MeasureReport setMeasure(String value) {
        if (this.measure == null) {
            this.measure = new CanonicalType();
        }
        this.measure.setValue(value);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public MeasureReport setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public MeasureReport setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public MeasureReport setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public MeasureReport setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Reference getReporter() {
        if (this.reporter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.reporter");
            }
            if (Configuration.doAutoCreate()) {
                this.reporter = new Reference();
            }
        }
        return this.reporter;
    }

    public boolean hasReporter() {
        return this.reporter != null && !this.reporter.isEmpty();
    }

    public MeasureReport setReporter(Reference value) {
        this.reporter = value;
        return this;
    }

    public Resource getReporterTarget() {
        return this.reporterTarget;
    }

    public MeasureReport setReporterTarget(Resource value) {
        this.reporterTarget = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public MeasureReport setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public CodeableConcept getImprovementNotation() {
        if (this.improvementNotation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.improvementNotation");
            }
            if (Configuration.doAutoCreate()) {
                this.improvementNotation = new CodeableConcept();
            }
        }
        return this.improvementNotation;
    }

    public boolean hasImprovementNotation() {
        return this.improvementNotation != null && !this.improvementNotation.isEmpty();
    }

    public MeasureReport setImprovementNotation(CodeableConcept value) {
        this.improvementNotation = value;
        return this;
    }

    public List<MeasureReportGroupComponent> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<MeasureReportGroupComponent>();
        }
        return this.group;
    }

    public MeasureReport setGroup(List<MeasureReportGroupComponent> theGroup) {
        this.group = theGroup;
        return this;
    }

    public boolean hasGroup() {
        if (this.group == null) {
            return false;
        }
        for (MeasureReportGroupComponent item : this.group) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MeasureReportGroupComponent addGroup() {
        MeasureReportGroupComponent t = new MeasureReportGroupComponent();
        if (this.group == null) {
            this.group = new ArrayList<MeasureReportGroupComponent>();
        }
        this.group.add(t);
        return t;
    }

    public MeasureReport addGroup(MeasureReportGroupComponent t) {
        if (t == null) {
            return this;
        }
        if (this.group == null) {
            this.group = new ArrayList<MeasureReportGroupComponent>();
        }
        this.group.add(t);
        return this;
    }

    public MeasureReportGroupComponent getGroupFirstRep() {
        if (this.getGroup().isEmpty()) {
            this.addGroup();
        }
        return this.getGroup().get(0);
    }

    public List<Reference> getEvaluatedResource() {
        if (this.evaluatedResource == null) {
            this.evaluatedResource = new ArrayList<Reference>();
        }
        return this.evaluatedResource;
    }

    public MeasureReport setEvaluatedResource(List<Reference> theEvaluatedResource) {
        this.evaluatedResource = theEvaluatedResource;
        return this;
    }

    public boolean hasEvaluatedResource() {
        if (this.evaluatedResource == null) {
            return false;
        }
        for (Reference item : this.evaluatedResource) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEvaluatedResource() {
        Reference t = new Reference();
        if (this.evaluatedResource == null) {
            this.evaluatedResource = new ArrayList<Reference>();
        }
        this.evaluatedResource.add(t);
        return t;
    }

    public MeasureReport addEvaluatedResource(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.evaluatedResource == null) {
            this.evaluatedResource = new ArrayList<Reference>();
        }
        this.evaluatedResource.add(t);
        return this;
    }

    public Reference getEvaluatedResourceFirstRep() {
        if (this.getEvaluatedResource().isEmpty()) {
            this.addEvaluatedResource();
        }
        return this.getEvaluatedResource().get(0);
    }

    @Deprecated
    public List<Resource> getEvaluatedResourceTarget() {
        if (this.evaluatedResourceTarget == null) {
            this.evaluatedResourceTarget = new ArrayList<Resource>();
        }
        return this.evaluatedResourceTarget;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this MeasureReport when it is represented in other formats or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The MeasureReport status. No data will be available until the MeasureReport status is complete.", 0, 1, this.status));
        children.add(new Property("type", "code", "The type of measure report. This may be an individual report, which provides the score for the measure for an individual member of the population; a subject-listing, which returns the list of members that meet the various criteria in the measure; a summary report, which returns a population count for each of the criteria in the measure; or a data-collection, which enables the MeasureReport to be used to exchange the data-of-interest for a quality measure.", 0, 1, this.type));
        children.add(new Property(SP_MEASURE, "canonical(Measure)", "A reference to the Measure that was calculated to produce this report.", 0, 1, this.measure));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Practitioner|PractitionerRole|Location|Device|RelatedPerson|Group)", "Optional subject identifying the individual or individuals the report is for.", 0, 1, this.subject));
        children.add(new Property(SP_DATE, "dateTime", "The date this measure report was generated.", 0, 1, this.date));
        children.add(new Property(SP_REPORTER, "Reference(Practitioner|PractitionerRole|Location|Organization)", "The individual, location, or organization that is reporting the data.", 0, 1, this.reporter));
        children.add(new Property(SP_PERIOD, "Period", "The reporting period for which the report was calculated.", 0, 1, this.period));
        children.add(new Property("improvementNotation", "CodeableConcept", "Whether improvement in the measure is noted by an increase or decrease in the measure score.", 0, 1, this.improvementNotation));
        children.add(new Property("group", "", "The results of the calculation, one for each population group in the measure.", 0, Integer.MAX_VALUE, this.group));
        children.add(new Property("evaluatedResource", "Reference(Any)", "A reference to a Bundle containing the Resources that were used in the calculation of this measure.", 0, Integer.MAX_VALUE, this.evaluatedResource));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this MeasureReport when it is represented in other formats or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The MeasureReport status. No data will be available until the MeasureReport status is complete.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property("type", "code", "The type of measure report. This may be an individual report, which provides the score for the measure for an individual member of the population; a subject-listing, which returns the list of members that meet the various criteria in the measure; a summary report, which returns a population count for each of the criteria in the measure; or a data-collection, which enables the MeasureReport to be used to exchange the data-of-interest for a quality measure.", 0, 1, this.type);
            }
            case 938321246: {
                return new Property(SP_MEASURE, "canonical(Measure)", "A reference to the Measure that was calculated to produce this report.", 0, 1, this.measure);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Practitioner|PractitionerRole|Location|Device|RelatedPerson|Group)", "Optional subject identifying the individual or individuals the report is for.", 0, 1, this.subject);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date this measure report was generated.", 0, 1, this.date);
            }
            case -427039519: {
                return new Property(SP_REPORTER, "Reference(Practitioner|PractitionerRole|Location|Organization)", "The individual, location, or organization that is reporting the data.", 0, 1, this.reporter);
            }
            case -991726143: {
                return new Property(SP_PERIOD, "Period", "The reporting period for which the report was calculated.", 0, 1, this.period);
            }
            case -2085456136: {
                return new Property("improvementNotation", "CodeableConcept", "Whether improvement in the measure is noted by an increase or decrease in the measure score.", 0, 1, this.improvementNotation);
            }
            case 98629247: {
                return new Property("group", "", "The results of the calculation, one for each population group in the measure.", 0, Integer.MAX_VALUE, this.group);
            }
            case -1056771047: {
                return new Property("evaluatedResource", "Reference(Any)", "A reference to a Bundle containing the Resources that were used in the calculation of this measure.", 0, Integer.MAX_VALUE, this.evaluatedResource);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case 938321246: {
                Base[] baseArray;
                if (this.measure == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.measure;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.date;
                }
                return baseArray;
            }
            case -427039519: {
                Base[] baseArray;
                if (this.reporter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.reporter;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.period;
                }
                return baseArray;
            }
            case -2085456136: {
                Base[] baseArray;
                if (this.improvementNotation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.improvementNotation;
                }
                return baseArray;
            }
            case 98629247: {
                return this.group == null ? new Base[]{} : this.group.toArray(new Base[this.group.size()]);
            }
            case -1056771047: {
                return this.evaluatedResource == null ? new Base[]{} : this.evaluatedResource.toArray(new Base[this.evaluatedResource.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new MeasureReportStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                value = new MeasureReportTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
                return value;
            }
            case 938321246: {
                this.measure = this.castToCanonical(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case -427039519: {
                this.reporter = this.castToReference(value);
                return value;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                return value;
            }
            case -2085456136: {
                this.improvementNotation = this.castToCodeableConcept(value);
                return value;
            }
            case 98629247: {
                this.getGroup().add((MeasureReportGroupComponent)((Object)value));
                return value;
            }
            case -1056771047: {
                this.getEvaluatedResource().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new MeasureReportStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("type")) {
            value = new MeasureReportTypeEnumFactory().fromType(this.castToCode(value));
            this.type = value;
        } else if (name.equals(SP_MEASURE)) {
            this.measure = this.castToCanonical(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_REPORTER)) {
            this.reporter = this.castToReference(value);
        } else if (name.equals(SP_PERIOD)) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("improvementNotation")) {
            this.improvementNotation = this.castToCodeableConcept(value);
        } else if (name.equals("group")) {
            this.getGroup().add((MeasureReportGroupComponent)((Object)value));
        } else if (name.equals("evaluatedResource")) {
            this.getEvaluatedResource().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case 938321246: {
                return this.getMeasureElement();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case -427039519: {
                return this.getReporter();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -2085456136: {
                return this.getImprovementNotation();
            }
            case 98629247: {
                return this.addGroup();
            }
            case -1056771047: {
                return this.addEvaluatedResource();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case 938321246: {
                return new String[]{"canonical"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case -427039519: {
                return new String[]{"Reference"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case -2085456136: {
                return new String[]{"CodeableConcept"};
            }
            case 98629247: {
                return new String[0];
            }
            case -1056771047: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type MeasureReport.status");
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a primitive type MeasureReport.type");
        }
        if (name.equals(SP_MEASURE)) {
            throw new FHIRException("Cannot call addChild on a primitive type MeasureReport.measure");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type MeasureReport.date");
        }
        if (name.equals(SP_REPORTER)) {
            this.reporter = new Reference();
            return this.reporter;
        }
        if (name.equals(SP_PERIOD)) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("improvementNotation")) {
            this.improvementNotation = new CodeableConcept();
            return this.improvementNotation;
        }
        if (name.equals("group")) {
            return this.addGroup();
        }
        if (name.equals("evaluatedResource")) {
            return this.addEvaluatedResource();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MeasureReport";
    }

    @Override
    public MeasureReport copy() {
        MeasureReport dst = new MeasureReport();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MeasureReport dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.measure = this.measure == null ? null : this.measure.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.reporter = this.reporter == null ? null : this.reporter.copy();
        dst.period = this.period == null ? null : this.period.copy();
        CodeableConcept codeableConcept = dst.improvementNotation = this.improvementNotation == null ? null : this.improvementNotation.copy();
        if (this.group != null) {
            dst.group = new ArrayList<MeasureReportGroupComponent>();
            for (MeasureReportGroupComponent measureReportGroupComponent : this.group) {
                dst.group.add(measureReportGroupComponent.copy());
            }
        }
        if (this.evaluatedResource != null) {
            dst.evaluatedResource = new ArrayList<Reference>();
            for (Reference reference : this.evaluatedResource) {
                dst.evaluatedResource.add(reference.copy());
            }
        }
    }

    protected MeasureReport typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MeasureReport)) {
            return false;
        }
        MeasureReport o = (MeasureReport)other_;
        return MeasureReport.compareDeep(this.identifier, o.identifier, true) && MeasureReport.compareDeep(this.status, o.status, true) && MeasureReport.compareDeep(this.type, o.type, true) && MeasureReport.compareDeep(this.measure, o.measure, true) && MeasureReport.compareDeep(this.subject, o.subject, true) && MeasureReport.compareDeep(this.date, o.date, true) && MeasureReport.compareDeep(this.reporter, o.reporter, true) && MeasureReport.compareDeep(this.period, o.period, true) && MeasureReport.compareDeep(this.improvementNotation, o.improvementNotation, true) && MeasureReport.compareDeep(this.group, o.group, true) && MeasureReport.compareDeep(this.evaluatedResource, o.evaluatedResource, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MeasureReport)) {
            return false;
        }
        MeasureReport o = (MeasureReport)other_;
        return MeasureReport.compareValues(this.status, o.status, true) && MeasureReport.compareValues(this.type, o.type, true) && MeasureReport.compareValues(this.date, o.date, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.status, this.type, this.measure, this.subject, this.date, this.reporter, this.period, this.improvementNotation, this.group, this.evaluatedResource);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MeasureReport;
    }

    @Block
    public static class StratifierGroupPopulationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="initial-population | numerator | numerator-exclusion | denominator | denominator-exclusion | denominator-exception | measure-population | measure-population-exclusion | measure-observation", formalDefinition="The type of the population.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-population")
        protected CodeableConcept code;
        @Child(name="count", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Size of the population", formalDefinition="The number of members of the population in this stratum.")
        protected IntegerType count;
        @Child(name="subjectResults", type={ListResource.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="For subject-list reports, the subject results in this population", formalDefinition="This element refers to a List of subject level MeasureReport resources, one for each subject in this population in this stratum.")
        protected Reference subjectResults;
        protected ListResource subjectResultsTarget;
        private static final long serialVersionUID = 210461445L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StratifierGroupPopulationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public StratifierGroupPopulationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public IntegerType getCountElement() {
            if (this.count == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StratifierGroupPopulationComponent.count");
                }
                if (Configuration.doAutoCreate()) {
                    this.count = new IntegerType();
                }
            }
            return this.count;
        }

        public boolean hasCountElement() {
            return this.count != null && !this.count.isEmpty();
        }

        public boolean hasCount() {
            return this.count != null && !this.count.isEmpty();
        }

        public StratifierGroupPopulationComponent setCountElement(IntegerType value) {
            this.count = value;
            return this;
        }

        public int getCount() {
            return this.count == null || this.count.isEmpty() ? 0 : (Integer)this.count.getValue();
        }

        public StratifierGroupPopulationComponent setCount(int value) {
            if (this.count == null) {
                this.count = new IntegerType();
            }
            this.count.setValue((Object)value);
            return this;
        }

        public Reference getSubjectResults() {
            if (this.subjectResults == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StratifierGroupPopulationComponent.subjectResults");
                }
                if (Configuration.doAutoCreate()) {
                    this.subjectResults = new Reference();
                }
            }
            return this.subjectResults;
        }

        public boolean hasSubjectResults() {
            return this.subjectResults != null && !this.subjectResults.isEmpty();
        }

        public StratifierGroupPopulationComponent setSubjectResults(Reference value) {
            this.subjectResults = value;
            return this;
        }

        public ListResource getSubjectResultsTarget() {
            if (this.subjectResultsTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StratifierGroupPopulationComponent.subjectResults");
                }
                if (Configuration.doAutoCreate()) {
                    this.subjectResultsTarget = new ListResource();
                }
            }
            return this.subjectResultsTarget;
        }

        public StratifierGroupPopulationComponent setSubjectResultsTarget(ListResource value) {
            this.subjectResultsTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "The type of the population.", 0, 1, this.code));
            children.add(new Property("count", "integer", "The number of members of the population in this stratum.", 0, 1, this.count));
            children.add(new Property("subjectResults", "Reference(List)", "This element refers to a List of subject level MeasureReport resources, one for each subject in this population in this stratum.", 0, 1, this.subjectResults));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "The type of the population.", 0, 1, this.code);
                }
                case 94851343: {
                    return new Property("count", "integer", "The number of members of the population in this stratum.", 0, 1, this.count);
                }
                case 2136184106: {
                    return new Property("subjectResults", "Reference(List)", "This element refers to a List of subject level MeasureReport resources, one for each subject in this population in this stratum.", 0, 1, this.subjectResults);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 94851343: {
                    Base[] baseArray;
                    if (this.count == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.count;
                    }
                    return baseArray;
                }
                case 2136184106: {
                    Base[] baseArray;
                    if (this.subjectResults == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.subjectResults;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case 94851343: {
                    this.count = this.castToInteger(value);
                    return value;
                }
                case 2136184106: {
                    this.subjectResults = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("count")) {
                this.count = this.castToInteger(value);
            } else if (name.equals("subjectResults")) {
                this.subjectResults = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 94851343: {
                    return this.getCountElement();
                }
                case 2136184106: {
                    return this.getSubjectResults();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 94851343: {
                    return new String[]{"integer"};
                }
                case 2136184106: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("count")) {
                throw new FHIRException("Cannot call addChild on a primitive type MeasureReport.count");
            }
            if (name.equals("subjectResults")) {
                this.subjectResults = new Reference();
                return this.subjectResults;
            }
            return super.addChild(name);
        }

        @Override
        public StratifierGroupPopulationComponent copy() {
            StratifierGroupPopulationComponent dst = new StratifierGroupPopulationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(StratifierGroupPopulationComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.count = this.count == null ? null : this.count.copy();
            dst.subjectResults = this.subjectResults == null ? null : this.subjectResults.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StratifierGroupPopulationComponent)) {
                return false;
            }
            StratifierGroupPopulationComponent o = (StratifierGroupPopulationComponent)other_;
            return StratifierGroupPopulationComponent.compareDeep(this.code, o.code, true) && StratifierGroupPopulationComponent.compareDeep(this.count, o.count, true) && StratifierGroupPopulationComponent.compareDeep(this.subjectResults, o.subjectResults, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StratifierGroupPopulationComponent)) {
                return false;
            }
            StratifierGroupPopulationComponent o = (StratifierGroupPopulationComponent)other_;
            return StratifierGroupPopulationComponent.compareValues(this.count, o.count, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.count, this.subjectResults);
        }

        @Override
        public String fhirType() {
            return "MeasureReport.group.stratifier.stratum.population";
        }
    }

    @Block
    public static class StratifierGroupComponentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What stratifier component of the group", formalDefinition="The code for the stratum component value.")
        protected CodeableConcept code;
        @Child(name="value", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The stratum component value, e.g. male", formalDefinition="The stratum component value.")
        protected CodeableConcept value;
        private static final long serialVersionUID = 1750253426L;

        public StratifierGroupComponentComponent() {
        }

        public StratifierGroupComponentComponent(CodeableConcept code, CodeableConcept value) {
            this.code = code;
            this.value = value;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StratifierGroupComponentComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public StratifierGroupComponentComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public CodeableConcept getValue() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StratifierGroupComponentComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new CodeableConcept();
                }
            }
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public StratifierGroupComponentComponent setValue(CodeableConcept value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "The code for the stratum component value.", 0, 1, this.code));
            children.add(new Property("value", "CodeableConcept", "The stratum component value.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "The code for the stratum component value.", 0, 1, this.code);
                }
                case 111972721: {
                    return new Property("value", "CodeableConcept", "The stratum component value.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("value")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public StratifierGroupComponentComponent copy() {
            StratifierGroupComponentComponent dst = new StratifierGroupComponentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(StratifierGroupComponentComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StratifierGroupComponentComponent)) {
                return false;
            }
            StratifierGroupComponentComponent o = (StratifierGroupComponentComponent)other_;
            return StratifierGroupComponentComponent.compareDeep(this.code, o.code, true) && StratifierGroupComponentComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StratifierGroupComponentComponent)) {
                return false;
            }
            StratifierGroupComponentComponent o = (StratifierGroupComponentComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.value);
        }

        @Override
        public String fhirType() {
            return "MeasureReport.group.stratifier.stratum.component";
        }
    }

    @Block
    public static class StratifierGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The stratum value, e.g. male", formalDefinition="The value for this stratum, expressed as a CodeableConcept. When defining stratifiers on complex values, the value must be rendered such that the value for each stratum within the stratifier is unique.")
        protected CodeableConcept value;
        @Child(name="component", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Stratifier component values", formalDefinition="A stratifier component value.")
        protected List<StratifierGroupComponentComponent> component;
        @Child(name="population", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Population results in this stratum", formalDefinition="The populations that make up the stratum, one for each type of population appropriate to the measure.")
        protected List<StratifierGroupPopulationComponent> population;
        @Child(name="measureScore", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What score this stratum achieved", formalDefinition="The measure score for this stratum, calculated as appropriate for the measure type and scoring method, and based on only the members of this stratum.")
        protected Quantity measureScore;
        private static final long serialVersionUID = 892251179L;

        public CodeableConcept getValue() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StratifierGroupComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new CodeableConcept();
                }
            }
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public StratifierGroupComponent setValue(CodeableConcept value) {
            this.value = value;
            return this;
        }

        public List<StratifierGroupComponentComponent> getComponent() {
            if (this.component == null) {
                this.component = new ArrayList<StratifierGroupComponentComponent>();
            }
            return this.component;
        }

        public StratifierGroupComponent setComponent(List<StratifierGroupComponentComponent> theComponent) {
            this.component = theComponent;
            return this;
        }

        public boolean hasComponent() {
            if (this.component == null) {
                return false;
            }
            for (StratifierGroupComponentComponent item : this.component) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StratifierGroupComponentComponent addComponent() {
            StratifierGroupComponentComponent t = new StratifierGroupComponentComponent();
            if (this.component == null) {
                this.component = new ArrayList<StratifierGroupComponentComponent>();
            }
            this.component.add(t);
            return t;
        }

        public StratifierGroupComponent addComponent(StratifierGroupComponentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.component == null) {
                this.component = new ArrayList<StratifierGroupComponentComponent>();
            }
            this.component.add(t);
            return this;
        }

        public StratifierGroupComponentComponent getComponentFirstRep() {
            if (this.getComponent().isEmpty()) {
                this.addComponent();
            }
            return this.getComponent().get(0);
        }

        public List<StratifierGroupPopulationComponent> getPopulation() {
            if (this.population == null) {
                this.population = new ArrayList<StratifierGroupPopulationComponent>();
            }
            return this.population;
        }

        public StratifierGroupComponent setPopulation(List<StratifierGroupPopulationComponent> thePopulation) {
            this.population = thePopulation;
            return this;
        }

        public boolean hasPopulation() {
            if (this.population == null) {
                return false;
            }
            for (StratifierGroupPopulationComponent item : this.population) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StratifierGroupPopulationComponent addPopulation() {
            StratifierGroupPopulationComponent t = new StratifierGroupPopulationComponent();
            if (this.population == null) {
                this.population = new ArrayList<StratifierGroupPopulationComponent>();
            }
            this.population.add(t);
            return t;
        }

        public StratifierGroupComponent addPopulation(StratifierGroupPopulationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.population == null) {
                this.population = new ArrayList<StratifierGroupPopulationComponent>();
            }
            this.population.add(t);
            return this;
        }

        public StratifierGroupPopulationComponent getPopulationFirstRep() {
            if (this.getPopulation().isEmpty()) {
                this.addPopulation();
            }
            return this.getPopulation().get(0);
        }

        public Quantity getMeasureScore() {
            if (this.measureScore == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StratifierGroupComponent.measureScore");
                }
                if (Configuration.doAutoCreate()) {
                    this.measureScore = new Quantity();
                }
            }
            return this.measureScore;
        }

        public boolean hasMeasureScore() {
            return this.measureScore != null && !this.measureScore.isEmpty();
        }

        public StratifierGroupComponent setMeasureScore(Quantity value) {
            this.measureScore = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("value", "CodeableConcept", "The value for this stratum, expressed as a CodeableConcept. When defining stratifiers on complex values, the value must be rendered such that the value for each stratum within the stratifier is unique.", 0, 1, this.value));
            children.add(new Property("component", "", "A stratifier component value.", 0, Integer.MAX_VALUE, this.component));
            children.add(new Property("population", "", "The populations that make up the stratum, one for each type of population appropriate to the measure.", 0, Integer.MAX_VALUE, this.population));
            children.add(new Property("measureScore", "Quantity", "The measure score for this stratum, calculated as appropriate for the measure type and scoring method, and based on only the members of this stratum.", 0, 1, this.measureScore));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 111972721: {
                    return new Property("value", "CodeableConcept", "The value for this stratum, expressed as a CodeableConcept. When defining stratifiers on complex values, the value must be rendered such that the value for each stratum within the stratifier is unique.", 0, 1, this.value);
                }
                case -1399907075: {
                    return new Property("component", "", "A stratifier component value.", 0, Integer.MAX_VALUE, this.component);
                }
                case -2023558323: {
                    return new Property("population", "", "The populations that make up the stratum, one for each type of population appropriate to the measure.", 0, Integer.MAX_VALUE, this.population);
                }
                case -386313260: {
                    return new Property("measureScore", "Quantity", "The measure score for this stratum, calculated as appropriate for the measure type and scoring method, and based on only the members of this stratum.", 0, 1, this.measureScore);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
                case -1399907075: {
                    return this.component == null ? new Base[]{} : this.component.toArray(new Base[this.component.size()]);
                }
                case -2023558323: {
                    return this.population == null ? new Base[]{} : this.population.toArray(new Base[this.population.size()]);
                }
                case -386313260: {
                    Base[] baseArray;
                    if (this.measureScore == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.measureScore;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = this.castToCodeableConcept(value);
                    return value;
                }
                case -1399907075: {
                    this.getComponent().add((StratifierGroupComponentComponent)value);
                    return value;
                }
                case -2023558323: {
                    this.getPopulation().add((StratifierGroupPopulationComponent)value);
                    return value;
                }
                case -386313260: {
                    this.measureScore = this.castToQuantity(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("value")) {
                this.value = this.castToCodeableConcept(value);
            } else if (name.equals("component")) {
                this.getComponent().add((StratifierGroupComponentComponent)value);
            } else if (name.equals("population")) {
                this.getPopulation().add((StratifierGroupPopulationComponent)value);
            } else if (name.equals("measureScore")) {
                this.measureScore = this.castToQuantity(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return this.getValue();
                }
                case -1399907075: {
                    return this.addComponent();
                }
                case -2023558323: {
                    return this.addPopulation();
                }
                case -386313260: {
                    return this.getMeasureScore();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return new String[]{"CodeableConcept"};
                }
                case -1399907075: {
                    return new String[0];
                }
                case -2023558323: {
                    return new String[0];
                }
                case -386313260: {
                    return new String[]{"Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("value")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("component")) {
                return this.addComponent();
            }
            if (name.equals("population")) {
                return this.addPopulation();
            }
            if (name.equals("measureScore")) {
                this.measureScore = new Quantity();
                return this.measureScore;
            }
            return super.addChild(name);
        }

        @Override
        public StratifierGroupComponent copy() {
            StratifierGroupComponent dst = new StratifierGroupComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(StratifierGroupComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.value = this.value == null ? null : this.value.copy();
            if (this.component != null) {
                dst.component = new ArrayList<StratifierGroupComponentComponent>();
                for (StratifierGroupComponentComponent stratifierGroupComponentComponent : this.component) {
                    dst.component.add(stratifierGroupComponentComponent.copy());
                }
            }
            if (this.population != null) {
                dst.population = new ArrayList<StratifierGroupPopulationComponent>();
                for (StratifierGroupPopulationComponent stratifierGroupPopulationComponent : this.population) {
                    dst.population.add(stratifierGroupPopulationComponent.copy());
                }
            }
            dst.measureScore = this.measureScore == null ? null : this.measureScore.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StratifierGroupComponent)) {
                return false;
            }
            StratifierGroupComponent o = (StratifierGroupComponent)other_;
            return StratifierGroupComponent.compareDeep(this.value, o.value, true) && StratifierGroupComponent.compareDeep(this.component, o.component, true) && StratifierGroupComponent.compareDeep(this.population, o.population, true) && StratifierGroupComponent.compareDeep(this.measureScore, o.measureScore, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StratifierGroupComponent)) {
                return false;
            }
            StratifierGroupComponent o = (StratifierGroupComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.value, this.component, this.population, this.measureScore);
        }

        @Override
        public String fhirType() {
            return "MeasureReport.group.stratifier.stratum";
        }
    }

    @Block
    public static class MeasureReportGroupStratifierComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What stratifier of the group", formalDefinition="The meaning of this stratifier, as defined in the measure definition.")
        protected List<CodeableConcept> code;
        @Child(name="stratum", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Stratum results, one for each unique value, or set of values, in the stratifier, or stratifier components", formalDefinition="This element contains the results for a single stratum within the stratifier. For example, when stratifying on administrative gender, there will be four strata, one for each possible gender value.")
        protected List<StratifierGroupComponent> stratum;
        private static final long serialVersionUID = 259550185L;

        public List<CodeableConcept> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            return this.code;
        }

        public MeasureReportGroupStratifierComponent setCode(List<CodeableConcept> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (CodeableConcept item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return t;
        }

        public MeasureReportGroupStratifierComponent addCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return this;
        }

        public CodeableConcept getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public List<StratifierGroupComponent> getStratum() {
            if (this.stratum == null) {
                this.stratum = new ArrayList<StratifierGroupComponent>();
            }
            return this.stratum;
        }

        public MeasureReportGroupStratifierComponent setStratum(List<StratifierGroupComponent> theStratum) {
            this.stratum = theStratum;
            return this;
        }

        public boolean hasStratum() {
            if (this.stratum == null) {
                return false;
            }
            for (StratifierGroupComponent item : this.stratum) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StratifierGroupComponent addStratum() {
            StratifierGroupComponent t = new StratifierGroupComponent();
            if (this.stratum == null) {
                this.stratum = new ArrayList<StratifierGroupComponent>();
            }
            this.stratum.add(t);
            return t;
        }

        public MeasureReportGroupStratifierComponent addStratum(StratifierGroupComponent t) {
            if (t == null) {
                return this;
            }
            if (this.stratum == null) {
                this.stratum = new ArrayList<StratifierGroupComponent>();
            }
            this.stratum.add(t);
            return this;
        }

        public StratifierGroupComponent getStratumFirstRep() {
            if (this.getStratum().isEmpty()) {
                this.addStratum();
            }
            return this.getStratum().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "The meaning of this stratifier, as defined in the measure definition.", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property("stratum", "", "This element contains the results for a single stratum within the stratifier. For example, when stratifying on administrative gender, there will be four strata, one for each possible gender value.", 0, Integer.MAX_VALUE, this.stratum));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "The meaning of this stratifier, as defined in the measure definition.", 0, Integer.MAX_VALUE, this.code);
                }
                case -1881991236: {
                    return new Property("stratum", "", "This element contains the results for a single stratum within the stratifier. For example, when stratifying on administrative gender, there will be four strata, one for each possible gender value.", 0, Integer.MAX_VALUE, this.stratum);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case -1881991236: {
                    return this.stratum == null ? new Base[]{} : this.stratum.toArray(new Base[this.stratum.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.getCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1881991236: {
                    this.getStratum().add((StratifierGroupComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.getCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("stratum")) {
                this.getStratum().add((StratifierGroupComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.addCode();
                }
                case -1881991236: {
                    return this.addStratum();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1881991236: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                return this.addCode();
            }
            if (name.equals("stratum")) {
                return this.addStratum();
            }
            return super.addChild(name);
        }

        @Override
        public MeasureReportGroupStratifierComponent copy() {
            MeasureReportGroupStratifierComponent dst = new MeasureReportGroupStratifierComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MeasureReportGroupStratifierComponent dst) {
            super.copyValues(dst);
            if (this.code != null) {
                dst.code = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.code) {
                    dst.code.add(codeableConcept.copy());
                }
            }
            if (this.stratum != null) {
                dst.stratum = new ArrayList<StratifierGroupComponent>();
                for (StratifierGroupComponent stratifierGroupComponent : this.stratum) {
                    dst.stratum.add(stratifierGroupComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureReportGroupStratifierComponent)) {
                return false;
            }
            MeasureReportGroupStratifierComponent o = (MeasureReportGroupStratifierComponent)other_;
            return MeasureReportGroupStratifierComponent.compareDeep(this.code, o.code, true) && MeasureReportGroupStratifierComponent.compareDeep(this.stratum, o.stratum, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureReportGroupStratifierComponent)) {
                return false;
            }
            MeasureReportGroupStratifierComponent o = (MeasureReportGroupStratifierComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.stratum);
        }

        @Override
        public String fhirType() {
            return "MeasureReport.group.stratifier";
        }
    }

    @Block
    public static class MeasureReportGroupPopulationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="initial-population | numerator | numerator-exclusion | denominator | denominator-exclusion | denominator-exception | measure-population | measure-population-exclusion | measure-observation", formalDefinition="The type of the population.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-population")
        protected CodeableConcept code;
        @Child(name="count", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Size of the population", formalDefinition="The number of members of the population.")
        protected IntegerType count;
        @Child(name="subjectResults", type={ListResource.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="For subject-list reports, the subject results in this population", formalDefinition="This element refers to a List of subject level MeasureReport resources, one for each subject in this population.")
        protected Reference subjectResults;
        protected ListResource subjectResultsTarget;
        private static final long serialVersionUID = 210461445L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupPopulationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MeasureReportGroupPopulationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public IntegerType getCountElement() {
            if (this.count == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupPopulationComponent.count");
                }
                if (Configuration.doAutoCreate()) {
                    this.count = new IntegerType();
                }
            }
            return this.count;
        }

        public boolean hasCountElement() {
            return this.count != null && !this.count.isEmpty();
        }

        public boolean hasCount() {
            return this.count != null && !this.count.isEmpty();
        }

        public MeasureReportGroupPopulationComponent setCountElement(IntegerType value) {
            this.count = value;
            return this;
        }

        public int getCount() {
            return this.count == null || this.count.isEmpty() ? 0 : (Integer)this.count.getValue();
        }

        public MeasureReportGroupPopulationComponent setCount(int value) {
            if (this.count == null) {
                this.count = new IntegerType();
            }
            this.count.setValue((Object)value);
            return this;
        }

        public Reference getSubjectResults() {
            if (this.subjectResults == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupPopulationComponent.subjectResults");
                }
                if (Configuration.doAutoCreate()) {
                    this.subjectResults = new Reference();
                }
            }
            return this.subjectResults;
        }

        public boolean hasSubjectResults() {
            return this.subjectResults != null && !this.subjectResults.isEmpty();
        }

        public MeasureReportGroupPopulationComponent setSubjectResults(Reference value) {
            this.subjectResults = value;
            return this;
        }

        public ListResource getSubjectResultsTarget() {
            if (this.subjectResultsTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupPopulationComponent.subjectResults");
                }
                if (Configuration.doAutoCreate()) {
                    this.subjectResultsTarget = new ListResource();
                }
            }
            return this.subjectResultsTarget;
        }

        public MeasureReportGroupPopulationComponent setSubjectResultsTarget(ListResource value) {
            this.subjectResultsTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "The type of the population.", 0, 1, this.code));
            children.add(new Property("count", "integer", "The number of members of the population.", 0, 1, this.count));
            children.add(new Property("subjectResults", "Reference(List)", "This element refers to a List of subject level MeasureReport resources, one for each subject in this population.", 0, 1, this.subjectResults));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "The type of the population.", 0, 1, this.code);
                }
                case 94851343: {
                    return new Property("count", "integer", "The number of members of the population.", 0, 1, this.count);
                }
                case 2136184106: {
                    return new Property("subjectResults", "Reference(List)", "This element refers to a List of subject level MeasureReport resources, one for each subject in this population.", 0, 1, this.subjectResults);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 94851343: {
                    Base[] baseArray;
                    if (this.count == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.count;
                    }
                    return baseArray;
                }
                case 2136184106: {
                    Base[] baseArray;
                    if (this.subjectResults == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.subjectResults;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case 94851343: {
                    this.count = this.castToInteger(value);
                    return value;
                }
                case 2136184106: {
                    this.subjectResults = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("count")) {
                this.count = this.castToInteger(value);
            } else if (name.equals("subjectResults")) {
                this.subjectResults = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 94851343: {
                    return this.getCountElement();
                }
                case 2136184106: {
                    return this.getSubjectResults();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 94851343: {
                    return new String[]{"integer"};
                }
                case 2136184106: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("count")) {
                throw new FHIRException("Cannot call addChild on a primitive type MeasureReport.count");
            }
            if (name.equals("subjectResults")) {
                this.subjectResults = new Reference();
                return this.subjectResults;
            }
            return super.addChild(name);
        }

        @Override
        public MeasureReportGroupPopulationComponent copy() {
            MeasureReportGroupPopulationComponent dst = new MeasureReportGroupPopulationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MeasureReportGroupPopulationComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.count = this.count == null ? null : this.count.copy();
            dst.subjectResults = this.subjectResults == null ? null : this.subjectResults.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureReportGroupPopulationComponent)) {
                return false;
            }
            MeasureReportGroupPopulationComponent o = (MeasureReportGroupPopulationComponent)other_;
            return MeasureReportGroupPopulationComponent.compareDeep(this.code, o.code, true) && MeasureReportGroupPopulationComponent.compareDeep(this.count, o.count, true) && MeasureReportGroupPopulationComponent.compareDeep(this.subjectResults, o.subjectResults, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureReportGroupPopulationComponent)) {
                return false;
            }
            MeasureReportGroupPopulationComponent o = (MeasureReportGroupPopulationComponent)other_;
            return MeasureReportGroupPopulationComponent.compareValues(this.count, o.count, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.count, this.subjectResults);
        }

        @Override
        public String fhirType() {
            return "MeasureReport.group.population";
        }
    }

    @Block
    public static class MeasureReportGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Meaning of the group", formalDefinition="The meaning of the population group as defined in the measure definition.")
        protected CodeableConcept code;
        @Child(name="population", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The populations in the group", formalDefinition="The populations that make up the population group, one for each type of population appropriate for the measure.")
        protected List<MeasureReportGroupPopulationComponent> population;
        @Child(name="measureScore", type={Quantity.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="What score this group achieved", formalDefinition="The measure score for this population group, calculated as appropriate for the measure type and scoring method, and based on the contents of the populations defined in the group.")
        protected Quantity measureScore;
        @Child(name="stratifier", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Stratification results", formalDefinition="When a measure includes multiple stratifiers, there will be a stratifier group for each stratifier defined by the measure.")
        protected List<MeasureReportGroupStratifierComponent> stratifier;
        private static final long serialVersionUID = 1744426009L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MeasureReportGroupComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<MeasureReportGroupPopulationComponent> getPopulation() {
            if (this.population == null) {
                this.population = new ArrayList<MeasureReportGroupPopulationComponent>();
            }
            return this.population;
        }

        public MeasureReportGroupComponent setPopulation(List<MeasureReportGroupPopulationComponent> thePopulation) {
            this.population = thePopulation;
            return this;
        }

        public boolean hasPopulation() {
            if (this.population == null) {
                return false;
            }
            for (MeasureReportGroupPopulationComponent item : this.population) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MeasureReportGroupPopulationComponent addPopulation() {
            MeasureReportGroupPopulationComponent t = new MeasureReportGroupPopulationComponent();
            if (this.population == null) {
                this.population = new ArrayList<MeasureReportGroupPopulationComponent>();
            }
            this.population.add(t);
            return t;
        }

        public MeasureReportGroupComponent addPopulation(MeasureReportGroupPopulationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.population == null) {
                this.population = new ArrayList<MeasureReportGroupPopulationComponent>();
            }
            this.population.add(t);
            return this;
        }

        public MeasureReportGroupPopulationComponent getPopulationFirstRep() {
            if (this.getPopulation().isEmpty()) {
                this.addPopulation();
            }
            return this.getPopulation().get(0);
        }

        public Quantity getMeasureScore() {
            if (this.measureScore == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupComponent.measureScore");
                }
                if (Configuration.doAutoCreate()) {
                    this.measureScore = new Quantity();
                }
            }
            return this.measureScore;
        }

        public boolean hasMeasureScore() {
            return this.measureScore != null && !this.measureScore.isEmpty();
        }

        public MeasureReportGroupComponent setMeasureScore(Quantity value) {
            this.measureScore = value;
            return this;
        }

        public List<MeasureReportGroupStratifierComponent> getStratifier() {
            if (this.stratifier == null) {
                this.stratifier = new ArrayList<MeasureReportGroupStratifierComponent>();
            }
            return this.stratifier;
        }

        public MeasureReportGroupComponent setStratifier(List<MeasureReportGroupStratifierComponent> theStratifier) {
            this.stratifier = theStratifier;
            return this;
        }

        public boolean hasStratifier() {
            if (this.stratifier == null) {
                return false;
            }
            for (MeasureReportGroupStratifierComponent item : this.stratifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MeasureReportGroupStratifierComponent addStratifier() {
            MeasureReportGroupStratifierComponent t = new MeasureReportGroupStratifierComponent();
            if (this.stratifier == null) {
                this.stratifier = new ArrayList<MeasureReportGroupStratifierComponent>();
            }
            this.stratifier.add(t);
            return t;
        }

        public MeasureReportGroupComponent addStratifier(MeasureReportGroupStratifierComponent t) {
            if (t == null) {
                return this;
            }
            if (this.stratifier == null) {
                this.stratifier = new ArrayList<MeasureReportGroupStratifierComponent>();
            }
            this.stratifier.add(t);
            return this;
        }

        public MeasureReportGroupStratifierComponent getStratifierFirstRep() {
            if (this.getStratifier().isEmpty()) {
                this.addStratifier();
            }
            return this.getStratifier().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "The meaning of the population group as defined in the measure definition.", 0, 1, this.code));
            children.add(new Property("population", "", "The populations that make up the population group, one for each type of population appropriate for the measure.", 0, Integer.MAX_VALUE, this.population));
            children.add(new Property("measureScore", "Quantity", "The measure score for this population group, calculated as appropriate for the measure type and scoring method, and based on the contents of the populations defined in the group.", 0, 1, this.measureScore));
            children.add(new Property("stratifier", "", "When a measure includes multiple stratifiers, there will be a stratifier group for each stratifier defined by the measure.", 0, Integer.MAX_VALUE, this.stratifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "The meaning of the population group as defined in the measure definition.", 0, 1, this.code);
                }
                case -2023558323: {
                    return new Property("population", "", "The populations that make up the population group, one for each type of population appropriate for the measure.", 0, Integer.MAX_VALUE, this.population);
                }
                case -386313260: {
                    return new Property("measureScore", "Quantity", "The measure score for this population group, calculated as appropriate for the measure type and scoring method, and based on the contents of the populations defined in the group.", 0, 1, this.measureScore);
                }
                case 90983669: {
                    return new Property("stratifier", "", "When a measure includes multiple stratifiers, there will be a stratifier group for each stratifier defined by the measure.", 0, Integer.MAX_VALUE, this.stratifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -2023558323: {
                    return this.population == null ? new Base[]{} : this.population.toArray(new Base[this.population.size()]);
                }
                case -386313260: {
                    Base[] baseArray;
                    if (this.measureScore == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.measureScore;
                    }
                    return baseArray;
                }
                case 90983669: {
                    return this.stratifier == null ? new Base[]{} : this.stratifier.toArray(new Base[this.stratifier.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -2023558323: {
                    this.getPopulation().add((MeasureReportGroupPopulationComponent)value);
                    return value;
                }
                case -386313260: {
                    this.measureScore = this.castToQuantity(value);
                    return value;
                }
                case 90983669: {
                    this.getStratifier().add((MeasureReportGroupStratifierComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("population")) {
                this.getPopulation().add((MeasureReportGroupPopulationComponent)value);
            } else if (name.equals("measureScore")) {
                this.measureScore = this.castToQuantity(value);
            } else if (name.equals("stratifier")) {
                this.getStratifier().add((MeasureReportGroupStratifierComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -2023558323: {
                    return this.addPopulation();
                }
                case -386313260: {
                    return this.getMeasureScore();
                }
                case 90983669: {
                    return this.addStratifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -2023558323: {
                    return new String[0];
                }
                case -386313260: {
                    return new String[]{"Quantity"};
                }
                case 90983669: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("population")) {
                return this.addPopulation();
            }
            if (name.equals("measureScore")) {
                this.measureScore = new Quantity();
                return this.measureScore;
            }
            if (name.equals("stratifier")) {
                return this.addStratifier();
            }
            return super.addChild(name);
        }

        @Override
        public MeasureReportGroupComponent copy() {
            MeasureReportGroupComponent dst = new MeasureReportGroupComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MeasureReportGroupComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.population != null) {
                dst.population = new ArrayList<MeasureReportGroupPopulationComponent>();
                for (MeasureReportGroupPopulationComponent measureReportGroupPopulationComponent : this.population) {
                    dst.population.add(measureReportGroupPopulationComponent.copy());
                }
            }
            Quantity quantity = dst.measureScore = this.measureScore == null ? null : this.measureScore.copy();
            if (this.stratifier != null) {
                dst.stratifier = new ArrayList<MeasureReportGroupStratifierComponent>();
                for (MeasureReportGroupStratifierComponent measureReportGroupStratifierComponent : this.stratifier) {
                    dst.stratifier.add(measureReportGroupStratifierComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureReportGroupComponent)) {
                return false;
            }
            MeasureReportGroupComponent o = (MeasureReportGroupComponent)other_;
            return MeasureReportGroupComponent.compareDeep(this.code, o.code, true) && MeasureReportGroupComponent.compareDeep(this.population, o.population, true) && MeasureReportGroupComponent.compareDeep(this.measureScore, o.measureScore, true) && MeasureReportGroupComponent.compareDeep(this.stratifier, o.stratifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureReportGroupComponent)) {
                return false;
            }
            MeasureReportGroupComponent o = (MeasureReportGroupComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.population, this.measureScore, this.stratifier);
        }

        @Override
        public String fhirType() {
            return "MeasureReport.group";
        }
    }

    public static class MeasureReportTypeEnumFactory
    implements EnumFactory<MeasureReportType> {
        @Override
        public MeasureReportType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("individual".equals(codeString)) {
                return MeasureReportType.INDIVIDUAL;
            }
            if ("subject-list".equals(codeString)) {
                return MeasureReportType.SUBJECTLIST;
            }
            if ("summary".equals(codeString)) {
                return MeasureReportType.SUMMARY;
            }
            if ("data-collection".equals(codeString)) {
                return MeasureReportType.DATACOLLECTION;
            }
            throw new IllegalArgumentException("Unknown MeasureReportType code '" + codeString + "'");
        }

        public Enumeration<MeasureReportType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MeasureReportType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("individual".equals(codeString)) {
                return new Enumeration<MeasureReportType>(this, MeasureReportType.INDIVIDUAL);
            }
            if ("subject-list".equals(codeString)) {
                return new Enumeration<MeasureReportType>(this, MeasureReportType.SUBJECTLIST);
            }
            if ("summary".equals(codeString)) {
                return new Enumeration<MeasureReportType>(this, MeasureReportType.SUMMARY);
            }
            if ("data-collection".equals(codeString)) {
                return new Enumeration<MeasureReportType>(this, MeasureReportType.DATACOLLECTION);
            }
            throw new FHIRException("Unknown MeasureReportType code '" + codeString + "'");
        }

        @Override
        public String toCode(MeasureReportType code) {
            if (code == MeasureReportType.INDIVIDUAL) {
                return "individual";
            }
            if (code == MeasureReportType.SUBJECTLIST) {
                return "subject-list";
            }
            if (code == MeasureReportType.SUMMARY) {
                return "summary";
            }
            if (code == MeasureReportType.DATACOLLECTION) {
                return "data-collection";
            }
            return "?";
        }

        @Override
        public String toSystem(MeasureReportType code) {
            return code.getSystem();
        }
    }

    public static enum MeasureReportType {
        INDIVIDUAL,
        SUBJECTLIST,
        SUMMARY,
        DATACOLLECTION,
        NULL;


        public static MeasureReportType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("individual".equals(codeString)) {
                return INDIVIDUAL;
            }
            if ("subject-list".equals(codeString)) {
                return SUBJECTLIST;
            }
            if ("summary".equals(codeString)) {
                return SUMMARY;
            }
            if ("data-collection".equals(codeString)) {
                return DATACOLLECTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MeasureReportType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INDIVIDUAL: {
                    return "individual";
                }
                case SUBJECTLIST: {
                    return "subject-list";
                }
                case SUMMARY: {
                    return "summary";
                }
                case DATACOLLECTION: {
                    return "data-collection";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INDIVIDUAL: {
                    return "http://hl7.org/fhir/measure-report-type";
                }
                case SUBJECTLIST: {
                    return "http://hl7.org/fhir/measure-report-type";
                }
                case SUMMARY: {
                    return "http://hl7.org/fhir/measure-report-type";
                }
                case DATACOLLECTION: {
                    return "http://hl7.org/fhir/measure-report-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INDIVIDUAL: {
                    return "An individual report that provides information on the performance for a given measure with respect to a single subject.";
                }
                case SUBJECTLIST: {
                    return "A subject list report that includes a listing of subjects that satisfied each population criteria in the measure.";
                }
                case SUMMARY: {
                    return "A summary report that returns the number of members in each population criteria for the measure.";
                }
                case DATACOLLECTION: {
                    return "A data collection report that contains data-of-interest for the measure.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INDIVIDUAL: {
                    return "Individual";
                }
                case SUBJECTLIST: {
                    return "Subject List";
                }
                case SUMMARY: {
                    return "Summary";
                }
                case DATACOLLECTION: {
                    return "Data Collection";
                }
            }
            return "?";
        }
    }

    public static class MeasureReportStatusEnumFactory
    implements EnumFactory<MeasureReportStatus> {
        @Override
        public MeasureReportStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("complete".equals(codeString)) {
                return MeasureReportStatus.COMPLETE;
            }
            if ("pending".equals(codeString)) {
                return MeasureReportStatus.PENDING;
            }
            if ("error".equals(codeString)) {
                return MeasureReportStatus.ERROR;
            }
            throw new IllegalArgumentException("Unknown MeasureReportStatus code '" + codeString + "'");
        }

        public Enumeration<MeasureReportStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MeasureReportStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("complete".equals(codeString)) {
                return new Enumeration<MeasureReportStatus>(this, MeasureReportStatus.COMPLETE);
            }
            if ("pending".equals(codeString)) {
                return new Enumeration<MeasureReportStatus>(this, MeasureReportStatus.PENDING);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<MeasureReportStatus>(this, MeasureReportStatus.ERROR);
            }
            throw new FHIRException("Unknown MeasureReportStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(MeasureReportStatus code) {
            if (code == MeasureReportStatus.COMPLETE) {
                return "complete";
            }
            if (code == MeasureReportStatus.PENDING) {
                return "pending";
            }
            if (code == MeasureReportStatus.ERROR) {
                return "error";
            }
            return "?";
        }

        @Override
        public String toSystem(MeasureReportStatus code) {
            return code.getSystem();
        }
    }

    public static enum MeasureReportStatus {
        COMPLETE,
        PENDING,
        ERROR,
        NULL;


        public static MeasureReportStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("complete".equals(codeString)) {
                return COMPLETE;
            }
            if ("pending".equals(codeString)) {
                return PENDING;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MeasureReportStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case COMPLETE: {
                    return "complete";
                }
                case PENDING: {
                    return "pending";
                }
                case ERROR: {
                    return "error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case COMPLETE: {
                    return "http://hl7.org/fhir/measure-report-status";
                }
                case PENDING: {
                    return "http://hl7.org/fhir/measure-report-status";
                }
                case ERROR: {
                    return "http://hl7.org/fhir/measure-report-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case COMPLETE: {
                    return "The report is complete and ready for use.";
                }
                case PENDING: {
                    return "The report is currently being generated.";
                }
                case ERROR: {
                    return "An error occurred attempting to generate the report.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case COMPLETE: {
                    return "Complete";
                }
                case PENDING: {
                    return "Pending";
                }
                case ERROR: {
                    return "Error";
                }
            }
            return "?";
        }
    }
}

