/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.elementmodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.elementmodel.Element;
import org.hl7.fhir.r4.elementmodel.ParserBase;
import org.hl7.fhir.r4.elementmodel.Property;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.utils.SnomedExpressions;
import org.hl7.fhir.r4.utils.formats.Turtle;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class TurtleParser
extends ParserBase {
    private String base;
    public static String FHIR_URI_BASE = "http://hl7.org/fhir/";
    public static String FHIR_VERSION_BASE = "http://build.fhir.org/";

    public TurtleParser(IWorkerContext context) {
        super(context);
    }

    @Override
    public Element parse(InputStream input) throws IOException, FHIRException {
        Turtle src = new Turtle();
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
            try {
                src.parse(TextFile.streamToString(input));
            }
            catch (Exception e) {
                this.logError(-1, -1, "(document)", ValidationMessage.IssueType.INVALID, "Error parsing Turtle: " + e.getMessage(), ValidationMessage.IssueSeverity.FATAL);
                return null;
            }
            return this.parse(src);
        }
        src.parse(TextFile.streamToString(input));
        return this.parse(src);
    }

    private Element parse(Turtle src) throws FHIRException {
        for (Turtle.TTLComplex cmp : src.getObjects().values()) {
            for (String p : cmp.getPredicates().keySet()) {
                if (!(FHIR_URI_BASE + "nodeRole").equals(p) || !cmp.getPredicates().get(p).hasValue(FHIR_URI_BASE + "treeRoot")) continue;
                return this.parse(src, cmp);
            }
        }
        String msg = "Error parsing Turtle: unable to find any node maked as the entry point (where " + FHIR_URI_BASE + "nodeRole = " + FHIR_URI_BASE + "treeRoot)";
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
            this.logError(-1, -1, "(document)", ValidationMessage.IssueType.INVALID, msg, ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        throw new FHIRFormatError(msg);
    }

    private Element parse(Turtle src, Turtle.TTLComplex cmp) throws FHIRException {
        Turtle.TTLObject type = cmp.getPredicates().get("http://www.w3.org/2000/01/rdf-schema#type");
        if (type == null) {
            this.logError(cmp.getLine(), cmp.getCol(), "(document)", ValidationMessage.IssueType.INVALID, "Unknown resource type (missing rdfs:type)", ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        if (type instanceof Turtle.TTLList) {
            for (Turtle.TTLObject obj : ((Turtle.TTLList)type).getList()) {
                if (!(obj instanceof Turtle.TTLURL) || !((Turtle.TTLURL)obj).getUri().startsWith(FHIR_URI_BASE)) continue;
                type = obj;
                break;
            }
        }
        if (!(type instanceof Turtle.TTLURL)) {
            this.logError(cmp.getLine(), cmp.getCol(), "(document)", ValidationMessage.IssueType.INVALID, "Unexpected datatype for rdfs:type)", ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        String name = ((Turtle.TTLURL)type).getUri();
        String ns = name.substring(0, name.lastIndexOf("/"));
        name = name.substring(name.lastIndexOf("/") + 1);
        String path = "/" + name;
        StructureDefinition sd = this.getDefinition(cmp.getLine(), cmp.getCol(), ns, name);
        if (sd == null) {
            return null;
        }
        Element result = new Element(name, new Property(this.context, sd.getSnapshot().getElement().get(0), sd));
        result.markLocation(cmp.getLine(), cmp.getCol());
        result.setType(name);
        this.parseChildren(src, path, cmp, result, false);
        result.numberChildren();
        return result;
    }

    private void parseChildren(Turtle src, String path, Turtle.TTLComplex object, Element context, boolean primitive) throws FHIRException {
        List<Property> properties = context.getProperty().getChildProperties(context.getName(), null);
        HashSet<String> processed = new HashSet<String>();
        if (primitive) {
            processed.add(FHIR_URI_BASE + "value");
        }
        for (Property property : properties) {
            if (property.isChoice()) {
                for (ElementDefinition.TypeRefComponent type : property.getDefinition().getType()) {
                    String eName = property.getName().substring(0, property.getName().length() - 3) + Utilities.capitalize(type.getCode());
                    this.parseChild(src, object, context, processed, property, path, this.getFormalName(property, eName));
                }
                continue;
            }
            this.parseChild(src, object, context, processed, property, path, this.getFormalName(property));
        }
        if (this.policy != ParserBase.ValidationPolicy.NONE) {
            for (String u : object.getPredicates().keySet()) {
                if (processed.contains(u)) continue;
                Turtle.TTLObject n = object.getPredicates().get(u);
                this.logError(n.getLine(), n.getCol(), path, ValidationMessage.IssueType.STRUCTURE, "Unrecognised predicate '" + u + "'", ValidationMessage.IssueSeverity.ERROR);
            }
        }
    }

    private void parseChild(Turtle src, Turtle.TTLComplex object, Element context, Set<String> processed, Property property, String path, String name) throws FHIRException {
        processed.add(name);
        String npath = path + "/" + property.getName();
        Turtle.TTLObject e = object.getPredicates().get(FHIR_URI_BASE + name);
        if (e == null) {
            return;
        }
        if (property.isList() && e instanceof Turtle.TTLList) {
            Turtle.TTLList arr = (Turtle.TTLList)e;
            for (Turtle.TTLObject am : arr.getList()) {
                this.parseChildInstance(src, npath, object, context, property, name, am);
            }
        } else {
            this.parseChildInstance(src, npath, object, context, property, name, e);
        }
    }

    private void parseChildInstance(Turtle src, String npath, Turtle.TTLComplex object, Element context, Property property, String name, Turtle.TTLObject e) throws FHIRException {
        if (property.isResource()) {
            this.parseResource(src, npath, object, context, property, name, e);
        } else if (e instanceof Turtle.TTLComplex) {
            Turtle.TTLComplex child = (Turtle.TTLComplex)e;
            Element n = new Element(this.tail(name), property).markLocation(e.getLine(), e.getCol());
            context.getChildren().add(n);
            if (property.isPrimitive(property.getType(this.tail(name)))) {
                this.parseChildren(src, npath, child, n, true);
                Turtle.TTLObject val = child.getPredicates().get(FHIR_URI_BASE + "value");
                if (val != null) {
                    if (val instanceof Turtle.TTLLiteral) {
                        String value = ((Turtle.TTLLiteral)val).getValue();
                        String type = ((Turtle.TTLLiteral)val).getType();
                        n.setValue(value);
                    } else {
                        this.logError(object.getLine(), object.getCol(), npath, ValidationMessage.IssueType.INVALID, "This property must be a Literal, not a " + e.getClass().getName(), ValidationMessage.IssueSeverity.ERROR);
                    }
                }
            } else {
                this.parseChildren(src, npath, child, n, false);
            }
        } else {
            this.logError(object.getLine(), object.getCol(), npath, ValidationMessage.IssueType.INVALID, "This property must be a URI or bnode, not a " + e.getClass().getName(), ValidationMessage.IssueSeverity.ERROR);
        }
    }

    private String tail(String name) {
        return name.substring(name.lastIndexOf(".") + 1);
    }

    private void parseResource(Turtle src, String npath, Turtle.TTLComplex object, Element context, Property property, String name, Turtle.TTLObject e) throws FHIRException {
        Turtle.TTLComplex obj;
        if (e instanceof Turtle.TTLComplex) {
            obj = (Turtle.TTLComplex)e;
        } else if (e instanceof Turtle.TTLURL) {
            String url = ((Turtle.TTLURL)e).getUri();
            obj = src.getObject(url);
            if (obj == null) {
                this.logError(e.getLine(), e.getCol(), npath, ValidationMessage.IssueType.INVALID, "reference to " + url + " cannot be resolved", ValidationMessage.IssueSeverity.FATAL);
                return;
            }
        } else {
            throw new FHIRFormatError("Wrong type for resource");
        }
        Turtle.TTLObject type = obj.getPredicates().get("http://www.w3.org/2000/01/rdf-schema#type");
        if (type == null) {
            this.logError(object.getLine(), object.getCol(), npath, ValidationMessage.IssueType.INVALID, "Unknown resource type (missing rdfs:type)", ValidationMessage.IssueSeverity.FATAL);
            return;
        }
        if (type instanceof Turtle.TTLList) {
            for (Turtle.TTLObject tobj : ((Turtle.TTLList)type).getList()) {
                if (!(tobj instanceof Turtle.TTLURL) || !((Turtle.TTLURL)tobj).getUri().startsWith(FHIR_URI_BASE)) continue;
                type = tobj;
                break;
            }
        }
        if (!(type instanceof Turtle.TTLURL)) {
            this.logError(object.getLine(), object.getCol(), npath, ValidationMessage.IssueType.INVALID, "Unexpected datatype for rdfs:type)", ValidationMessage.IssueSeverity.FATAL);
            return;
        }
        String rt = ((Turtle.TTLURL)type).getUri();
        String ns = rt.substring(0, rt.lastIndexOf("/"));
        rt = rt.substring(rt.lastIndexOf("/") + 1);
        StructureDefinition sd = this.getDefinition(object.getLine(), object.getCol(), ns, rt);
        if (sd == null) {
            return;
        }
        Element n = new Element(this.tail(name), property).markLocation(object.getLine(), object.getCol());
        context.getChildren().add(n);
        n.updateProperty(new Property(this.context, sd.getSnapshot().getElement().get(0), sd), Element.SpecialElement.fromProperty(n.getProperty()), property);
        n.setType(rt);
        this.parseChildren(src, npath, obj, n, false);
    }

    private String getFormalName(Property property) {
        String en = property.getDefinition().getBase().getPath();
        if (en == null) {
            en = property.getDefinition().getPath();
        }
        return en;
    }

    private String getFormalName(Property property, String elementName) {
        String en = property.getDefinition().getBase().getPath();
        if (en == null) {
            en = property.getDefinition().getPath();
        }
        if (!en.endsWith("[x]")) {
            throw new Error("Attempt to replace element name for a non-choice type");
        }
        return en.substring(0, en.lastIndexOf(".") + 1) + elementName;
    }

    @Override
    public void compose(Element e, OutputStream stream, IParser.OutputStyle style, String base) throws IOException, FHIRException {
        this.base = base;
        Turtle ttl = new Turtle();
        this.compose(e, ttl, base);
        ttl.commit(stream, false);
    }

    public void compose(Element e, Turtle ttl, String base) throws FHIRException {
        ttl.prefix("fhir", FHIR_URI_BASE);
        ttl.prefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        ttl.prefix("owl", "http://www.w3.org/2002/07/owl#");
        ttl.prefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        Turtle.Section section = ttl.section("resource");
        String subjId = this.genSubjectId(e);
        String ontologyId = subjId.replace(">", ".ttl>");
        Turtle.Section ontology = ttl.section("ontology header");
        ontology.triple(ontologyId, "a", "owl:Ontology");
        ontology.triple(ontologyId, "owl:imports", "fhir:fhir.ttl");
        if (ontologyId.startsWith("<" + FHIR_URI_BASE)) {
            ontology.triple(ontologyId, "owl:versionIRI", ontologyId.replace(FHIR_URI_BASE, FHIR_VERSION_BASE));
        }
        Turtle.Subject subject = section.triple(subjId, "a", "fhir:" + e.getType());
        subject.linkedPredicate("fhir:nodeRole", "fhir:treeRoot", this.linkResolver == null ? null : this.linkResolver.resolvePage("rdf.html#tree-root"));
        for (Element child : e.getChildren()) {
            this.composeElement(section, subject, child, null);
        }
    }

    protected String getURIType(String uri) {
        if (uri.startsWith("<" + FHIR_URI_BASE) && uri.substring(FHIR_URI_BASE.length() + 1).contains("/")) {
            return uri.substring(FHIR_URI_BASE.length() + 1, uri.indexOf(47, FHIR_URI_BASE.length() + 1));
        }
        return null;
    }

    protected String getReferenceURI(String ref) {
        if (ref != null && (ref.startsWith("http://") || ref.startsWith("https://"))) {
            return "<" + ref + ">";
        }
        if (this.base != null && ref != null && ref.contains("/")) {
            return "<" + Utilities.appendForwardSlash(this.base) + ref + ">";
        }
        return null;
    }

    protected void decorateReference(Turtle.Complex t, Element coding) {
        String refURI = this.getReferenceURI(coding.getChildValue("reference"));
        if (refURI != null) {
            t.linkedPredicate("fhir:link", refURI, this.linkResolver == null ? null : this.linkResolver.resolvePage("rdf.html#reference"));
        }
    }

    protected void decorateCanonical(Turtle.Complex t, Element canonical) {
        String refURI = this.getReferenceURI(canonical.primitiveValue());
        if (refURI != null) {
            t.linkedPredicate("fhir:link", refURI, this.linkResolver == null ? null : this.linkResolver.resolvePage("rdf.html#reference"));
        }
    }

    private String genSubjectId(Element e) {
        String id = e.getChildValue("id");
        if (this.base == null || id == null) {
            return "";
        }
        if (this.base.endsWith("#")) {
            return "<" + this.base + e.getType() + "-" + id + ">";
        }
        return "<" + Utilities.pathURL(this.base, e.getType(), id) + ">";
    }

    private String urlescape(String s2) {
        StringBuilder b = new StringBuilder();
        for (char ch : s2.toCharArray()) {
            if (Utilities.charInSet(ch, ':', ';', '=', ',')) {
                b.append("%" + Integer.toHexString(ch));
                continue;
            }
            b.append(ch);
        }
        return b.toString();
    }

    private void composeElement(Turtle.Section section, Turtle.Complex ctxt, Element element, Element parent) throws FHIRException {
        String uriType;
        String refURI;
        Turtle.Complex t;
        String en = this.getFormalName(element);
        if (element.getSpecial() == Element.SpecialElement.BUNDLE_ENTRY && parent != null && parent.getNamedChildValue("fullUrl") != null) {
            String url = "<" + parent.getNamedChildValue("fullUrl") + ">";
            ctxt.linkedPredicate("fhir:" + en, url, this.linkResolver == null ? null : this.linkResolver.resolveProperty(element.getProperty()));
            t = section.subject(url);
        } else {
            t = ctxt.linkedPredicate("fhir:" + en, this.linkResolver == null ? null : this.linkResolver.resolveProperty(element.getProperty()));
        }
        if (element.getSpecial() != null) {
            t.linkedPredicate("a", "fhir:" + element.fhirType(), this.linkResolver == null ? null : this.linkResolver.resolveType(element.fhirType()));
        }
        if (element.hasValue()) {
            t.linkedPredicate("fhir:value", TurtleParser.ttlLiteral(element.getValue(), element.getType()), this.linkResolver == null ? null : this.linkResolver.resolveType(element.getType()));
        }
        if (element.getProperty().isList() && (!element.isResource() || element.getSpecial() == Element.SpecialElement.CONTAINED)) {
            t.linkedPredicate("fhir:index", Integer.toString(element.getIndex()), this.linkResolver == null ? null : this.linkResolver.resolvePage("rdf.html#index"));
        }
        if ("Coding".equals(element.getType())) {
            this.decorateCoding(t, element, section);
        }
        if (Utilities.existsInList(element.getType(), "Reference")) {
            this.decorateReference(t, element);
        } else if (Utilities.existsInList(element.getType(), "canonical")) {
            this.decorateCanonical(t, element);
        }
        if ("canonical".equals(element.getType()) && (refURI = element.primitiveValue()) != null && (uriType = this.getURIType(refURI)) != null && !section.hasSubject(refURI)) {
            section.triple(refURI, "a", "fhir:" + uriType);
        }
        if ("Reference".equals(element.getType()) && (refURI = this.getReferenceURI(element.getChildValue("reference"))) != null && (uriType = this.getURIType(refURI)) != null && !section.hasSubject(refURI)) {
            section.triple(refURI, "a", "fhir:" + uriType);
        }
        for (Element child : element.getChildren()) {
            if ("xhtml".equals(child.getType())) {
                String childfn = this.getFormalName(child);
                t.predicate("fhir:" + childfn, TurtleParser.ttlLiteral(child.getValue(), child.getType()));
                continue;
            }
            this.composeElement(section, t, child, element);
        }
    }

    private String getFormalName(Element element) {
        String en = null;
        if (element.getSpecial() == null) {
            if (element.getProperty().getDefinition().hasBase()) {
                en = element.getProperty().getDefinition().getBase().getPath();
            }
        } else {
            en = element.getSpecial() == Element.SpecialElement.BUNDLE_ENTRY ? "Bundle.entry.resource" : (element.getSpecial() == Element.SpecialElement.BUNDLE_OUTCOME ? "Bundle.entry.response.outcome" : (element.getSpecial() == Element.SpecialElement.PARAMETER ? element.getElementProperty().getDefinition().getPath() : "DomainResource.contained"));
        }
        if (en == null) {
            en = element.getProperty().getDefinition().getPath();
        }
        boolean doType = false;
        if (en.endsWith("[x]")) {
            en = en.substring(0, en.length() - 3);
            doType = true;
        }
        if (doType || element.getProperty().getDefinition().getType().size() > 1 && !this.allReference(element.getProperty().getDefinition().getType())) {
            en = en + Utilities.capitalize(element.getType());
        }
        return en;
    }

    private boolean allReference(List<ElementDefinition.TypeRefComponent> types) {
        for (ElementDefinition.TypeRefComponent t : types) {
            if (t.getCode().equals("Reference")) continue;
            return false;
        }
        return true;
    }

    public static String ttlLiteral(String value, String type) {
        String xst = "";
        if (type.equals("boolean")) {
            xst = "^^xsd:boolean";
        } else if (type.equals("integer")) {
            xst = "^^xsd:integer";
        } else if (type.equals("unsignedInt")) {
            xst = "^^xsd:nonNegativeInteger";
        } else if (type.equals("positiveInt")) {
            xst = "^^xsd:positiveInteger";
        } else if (type.equals("decimal")) {
            xst = "^^xsd:decimal";
        } else if (type.equals("base64Binary")) {
            xst = "^^xsd:base64Binary";
        } else if (type.equals("instant")) {
            xst = "^^xsd:dateTime";
        } else if (type.equals("time")) {
            xst = "^^xsd:time";
        } else if (type.equals("date") || type.equals("dateTime")) {
            String v = value;
            if (v.length() > 10) {
                int i = value.substring(10).indexOf("-");
                if (i == -1) {
                    i = value.substring(10).indexOf("+");
                }
                String string = v = i == -1 ? value : value.substring(0, 10 + i);
            }
            if (v.length() > 10) {
                xst = "^^xsd:dateTime";
            } else if (v.length() == 10) {
                xst = "^^xsd:date";
            } else if (v.length() == 7) {
                xst = "^^xsd:gYearMonth";
            } else if (v.length() == 4) {
                xst = "^^xsd:gYear";
            }
        }
        return "\"" + Turtle.escape(value, true) + "\"" + xst;
    }

    protected void decorateCoding(Turtle.Complex t, Element coding, Turtle.Section section) throws FHIRException {
        String system = coding.getChildValue("system");
        String code = coding.getChildValue("code");
        if (system == null || code == null) {
            return;
        }
        if ("http://snomed.info/sct".equals(system)) {
            t.prefix("sct", "http://snomed.info/id/");
            if (code.contains(":") || code.contains("=")) {
                this.generateLinkedPredicate(t, code);
            } else {
                t.linkedPredicate("a", "sct:" + this.urlescape(code), null);
            }
        } else if ("http://loinc.org".equals(system)) {
            t.prefix("loinc", "http://loinc.org/rdf#");
            t.linkedPredicate("a", "loinc:" + this.urlescape(code).toUpperCase(), null);
        }
    }

    private void generateLinkedPredicate(Turtle.Complex t, String code) throws FHIRException {
        SnomedExpressions.Expression expression = SnomedExpressions.parse(code);
    }
}

