/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.utils;

import org.hl7.fhir.dstu3.model.ExpressionNode;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

public class FHIRLexer {
    private String source;
    private int cursor;
    private int currentStart;
    private String current;
    private ExpressionNode.SourceLocation currentLocation;
    private ExpressionNode.SourceLocation currentStartLocation;
    private int id;

    public FHIRLexer(String source) throws FHIRLexerException {
        this.source = source;
        this.currentLocation = new ExpressionNode.SourceLocation(1, 1);
        this.next();
    }

    public String getCurrent() {
        return this.current;
    }

    public ExpressionNode.SourceLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public boolean isConstant(boolean incDoubleQuotes) {
        return this.current.charAt(0) == '\'' || incDoubleQuotes && this.current.charAt(0) == '\"' || this.current.charAt(0) == '@' || this.current.charAt(0) == '%' || this.current.charAt(0) == '-' || this.current.charAt(0) == '+' || this.current.charAt(0) >= '0' && this.current.charAt(0) <= '9' || this.current.equals("true") || this.current.equals("false") || this.current.equals("{}");
    }

    public boolean isStringConstant() {
        return this.current.charAt(0) == '\'' || this.current.charAt(0) == '\"';
    }

    public String take() throws FHIRLexerException {
        String s2 = this.current;
        this.next();
        return s2;
    }

    public int takeInt() throws FHIRLexerException {
        String s2 = this.current;
        if (!Utilities.isInteger(s2)) {
            throw this.error("Found " + this.current + " expecting an integer");
        }
        this.next();
        return Integer.parseInt(s2);
    }

    public boolean isToken() {
        if (Utilities.noString(this.current)) {
            return false;
        }
        if (this.current.startsWith("$")) {
            return true;
        }
        if (this.current.equals("*") || this.current.equals("**")) {
            return true;
        }
        if (this.current.charAt(0) >= 'A' && this.current.charAt(0) <= 'Z' || this.current.charAt(0) >= 'a' && this.current.charAt(0) <= 'z') {
            for (int i = 1; i < this.current.length(); ++i) {
                if (this.current.charAt(1) >= 'A' && this.current.charAt(1) <= 'Z' || this.current.charAt(1) >= 'a' && this.current.charAt(1) <= 'z' || this.current.charAt(1) >= '0' && this.current.charAt(1) <= '9') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public FHIRLexerException error(String msg) {
        return this.error(msg, this.currentLocation.toString());
    }

    public FHIRLexerException error(String msg, String location) {
        return new FHIRLexerException("Error at " + location + ": " + msg);
    }

    public void next() throws FHIRLexerException {
        this.current = null;
        boolean last13 = false;
        while (this.cursor < this.source.length() && Character.isWhitespace(this.source.charAt(this.cursor))) {
            if (this.source.charAt(this.cursor) == '\r') {
                this.currentLocation.setLine(this.currentLocation.getLine() + 1);
                this.currentLocation.setColumn(1);
                last13 = true;
            } else if (!last13 && this.source.charAt(this.cursor) == '\n') {
                this.currentLocation.setLine(this.currentLocation.getLine() + 1);
                this.currentLocation.setColumn(1);
                last13 = false;
            } else {
                last13 = false;
                this.currentLocation.setColumn(this.currentLocation.getColumn() + 1);
            }
            ++this.cursor;
        }
        this.currentStart = this.cursor;
        this.currentStartLocation = this.currentLocation;
        if (this.cursor < this.source.length()) {
            char ch = this.source.charAt(this.cursor);
            if (ch == '!' || ch == '>' || ch == '<' || ch == ':' || ch == '-' || ch == '=') {
                ++this.cursor;
                if (this.cursor < this.source.length() && (this.source.charAt(this.cursor) == '=' || this.source.charAt(this.cursor) == '~' || this.source.charAt(this.cursor) == '-')) {
                    ++this.cursor;
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch == '.') {
                ++this.cursor;
                if (this.cursor < this.source.length() && this.source.charAt(this.cursor) == '.') {
                    ++this.cursor;
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch >= '0' && ch <= '9') {
                ++this.cursor;
                boolean dotted = false;
                while (this.cursor < this.source.length() && (this.source.charAt(this.cursor) >= '0' && this.source.charAt(this.cursor) <= '9' || this.source.charAt(this.cursor) == '.' && !dotted)) {
                    if (this.source.charAt(this.cursor) == '.') {
                        dotted = true;
                    }
                    ++this.cursor;
                }
                if (this.source.charAt(this.cursor - 1) == '.') {
                    --this.cursor;
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                while (this.cursor < this.source.length() && (this.source.charAt(this.cursor) >= 'A' && this.source.charAt(this.cursor) <= 'Z' || this.source.charAt(this.cursor) >= 'a' && this.source.charAt(this.cursor) <= 'z' || this.source.charAt(this.cursor) >= '0' && this.source.charAt(this.cursor) <= '9' || this.source.charAt(this.cursor) == '_')) {
                    ++this.cursor;
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch == '%') {
                ++this.cursor;
                if (this.cursor < this.source.length() && this.source.charAt(this.cursor) == '\"') {
                    ++this.cursor;
                    while (this.cursor < this.source.length() && this.source.charAt(this.cursor) != '\"') {
                        ++this.cursor;
                    }
                    ++this.cursor;
                } else {
                    while (this.cursor < this.source.length() && (this.source.charAt(this.cursor) >= 'A' && this.source.charAt(this.cursor) <= 'Z' || this.source.charAt(this.cursor) >= 'a' && this.source.charAt(this.cursor) <= 'z' || this.source.charAt(this.cursor) >= '0' && this.source.charAt(this.cursor) <= '9' || this.source.charAt(this.cursor) == ':' || this.source.charAt(this.cursor) == '-')) {
                        ++this.cursor;
                    }
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch == '/') {
                ++this.cursor;
                if (this.cursor < this.source.length() && this.source.charAt(this.cursor) == '/') {
                    ++this.cursor;
                    while (this.cursor < this.source.length() && this.source.charAt(this.cursor) != '\r' && this.source.charAt(this.cursor) != '\n') {
                        ++this.cursor;
                    }
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch == '$') {
                ++this.cursor;
                while (this.cursor < this.source.length() && this.source.charAt(this.cursor) >= 'a' && this.source.charAt(this.cursor) <= 'z') {
                    ++this.cursor;
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch == '{') {
                ++this.cursor;
                ch = this.source.charAt(this.cursor);
                if (ch == '}') {
                    ++this.cursor;
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch == '\"') {
                ++this.cursor;
                boolean escape = false;
                while (this.cursor < this.source.length() && (escape || this.source.charAt(this.cursor) != '\"')) {
                    escape = escape ? false : this.source.charAt(this.cursor) == '\\';
                    ++this.cursor;
                }
                if (this.cursor == this.source.length()) {
                    throw this.error("Unterminated string");
                }
                ++this.cursor;
                this.current = "\"" + this.source.substring(this.currentStart + 1, this.cursor - 1) + "\"";
            } else if (ch == '\'') {
                ++this.cursor;
                char ech = ch;
                boolean escape = false;
                while (this.cursor < this.source.length() && (escape || this.source.charAt(this.cursor) != ech)) {
                    escape = escape ? false : this.source.charAt(this.cursor) == '\\';
                    ++this.cursor;
                }
                if (this.cursor == this.source.length()) {
                    throw this.error("Unterminated string");
                }
                ++this.cursor;
                this.current = this.source.substring(this.currentStart, this.cursor);
                if (ech == '\'') {
                    this.current = "'" + this.current.substring(1, this.current.length() - 1) + "'";
                }
            } else if (ch == '@') {
                ++this.cursor;
                while (this.cursor < this.source.length() && this.isDateChar(this.source.charAt(this.cursor))) {
                    ++this.cursor;
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else {
                ++this.cursor;
                this.current = this.source.substring(this.currentStart, this.cursor);
            }
        }
    }

    private boolean isDateChar(char ch) {
        return ch == '-' || ch == ':' || ch == 'T' || ch == '+' || ch == 'Z' || Character.isDigit(ch);
    }

    public boolean isOp() {
        return ExpressionNode.Operation.fromCode(this.current) != null;
    }

    public boolean done() {
        return this.currentStart >= this.source.length();
    }

    public int nextId() {
        ++this.id;
        return this.id;
    }

    public ExpressionNode.SourceLocation getCurrentStartLocation() {
        return this.currentStartLocation;
    }

    public void setCurrent(String current) {
        this.current = current;
    }

    public boolean hasComment() {
        return !this.done() && this.current.startsWith("//");
    }

    public boolean hasToken(String kw) {
        return !this.done() && kw.equals(this.current);
    }

    public boolean hasToken(String ... names) {
        if (this.done()) {
            return false;
        }
        for (String s2 : names) {
            if (!s2.equals(this.current)) continue;
            return true;
        }
        return false;
    }

    public void token(String kw) throws FHIRLexerException {
        if (!kw.equals(this.current)) {
            throw this.error("Found \"" + this.current + "\" expecting \"" + kw + "\"");
        }
        this.next();
    }

    public String readConstant(String desc) throws FHIRLexerException {
        if (!this.isStringConstant()) {
            throw this.error("Found " + this.current + " expecting \"[" + desc + "]\"");
        }
        return this.processConstant(this.take());
    }

    public String processConstant(String s2) throws FHIRLexerException {
        StringBuilder b = new StringBuilder();
        int i = 1;
        block10: while (i < s2.length() - 1) {
            char ch = s2.charAt(i);
            if (ch == '\\') {
                switch (s2.charAt(++i)) {
                    case 't': {
                        b.append('\t');
                        continue block10;
                    }
                    case 'r': {
                        b.append('\r');
                        continue block10;
                    }
                    case 'n': {
                        b.append('\n');
                        continue block10;
                    }
                    case 'f': {
                        b.append('\f');
                        continue block10;
                    }
                    case '\'': {
                        b.append('\'');
                        continue block10;
                    }
                    case '\\': {
                        b.append('\\');
                        continue block10;
                    }
                    case '/': {
                        b.append('\\');
                        continue block10;
                    }
                    case 'u': {
                        int uc = Integer.parseInt(s2.substring(++i, i + 4), 16);
                        b.append((char)uc);
                        i += 4;
                        continue block10;
                    }
                }
                throw new FHIRLexerException("Unknown character escape \\" + s2.charAt(i));
            }
            b.append(ch);
            ++i;
        }
        return b.toString();
    }

    public void skipToken(String token) throws FHIRLexerException {
        if (this.getCurrent().equals(token)) {
            this.next();
        }
    }

    public String takeDottedToken() throws FHIRLexerException {
        StringBuilder b = new StringBuilder();
        b.append(this.take());
        while (!this.done() && this.getCurrent().equals(".")) {
            b.append(this.take());
            b.append(this.take());
        }
        return b.toString();
    }

    void skipComments() throws FHIRLexerException {
        while (!this.done() && this.hasComment()) {
            this.next();
        }
    }

    public class FHIRLexerException
    extends FHIRException {
        public FHIRLexerException() {
        }

        public FHIRLexerException(String message, Throwable cause) {
            super(message, cause);
        }

        public FHIRLexerException(String message) {
            super(message);
        }

        public FHIRLexerException(Throwable cause) {
            super(cause);
        }
    }
}

