/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.TransactionMode;

public class TransactionModeEnumFactory
implements EnumFactory<TransactionMode> {
    @Override
    public TransactionMode fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("not-supported".equals(codeString)) {
            return TransactionMode.NOTSUPPORTED;
        }
        if ("batch".equals(codeString)) {
            return TransactionMode.BATCH;
        }
        if ("transaction".equals(codeString)) {
            return TransactionMode.TRANSACTION;
        }
        if ("both".equals(codeString)) {
            return TransactionMode.BOTH;
        }
        throw new IllegalArgumentException("Unknown TransactionMode code '" + codeString + "'");
    }

    @Override
    public String toCode(TransactionMode code) {
        if (code == TransactionMode.NOTSUPPORTED) {
            return "not-supported";
        }
        if (code == TransactionMode.BATCH) {
            return "batch";
        }
        if (code == TransactionMode.TRANSACTION) {
            return "transaction";
        }
        if (code == TransactionMode.BOTH) {
            return "both";
        }
        return "?";
    }

    @Override
    public String toSystem(TransactionMode code) {
        return code.getSystem();
    }
}

