/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum RequestStage {
    PROPOSAL,
    PLAN,
    ORIGINALORDER,
    ENCODED,
    REFLEXORDER,
    NULL;


    public static RequestStage fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposal".equals(codeString)) {
            return PROPOSAL;
        }
        if ("plan".equals(codeString)) {
            return PLAN;
        }
        if ("original-order".equals(codeString)) {
            return ORIGINALORDER;
        }
        if ("encoded".equals(codeString)) {
            return ENCODED;
        }
        if ("reflex-order".equals(codeString)) {
            return REFLEXORDER;
        }
        throw new FHIRException("Unknown RequestStage code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROPOSAL: {
                return "proposal";
            }
            case PLAN: {
                return "plan";
            }
            case ORIGINALORDER: {
                return "original-order";
            }
            case ENCODED: {
                return "encoded";
            }
            case REFLEXORDER: {
                return "reflex-order";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/request-stage";
    }

    public String getDefinition() {
        switch (this) {
            case PROPOSAL: {
                return "The request is a proposal";
            }
            case PLAN: {
                return "The request is a plan";
            }
            case ORIGINALORDER: {
                return "The request is an order.";
            }
            case ENCODED: {
                return "Represents an order created by a fulfiller as a representation of the specific action(s) they intend to take to fulfill the original order.  Typically these orders are more fully encoded than the original placer order.";
            }
            case REFLEXORDER: {
                return "Represents a separate order created by a fulfiller as result of fulfilment of an order.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROPOSAL: {
                return "Proposal";
            }
            case PLAN: {
                return "Plan";
            }
            case ORIGINALORDER: {
                return "Original Order";
            }
            case ENCODED: {
                return "Encoded";
            }
            case REFLEXORDER: {
                return "Reflex Order";
            }
        }
        return "?";
    }
}

