/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.OperationalStatus;

public class OperationalStatusEnumFactory
implements EnumFactory<OperationalStatus> {
    @Override
    public OperationalStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("off".equals(codeString)) {
            return OperationalStatus.OFF;
        }
        if ("on".equals(codeString)) {
            return OperationalStatus.ON;
        }
        if ("not-ready".equals(codeString)) {
            return OperationalStatus.NOTREADY;
        }
        if ("standby".equals(codeString)) {
            return OperationalStatus.STANDBY;
        }
        if ("transduc-discon".equals(codeString)) {
            return OperationalStatus.TRANSDUCDISCON;
        }
        if ("hw-discon".equals(codeString)) {
            return OperationalStatus.HWDISCON;
        }
        if ("entered-in-error".equals(codeString)) {
            return OperationalStatus.ENTEREDINERROR;
        }
        throw new IllegalArgumentException("Unknown OperationalStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(OperationalStatus code) {
        if (code == OperationalStatus.OFF) {
            return "off";
        }
        if (code == OperationalStatus.ON) {
            return "on";
        }
        if (code == OperationalStatus.NOTREADY) {
            return "not-ready";
        }
        if (code == OperationalStatus.STANDBY) {
            return "standby";
        }
        if (code == OperationalStatus.TRANSDUCDISCON) {
            return "transduc-discon";
        }
        if (code == OperationalStatus.HWDISCON) {
            return "hw-discon";
        }
        if (code == OperationalStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        return "?";
    }

    @Override
    public String toSystem(OperationalStatus code) {
        return code.getSystem();
    }
}

