/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NoteType {
    DISPLAY,
    PRINT,
    PRINTOPER,
    NULL;


    public static NoteType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("display".equals(codeString)) {
            return DISPLAY;
        }
        if ("print".equals(codeString)) {
            return PRINT;
        }
        if ("printoper".equals(codeString)) {
            return PRINTOPER;
        }
        throw new FHIRException("Unknown NoteType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DISPLAY: {
                return "display";
            }
            case PRINT: {
                return "print";
            }
            case PRINTOPER: {
                return "printoper";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/note-type";
    }

    public String getDefinition() {
        switch (this) {
            case DISPLAY: {
                return "Display the note.";
            }
            case PRINT: {
                return "Print the note on the form.";
            }
            case PRINTOPER: {
                return "Print the note for the operator.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DISPLAY: {
                return "Display";
            }
            case PRINT: {
                return "Print (Form)";
            }
            case PRINTOPER: {
                return "Print (Operator)";
            }
        }
        return "?";
    }
}

