/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum FmItemtype {
    GROUP,
    PRODUCT,
    SERVICE,
    NULL;


    public static FmItemtype fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("group".equals(codeString)) {
            return GROUP;
        }
        if ("product".equals(codeString)) {
            return PRODUCT;
        }
        if ("service".equals(codeString)) {
            return SERVICE;
        }
        throw new FHIRException("Unknown FmItemtype code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case GROUP: {
                return "group";
            }
            case PRODUCT: {
                return "product";
            }
            case SERVICE: {
                return "service";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-claimitemtype";
    }

    public String getDefinition() {
        switch (this) {
            case GROUP: {
                return "A group of products and/or Services, amount ar the summary or detail level products and services.";
            }
            case PRODUCT: {
                return "A billed product line item.";
            }
            case SERVICE: {
                return "A billed service line item.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case GROUP: {
                return "Group";
            }
            case PRODUCT: {
                return "Product";
            }
            case SERVICE: {
                return "Service";
            }
        }
        return "?";
    }
}

