/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EncounterLocationStatus {
    PLANNED,
    ACTIVE,
    RESERVED,
    COMPLETED,
    NULL;


    public static EncounterLocationStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("planned".equals(codeString)) {
            return PLANNED;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("reserved".equals(codeString)) {
            return RESERVED;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        throw new FHIRException("Unknown EncounterLocationStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PLANNED: {
                return "planned";
            }
            case ACTIVE: {
                return "active";
            }
            case RESERVED: {
                return "reserved";
            }
            case COMPLETED: {
                return "completed";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/encounter-location-status";
    }

    public String getDefinition() {
        switch (this) {
            case PLANNED: {
                return "The patient is planned to be moved to this location at some point in the future.";
            }
            case ACTIVE: {
                return "The patient is currently at this location, or was between the period specified.\r\rA system may update these records when the patient leaves the location to either reserved, or completed";
            }
            case RESERVED: {
                return "This location is held empty for this patient.";
            }
            case COMPLETED: {
                return "The patient was at this location during the period specified.\r\rNot to be used when the patient is currently at the location";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PLANNED: {
                return "Planned";
            }
            case ACTIVE: {
                return "Active";
            }
            case RESERVED: {
                return "Reserved";
            }
            case COMPLETED: {
                return "Completed";
            }
        }
        return "?";
    }
}

