/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConditionalReadStatus {
    NOTSUPPORTED,
    MODIFIEDSINCE,
    NOTMATCH,
    FULLSUPPORT,
    NULL;


    public static ConditionalReadStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("not-supported".equals(codeString)) {
            return NOTSUPPORTED;
        }
        if ("modified-since".equals(codeString)) {
            return MODIFIEDSINCE;
        }
        if ("not-match".equals(codeString)) {
            return NOTMATCH;
        }
        if ("full-support".equals(codeString)) {
            return FULLSUPPORT;
        }
        throw new FHIRException("Unknown ConditionalReadStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NOTSUPPORTED: {
                return "not-supported";
            }
            case MODIFIEDSINCE: {
                return "modified-since";
            }
            case NOTMATCH: {
                return "not-match";
            }
            case FULLSUPPORT: {
                return "full-support";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/conditional-read-status";
    }

    public String getDefinition() {
        switch (this) {
            case NOTSUPPORTED: {
                return "No support for conditional deletes.";
            }
            case MODIFIEDSINCE: {
                return "Conditional reads are supported, but only with the If-Modified-Since HTTP Header.";
            }
            case NOTMATCH: {
                return "Conditional reads are supported, but only with the If-None-Match HTTP Header.";
            }
            case FULLSUPPORT: {
                return "Conditional reads are supported, with both If-Modified-Since and If-None-Match HTTP Headers.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NOTSUPPORTED: {
                return "Not Supported";
            }
            case MODIFIEDSINCE: {
                return "If-Modified-Since";
            }
            case NOTMATCH: {
                return "If-None-Match";
            }
            case FULLSUPPORT: {
                return "Full Support";
            }
        }
        return "?";
    }
}

