/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConditionState {
    ACTIVE,
    INACTIVE,
    RESOLVED,
    NULL;


    public static ConditionState fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("inactive".equals(codeString)) {
            return INACTIVE;
        }
        if ("resolved".equals(codeString)) {
            return RESOLVED;
        }
        throw new FHIRException("Unknown ConditionState code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case INACTIVE: {
                return "inactive";
            }
            case RESOLVED: {
                return "resolved";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/condition-state";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "The condition is active.";
            }
            case INACTIVE: {
                return "The condition is inactive, but not resolved.";
            }
            case RESOLVED: {
                return "The condition is resolved.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case INACTIVE: {
                return "Inactive";
            }
            case RESOLVED: {
                return "Resolved";
            }
        }
        return "?";
    }
}

