/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ConditionCategory;

public class ConditionCategoryEnumFactory
implements EnumFactory<ConditionCategory> {
    @Override
    public ConditionCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("problem-list-item".equals(codeString)) {
            return ConditionCategory.PROBLEMLISTITEM;
        }
        if ("encounter-diagnosis".equals(codeString)) {
            return ConditionCategory.ENCOUNTERDIAGNOSIS;
        }
        throw new IllegalArgumentException("Unknown ConditionCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(ConditionCategory code) {
        if (code == ConditionCategory.PROBLEMLISTITEM) {
            return "problem-list-item";
        }
        if (code == ConditionCategory.ENCOUNTERDIAGNOSIS) {
            return "encounter-diagnosis";
        }
        return "?";
    }

    @Override
    public String toSystem(ConditionCategory code) {
        return code.getSystem();
    }
}

