/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ClaimType;

public class ClaimTypeEnumFactory
implements EnumFactory<ClaimType> {
    @Override
    public ClaimType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("institutional".equals(codeString)) {
            return ClaimType.INSTITUTIONAL;
        }
        if ("oral".equals(codeString)) {
            return ClaimType.ORAL;
        }
        if ("pharmacy".equals(codeString)) {
            return ClaimType.PHARMACY;
        }
        if ("professional".equals(codeString)) {
            return ClaimType.PROFESSIONAL;
        }
        if ("vision".equals(codeString)) {
            return ClaimType.VISION;
        }
        throw new IllegalArgumentException("Unknown ClaimType code '" + codeString + "'");
    }

    @Override
    public String toCode(ClaimType code) {
        if (code == ClaimType.INSTITUTIONAL) {
            return "institutional";
        }
        if (code == ClaimType.ORAL) {
            return "oral";
        }
        if (code == ClaimType.PHARMACY) {
            return "pharmacy";
        }
        if (code == ClaimType.PROFESSIONAL) {
            return "professional";
        }
        if (code == ClaimType.VISION) {
            return "vision";
        }
        return "?";
    }

    @Override
    public String toSystem(ClaimType code) {
        return code.getSystem();
    }
}

