/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AdverseEventCausalityResult {
    RESULT1,
    RESULT2,
    NULL;


    public static AdverseEventCausalityResult fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("result1".equals(codeString)) {
            return RESULT1;
        }
        if ("result2".equals(codeString)) {
            return RESULT2;
        }
        throw new FHIRException("Unknown AdverseEventCausalityResult code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case RESULT1: {
                return "result1";
            }
            case RESULT2: {
                return "result2";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/adverse-event-causality-result";
    }

    public String getDefinition() {
        switch (this) {
            case RESULT1: {
                return "";
            }
            case RESULT2: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case RESULT1: {
                return "placeholder";
            }
            case RESULT2: {
                return "placeholder";
            }
        }
        return "?";
    }
}

