/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Duration;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Person;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="RequestGroup", profile="http://hl7.org/fhir/Profile/RequestGroup")
public class RequestGroup
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="Allows a service to provide a unique, business identifier for the request.")
    protected List<Identifier> identifier;
    @Child(name="definition", type={Reference.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instantiates protocol or definition", formalDefinition="A protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.")
    protected List<Reference> definition;
    protected List<Resource> definitionTarget;
    @Child(name="basedOn", type={Reference.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Fulfills plan, proposal, or order", formalDefinition="A plan, proposal or order that is fulfilled in whole or in part by this request.")
    protected List<Reference> basedOn;
    protected List<Resource> basedOnTarget;
    @Child(name="replaces", type={Reference.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Request(s) replaced by this request", formalDefinition="Completed or terminated request(s) whose function is taken by this new request.")
    protected List<Reference> replaces;
    protected List<Resource> replacesTarget;
    @Child(name="groupIdentifier", type={Identifier.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Composite request this is part of", formalDefinition="A shared identifier common to all requests that were authorized more or less simultaneously by a single author, representing the identifier of the requisition, prescription or similar form.")
    protected Identifier groupIdentifier;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | suspended | cancelled | completed | entered-in-error | unknown", formalDefinition="The current state of the request. For request groups, the status reflects the status of all the requests in the group.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-status")
    protected Enumeration<RequestStatus> status;
    @Child(name="intent", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposal | plan | order", formalDefinition="Indicates the level of authority/intentionality associated with the request and where the request fits into the workflow chain.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-intent")
    protected Enumeration<RequestIntent> intent;
    @Child(name="priority", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="routine | urgent | asap | stat", formalDefinition="Indicates how quickly the request should be addressed with respect to other requests.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
    protected Enumeration<RequestPriority> priority;
    @Child(name="subject", type={Patient.class, Group.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who the request group is about", formalDefinition="The subject for which the request group was created.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Encounter or Episode for the request group", formalDefinition="Describes the context of the request group, if any.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="authoredOn", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the request group was authored", formalDefinition="Indicates when the request group was created.")
    protected DateTimeType authoredOn;
    @Child(name="author", type={Device.class, Practitioner.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Device or practitioner that authored the request group", formalDefinition="Provides a reference to the author of the request group.")
    protected Reference author;
    protected Resource authorTarget;
    @Child(name="reason", type={CodeableConcept.class, Reference.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for the request group", formalDefinition="Indicates the reason the request group was created. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.")
    protected Type reason;
    @Child(name="note", type={Annotation.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional notes about the response", formalDefinition="Provides a mechanism to communicate additional information about the response.")
    protected List<Annotation> note;
    @Child(name="action", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Proposed actions, if any", formalDefinition="The actions, if any, produced by the evaluation of the artifact.")
    protected List<RequestGroupActionComponent> action;
    private static final long serialVersionUID = -1812083587L;
    @SearchParamDefinition(name="authored", path="RequestGroup.authoredOn", description="The date the request group was authored", type="date")
    public static final String SP_AUTHORED = "authored";
    public static final DateClientParam AUTHORED = new DateClientParam("authored");
    @SearchParamDefinition(name="identifier", path="RequestGroup.identifier", description="External identifiers for the request group", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="subject", path="RequestGroup.subject", description="The subject that the request group is about", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("RequestGroup:subject").toLocked();
    @SearchParamDefinition(name="author", path="RequestGroup.author", description="The author of the request group", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Practitioner")}, target={Device.class, Practitioner.class})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("RequestGroup:author").toLocked();
    @SearchParamDefinition(name="encounter", path="RequestGroup.context", description="The encounter the request group applies to", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("RequestGroup:encounter").toLocked();
    @SearchParamDefinition(name="priority", path="RequestGroup.priority", description="The priority of the request group", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="intent", path="RequestGroup.intent", description="The intent of the request group", type="token")
    public static final String SP_INTENT = "intent";
    public static final TokenClientParam INTENT = new TokenClientParam("intent");
    @SearchParamDefinition(name="participant", path="RequestGroup.action.participant", description="The participant in the requests in the group", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Patient.class, Person.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_PARTICIPANT = "participant";
    public static final ReferenceClientParam PARTICIPANT = new ReferenceClientParam("participant");
    public static final Include INCLUDE_PARTICIPANT = new Include("RequestGroup:participant").toLocked();
    @SearchParamDefinition(name="group-identifier", path="RequestGroup.groupIdentifier", description="The group identifier for the request group", type="token")
    public static final String SP_GROUP_IDENTIFIER = "group-identifier";
    public static final TokenClientParam GROUP_IDENTIFIER = new TokenClientParam("group-identifier");
    @SearchParamDefinition(name="patient", path="RequestGroup.subject", description="The identity of a patient to search for request groups", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("RequestGroup:patient").toLocked();
    @SearchParamDefinition(name="context", path="RequestGroup.context", description="The context the request group applies to", type="reference", target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("RequestGroup:context").toLocked();
    @SearchParamDefinition(name="definition", path="RequestGroup.definition", description="The definition from which the request group is realized", type="reference")
    public static final String SP_DEFINITION = "definition";
    public static final ReferenceClientParam DEFINITION = new ReferenceClientParam("definition");
    public static final Include INCLUDE_DEFINITION = new Include("RequestGroup:definition").toLocked();
    @SearchParamDefinition(name="status", path="RequestGroup.status", description="The status of the request group", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public RequestGroup() {
    }

    public RequestGroup(Enumeration<RequestStatus> status, Enumeration<RequestIntent> intent) {
        this.status = status;
        this.intent = intent;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public RequestGroup setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public RequestGroup addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getDefinition() {
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        return this.definition;
    }

    public RequestGroup setDefinition(List<Reference> theDefinition) {
        this.definition = theDefinition;
        return this;
    }

    public boolean hasDefinition() {
        if (this.definition == null) {
            return false;
        }
        for (Reference item : this.definition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDefinition() {
        Reference t = new Reference();
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return t;
    }

    public RequestGroup addDefinition(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return this;
    }

    public Reference getDefinitionFirstRep() {
        if (this.getDefinition().isEmpty()) {
            this.addDefinition();
        }
        return this.getDefinition().get(0);
    }

    @Deprecated
    public List<Resource> getDefinitionTarget() {
        if (this.definitionTarget == null) {
            this.definitionTarget = new ArrayList<Resource>();
        }
        return this.definitionTarget;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public RequestGroup setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public RequestGroup addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    @Deprecated
    public List<Resource> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<Resource>();
        }
        return this.basedOnTarget;
    }

    public List<Reference> getReplaces() {
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        return this.replaces;
    }

    public RequestGroup setReplaces(List<Reference> theReplaces) {
        this.replaces = theReplaces;
        return this;
    }

    public boolean hasReplaces() {
        if (this.replaces == null) {
            return false;
        }
        for (Reference item : this.replaces) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReplaces() {
        Reference t = new Reference();
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return t;
    }

    public RequestGroup addReplaces(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return this;
    }

    public Reference getReplacesFirstRep() {
        if (this.getReplaces().isEmpty()) {
            this.addReplaces();
        }
        return this.getReplaces().get(0);
    }

    @Deprecated
    public List<Resource> getReplacesTarget() {
        if (this.replacesTarget == null) {
            this.replacesTarget = new ArrayList<Resource>();
        }
        return this.replacesTarget;
    }

    public Identifier getGroupIdentifier() {
        if (this.groupIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.groupIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.groupIdentifier = new Identifier();
            }
        }
        return this.groupIdentifier;
    }

    public boolean hasGroupIdentifier() {
        return this.groupIdentifier != null && !this.groupIdentifier.isEmpty();
    }

    public RequestGroup setGroupIdentifier(Identifier value) {
        this.groupIdentifier = value;
        return this;
    }

    public Enumeration<RequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<RequestStatus>(new RequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public RequestGroup setStatusElement(Enumeration<RequestStatus> value) {
        this.status = value;
        return this;
    }

    public RequestStatus getStatus() {
        return this.status == null ? null : (RequestStatus)((Object)this.status.getValue());
    }

    public RequestGroup setStatus(RequestStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<RequestStatus>(new RequestStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<RequestIntent> getIntentElement() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new Enumeration<RequestIntent>(new RequestIntentEnumFactory());
            }
        }
        return this.intent;
    }

    public boolean hasIntentElement() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public RequestGroup setIntentElement(Enumeration<RequestIntent> value) {
        this.intent = value;
        return this;
    }

    public RequestIntent getIntent() {
        return this.intent == null ? null : (RequestIntent)((Object)this.intent.getValue());
    }

    public RequestGroup setIntent(RequestIntent value) {
        if (this.intent == null) {
            this.intent = new Enumeration<RequestIntent>(new RequestIntentEnumFactory());
        }
        this.intent.setValue((Object)value);
        return this;
    }

    public Enumeration<RequestPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<RequestPriority>(new RequestPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public RequestGroup setPriorityElement(Enumeration<RequestPriority> value) {
        this.priority = value;
        return this;
    }

    public RequestPriority getPriority() {
        return this.priority == null ? null : (RequestPriority)((Object)this.priority.getValue());
    }

    public RequestGroup setPriority(RequestPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<RequestPriority>(new RequestPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public RequestGroup setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public RequestGroup setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public RequestGroup setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public RequestGroup setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public DateTimeType getAuthoredOnElement() {
        if (this.authoredOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.authoredOn");
            }
            if (Configuration.doAutoCreate()) {
                this.authoredOn = new DateTimeType();
            }
        }
        return this.authoredOn;
    }

    public boolean hasAuthoredOnElement() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public boolean hasAuthoredOn() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public RequestGroup setAuthoredOnElement(DateTimeType value) {
        this.authoredOn = value;
        return this;
    }

    public Date getAuthoredOn() {
        return this.authoredOn == null ? null : (Date)this.authoredOn.getValue();
    }

    public RequestGroup setAuthoredOn(Date value) {
        if (value == null) {
            this.authoredOn = null;
        } else {
            if (this.authoredOn == null) {
                this.authoredOn = new DateTimeType();
            }
            this.authoredOn.setValue(value);
        }
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RequestGroup.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public RequestGroup setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public RequestGroup setAuthorTarget(Resource value) {
        this.authorTarget = value;
        return this;
    }

    public Type getReason() {
        return this.reason;
    }

    public CodeableConcept getReasonCodeableConcept() throws FHIRException {
        if (this.reason == null) {
            return null;
        }
        if (!(this.reason instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.reason;
    }

    public boolean hasReasonCodeableConcept() {
        return this != null && this.reason instanceof CodeableConcept;
    }

    public Reference getReasonReference() throws FHIRException {
        if (this.reason == null) {
            return null;
        }
        if (!(this.reason instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (Reference)this.reason;
    }

    public boolean hasReasonReference() {
        return this != null && this.reason instanceof Reference;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public RequestGroup setReason(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new FHIRFormatError("Not the right type for RequestGroup.reason[x]: " + value.fhirType());
        }
        this.reason = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public RequestGroup setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public RequestGroup addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<RequestGroupActionComponent> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<RequestGroupActionComponent>();
        }
        return this.action;
    }

    public RequestGroup setAction(List<RequestGroupActionComponent> theAction) {
        this.action = theAction;
        return this;
    }

    public boolean hasAction() {
        if (this.action == null) {
            return false;
        }
        for (RequestGroupActionComponent item : this.action) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RequestGroupActionComponent addAction() {
        RequestGroupActionComponent t = new RequestGroupActionComponent();
        if (this.action == null) {
            this.action = new ArrayList<RequestGroupActionComponent>();
        }
        this.action.add(t);
        return t;
    }

    public RequestGroup addAction(RequestGroupActionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.action == null) {
            this.action = new ArrayList<RequestGroupActionComponent>();
        }
        this.action.add(t);
        return this;
    }

    public RequestGroupActionComponent getActionFirstRep() {
        if (this.getAction().isEmpty()) {
            this.addAction();
        }
        return this.getAction().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Allows a service to provide a unique, business identifier for the request.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_DEFINITION, "Reference(Any)", "A protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.", 0, Integer.MAX_VALUE, this.definition));
        children.add(new Property("basedOn", "Reference(Any)", "A plan, proposal or order that is fulfilled in whole or in part by this request.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("replaces", "Reference(Any)", "Completed or terminated request(s) whose function is taken by this new request.", 0, Integer.MAX_VALUE, this.replaces));
        children.add(new Property("groupIdentifier", "Identifier", "A shared identifier common to all requests that were authorized more or less simultaneously by a single author, representing the identifier of the requisition, prescription or similar form.", 0, 1, this.groupIdentifier));
        children.add(new Property(SP_STATUS, "code", "The current state of the request. For request groups, the status reflects the status of all the requests in the group.", 0, 1, this.status));
        children.add(new Property(SP_INTENT, "code", "Indicates the level of authority/intentionality associated with the request and where the request fits into the workflow chain.", 0, 1, this.intent));
        children.add(new Property(SP_PRIORITY, "code", "Indicates how quickly the request should be addressed with respect to other requests.", 0, 1, this.priority));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The subject for which the request group was created.", 0, 1, this.subject));
        children.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "Describes the context of the request group, if any.", 0, 1, this.context));
        children.add(new Property("authoredOn", "dateTime", "Indicates when the request group was created.", 0, 1, this.authoredOn));
        children.add(new Property(SP_AUTHOR, "Reference(Device|Practitioner)", "Provides a reference to the author of the request group.", 0, 1, this.author));
        children.add(new Property("reason[x]", "CodeableConcept|Reference(Any)", "Indicates the reason the request group was created. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.", 0, 1, this.reason));
        children.add(new Property("note", "Annotation", "Provides a mechanism to communicate additional information about the response.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("action", "", "The actions, if any, produced by the evaluation of the artifact.", 0, Integer.MAX_VALUE, this.action));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Allows a service to provide a unique, business identifier for the request.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1014418093: {
                return new Property(SP_DEFINITION, "Reference(Any)", "A protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.", 0, Integer.MAX_VALUE, this.definition);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(Any)", "A plan, proposal or order that is fulfilled in whole or in part by this request.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -430332865: {
                return new Property("replaces", "Reference(Any)", "Completed or terminated request(s) whose function is taken by this new request.", 0, Integer.MAX_VALUE, this.replaces);
            }
            case -445338488: {
                return new Property("groupIdentifier", "Identifier", "A shared identifier common to all requests that were authorized more or less simultaneously by a single author, representing the identifier of the requisition, prescription or similar form.", 0, 1, this.groupIdentifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the request. For request groups, the status reflects the status of all the requests in the group.", 0, 1, this.status);
            }
            case -1183762788: {
                return new Property(SP_INTENT, "code", "Indicates the level of authority/intentionality associated with the request and where the request fits into the workflow chain.", 0, 1, this.intent);
            }
            case -1165461084: {
                return new Property(SP_PRIORITY, "code", "Indicates how quickly the request should be addressed with respect to other requests.", 0, 1, this.priority);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The subject for which the request group was created.", 0, 1, this.subject);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "Describes the context of the request group, if any.", 0, 1, this.context);
            }
            case -1500852503: {
                return new Property("authoredOn", "dateTime", "Indicates when the request group was created.", 0, 1, this.authoredOn);
            }
            case -1406328437: {
                return new Property(SP_AUTHOR, "Reference(Device|Practitioner)", "Provides a reference to the author of the request group.", 0, 1, this.author);
            }
            case -669418564: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "Indicates the reason the request group was created. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.", 0, 1, this.reason);
            }
            case -934964668: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "Indicates the reason the request group was created. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.", 0, 1, this.reason);
            }
            case -610155331: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "Indicates the reason the request group was created. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.", 0, 1, this.reason);
            }
            case -1146218137: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "Indicates the reason the request group was created. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.", 0, 1, this.reason);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Provides a mechanism to communicate additional information about the response.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1422950858: {
                return new Property("action", "", "The actions, if any, produced by the evaluation of the artifact.", 0, Integer.MAX_VALUE, this.action);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1014418093: {
                return this.definition == null ? new Base[]{} : this.definition.toArray(new Base[this.definition.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -430332865: {
                return this.replaces == null ? new Base[]{} : this.replaces.toArray(new Base[this.replaces.size()]);
            }
            case -445338488: {
                Base[] baseArray;
                if (this.groupIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.groupIdentifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.intent;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.priority;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.context;
                }
                return baseArray;
            }
            case -1500852503: {
                Base[] baseArray;
                if (this.authoredOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.authoredOn;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.author;
                }
                return baseArray;
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.reason;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1422950858: {
                return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1014418093: {
                this.getDefinition().add(this.castToReference(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case -430332865: {
                this.getReplaces().add(this.castToReference(value));
                return value;
            }
            case -445338488: {
                this.groupIdentifier = this.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new RequestStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -1183762788: {
                value = new RequestIntentEnumFactory().fromType(this.castToCode(value));
                this.intent = value;
                return value;
            }
            case -1165461084: {
                value = new RequestPriorityEnumFactory().fromType(this.castToCode(value));
                this.priority = value;
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case -1500852503: {
                this.authoredOn = this.castToDateTime(value);
                return value;
            }
            case -1406328437: {
                this.author = this.castToReference(value);
                return value;
            }
            case -934964668: {
                this.reason = this.castToType(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case -1422950858: {
                this.getAction().add((RequestGroupActionComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_DEFINITION)) {
            this.getDefinition().add(this.castToReference(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals("replaces")) {
            this.getReplaces().add(this.castToReference(value));
        } else if (name.equals("groupIdentifier")) {
            this.groupIdentifier = this.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new RequestStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_INTENT)) {
            value = new RequestIntentEnumFactory().fromType(this.castToCode(value));
            this.intent = value;
        } else if (name.equals(SP_PRIORITY)) {
            value = new RequestPriorityEnumFactory().fromType(this.castToCode(value));
            this.priority = value;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals("authoredOn")) {
            this.authoredOn = this.castToDateTime(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = this.castToReference(value);
        } else if (name.equals("reason[x]")) {
            this.reason = this.castToType(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("action")) {
            this.getAction().add((RequestGroupActionComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1014418093: {
                return this.addDefinition();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -430332865: {
                return this.addReplaces();
            }
            case -445338488: {
                return this.getGroupIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1183762788: {
                return this.getIntentElement();
            }
            case -1165461084: {
                return this.getPriorityElement();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case -1500852503: {
                return this.getAuthoredOnElement();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case -669418564: {
                return this.getReason();
            }
            case -934964668: {
                return this.getReason();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1422950858: {
                return this.addAction();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1014418093: {
                return new String[]{"Reference"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -430332865: {
                return new String[]{"Reference"};
            }
            case -445338488: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1183762788: {
                return new String[]{"code"};
            }
            case -1165461084: {
                return new String[]{"code"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case -1500852503: {
                return new String[]{"dateTime"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1422950858: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_DEFINITION)) {
            return this.addDefinition();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("replaces")) {
            return this.addReplaces();
        }
        if (name.equals("groupIdentifier")) {
            this.groupIdentifier = new Identifier();
            return this.groupIdentifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.status");
        }
        if (name.equals(SP_INTENT)) {
            throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.intent");
        }
        if (name.equals(SP_PRIORITY)) {
            throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.priority");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("authoredOn")) {
            throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.authoredOn");
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals("reasonCodeableConcept")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("reasonReference")) {
            this.reason = new Reference();
            return this.reason;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("action")) {
            return this.addAction();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "RequestGroup";
    }

    @Override
    public RequestGroup copy() {
        RequestGroup dst = new RequestGroup();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.definition != null) {
            dst.definition = new ArrayList<Reference>();
            for (Reference reference : this.definition) {
                dst.definition.add(reference.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.replaces != null) {
            dst.replaces = new ArrayList<Reference>();
            for (Reference reference : this.replaces) {
                dst.replaces.add(reference.copy());
            }
        }
        dst.groupIdentifier = this.groupIdentifier == null ? null : this.groupIdentifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.intent = this.intent == null ? null : this.intent.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.context = this.context == null ? null : this.context.copy();
        dst.authoredOn = this.authoredOn == null ? null : this.authoredOn.copy();
        dst.author = this.author == null ? null : this.author.copy();
        Type type = dst.reason = this.reason == null ? null : this.reason.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.action != null) {
            dst.action = new ArrayList<RequestGroupActionComponent>();
            for (RequestGroupActionComponent requestGroupActionComponent : this.action) {
                dst.action.add(requestGroupActionComponent.copy());
            }
        }
        return dst;
    }

    protected RequestGroup typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof RequestGroup)) {
            return false;
        }
        RequestGroup o = (RequestGroup)other_;
        return RequestGroup.compareDeep(this.identifier, o.identifier, true) && RequestGroup.compareDeep(this.definition, o.definition, true) && RequestGroup.compareDeep(this.basedOn, o.basedOn, true) && RequestGroup.compareDeep(this.replaces, o.replaces, true) && RequestGroup.compareDeep(this.groupIdentifier, o.groupIdentifier, true) && RequestGroup.compareDeep(this.status, o.status, true) && RequestGroup.compareDeep(this.intent, o.intent, true) && RequestGroup.compareDeep(this.priority, o.priority, true) && RequestGroup.compareDeep(this.subject, o.subject, true) && RequestGroup.compareDeep(this.context, o.context, true) && RequestGroup.compareDeep(this.authoredOn, o.authoredOn, true) && RequestGroup.compareDeep(this.author, o.author, true) && RequestGroup.compareDeep(this.reason, o.reason, true) && RequestGroup.compareDeep(this.note, o.note, true) && RequestGroup.compareDeep(this.action, o.action, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof RequestGroup)) {
            return false;
        }
        RequestGroup o = (RequestGroup)other_;
        return RequestGroup.compareValues(this.status, o.status, true) && RequestGroup.compareValues(this.intent, o.intent, true) && RequestGroup.compareValues(this.priority, o.priority, true) && RequestGroup.compareValues(this.authoredOn, o.authoredOn, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.definition, this.basedOn, this.replaces, this.groupIdentifier, this.status, this.intent, this.priority, this.subject, this.context, this.authoredOn, this.author, this.reason, this.note, this.action);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.RequestGroup;
    }

    @Block
    public static class RequestGroupActionRelatedActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="actionId", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What action this is related to", formalDefinition="The element id of the action this is related to.")
        protected IdType actionId;
        @Child(name="relationship", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="before-start | before | before-end | concurrent-with-start | concurrent | concurrent-with-end | after-start | after | after-end", formalDefinition="The relationship of this action to the related action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-relationship-type")
        protected Enumeration<ActionRelationshipType> relationship;
        @Child(name="offset", type={Duration.class, Range.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time offset for the relationship", formalDefinition="A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.")
        protected Type offset;
        private static final long serialVersionUID = 1063306770L;

        public RequestGroupActionRelatedActionComponent() {
        }

        public RequestGroupActionRelatedActionComponent(IdType actionId, Enumeration<ActionRelationshipType> relationship) {
            this.actionId = actionId;
            this.relationship = relationship;
        }

        public IdType getActionIdElement() {
            if (this.actionId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionRelatedActionComponent.actionId");
                }
                if (Configuration.doAutoCreate()) {
                    this.actionId = new IdType();
                }
            }
            return this.actionId;
        }

        public boolean hasActionIdElement() {
            return this.actionId != null && !this.actionId.isEmpty();
        }

        public boolean hasActionId() {
            return this.actionId != null && !this.actionId.isEmpty();
        }

        public RequestGroupActionRelatedActionComponent setActionIdElement(IdType value) {
            this.actionId = value;
            return this;
        }

        public String getActionId() {
            return this.actionId == null ? null : this.actionId.getValue();
        }

        public RequestGroupActionRelatedActionComponent setActionId(String value) {
            if (this.actionId == null) {
                this.actionId = new IdType();
            }
            this.actionId.setValue(value);
            return this;
        }

        public Enumeration<ActionRelationshipType> getRelationshipElement() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionRelatedActionComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new Enumeration<ActionRelationshipType>(new ActionRelationshipTypeEnumFactory());
                }
            }
            return this.relationship;
        }

        public boolean hasRelationshipElement() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public RequestGroupActionRelatedActionComponent setRelationshipElement(Enumeration<ActionRelationshipType> value) {
            this.relationship = value;
            return this;
        }

        public ActionRelationshipType getRelationship() {
            return this.relationship == null ? null : (ActionRelationshipType)((Object)this.relationship.getValue());
        }

        public RequestGroupActionRelatedActionComponent setRelationship(ActionRelationshipType value) {
            if (this.relationship == null) {
                this.relationship = new Enumeration<ActionRelationshipType>(new ActionRelationshipTypeEnumFactory());
            }
            this.relationship.setValue((Object)value);
            return this;
        }

        public Type getOffset() {
            return this.offset;
        }

        public Duration getOffsetDuration() throws FHIRException {
            if (this.offset == null) {
                return null;
            }
            if (!(this.offset instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.offset.getClass().getName() + " was encountered");
            }
            return (Duration)this.offset;
        }

        public boolean hasOffsetDuration() {
            return this != null && this.offset instanceof Duration;
        }

        public Range getOffsetRange() throws FHIRException {
            if (this.offset == null) {
                return null;
            }
            if (!(this.offset instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.offset.getClass().getName() + " was encountered");
            }
            return (Range)this.offset;
        }

        public boolean hasOffsetRange() {
            return this != null && this.offset instanceof Range;
        }

        public boolean hasOffset() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public RequestGroupActionRelatedActionComponent setOffset(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof Duration) && !(value instanceof Range)) {
                throw new FHIRFormatError("Not the right type for RequestGroup.action.relatedAction.offset[x]: " + value.fhirType());
            }
            this.offset = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("actionId", "id", "The element id of the action this is related to.", 0, 1, this.actionId));
            children.add(new Property("relationship", "code", "The relationship of this action to the related action.", 0, 1, this.relationship));
            children.add(new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1656172047: {
                    return new Property("actionId", "id", "The element id of the action this is related to.", 0, 1, this.actionId);
                }
                case -261851592: {
                    return new Property("relationship", "code", "The relationship of this action to the related action.", 0, 1, this.relationship);
                }
                case -1960684787: {
                    return new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
                case -1019779949: {
                    return new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
                case 134075207: {
                    return new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
                case 1263585386: {
                    return new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1656172047: {
                    Base[] baseArray;
                    if (this.actionId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.actionId;
                    }
                    return baseArray;
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.relationship;
                    }
                    return baseArray;
                }
                case -1019779949: {
                    Base[] baseArray;
                    if (this.offset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.offset;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1656172047: {
                    this.actionId = this.castToId(value);
                    return value;
                }
                case -261851592: {
                    value = new ActionRelationshipTypeEnumFactory().fromType(this.castToCode(value));
                    this.relationship = value;
                    return value;
                }
                case -1019779949: {
                    this.offset = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("actionId")) {
                this.actionId = this.castToId(value);
            } else if (name.equals("relationship")) {
                value = new ActionRelationshipTypeEnumFactory().fromType(this.castToCode(value));
                this.relationship = value;
            } else if (name.equals("offset[x]")) {
                this.offset = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1656172047: {
                    return this.getActionIdElement();
                }
                case -261851592: {
                    return this.getRelationshipElement();
                }
                case -1960684787: {
                    return this.getOffset();
                }
                case -1019779949: {
                    return this.getOffset();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1656172047: {
                    return new String[]{"id"};
                }
                case -261851592: {
                    return new String[]{"code"};
                }
                case -1019779949: {
                    return new String[]{"Duration", "Range"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("actionId")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.actionId");
            }
            if (name.equals("relationship")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.relationship");
            }
            if (name.equals("offsetDuration")) {
                this.offset = new Duration();
                return this.offset;
            }
            if (name.equals("offsetRange")) {
                this.offset = new Range();
                return this.offset;
            }
            return super.addChild(name);
        }

        @Override
        public RequestGroupActionRelatedActionComponent copy() {
            RequestGroupActionRelatedActionComponent dst = new RequestGroupActionRelatedActionComponent();
            this.copyValues(dst);
            dst.actionId = this.actionId == null ? null : this.actionId.copy();
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            dst.offset = this.offset == null ? null : this.offset.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestGroupActionRelatedActionComponent)) {
                return false;
            }
            RequestGroupActionRelatedActionComponent o = (RequestGroupActionRelatedActionComponent)other_;
            return RequestGroupActionRelatedActionComponent.compareDeep(this.actionId, o.actionId, true) && RequestGroupActionRelatedActionComponent.compareDeep(this.relationship, o.relationship, true) && RequestGroupActionRelatedActionComponent.compareDeep(this.offset, o.offset, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestGroupActionRelatedActionComponent)) {
                return false;
            }
            RequestGroupActionRelatedActionComponent o = (RequestGroupActionRelatedActionComponent)other_;
            return RequestGroupActionRelatedActionComponent.compareValues(this.actionId, o.actionId, true) && RequestGroupActionRelatedActionComponent.compareValues(this.relationship, o.relationship, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.actionId, this.relationship, this.offset);
        }

        @Override
        public String fhirType() {
            return "RequestGroup.action.relatedAction";
        }
    }

    @Block
    public static class RequestGroupActionConditionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="kind", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="applicability | start | stop", formalDefinition="The kind of condition.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-condition-kind")
        protected Enumeration<ActionConditionKind> kind;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Natural language description of the condition", formalDefinition="A brief, natural language description of the condition that effectively communicates the intended semantics.")
        protected StringType description;
        @Child(name="language", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Language of the expression", formalDefinition="The media type of the language for the expression.")
        protected StringType language;
        @Child(name="expression", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Boolean-valued expression", formalDefinition="An expression that returns true or false, indicating whether or not the condition is satisfied.")
        protected StringType expression;
        private static final long serialVersionUID = 944300105L;

        public RequestGroupActionConditionComponent() {
        }

        public RequestGroupActionConditionComponent(Enumeration<ActionConditionKind> kind) {
            this.kind = kind;
        }

        public Enumeration<ActionConditionKind> getKindElement() {
            if (this.kind == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionConditionComponent.kind");
                }
                if (Configuration.doAutoCreate()) {
                    this.kind = new Enumeration<ActionConditionKind>(new ActionConditionKindEnumFactory());
                }
            }
            return this.kind;
        }

        public boolean hasKindElement() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public boolean hasKind() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public RequestGroupActionConditionComponent setKindElement(Enumeration<ActionConditionKind> value) {
            this.kind = value;
            return this;
        }

        public ActionConditionKind getKind() {
            return this.kind == null ? null : (ActionConditionKind)((Object)this.kind.getValue());
        }

        public RequestGroupActionConditionComponent setKind(ActionConditionKind value) {
            if (this.kind == null) {
                this.kind = new Enumeration<ActionConditionKind>(new ActionConditionKindEnumFactory());
            }
            this.kind.setValue((Object)value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionConditionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public RequestGroupActionConditionComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public RequestGroupActionConditionComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionConditionComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new StringType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public RequestGroupActionConditionComponent setLanguageElement(StringType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public RequestGroupActionConditionComponent setLanguage(String value) {
            if (Utilities.noString(value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new StringType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public StringType getExpressionElement() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionConditionComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new StringType();
                }
            }
            return this.expression;
        }

        public boolean hasExpressionElement() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public RequestGroupActionConditionComponent setExpressionElement(StringType value) {
            this.expression = value;
            return this;
        }

        public String getExpression() {
            return this.expression == null ? null : (String)this.expression.getValue();
        }

        public RequestGroupActionConditionComponent setExpression(String value) {
            if (Utilities.noString(value)) {
                this.expression = null;
            } else {
                if (this.expression == null) {
                    this.expression = new StringType();
                }
                this.expression.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("kind", "code", "The kind of condition.", 0, 1, this.kind));
            children.add(new Property("description", "string", "A brief, natural language description of the condition that effectively communicates the intended semantics.", 0, 1, this.description));
            children.add(new Property("language", "string", "The media type of the language for the expression.", 0, 1, this.language));
            children.add(new Property("expression", "string", "An expression that returns true or false, indicating whether or not the condition is satisfied.", 0, 1, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3292052: {
                    return new Property("kind", "code", "The kind of condition.", 0, 1, this.kind);
                }
                case -1724546052: {
                    return new Property("description", "string", "A brief, natural language description of the condition that effectively communicates the intended semantics.", 0, 1, this.description);
                }
                case -1613589672: {
                    return new Property("language", "string", "The media type of the language for the expression.", 0, 1, this.language);
                }
                case -1795452264: {
                    return new Property("expression", "string", "An expression that returns true or false, indicating whether or not the condition is satisfied.", 0, 1, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    Base[] baseArray;
                    if (this.kind == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.kind;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.language;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    value = new ActionConditionKindEnumFactory().fromType(this.castToCode(value));
                    this.kind = value;
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -1613589672: {
                    this.language = this.castToString(value);
                    return value;
                }
                case -1795452264: {
                    this.expression = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("kind")) {
                value = new ActionConditionKindEnumFactory().fromType(this.castToCode(value));
                this.kind = value;
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("language")) {
                this.language = this.castToString(value);
            } else if (name.equals("expression")) {
                this.expression = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    return this.getKindElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1613589672: {
                    return this.getLanguageElement();
                }
                case -1795452264: {
                    return this.getExpressionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    return new String[]{"code"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1613589672: {
                    return new String[]{"string"};
                }
                case -1795452264: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("kind")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.kind");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.description");
            }
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.language");
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.expression");
            }
            return super.addChild(name);
        }

        @Override
        public RequestGroupActionConditionComponent copy() {
            RequestGroupActionConditionComponent dst = new RequestGroupActionConditionComponent();
            this.copyValues(dst);
            dst.kind = this.kind == null ? null : this.kind.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.language = this.language == null ? null : this.language.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestGroupActionConditionComponent)) {
                return false;
            }
            RequestGroupActionConditionComponent o = (RequestGroupActionConditionComponent)other_;
            return RequestGroupActionConditionComponent.compareDeep(this.kind, o.kind, true) && RequestGroupActionConditionComponent.compareDeep(this.description, o.description, true) && RequestGroupActionConditionComponent.compareDeep(this.language, o.language, true) && RequestGroupActionConditionComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestGroupActionConditionComponent)) {
                return false;
            }
            RequestGroupActionConditionComponent o = (RequestGroupActionConditionComponent)other_;
            return RequestGroupActionConditionComponent.compareValues(this.kind, o.kind, true) && RequestGroupActionConditionComponent.compareValues(this.description, o.description, true) && RequestGroupActionConditionComponent.compareValues(this.language, o.language, true) && RequestGroupActionConditionComponent.compareValues(this.expression, o.expression, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.kind, this.description, this.language, this.expression);
        }

        @Override
        public String fhirType() {
            return "RequestGroup.action.condition";
        }
    }

    @Block
    public static class RequestGroupActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="label", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible label for the action (e.g. 1. or A.)", formalDefinition="A user-visible label for the action.")
        protected StringType label;
        @Child(name="title", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible title", formalDefinition="The title of the action displayed to a user.")
        protected StringType title;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Short description of the action", formalDefinition="A short description of the action used to provide a summary to display to the user.")
        protected StringType description;
        @Child(name="textEquivalent", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Static text equivalent of the action, used if the dynamic aspects cannot be interpreted by the receiving system", formalDefinition="A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that may not be capable of interpreting it dynamically.")
        protected StringType textEquivalent;
        @Child(name="code", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Code representing the meaning of the action or sub-actions", formalDefinition="A code that provides meaning for the action or action group. For example, a section may have a LOINC code for a the section of a documentation template.")
        protected List<CodeableConcept> code;
        @Child(name="documentation", type={RelatedArtifact.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Supporting documentation for the intended performer of the action", formalDefinition="Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.")
        protected List<RelatedArtifact> documentation;
        @Child(name="condition", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Whether or not the action is applicable", formalDefinition="An expression that describes applicability criteria, or start/stop conditions for the action.")
        protected List<RequestGroupActionConditionComponent> condition;
        @Child(name="relatedAction", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Relationship to another action", formalDefinition="A relationship to another action such as \"before\" or \"30-60 minutes after start of\".")
        protected List<RequestGroupActionRelatedActionComponent> relatedAction;
        @Child(name="timing", type={DateTimeType.class, Period.class, Duration.class, Range.class, Timing.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the action should take place", formalDefinition="An optional value describing when the action should be performed.")
        protected Type timing;
        @Child(name="participant", type={Patient.class, Person.class, Practitioner.class, RelatedPerson.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who should perform the action", formalDefinition="The participant that should perform or be responsible for this action.")
        protected List<Reference> participant;
        protected List<Resource> participantTarget;
        @Child(name="type", type={Coding.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="create | update | remove | fire-event", formalDefinition="The type of action to perform (create, update, remove).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-type")
        protected Coding type;
        @Child(name="groupingBehavior", type={CodeType.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="visual-group | logical-group | sentence-group", formalDefinition="Defines the grouping behavior for the action and its children.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-grouping-behavior")
        protected Enumeration<ActionGroupingBehavior> groupingBehavior;
        @Child(name="selectionBehavior", type={CodeType.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="any | all | all-or-none | exactly-one | at-most-one | one-or-more", formalDefinition="Defines the selection behavior for the action and its children.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-selection-behavior")
        protected Enumeration<ActionSelectionBehavior> selectionBehavior;
        @Child(name="requiredBehavior", type={CodeType.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="must | could | must-unless-documented", formalDefinition="Defines the requiredness behavior for the action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-required-behavior")
        protected Enumeration<ActionRequiredBehavior> requiredBehavior;
        @Child(name="precheckBehavior", type={CodeType.class}, order=15, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="yes | no", formalDefinition="Defines whether the action should usually be preselected.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-precheck-behavior")
        protected Enumeration<ActionPrecheckBehavior> precheckBehavior;
        @Child(name="cardinalityBehavior", type={CodeType.class}, order=16, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="single | multiple", formalDefinition="Defines whether the action can be selected multiple times.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-cardinality-behavior")
        protected Enumeration<ActionCardinalityBehavior> cardinalityBehavior;
        @Child(name="resource", type={Reference.class}, order=17, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The target of the action", formalDefinition="The resource that is the target of the action (e.g. CommunicationRequest).")
        protected Reference resource;
        protected Resource resourceTarget;
        @Child(name="action", type={RequestGroupActionComponent.class}, order=18, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Sub action", formalDefinition="Sub actions.")
        protected List<RequestGroupActionComponent> action;
        private static final long serialVersionUID = 362859874L;

        public StringType getLabelElement() {
            if (this.label == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.label");
                }
                if (Configuration.doAutoCreate()) {
                    this.label = new StringType();
                }
            }
            return this.label;
        }

        public boolean hasLabelElement() {
            return this.label != null && !this.label.isEmpty();
        }

        public boolean hasLabel() {
            return this.label != null && !this.label.isEmpty();
        }

        public RequestGroupActionComponent setLabelElement(StringType value) {
            this.label = value;
            return this;
        }

        public String getLabel() {
            return this.label == null ? null : (String)this.label.getValue();
        }

        public RequestGroupActionComponent setLabel(String value) {
            if (Utilities.noString(value)) {
                this.label = null;
            } else {
                if (this.label == null) {
                    this.label = new StringType();
                }
                this.label.setValue(value);
            }
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public RequestGroupActionComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public RequestGroupActionComponent setTitle(String value) {
            if (Utilities.noString(value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public RequestGroupActionComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public RequestGroupActionComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getTextEquivalentElement() {
            if (this.textEquivalent == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.textEquivalent");
                }
                if (Configuration.doAutoCreate()) {
                    this.textEquivalent = new StringType();
                }
            }
            return this.textEquivalent;
        }

        public boolean hasTextEquivalentElement() {
            return this.textEquivalent != null && !this.textEquivalent.isEmpty();
        }

        public boolean hasTextEquivalent() {
            return this.textEquivalent != null && !this.textEquivalent.isEmpty();
        }

        public RequestGroupActionComponent setTextEquivalentElement(StringType value) {
            this.textEquivalent = value;
            return this;
        }

        public String getTextEquivalent() {
            return this.textEquivalent == null ? null : (String)this.textEquivalent.getValue();
        }

        public RequestGroupActionComponent setTextEquivalent(String value) {
            if (Utilities.noString(value)) {
                this.textEquivalent = null;
            } else {
                if (this.textEquivalent == null) {
                    this.textEquivalent = new StringType();
                }
                this.textEquivalent.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            return this.code;
        }

        public RequestGroupActionComponent setCode(List<CodeableConcept> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (CodeableConcept item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return t;
        }

        public RequestGroupActionComponent addCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return this;
        }

        public CodeableConcept getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public List<RelatedArtifact> getDocumentation() {
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            return this.documentation;
        }

        public RequestGroupActionComponent setDocumentation(List<RelatedArtifact> theDocumentation) {
            this.documentation = theDocumentation;
            return this;
        }

        public boolean hasDocumentation() {
            if (this.documentation == null) {
                return false;
            }
            for (RelatedArtifact item : this.documentation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RelatedArtifact addDocumentation() {
            RelatedArtifact t = new RelatedArtifact();
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            this.documentation.add(t);
            return t;
        }

        public RequestGroupActionComponent addDocumentation(RelatedArtifact t) {
            if (t == null) {
                return this;
            }
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            this.documentation.add(t);
            return this;
        }

        public RelatedArtifact getDocumentationFirstRep() {
            if (this.getDocumentation().isEmpty()) {
                this.addDocumentation();
            }
            return this.getDocumentation().get(0);
        }

        public List<RequestGroupActionConditionComponent> getCondition() {
            if (this.condition == null) {
                this.condition = new ArrayList<RequestGroupActionConditionComponent>();
            }
            return this.condition;
        }

        public RequestGroupActionComponent setCondition(List<RequestGroupActionConditionComponent> theCondition) {
            this.condition = theCondition;
            return this;
        }

        public boolean hasCondition() {
            if (this.condition == null) {
                return false;
            }
            for (RequestGroupActionConditionComponent item : this.condition) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RequestGroupActionConditionComponent addCondition() {
            RequestGroupActionConditionComponent t = new RequestGroupActionConditionComponent();
            if (this.condition == null) {
                this.condition = new ArrayList<RequestGroupActionConditionComponent>();
            }
            this.condition.add(t);
            return t;
        }

        public RequestGroupActionComponent addCondition(RequestGroupActionConditionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.condition == null) {
                this.condition = new ArrayList<RequestGroupActionConditionComponent>();
            }
            this.condition.add(t);
            return this;
        }

        public RequestGroupActionConditionComponent getConditionFirstRep() {
            if (this.getCondition().isEmpty()) {
                this.addCondition();
            }
            return this.getCondition().get(0);
        }

        public List<RequestGroupActionRelatedActionComponent> getRelatedAction() {
            if (this.relatedAction == null) {
                this.relatedAction = new ArrayList<RequestGroupActionRelatedActionComponent>();
            }
            return this.relatedAction;
        }

        public RequestGroupActionComponent setRelatedAction(List<RequestGroupActionRelatedActionComponent> theRelatedAction) {
            this.relatedAction = theRelatedAction;
            return this;
        }

        public boolean hasRelatedAction() {
            if (this.relatedAction == null) {
                return false;
            }
            for (RequestGroupActionRelatedActionComponent item : this.relatedAction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RequestGroupActionRelatedActionComponent addRelatedAction() {
            RequestGroupActionRelatedActionComponent t = new RequestGroupActionRelatedActionComponent();
            if (this.relatedAction == null) {
                this.relatedAction = new ArrayList<RequestGroupActionRelatedActionComponent>();
            }
            this.relatedAction.add(t);
            return t;
        }

        public RequestGroupActionComponent addRelatedAction(RequestGroupActionRelatedActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.relatedAction == null) {
                this.relatedAction = new ArrayList<RequestGroupActionRelatedActionComponent>();
            }
            this.relatedAction.add(t);
            return this;
        }

        public RequestGroupActionRelatedActionComponent getRelatedActionFirstRep() {
            if (this.getRelatedAction().isEmpty()) {
                this.addRelatedAction();
            }
            return this.getRelatedAction().get(0);
        }

        public Type getTiming() {
            return this.timing;
        }

        public DateTimeType getTimingDateTimeType() throws FHIRException {
            if (this.timing == null) {
                return null;
            }
            if (!(this.timing instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.timing;
        }

        public boolean hasTimingDateTimeType() {
            return this != null && this.timing instanceof DateTimeType;
        }

        public Period getTimingPeriod() throws FHIRException {
            if (this.timing == null) {
                return null;
            }
            if (!(this.timing instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Period)this.timing;
        }

        public boolean hasTimingPeriod() {
            return this != null && this.timing instanceof Period;
        }

        public Duration getTimingDuration() throws FHIRException {
            if (this.timing == null) {
                return null;
            }
            if (!(this.timing instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Duration)this.timing;
        }

        public boolean hasTimingDuration() {
            return this != null && this.timing instanceof Duration;
        }

        public Range getTimingRange() throws FHIRException {
            if (this.timing == null) {
                return null;
            }
            if (!(this.timing instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Range)this.timing;
        }

        public boolean hasTimingRange() {
            return this != null && this.timing instanceof Range;
        }

        public Timing getTimingTiming() throws FHIRException {
            if (this.timing == null) {
                return null;
            }
            if (!(this.timing instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Timing)this.timing;
        }

        public boolean hasTimingTiming() {
            return this != null && this.timing instanceof Timing;
        }

        public boolean hasTiming() {
            return this.timing != null && !this.timing.isEmpty();
        }

        public RequestGroupActionComponent setTiming(Type value) throws FHIRFormatError {
            if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Duration || value instanceof Range || value instanceof Timing)) {
                throw new FHIRFormatError("Not the right type for RequestGroup.action.timing[x]: " + value.fhirType());
            }
            this.timing = value;
            return this;
        }

        public List<Reference> getParticipant() {
            if (this.participant == null) {
                this.participant = new ArrayList<Reference>();
            }
            return this.participant;
        }

        public RequestGroupActionComponent setParticipant(List<Reference> theParticipant) {
            this.participant = theParticipant;
            return this;
        }

        public boolean hasParticipant() {
            if (this.participant == null) {
                return false;
            }
            for (Reference item : this.participant) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addParticipant() {
            Reference t = new Reference();
            if (this.participant == null) {
                this.participant = new ArrayList<Reference>();
            }
            this.participant.add(t);
            return t;
        }

        public RequestGroupActionComponent addParticipant(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.participant == null) {
                this.participant = new ArrayList<Reference>();
            }
            this.participant.add(t);
            return this;
        }

        public Reference getParticipantFirstRep() {
            if (this.getParticipant().isEmpty()) {
                this.addParticipant();
            }
            return this.getParticipant().get(0);
        }

        @Deprecated
        public List<Resource> getParticipantTarget() {
            if (this.participantTarget == null) {
                this.participantTarget = new ArrayList<Resource>();
            }
            return this.participantTarget;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public RequestGroupActionComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Enumeration<ActionGroupingBehavior> getGroupingBehaviorElement() {
            if (this.groupingBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.groupingBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.groupingBehavior = new Enumeration<ActionGroupingBehavior>(new ActionGroupingBehaviorEnumFactory());
                }
            }
            return this.groupingBehavior;
        }

        public boolean hasGroupingBehaviorElement() {
            return this.groupingBehavior != null && !this.groupingBehavior.isEmpty();
        }

        public boolean hasGroupingBehavior() {
            return this.groupingBehavior != null && !this.groupingBehavior.isEmpty();
        }

        public RequestGroupActionComponent setGroupingBehaviorElement(Enumeration<ActionGroupingBehavior> value) {
            this.groupingBehavior = value;
            return this;
        }

        public ActionGroupingBehavior getGroupingBehavior() {
            return this.groupingBehavior == null ? null : (ActionGroupingBehavior)((Object)this.groupingBehavior.getValue());
        }

        public RequestGroupActionComponent setGroupingBehavior(ActionGroupingBehavior value) {
            if (value == null) {
                this.groupingBehavior = null;
            } else {
                if (this.groupingBehavior == null) {
                    this.groupingBehavior = new Enumeration<ActionGroupingBehavior>(new ActionGroupingBehaviorEnumFactory());
                }
                this.groupingBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<ActionSelectionBehavior> getSelectionBehaviorElement() {
            if (this.selectionBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.selectionBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.selectionBehavior = new Enumeration<ActionSelectionBehavior>(new ActionSelectionBehaviorEnumFactory());
                }
            }
            return this.selectionBehavior;
        }

        public boolean hasSelectionBehaviorElement() {
            return this.selectionBehavior != null && !this.selectionBehavior.isEmpty();
        }

        public boolean hasSelectionBehavior() {
            return this.selectionBehavior != null && !this.selectionBehavior.isEmpty();
        }

        public RequestGroupActionComponent setSelectionBehaviorElement(Enumeration<ActionSelectionBehavior> value) {
            this.selectionBehavior = value;
            return this;
        }

        public ActionSelectionBehavior getSelectionBehavior() {
            return this.selectionBehavior == null ? null : (ActionSelectionBehavior)((Object)this.selectionBehavior.getValue());
        }

        public RequestGroupActionComponent setSelectionBehavior(ActionSelectionBehavior value) {
            if (value == null) {
                this.selectionBehavior = null;
            } else {
                if (this.selectionBehavior == null) {
                    this.selectionBehavior = new Enumeration<ActionSelectionBehavior>(new ActionSelectionBehaviorEnumFactory());
                }
                this.selectionBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<ActionRequiredBehavior> getRequiredBehaviorElement() {
            if (this.requiredBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.requiredBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.requiredBehavior = new Enumeration<ActionRequiredBehavior>(new ActionRequiredBehaviorEnumFactory());
                }
            }
            return this.requiredBehavior;
        }

        public boolean hasRequiredBehaviorElement() {
            return this.requiredBehavior != null && !this.requiredBehavior.isEmpty();
        }

        public boolean hasRequiredBehavior() {
            return this.requiredBehavior != null && !this.requiredBehavior.isEmpty();
        }

        public RequestGroupActionComponent setRequiredBehaviorElement(Enumeration<ActionRequiredBehavior> value) {
            this.requiredBehavior = value;
            return this;
        }

        public ActionRequiredBehavior getRequiredBehavior() {
            return this.requiredBehavior == null ? null : (ActionRequiredBehavior)((Object)this.requiredBehavior.getValue());
        }

        public RequestGroupActionComponent setRequiredBehavior(ActionRequiredBehavior value) {
            if (value == null) {
                this.requiredBehavior = null;
            } else {
                if (this.requiredBehavior == null) {
                    this.requiredBehavior = new Enumeration<ActionRequiredBehavior>(new ActionRequiredBehaviorEnumFactory());
                }
                this.requiredBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<ActionPrecheckBehavior> getPrecheckBehaviorElement() {
            if (this.precheckBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.precheckBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.precheckBehavior = new Enumeration<ActionPrecheckBehavior>(new ActionPrecheckBehaviorEnumFactory());
                }
            }
            return this.precheckBehavior;
        }

        public boolean hasPrecheckBehaviorElement() {
            return this.precheckBehavior != null && !this.precheckBehavior.isEmpty();
        }

        public boolean hasPrecheckBehavior() {
            return this.precheckBehavior != null && !this.precheckBehavior.isEmpty();
        }

        public RequestGroupActionComponent setPrecheckBehaviorElement(Enumeration<ActionPrecheckBehavior> value) {
            this.precheckBehavior = value;
            return this;
        }

        public ActionPrecheckBehavior getPrecheckBehavior() {
            return this.precheckBehavior == null ? null : (ActionPrecheckBehavior)((Object)this.precheckBehavior.getValue());
        }

        public RequestGroupActionComponent setPrecheckBehavior(ActionPrecheckBehavior value) {
            if (value == null) {
                this.precheckBehavior = null;
            } else {
                if (this.precheckBehavior == null) {
                    this.precheckBehavior = new Enumeration<ActionPrecheckBehavior>(new ActionPrecheckBehaviorEnumFactory());
                }
                this.precheckBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<ActionCardinalityBehavior> getCardinalityBehaviorElement() {
            if (this.cardinalityBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.cardinalityBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.cardinalityBehavior = new Enumeration<ActionCardinalityBehavior>(new ActionCardinalityBehaviorEnumFactory());
                }
            }
            return this.cardinalityBehavior;
        }

        public boolean hasCardinalityBehaviorElement() {
            return this.cardinalityBehavior != null && !this.cardinalityBehavior.isEmpty();
        }

        public boolean hasCardinalityBehavior() {
            return this.cardinalityBehavior != null && !this.cardinalityBehavior.isEmpty();
        }

        public RequestGroupActionComponent setCardinalityBehaviorElement(Enumeration<ActionCardinalityBehavior> value) {
            this.cardinalityBehavior = value;
            return this;
        }

        public ActionCardinalityBehavior getCardinalityBehavior() {
            return this.cardinalityBehavior == null ? null : (ActionCardinalityBehavior)((Object)this.cardinalityBehavior.getValue());
        }

        public RequestGroupActionComponent setCardinalityBehavior(ActionCardinalityBehavior value) {
            if (value == null) {
                this.cardinalityBehavior = null;
            } else {
                if (this.cardinalityBehavior == null) {
                    this.cardinalityBehavior = new Enumeration<ActionCardinalityBehavior>(new ActionCardinalityBehaviorEnumFactory());
                }
                this.cardinalityBehavior.setValue((Object)value);
            }
            return this;
        }

        public Reference getResource() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RequestGroupActionComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new Reference();
                }
            }
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public RequestGroupActionComponent setResource(Reference value) {
            this.resource = value;
            return this;
        }

        public Resource getResourceTarget() {
            return this.resourceTarget;
        }

        public RequestGroupActionComponent setResourceTarget(Resource value) {
            this.resourceTarget = value;
            return this;
        }

        public List<RequestGroupActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<RequestGroupActionComponent>();
            }
            return this.action;
        }

        public RequestGroupActionComponent setAction(List<RequestGroupActionComponent> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (RequestGroupActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RequestGroupActionComponent addAction() {
            RequestGroupActionComponent t = new RequestGroupActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<RequestGroupActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public RequestGroupActionComponent addAction(RequestGroupActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<RequestGroupActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        public RequestGroupActionComponent getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("label", "string", "A user-visible label for the action.", 0, 1, this.label));
            children.add(new Property("title", "string", "The title of the action displayed to a user.", 0, 1, this.title));
            children.add(new Property("description", "string", "A short description of the action used to provide a summary to display to the user.", 0, 1, this.description));
            children.add(new Property("textEquivalent", "string", "A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that may not be capable of interpreting it dynamically.", 0, 1, this.textEquivalent));
            children.add(new Property("code", "CodeableConcept", "A code that provides meaning for the action or action group. For example, a section may have a LOINC code for a the section of a documentation template.", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property("documentation", "RelatedArtifact", "Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation));
            children.add(new Property("condition", "", "An expression that describes applicability criteria, or start/stop conditions for the action.", 0, Integer.MAX_VALUE, this.condition));
            children.add(new Property("relatedAction", "", "A relationship to another action such as \"before\" or \"30-60 minutes after start of\".", 0, Integer.MAX_VALUE, this.relatedAction));
            children.add(new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing));
            children.add(new Property(RequestGroup.SP_PARTICIPANT, "Reference(Patient|Person|Practitioner|RelatedPerson)", "The participant that should perform or be responsible for this action.", 0, Integer.MAX_VALUE, this.participant));
            children.add(new Property("type", "Coding", "The type of action to perform (create, update, remove).", 0, 1, this.type));
            children.add(new Property("groupingBehavior", "code", "Defines the grouping behavior for the action and its children.", 0, 1, this.groupingBehavior));
            children.add(new Property("selectionBehavior", "code", "Defines the selection behavior for the action and its children.", 0, 1, this.selectionBehavior));
            children.add(new Property("requiredBehavior", "code", "Defines the requiredness behavior for the action.", 0, 1, this.requiredBehavior));
            children.add(new Property("precheckBehavior", "code", "Defines whether the action should usually be preselected.", 0, 1, this.precheckBehavior));
            children.add(new Property("cardinalityBehavior", "code", "Defines whether the action can be selected multiple times.", 0, 1, this.cardinalityBehavior));
            children.add(new Property("resource", "Reference(Any)", "The resource that is the target of the action (e.g. CommunicationRequest).", 0, 1, this.resource));
            children.add(new Property("action", "@RequestGroup.action", "Sub actions.", 0, Integer.MAX_VALUE, this.action));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 102727412: {
                    return new Property("label", "string", "A user-visible label for the action.", 0, 1, this.label);
                }
                case 110371416: {
                    return new Property("title", "string", "The title of the action displayed to a user.", 0, 1, this.title);
                }
                case -1724546052: {
                    return new Property("description", "string", "A short description of the action used to provide a summary to display to the user.", 0, 1, this.description);
                }
                case -900391049: {
                    return new Property("textEquivalent", "string", "A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that may not be capable of interpreting it dynamically.", 0, 1, this.textEquivalent);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A code that provides meaning for the action or action group. For example, a section may have a LOINC code for a the section of a documentation template.", 0, Integer.MAX_VALUE, this.code);
                }
                case 1587405498: {
                    return new Property("documentation", "RelatedArtifact", "Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation);
                }
                case -861311717: {
                    return new Property("condition", "", "An expression that describes applicability criteria, or start/stop conditions for the action.", 0, Integer.MAX_VALUE, this.condition);
                }
                case -384107967: {
                    return new Property("relatedAction", "", "A relationship to another action such as \"before\" or \"30-60 minutes after start of\".", 0, Integer.MAX_VALUE, this.relatedAction);
                }
                case 164632566: {
                    return new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -873664438: {
                    return new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -1837458939: {
                    return new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -615615829: {
                    return new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -1327253506: {
                    return new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -710871277: {
                    return new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -497554124: {
                    return new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case 767422259: {
                    return new Property(RequestGroup.SP_PARTICIPANT, "Reference(Patient|Person|Practitioner|RelatedPerson)", "The participant that should perform or be responsible for this action.", 0, Integer.MAX_VALUE, this.participant);
                }
                case 3575610: {
                    return new Property("type", "Coding", "The type of action to perform (create, update, remove).", 0, 1, this.type);
                }
                case 586678389: {
                    return new Property("groupingBehavior", "code", "Defines the grouping behavior for the action and its children.", 0, 1, this.groupingBehavior);
                }
                case 168639486: {
                    return new Property("selectionBehavior", "code", "Defines the selection behavior for the action and its children.", 0, 1, this.selectionBehavior);
                }
                case -1163906287: {
                    return new Property("requiredBehavior", "code", "Defines the requiredness behavior for the action.", 0, 1, this.requiredBehavior);
                }
                case -1174249033: {
                    return new Property("precheckBehavior", "code", "Defines whether the action should usually be preselected.", 0, 1, this.precheckBehavior);
                }
                case -922577408: {
                    return new Property("cardinalityBehavior", "code", "Defines whether the action can be selected multiple times.", 0, 1, this.cardinalityBehavior);
                }
                case -341064690: {
                    return new Property("resource", "Reference(Any)", "The resource that is the target of the action (e.g. CommunicationRequest).", 0, 1, this.resource);
                }
                case -1422950858: {
                    return new Property("action", "@RequestGroup.action", "Sub actions.", 0, Integer.MAX_VALUE, this.action);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    Base[] baseArray;
                    if (this.label == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.label;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case -900391049: {
                    Base[] baseArray;
                    if (this.textEquivalent == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.textEquivalent;
                    }
                    return baseArray;
                }
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case 1587405498: {
                    return this.documentation == null ? new Base[]{} : this.documentation.toArray(new Base[this.documentation.size()]);
                }
                case -861311717: {
                    return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
                }
                case -384107967: {
                    return this.relatedAction == null ? new Base[]{} : this.relatedAction.toArray(new Base[this.relatedAction.size()]);
                }
                case -873664438: {
                    Base[] baseArray;
                    if (this.timing == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.timing;
                    }
                    return baseArray;
                }
                case 767422259: {
                    return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.type;
                    }
                    return baseArray;
                }
                case 586678389: {
                    Base[] baseArray;
                    if (this.groupingBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.groupingBehavior;
                    }
                    return baseArray;
                }
                case 168639486: {
                    Base[] baseArray;
                    if (this.selectionBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.selectionBehavior;
                    }
                    return baseArray;
                }
                case -1163906287: {
                    Base[] baseArray;
                    if (this.requiredBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.requiredBehavior;
                    }
                    return baseArray;
                }
                case -1174249033: {
                    Base[] baseArray;
                    if (this.precheckBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.precheckBehavior;
                    }
                    return baseArray;
                }
                case -922577408: {
                    Base[] baseArray;
                    if (this.cardinalityBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.cardinalityBehavior;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.resource;
                    }
                    return baseArray;
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    this.label = this.castToString(value);
                    return value;
                }
                case 110371416: {
                    this.title = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -900391049: {
                    this.textEquivalent = this.castToString(value);
                    return value;
                }
                case 3059181: {
                    this.getCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1587405498: {
                    this.getDocumentation().add(this.castToRelatedArtifact(value));
                    return value;
                }
                case -861311717: {
                    this.getCondition().add((RequestGroupActionConditionComponent)((Object)value));
                    return value;
                }
                case -384107967: {
                    this.getRelatedAction().add((RequestGroupActionRelatedActionComponent)((Object)value));
                    return value;
                }
                case -873664438: {
                    this.timing = this.castToType(value);
                    return value;
                }
                case 767422259: {
                    this.getParticipant().add(this.castToReference(value));
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCoding(value);
                    return value;
                }
                case 586678389: {
                    value = new ActionGroupingBehaviorEnumFactory().fromType(this.castToCode(value));
                    this.groupingBehavior = value;
                    return value;
                }
                case 168639486: {
                    value = new ActionSelectionBehaviorEnumFactory().fromType(this.castToCode(value));
                    this.selectionBehavior = value;
                    return value;
                }
                case -1163906287: {
                    value = new ActionRequiredBehaviorEnumFactory().fromType(this.castToCode(value));
                    this.requiredBehavior = value;
                    return value;
                }
                case -1174249033: {
                    value = new ActionPrecheckBehaviorEnumFactory().fromType(this.castToCode(value));
                    this.precheckBehavior = value;
                    return value;
                }
                case -922577408: {
                    value = new ActionCardinalityBehaviorEnumFactory().fromType(this.castToCode(value));
                    this.cardinalityBehavior = value;
                    return value;
                }
                case -341064690: {
                    this.resource = this.castToReference(value);
                    return value;
                }
                case -1422950858: {
                    this.getAction().add((RequestGroupActionComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("label")) {
                this.label = this.castToString(value);
            } else if (name.equals("title")) {
                this.title = this.castToString(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("textEquivalent")) {
                this.textEquivalent = this.castToString(value);
            } else if (name.equals("code")) {
                this.getCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("documentation")) {
                this.getDocumentation().add(this.castToRelatedArtifact(value));
            } else if (name.equals("condition")) {
                this.getCondition().add((RequestGroupActionConditionComponent)((Object)value));
            } else if (name.equals("relatedAction")) {
                this.getRelatedAction().add((RequestGroupActionRelatedActionComponent)((Object)value));
            } else if (name.equals("timing[x]")) {
                this.timing = this.castToType(value);
            } else if (name.equals(RequestGroup.SP_PARTICIPANT)) {
                this.getParticipant().add(this.castToReference(value));
            } else if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("groupingBehavior")) {
                value = new ActionGroupingBehaviorEnumFactory().fromType(this.castToCode(value));
                this.groupingBehavior = value;
            } else if (name.equals("selectionBehavior")) {
                value = new ActionSelectionBehaviorEnumFactory().fromType(this.castToCode(value));
                this.selectionBehavior = value;
            } else if (name.equals("requiredBehavior")) {
                value = new ActionRequiredBehaviorEnumFactory().fromType(this.castToCode(value));
                this.requiredBehavior = value;
            } else if (name.equals("precheckBehavior")) {
                value = new ActionPrecheckBehaviorEnumFactory().fromType(this.castToCode(value));
                this.precheckBehavior = value;
            } else if (name.equals("cardinalityBehavior")) {
                value = new ActionCardinalityBehaviorEnumFactory().fromType(this.castToCode(value));
                this.cardinalityBehavior = value;
            } else if (name.equals("resource")) {
                this.resource = this.castToReference(value);
            } else if (name.equals("action")) {
                this.getAction().add((RequestGroupActionComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    return this.getLabelElement();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -900391049: {
                    return this.getTextEquivalentElement();
                }
                case 3059181: {
                    return this.addCode();
                }
                case 1587405498: {
                    return this.addDocumentation();
                }
                case -861311717: {
                    return this.addCondition();
                }
                case -384107967: {
                    return this.addRelatedAction();
                }
                case 164632566: {
                    return this.getTiming();
                }
                case -873664438: {
                    return this.getTiming();
                }
                case 767422259: {
                    return this.addParticipant();
                }
                case 3575610: {
                    return this.getType();
                }
                case 586678389: {
                    return this.getGroupingBehaviorElement();
                }
                case 168639486: {
                    return this.getSelectionBehaviorElement();
                }
                case -1163906287: {
                    return this.getRequiredBehaviorElement();
                }
                case -1174249033: {
                    return this.getPrecheckBehaviorElement();
                }
                case -922577408: {
                    return this.getCardinalityBehaviorElement();
                }
                case -341064690: {
                    return this.getResource();
                }
                case -1422950858: {
                    return this.addAction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    return new String[]{"string"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -900391049: {
                    return new String[]{"string"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 1587405498: {
                    return new String[]{"RelatedArtifact"};
                }
                case -861311717: {
                    return new String[0];
                }
                case -384107967: {
                    return new String[0];
                }
                case -873664438: {
                    return new String[]{"dateTime", "Period", "Duration", "Range", "Timing"};
                }
                case 767422259: {
                    return new String[]{"Reference"};
                }
                case 3575610: {
                    return new String[]{"Coding"};
                }
                case 586678389: {
                    return new String[]{"code"};
                }
                case 168639486: {
                    return new String[]{"code"};
                }
                case -1163906287: {
                    return new String[]{"code"};
                }
                case -1174249033: {
                    return new String[]{"code"};
                }
                case -922577408: {
                    return new String[]{"code"};
                }
                case -341064690: {
                    return new String[]{"Reference"};
                }
                case -1422950858: {
                    return new String[]{"@RequestGroup.action"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("label")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.label");
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.title");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.description");
            }
            if (name.equals("textEquivalent")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.textEquivalent");
            }
            if (name.equals("code")) {
                return this.addCode();
            }
            if (name.equals("documentation")) {
                return this.addDocumentation();
            }
            if (name.equals("condition")) {
                return this.addCondition();
            }
            if (name.equals("relatedAction")) {
                return this.addRelatedAction();
            }
            if (name.equals("timingDateTime")) {
                this.timing = new DateTimeType();
                return this.timing;
            }
            if (name.equals("timingPeriod")) {
                this.timing = new Period();
                return this.timing;
            }
            if (name.equals("timingDuration")) {
                this.timing = new Duration();
                return this.timing;
            }
            if (name.equals("timingRange")) {
                this.timing = new Range();
                return this.timing;
            }
            if (name.equals("timingTiming")) {
                this.timing = new Timing();
                return this.timing;
            }
            if (name.equals(RequestGroup.SP_PARTICIPANT)) {
                return this.addParticipant();
            }
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("groupingBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.groupingBehavior");
            }
            if (name.equals("selectionBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.selectionBehavior");
            }
            if (name.equals("requiredBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.requiredBehavior");
            }
            if (name.equals("precheckBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.precheckBehavior");
            }
            if (name.equals("cardinalityBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type RequestGroup.cardinalityBehavior");
            }
            if (name.equals("resource")) {
                this.resource = new Reference();
                return this.resource;
            }
            if (name.equals("action")) {
                return this.addAction();
            }
            return super.addChild(name);
        }

        @Override
        public RequestGroupActionComponent copy() {
            RequestGroupActionComponent dst = new RequestGroupActionComponent();
            this.copyValues(dst);
            dst.label = this.label == null ? null : this.label.copy();
            dst.title = this.title == null ? null : this.title.copy();
            dst.description = this.description == null ? null : this.description.copy();
            StringType stringType = dst.textEquivalent = this.textEquivalent == null ? null : this.textEquivalent.copy();
            if (this.code != null) {
                dst.code = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.code) {
                    dst.code.add(codeableConcept.copy());
                }
            }
            if (this.documentation != null) {
                dst.documentation = new ArrayList<RelatedArtifact>();
                for (RelatedArtifact relatedArtifact : this.documentation) {
                    dst.documentation.add(relatedArtifact.copy());
                }
            }
            if (this.condition != null) {
                dst.condition = new ArrayList<RequestGroupActionConditionComponent>();
                for (RequestGroupActionConditionComponent requestGroupActionConditionComponent : this.condition) {
                    dst.condition.add(requestGroupActionConditionComponent.copy());
                }
            }
            if (this.relatedAction != null) {
                dst.relatedAction = new ArrayList<RequestGroupActionRelatedActionComponent>();
                for (RequestGroupActionRelatedActionComponent requestGroupActionRelatedActionComponent : this.relatedAction) {
                    dst.relatedAction.add(requestGroupActionRelatedActionComponent.copy());
                }
            }
            Type type = dst.timing = this.timing == null ? null : this.timing.copy();
            if (this.participant != null) {
                dst.participant = new ArrayList<Reference>();
                for (Reference reference : this.participant) {
                    dst.participant.add(reference.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            dst.groupingBehavior = this.groupingBehavior == null ? null : this.groupingBehavior.copy();
            dst.selectionBehavior = this.selectionBehavior == null ? null : this.selectionBehavior.copy();
            dst.requiredBehavior = this.requiredBehavior == null ? null : this.requiredBehavior.copy();
            dst.precheckBehavior = this.precheckBehavior == null ? null : this.precheckBehavior.copy();
            dst.cardinalityBehavior = this.cardinalityBehavior == null ? null : this.cardinalityBehavior.copy();
            Reference reference = dst.resource = this.resource == null ? null : this.resource.copy();
            if (this.action != null) {
                dst.action = new ArrayList<RequestGroupActionComponent>();
                for (RequestGroupActionComponent requestGroupActionComponent : this.action) {
                    dst.action.add(requestGroupActionComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestGroupActionComponent)) {
                return false;
            }
            RequestGroupActionComponent o = (RequestGroupActionComponent)other_;
            return RequestGroupActionComponent.compareDeep(this.label, o.label, true) && RequestGroupActionComponent.compareDeep(this.title, o.title, true) && RequestGroupActionComponent.compareDeep(this.description, o.description, true) && RequestGroupActionComponent.compareDeep(this.textEquivalent, o.textEquivalent, true) && RequestGroupActionComponent.compareDeep(this.code, o.code, true) && RequestGroupActionComponent.compareDeep(this.documentation, o.documentation, true) && RequestGroupActionComponent.compareDeep(this.condition, o.condition, true) && RequestGroupActionComponent.compareDeep(this.relatedAction, o.relatedAction, true) && RequestGroupActionComponent.compareDeep(this.timing, o.timing, true) && RequestGroupActionComponent.compareDeep(this.participant, o.participant, true) && RequestGroupActionComponent.compareDeep(this.type, o.type, true) && RequestGroupActionComponent.compareDeep(this.groupingBehavior, o.groupingBehavior, true) && RequestGroupActionComponent.compareDeep(this.selectionBehavior, o.selectionBehavior, true) && RequestGroupActionComponent.compareDeep(this.requiredBehavior, o.requiredBehavior, true) && RequestGroupActionComponent.compareDeep(this.precheckBehavior, o.precheckBehavior, true) && RequestGroupActionComponent.compareDeep(this.cardinalityBehavior, o.cardinalityBehavior, true) && RequestGroupActionComponent.compareDeep(this.resource, o.resource, true) && RequestGroupActionComponent.compareDeep(this.action, o.action, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RequestGroupActionComponent)) {
                return false;
            }
            RequestGroupActionComponent o = (RequestGroupActionComponent)other_;
            return RequestGroupActionComponent.compareValues(this.label, o.label, true) && RequestGroupActionComponent.compareValues(this.title, o.title, true) && RequestGroupActionComponent.compareValues(this.description, o.description, true) && RequestGroupActionComponent.compareValues(this.textEquivalent, o.textEquivalent, true) && RequestGroupActionComponent.compareValues(this.groupingBehavior, o.groupingBehavior, true) && RequestGroupActionComponent.compareValues(this.selectionBehavior, o.selectionBehavior, true) && RequestGroupActionComponent.compareValues(this.requiredBehavior, o.requiredBehavior, true) && RequestGroupActionComponent.compareValues(this.precheckBehavior, o.precheckBehavior, true) && RequestGroupActionComponent.compareValues(this.cardinalityBehavior, o.cardinalityBehavior, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.label, this.title, this.description, this.textEquivalent, this.code, this.documentation, this.condition, this.relatedAction, this.timing, this.participant, this.type, this.groupingBehavior, this.selectionBehavior, this.requiredBehavior, this.precheckBehavior, this.cardinalityBehavior, this.resource, this.action);
        }

        @Override
        public String fhirType() {
            return "RequestGroup.action";
        }
    }

    public static class ActionCardinalityBehaviorEnumFactory
    implements EnumFactory<ActionCardinalityBehavior> {
        @Override
        public ActionCardinalityBehavior fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("single".equals(codeString)) {
                return ActionCardinalityBehavior.SINGLE;
            }
            if ("multiple".equals(codeString)) {
                return ActionCardinalityBehavior.MULTIPLE;
            }
            throw new IllegalArgumentException("Unknown ActionCardinalityBehavior code '" + codeString + "'");
        }

        public Enumeration<ActionCardinalityBehavior> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActionCardinalityBehavior>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("single".equals(codeString)) {
                return new Enumeration<ActionCardinalityBehavior>(this, ActionCardinalityBehavior.SINGLE);
            }
            if ("multiple".equals(codeString)) {
                return new Enumeration<ActionCardinalityBehavior>(this, ActionCardinalityBehavior.MULTIPLE);
            }
            throw new FHIRException("Unknown ActionCardinalityBehavior code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionCardinalityBehavior code) {
            if (code == ActionCardinalityBehavior.SINGLE) {
                return "single";
            }
            if (code == ActionCardinalityBehavior.MULTIPLE) {
                return "multiple";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionCardinalityBehavior code) {
            return code.getSystem();
        }
    }

    public static enum ActionCardinalityBehavior {
        SINGLE,
        MULTIPLE,
        NULL;


        public static ActionCardinalityBehavior fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("single".equals(codeString)) {
                return SINGLE;
            }
            if ("multiple".equals(codeString)) {
                return MULTIPLE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActionCardinalityBehavior code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SINGLE: {
                    return "single";
                }
                case MULTIPLE: {
                    return "multiple";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SINGLE: {
                    return "http://hl7.org/fhir/action-cardinality-behavior";
                }
                case MULTIPLE: {
                    return "http://hl7.org/fhir/action-cardinality-behavior";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SINGLE: {
                    return "The action may only be selected one time";
                }
                case MULTIPLE: {
                    return "The action may be selected multiple times";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SINGLE: {
                    return "Single";
                }
                case MULTIPLE: {
                    return "Multiple";
                }
            }
            return "?";
        }
    }

    public static class ActionPrecheckBehaviorEnumFactory
    implements EnumFactory<ActionPrecheckBehavior> {
        @Override
        public ActionPrecheckBehavior fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("yes".equals(codeString)) {
                return ActionPrecheckBehavior.YES;
            }
            if ("no".equals(codeString)) {
                return ActionPrecheckBehavior.NO;
            }
            throw new IllegalArgumentException("Unknown ActionPrecheckBehavior code '" + codeString + "'");
        }

        public Enumeration<ActionPrecheckBehavior> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActionPrecheckBehavior>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("yes".equals(codeString)) {
                return new Enumeration<ActionPrecheckBehavior>(this, ActionPrecheckBehavior.YES);
            }
            if ("no".equals(codeString)) {
                return new Enumeration<ActionPrecheckBehavior>(this, ActionPrecheckBehavior.NO);
            }
            throw new FHIRException("Unknown ActionPrecheckBehavior code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionPrecheckBehavior code) {
            if (code == ActionPrecheckBehavior.YES) {
                return "yes";
            }
            if (code == ActionPrecheckBehavior.NO) {
                return "no";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionPrecheckBehavior code) {
            return code.getSystem();
        }
    }

    public static enum ActionPrecheckBehavior {
        YES,
        NO,
        NULL;


        public static ActionPrecheckBehavior fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("yes".equals(codeString)) {
                return YES;
            }
            if ("no".equals(codeString)) {
                return NO;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActionPrecheckBehavior code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case YES: {
                    return "yes";
                }
                case NO: {
                    return "no";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case YES: {
                    return "http://hl7.org/fhir/action-precheck-behavior";
                }
                case NO: {
                    return "http://hl7.org/fhir/action-precheck-behavior";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case YES: {
                    return "An action with this behavior is one of the most frequent action that is, or should be, included by an end user, for the particular context in which the action occurs. The system displaying the action to the end user should consider \"pre-checking\" such an action as a convenience for the user";
                }
                case NO: {
                    return "An action with this behavior is one of the less frequent actions included by the end user, for the particular context in which the action occurs. The system displaying the actions to the end user would typically not \"pre-check\" such an action";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case YES: {
                    return "Yes";
                }
                case NO: {
                    return "No";
                }
            }
            return "?";
        }
    }

    public static class ActionRequiredBehaviorEnumFactory
    implements EnumFactory<ActionRequiredBehavior> {
        @Override
        public ActionRequiredBehavior fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("must".equals(codeString)) {
                return ActionRequiredBehavior.MUST;
            }
            if ("could".equals(codeString)) {
                return ActionRequiredBehavior.COULD;
            }
            if ("must-unless-documented".equals(codeString)) {
                return ActionRequiredBehavior.MUSTUNLESSDOCUMENTED;
            }
            throw new IllegalArgumentException("Unknown ActionRequiredBehavior code '" + codeString + "'");
        }

        public Enumeration<ActionRequiredBehavior> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActionRequiredBehavior>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("must".equals(codeString)) {
                return new Enumeration<ActionRequiredBehavior>(this, ActionRequiredBehavior.MUST);
            }
            if ("could".equals(codeString)) {
                return new Enumeration<ActionRequiredBehavior>(this, ActionRequiredBehavior.COULD);
            }
            if ("must-unless-documented".equals(codeString)) {
                return new Enumeration<ActionRequiredBehavior>(this, ActionRequiredBehavior.MUSTUNLESSDOCUMENTED);
            }
            throw new FHIRException("Unknown ActionRequiredBehavior code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionRequiredBehavior code) {
            if (code == ActionRequiredBehavior.MUST) {
                return "must";
            }
            if (code == ActionRequiredBehavior.COULD) {
                return "could";
            }
            if (code == ActionRequiredBehavior.MUSTUNLESSDOCUMENTED) {
                return "must-unless-documented";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionRequiredBehavior code) {
            return code.getSystem();
        }
    }

    public static enum ActionRequiredBehavior {
        MUST,
        COULD,
        MUSTUNLESSDOCUMENTED,
        NULL;


        public static ActionRequiredBehavior fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("must".equals(codeString)) {
                return MUST;
            }
            if ("could".equals(codeString)) {
                return COULD;
            }
            if ("must-unless-documented".equals(codeString)) {
                return MUSTUNLESSDOCUMENTED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActionRequiredBehavior code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MUST: {
                    return "must";
                }
                case COULD: {
                    return "could";
                }
                case MUSTUNLESSDOCUMENTED: {
                    return "must-unless-documented";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MUST: {
                    return "http://hl7.org/fhir/action-required-behavior";
                }
                case COULD: {
                    return "http://hl7.org/fhir/action-required-behavior";
                }
                case MUSTUNLESSDOCUMENTED: {
                    return "http://hl7.org/fhir/action-required-behavior";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MUST: {
                    return "An action with this behavior must be included in the actions processed by the end user; the end user may not choose not to include this action";
                }
                case COULD: {
                    return "An action with this behavior may be included in the set of actions processed by the end user";
                }
                case MUSTUNLESSDOCUMENTED: {
                    return "An action with this behavior must be included in the set of actions processed by the end user, unless the end user provides documentation as to why the action was not included";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MUST: {
                    return "Must";
                }
                case COULD: {
                    return "Could";
                }
                case MUSTUNLESSDOCUMENTED: {
                    return "Must Unless Documented";
                }
            }
            return "?";
        }
    }

    public static class ActionSelectionBehaviorEnumFactory
    implements EnumFactory<ActionSelectionBehavior> {
        @Override
        public ActionSelectionBehavior fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("any".equals(codeString)) {
                return ActionSelectionBehavior.ANY;
            }
            if ("all".equals(codeString)) {
                return ActionSelectionBehavior.ALL;
            }
            if ("all-or-none".equals(codeString)) {
                return ActionSelectionBehavior.ALLORNONE;
            }
            if ("exactly-one".equals(codeString)) {
                return ActionSelectionBehavior.EXACTLYONE;
            }
            if ("at-most-one".equals(codeString)) {
                return ActionSelectionBehavior.ATMOSTONE;
            }
            if ("one-or-more".equals(codeString)) {
                return ActionSelectionBehavior.ONEORMORE;
            }
            throw new IllegalArgumentException("Unknown ActionSelectionBehavior code '" + codeString + "'");
        }

        public Enumeration<ActionSelectionBehavior> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActionSelectionBehavior>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("any".equals(codeString)) {
                return new Enumeration<ActionSelectionBehavior>(this, ActionSelectionBehavior.ANY);
            }
            if ("all".equals(codeString)) {
                return new Enumeration<ActionSelectionBehavior>(this, ActionSelectionBehavior.ALL);
            }
            if ("all-or-none".equals(codeString)) {
                return new Enumeration<ActionSelectionBehavior>(this, ActionSelectionBehavior.ALLORNONE);
            }
            if ("exactly-one".equals(codeString)) {
                return new Enumeration<ActionSelectionBehavior>(this, ActionSelectionBehavior.EXACTLYONE);
            }
            if ("at-most-one".equals(codeString)) {
                return new Enumeration<ActionSelectionBehavior>(this, ActionSelectionBehavior.ATMOSTONE);
            }
            if ("one-or-more".equals(codeString)) {
                return new Enumeration<ActionSelectionBehavior>(this, ActionSelectionBehavior.ONEORMORE);
            }
            throw new FHIRException("Unknown ActionSelectionBehavior code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionSelectionBehavior code) {
            if (code == ActionSelectionBehavior.ANY) {
                return "any";
            }
            if (code == ActionSelectionBehavior.ALL) {
                return "all";
            }
            if (code == ActionSelectionBehavior.ALLORNONE) {
                return "all-or-none";
            }
            if (code == ActionSelectionBehavior.EXACTLYONE) {
                return "exactly-one";
            }
            if (code == ActionSelectionBehavior.ATMOSTONE) {
                return "at-most-one";
            }
            if (code == ActionSelectionBehavior.ONEORMORE) {
                return "one-or-more";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionSelectionBehavior code) {
            return code.getSystem();
        }
    }

    public static enum ActionSelectionBehavior {
        ANY,
        ALL,
        ALLORNONE,
        EXACTLYONE,
        ATMOSTONE,
        ONEORMORE,
        NULL;


        public static ActionSelectionBehavior fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("any".equals(codeString)) {
                return ANY;
            }
            if ("all".equals(codeString)) {
                return ALL;
            }
            if ("all-or-none".equals(codeString)) {
                return ALLORNONE;
            }
            if ("exactly-one".equals(codeString)) {
                return EXACTLYONE;
            }
            if ("at-most-one".equals(codeString)) {
                return ATMOSTONE;
            }
            if ("one-or-more".equals(codeString)) {
                return ONEORMORE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActionSelectionBehavior code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ANY: {
                    return "any";
                }
                case ALL: {
                    return "all";
                }
                case ALLORNONE: {
                    return "all-or-none";
                }
                case EXACTLYONE: {
                    return "exactly-one";
                }
                case ATMOSTONE: {
                    return "at-most-one";
                }
                case ONEORMORE: {
                    return "one-or-more";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ANY: {
                    return "http://hl7.org/fhir/action-selection-behavior";
                }
                case ALL: {
                    return "http://hl7.org/fhir/action-selection-behavior";
                }
                case ALLORNONE: {
                    return "http://hl7.org/fhir/action-selection-behavior";
                }
                case EXACTLYONE: {
                    return "http://hl7.org/fhir/action-selection-behavior";
                }
                case ATMOSTONE: {
                    return "http://hl7.org/fhir/action-selection-behavior";
                }
                case ONEORMORE: {
                    return "http://hl7.org/fhir/action-selection-behavior";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ANY: {
                    return "Any number of the actions in the group may be chosen, from zero to all";
                }
                case ALL: {
                    return "All the actions in the group must be selected as a single unit";
                }
                case ALLORNONE: {
                    return "All the actions in the group are meant to be chosen as a single unit: either all must be selected by the end user, or none may be selected";
                }
                case EXACTLYONE: {
                    return "The end user must choose one and only one of the selectable actions in the group. The user may not choose none of the actions in the group";
                }
                case ATMOSTONE: {
                    return "The end user may choose zero or at most one of the actions in the group";
                }
                case ONEORMORE: {
                    return "The end user must choose a minimum of one, and as many additional as desired";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ANY: {
                    return "Any";
                }
                case ALL: {
                    return "All";
                }
                case ALLORNONE: {
                    return "All Or None";
                }
                case EXACTLYONE: {
                    return "Exactly One";
                }
                case ATMOSTONE: {
                    return "At Most One";
                }
                case ONEORMORE: {
                    return "One Or More";
                }
            }
            return "?";
        }
    }

    public static class ActionGroupingBehaviorEnumFactory
    implements EnumFactory<ActionGroupingBehavior> {
        @Override
        public ActionGroupingBehavior fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("visual-group".equals(codeString)) {
                return ActionGroupingBehavior.VISUALGROUP;
            }
            if ("logical-group".equals(codeString)) {
                return ActionGroupingBehavior.LOGICALGROUP;
            }
            if ("sentence-group".equals(codeString)) {
                return ActionGroupingBehavior.SENTENCEGROUP;
            }
            throw new IllegalArgumentException("Unknown ActionGroupingBehavior code '" + codeString + "'");
        }

        public Enumeration<ActionGroupingBehavior> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActionGroupingBehavior>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("visual-group".equals(codeString)) {
                return new Enumeration<ActionGroupingBehavior>(this, ActionGroupingBehavior.VISUALGROUP);
            }
            if ("logical-group".equals(codeString)) {
                return new Enumeration<ActionGroupingBehavior>(this, ActionGroupingBehavior.LOGICALGROUP);
            }
            if ("sentence-group".equals(codeString)) {
                return new Enumeration<ActionGroupingBehavior>(this, ActionGroupingBehavior.SENTENCEGROUP);
            }
            throw new FHIRException("Unknown ActionGroupingBehavior code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionGroupingBehavior code) {
            if (code == ActionGroupingBehavior.VISUALGROUP) {
                return "visual-group";
            }
            if (code == ActionGroupingBehavior.LOGICALGROUP) {
                return "logical-group";
            }
            if (code == ActionGroupingBehavior.SENTENCEGROUP) {
                return "sentence-group";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionGroupingBehavior code) {
            return code.getSystem();
        }
    }

    public static enum ActionGroupingBehavior {
        VISUALGROUP,
        LOGICALGROUP,
        SENTENCEGROUP,
        NULL;


        public static ActionGroupingBehavior fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("visual-group".equals(codeString)) {
                return VISUALGROUP;
            }
            if ("logical-group".equals(codeString)) {
                return LOGICALGROUP;
            }
            if ("sentence-group".equals(codeString)) {
                return SENTENCEGROUP;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActionGroupingBehavior code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case VISUALGROUP: {
                    return "visual-group";
                }
                case LOGICALGROUP: {
                    return "logical-group";
                }
                case SENTENCEGROUP: {
                    return "sentence-group";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case VISUALGROUP: {
                    return "http://hl7.org/fhir/action-grouping-behavior";
                }
                case LOGICALGROUP: {
                    return "http://hl7.org/fhir/action-grouping-behavior";
                }
                case SENTENCEGROUP: {
                    return "http://hl7.org/fhir/action-grouping-behavior";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case VISUALGROUP: {
                    return "Any group marked with this behavior should be displayed as a visual group to the end user";
                }
                case LOGICALGROUP: {
                    return "A group with this behavior logically groups its sub-elements, and may be shown as a visual group to the end user, but it is not required to do so";
                }
                case SENTENCEGROUP: {
                    return "A group of related alternative actions is a sentence group if the target referenced by the action is the same in all the actions and each action simply constitutes a different variation on how to specify the details for the target. For example, two actions that could be in a SentenceGroup are \"aspirin, 500 mg, 2 times per day\" and \"aspirin, 300 mg, 3 times per day\". In both cases, aspirin is the target referenced by the action, and the two actions represent different options for how aspirin might be ordered for the patient. Note that a SentenceGroup would almost always have an associated selection behavior of \"AtMostOne\", unless it's a required action, in which case, it would be \"ExactlyOne\"";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case VISUALGROUP: {
                    return "Visual Group";
                }
                case LOGICALGROUP: {
                    return "Logical Group";
                }
                case SENTENCEGROUP: {
                    return "Sentence Group";
                }
            }
            return "?";
        }
    }

    public static class ActionRelationshipTypeEnumFactory
    implements EnumFactory<ActionRelationshipType> {
        @Override
        public ActionRelationshipType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("before-start".equals(codeString)) {
                return ActionRelationshipType.BEFORESTART;
            }
            if ("before".equals(codeString)) {
                return ActionRelationshipType.BEFORE;
            }
            if ("before-end".equals(codeString)) {
                return ActionRelationshipType.BEFOREEND;
            }
            if ("concurrent-with-start".equals(codeString)) {
                return ActionRelationshipType.CONCURRENTWITHSTART;
            }
            if ("concurrent".equals(codeString)) {
                return ActionRelationshipType.CONCURRENT;
            }
            if ("concurrent-with-end".equals(codeString)) {
                return ActionRelationshipType.CONCURRENTWITHEND;
            }
            if ("after-start".equals(codeString)) {
                return ActionRelationshipType.AFTERSTART;
            }
            if ("after".equals(codeString)) {
                return ActionRelationshipType.AFTER;
            }
            if ("after-end".equals(codeString)) {
                return ActionRelationshipType.AFTEREND;
            }
            throw new IllegalArgumentException("Unknown ActionRelationshipType code '" + codeString + "'");
        }

        public Enumeration<ActionRelationshipType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActionRelationshipType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("before-start".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.BEFORESTART);
            }
            if ("before".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.BEFORE);
            }
            if ("before-end".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.BEFOREEND);
            }
            if ("concurrent-with-start".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.CONCURRENTWITHSTART);
            }
            if ("concurrent".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.CONCURRENT);
            }
            if ("concurrent-with-end".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.CONCURRENTWITHEND);
            }
            if ("after-start".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.AFTERSTART);
            }
            if ("after".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.AFTER);
            }
            if ("after-end".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.AFTEREND);
            }
            throw new FHIRException("Unknown ActionRelationshipType code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionRelationshipType code) {
            if (code == ActionRelationshipType.BEFORESTART) {
                return "before-start";
            }
            if (code == ActionRelationshipType.BEFORE) {
                return "before";
            }
            if (code == ActionRelationshipType.BEFOREEND) {
                return "before-end";
            }
            if (code == ActionRelationshipType.CONCURRENTWITHSTART) {
                return "concurrent-with-start";
            }
            if (code == ActionRelationshipType.CONCURRENT) {
                return "concurrent";
            }
            if (code == ActionRelationshipType.CONCURRENTWITHEND) {
                return "concurrent-with-end";
            }
            if (code == ActionRelationshipType.AFTERSTART) {
                return "after-start";
            }
            if (code == ActionRelationshipType.AFTER) {
                return "after";
            }
            if (code == ActionRelationshipType.AFTEREND) {
                return "after-end";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionRelationshipType code) {
            return code.getSystem();
        }
    }

    public static enum ActionRelationshipType {
        BEFORESTART,
        BEFORE,
        BEFOREEND,
        CONCURRENTWITHSTART,
        CONCURRENT,
        CONCURRENTWITHEND,
        AFTERSTART,
        AFTER,
        AFTEREND,
        NULL;


        public static ActionRelationshipType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("before-start".equals(codeString)) {
                return BEFORESTART;
            }
            if ("before".equals(codeString)) {
                return BEFORE;
            }
            if ("before-end".equals(codeString)) {
                return BEFOREEND;
            }
            if ("concurrent-with-start".equals(codeString)) {
                return CONCURRENTWITHSTART;
            }
            if ("concurrent".equals(codeString)) {
                return CONCURRENT;
            }
            if ("concurrent-with-end".equals(codeString)) {
                return CONCURRENTWITHEND;
            }
            if ("after-start".equals(codeString)) {
                return AFTERSTART;
            }
            if ("after".equals(codeString)) {
                return AFTER;
            }
            if ("after-end".equals(codeString)) {
                return AFTEREND;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActionRelationshipType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case BEFORESTART: {
                    return "before-start";
                }
                case BEFORE: {
                    return "before";
                }
                case BEFOREEND: {
                    return "before-end";
                }
                case CONCURRENTWITHSTART: {
                    return "concurrent-with-start";
                }
                case CONCURRENT: {
                    return "concurrent";
                }
                case CONCURRENTWITHEND: {
                    return "concurrent-with-end";
                }
                case AFTERSTART: {
                    return "after-start";
                }
                case AFTER: {
                    return "after";
                }
                case AFTEREND: {
                    return "after-end";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case BEFORESTART: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case BEFORE: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case BEFOREEND: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case CONCURRENTWITHSTART: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case CONCURRENT: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case CONCURRENTWITHEND: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case AFTERSTART: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case AFTER: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case AFTEREND: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case BEFORESTART: {
                    return "The action must be performed before the start of the related action";
                }
                case BEFORE: {
                    return "The action must be performed before the related action";
                }
                case BEFOREEND: {
                    return "The action must be performed before the end of the related action";
                }
                case CONCURRENTWITHSTART: {
                    return "The action must be performed concurrent with the start of the related action";
                }
                case CONCURRENT: {
                    return "The action must be performed concurrent with the related action";
                }
                case CONCURRENTWITHEND: {
                    return "The action must be performed concurrent with the end of the related action";
                }
                case AFTERSTART: {
                    return "The action must be performed after the start of the related action";
                }
                case AFTER: {
                    return "The action must be performed after the related action";
                }
                case AFTEREND: {
                    return "The action must be performed after the end of the related action";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case BEFORESTART: {
                    return "Before Start";
                }
                case BEFORE: {
                    return "Before";
                }
                case BEFOREEND: {
                    return "Before End";
                }
                case CONCURRENTWITHSTART: {
                    return "Concurrent With Start";
                }
                case CONCURRENT: {
                    return "Concurrent";
                }
                case CONCURRENTWITHEND: {
                    return "Concurrent With End";
                }
                case AFTERSTART: {
                    return "After Start";
                }
                case AFTER: {
                    return "After";
                }
                case AFTEREND: {
                    return "After End";
                }
            }
            return "?";
        }
    }

    public static class ActionConditionKindEnumFactory
    implements EnumFactory<ActionConditionKind> {
        @Override
        public ActionConditionKind fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("applicability".equals(codeString)) {
                return ActionConditionKind.APPLICABILITY;
            }
            if ("start".equals(codeString)) {
                return ActionConditionKind.START;
            }
            if ("stop".equals(codeString)) {
                return ActionConditionKind.STOP;
            }
            throw new IllegalArgumentException("Unknown ActionConditionKind code '" + codeString + "'");
        }

        public Enumeration<ActionConditionKind> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActionConditionKind>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("applicability".equals(codeString)) {
                return new Enumeration<ActionConditionKind>(this, ActionConditionKind.APPLICABILITY);
            }
            if ("start".equals(codeString)) {
                return new Enumeration<ActionConditionKind>(this, ActionConditionKind.START);
            }
            if ("stop".equals(codeString)) {
                return new Enumeration<ActionConditionKind>(this, ActionConditionKind.STOP);
            }
            throw new FHIRException("Unknown ActionConditionKind code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionConditionKind code) {
            if (code == ActionConditionKind.APPLICABILITY) {
                return "applicability";
            }
            if (code == ActionConditionKind.START) {
                return "start";
            }
            if (code == ActionConditionKind.STOP) {
                return "stop";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionConditionKind code) {
            return code.getSystem();
        }
    }

    public static enum ActionConditionKind {
        APPLICABILITY,
        START,
        STOP,
        NULL;


        public static ActionConditionKind fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("applicability".equals(codeString)) {
                return APPLICABILITY;
            }
            if ("start".equals(codeString)) {
                return START;
            }
            if ("stop".equals(codeString)) {
                return STOP;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActionConditionKind code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case APPLICABILITY: {
                    return "applicability";
                }
                case START: {
                    return "start";
                }
                case STOP: {
                    return "stop";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case APPLICABILITY: {
                    return "http://hl7.org/fhir/action-condition-kind";
                }
                case START: {
                    return "http://hl7.org/fhir/action-condition-kind";
                }
                case STOP: {
                    return "http://hl7.org/fhir/action-condition-kind";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case APPLICABILITY: {
                    return "The condition describes whether or not a given action is applicable";
                }
                case START: {
                    return "The condition is a starting condition for the action";
                }
                case STOP: {
                    return "The condition is a stop, or exit condition for the action";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case APPLICABILITY: {
                    return "Applicability";
                }
                case START: {
                    return "Start";
                }
                case STOP: {
                    return "Stop";
                }
            }
            return "?";
        }
    }

    public static class RequestPriorityEnumFactory
    implements EnumFactory<RequestPriority> {
        @Override
        public RequestPriority fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return RequestPriority.ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return RequestPriority.URGENT;
            }
            if ("asap".equals(codeString)) {
                return RequestPriority.ASAP;
            }
            if ("stat".equals(codeString)) {
                return RequestPriority.STAT;
            }
            throw new IllegalArgumentException("Unknown RequestPriority code '" + codeString + "'");
        }

        public Enumeration<RequestPriority> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RequestPriority>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.ROUTINE);
            }
            if ("urgent".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.URGENT);
            }
            if ("asap".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.ASAP);
            }
            if ("stat".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.STAT);
            }
            throw new FHIRException("Unknown RequestPriority code '" + codeString + "'");
        }

        @Override
        public String toCode(RequestPriority code) {
            if (code == RequestPriority.ROUTINE) {
                return "routine";
            }
            if (code == RequestPriority.URGENT) {
                return "urgent";
            }
            if (code == RequestPriority.ASAP) {
                return "asap";
            }
            if (code == RequestPriority.STAT) {
                return "stat";
            }
            return "?";
        }

        @Override
        public String toSystem(RequestPriority code) {
            return code.getSystem();
        }
    }

    public static enum RequestPriority {
        ROUTINE,
        URGENT,
        ASAP,
        STAT,
        NULL;


        public static RequestPriority fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return URGENT;
            }
            if ("asap".equals(codeString)) {
                return ASAP;
            }
            if ("stat".equals(codeString)) {
                return STAT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RequestPriority code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ROUTINE: {
                    return "routine";
                }
                case URGENT: {
                    return "urgent";
                }
                case ASAP: {
                    return "asap";
                }
                case STAT: {
                    return "stat";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ROUTINE: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case URGENT: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case ASAP: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case STAT: {
                    return "http://hl7.org/fhir/request-priority";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ROUTINE: {
                    return "The request has normal priority";
                }
                case URGENT: {
                    return "The request should be actioned promptly - higher priority than routine";
                }
                case ASAP: {
                    return "The request should be actioned as soon as possible - higher priority than urgent";
                }
                case STAT: {
                    return "The request should be actioned immediately - highest possible priority.  E.g. an emergency";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ROUTINE: {
                    return "Routine";
                }
                case URGENT: {
                    return "Urgent";
                }
                case ASAP: {
                    return "ASAP";
                }
                case STAT: {
                    return "STAT";
                }
            }
            return "?";
        }
    }

    public static class RequestIntentEnumFactory
    implements EnumFactory<RequestIntent> {
        @Override
        public RequestIntent fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return RequestIntent.PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return RequestIntent.PLAN;
            }
            if ("order".equals(codeString)) {
                return RequestIntent.ORDER;
            }
            if ("original-order".equals(codeString)) {
                return RequestIntent.ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return RequestIntent.REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return RequestIntent.FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return RequestIntent.INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return RequestIntent.OPTION;
            }
            throw new IllegalArgumentException("Unknown RequestIntent code '" + codeString + "'");
        }

        public Enumeration<RequestIntent> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RequestIntent>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.PROPOSAL);
            }
            if ("plan".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.PLAN);
            }
            if ("order".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.ORDER);
            }
            if ("original-order".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.ORIGINALORDER);
            }
            if ("reflex-order".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.REFLEXORDER);
            }
            if ("filler-order".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.FILLERORDER);
            }
            if ("instance-order".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.INSTANCEORDER);
            }
            if ("option".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.OPTION);
            }
            throw new FHIRException("Unknown RequestIntent code '" + codeString + "'");
        }

        @Override
        public String toCode(RequestIntent code) {
            if (code == RequestIntent.PROPOSAL) {
                return "proposal";
            }
            if (code == RequestIntent.PLAN) {
                return "plan";
            }
            if (code == RequestIntent.ORDER) {
                return "order";
            }
            if (code == RequestIntent.ORIGINALORDER) {
                return "original-order";
            }
            if (code == RequestIntent.REFLEXORDER) {
                return "reflex-order";
            }
            if (code == RequestIntent.FILLERORDER) {
                return "filler-order";
            }
            if (code == RequestIntent.INSTANCEORDER) {
                return "instance-order";
            }
            if (code == RequestIntent.OPTION) {
                return "option";
            }
            return "?";
        }

        @Override
        public String toSystem(RequestIntent code) {
            return code.getSystem();
        }
    }

    public static enum RequestIntent {
        PROPOSAL,
        PLAN,
        ORDER,
        ORIGINALORDER,
        REFLEXORDER,
        FILLERORDER,
        INSTANCEORDER,
        OPTION,
        NULL;


        public static RequestIntent fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return PLAN;
            }
            if ("order".equals(codeString)) {
                return ORDER;
            }
            if ("original-order".equals(codeString)) {
                return ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return OPTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RequestIntent code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSAL: {
                    return "proposal";
                }
                case PLAN: {
                    return "plan";
                }
                case ORDER: {
                    return "order";
                }
                case ORIGINALORDER: {
                    return "original-order";
                }
                case REFLEXORDER: {
                    return "reflex-order";
                }
                case FILLERORDER: {
                    return "filler-order";
                }
                case INSTANCEORDER: {
                    return "instance-order";
                }
                case OPTION: {
                    return "option";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSAL: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case PLAN: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORIGINALORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case REFLEXORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case FILLERORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case INSTANCEORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case OPTION: {
                    return "http://hl7.org/fhir/request-intent";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSAL: {
                    return "The request is a suggestion made by someone/something that doesn't have an intention to ensure it occurs and without providing an authorization to act";
                }
                case PLAN: {
                    return "The request represents an intension to ensure something occurs without providing an authorization for others to act";
                }
                case ORDER: {
                    return "The request represents a request/demand and authorization for action";
                }
                case ORIGINALORDER: {
                    return "The request represents an original authorization for action";
                }
                case REFLEXORDER: {
                    return "The request represents an automatically generated supplemental authorization for action based on a parent authorization together with initial results of the action taken against that parent authorization";
                }
                case FILLERORDER: {
                    return "The request represents the view of an authorization instantiated by a fulfilling system representing the details of the fulfiller's intention to act upon a submitted order";
                }
                case INSTANCEORDER: {
                    return "An order created in fulfillment of a broader order that represents the authorization for a single activity occurrence.  E.g. The administration of a single dose of a drug.";
                }
                case OPTION: {
                    return "The request represents a component or option for a RequestGroup that establishes timing, conditionality and/or other constraints among a set of requests.\n\nRefer to [[[RequestGroup]]] for additional information on how this status is used";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSAL: {
                    return "Proposal";
                }
                case PLAN: {
                    return "Plan";
                }
                case ORDER: {
                    return "Order";
                }
                case ORIGINALORDER: {
                    return "Original Order";
                }
                case REFLEXORDER: {
                    return "Reflex Order";
                }
                case FILLERORDER: {
                    return "Filler Order";
                }
                case INSTANCEORDER: {
                    return "Instance Order";
                }
                case OPTION: {
                    return "Option";
                }
            }
            return "?";
        }
    }

    public static class RequestStatusEnumFactory
    implements EnumFactory<RequestStatus> {
        @Override
        public RequestStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return RequestStatus.DRAFT;
            }
            if ("active".equals(codeString)) {
                return RequestStatus.ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return RequestStatus.SUSPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return RequestStatus.CANCELLED;
            }
            if ("completed".equals(codeString)) {
                return RequestStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return RequestStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return RequestStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown RequestStatus code '" + codeString + "'");
        }

        public Enumeration<RequestStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RequestStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<RequestStatus>(this, RequestStatus.DRAFT);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<RequestStatus>(this, RequestStatus.ACTIVE);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<RequestStatus>(this, RequestStatus.SUSPENDED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<RequestStatus>(this, RequestStatus.CANCELLED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<RequestStatus>(this, RequestStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<RequestStatus>(this, RequestStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<RequestStatus>(this, RequestStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown RequestStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(RequestStatus code) {
            if (code == RequestStatus.DRAFT) {
                return "draft";
            }
            if (code == RequestStatus.ACTIVE) {
                return "active";
            }
            if (code == RequestStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == RequestStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == RequestStatus.COMPLETED) {
                return "completed";
            }
            if (code == RequestStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == RequestStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(RequestStatus code) {
            return code.getSystem();
        }
    }

    public static enum RequestStatus {
        DRAFT,
        ACTIVE,
        SUSPENDED,
        CANCELLED,
        COMPLETED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static RequestStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RequestStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case ACTIVE: {
                    return "active";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/request-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/request-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/request-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/request-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/request-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/request-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/request-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The request has been created but is not yet complete or ready for action";
                }
                case ACTIVE: {
                    return "The request is ready to be acted upon";
                }
                case SUSPENDED: {
                    return "The authorization/request to act has been temporarily withdrawn but is expected to resume in the future";
                }
                case CANCELLED: {
                    return "The authorization/request to act has been terminated prior to the full completion of the intended actions.  No further activity should occur.";
                }
                case COMPLETED: {
                    return "Activity against the request has been sufficiently completed to the satisfaction of the requester";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it.  (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".)";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this request.  Note: This concept is not to be used for \"other\" . One of the listed statuses is presumed to apply,  but the system creating the request doesn't know.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case ACTIVE: {
                    return "Active";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }
}

