/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.CommunicationRequest;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ProcessResponse", profile="http://hl7.org/fhir/Profile/ProcessResponse")
public class ProcessResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier", formalDefinition="The Response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<ProcessResponseStatus> status;
    @Child(name="created", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Creation date", formalDefinition="The date when the enclosed suite of services were performed or completed.")
    protected DateTimeType created;
    @Child(name="organization", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Authoring Organization", formalDefinition="The organization who produced this adjudicated response.")
    protected Reference organization;
    protected Organization organizationTarget;
    @Child(name="request", type={Reference.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Request reference", formalDefinition="Original request resource reference.")
    protected Reference request;
    protected Resource requestTarget;
    @Child(name="outcome", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Processing outcome", formalDefinition="Transaction status: error, complete, held.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/process-outcome")
    protected CodeableConcept outcome;
    @Child(name="disposition", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Disposition Message", formalDefinition="A description of the status of the adjudication or processing.")
    protected StringType disposition;
    @Child(name="requestProvider", type={Practitioner.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible Practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Reference requestProvider;
    protected Practitioner requestProviderTarget;
    @Child(name="requestOrganization", type={Organization.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    protected Reference requestOrganization;
    protected Organization requestOrganizationTarget;
    @Child(name="form", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Printed Form Identifier", formalDefinition="The form to be used for printing the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/forms")
    protected CodeableConcept form;
    @Child(name="processNote", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Processing comments or additional requirements", formalDefinition="Suite of processing notes or additional requirements if the processing has been held.")
    protected List<ProcessResponseProcessNoteComponent> processNote;
    @Child(name="error", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Error code", formalDefinition="Processing errors.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication-error")
    protected List<CodeableConcept> error;
    @Child(name="communicationRequest", type={CommunicationRequest.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Request for additional information", formalDefinition="Request for additional supporting or authorizing information, such as: documents, images or resources.")
    protected List<Reference> communicationRequest;
    protected List<CommunicationRequest> communicationRequestTarget;
    private static final long serialVersionUID = -2058462467L;
    @SearchParamDefinition(name="identifier", path="ProcessResponse.identifier", description="The business identifier of the Explanation of Benefit", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="request", path="ProcessResponse.request", description="The reference to the claim", type="reference")
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("ProcessResponse:request").toLocked();
    @SearchParamDefinition(name="organization", path="ProcessResponse.organization", description="The organization who generated this resource", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("ProcessResponse:organization").toLocked();
    @SearchParamDefinition(name="request-organization", path="ProcessResponse.requestOrganization", description="The Organization who is responsible the request transaction", type="reference", target={Organization.class})
    public static final String SP_REQUEST_ORGANIZATION = "request-organization";
    public static final ReferenceClientParam REQUEST_ORGANIZATION = new ReferenceClientParam("request-organization");
    public static final Include INCLUDE_REQUEST_ORGANIZATION = new Include("ProcessResponse:request-organization").toLocked();
    @SearchParamDefinition(name="request-provider", path="ProcessResponse.requestProvider", description="The Provider who is responsible the request transaction", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class})
    public static final String SP_REQUEST_PROVIDER = "request-provider";
    public static final ReferenceClientParam REQUEST_PROVIDER = new ReferenceClientParam("request-provider");
    public static final Include INCLUDE_REQUEST_PROVIDER = new Include("ProcessResponse:request-provider").toLocked();

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ProcessResponse setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ProcessResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ProcessResponseStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ProcessResponseStatus>(new ProcessResponseStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ProcessResponse setStatusElement(Enumeration<ProcessResponseStatus> value) {
        this.status = value;
        return this;
    }

    public ProcessResponseStatus getStatus() {
        return this.status == null ? null : (ProcessResponseStatus)((Object)this.status.getValue());
    }

    public ProcessResponse setStatus(ProcessResponseStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<ProcessResponseStatus>(new ProcessResponseStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public ProcessResponse setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public ProcessResponse setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public ProcessResponse setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public Organization getOrganizationTarget() {
        if (this.organizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organizationTarget = new Organization();
            }
        }
        return this.organizationTarget;
    }

    public ProcessResponse setOrganizationTarget(Organization value) {
        this.organizationTarget = value;
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public ProcessResponse setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public Resource getRequestTarget() {
        return this.requestTarget;
    }

    public ProcessResponse setRequestTarget(Resource value) {
        this.requestTarget = value;
        return this;
    }

    public CodeableConcept getOutcome() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new CodeableConcept();
            }
        }
        return this.outcome;
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public ProcessResponse setOutcome(CodeableConcept value) {
        this.outcome = value;
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public ProcessResponse setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public ProcessResponse setDisposition(String value) {
        if (Utilities.noString(value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public Reference getRequestProvider() {
        if (this.requestProvider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.requestProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.requestProvider = new Reference();
            }
        }
        return this.requestProvider;
    }

    public boolean hasRequestProvider() {
        return this.requestProvider != null && !this.requestProvider.isEmpty();
    }

    public ProcessResponse setRequestProvider(Reference value) {
        this.requestProvider = value;
        return this;
    }

    public Practitioner getRequestProviderTarget() {
        if (this.requestProviderTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.requestProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.requestProviderTarget = new Practitioner();
            }
        }
        return this.requestProviderTarget;
    }

    public ProcessResponse setRequestProviderTarget(Practitioner value) {
        this.requestProviderTarget = value;
        return this;
    }

    public Reference getRequestOrganization() {
        if (this.requestOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.requestOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.requestOrganization = new Reference();
            }
        }
        return this.requestOrganization;
    }

    public boolean hasRequestOrganization() {
        return this.requestOrganization != null && !this.requestOrganization.isEmpty();
    }

    public ProcessResponse setRequestOrganization(Reference value) {
        this.requestOrganization = value;
        return this;
    }

    public Organization getRequestOrganizationTarget() {
        if (this.requestOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.requestOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.requestOrganizationTarget = new Organization();
            }
        }
        return this.requestOrganizationTarget;
    }

    public ProcessResponse setRequestOrganizationTarget(Organization value) {
        this.requestOrganizationTarget = value;
        return this;
    }

    public CodeableConcept getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new CodeableConcept();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public ProcessResponse setForm(CodeableConcept value) {
        this.form = value;
        return this;
    }

    public List<ProcessResponseProcessNoteComponent> getProcessNote() {
        if (this.processNote == null) {
            this.processNote = new ArrayList<ProcessResponseProcessNoteComponent>();
        }
        return this.processNote;
    }

    public ProcessResponse setProcessNote(List<ProcessResponseProcessNoteComponent> theProcessNote) {
        this.processNote = theProcessNote;
        return this;
    }

    public boolean hasProcessNote() {
        if (this.processNote == null) {
            return false;
        }
        for (ProcessResponseProcessNoteComponent item : this.processNote) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProcessResponseProcessNoteComponent addProcessNote() {
        ProcessResponseProcessNoteComponent t = new ProcessResponseProcessNoteComponent();
        if (this.processNote == null) {
            this.processNote = new ArrayList<ProcessResponseProcessNoteComponent>();
        }
        this.processNote.add(t);
        return t;
    }

    public ProcessResponse addProcessNote(ProcessResponseProcessNoteComponent t) {
        if (t == null) {
            return this;
        }
        if (this.processNote == null) {
            this.processNote = new ArrayList<ProcessResponseProcessNoteComponent>();
        }
        this.processNote.add(t);
        return this;
    }

    public ProcessResponseProcessNoteComponent getProcessNoteFirstRep() {
        if (this.getProcessNote().isEmpty()) {
            this.addProcessNote();
        }
        return this.getProcessNote().get(0);
    }

    public List<CodeableConcept> getError() {
        if (this.error == null) {
            this.error = new ArrayList<CodeableConcept>();
        }
        return this.error;
    }

    public ProcessResponse setError(List<CodeableConcept> theError) {
        this.error = theError;
        return this;
    }

    public boolean hasError() {
        if (this.error == null) {
            return false;
        }
        for (CodeableConcept item : this.error) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addError() {
        CodeableConcept t = new CodeableConcept();
        if (this.error == null) {
            this.error = new ArrayList<CodeableConcept>();
        }
        this.error.add(t);
        return t;
    }

    public ProcessResponse addError(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.error == null) {
            this.error = new ArrayList<CodeableConcept>();
        }
        this.error.add(t);
        return this;
    }

    public CodeableConcept getErrorFirstRep() {
        if (this.getError().isEmpty()) {
            this.addError();
        }
        return this.getError().get(0);
    }

    public List<Reference> getCommunicationRequest() {
        if (this.communicationRequest == null) {
            this.communicationRequest = new ArrayList<Reference>();
        }
        return this.communicationRequest;
    }

    public ProcessResponse setCommunicationRequest(List<Reference> theCommunicationRequest) {
        this.communicationRequest = theCommunicationRequest;
        return this;
    }

    public boolean hasCommunicationRequest() {
        if (this.communicationRequest == null) {
            return false;
        }
        for (Reference item : this.communicationRequest) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addCommunicationRequest() {
        Reference t = new Reference();
        if (this.communicationRequest == null) {
            this.communicationRequest = new ArrayList<Reference>();
        }
        this.communicationRequest.add(t);
        return t;
    }

    public ProcessResponse addCommunicationRequest(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.communicationRequest == null) {
            this.communicationRequest = new ArrayList<Reference>();
        }
        this.communicationRequest.add(t);
        return this;
    }

    public Reference getCommunicationRequestFirstRep() {
        if (this.getCommunicationRequest().isEmpty()) {
            this.addCommunicationRequest();
        }
        return this.getCommunicationRequest().get(0);
    }

    @Deprecated
    public List<CommunicationRequest> getCommunicationRequestTarget() {
        if (this.communicationRequestTarget == null) {
            this.communicationRequestTarget = new ArrayList<CommunicationRequest>();
        }
        return this.communicationRequestTarget;
    }

    @Deprecated
    public CommunicationRequest addCommunicationRequestTarget() {
        CommunicationRequest r = new CommunicationRequest();
        if (this.communicationRequestTarget == null) {
            this.communicationRequestTarget = new ArrayList<CommunicationRequest>();
        }
        this.communicationRequestTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("status", "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property("created", "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, 1, this.created));
        children.add(new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization who produced this adjudicated response.", 0, 1, this.organization));
        children.add(new Property(SP_REQUEST, "Reference(Any)", "Original request resource reference.", 0, 1, this.request));
        children.add(new Property("outcome", "CodeableConcept", "Transaction status: error, complete, held.", 0, 1, this.outcome));
        children.add(new Property("disposition", "string", "A description of the status of the adjudication or processing.", 0, 1, this.disposition));
        children.add(new Property("requestProvider", "Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestProvider));
        children.add(new Property("requestOrganization", "Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, 1, this.requestOrganization));
        children.add(new Property("form", "CodeableConcept", "The form to be used for printing the content.", 0, 1, this.form));
        children.add(new Property("processNote", "", "Suite of processing notes or additional requirements if the processing has been held.", 0, Integer.MAX_VALUE, this.processNote));
        children.add(new Property("error", "CodeableConcept", "Processing errors.", 0, Integer.MAX_VALUE, this.error));
        children.add(new Property("communicationRequest", "Reference(CommunicationRequest)", "Request for additional supporting or authorizing information, such as: documents, images or resources.", 0, Integer.MAX_VALUE, this.communicationRequest));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property("status", "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 1028554472: {
                return new Property("created", "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, 1, this.created);
            }
            case 1178922291: {
                return new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization who produced this adjudicated response.", 0, 1, this.organization);
            }
            case 1095692943: {
                return new Property(SP_REQUEST, "Reference(Any)", "Original request resource reference.", 0, 1, this.request);
            }
            case -1106507950: {
                return new Property("outcome", "CodeableConcept", "Transaction status: error, complete, held.", 0, 1, this.outcome);
            }
            case 583380919: {
                return new Property("disposition", "string", "A description of the status of the adjudication or processing.", 0, 1, this.disposition);
            }
            case 1601527200: {
                return new Property("requestProvider", "Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestProvider);
            }
            case 599053666: {
                return new Property("requestOrganization", "Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, 1, this.requestOrganization);
            }
            case 3148996: {
                return new Property("form", "CodeableConcept", "The form to be used for printing the content.", 0, 1, this.form);
            }
            case 202339073: {
                return new Property("processNote", "", "Suite of processing notes or additional requirements if the processing has been held.", 0, Integer.MAX_VALUE, this.processNote);
            }
            case 96784904: {
                return new Property("error", "CodeableConcept", "Processing errors.", 0, Integer.MAX_VALUE, this.error);
            }
            case -2071896615: {
                return new Property("communicationRequest", "Reference(CommunicationRequest)", "Request for additional supporting or authorizing information, such as: documents, images or resources.", 0, Integer.MAX_VALUE, this.communicationRequest);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.created;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.organization;
                }
                return baseArray;
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.request;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.outcome;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.disposition;
                }
                return baseArray;
            }
            case 1601527200: {
                Base[] baseArray;
                if (this.requestProvider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.requestProvider;
                }
                return baseArray;
            }
            case 599053666: {
                Base[] baseArray;
                if (this.requestOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.requestOrganization;
                }
                return baseArray;
            }
            case 3148996: {
                Base[] baseArray;
                if (this.form == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.form;
                }
                return baseArray;
            }
            case 202339073: {
                return this.processNote == null ? new Base[]{} : this.processNote.toArray(new Base[this.processNote.size()]);
            }
            case 96784904: {
                return this.error == null ? new Base[]{} : this.error.toArray(new Base[this.error.size()]);
            }
            case -2071896615: {
                return this.communicationRequest == null ? new Base[]{} : this.communicationRequest.toArray(new Base[this.communicationRequest.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ProcessResponseStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case 1178922291: {
                this.organization = this.castToReference(value);
                return value;
            }
            case 1095692943: {
                this.request = this.castToReference(value);
                return value;
            }
            case -1106507950: {
                this.outcome = this.castToCodeableConcept(value);
                return value;
            }
            case 583380919: {
                this.disposition = this.castToString(value);
                return value;
            }
            case 1601527200: {
                this.requestProvider = this.castToReference(value);
                return value;
            }
            case 599053666: {
                this.requestOrganization = this.castToReference(value);
                return value;
            }
            case 3148996: {
                this.form = this.castToCodeableConcept(value);
                return value;
            }
            case 202339073: {
                this.getProcessNote().add((ProcessResponseProcessNoteComponent)((Object)value));
                return value;
            }
            case 96784904: {
                this.getError().add(this.castToCodeableConcept(value));
                return value;
            }
            case -2071896615: {
                this.getCommunicationRequest().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("status")) {
            value = new ProcessResponseStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("created")) {
            this.created = this.castToDateTime(value);
        } else if (name.equals(SP_ORGANIZATION)) {
            this.organization = this.castToReference(value);
        } else if (name.equals(SP_REQUEST)) {
            this.request = this.castToReference(value);
        } else if (name.equals("outcome")) {
            this.outcome = this.castToCodeableConcept(value);
        } else if (name.equals("disposition")) {
            this.disposition = this.castToString(value);
        } else if (name.equals("requestProvider")) {
            this.requestProvider = this.castToReference(value);
        } else if (name.equals("requestOrganization")) {
            this.requestOrganization = this.castToReference(value);
        } else if (name.equals("form")) {
            this.form = this.castToCodeableConcept(value);
        } else if (name.equals("processNote")) {
            this.getProcessNote().add((ProcessResponseProcessNoteComponent)((Object)value));
        } else if (name.equals("error")) {
            this.getError().add(this.castToCodeableConcept(value));
        } else if (name.equals("communicationRequest")) {
            this.getCommunicationRequest().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case 1178922291: {
                return this.getOrganization();
            }
            case 1095692943: {
                return this.getRequest();
            }
            case -1106507950: {
                return this.getOutcome();
            }
            case 583380919: {
                return this.getDispositionElement();
            }
            case 1601527200: {
                return this.getRequestProvider();
            }
            case 599053666: {
                return this.getRequestOrganization();
            }
            case 3148996: {
                return this.getForm();
            }
            case 202339073: {
                return this.addProcessNote();
            }
            case 96784904: {
                return this.addError();
            }
            case -2071896615: {
                return this.addCommunicationRequest();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case 1178922291: {
                return new String[]{"Reference"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -1106507950: {
                return new String[]{"CodeableConcept"};
            }
            case 583380919: {
                return new String[]{"string"};
            }
            case 1601527200: {
                return new String[]{"Reference"};
            }
            case 599053666: {
                return new String[]{"Reference"};
            }
            case 3148996: {
                return new String[]{"CodeableConcept"};
            }
            case 202339073: {
                return new String[0];
            }
            case 96784904: {
                return new String[]{"CodeableConcept"};
            }
            case -2071896615: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcessResponse.status");
        }
        if (name.equals("created")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcessResponse.created");
        }
        if (name.equals(SP_ORGANIZATION)) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals(SP_REQUEST)) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals("outcome")) {
            this.outcome = new CodeableConcept();
            return this.outcome;
        }
        if (name.equals("disposition")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcessResponse.disposition");
        }
        if (name.equals("requestProvider")) {
            this.requestProvider = new Reference();
            return this.requestProvider;
        }
        if (name.equals("requestOrganization")) {
            this.requestOrganization = new Reference();
            return this.requestOrganization;
        }
        if (name.equals("form")) {
            this.form = new CodeableConcept();
            return this.form;
        }
        if (name.equals("processNote")) {
            return this.addProcessNote();
        }
        if (name.equals("error")) {
            return this.addError();
        }
        if (name.equals("communicationRequest")) {
            return this.addCommunicationRequest();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ProcessResponse";
    }

    @Override
    public ProcessResponse copy() {
        ProcessResponse dst = new ProcessResponse();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.request = this.request == null ? null : this.request.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        dst.requestProvider = this.requestProvider == null ? null : this.requestProvider.copy();
        dst.requestOrganization = this.requestOrganization == null ? null : this.requestOrganization.copy();
        CodeableConcept codeableConcept = dst.form = this.form == null ? null : this.form.copy();
        if (this.processNote != null) {
            dst.processNote = new ArrayList<ProcessResponseProcessNoteComponent>();
            for (ProcessResponseProcessNoteComponent processResponseProcessNoteComponent : this.processNote) {
                dst.processNote.add(processResponseProcessNoteComponent.copy());
            }
        }
        if (this.error != null) {
            dst.error = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.error) {
                dst.error.add(codeableConcept2.copy());
            }
        }
        if (this.communicationRequest != null) {
            dst.communicationRequest = new ArrayList<Reference>();
            for (Reference reference : this.communicationRequest) {
                dst.communicationRequest.add(reference.copy());
            }
        }
        return dst;
    }

    protected ProcessResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ProcessResponse)) {
            return false;
        }
        ProcessResponse o = (ProcessResponse)other_;
        return ProcessResponse.compareDeep(this.identifier, o.identifier, true) && ProcessResponse.compareDeep(this.status, o.status, true) && ProcessResponse.compareDeep(this.created, o.created, true) && ProcessResponse.compareDeep(this.organization, o.organization, true) && ProcessResponse.compareDeep(this.request, o.request, true) && ProcessResponse.compareDeep(this.outcome, o.outcome, true) && ProcessResponse.compareDeep(this.disposition, o.disposition, true) && ProcessResponse.compareDeep(this.requestProvider, o.requestProvider, true) && ProcessResponse.compareDeep(this.requestOrganization, o.requestOrganization, true) && ProcessResponse.compareDeep(this.form, o.form, true) && ProcessResponse.compareDeep(this.processNote, o.processNote, true) && ProcessResponse.compareDeep(this.error, o.error, true) && ProcessResponse.compareDeep(this.communicationRequest, o.communicationRequest, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ProcessResponse)) {
            return false;
        }
        ProcessResponse o = (ProcessResponse)other_;
        return ProcessResponse.compareValues(this.status, o.status, true) && ProcessResponse.compareValues(this.created, o.created, true) && ProcessResponse.compareValues(this.disposition, o.disposition, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.status, this.created, this.organization, this.request, this.outcome, this.disposition, this.requestProvider, this.requestOrganization, this.form, this.processNote, this.error, this.communicationRequest);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ProcessResponse;
    }

    @Block
    public static class ProcessResponseProcessNoteComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="display | print | printoper", formalDefinition="The note purpose: Print/Display.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/note-type")
        protected CodeableConcept type;
        @Child(name="text", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Comment on the processing", formalDefinition="The note text.")
        protected StringType text;
        private static final long serialVersionUID = 874830709L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcessResponseProcessNoteComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ProcessResponseProcessNoteComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcessResponseProcessNoteComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public ProcessResponseProcessNoteComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public ProcessResponseProcessNoteComponent setText(String value) {
            if (Utilities.noString(value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The note purpose: Print/Display.", 0, 1, this.type));
            children.add(new Property("text", "string", "The note text.", 0, 1, this.text));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The note purpose: Print/Display.", 0, 1, this.type);
                }
                case 3556653: {
                    return new Property("text", "string", "The note text.", 0, 1, this.text);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.text;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 3556653: {
                    return this.getTextElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3556653: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type ProcessResponse.text");
            }
            return super.addChild(name);
        }

        @Override
        public ProcessResponseProcessNoteComponent copy() {
            ProcessResponseProcessNoteComponent dst = new ProcessResponseProcessNoteComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.text = this.text == null ? null : this.text.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcessResponseProcessNoteComponent)) {
                return false;
            }
            ProcessResponseProcessNoteComponent o = (ProcessResponseProcessNoteComponent)other_;
            return ProcessResponseProcessNoteComponent.compareDeep(this.type, o.type, true) && ProcessResponseProcessNoteComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcessResponseProcessNoteComponent)) {
                return false;
            }
            ProcessResponseProcessNoteComponent o = (ProcessResponseProcessNoteComponent)other_;
            return ProcessResponseProcessNoteComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.text);
        }

        @Override
        public String fhirType() {
            return "ProcessResponse.processNote";
        }
    }

    public static class ProcessResponseStatusEnumFactory
    implements EnumFactory<ProcessResponseStatus> {
        @Override
        public ProcessResponseStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ProcessResponseStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return ProcessResponseStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return ProcessResponseStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ProcessResponseStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ProcessResponseStatus code '" + codeString + "'");
        }

        public Enumeration<ProcessResponseStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ProcessResponseStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ProcessResponseStatus>(this, ProcessResponseStatus.ACTIVE);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ProcessResponseStatus>(this, ProcessResponseStatus.CANCELLED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ProcessResponseStatus>(this, ProcessResponseStatus.DRAFT);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ProcessResponseStatus>(this, ProcessResponseStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown ProcessResponseStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ProcessResponseStatus code) {
            if (code == ProcessResponseStatus.ACTIVE) {
                return "active";
            }
            if (code == ProcessResponseStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ProcessResponseStatus.DRAFT) {
                return "draft";
            }
            if (code == ProcessResponseStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ProcessResponseStatus code) {
            return code.getSystem();
        }
    }

    public static enum ProcessResponseStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static ProcessResponseStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ProcessResponseStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/fm-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The instance was entered in error.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

