/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.formats;

import java.io.IOException;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.XmlParserBase;
import org.hl7.fhir.dstu3.model.Account;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.AdverseEvent;
import org.hl7.fhir.dstu3.model.Age;
import org.hl7.fhir.dstu3.model.AllergyIntolerance;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Appointment;
import org.hl7.fhir.dstu3.model.AppointmentResponse;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.AuditEvent;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.Base64BinaryType;
import org.hl7.fhir.dstu3.model.Basic;
import org.hl7.fhir.dstu3.model.Binary;
import org.hl7.fhir.dstu3.model.BodySite;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.CapabilityStatement;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.CareTeam;
import org.hl7.fhir.dstu3.model.ChargeItem;
import org.hl7.fhir.dstu3.model.Claim;
import org.hl7.fhir.dstu3.model.ClaimResponse;
import org.hl7.fhir.dstu3.model.ClinicalImpression;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Communication;
import org.hl7.fhir.dstu3.model.CommunicationRequest;
import org.hl7.fhir.dstu3.model.CompartmentDefinition;
import org.hl7.fhir.dstu3.model.Composition;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Consent;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.Contract;
import org.hl7.fhir.dstu3.model.Contributor;
import org.hl7.fhir.dstu3.model.Count;
import org.hl7.fhir.dstu3.model.Coverage;
import org.hl7.fhir.dstu3.model.DataElement;
import org.hl7.fhir.dstu3.model.DataRequirement;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.DetectedIssue;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DeviceComponent;
import org.hl7.fhir.dstu3.model.DeviceMetric;
import org.hl7.fhir.dstu3.model.DeviceRequest;
import org.hl7.fhir.dstu3.model.DeviceUseStatement;
import org.hl7.fhir.dstu3.model.DiagnosticReport;
import org.hl7.fhir.dstu3.model.Distance;
import org.hl7.fhir.dstu3.model.DocumentManifest;
import org.hl7.fhir.dstu3.model.DocumentReference;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Dosage;
import org.hl7.fhir.dstu3.model.Duration;
import org.hl7.fhir.dstu3.model.Element;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.EligibilityRequest;
import org.hl7.fhir.dstu3.model.EligibilityResponse;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.Endpoint;
import org.hl7.fhir.dstu3.model.EnrollmentRequest;
import org.hl7.fhir.dstu3.model.EnrollmentResponse;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.ExpansionProfile;
import org.hl7.fhir.dstu3.model.ExplanationOfBenefit;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.ExtensionHelper;
import org.hl7.fhir.dstu3.model.FamilyMemberHistory;
import org.hl7.fhir.dstu3.model.Flag;
import org.hl7.fhir.dstu3.model.Goal;
import org.hl7.fhir.dstu3.model.GraphDefinition;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.GuidanceResponse;
import org.hl7.fhir.dstu3.model.HealthcareService;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.ImagingManifest;
import org.hl7.fhir.dstu3.model.ImagingStudy;
import org.hl7.fhir.dstu3.model.Immunization;
import org.hl7.fhir.dstu3.model.ImmunizationRecommendation;
import org.hl7.fhir.dstu3.model.ImplementationGuide;
import org.hl7.fhir.dstu3.model.InstantType;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.Linkage;
import org.hl7.fhir.dstu3.model.ListResource;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.Measure;
import org.hl7.fhir.dstu3.model.MeasureReport;
import org.hl7.fhir.dstu3.model.Media;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.dstu3.model.MedicationAdministration;
import org.hl7.fhir.dstu3.model.MedicationDispense;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.MedicationStatement;
import org.hl7.fhir.dstu3.model.MessageDefinition;
import org.hl7.fhir.dstu3.model.MessageHeader;
import org.hl7.fhir.dstu3.model.Meta;
import org.hl7.fhir.dstu3.model.Money;
import org.hl7.fhir.dstu3.model.NamingSystem;
import org.hl7.fhir.dstu3.model.Narrative;
import org.hl7.fhir.dstu3.model.NutritionOrder;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.OidType;
import org.hl7.fhir.dstu3.model.OperationDefinition;
import org.hl7.fhir.dstu3.model.OperationOutcome;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.ParameterDefinition;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.PaymentNotice;
import org.hl7.fhir.dstu3.model.PaymentReconciliation;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Person;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.PositiveIntType;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PractitionerRole;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.ProcessRequest;
import org.hl7.fhir.dstu3.model.ProcessResponse;
import org.hl7.fhir.dstu3.model.Provenance;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Ratio;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ReferralRequest;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.RequestGroup;
import org.hl7.fhir.dstu3.model.ResearchStudy;
import org.hl7.fhir.dstu3.model.ResearchSubject;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.RiskAssessment;
import org.hl7.fhir.dstu3.model.SampledData;
import org.hl7.fhir.dstu3.model.Schedule;
import org.hl7.fhir.dstu3.model.SearchParameter;
import org.hl7.fhir.dstu3.model.Sequence;
import org.hl7.fhir.dstu3.model.ServiceDefinition;
import org.hl7.fhir.dstu3.model.Signature;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.Slot;
import org.hl7.fhir.dstu3.model.Specimen;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.StructureMap;
import org.hl7.fhir.dstu3.model.Subscription;
import org.hl7.fhir.dstu3.model.Substance;
import org.hl7.fhir.dstu3.model.SupplyDelivery;
import org.hl7.fhir.dstu3.model.SupplyRequest;
import org.hl7.fhir.dstu3.model.Task;
import org.hl7.fhir.dstu3.model.TestReport;
import org.hl7.fhir.dstu3.model.TestScript;
import org.hl7.fhir.dstu3.model.TimeType;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.TriggerDefinition;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UnsignedIntType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.dstu3.model.UuidType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.model.VisionPrescription;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlParser
extends XmlParserBase {
    public XmlParser() {
    }

    public XmlParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    protected boolean parseElementContent(int eventType, XmlPullParser xpp, Element res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType != 2 || !xpp.getName().equals("extension")) {
            return false;
        }
        res.getExtension().add(this.parseExtension(xpp));
        return true;
    }

    protected boolean parseBackboneContent(int eventType, XmlPullParser xpp, BackboneElement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType != 2 || !xpp.getName().equals("modifierExtension")) {
            return this.parseElementContent(eventType, xpp, res);
        }
        res.getModifierExtension().add(this.parseExtension(xpp));
        return true;
    }

    protected <E extends Enum<E>> Enumeration<E> parseEnumeration(XmlPullParser xpp, E item, EnumFactory e) throws XmlPullParserException, IOException, FHIRFormatError {
        Enumeration res = new Enumeration(e);
        this.parseElementAttributes(xpp, res);
        res.setValue(e.fromCode(xpp.getAttributeValue(null, "value")));
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DateType parseDate(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DateType res = new DateType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DateTimeType parseDateTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DateTimeType res = new DateTimeType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CodeType parseCode(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeType res = new CodeType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StringType parseString(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        StringType res = new StringType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected IntegerType parseInteger(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        IntegerType res = new IntegerType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OidType parseOid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OidType res = new OidType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UriType parseUri(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UriType res = new UriType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UuidType parseUuid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UuidType res = new UuidType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected InstantType parseInstant(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InstantType res = new InstantType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected BooleanType parseBoolean(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BooleanType res = new BooleanType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Base64BinaryType parseBase64Binary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Base64BinaryType res = new Base64BinaryType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UnsignedIntType parseUnsignedInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UnsignedIntType res = new UnsignedIntType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MarkdownType parseMarkdown(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MarkdownType res = new MarkdownType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TimeType parseTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TimeType res = new TimeType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected IdType parseId(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        IdType res = new IdType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PositiveIntType parsePositiveInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PositiveIntType res = new PositiveIntType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DecimalType parseDecimal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DecimalType res = new DecimalType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Extension parseExtension(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Extension res = new Extension();
        this.parseElementAttributes(xpp, res);
        if (xpp.getAttributeValue(null, "url") != null) {
            res.setUrl(xpp.getAttributeValue(null, "url"));
        }
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExtensionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExtensionContent(int eventType, XmlPullParser xpp, Extension res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Narrative parseNarrative(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Narrative res = new Narrative();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNarrativeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNarrativeContent(int eventType, XmlPullParser xpp, Narrative res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("div")) {
            res.setDiv(this.parseXhtml(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Reference parseReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Reference res = new Reference();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseReferenceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseReferenceContent(int eventType, XmlPullParser xpp, Reference res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReferenceElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Quantity parseQuantity(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Quantity res = new Quantity();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseQuantityContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseQuantityContent(int eventType, XmlPullParser xpp, Quantity res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comparator")) {
            res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("unit")) {
            res.setUnitElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Period parsePeriod(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Period res = new Period();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePeriodContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePeriodContent(int eventType, XmlPullParser xpp, Period res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseDateTime(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Attachment parseAttachment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Attachment res = new Attachment();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAttachmentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAttachmentContent(int eventType, XmlPullParser xpp, Attachment res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("contentType")) {
            res.setContentTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.setDataElement(this.parseBase64Binary(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("size")) {
            res.setSizeElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hash")) {
            res.setHashElement(this.parseBase64Binary(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("creation")) {
            res.setCreationElement(this.parseDateTime(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Duration parseDuration(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Duration res = new Duration();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDurationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDurationContent(int eventType, XmlPullParser xpp, Duration res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseQuantityContent(eventType, xpp, res);
    }

    protected Count parseCount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Count res = new Count();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCountContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCountContent(int eventType, XmlPullParser xpp, Count res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseQuantityContent(eventType, xpp, res);
    }

    protected Range parseRange(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Range res = new Range();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRangeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRangeContent(int eventType, XmlPullParser xpp, Range res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("low")) {
            res.setLow(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("high")) {
            res.setHigh(this.parseSimpleQuantity(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Annotation parseAnnotation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Annotation res = new Annotation();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAnnotationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAnnotationContent(int eventType, XmlPullParser xpp, Annotation res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "author")) {
            res.setAuthor(this.parseType("author", xpp));
        } else if (eventType == 2 && xpp.getName().equals("time")) {
            res.setTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Money parseMoney(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Money res = new Money();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMoneyContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMoneyContent(int eventType, XmlPullParser xpp, Money res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseQuantityContent(eventType, xpp, res);
    }

    protected Identifier parseIdentifier(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Identifier res = new Identifier();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseIdentifierContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseIdentifierContent(int eventType, XmlPullParser xpp, Identifier res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("assigner")) {
            res.setAssigner(this.parseReference(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Coding parseCoding(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Coding res = new Coding();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodingContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodingContent(int eventType, XmlPullParser xpp, Coding res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("userSelected")) {
            res.setUserSelectedElement(this.parseBoolean(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Signature parseSignature(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Signature res = new Signature();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSignatureContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSignatureContent(int eventType, XmlPullParser xpp, Signature res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("when")) {
            res.setWhenElement(this.parseInstant(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "who")) {
            res.setWho(this.parseType("who", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "onBehalfOf")) {
            res.setOnBehalfOf(this.parseType("onBehalfOf", xpp));
        } else if (eventType == 2 && xpp.getName().equals("contentType")) {
            res.setContentTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("blob")) {
            res.setBlobElement(this.parseBase64Binary(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected SampledData parseSampledData(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SampledData res = new SampledData();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSampledDataContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSampledDataContent(int eventType, XmlPullParser xpp, SampledData res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("origin")) {
            res.setOrigin(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriodElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lowerLimit")) {
            res.setLowerLimitElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("upperLimit")) {
            res.setUpperLimitElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dimensions")) {
            res.setDimensionsElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.setDataElement(this.parseString(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Ratio parseRatio(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Ratio res = new Ratio();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRatioContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRatioContent(int eventType, XmlPullParser xpp, Ratio res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("numerator")) {
            res.setNumerator(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("denominator")) {
            res.setDenominator(this.parseQuantity(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Distance parseDistance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Distance res = new Distance();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDistanceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDistanceContent(int eventType, XmlPullParser xpp, Distance res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseQuantityContent(eventType, xpp, res);
    }

    protected Age parseAge(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Age res = new Age();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAgeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAgeContent(int eventType, XmlPullParser xpp, Age res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseQuantityContent(eventType, xpp, res);
    }

    protected CodeableConcept parseCodeableConcept(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeableConcept res = new CodeableConcept();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeableConceptContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeableConceptContent(int eventType, XmlPullParser xpp, CodeableConcept res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("coding")) {
            res.getCoding().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected SimpleQuantity parseSimpleQuantity(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SimpleQuantity res = new SimpleQuantity();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSimpleQuantityContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSimpleQuantityContent(int eventType, XmlPullParser xpp, SimpleQuantity res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comparator")) {
            res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("unit")) {
            res.setUnitElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Meta parseMeta(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Meta res = new Meta();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMetaContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMetaContent(int eventType, XmlPullParser xpp, Meta res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("versionId")) {
            res.setVersionIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastUpdated")) {
            res.setLastUpdatedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.getProfile().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("security")) {
            res.getSecurity().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tag")) {
            res.getTag().add(this.parseCoding(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Address parseAddress(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Address res = new Address();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAddressContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAddressContent(int eventType, XmlPullParser xpp, Address res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("line")) {
            res.getLine().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("city")) {
            res.setCityElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("district")) {
            res.setDistrictElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("state")) {
            res.setStateElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("postalCode")) {
            res.setPostalCodeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("country")) {
            res.setCountryElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TriggerDefinition parseTriggerDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TriggerDefinition res = new TriggerDefinition();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTriggerDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTriggerDefinitionContent(int eventType, XmlPullParser xpp, TriggerDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("eventName")) {
            res.setEventNameElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "eventTiming")) {
            res.setEventTiming(this.parseType("eventTiming", xpp));
        } else if (eventType == 2 && xpp.getName().equals("eventData")) {
            res.setEventData(this.parseDataRequirement(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contributor parseContributor(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contributor res = new Contributor();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContributorContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContributorContent(int eventType, XmlPullParser xpp, Contributor res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Contributor.ContributorType.NULL, new Contributor.ContributorTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DataRequirement parseDataRequirement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DataRequirement res = new DataRequirement();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDataRequirementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDataRequirementContent(int eventType, XmlPullParser xpp, DataRequirement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.getProfile().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mustSupport")) {
            res.getMustSupport().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("codeFilter")) {
            res.getCodeFilter().add(this.parseDataRequirementDataRequirementCodeFilterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("dateFilter")) {
            res.getDateFilter().add(this.parseDataRequirementDataRequirementDateFilterComponent(xpp, res));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementDataRequirementCodeFilterComponent(XmlPullParser xpp, DataRequirement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDataRequirementDataRequirementCodeFilterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDataRequirementDataRequirementCodeFilterComponentContent(int eventType, XmlPullParser xpp, DataRequirement owner, DataRequirement.DataRequirementCodeFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "valueSet")) {
            res.setValueSet(this.parseType("valueSet", xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueCode")) {
            res.getValueCode().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueCoding")) {
            res.getValueCoding().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueCodeableConcept")) {
            res.getValueCodeableConcept().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDataRequirementDateFilterComponent(XmlPullParser xpp, DataRequirement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDataRequirementDataRequirementDateFilterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDataRequirementDataRequirementDateFilterComponentContent(int eventType, XmlPullParser xpp, DataRequirement owner, DataRequirement.DataRequirementDateFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Dosage parseDosage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Dosage res = new Dosage();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDosageContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDosageContent(int eventType, XmlPullParser xpp, Dosage res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("additionalInstruction")) {
            res.getAdditionalInstruction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientInstruction")) {
            res.setPatientInstructionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("timing")) {
            res.setTiming(this.parseTiming(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "asNeeded")) {
            res.setAsNeeded(this.parseType("asNeeded", xpp));
        } else if (eventType == 2 && xpp.getName().equals("site")) {
            res.setSite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("route")) {
            res.setRoute(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("method")) {
            res.setMethod(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "dose")) {
            res.setDose(this.parseType("dose", xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxDosePerPeriod")) {
            res.setMaxDosePerPeriod(this.parseRatio(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxDosePerAdministration")) {
            res.setMaxDosePerAdministration(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxDosePerLifetime")) {
            res.setMaxDosePerLifetime(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
            res.setRate(this.parseType("rate", xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected RelatedArtifact parseRelatedArtifact(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        RelatedArtifact res = new RelatedArtifact();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRelatedArtifactContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRelatedArtifactContent(int eventType, XmlPullParser xpp, RelatedArtifact res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, RelatedArtifact.RelatedArtifactType.NULL, new RelatedArtifact.RelatedArtifactTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("citation")) {
            res.setCitationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("document")) {
            res.setDocument(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseReference(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ContactDetail parseContactDetail(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ContactDetail res = new ContactDetail();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContactDetailContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContactDetailContent(int eventType, XmlPullParser xpp, ContactDetail res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected HumanName parseHumanName(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        HumanName res = new HumanName();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseHumanNameContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseHumanNameContent(int eventType, XmlPullParser xpp, HumanName res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("family")) {
            res.setFamilyElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("given")) {
            res.getGiven().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("prefix")) {
            res.getPrefix().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("suffix")) {
            res.getSuffix().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ContactPoint parseContactPoint(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ContactPoint res = new ContactPoint();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContactPointContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContactPointContent(int eventType, XmlPullParser xpp, ContactPoint res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseEnumeration(xpp, ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("rank")) {
            res.setRankElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected UsageContext parseUsageContext(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UsageContext res = new UsageContext();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseUsageContextContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseUsageContextContent(int eventType, XmlPullParser xpp, UsageContext res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCoding(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Timing parseTiming(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Timing res = new Timing();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTimingContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTimingContent(int eventType, XmlPullParser xpp, Timing res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("event")) {
            res.getEvent().add(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("repeat")) {
            res.setRepeat(this.parseTimingTimingRepeatComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Timing.TimingRepeatComponent parseTimingTimingRepeatComponent(XmlPullParser xpp, Timing owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTimingTimingRepeatComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTimingTimingRepeatComponentContent(int eventType, XmlPullParser xpp, Timing owner, Timing.TimingRepeatComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "bounds")) {
            res.setBounds(this.parseType("bounds", xpp));
        } else if (eventType == 2 && xpp.getName().equals("count")) {
            res.setCountElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("countMax")) {
            res.setCountMaxElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("duration")) {
            res.setDurationElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("durationMax")) {
            res.setDurationMaxElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("durationUnit")) {
            res.setDurationUnitElement(this.parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("frequency")) {
            res.setFrequencyElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("frequencyMax")) {
            res.setFrequencyMaxElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriodElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("periodMax")) {
            res.setPeriodMaxElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("periodUnit")) {
            res.setPeriodUnitElement(this.parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("dayOfWeek")) {
            res.getDayOfWeek().add(this.parseEnumeration(xpp, Timing.DayOfWeek.NULL, new Timing.DayOfWeekEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("timeOfDay")) {
            res.getTimeOfDay().add(this.parseTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("when")) {
            res.getWhen().add(this.parseEnumeration(xpp, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("offset")) {
            res.setOffsetElement(this.parseUnsignedInt(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition parseElementDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition res = new ElementDefinition();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionContent(int eventType, XmlPullParser xpp, ElementDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("representation")) {
            res.getRepresentation().add(this.parseEnumeration(xpp, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("sliceName")) {
            res.setSliceNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("label")) {
            res.setLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("slicing")) {
            res.setSlicing(this.parseElementDefinitionElementDefinitionSlicingComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("short")) {
            res.setShortElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requirements")) {
            res.setRequirementsElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("alias")) {
            res.getAlias().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("base")) {
            res.setBase(this.parseElementDefinitionElementDefinitionBaseComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("contentReference")) {
            res.setContentReferenceElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseElementDefinitionTypeRefComponent(xpp, res));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "defaultValue")) {
            res.setDefaultValue(this.parseType("defaultValue", xpp));
        } else if (eventType == 2 && xpp.getName().equals("meaningWhenMissing")) {
            res.setMeaningWhenMissingElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("orderMeaning")) {
            res.setOrderMeaningElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "fixed")) {
            res.setFixed(this.parseType("fixed", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "pattern")) {
            res.setPattern(this.parseType("pattern", xpp));
        } else if (eventType == 2 && xpp.getName().equals("example")) {
            res.getExample().add(this.parseElementDefinitionElementDefinitionExampleComponent(xpp, res));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "minValue")) {
            res.setMinValue(this.parseType("minValue", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "maxValue")) {
            res.setMaxValue(this.parseType("maxValue", xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxLength")) {
            res.setMaxLengthElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("condition")) {
            res.getCondition().add(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("constraint")) {
            res.getConstraint().add(this.parseElementDefinitionElementDefinitionConstraintComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("mustSupport")) {
            res.setMustSupportElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("isModifier")) {
            res.setIsModifierElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("isSummary")) {
            res.setIsSummaryElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("binding")) {
            res.setBinding(this.parseElementDefinitionElementDefinitionBindingComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("mapping")) {
            res.getMapping().add(this.parseElementDefinitionElementDefinitionMappingComponent(xpp, res));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionElementDefinitionSlicingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionElementDefinitionSlicingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionElementDefinitionSlicingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("discriminator")) {
            res.getDiscriminator().add(this.parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ordered")) {
            res.setOrderedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rules")) {
            res.setRulesElement(this.parseEnumeration(xpp, ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, ElementDefinition.DiscriminatorType.NULL, new ElementDefinition.DiscriminatorTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionElementDefinitionBaseComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionElementDefinitionBaseComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionElementDefinitionBaseComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionBaseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionTypeRefComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionTypeRefComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.TypeRefComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetProfile")) {
            res.setTargetProfileElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("aggregation")) {
            res.getAggregation().add(this.parseEnumeration(xpp, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("versioning")) {
            res.setVersioningElement(this.parseEnumeration(xpp, ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionExampleComponent parseElementDefinitionElementDefinitionExampleComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionExampleComponent res = new ElementDefinition.ElementDefinitionExampleComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionElementDefinitionExampleComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionElementDefinitionExampleComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionExampleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("label")) {
            res.setLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionElementDefinitionConstraintComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionElementDefinitionConstraintComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionElementDefinitionConstraintComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionConstraintComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("key")) {
            res.setKeyElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requirements")) {
            res.setRequirementsElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverityElement(this.parseEnumeration(xpp, ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("human")) {
            res.setHumanElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("xpath")) {
            res.setXpathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSourceElement(this.parseUri(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionElementDefinitionBindingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionElementDefinitionBindingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionElementDefinitionBindingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionBindingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("strength")) {
            res.setStrengthElement(this.parseEnumeration(xpp, Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "valueSet")) {
            res.setValueSet(this.parseType("valueSet", xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionElementDefinitionMappingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionElementDefinitionMappingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionElementDefinitionMappingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionMappingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identity")) {
            res.setIdentityElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("map")) {
            res.setMapElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ParameterDefinition parseParameterDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ParameterDefinition res = new ParameterDefinition();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseParameterDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseParameterDefinitionContent(int eventType, XmlPullParser xpp, ParameterDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, ParameterDefinition.ParameterUse.NULL, new ParameterDefinition.ParameterUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfile(this.parseReference(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected void parseDomainResourceAttributes(XmlPullParser xpp, DomainResource res) throws XmlPullParserException, IOException, FHIRFormatError {
        this.parseResourceAttributes(xpp, res);
    }

    protected boolean parseDomainResourceContent(int eventType, XmlPullParser xpp, DomainResource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("text")) {
            res.setText(this.parseNarrative(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contained")) {
            res.getContained().add(this.parseResourceContained(xpp));
        } else if (eventType == 2 && xpp.getName().equals("extension")) {
            res.getExtension().add(this.parseExtension(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifierExtension")) {
            res.getModifierExtension().add(this.parseExtension(xpp));
        } else {
            return this.parseResourceContent(eventType, xpp, res);
        }
        return true;
    }

    protected Parameters parseParameters(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Parameters res = new Parameters();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseParametersContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseParametersContent(int eventType, XmlPullParser xpp, Parameters res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("parameter")) {
            res.getParameter().add(this.parseParametersParametersParameterComponent(xpp, res));
        } else if (!this.parseResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Parameters.ParametersParameterComponent parseParametersParametersParameterComponent(XmlPullParser xpp, Parameters owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Parameters.ParametersParameterComponent res = new Parameters.ParametersParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseParametersParametersParameterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseParametersParametersParameterComponentContent(int eventType, XmlPullParser xpp, Parameters owner, Parameters.ParametersParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseResourceContained(xpp));
        } else if (eventType == 2 && xpp.getName().equals("part")) {
            res.getPart().add(this.parseParametersParametersParameterComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected void parseResourceAttributes(XmlPullParser xpp, Resource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (!this.comments.isEmpty()) {
            res.getFormatCommentsPre().addAll(this.comments);
            this.comments.clear();
        }
    }

    protected boolean parseResourceContent(int eventType, XmlPullParser xpp, Resource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("id")) {
            res.setIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("meta")) {
            res.setMeta(this.parseMeta(xpp));
        } else if (eventType == 2 && xpp.getName().equals("implicitRules")) {
            res.setImplicitRulesElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else {
            return false;
        }
        return true;
    }

    protected Account parseAccount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Account res = new Account();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAccountContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAccountContent(int eventType, XmlPullParser xpp, Account res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActive(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("balance")) {
            res.setBalance(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.getCoverage().add(this.parseAccountCoverageComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("owner")) {
            res.setOwner(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("guarantor")) {
            res.getGuarantor().add(this.parseAccountGuarantorComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Account.CoverageComponent parseAccountCoverageComponent(XmlPullParser xpp, Account owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Account.CoverageComponent res = new Account.CoverageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAccountCoverageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAccountCoverageComponentContent(int eventType, XmlPullParser xpp, Account owner, Account.CoverageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parsePositiveInt(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Account.GuarantorComponent parseAccountGuarantorComponent(XmlPullParser xpp, Account owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Account.GuarantorComponent res = new Account.GuarantorComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAccountGuarantorComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAccountGuarantorComponentContent(int eventType, XmlPullParser xpp, Account owner, Account.GuarantorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onHold")) {
            res.setOnHoldElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ActivityDefinition parseActivityDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ActivityDefinition res = new ActivityDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseActivityDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseActivityDefinitionContent(int eventType, XmlPullParser xpp, ActivityDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.setUsageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributor")) {
            res.getContributor().add(this.parseContributor(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("library")) {
            res.getLibrary().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, ActivityDefinition.ActivityDefinitionKind.NULL, new ActivityDefinition.ActivityDefinitionKindEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseActivityDefinitionActivityDefinitionParticipantComponent(xpp, res));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "product")) {
            res.setProduct(this.parseType("product", xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dosage")) {
            res.getDosage().add(this.parseDosage(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.getBodySite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("transform")) {
            res.setTransform(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dynamicValue")) {
            res.getDynamicValue().add(this.parseActivityDefinitionActivityDefinitionDynamicValueComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ActivityDefinition.ActivityDefinitionParticipantComponent parseActivityDefinitionActivityDefinitionParticipantComponent(XmlPullParser xpp, ActivityDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ActivityDefinition.ActivityDefinitionParticipantComponent res = new ActivityDefinition.ActivityDefinitionParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseActivityDefinitionActivityDefinitionParticipantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseActivityDefinitionActivityDefinitionParticipantComponentContent(int eventType, XmlPullParser xpp, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, ActivityDefinition.ActivityParticipantType.NULL, new ActivityDefinition.ActivityParticipantTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ActivityDefinition.ActivityDefinitionDynamicValueComponent parseActivityDefinitionActivityDefinitionDynamicValueComponent(XmlPullParser xpp, ActivityDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ActivityDefinition.ActivityDefinitionDynamicValueComponent res = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseActivityDefinitionActivityDefinitionDynamicValueComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseActivityDefinitionActivityDefinitionDynamicValueComponentContent(int eventType, XmlPullParser xpp, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionDynamicValueComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdverseEvent parseAdverseEvent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AdverseEvent res = new AdverseEvent();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdverseEventContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdverseEventContent(int eventType, XmlPullParser xpp, AdverseEvent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategoryElement(this.parseEnumeration(xpp, AdverseEvent.AdverseEventCategory.NULL, new AdverseEvent.AdverseEventCategoryEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reaction")) {
            res.getReaction().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("seriousness")) {
            res.setSeriousness(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recorder")) {
            res.setRecorder(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("eventParticipant")) {
            res.setEventParticipant(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("suspectEntity")) {
            res.getSuspectEntity().add(this.parseAdverseEventAdverseEventSuspectEntityComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("subjectMedicalHistory")) {
            res.getSubjectMedicalHistory().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceDocument")) {
            res.getReferenceDocument().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("study")) {
            res.getStudy().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdverseEvent.AdverseEventSuspectEntityComponent parseAdverseEventAdverseEventSuspectEntityComponent(XmlPullParser xpp, AdverseEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AdverseEvent.AdverseEventSuspectEntityComponent res = new AdverseEvent.AdverseEventSuspectEntityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdverseEventAdverseEventSuspectEntityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdverseEventAdverseEventSuspectEntityComponentContent(int eventType, XmlPullParser xpp, AdverseEvent owner, AdverseEvent.AdverseEventSuspectEntityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("instance")) {
            res.setInstance(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("causality")) {
            res.setCausalityElement(this.parseEnumeration(xpp, AdverseEvent.AdverseEventCausality.NULL, new AdverseEvent.AdverseEventCausalityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("causalityAssessment")) {
            res.setCausalityAssessment(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("causalityProductRelatedness")) {
            res.setCausalityProductRelatednessElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("causalityMethod")) {
            res.setCausalityMethod(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("causalityAuthor")) {
            res.setCausalityAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("causalityResult")) {
            res.setCausalityResult(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AllergyIntolerance parseAllergyIntolerance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AllergyIntolerance res = new AllergyIntolerance();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAllergyIntoleranceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAllergyIntoleranceContent(int eventType, XmlPullParser xpp, AllergyIntolerance res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("clinicalStatus")) {
            res.setClinicalStatusElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceClinicalStatus.NULL, new AllergyIntolerance.AllergyIntoleranceClinicalStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("verificationStatus")) {
            res.setVerificationStatusElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceVerificationStatus.NULL, new AllergyIntolerance.AllergyIntoleranceVerificationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("criticality")) {
            res.setCriticalityElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "onset")) {
            res.setOnset(this.parseType("onset", xpp));
        } else if (eventType == 2 && xpp.getName().equals("assertedDate")) {
            res.setAssertedDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recorder")) {
            res.setRecorder(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("asserter")) {
            res.setAsserter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastOccurrence")) {
            res.setLastOccurrenceElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reaction")) {
            res.getReaction().add(this.parseAllergyIntoleranceAllergyIntoleranceReactionComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceAllergyIntoleranceReactionComponent(XmlPullParser xpp, AllergyIntolerance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAllergyIntoleranceAllergyIntoleranceReactionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAllergyIntoleranceAllergyIntoleranceReactionComponentContent(int eventType, XmlPullParser xpp, AllergyIntolerance owner, AllergyIntolerance.AllergyIntoleranceReactionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("substance")) {
            res.setSubstance(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manifestation")) {
            res.getManifestation().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onset")) {
            res.setOnsetElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverityElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("exposureRoute")) {
            res.setExposureRoute(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Appointment parseAppointment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Appointment res = new Appointment();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAppointmentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAppointmentContent(int eventType, XmlPullParser xpp, Appointment res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("serviceCategory")) {
            res.setServiceCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serviceType")) {
            res.getServiceType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialty")) {
            res.getSpecialty().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("appointmentType")) {
            res.setAppointmentType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("indication")) {
            res.getIndication().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.getSupportingInformation().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("minutesDuration")) {
            res.setMinutesDurationElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("slot")) {
            res.getSlot().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("incomingReferral")) {
            res.getIncomingReferral().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseAppointmentAppointmentParticipantComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("requestedPeriod")) {
            res.getRequestedPeriod().add(this.parsePeriod(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Appointment.AppointmentParticipantComponent parseAppointmentAppointmentParticipantComponent(XmlPullParser xpp, Appointment owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAppointmentAppointmentParticipantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAppointmentAppointmentParticipantComponentContent(int eventType, XmlPullParser xpp, Appointment owner, Appointment.AppointmentParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("required")) {
            res.setRequiredElement(this.parseEnumeration(xpp, Appointment.ParticipantRequired.NULL, new Appointment.ParticipantRequiredEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Appointment.ParticipationStatus.NULL, new Appointment.ParticipationStatusEnumFactory()));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AppointmentResponse parseAppointmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AppointmentResponse res = new AppointmentResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAppointmentResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAppointmentResponseContent(int eventType, XmlPullParser xpp, AppointmentResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("appointment")) {
            res.setAppointment(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participantType")) {
            res.getParticipantType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participantStatus")) {
            res.setParticipantStatusElement(this.parseEnumeration(xpp, AppointmentResponse.ParticipantStatus.NULL, new AppointmentResponse.ParticipantStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent parseAuditEvent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent res = new AuditEvent();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventContent(int eventType, XmlPullParser xpp, AuditEvent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtype")) {
            res.getSubtype().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.setActionElement(this.parseEnumeration(xpp, AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("recorded")) {
            res.setRecordedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(xpp, AuditEvent.AuditEventOutcome.NULL, new AuditEvent.AuditEventOutcomeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("outcomeDesc")) {
            res.setOutcomeDescElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purposeOfEvent")) {
            res.getPurposeOfEvent().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("agent")) {
            res.getAgent().add(this.parseAuditEventAuditEventAgentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseAuditEventAuditEventSourceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("entity")) {
            res.getEntity().add(this.parseAuditEventAuditEventEntityComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent.AuditEventAgentComponent parseAuditEventAuditEventAgentComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventAuditEventAgentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventAuditEventAgentComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventAgentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.getRole().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("userId")) {
            res.setUserId(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("altId")) {
            res.setAltIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestor")) {
            res.setRequestorElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("policy")) {
            res.getPolicy().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("media")) {
            res.setMedia(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.setNetwork(this.parseAuditEventAuditEventAgentNetworkComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("purposeOfUse")) {
            res.getPurposeOfUse().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent.AuditEventAgentNetworkComponent parseAuditEventAuditEventAgentNetworkComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventAgentNetworkComponent res = new AuditEvent.AuditEventAgentNetworkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventAuditEventAgentNetworkComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventAuditEventAgentNetworkComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventAgentNetworkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("address")) {
            res.setAddressElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, AuditEvent.AuditEventAgentNetworkType.NULL, new AuditEvent.AuditEventAgentNetworkTypeEnumFactory()));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent.AuditEventSourceComponent parseAuditEventAuditEventSourceComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventAuditEventSourceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventAuditEventSourceComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventSourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("site")) {
            res.setSiteElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCoding(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent.AuditEventEntityComponent parseAuditEventAuditEventEntityComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventAuditEventEntityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventAuditEventEntityComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventEntityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lifecycle")) {
            res.setLifecycle(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
            res.getSecurityLabel().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("query")) {
            res.setQueryElement(this.parseBase64Binary(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseAuditEventAuditEventEntityDetailComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventAuditEventEntityDetailComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventAuditEventEntityDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventAuditEventEntityDetailComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventEntityDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseBase64Binary(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Basic parseBasic(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Basic res = new Basic();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBasicContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBasicContent(int eventType, XmlPullParser xpp, Basic res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Binary parseBinary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Binary res = new Binary();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBinaryContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBinaryContent(int eventType, XmlPullParser xpp, Binary res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("contentType")) {
            res.setContentTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityContext")) {
            res.setSecurityContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.setContentElement(this.parseBase64Binary(xpp));
        } else if (!this.parseResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected BodySite parseBodySite(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BodySite res = new BodySite();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBodySiteContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBodySiteContent(int eventType, XmlPullParser xpp, BodySite res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("qualifier")) {
            res.getQualifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("image")) {
            res.getImage().add(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle parseBundle(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle res = new Bundle();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleContent(int eventType, XmlPullParser xpp, Bundle res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("total")) {
            res.setTotalElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parseBundleBundleLinkComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("entry")) {
            res.getEntry().add(this.parseBundleBundleEntryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("signature")) {
            res.setSignature(this.parseSignature(xpp));
        } else if (!this.parseResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle.BundleLinkComponent parseBundleBundleLinkComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleBundleLinkComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleBundleLinkComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("relation")) {
            res.setRelationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle.BundleEntryComponent parseBundleBundleEntryComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleBundleEntryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleBundleEntryComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parseBundleBundleLinkComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("fullUrl")) {
            res.setFullUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseResourceContained(xpp));
        } else if (eventType == 2 && xpp.getName().equals("search")) {
            res.setSearch(this.parseBundleBundleEntrySearchComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseBundleBundleEntryRequestComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("response")) {
            res.setResponse(this.parseBundleBundleEntryResponseComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle.BundleEntrySearchComponent parseBundleBundleEntrySearchComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleBundleEntrySearchComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleBundleEntrySearchComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntrySearchComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("score")) {
            res.setScoreElement(this.parseDecimal(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle.BundleEntryRequestComponent parseBundleBundleEntryRequestComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleBundleEntryRequestComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleBundleEntryRequestComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntryRequestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("method")) {
            res.setMethodElement(this.parseEnumeration(xpp, Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ifNoneMatch")) {
            res.setIfNoneMatchElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ifModifiedSince")) {
            res.setIfModifiedSinceElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ifMatch")) {
            res.setIfMatchElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ifNoneExist")) {
            res.setIfNoneExistElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle.BundleEntryResponseComponent parseBundleBundleEntryResponseComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleBundleEntryResponseComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleBundleEntryResponseComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntryResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocationElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("etag")) {
            res.setEtagElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastModified")) {
            res.setLastModifiedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseResourceContained(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement parseCapabilityStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement res = new CapabilityStatement();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementContent(int eventType, XmlPullParser xpp, CapabilityStatement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, CapabilityStatement.CapabilityStatementKind.NULL, new CapabilityStatement.CapabilityStatementKindEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("instantiates")) {
            res.getInstantiates().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("software")) {
            res.setSoftware(this.parseCapabilityStatementCapabilityStatementSoftwareComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("implementation")) {
            res.setImplementation(this.parseCapabilityStatementCapabilityStatementImplementationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("fhirVersion")) {
            res.setFhirVersionElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("acceptUnknown")) {
            res.setAcceptUnknownElement(this.parseEnumeration(xpp, CapabilityStatement.UnknownContentCode.NULL, new CapabilityStatement.UnknownContentCodeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("format")) {
            res.getFormat().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patchFormat")) {
            res.getPatchFormat().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("implementationGuide")) {
            res.getImplementationGuide().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.getProfile().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rest")) {
            res.getRest().add(this.parseCapabilityStatementCapabilityStatementRestComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("messaging")) {
            res.getMessaging().add(this.parseCapabilityStatementCapabilityStatementMessagingComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("document")) {
            res.getDocument().add(this.parseCapabilityStatementCapabilityStatementDocumentComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementSoftwareComponent parseCapabilityStatementCapabilityStatementSoftwareComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementSoftwareComponent res = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementSoftwareComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementSoftwareComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementSoftwareComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("releaseDate")) {
            res.setReleaseDateElement(this.parseDateTime(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementImplementationComponent parseCapabilityStatementCapabilityStatementImplementationComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementImplementationComponent res = new CapabilityStatement.CapabilityStatementImplementationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementImplementationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementImplementationComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementImplementationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestComponent parseCapabilityStatementCapabilityStatementRestComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestComponent res = new CapabilityStatement.CapabilityStatementRestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementRestComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementRestComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, CapabilityStatement.RestfulCapabilityMode.NULL, new CapabilityStatement.RestfulCapabilityModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("security")) {
            res.setSecurity(this.parseCapabilityStatementCapabilityStatementRestSecurityComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.getResource().add(this.parseCapabilityStatementCapabilityStatementRestResourceComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("interaction")) {
            res.getInteraction().add(this.parseCapabilityStatementSystemInteractionComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("searchParam")) {
            res.getSearchParam().add(this.parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("operation")) {
            res.getOperation().add(this.parseCapabilityStatementCapabilityStatementRestOperationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("compartment")) {
            res.getCompartment().add(this.parseUri(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestSecurityComponent parseCapabilityStatementCapabilityStatementRestSecurityComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestSecurityComponent res = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementRestSecurityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementRestSecurityComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestSecurityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("cors")) {
            res.setCorsElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.getService().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("certificate")) {
            res.getCertificate().add(this.parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent res = new CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("blob")) {
            res.setBlobElement(this.parseBase64Binary(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestResourceComponent parseCapabilityStatementCapabilityStatementRestResourceComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceComponent res = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementRestResourceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementRestResourceComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfile(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("interaction")) {
            res.getInteraction().add(this.parseCapabilityStatementResourceInteractionComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("versioning")) {
            res.setVersioningElement(this.parseEnumeration(xpp, CapabilityStatement.ResourceVersionPolicy.NULL, new CapabilityStatement.ResourceVersionPolicyEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("readHistory")) {
            res.setReadHistoryElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("updateCreate")) {
            res.setUpdateCreateElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("conditionalCreate")) {
            res.setConditionalCreateElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("conditionalRead")) {
            res.setConditionalReadElement(this.parseEnumeration(xpp, CapabilityStatement.ConditionalReadStatus.NULL, new CapabilityStatement.ConditionalReadStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("conditionalUpdate")) {
            res.setConditionalUpdateElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("conditionalDelete")) {
            res.setConditionalDeleteElement(this.parseEnumeration(xpp, CapabilityStatement.ConditionalDeleteStatus.NULL, new CapabilityStatement.ConditionalDeleteStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("referencePolicy")) {
            res.getReferencePolicy().add(this.parseEnumeration(xpp, CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("searchInclude")) {
            res.getSearchInclude().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("searchRevInclude")) {
            res.getSearchRevInclude().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("searchParam")) {
            res.getSearchParam().add(this.parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.ResourceInteractionComponent parseCapabilityStatementResourceInteractionComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.ResourceInteractionComponent res = new CapabilityStatement.ResourceInteractionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementResourceInteractionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementResourceInteractionComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.ResourceInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, CapabilityStatement.TypeRestfulInteraction.NULL, new CapabilityStatement.TypeRestfulInteractionEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.SystemInteractionComponent parseCapabilityStatementSystemInteractionComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.SystemInteractionComponent res = new CapabilityStatement.SystemInteractionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementSystemInteractionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementSystemInteractionComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.SystemInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, CapabilityStatement.SystemRestfulInteraction.NULL, new CapabilityStatement.SystemRestfulInteractionEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestOperationComponent parseCapabilityStatementCapabilityStatementRestOperationComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestOperationComponent res = new CapabilityStatement.CapabilityStatementRestOperationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementRestOperationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementRestOperationComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinition(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementMessagingComponent parseCapabilityStatementCapabilityStatementMessagingComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingComponent res = new CapabilityStatement.CapabilityStatementMessagingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementMessagingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementMessagingComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("reliableCache")) {
            res.setReliableCacheElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportedMessage")) {
            res.getSupportedMessage().add(this.parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("event")) {
            res.getEvent().add(this.parseCapabilityStatementCapabilityStatementMessagingEventComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementMessagingEndpointComponent parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent res = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementMessagingEndpointComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementMessagingEndpointComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingEndpointComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("protocol")) {
            res.setProtocol(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.setAddressElement(this.parseUri(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinition(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementMessagingEventComponent parseCapabilityStatementCapabilityStatementMessagingEventComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingEventComponent res = new CapabilityStatement.CapabilityStatementMessagingEventComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementMessagingEventComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementMessagingEventComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingEventComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategoryElement(this.parseEnumeration(xpp, CapabilityStatement.MessageSignificanceCategory.NULL, new CapabilityStatement.MessageSignificanceCategoryEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("focus")) {
            res.setFocusElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("response")) {
            res.setResponse(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementDocumentComponent parseCapabilityStatementCapabilityStatementDocumentComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementDocumentComponent res = new CapabilityStatement.CapabilityStatementDocumentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementDocumentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementDocumentComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementDocumentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, CapabilityStatement.DocumentMode.NULL, new CapabilityStatement.DocumentModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfile(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CarePlan parseCarePlan(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan res = new CarePlan();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCarePlanContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCarePlanContent(int eventType, XmlPullParser xpp, CarePlan res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.getDefinition().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("replaces")) {
            res.getReplaces().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, CarePlan.CarePlanStatus.NULL, new CarePlan.CarePlanStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntentElement(this.parseEnumeration(xpp, CarePlan.CarePlanIntent.NULL, new CarePlan.CarePlanIntentEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeam")) {
            res.getCareTeam().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("addresses")) {
            res.getAddresses().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("goal")) {
            res.getGoal().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("activity")) {
            res.getActivity().add(this.parseCarePlanCarePlanActivityComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CarePlan.CarePlanActivityComponent parseCarePlanCarePlanActivityComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCarePlanCarePlanActivityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCarePlanCarePlanActivityComponentContent(int eventType, XmlPullParser xpp, CarePlan owner, CarePlan.CarePlanActivityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("outcomeCodeableConcept")) {
            res.getOutcomeCodeableConcept().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcomeReference")) {
            res.getOutcomeReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("progress")) {
            res.getProgress().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.setDetail(this.parseCarePlanCarePlanActivityDetailComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CarePlan.CarePlanActivityDetailComponent parseCarePlanCarePlanActivityDetailComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCarePlanCarePlanActivityDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCarePlanCarePlanActivityDetailComponentContent(int eventType, XmlPullParser xpp, CarePlan owner, CarePlan.CarePlanActivityDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinition(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("goal")) {
            res.getGoal().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReasonElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("prohibited")) {
            res.setProhibitedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "scheduled")) {
            res.setScheduled(this.parseType("scheduled", xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "product")) {
            res.setProduct(this.parseType("product", xpp));
        } else if (eventType == 2 && xpp.getName().equals("dailyAmount")) {
            res.setDailyAmount(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CareTeam parseCareTeam(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CareTeam res = new CareTeam();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCareTeamContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCareTeamContent(int eventType, XmlPullParser xpp, CareTeam res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, CareTeam.CareTeamStatus.NULL, new CareTeam.CareTeamStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseCareTeamCareTeamParticipantComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
            res.getManagingOrganization().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CareTeam.CareTeamParticipantComponent parseCareTeamCareTeamParticipantComponent(XmlPullParser xpp, CareTeam owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCareTeamCareTeamParticipantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCareTeamCareTeamParticipantComponentContent(int eventType, XmlPullParser xpp, CareTeam owner, CareTeam.CareTeamParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("member")) {
            res.setMember(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ChargeItem parseChargeItem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ChargeItem res = new ChargeItem();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseChargeItemContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseChargeItemContent(int eventType, XmlPullParser xpp, ChargeItem res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.getDefinition().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ChargeItem.ChargeItemStatus.NULL, new ChargeItem.ChargeItemStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseChargeItemChargeItemParticipantComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("performingOrganization")) {
            res.setPerformingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestingOrganization")) {
            res.setRequestingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodysite")) {
            res.getBodysite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factorOverride")) {
            res.setFactorOverrideElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priceOverride")) {
            res.setPriceOverride(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("overrideReason")) {
            res.setOverrideReasonElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enterer")) {
            res.setEnterer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enteredDate")) {
            res.setEnteredDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.getService().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("account")) {
            res.getAccount().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.getSupportingInformation().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ChargeItem.ChargeItemParticipantComponent parseChargeItemChargeItemParticipantComponent(XmlPullParser xpp, ChargeItem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ChargeItem.ChargeItemParticipantComponent res = new ChargeItem.ChargeItemParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseChargeItemChargeItemParticipantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseChargeItemChargeItemParticipantComponentContent(int eventType, XmlPullParser xpp, ChargeItem owner, ChargeItem.ChargeItemParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim parseClaim(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim res = new Claim();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimContent(int eventType, XmlPullParser xpp, Claim res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Claim.ClaimStatus.NULL, new Claim.ClaimStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.getSubType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, Claim.Use.NULL, new Claim.UseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("billablePeriod")) {
            res.setBillablePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enterer")) {
            res.setEnterer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.setOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fundsReserve")) {
            res.setFundsReserve(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("related")) {
            res.getRelated().add(this.parseClaimRelatedClaimComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("prescription")) {
            res.setPrescription(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("originalPrescription")) {
            res.setOriginalPrescription(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payee")) {
            res.setPayee(this.parseClaimPayeeComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("referral")) {
            res.setReferral(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("facility")) {
            res.setFacility(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeam")) {
            res.getCareTeam().add(this.parseClaimCareTeamComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("information")) {
            res.getInformation().add(this.parseClaimSpecialConditionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
            res.getDiagnosis().add(this.parseClaimDiagnosisComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("procedure")) {
            res.getProcedure().add(this.parseClaimProcedureComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseClaimInsuranceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("accident")) {
            res.setAccident(this.parseClaimAccidentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("employmentImpacted")) {
            res.setEmploymentImpacted(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hospitalization")) {
            res.setHospitalization(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseClaimItemComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("total")) {
            res.setTotal(this.parseMoney(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.RelatedClaimComponent parseClaimRelatedClaimComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.RelatedClaimComponent res = new Claim.RelatedClaimComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimRelatedClaimComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimRelatedClaimComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.RelatedClaimComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("claim")) {
            res.setClaim(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseIdentifier(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.PayeeComponent parseClaimPayeeComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.PayeeComponent res = new Claim.PayeeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimPayeeComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimPayeeComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.PayeeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resourceType")) {
            res.setResourceType(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.CareTeamComponent parseClaimCareTeamComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.CareTeamComponent res = new Claim.CareTeamComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimCareTeamComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimCareTeamComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.CareTeamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("responsible")) {
            res.setResponsibleElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("qualification")) {
            res.setQualification(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.SpecialConditionComponent parseClaimSpecialConditionComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.SpecialConditionComponent res = new Claim.SpecialConditionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimSpecialConditionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimSpecialConditionComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.SpecialConditionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimDiagnosisComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimDiagnosisComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "diagnosis")) {
            res.setDiagnosis(this.parseType("diagnosis", xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("packageCode")) {
            res.setPackageCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.ProcedureComponent parseClaimProcedureComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.ProcedureComponent res = new Claim.ProcedureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimProcedureComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimProcedureComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.ProcedureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "procedure")) {
            res.setProcedure(this.parseType("procedure", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.InsuranceComponent parseClaimInsuranceComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.InsuranceComponent res = new Claim.InsuranceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimInsuranceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimInsuranceComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("focal")) {
            res.setFocalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
            res.getPreAuthRef().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("claimResponse")) {
            res.setClaimResponse(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.AccidentComponent parseClaimAccidentComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.AccidentComponent res = new Claim.AccidentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimAccidentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimAccidentComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.AccidentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.ItemComponent parseClaimItemComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.ItemComponent res = new Claim.ItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimItemComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeamLinkId")) {
            res.getCareTeamLinkId().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosisLinkId")) {
            res.getDiagnosisLinkId().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedureLinkId")) {
            res.getProcedureLinkId().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("informationLinkId")) {
            res.getInformationLinkId().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.setService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subSite")) {
            res.getSubSite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.getEncounter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseClaimDetailComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.DetailComponent parseClaimDetailComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.DetailComponent res = new Claim.DetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimDetailComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.DetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.setService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
            res.getSubDetail().add(this.parseClaimSubDetailComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.SubDetailComponent parseClaimSubDetailComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.SubDetailComponent res = new Claim.SubDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimSubDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimSubDetailComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.setService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse parseClaimResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse res = new ClaimResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseContent(int eventType, XmlPullParser xpp, ClaimResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ClaimResponse.ClaimResponseStatus.NULL, new ClaimResponse.ClaimResponseStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestProvider")) {
            res.setRequestProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("disposition")) {
            res.setDispositionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payeeType")) {
            res.setPayeeType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseClaimResponseItemComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("addItem")) {
            res.getAddItem().add(this.parseClaimResponseAddedItemComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("error")) {
            res.getError().add(this.parseClaimResponseErrorComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("totalCost")) {
            res.setTotalCost(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unallocDeductable")) {
            res.setUnallocDeductable(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("totalBenefit")) {
            res.setTotalBenefit(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payment")) {
            res.setPayment(this.parseClaimResponsePaymentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("reserved")) {
            res.setReserved(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("form")) {
            res.setForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("processNote")) {
            res.getProcessNote().add(this.parseClaimResponseNoteComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("communicationRequest")) {
            res.getCommunicationRequest().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseClaimResponseInsuranceComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.ItemComponent parseClaimResponseItemComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ItemComponent res = new ClaimResponse.ItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseItemComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseClaimResponseItemDetailComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.AdjudicationComponent parseClaimResponseAdjudicationComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AdjudicationComponent res = new ClaimResponse.AdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseAdjudicationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseAdjudicationComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.AdjudicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDecimal(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseItemDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseItemDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.ItemDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
            res.getSubDetail().add(this.parseClaimResponseSubDetailComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseSubDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseSubDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseAddedItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseAddedItemComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.AddedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
            res.getSequenceLinkId().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.setService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fee")) {
            res.setFee(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseClaimResponseAddedItemsDetailComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.AddedItemsDetailComponent parseClaimResponseAddedItemsDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemsDetailComponent res = new ClaimResponse.AddedItemsDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseAddedItemsDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseAddedItemsDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.AddedItemsDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.setService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fee")) {
            res.setFee(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.ErrorComponent parseClaimResponseErrorComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ErrorComponent res = new ClaimResponse.ErrorComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseErrorComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseErrorComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.ErrorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detailSequenceLinkId")) {
            res.setDetailSequenceLinkIdElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subdetailSequenceLinkId")) {
            res.setSubdetailSequenceLinkIdElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.PaymentComponent parseClaimResponsePaymentComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.PaymentComponent res = new ClaimResponse.PaymentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponsePaymentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponsePaymentComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.PaymentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjustment")) {
            res.setAdjustment(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjustmentReason")) {
            res.setAdjustmentReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.NoteComponent parseClaimResponseNoteComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.NoteComponent res = new ClaimResponse.NoteComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseNoteComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseNoteComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.NoteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("number")) {
            res.setNumberElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.InsuranceComponent parseClaimResponseInsuranceComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.InsuranceComponent res = new ClaimResponse.InsuranceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseInsuranceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseInsuranceComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("focal")) {
            res.setFocalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
            res.getPreAuthRef().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("claimResponse")) {
            res.setClaimResponse(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalImpression parseClinicalImpression(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression res = new ClinicalImpression();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalImpressionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalImpressionContent(int eventType, XmlPullParser xpp, ClinicalImpression res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ClinicalImpression.ClinicalImpressionStatus.NULL, new ClinicalImpression.ClinicalImpressionStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
            res.setEffective(this.parseType("effective", xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("assessor")) {
            res.setAssessor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("previous")) {
            res.setPrevious(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("problem")) {
            res.getProblem().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("investigation")) {
            res.getInvestigation().add(this.parseClinicalImpressionClinicalImpressionInvestigationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("protocol")) {
            res.getProtocol().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("summary")) {
            res.setSummaryElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("finding")) {
            res.getFinding().add(this.parseClinicalImpressionClinicalImpressionFindingComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("prognosisCodeableConcept")) {
            res.getPrognosisCodeableConcept().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("prognosisReference")) {
            res.getPrognosisReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalImpression.ClinicalImpressionInvestigationComponent parseClinicalImpressionClinicalImpressionInvestigationComponent(XmlPullParser xpp, ClinicalImpression owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionInvestigationComponent res = new ClinicalImpression.ClinicalImpressionInvestigationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalImpressionClinicalImpressionInvestigationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalImpressionClinicalImpressionInvestigationComponentContent(int eventType, XmlPullParser xpp, ClinicalImpression owner, ClinicalImpression.ClinicalImpressionInvestigationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionClinicalImpressionFindingComponent(XmlPullParser xpp, ClinicalImpression owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalImpressionClinicalImpressionFindingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalImpressionClinicalImpressionFindingComponentContent(int eventType, XmlPullParser xpp, ClinicalImpression owner, ClinicalImpression.ClinicalImpressionFindingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "item")) {
            res.setItem(this.parseType("item", xpp));
        } else if (eventType == 2 && xpp.getName().equals("basis")) {
            res.setBasisElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem parseCodeSystem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem res = new CodeSystem();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemContent(int eventType, XmlPullParser xpp, CodeSystem res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("caseSensitive")) {
            res.setCaseSensitiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueSet")) {
            res.setValueSetElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hierarchyMeaning")) {
            res.setHierarchyMeaningElement(this.parseEnumeration(xpp, CodeSystem.CodeSystemHierarchyMeaning.NULL, new CodeSystem.CodeSystemHierarchyMeaningEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("compositional")) {
            res.setCompositionalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("versionNeeded")) {
            res.setVersionNeededElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.setContentElement(this.parseEnumeration(xpp, CodeSystem.CodeSystemContentMode.NULL, new CodeSystem.CodeSystemContentModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("count")) {
            res.setCountElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("filter")) {
            res.getFilter().add(this.parseCodeSystemCodeSystemFilterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("property")) {
            res.getProperty().add(this.parseCodeSystemPropertyComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("concept")) {
            res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem.CodeSystemFilterComponent parseCodeSystemCodeSystemFilterComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemCodeSystemFilterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemCodeSystemFilterComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.CodeSystemFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operator")) {
            res.getOperator().add(this.parseEnumeration(xpp, CodeSystem.FilterOperator.NULL, new CodeSystem.FilterOperatorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem.PropertyComponent parseCodeSystemPropertyComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.PropertyComponent res = new CodeSystem.PropertyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemPropertyComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemPropertyComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.PropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("uri")) {
            res.setUriElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemConceptDefinitionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemConceptDefinitionComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.ConceptDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("designation")) {
            res.getDesignation().add(this.parseCodeSystemConceptDefinitionDesignationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("property")) {
            res.getProperty().add(this.parseCodeSystemConceptPropertyComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("concept")) {
            res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemConceptDefinitionDesignationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemConceptDefinitionDesignationComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.ConceptDefinitionDesignationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUse(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem.ConceptPropertyComponent parseCodeSystemConceptPropertyComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.ConceptPropertyComponent res = new CodeSystem.ConceptPropertyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemConceptPropertyComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemConceptPropertyComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.ConceptPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Communication parseCommunication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Communication res = new Communication();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCommunicationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCommunicationContent(int eventType, XmlPullParser xpp, Communication res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.getDefinition().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Communication.CommunicationStatus.NULL, new Communication.CommunicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("notDone")) {
            res.setNotDoneElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("notDoneReason")) {
            res.setNotDoneReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("medium")) {
            res.getMedium().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recipient")) {
            res.getRecipient().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sent")) {
            res.setSentElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("received")) {
            res.setReceivedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sender")) {
            res.setSender(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payload")) {
            res.getPayload().add(this.parseCommunicationCommunicationPayloadComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Communication.CommunicationPayloadComponent parseCommunicationCommunicationPayloadComponent(XmlPullParser xpp, Communication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCommunicationCommunicationPayloadComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCommunicationCommunicationPayloadComponentContent(int eventType, XmlPullParser xpp, Communication owner, Communication.CommunicationPayloadComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
            res.setContent(this.parseType("content", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CommunicationRequest parseCommunicationRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CommunicationRequest res = new CommunicationRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCommunicationRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCommunicationRequestContent(int eventType, XmlPullParser xpp, CommunicationRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("replaces")) {
            res.getReplaces().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, CommunicationRequest.CommunicationRequestStatus.NULL, new CommunicationRequest.CommunicationRequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, CommunicationRequest.CommunicationPriority.NULL, new CommunicationRequest.CommunicationPriorityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("medium")) {
            res.getMedium().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recipient")) {
            res.getRecipient().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payload")) {
            res.getPayload().add(this.parseCommunicationRequestCommunicationRequestPayloadComponent(xpp, res));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sender")) {
            res.setSender(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requester")) {
            res.setRequester(this.parseCommunicationRequestCommunicationRequestRequesterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestCommunicationRequestPayloadComponent(XmlPullParser xpp, CommunicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCommunicationRequestCommunicationRequestPayloadComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCommunicationRequestCommunicationRequestPayloadComponentContent(int eventType, XmlPullParser xpp, CommunicationRequest owner, CommunicationRequest.CommunicationRequestPayloadComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
            res.setContent(this.parseType("content", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CommunicationRequest.CommunicationRequestRequesterComponent parseCommunicationRequestCommunicationRequestRequesterComponent(XmlPullParser xpp, CommunicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CommunicationRequest.CommunicationRequestRequesterComponent res = new CommunicationRequest.CommunicationRequestRequesterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCommunicationRequestCommunicationRequestRequesterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCommunicationRequestCommunicationRequestRequesterComponentContent(int eventType, XmlPullParser xpp, CommunicationRequest owner, CommunicationRequest.CommunicationRequestRequesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("agent")) {
            res.setAgent(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CompartmentDefinition parseCompartmentDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CompartmentDefinition res = new CompartmentDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompartmentDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompartmentDefinitionContent(int eventType, XmlPullParser xpp, CompartmentDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, CompartmentDefinition.CompartmentType.NULL, new CompartmentDefinition.CompartmentTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("search")) {
            res.setSearchElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.getResource().add(this.parseCompartmentDefinitionCompartmentDefinitionResourceComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionCompartmentDefinitionResourceComponent(XmlPullParser xpp, CompartmentDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompartmentDefinitionCompartmentDefinitionResourceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompartmentDefinitionCompartmentDefinitionResourceComponentContent(int eventType, XmlPullParser xpp, CompartmentDefinition owner, CompartmentDefinition.CompartmentDefinitionResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("param")) {
            res.getParam().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Composition parseComposition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition res = new Composition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompositionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompositionContent(int eventType, XmlPullParser xpp, Composition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Composition.CompositionStatus.NULL, new Composition.CompositionStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("class")) {
            res.setClass_(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("confidentiality")) {
            res.setConfidentialityElement(this.parseEnumeration(xpp, Composition.DocumentConfidentiality.NULL, new Composition.DocumentConfidentialityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("attester")) {
            res.getAttester().add(this.parseCompositionCompositionAttesterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("custodian")) {
            res.setCustodian(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatesTo")) {
            res.getRelatesTo().add(this.parseCompositionCompositionRelatesToComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("event")) {
            res.getEvent().add(this.parseCompositionCompositionEventComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("section")) {
            res.getSection().add(this.parseCompositionSectionComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Composition.CompositionAttesterComponent parseCompositionCompositionAttesterComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompositionCompositionAttesterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompositionCompositionAttesterComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.CompositionAttesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.getMode().add(this.parseEnumeration(xpp, Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("time")) {
            res.setTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Composition.CompositionRelatesToComponent parseCompositionCompositionRelatesToComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.CompositionRelatesToComponent res = new Composition.CompositionRelatesToComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompositionCompositionRelatesToComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompositionCompositionRelatesToComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.CompositionRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, Composition.DocumentRelationshipType.NULL, new Composition.DocumentRelationshipTypeEnumFactory()));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "target")) {
            res.setTarget(this.parseType("target", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Composition.CompositionEventComponent parseCompositionCompositionEventComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompositionCompositionEventComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompositionCompositionEventComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.CompositionEventComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Composition.SectionComponent parseCompositionSectionComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.SectionComponent res = new Composition.SectionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompositionSectionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompositionSectionComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.SectionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setText(this.parseNarrative(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, Composition.SectionMode.NULL, new Composition.SectionModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entry")) {
            res.getEntry().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("section")) {
            res.getSection().add(this.parseCompositionSectionComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap parseConceptMap(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap res = new ConceptMap();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapContent(int eventType, XmlPullParser xpp, ConceptMap res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "source")) {
            res.setSource(this.parseType("source", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "target")) {
            res.setTarget(this.parseType("target", xpp));
        } else if (eventType == 2 && xpp.getName().equals("group")) {
            res.getGroup().add(this.parseConceptMapConceptMapGroupComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap.ConceptMapGroupComponent parseConceptMapConceptMapGroupComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.ConceptMapGroupComponent res = new ConceptMap.ConceptMapGroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapConceptMapGroupComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapConceptMapGroupComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.ConceptMapGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSourceElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sourceVersion")) {
            res.setSourceVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTargetElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetVersion")) {
            res.setTargetVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("element")) {
            res.getElement().add(this.parseConceptMapSourceElementComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("unmapped")) {
            res.setUnmapped(this.parseConceptMapConceptMapGroupUnmappedComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapSourceElementComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapSourceElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.SourceElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.getTarget().add(this.parseConceptMapTargetElementComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapTargetElementComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapTargetElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.TargetElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("equivalence")) {
            res.setEquivalenceElement(this.parseEnumeration(xpp, Enumerations.ConceptMapEquivalence.NULL, new Enumerations.ConceptMapEquivalenceEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dependsOn")) {
            res.getDependsOn().add(this.parseConceptMapOtherElementComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("product")) {
            res.getProduct().add(this.parseConceptMapOtherElementComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapOtherElementComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapOtherElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.OtherElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("property")) {
            res.setPropertyElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap.ConceptMapGroupUnmappedComponent parseConceptMapConceptMapGroupUnmappedComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.ConceptMapGroupUnmappedComponent res = new ConceptMap.ConceptMapGroupUnmappedComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapConceptMapGroupUnmappedComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapConceptMapGroupUnmappedComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.ConceptMapGroupUnmappedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, ConceptMap.ConceptMapGroupUnmappedMode.NULL, new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Condition parseCondition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Condition res = new Condition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConditionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConditionContent(int eventType, XmlPullParser xpp, Condition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("clinicalStatus")) {
            res.setClinicalStatusElement(this.parseEnumeration(xpp, Condition.ConditionClinicalStatus.NULL, new Condition.ConditionClinicalStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("verificationStatus")) {
            res.setVerificationStatusElement(this.parseEnumeration(xpp, Condition.ConditionVerificationStatus.NULL, new Condition.ConditionVerificationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverity(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.getBodySite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "onset")) {
            res.setOnset(this.parseType("onset", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "abatement")) {
            res.setAbatement(this.parseType("abatement", xpp));
        } else if (eventType == 2 && xpp.getName().equals("assertedDate")) {
            res.setAssertedDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("asserter")) {
            res.setAsserter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("stage")) {
            res.setStage(this.parseConditionConditionStageComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("evidence")) {
            res.getEvidence().add(this.parseConditionConditionEvidenceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Condition.ConditionStageComponent parseConditionConditionStageComponent(XmlPullParser xpp, Condition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConditionConditionStageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConditionConditionStageComponentContent(int eventType, XmlPullParser xpp, Condition owner, Condition.ConditionStageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("summary")) {
            res.setSummary(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("assessment")) {
            res.getAssessment().add(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Condition.ConditionEvidenceComponent parseConditionConditionEvidenceComponent(XmlPullParser xpp, Condition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConditionConditionEvidenceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConditionConditionEvidenceComponentContent(int eventType, XmlPullParser xpp, Condition owner, Condition.ConditionEvidenceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent parseConsent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent res = new Consent();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentContent(int eventType, XmlPullParser xpp, Consent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Consent.ConsentState.NULL, new Consent.ConsentStateEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dateTime")) {
            res.setDateTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("consentingParty")) {
            res.getConsentingParty().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.getActor().add(this.parseConsentConsentActorComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.getOrganization().add(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "source")) {
            res.setSource(this.parseType("source", xpp));
        } else if (eventType == 2 && xpp.getName().equals("policy")) {
            res.getPolicy().add(this.parseConsentConsentPolicyComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("policyRule")) {
            res.setPolicyRuleElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
            res.getSecurityLabel().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.getPurpose().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dataPeriod")) {
            res.setDataPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.getData().add(this.parseConsentConsentDataComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("except")) {
            res.getExcept().add(this.parseConsentExceptComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.ConsentActorComponent parseConsentConsentActorComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.ConsentActorComponent res = new Consent.ConsentActorComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentConsentActorComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentConsentActorComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.ConsentActorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.ConsentPolicyComponent parseConsentConsentPolicyComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.ConsentPolicyComponent res = new Consent.ConsentPolicyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentConsentPolicyComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentConsentPolicyComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.ConsentPolicyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("authority")) {
            res.setAuthorityElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("uri")) {
            res.setUriElement(this.parseUri(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.ConsentDataComponent parseConsentConsentDataComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.ConsentDataComponent res = new Consent.ConsentDataComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentConsentDataComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentConsentDataComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.ConsentDataComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("meaning")) {
            res.setMeaningElement(this.parseEnumeration(xpp, Consent.ConsentDataMeaning.NULL, new Consent.ConsentDataMeaningEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.ExceptComponent parseConsentExceptComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.ExceptComponent res = new Consent.ExceptComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentExceptComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentExceptComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.ExceptComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Consent.ConsentExceptType.NULL, new Consent.ConsentExceptTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.getActor().add(this.parseConsentExceptActorComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
            res.getSecurityLabel().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.getPurpose().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("class")) {
            res.getClass_().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dataPeriod")) {
            res.setDataPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.getData().add(this.parseConsentExceptDataComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.ExceptActorComponent parseConsentExceptActorComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.ExceptActorComponent res = new Consent.ExceptActorComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentExceptActorComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentExceptActorComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.ExceptActorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.ExceptDataComponent parseConsentExceptDataComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.ExceptDataComponent res = new Consent.ExceptDataComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentExceptDataComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentExceptDataComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.ExceptDataComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("meaning")) {
            res.setMeaningElement(this.parseEnumeration(xpp, Consent.ConsentDataMeaning.NULL, new Consent.ConsentDataMeaningEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract parseContract(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract res = new Contract();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractContent(int eventType, XmlPullParser xpp, Contract res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Contract.ContractStatus.NULL, new Contract.ContractStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("issued")) {
            res.setIssuedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("applies")) {
            res.setApplies(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.getSubject().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authority")) {
            res.getAuthority().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("domain")) {
            res.getDomain().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.getSubType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actionReason")) {
            res.getActionReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decisionType")) {
            res.setDecisionType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contentDerivative")) {
            res.setContentDerivative(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
            res.getSecurityLabel().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("agent")) {
            res.getAgent().add(this.parseContractAgentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("signer")) {
            res.getSigner().add(this.parseContractSignatoryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("valuedItem")) {
            res.getValuedItem().add(this.parseContractValuedItemComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("term")) {
            res.getTerm().add(this.parseContractTermComponent(xpp, res));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "binding")) {
            res.setBinding(this.parseType("binding", xpp));
        } else if (eventType == 2 && xpp.getName().equals("friendly")) {
            res.getFriendly().add(this.parseContractFriendlyLanguageComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("legal")) {
            res.getLegal().add(this.parseContractLegalLanguageComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("rule")) {
            res.getRule().add(this.parseContractComputableLanguageComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.AgentComponent parseContractAgentComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.AgentComponent res = new Contract.AgentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractAgentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractAgentComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.AgentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.getRole().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.SignatoryComponent parseContractSignatoryComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.SignatoryComponent res = new Contract.SignatoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractSignatoryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractSignatoryComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.SignatoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("signature")) {
            res.getSignature().add(this.parseSignature(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ValuedItemComponent parseContractValuedItemComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractValuedItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractValuedItemComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ValuedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "entity")) {
            res.setEntity(this.parseType("entity", xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectiveTime")) {
            res.setEffectiveTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("points")) {
            res.setPointsElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.TermComponent parseContractTermComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.TermComponent res = new Contract.TermComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractTermComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractTermComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.TermComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issued")) {
            res.setIssuedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("applies")) {
            res.setApplies(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.setSubType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actionReason")) {
            res.getActionReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
            res.getSecurityLabel().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("agent")) {
            res.getAgent().add(this.parseContractTermAgentComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valuedItem")) {
            res.getValuedItem().add(this.parseContractTermValuedItemComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("group")) {
            res.getGroup().add(this.parseContractTermComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.TermAgentComponent parseContractTermAgentComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.TermAgentComponent res = new Contract.TermAgentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractTermAgentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractTermAgentComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.TermAgentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.getRole().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.TermValuedItemComponent parseContractTermValuedItemComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.TermValuedItemComponent res = new Contract.TermValuedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractTermValuedItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractTermValuedItemComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.TermValuedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "entity")) {
            res.setEntity(this.parseType("entity", xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectiveTime")) {
            res.setEffectiveTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("points")) {
            res.setPointsElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractFriendlyLanguageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractFriendlyLanguageComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.FriendlyLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
            res.setContent(this.parseType("content", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractLegalLanguageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractLegalLanguageComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.LegalLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
            res.setContent(this.parseType("content", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractComputableLanguageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractComputableLanguageComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ComputableLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
            res.setContent(this.parseType("content", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Coverage parseCoverage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Coverage res = new Coverage();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageContent(int eventType, XmlPullParser xpp, Coverage res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Coverage.CoverageStatus.NULL, new Coverage.CoverageStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("policyHolder")) {
            res.setPolicyHolder(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subscriber")) {
            res.setSubscriber(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subscriberId")) {
            res.setSubscriberIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("beneficiary")) {
            res.setBeneficiary(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payor")) {
            res.getPayor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("grouping")) {
            res.setGrouping(this.parseCoverageGroupComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("dependent")) {
            res.setDependentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("order")) {
            res.setOrderElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.setNetworkElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contract")) {
            res.getContract().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Coverage.GroupComponent parseCoverageGroupComponent(XmlPullParser xpp, Coverage owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Coverage.GroupComponent res = new Coverage.GroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageGroupComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageGroupComponentContent(int eventType, XmlPullParser xpp, Coverage owner, Coverage.GroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("group")) {
            res.setGroupElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupDisplay")) {
            res.setGroupDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subGroup")) {
            res.setSubGroupElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subGroupDisplay")) {
            res.setSubGroupDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("plan")) {
            res.setPlanElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("planDisplay")) {
            res.setPlanDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subPlan")) {
            res.setSubPlanElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subPlanDisplay")) {
            res.setSubPlanDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("class")) {
            res.setClass_Element(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classDisplay")) {
            res.setClassDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subClass")) {
            res.setSubClassElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subClassDisplay")) {
            res.setSubClassDisplayElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DataElement parseDataElement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DataElement res = new DataElement();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDataElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDataElementContent(int eventType, XmlPullParser xpp, DataElement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("stringency")) {
            res.setStringencyElement(this.parseEnumeration(xpp, DataElement.DataElementStringency.NULL, new DataElement.DataElementStringencyEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("mapping")) {
            res.getMapping().add(this.parseDataElementDataElementMappingComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("element")) {
            res.getElement().add(this.parseElementDefinition(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DataElement.DataElementMappingComponent parseDataElementDataElementMappingComponent(XmlPullParser xpp, DataElement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DataElement.DataElementMappingComponent res = new DataElement.DataElementMappingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDataElementDataElementMappingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDataElementDataElementMappingComponentContent(int eventType, XmlPullParser xpp, DataElement owner, DataElement.DataElementMappingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identity")) {
            res.setIdentityElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("uri")) {
            res.setUriElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DetectedIssue parseDetectedIssue(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DetectedIssue res = new DetectedIssue();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDetectedIssueContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDetectedIssueContent(int eventType, XmlPullParser xpp, DetectedIssue res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, DetectedIssue.DetectedIssueStatus.NULL, new DetectedIssue.DetectedIssueStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverityElement(this.parseEnumeration(xpp, DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("implicated")) {
            res.getImplicated().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.setDetailElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReferenceElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mitigation")) {
            res.getMitigation().add(this.parseDetectedIssueDetectedIssueMitigationComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueDetectedIssueMitigationComponent(XmlPullParser xpp, DetectedIssue owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDetectedIssueDetectedIssueMitigationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDetectedIssueDetectedIssueMitigationComponentContent(int eventType, XmlPullParser xpp, DetectedIssue owner, DetectedIssue.DetectedIssueMitigationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("action")) {
            res.setAction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device parseDevice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Device res = new Device();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceContent(int eventType, XmlPullParser xpp, Device res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.setUdi(this.parseDeviceDeviceUdiComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Device.FHIRDeviceStatus.NULL, new Device.FHIRDeviceStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lotNumber")) {
            res.setLotNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.setManufacturerElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufactureDate")) {
            res.setManufactureDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expirationDate")) {
            res.setExpirationDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("model")) {
            res.setModelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("owner")) {
            res.setOwner(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("safety")) {
            res.getSafety().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device.DeviceUdiComponent parseDeviceDeviceUdiComponent(XmlPullParser xpp, Device owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Device.DeviceUdiComponent res = new Device.DeviceUdiComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDeviceUdiComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDeviceUdiComponentContent(int eventType, XmlPullParser xpp, Device owner, Device.DeviceUdiComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("deviceIdentifier")) {
            res.setDeviceIdentifierElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.setJurisdictionElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("carrierHRF")) {
            res.setCarrierHRFElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("carrierAIDC")) {
            res.setCarrierAIDCElement(this.parseBase64Binary(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issuer")) {
            res.setIssuerElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entryType")) {
            res.setEntryTypeElement(this.parseEnumeration(xpp, Device.UDIEntryType.NULL, new Device.UDIEntryTypeEnumFactory()));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceComponent parseDeviceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceComponent res = new DeviceComponent();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceComponentContent(int eventType, XmlPullParser xpp, DeviceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastSystemChange")) {
            res.setLastSystemChangeElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parent")) {
            res.setParent(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operationalStatus")) {
            res.getOperationalStatus().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parameterGroup")) {
            res.setParameterGroup(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("measurementPrinciple")) {
            res.setMeasurementPrincipleElement(this.parseEnumeration(xpp, DeviceComponent.MeasmntPrinciple.NULL, new DeviceComponent.MeasmntPrincipleEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("productionSpecification")) {
            res.getProductionSpecification().add(this.parseDeviceComponentDeviceComponentProductionSpecificationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("languageCode")) {
            res.setLanguageCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceComponent.DeviceComponentProductionSpecificationComponent parseDeviceComponentDeviceComponentProductionSpecificationComponent(XmlPullParser xpp, DeviceComponent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceComponent.DeviceComponentProductionSpecificationComponent res = new DeviceComponent.DeviceComponentProductionSpecificationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceComponentDeviceComponentProductionSpecificationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceComponentDeviceComponentProductionSpecificationComponentContent(int eventType, XmlPullParser xpp, DeviceComponent owner, DeviceComponent.DeviceComponentProductionSpecificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("specType")) {
            res.setSpecType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("componentId")) {
            res.setComponentId(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productionSpec")) {
            res.setProductionSpecElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceMetric parseDeviceMetric(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceMetric res = new DeviceMetric();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceMetricContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceMetricContent(int eventType, XmlPullParser xpp, DeviceMetric res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unit")) {
            res.setUnit(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parent")) {
            res.setParent(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operationalStatus")) {
            res.setOperationalStatusElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("color")) {
            res.setColorElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategoryElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("measurementPeriod")) {
            res.setMeasurementPeriod(this.parseTiming(xpp));
        } else if (eventType == 2 && xpp.getName().equals("calibration")) {
            res.getCalibration().add(this.parseDeviceMetricDeviceMetricCalibrationComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricDeviceMetricCalibrationComponent(XmlPullParser xpp, DeviceMetric owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceMetricDeviceMetricCalibrationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceMetricDeviceMetricCalibrationComponentContent(int eventType, XmlPullParser xpp, DeviceMetric owner, DeviceMetric.DeviceMetricCalibrationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("state")) {
            res.setStateElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("time")) {
            res.setTimeElement(this.parseInstant(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceRequest parseDeviceRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceRequest res = new DeviceRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceRequestContent(int eventType, XmlPullParser xpp, DeviceRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.getDefinition().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priorRequest")) {
            res.getPriorRequest().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, DeviceRequest.DeviceRequestStatus.NULL, new DeviceRequest.DeviceRequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntent(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, DeviceRequest.RequestPriority.NULL, new DeviceRequest.RequestPriorityEnumFactory()));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "code")) {
            res.setCode(this.parseType("code", xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requester")) {
            res.setRequester(this.parseDeviceRequestDeviceRequestRequesterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("performerType")) {
            res.setPerformerType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relevantHistory")) {
            res.getRelevantHistory().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceRequest.DeviceRequestRequesterComponent parseDeviceRequestDeviceRequestRequesterComponent(XmlPullParser xpp, DeviceRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceRequest.DeviceRequestRequesterComponent res = new DeviceRequest.DeviceRequestRequesterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceRequestDeviceRequestRequesterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceRequestDeviceRequestRequesterComponentContent(int eventType, XmlPullParser xpp, DeviceRequest owner, DeviceRequest.DeviceRequestRequesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("agent")) {
            res.setAgent(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceUseStatement parseDeviceUseStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceUseStatement res = new DeviceUseStatement();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceUseStatementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceUseStatementContent(int eventType, XmlPullParser xpp, DeviceUseStatement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, DeviceUseStatement.DeviceUseStatementStatus.NULL, new DeviceUseStatement.DeviceUseStatementStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("whenUsed")) {
            res.setWhenUsed(this.parsePeriod(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && xpp.getName().equals("recordedOn")) {
            res.setRecordedOnElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.setDevice(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("indication")) {
            res.getIndication().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DiagnosticReport parseDiagnosticReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticReport res = new DiagnosticReport();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDiagnosticReportContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDiagnosticReportContent(int eventType, XmlPullParser xpp, DiagnosticReport res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
            res.setEffective(this.parseType("effective", xpp));
        } else if (eventType == 2 && xpp.getName().equals("issued")) {
            res.setIssuedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseDiagnosticReportDiagnosticReportPerformerComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("specimen")) {
            res.getSpecimen().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("result")) {
            res.getResult().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("imagingStudy")) {
            res.getImagingStudy().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("image")) {
            res.getImage().add(this.parseDiagnosticReportDiagnosticReportImageComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("conclusion")) {
            res.setConclusionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("codedDiagnosis")) {
            res.getCodedDiagnosis().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("presentedForm")) {
            res.getPresentedForm().add(this.parseAttachment(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DiagnosticReport.DiagnosticReportPerformerComponent parseDiagnosticReportDiagnosticReportPerformerComponent(XmlPullParser xpp, DiagnosticReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticReport.DiagnosticReportPerformerComponent res = new DiagnosticReport.DiagnosticReportPerformerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDiagnosticReportDiagnosticReportPerformerComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDiagnosticReportDiagnosticReportPerformerComponentContent(int eventType, XmlPullParser xpp, DiagnosticReport owner, DiagnosticReport.DiagnosticReportPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DiagnosticReport.DiagnosticReportImageComponent parseDiagnosticReportDiagnosticReportImageComponent(XmlPullParser xpp, DiagnosticReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticReport.DiagnosticReportImageComponent res = new DiagnosticReport.DiagnosticReportImageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDiagnosticReportDiagnosticReportImageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDiagnosticReportDiagnosticReportImageComponentContent(int eventType, XmlPullParser xpp, DiagnosticReport owner, DiagnosticReport.DiagnosticReportImageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("link")) {
            res.setLink(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentManifest parseDocumentManifest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentManifest res = new DocumentManifest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentManifestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentManifestContent(int eventType, XmlPullParser xpp, DocumentManifest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("masterIdentifier")) {
            res.setMasterIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recipient")) {
            res.getRecipient().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSourceElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.getContent().add(this.parseDocumentManifestDocumentManifestContentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("related")) {
            res.getRelated().add(this.parseDocumentManifestDocumentManifestRelatedComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentManifest.DocumentManifestContentComponent parseDocumentManifestDocumentManifestContentComponent(XmlPullParser xpp, DocumentManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentManifest.DocumentManifestContentComponent res = new DocumentManifest.DocumentManifestContentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentManifestDocumentManifestContentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentManifestDocumentManifestContentComponentContent(int eventType, XmlPullParser xpp, DocumentManifest owner, DocumentManifest.DocumentManifestContentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "p")) {
            res.setP(this.parseType("p", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestDocumentManifestRelatedComponent(XmlPullParser xpp, DocumentManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentManifestDocumentManifestRelatedComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentManifestDocumentManifestRelatedComponentContent(int eventType, XmlPullParser xpp, DocumentManifest owner, DocumentManifest.DocumentManifestRelatedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ref")) {
            res.setRef(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentReference parseDocumentReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference res = new DocumentReference();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentReferenceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentReferenceContent(int eventType, XmlPullParser xpp, DocumentReference res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("masterIdentifier")) {
            res.setMasterIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("docStatus")) {
            res.setDocStatusElement(this.parseEnumeration(xpp, DocumentReference.ReferredDocumentStatus.NULL, new DocumentReference.ReferredDocumentStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("class")) {
            res.setClass_(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("indexed")) {
            res.setIndexedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authenticator")) {
            res.setAuthenticator(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("custodian")) {
            res.setCustodian(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatesTo")) {
            res.getRelatesTo().add(this.parseDocumentReferenceDocumentReferenceRelatesToComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
            res.getSecurityLabel().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.getContent().add(this.parseDocumentReferenceDocumentReferenceContentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseDocumentReferenceDocumentReferenceContextComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceDocumentReferenceRelatesToComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentReferenceDocumentReferenceRelatesToComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentReferenceDocumentReferenceRelatesToComponentContent(int eventType, XmlPullParser xpp, DocumentReference owner, DocumentReference.DocumentReferenceRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, DocumentReference.DocumentRelationshipType.NULL, new DocumentReference.DocumentRelationshipTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTarget(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceDocumentReferenceContentComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentReferenceDocumentReferenceContentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentReferenceDocumentReferenceContentComponentContent(int eventType, XmlPullParser xpp, DocumentReference owner, DocumentReference.DocumentReferenceContentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("attachment")) {
            res.setAttachment(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("format")) {
            res.setFormat(this.parseCoding(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceDocumentReferenceContextComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContextComponent res = new DocumentReference.DocumentReferenceContextComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentReferenceDocumentReferenceContextComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentReferenceDocumentReferenceContextComponentContent(int eventType, XmlPullParser xpp, DocumentReference owner, DocumentReference.DocumentReferenceContextComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("event")) {
            res.getEvent().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("facilityType")) {
            res.setFacilityType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("practiceSetting")) {
            res.setPracticeSetting(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sourcePatientInfo")) {
            res.setSourcePatientInfo(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("related")) {
            res.getRelated().add(this.parseDocumentReferenceDocumentReferenceContextRelatedComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentReference.DocumentReferenceContextRelatedComponent parseDocumentReferenceDocumentReferenceContextRelatedComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContextRelatedComponent res = new DocumentReference.DocumentReferenceContextRelatedComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentReferenceDocumentReferenceContextRelatedComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentReferenceDocumentReferenceContextRelatedComponentContent(int eventType, XmlPullParser xpp, DocumentReference owner, DocumentReference.DocumentReferenceContextRelatedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ref")) {
            res.setRef(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EligibilityRequest parseEligibilityRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EligibilityRequest res = new EligibilityRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEligibilityRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEligibilityRequestContent(int eventType, XmlPullParser xpp, EligibilityRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, EligibilityRequest.EligibilityRequestStatus.NULL, new EligibilityRequest.EligibilityRequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enterer")) {
            res.setEnterer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.setOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("facility")) {
            res.setFacility(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("benefitCategory")) {
            res.setBenefitCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("benefitSubCategory")) {
            res.setBenefitSubCategory(this.parseCodeableConcept(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EligibilityResponse parseEligibilityResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EligibilityResponse res = new EligibilityResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEligibilityResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEligibilityResponseContent(int eventType, XmlPullParser xpp, EligibilityResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, EligibilityResponse.EligibilityResponseStatus.NULL, new EligibilityResponse.EligibilityResponseStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestProvider")) {
            res.setRequestProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("disposition")) {
            res.setDispositionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("inforce")) {
            res.setInforceElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseEligibilityResponseInsuranceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("form")) {
            res.setForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("error")) {
            res.getError().add(this.parseEligibilityResponseErrorsComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EligibilityResponse.InsuranceComponent parseEligibilityResponseInsuranceComponent(XmlPullParser xpp, EligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EligibilityResponse.InsuranceComponent res = new EligibilityResponse.InsuranceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEligibilityResponseInsuranceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEligibilityResponseInsuranceComponentContent(int eventType, XmlPullParser xpp, EligibilityResponse owner, EligibilityResponse.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contract")) {
            res.setContract(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("benefitBalance")) {
            res.getBenefitBalance().add(this.parseEligibilityResponseBenefitsComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EligibilityResponse.BenefitsComponent parseEligibilityResponseBenefitsComponent(XmlPullParser xpp, EligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EligibilityResponse.BenefitsComponent res = new EligibilityResponse.BenefitsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEligibilityResponseBenefitsComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEligibilityResponseBenefitsComponentContent(int eventType, XmlPullParser xpp, EligibilityResponse owner, EligibilityResponse.BenefitsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subCategory")) {
            res.setSubCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("excluded")) {
            res.setExcludedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.setNetwork(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unit")) {
            res.setUnit(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("term")) {
            res.setTerm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("financial")) {
            res.getFinancial().add(this.parseEligibilityResponseBenefitComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EligibilityResponse.BenefitComponent parseEligibilityResponseBenefitComponent(XmlPullParser xpp, EligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EligibilityResponse.BenefitComponent res = new EligibilityResponse.BenefitComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEligibilityResponseBenefitComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEligibilityResponseBenefitComponentContent(int eventType, XmlPullParser xpp, EligibilityResponse owner, EligibilityResponse.BenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "allowed")) {
            res.setAllowed(this.parseType("allowed", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "used")) {
            res.setUsed(this.parseType("used", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EligibilityResponse.ErrorsComponent parseEligibilityResponseErrorsComponent(XmlPullParser xpp, EligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EligibilityResponse.ErrorsComponent res = new EligibilityResponse.ErrorsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEligibilityResponseErrorsComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEligibilityResponseErrorsComponentContent(int eventType, XmlPullParser xpp, EligibilityResponse owner, EligibilityResponse.ErrorsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter parseEncounter(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter res = new Encounter();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterContent(int eventType, XmlPullParser xpp, Encounter res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusHistory")) {
            res.getStatusHistory().add(this.parseEncounterStatusHistoryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("class")) {
            res.setClass_(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classHistory")) {
            res.getClassHistory().add(this.parseEncounterClassHistoryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("episodeOfCare")) {
            res.getEpisodeOfCare().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("incomingReferral")) {
            res.getIncomingReferral().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseEncounterEncounterParticipantComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("appointment")) {
            res.setAppointment(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("length")) {
            res.setLength(this.parseDuration(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
            res.getDiagnosis().add(this.parseEncounterDiagnosisComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("account")) {
            res.getAccount().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hospitalization")) {
            res.setHospitalization(this.parseEncounterEncounterHospitalizationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.getLocation().add(this.parseEncounterEncounterLocationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("serviceProvider")) {
            res.setServiceProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.setPartOf(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.StatusHistoryComponent parseEncounterStatusHistoryComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.StatusHistoryComponent res = new Encounter.StatusHistoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterStatusHistoryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterStatusHistoryComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.StatusHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.ClassHistoryComponent parseEncounterClassHistoryComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.ClassHistoryComponent res = new Encounter.ClassHistoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterClassHistoryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterClassHistoryComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.ClassHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("class")) {
            res.setClass_(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.EncounterParticipantComponent parseEncounterEncounterParticipantComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterEncounterParticipantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterEncounterParticipantComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.EncounterParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("individual")) {
            res.setIndividual(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.DiagnosisComponent parseEncounterDiagnosisComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.DiagnosisComponent res = new Encounter.DiagnosisComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterDiagnosisComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterDiagnosisComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("condition")) {
            res.setCondition(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rank")) {
            res.setRankElement(this.parsePositiveInt(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.EncounterHospitalizationComponent parseEncounterEncounterHospitalizationComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterEncounterHospitalizationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterEncounterHospitalizationComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.EncounterHospitalizationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("preAdmissionIdentifier")) {
            res.setPreAdmissionIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("origin")) {
            res.setOrigin(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("admitSource")) {
            res.setAdmitSource(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reAdmission")) {
            res.setReAdmission(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dietPreference")) {
            res.getDietPreference().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialCourtesy")) {
            res.getSpecialCourtesy().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialArrangement")) {
            res.getSpecialArrangement().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("destination")) {
            res.setDestination(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dischargeDisposition")) {
            res.setDischargeDisposition(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.EncounterLocationComponent parseEncounterEncounterLocationComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterEncounterLocationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterEncounterLocationComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.EncounterLocationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Endpoint parseEndpoint(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Endpoint res = new Endpoint();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEndpointContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEndpointContent(int eventType, XmlPullParser xpp, Endpoint res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Endpoint.EndpointStatus.NULL, new Endpoint.EndpointStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("connectionType")) {
            res.setConnectionType(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payloadType")) {
            res.getPayloadType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payloadMimeType")) {
            res.getPayloadMimeType().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.setAddressElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("header")) {
            res.getHeader().add(this.parseString(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EnrollmentRequest parseEnrollmentRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EnrollmentRequest res = new EnrollmentRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEnrollmentRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEnrollmentRequestContent(int eventType, XmlPullParser xpp, EnrollmentRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, EnrollmentRequest.EnrollmentRequestStatus.NULL, new EnrollmentRequest.EnrollmentRequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.setOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EnrollmentResponse parseEnrollmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EnrollmentResponse res = new EnrollmentResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEnrollmentResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEnrollmentResponseContent(int eventType, XmlPullParser xpp, EnrollmentResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, EnrollmentResponse.EnrollmentResponseStatus.NULL, new EnrollmentResponse.EnrollmentResponseStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("disposition")) {
            res.setDispositionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.setOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestProvider")) {
            res.setRequestProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EpisodeOfCare parseEpisodeOfCare(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EpisodeOfCare res = new EpisodeOfCare();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEpisodeOfCareContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEpisodeOfCareContent(int eventType, XmlPullParser xpp, EpisodeOfCare res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusHistory")) {
            res.getStatusHistory().add(this.parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
            res.getDiagnosis().add(this.parseEpisodeOfCareDiagnosisComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referralRequest")) {
            res.getReferralRequest().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careManager")) {
            res.setCareManager(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("team")) {
            res.getTeam().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("account")) {
            res.getAccount().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(XmlPullParser xpp, EpisodeOfCare owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentContent(int eventType, XmlPullParser xpp, EpisodeOfCare owner, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EpisodeOfCare.DiagnosisComponent parseEpisodeOfCareDiagnosisComponent(XmlPullParser xpp, EpisodeOfCare owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EpisodeOfCare.DiagnosisComponent res = new EpisodeOfCare.DiagnosisComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEpisodeOfCareDiagnosisComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEpisodeOfCareDiagnosisComponentContent(int eventType, XmlPullParser xpp, EpisodeOfCare owner, EpisodeOfCare.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("condition")) {
            res.setCondition(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rank")) {
            res.setRankElement(this.parsePositiveInt(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExpansionProfile parseExpansionProfile(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile res = new ExpansionProfile();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExpansionProfileContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExpansionProfileContent(int eventType, XmlPullParser xpp, ExpansionProfile res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fixedVersion")) {
            res.getFixedVersion().add(this.parseExpansionProfileExpansionProfileFixedVersionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("excludedSystem")) {
            res.setExcludedSystem(this.parseExpansionProfileExpansionProfileExcludedSystemComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("includeDesignations")) {
            res.setIncludeDesignationsElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("designation")) {
            res.setDesignation(this.parseExpansionProfileExpansionProfileDesignationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("includeDefinition")) {
            res.setIncludeDefinitionElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("activeOnly")) {
            res.setActiveOnlyElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("excludeNested")) {
            res.setExcludeNestedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("excludeNotForUI")) {
            res.setExcludeNotForUIElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("excludePostCoordinated")) {
            res.setExcludePostCoordinatedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("displayLanguage")) {
            res.setDisplayLanguageElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("limitedExpansion")) {
            res.setLimitedExpansionElement(this.parseBoolean(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExpansionProfile.ExpansionProfileFixedVersionComponent parseExpansionProfileExpansionProfileFixedVersionComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.ExpansionProfileFixedVersionComponent res = new ExpansionProfile.ExpansionProfileFixedVersionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExpansionProfileExpansionProfileFixedVersionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExpansionProfileExpansionProfileFixedVersionComponentContent(int eventType, XmlPullParser xpp, ExpansionProfile owner, ExpansionProfile.ExpansionProfileFixedVersionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, ExpansionProfile.SystemVersionProcessingMode.NULL, new ExpansionProfile.SystemVersionProcessingModeEnumFactory()));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExpansionProfile.ExpansionProfileExcludedSystemComponent parseExpansionProfileExpansionProfileExcludedSystemComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.ExpansionProfileExcludedSystemComponent res = new ExpansionProfile.ExpansionProfileExcludedSystemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExpansionProfileExpansionProfileExcludedSystemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExpansionProfileExpansionProfileExcludedSystemComponentContent(int eventType, XmlPullParser xpp, ExpansionProfile owner, ExpansionProfile.ExpansionProfileExcludedSystemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExpansionProfile.ExpansionProfileDesignationComponent parseExpansionProfileExpansionProfileDesignationComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.ExpansionProfileDesignationComponent res = new ExpansionProfile.ExpansionProfileDesignationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExpansionProfileExpansionProfileDesignationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExpansionProfileExpansionProfileDesignationComponentContent(int eventType, XmlPullParser xpp, ExpansionProfile owner, ExpansionProfile.ExpansionProfileDesignationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("include")) {
            res.setInclude(this.parseExpansionProfileDesignationIncludeComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("exclude")) {
            res.setExclude(this.parseExpansionProfileDesignationExcludeComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExpansionProfile.DesignationIncludeComponent parseExpansionProfileDesignationIncludeComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.DesignationIncludeComponent res = new ExpansionProfile.DesignationIncludeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExpansionProfileDesignationIncludeComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExpansionProfileDesignationIncludeComponentContent(int eventType, XmlPullParser xpp, ExpansionProfile owner, ExpansionProfile.DesignationIncludeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("designation")) {
            res.getDesignation().add(this.parseExpansionProfileDesignationIncludeDesignationComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExpansionProfile.DesignationIncludeDesignationComponent parseExpansionProfileDesignationIncludeDesignationComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.DesignationIncludeDesignationComponent res = new ExpansionProfile.DesignationIncludeDesignationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExpansionProfileDesignationIncludeDesignationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExpansionProfileDesignationIncludeDesignationComponentContent(int eventType, XmlPullParser xpp, ExpansionProfile owner, ExpansionProfile.DesignationIncludeDesignationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUse(this.parseCoding(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExpansionProfile.DesignationExcludeComponent parseExpansionProfileDesignationExcludeComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.DesignationExcludeComponent res = new ExpansionProfile.DesignationExcludeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExpansionProfileDesignationExcludeComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExpansionProfileDesignationExcludeComponentContent(int eventType, XmlPullParser xpp, ExpansionProfile owner, ExpansionProfile.DesignationExcludeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("designation")) {
            res.getDesignation().add(this.parseExpansionProfileDesignationExcludeDesignationComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExpansionProfile.DesignationExcludeDesignationComponent parseExpansionProfileDesignationExcludeDesignationComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExpansionProfile.DesignationExcludeDesignationComponent res = new ExpansionProfile.DesignationExcludeDesignationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExpansionProfileDesignationExcludeDesignationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExpansionProfileDesignationExcludeDesignationComponentContent(int eventType, XmlPullParser xpp, ExpansionProfile owner, ExpansionProfile.DesignationExcludeDesignationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUse(this.parseCoding(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit parseExplanationOfBenefit(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit res = new ExplanationOfBenefit();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL, new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.getSubType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("billablePeriod")) {
            res.setBillablePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enterer")) {
            res.setEnterer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.setOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referral")) {
            res.setReferral(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("facility")) {
            res.setFacility(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("claim")) {
            res.setClaim(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("claimResponse")) {
            res.setClaimResponse(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("disposition")) {
            res.setDispositionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("related")) {
            res.getRelated().add(this.parseExplanationOfBenefitRelatedClaimComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("prescription")) {
            res.setPrescription(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("originalPrescription")) {
            res.setOriginalPrescription(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payee")) {
            res.setPayee(this.parseExplanationOfBenefitPayeeComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("information")) {
            res.getInformation().add(this.parseExplanationOfBenefitSupportingInformationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("careTeam")) {
            res.getCareTeam().add(this.parseExplanationOfBenefitCareTeamComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
            res.getDiagnosis().add(this.parseExplanationOfBenefitDiagnosisComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("procedure")) {
            res.getProcedure().add(this.parseExplanationOfBenefitProcedureComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("precedence")) {
            res.setPrecedenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.setInsurance(this.parseExplanationOfBenefitInsuranceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("accident")) {
            res.setAccident(this.parseExplanationOfBenefitAccidentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("employmentImpacted")) {
            res.setEmploymentImpacted(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hospitalization")) {
            res.setHospitalization(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseExplanationOfBenefitItemComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("addItem")) {
            res.getAddItem().add(this.parseExplanationOfBenefitAddedItemComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("totalCost")) {
            res.setTotalCost(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unallocDeductable")) {
            res.setUnallocDeductable(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("totalBenefit")) {
            res.setTotalBenefit(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payment")) {
            res.setPayment(this.parseExplanationOfBenefitPaymentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("form")) {
            res.setForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("processNote")) {
            res.getProcessNote().add(this.parseExplanationOfBenefitNoteComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("benefitBalance")) {
            res.getBenefitBalance().add(this.parseExplanationOfBenefitBenefitBalanceComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.RelatedClaimComponent parseExplanationOfBenefitRelatedClaimComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.RelatedClaimComponent res = new ExplanationOfBenefit.RelatedClaimComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitRelatedClaimComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitRelatedClaimComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.RelatedClaimComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("claim")) {
            res.setClaim(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseIdentifier(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitPayeeComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitPayeeComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.PayeeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resourceType")) {
            res.setResourceType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.SupportingInformationComponent parseExplanationOfBenefitSupportingInformationComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.SupportingInformationComponent res = new ExplanationOfBenefit.SupportingInformationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitSupportingInformationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitSupportingInformationComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.SupportingInformationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCoding(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.CareTeamComponent parseExplanationOfBenefitCareTeamComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.CareTeamComponent res = new ExplanationOfBenefit.CareTeamComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitCareTeamComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitCareTeamComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.CareTeamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("responsible")) {
            res.setResponsibleElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("qualification")) {
            res.setQualification(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitDiagnosisComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitDiagnosisComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "diagnosis")) {
            res.setDiagnosis(this.parseType("diagnosis", xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("packageCode")) {
            res.setPackageCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitProcedureComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitProcedureComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.ProcedureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "procedure")) {
            res.setProcedure(this.parseType("procedure", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.InsuranceComponent parseExplanationOfBenefitInsuranceComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.InsuranceComponent res = new ExplanationOfBenefit.InsuranceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitInsuranceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitInsuranceComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
            res.getPreAuthRef().add(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.AccidentComponent parseExplanationOfBenefitAccidentComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AccidentComponent res = new ExplanationOfBenefit.AccidentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitAccidentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitAccidentComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AccidentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.ItemComponent parseExplanationOfBenefitItemComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.ItemComponent res = new ExplanationOfBenefit.ItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitItemComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeamLinkId")) {
            res.getCareTeamLinkId().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosisLinkId")) {
            res.getDiagnosisLinkId().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedureLinkId")) {
            res.getProcedureLinkId().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("informationLinkId")) {
            res.getInformationLinkId().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.setService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subSite")) {
            res.getSubSite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.getEncounter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseExplanationOfBenefitDetailComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.AdjudicationComponent parseExplanationOfBenefitAdjudicationComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AdjudicationComponent res = new ExplanationOfBenefit.AdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitAdjudicationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitAdjudicationComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AdjudicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDecimal(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.DetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.setService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
            res.getSubDetail().add(this.parseExplanationOfBenefitSubDetailComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitSubDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitSubDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.setService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitAddedItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitAddedItemComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
            res.getSequenceLinkId().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.setService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fee")) {
            res.setFee(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseExplanationOfBenefitAddedItemsDetailComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.AddedItemsDetailComponent parseExplanationOfBenefitAddedItemsDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemsDetailComponent res = new ExplanationOfBenefit.AddedItemsDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitAddedItemsDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitAddedItemsDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemsDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.setService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fee")) {
            res.setFee(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.PaymentComponent parseExplanationOfBenefitPaymentComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.PaymentComponent res = new ExplanationOfBenefit.PaymentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitPaymentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitPaymentComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.PaymentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjustment")) {
            res.setAdjustment(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjustmentReason")) {
            res.setAdjustmentReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.NoteComponent parseExplanationOfBenefitNoteComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.NoteComponent res = new ExplanationOfBenefit.NoteComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitNoteComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitNoteComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.NoteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("number")) {
            res.setNumberElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitBenefitBalanceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitBenefitBalanceComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitBalanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subCategory")) {
            res.setSubCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("excluded")) {
            res.setExcludedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.setNetwork(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unit")) {
            res.setUnit(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("term")) {
            res.setTerm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("financial")) {
            res.getFinancial().add(this.parseExplanationOfBenefitBenefitComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitBenefitComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitBenefitComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "allowed")) {
            res.setAllowed(this.parseType("allowed", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "used")) {
            res.setUsed(this.parseType("used", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected FamilyMemberHistory parseFamilyMemberHistory(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        FamilyMemberHistory res = new FamilyMemberHistory();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseFamilyMemberHistoryContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseFamilyMemberHistoryContent(int eventType, XmlPullParser xpp, FamilyMemberHistory res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.getDefinition().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("notDone")) {
            res.setNotDoneElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("notDoneReason")) {
            res.setNotDoneReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("gender")) {
            res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "born")) {
            res.setBorn(this.parseType("born", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "age")) {
            res.setAge(this.parseType("age", xpp));
        } else if (eventType == 2 && xpp.getName().equals("estimatedAge")) {
            res.setEstimatedAgeElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "deceased")) {
            res.setDeceased(this.parseType("deceased", xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("condition")) {
            res.getCondition().add(this.parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(XmlPullParser xpp, FamilyMemberHistory owner) throws XmlPullParserException, IOException, FHIRFormatError {
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentContent(int eventType, XmlPullParser xpp, FamilyMemberHistory owner, FamilyMemberHistory.FamilyMemberHistoryConditionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "onset")) {
            res.setOnset(this.parseType("onset", xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Flag parseFlag(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Flag res = new Flag();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseFlagContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseFlagContent(int eventType, XmlPullParser xpp, Flag res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Goal parseGoal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Goal res = new Goal();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGoalContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGoalContent(int eventType, XmlPullParser xpp, Goal res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Goal.GoalStatus.NULL, new Goal.GoalStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescription(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "start")) {
            res.setStart(this.parseType("start", xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTarget(this.parseGoalGoalTargetComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("statusDate")) {
            res.setStatusDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReasonElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expressedBy")) {
            res.setExpressedBy(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("addresses")) {
            res.getAddresses().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcomeCode")) {
            res.getOutcomeCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcomeReference")) {
            res.getOutcomeReference().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Goal.GoalTargetComponent parseGoalGoalTargetComponent(XmlPullParser xpp, Goal owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Goal.GoalTargetComponent res = new Goal.GoalTargetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGoalGoalTargetComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGoalGoalTargetComponentContent(int eventType, XmlPullParser xpp, Goal owner, Goal.GoalTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("measure")) {
            res.setMeasure(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "detail")) {
            res.setDetail(this.parseType("detail", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "due")) {
            res.setDue(this.parseType("due", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GraphDefinition parseGraphDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GraphDefinition res = new GraphDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGraphDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGraphDefinitionContent(int eventType, XmlPullParser xpp, GraphDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parseGraphDefinitionGraphDefinitionLinkComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GraphDefinition.GraphDefinitionLinkComponent parseGraphDefinitionGraphDefinitionLinkComponent(XmlPullParser xpp, GraphDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        GraphDefinition.GraphDefinitionLinkComponent res = new GraphDefinition.GraphDefinitionLinkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGraphDefinitionGraphDefinitionLinkComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGraphDefinitionGraphDefinitionLinkComponentContent(int eventType, XmlPullParser xpp, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sliceName")) {
            res.setSliceNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.getTarget().add(this.parseGraphDefinitionGraphDefinitionLinkTargetComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GraphDefinition.GraphDefinitionLinkTargetComponent parseGraphDefinitionGraphDefinitionLinkTargetComponent(XmlPullParser xpp, GraphDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        GraphDefinition.GraphDefinitionLinkTargetComponent res = new GraphDefinition.GraphDefinitionLinkTargetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGraphDefinitionGraphDefinitionLinkTargetComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGraphDefinitionGraphDefinitionLinkTargetComponentContent(int eventType, XmlPullParser xpp, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("compartment")) {
            res.getCompartment().add(this.parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parseGraphDefinitionGraphDefinitionLinkComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(XmlPullParser xpp, GraphDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentContent(int eventType, XmlPullParser xpp, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, GraphDefinition.CompartmentCode.NULL, new GraphDefinition.CompartmentCodeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("rule")) {
            res.setRuleElement(this.parseEnumeration(xpp, GraphDefinition.GraphCompartmentRule.NULL, new GraphDefinition.GraphCompartmentRuleEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Group parseGroup(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Group res = new Group();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGroupContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGroupContent(int eventType, XmlPullParser xpp, Group res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("actual")) {
            res.setActualElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantityElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("characteristic")) {
            res.getCharacteristic().add(this.parseGroupGroupCharacteristicComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("member")) {
            res.getMember().add(this.parseGroupGroupMemberComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Group.GroupCharacteristicComponent parseGroupGroupCharacteristicComponent(XmlPullParser xpp, Group owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGroupGroupCharacteristicComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGroupGroupCharacteristicComponentContent(int eventType, XmlPullParser xpp, Group owner, Group.GroupCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("exclude")) {
            res.setExcludeElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Group.GroupMemberComponent parseGroupGroupMemberComponent(XmlPullParser xpp, Group owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Group.GroupMemberComponent res = new Group.GroupMemberComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGroupGroupMemberComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGroupGroupMemberComponentContent(int eventType, XmlPullParser xpp, Group owner, Group.GroupMemberComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("entity")) {
            res.setEntity(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("inactive")) {
            res.setInactiveElement(this.parseBoolean(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GuidanceResponse parseGuidanceResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GuidanceResponse res = new GuidanceResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGuidanceResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGuidanceResponseContent(int eventType, XmlPullParser xpp, GuidanceResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("requestId")) {
            res.setRequestIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("module")) {
            res.setModule(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("occurrenceDateTime")) {
            res.setOccurrenceDateTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "reason")) {
            res.setReason(this.parseType("reason", xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("evaluationMessage")) {
            res.getEvaluationMessage().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outputParameters")) {
            res.setOutputParameters(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("result")) {
            res.setResult(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dataRequirement")) {
            res.getDataRequirement().add(this.parseDataRequirement(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected HealthcareService parseHealthcareService(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService res = new HealthcareService();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseHealthcareServiceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseHealthcareServiceContent(int eventType, XmlPullParser xpp, HealthcareService res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("providedBy")) {
            res.setProvidedBy(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialty")) {
            res.getSpecialty().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.getLocation().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("extraDetails")) {
            res.setExtraDetailsElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("photo")) {
            res.setPhoto(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverageArea")) {
            res.getCoverageArea().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serviceProvisionCode")) {
            res.getServiceProvisionCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("eligibility")) {
            res.setEligibility(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("eligibilityNote")) {
            res.setEligibilityNoteElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programName")) {
            res.getProgramName().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("characteristic")) {
            res.getCharacteristic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referralMethod")) {
            res.getReferralMethod().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("appointmentRequired")) {
            res.setAppointmentRequiredElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("availableTime")) {
            res.getAvailableTime().add(this.parseHealthcareServiceHealthcareServiceAvailableTimeComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("notAvailable")) {
            res.getNotAvailable().add(this.parseHealthcareServiceHealthcareServiceNotAvailableComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("availabilityExceptions")) {
            res.setAvailabilityExceptionsElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceHealthcareServiceAvailableTimeComponent(XmlPullParser xpp, HealthcareService owner) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseHealthcareServiceHealthcareServiceAvailableTimeComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseHealthcareServiceHealthcareServiceAvailableTimeComponentContent(int eventType, XmlPullParser xpp, HealthcareService owner, HealthcareService.HealthcareServiceAvailableTimeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("daysOfWeek")) {
            res.getDaysOfWeek().add(this.parseEnumeration(xpp, HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("allDay")) {
            res.setAllDayElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("availableStartTime")) {
            res.setAvailableStartTimeElement(this.parseTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("availableEndTime")) {
            res.setAvailableEndTimeElement(this.parseTime(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceHealthcareServiceNotAvailableComponent(XmlPullParser xpp, HealthcareService owner) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseHealthcareServiceHealthcareServiceNotAvailableComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseHealthcareServiceHealthcareServiceNotAvailableComponentContent(int eventType, XmlPullParser xpp, HealthcareService owner, HealthcareService.HealthcareServiceNotAvailableComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("during")) {
            res.setDuring(this.parsePeriod(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingManifest parseImagingManifest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingManifest res = new ImagingManifest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingManifestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingManifestContent(int eventType, XmlPullParser xpp, ImagingManifest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authoringTime")) {
            res.setAuthoringTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("study")) {
            res.getStudy().add(this.parseImagingManifestStudyComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingManifest.StudyComponent parseImagingManifestStudyComponent(XmlPullParser xpp, ImagingManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingManifest.StudyComponent res = new ImagingManifest.StudyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingManifestStudyComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingManifestStudyComponentContent(int eventType, XmlPullParser xpp, ImagingManifest owner, ImagingManifest.StudyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uid")) {
            res.setUidElement(this.parseOid(xpp));
        } else if (eventType == 2 && xpp.getName().equals("imagingStudy")) {
            res.setImagingStudy(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("series")) {
            res.getSeries().add(this.parseImagingManifestSeriesComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingManifest.SeriesComponent parseImagingManifestSeriesComponent(XmlPullParser xpp, ImagingManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingManifest.SeriesComponent res = new ImagingManifest.SeriesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingManifestSeriesComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingManifestSeriesComponentContent(int eventType, XmlPullParser xpp, ImagingManifest owner, ImagingManifest.SeriesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uid")) {
            res.setUidElement(this.parseOid(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instance")) {
            res.getInstance().add(this.parseImagingManifestInstanceComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingManifest.InstanceComponent parseImagingManifestInstanceComponent(XmlPullParser xpp, ImagingManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingManifest.InstanceComponent res = new ImagingManifest.InstanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingManifestInstanceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingManifestInstanceComponentContent(int eventType, XmlPullParser xpp, ImagingManifest owner, ImagingManifest.InstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sopClass")) {
            res.setSopClassElement(this.parseOid(xpp));
        } else if (eventType == 2 && xpp.getName().equals("uid")) {
            res.setUidElement(this.parseOid(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingStudy parseImagingStudy(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy res = new ImagingStudy();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingStudyContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingStudyContent(int eventType, XmlPullParser xpp, ImagingStudy res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uid")) {
            res.setUidElement(this.parseOid(xpp));
        } else if (eventType == 2 && xpp.getName().equals("accession")) {
            res.setAccession(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("availability")) {
            res.setAvailabilityElement(this.parseEnumeration(xpp, ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("modalityList")) {
            res.getModalityList().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("started")) {
            res.setStartedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referrer")) {
            res.setReferrer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("interpreter")) {
            res.getInterpreter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfSeries")) {
            res.setNumberOfSeriesElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfInstances")) {
            res.setNumberOfInstancesElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedureReference")) {
            res.getProcedureReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedureCode")) {
            res.getProcedureCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("series")) {
            res.getSeries().add(this.parseImagingStudyImagingStudySeriesComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudyImagingStudySeriesComponent(XmlPullParser xpp, ImagingStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingStudyImagingStudySeriesComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingStudyImagingStudySeriesComponentContent(int eventType, XmlPullParser xpp, ImagingStudy owner, ImagingStudy.ImagingStudySeriesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uid")) {
            res.setUidElement(this.parseOid(xpp));
        } else if (eventType == 2 && xpp.getName().equals("number")) {
            res.setNumberElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modality")) {
            res.setModality(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfInstances")) {
            res.setNumberOfInstancesElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("availability")) {
            res.setAvailabilityElement(this.parseEnumeration(xpp, ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("laterality")) {
            res.setLaterality(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("started")) {
            res.setStartedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instance")) {
            res.getInstance().add(this.parseImagingStudyImagingStudySeriesInstanceComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudyImagingStudySeriesInstanceComponent(XmlPullParser xpp, ImagingStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingStudyImagingStudySeriesInstanceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingStudyImagingStudySeriesInstanceComponentContent(int eventType, XmlPullParser xpp, ImagingStudy owner, ImagingStudy.ImagingStudySeriesInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uid")) {
            res.setUidElement(this.parseOid(xpp));
        } else if (eventType == 2 && xpp.getName().equals("number")) {
            res.setNumberElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sopClass")) {
            res.setSopClassElement(this.parseOid(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Immunization parseImmunization(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization res = new Immunization();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationContent(int eventType, XmlPullParser xpp, Immunization res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Immunization.ImmunizationStatus.NULL, new Immunization.ImmunizationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("notGiven")) {
            res.setNotGivenElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("vaccineCode")) {
            res.setVaccineCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("primarySource")) {
            res.setPrimarySourceElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reportOrigin")) {
            res.setReportOrigin(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.setManufacturer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lotNumber")) {
            res.setLotNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expirationDate")) {
            res.setExpirationDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("site")) {
            res.setSite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("route")) {
            res.setRoute(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseQuantity")) {
            res.setDoseQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("practitioner")) {
            res.getPractitioner().add(this.parseImmunizationImmunizationPractitionerComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("explanation")) {
            res.setExplanation(this.parseImmunizationImmunizationExplanationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("reaction")) {
            res.getReaction().add(this.parseImmunizationImmunizationReactionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("vaccinationProtocol")) {
            res.getVaccinationProtocol().add(this.parseImmunizationImmunizationVaccinationProtocolComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Immunization.ImmunizationPractitionerComponent parseImmunizationImmunizationPractitionerComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationPractitionerComponent res = new Immunization.ImmunizationPractitionerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationImmunizationPractitionerComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationImmunizationPractitionerComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationPractitionerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Immunization.ImmunizationExplanationComponent parseImmunizationImmunizationExplanationComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationExplanationComponent res = new Immunization.ImmunizationExplanationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationImmunizationExplanationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationImmunizationExplanationComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationExplanationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonNotGiven")) {
            res.getReasonNotGiven().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Immunization.ImmunizationReactionComponent parseImmunizationImmunizationReactionComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationImmunizationReactionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationImmunizationReactionComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationReactionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.setDetail(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reported")) {
            res.setReportedElement(this.parseBoolean(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Immunization.ImmunizationVaccinationProtocolComponent parseImmunizationImmunizationVaccinationProtocolComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationVaccinationProtocolComponent res = new Immunization.ImmunizationVaccinationProtocolComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationImmunizationVaccinationProtocolComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationImmunizationVaccinationProtocolComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationVaccinationProtocolComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("doseSequence")) {
            res.setDoseSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authority")) {
            res.setAuthority(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("series")) {
            res.setSeriesElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("seriesDoses")) {
            res.setSeriesDosesElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetDisease")) {
            res.getTargetDisease().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseStatus")) {
            res.setDoseStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseStatusReason")) {
            res.setDoseStatusReason(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImmunizationRecommendation parseImmunizationRecommendation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation res = new ImmunizationRecommendation();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationRecommendationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationRecommendationContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recommendation")) {
            res.getRecommendation().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("vaccineCode")) {
            res.setVaccineCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetDisease")) {
            res.setTargetDisease(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseNumber")) {
            res.setDoseNumberElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("forecastStatus")) {
            res.setForecastStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dateCriterion")) {
            res.getDateCriterion().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("protocol")) {
            res.setProtocol(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("supportingImmunization")) {
            res.getSupportingImmunization().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingPatientInformation")) {
            res.getSupportingPatientInformation().add(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDateTime(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponentContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("doseSequence")) {
            res.setDoseSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authority")) {
            res.setAuthority(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("series")) {
            res.setSeriesElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide parseImplementationGuide(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide res = new ImplementationGuide();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideContent(int eventType, XmlPullParser xpp, ImplementationGuide res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fhirVersion")) {
            res.setFhirVersionElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dependency")) {
            res.getDependency().add(this.parseImplementationGuideImplementationGuideDependencyComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("package")) {
            res.getPackage().add(this.parseImplementationGuideImplementationGuidePackageComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("global")) {
            res.getGlobal().add(this.parseImplementationGuideImplementationGuideGlobalComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("binary")) {
            res.getBinary().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("page")) {
            res.setPage(this.parseImplementationGuideImplementationGuidePageComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideDependencyComponent parseImplementationGuideImplementationGuideDependencyComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDependencyComponent res = new ImplementationGuide.ImplementationGuideDependencyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideImplementationGuideDependencyComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideImplementationGuideDependencyComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDependencyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, ImplementationGuide.GuideDependencyType.NULL, new ImplementationGuide.GuideDependencyTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("uri")) {
            res.setUriElement(this.parseUri(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuidePackageComponent parseImplementationGuideImplementationGuidePackageComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuidePackageComponent res = new ImplementationGuide.ImplementationGuidePackageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideImplementationGuidePackageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideImplementationGuidePackageComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuidePackageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.getResource().add(this.parseImplementationGuideImplementationGuidePackageResourceComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuidePackageResourceComponent parseImplementationGuideImplementationGuidePackageResourceComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuidePackageResourceComponent res = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideImplementationGuidePackageResourceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideImplementationGuidePackageResourceComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuidePackageResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("example")) {
            res.setExampleElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("acronym")) {
            res.setAcronymElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "source")) {
            res.setSource(this.parseType("source", xpp));
        } else if (eventType == 2 && xpp.getName().equals("exampleFor")) {
            res.setExampleFor(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideImplementationGuideGlobalComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideImplementationGuideGlobalComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideImplementationGuideGlobalComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideGlobalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfile(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuidePageComponent parseImplementationGuideImplementationGuidePageComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuidePageComponent res = new ImplementationGuide.ImplementationGuidePageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideImplementationGuidePageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideImplementationGuidePageComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuidePageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSourceElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, ImplementationGuide.GuidePageKind.NULL, new ImplementationGuide.GuidePageKindEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("package")) {
            res.getPackage().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("format")) {
            res.setFormatElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("page")) {
            res.getPage().add(this.parseImplementationGuideImplementationGuidePageComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Library parseLibrary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Library res = new Library();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLibraryContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLibraryContent(int eventType, XmlPullParser xpp, Library res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.setUsageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributor")) {
            res.getContributor().add(this.parseContributor(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parameter")) {
            res.getParameter().add(this.parseParameterDefinition(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dataRequirement")) {
            res.getDataRequirement().add(this.parseDataRequirement(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.getContent().add(this.parseAttachment(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Linkage parseLinkage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Linkage res = new Linkage();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLinkageContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLinkageContent(int eventType, XmlPullParser xpp, Linkage res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseLinkageLinkageItemComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Linkage.LinkageItemComponent parseLinkageLinkageItemComponent(XmlPullParser xpp, Linkage owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Linkage.LinkageItemComponent res = new Linkage.LinkageItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLinkageLinkageItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLinkageLinkageItemComponentContent(int eventType, XmlPullParser xpp, Linkage owner, Linkage.LinkageItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Linkage.LinkageType.NULL, new Linkage.LinkageTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ListResource parseListResource(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ListResource res = new ListResource();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseListResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseListResourceContent(int eventType, XmlPullParser xpp, ListResource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ListResource.ListStatus.NULL, new ListResource.ListStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, ListResource.ListMode.NULL, new ListResource.ListModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entry")) {
            res.getEntry().add(this.parseListResourceListEntryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ListResource.ListEntryComponent parseListResourceListEntryComponent(XmlPullParser xpp, ListResource owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ListResource.ListEntryComponent res = new ListResource.ListEntryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseListResourceListEntryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseListResourceListEntryComponentContent(int eventType, XmlPullParser xpp, ListResource owner, ListResource.ListEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("flag")) {
            res.setFlag(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("deleted")) {
            res.setDeletedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.setItem(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Location parseLocation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Location res = new Location();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLocationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLocationContent(int eventType, XmlPullParser xpp, Location res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Location.LocationStatus.NULL, new Location.LocationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("operationalStatus")) {
            res.setOperationalStatus(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("alias")) {
            res.getAlias().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, Location.LocationMode.NULL, new Location.LocationModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.setAddress(this.parseAddress(xpp));
        } else if (eventType == 2 && xpp.getName().equals("physicalType")) {
            res.setPhysicalType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("position")) {
            res.setPosition(this.parseLocationLocationPositionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.setPartOf(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Location.LocationPositionComponent parseLocationLocationPositionComponent(XmlPullParser xpp, Location owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Location.LocationPositionComponent res = new Location.LocationPositionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLocationLocationPositionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLocationLocationPositionComponentContent(int eventType, XmlPullParser xpp, Location owner, Location.LocationPositionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("longitude")) {
            res.setLongitudeElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("latitude")) {
            res.setLatitudeElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("altitude")) {
            res.setAltitudeElement(this.parseDecimal(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure parseMeasure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure res = new Measure();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureContent(int eventType, XmlPullParser xpp, Measure res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.setUsageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributor")) {
            res.getContributor().add(this.parseContributor(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("library")) {
            res.getLibrary().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("disclaimer")) {
            res.setDisclaimerElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("scoring")) {
            res.setScoring(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("compositeScoring")) {
            res.setCompositeScoring(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("riskAdjustment")) {
            res.setRiskAdjustmentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rateAggregation")) {
            res.setRateAggregationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rationale")) {
            res.setRationaleElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("clinicalRecommendationStatement")) {
            res.setClinicalRecommendationStatementElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("improvementNotation")) {
            res.setImprovementNotationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.getDefinition().add(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("guidance")) {
            res.setGuidanceElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("set")) {
            res.setSetElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("group")) {
            res.getGroup().add(this.parseMeasureMeasureGroupComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("supplementalData")) {
            res.getSupplementalData().add(this.parseMeasureMeasureSupplementalDataComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure.MeasureGroupComponent parseMeasureMeasureGroupComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureGroupComponent res = new Measure.MeasureGroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureMeasureGroupComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureMeasureGroupComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("population")) {
            res.getPopulation().add(this.parseMeasureMeasureGroupPopulationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("stratifier")) {
            res.getStratifier().add(this.parseMeasureMeasureGroupStratifierComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure.MeasureGroupPopulationComponent parseMeasureMeasureGroupPopulationComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureGroupPopulationComponent res = new Measure.MeasureGroupPopulationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureMeasureGroupPopulationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureMeasureGroupPopulationComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("criteria")) {
            res.setCriteriaElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure.MeasureGroupStratifierComponent parseMeasureMeasureGroupStratifierComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureGroupStratifierComponent res = new Measure.MeasureGroupStratifierComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureMeasureGroupStratifierComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureMeasureGroupStratifierComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureGroupStratifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("criteria")) {
            res.setCriteriaElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure.MeasureSupplementalDataComponent parseMeasureMeasureSupplementalDataComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureSupplementalDataComponent res = new Measure.MeasureSupplementalDataComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureMeasureSupplementalDataComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureMeasureSupplementalDataComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureSupplementalDataComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.getUsage().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("criteria")) {
            res.setCriteriaElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MeasureReport parseMeasureReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport res = new MeasureReport();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureReportContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureReportContent(int eventType, XmlPullParser xpp, MeasureReport res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, MeasureReport.MeasureReportStatus.NULL, new MeasureReport.MeasureReportStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, MeasureReport.MeasureReportType.NULL, new MeasureReport.MeasureReportTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("measure")) {
            res.setMeasure(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reportingOrganization")) {
            res.setReportingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("group")) {
            res.getGroup().add(this.parseMeasureReportMeasureReportGroupComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("evaluatedResources")) {
            res.setEvaluatedResources(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MeasureReport.MeasureReportGroupComponent parseMeasureReportMeasureReportGroupComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupComponent res = new MeasureReport.MeasureReportGroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureReportMeasureReportGroupComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureReportMeasureReportGroupComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.MeasureReportGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("population")) {
            res.getPopulation().add(this.parseMeasureReportMeasureReportGroupPopulationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("measureScore")) {
            res.setMeasureScoreElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("stratifier")) {
            res.getStratifier().add(this.parseMeasureReportMeasureReportGroupStratifierComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MeasureReport.MeasureReportGroupPopulationComponent parseMeasureReportMeasureReportGroupPopulationComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupPopulationComponent res = new MeasureReport.MeasureReportGroupPopulationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureReportMeasureReportGroupPopulationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureReportMeasureReportGroupPopulationComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.MeasureReportGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("count")) {
            res.setCountElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patients")) {
            res.setPatients(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MeasureReport.MeasureReportGroupStratifierComponent parseMeasureReportMeasureReportGroupStratifierComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupStratifierComponent res = new MeasureReport.MeasureReportGroupStratifierComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureReportMeasureReportGroupStratifierComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureReportMeasureReportGroupStratifierComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.MeasureReportGroupStratifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("stratum")) {
            res.getStratum().add(this.parseMeasureReportStratifierGroupComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MeasureReport.StratifierGroupComponent parseMeasureReportStratifierGroupComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.StratifierGroupComponent res = new MeasureReport.StratifierGroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureReportStratifierGroupComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureReportStratifierGroupComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.StratifierGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("population")) {
            res.getPopulation().add(this.parseMeasureReportStratifierGroupPopulationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("measureScore")) {
            res.setMeasureScoreElement(this.parseDecimal(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MeasureReport.StratifierGroupPopulationComponent parseMeasureReportStratifierGroupPopulationComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.StratifierGroupPopulationComponent res = new MeasureReport.StratifierGroupPopulationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureReportStratifierGroupPopulationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureReportStratifierGroupPopulationComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.StratifierGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("count")) {
            res.setCountElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patients")) {
            res.setPatients(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Media parseMedia(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Media res = new Media();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMediaContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMediaContent(int eventType, XmlPullParser xpp, Media res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Media.DigitalMediaType.NULL, new Media.DigitalMediaTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("subtype")) {
            res.setSubtype(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("view")) {
            res.setView(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("operator")) {
            res.setOperator(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.setDevice(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("height")) {
            res.setHeightElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("width")) {
            res.setWidthElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("frames")) {
            res.setFramesElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("duration")) {
            res.setDurationElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.setContent(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Medication parseMedication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication res = new Medication();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationContent(int eventType, XmlPullParser xpp, Medication res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Medication.MedicationStatus.NULL, new Medication.MedicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("isBrand")) {
            res.setIsBrandElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("isOverTheCounter")) {
            res.setIsOverTheCounterElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.setManufacturer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("form")) {
            res.setForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ingredient")) {
            res.getIngredient().add(this.parseMedicationMedicationIngredientComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("package")) {
            res.setPackage(this.parseMedicationMedicationPackageComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("image")) {
            res.getImage().add(this.parseAttachment(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Medication.MedicationIngredientComponent parseMedicationMedicationIngredientComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationIngredientComponent res = new Medication.MedicationIngredientComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationMedicationIngredientComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationMedicationIngredientComponentContent(int eventType, XmlPullParser xpp, Medication owner, Medication.MedicationIngredientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "item")) {
            res.setItem(this.parseType("item", xpp));
        } else if (eventType == 2 && xpp.getName().equals("isActive")) {
            res.setIsActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseRatio(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Medication.MedicationPackageComponent parseMedicationMedicationPackageComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationPackageComponent res = new Medication.MedicationPackageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationMedicationPackageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationMedicationPackageComponentContent(int eventType, XmlPullParser xpp, Medication owner, Medication.MedicationPackageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("container")) {
            res.setContainer(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.getContent().add(this.parseMedicationMedicationPackageContentComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("batch")) {
            res.getBatch().add(this.parseMedicationMedicationPackageBatchComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Medication.MedicationPackageContentComponent parseMedicationMedicationPackageContentComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationPackageContentComponent res = new Medication.MedicationPackageContentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationMedicationPackageContentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationMedicationPackageContentComponentContent(int eventType, XmlPullParser xpp, Medication owner, Medication.MedicationPackageContentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "item")) {
            res.setItem(this.parseType("item", xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseSimpleQuantity(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Medication.MedicationPackageBatchComponent parseMedicationMedicationPackageBatchComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationPackageBatchComponent res = new Medication.MedicationPackageBatchComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationMedicationPackageBatchComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationMedicationPackageBatchComponentContent(int eventType, XmlPullParser xpp, Medication owner, Medication.MedicationPackageBatchComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("lotNumber")) {
            res.setLotNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expirationDate")) {
            res.setExpirationDateElement(this.parseDateTime(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationAdministration parseMedicationAdministration(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationAdministration res = new MedicationAdministration();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationAdministrationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationAdministrationContent(int eventType, XmlPullParser xpp, MedicationAdministration res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.getDefinition().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, MedicationAdministration.MedicationAdministrationStatus.NULL, new MedicationAdministration.MedicationAdministrationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
            res.setMedication(this.parseType("medication", xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.getSupportingInformation().add(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
            res.setEffective(this.parseType("effective", xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseMedicationAdministrationMedicationAdministrationPerformerComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("notGiven")) {
            res.setNotGivenElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonNotGiven")) {
            res.getReasonNotGiven().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("prescription")) {
            res.setPrescription(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.getDevice().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dosage")) {
            res.setDosage(this.parseMedicationAdministrationMedicationAdministrationDosageComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("eventHistory")) {
            res.getEventHistory().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationAdministration.MedicationAdministrationPerformerComponent parseMedicationAdministrationMedicationAdministrationPerformerComponent(XmlPullParser xpp, MedicationAdministration owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationAdministration.MedicationAdministrationPerformerComponent res = new MedicationAdministration.MedicationAdministrationPerformerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationAdministrationMedicationAdministrationPerformerComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationAdministrationMedicationAdministrationPerformerComponentContent(int eventType, XmlPullParser xpp, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationMedicationAdministrationDosageComponent(XmlPullParser xpp, MedicationAdministration owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationAdministration.MedicationAdministrationDosageComponent res = new MedicationAdministration.MedicationAdministrationDosageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationAdministrationMedicationAdministrationDosageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationAdministrationMedicationAdministrationDosageComponentContent(int eventType, XmlPullParser xpp, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationDosageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("site")) {
            res.setSite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("route")) {
            res.setRoute(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("method")) {
            res.setMethod(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dose")) {
            res.setDose(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
            res.setRate(this.parseType("rate", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationDispense parseMedicationDispense(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationDispense res = new MedicationDispense();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationDispenseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationDispenseContent(int eventType, XmlPullParser xpp, MedicationDispense res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, MedicationDispense.MedicationDispenseStatus.NULL, new MedicationDispense.MedicationDispenseStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
            res.setMedication(this.parseType("medication", xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.getSupportingInformation().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseMedicationDispenseMedicationDispensePerformerComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("authorizingPrescription")) {
            res.getAuthorizingPrescription().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("daysSupply")) {
            res.setDaysSupply(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("whenPrepared")) {
            res.setWhenPreparedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("whenHandedOver")) {
            res.setWhenHandedOverElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("destination")) {
            res.setDestination(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("receiver")) {
            res.getReceiver().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dosageInstruction")) {
            res.getDosageInstruction().add(this.parseDosage(xpp));
        } else if (eventType == 2 && xpp.getName().equals("substitution")) {
            res.setSubstitution(this.parseMedicationDispenseMedicationDispenseSubstitutionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("detectedIssue")) {
            res.getDetectedIssue().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("notDone")) {
            res.setNotDoneElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "notDoneReason")) {
            res.setNotDoneReason(this.parseType("notDoneReason", xpp));
        } else if (eventType == 2 && xpp.getName().equals("eventHistory")) {
            res.getEventHistory().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationDispense.MedicationDispensePerformerComponent parseMedicationDispenseMedicationDispensePerformerComponent(XmlPullParser xpp, MedicationDispense owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationDispense.MedicationDispensePerformerComponent res = new MedicationDispense.MedicationDispensePerformerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationDispenseMedicationDispensePerformerComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationDispenseMedicationDispensePerformerComponentContent(int eventType, XmlPullParser xpp, MedicationDispense owner, MedicationDispense.MedicationDispensePerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseMedicationDispenseSubstitutionComponent(XmlPullParser xpp, MedicationDispense owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationDispense.MedicationDispenseSubstitutionComponent res = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationDispenseMedicationDispenseSubstitutionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationDispenseMedicationDispenseSubstitutionComponentContent(int eventType, XmlPullParser xpp, MedicationDispense owner, MedicationDispense.MedicationDispenseSubstitutionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("wasSubstituted")) {
            res.setWasSubstitutedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("responsibleParty")) {
            res.getResponsibleParty().add(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationRequest parseMedicationRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationRequest res = new MedicationRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationRequestContent(int eventType, XmlPullParser xpp, MedicationRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.getDefinition().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, MedicationRequest.MedicationRequestStatus.NULL, new MedicationRequest.MedicationRequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntentElement(this.parseEnumeration(xpp, MedicationRequest.MedicationRequestIntent.NULL, new MedicationRequest.MedicationRequestIntentEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, MedicationRequest.MedicationRequestPriority.NULL, new MedicationRequest.MedicationRequestPriorityEnumFactory()));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
            res.setMedication(this.parseType("medication", xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.getSupportingInformation().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requester")) {
            res.setRequester(this.parseMedicationRequestMedicationRequestRequesterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("recorder")) {
            res.setRecorder(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dosageInstruction")) {
            res.getDosageInstruction().add(this.parseDosage(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dispenseRequest")) {
            res.setDispenseRequest(this.parseMedicationRequestMedicationRequestDispenseRequestComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("substitution")) {
            res.setSubstitution(this.parseMedicationRequestMedicationRequestSubstitutionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("priorPrescription")) {
            res.setPriorPrescription(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detectedIssue")) {
            res.getDetectedIssue().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("eventHistory")) {
            res.getEventHistory().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationRequest.MedicationRequestRequesterComponent parseMedicationRequestMedicationRequestRequesterComponent(XmlPullParser xpp, MedicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationRequest.MedicationRequestRequesterComponent res = new MedicationRequest.MedicationRequestRequesterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationRequestMedicationRequestRequesterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationRequestMedicationRequestRequesterComponentContent(int eventType, XmlPullParser xpp, MedicationRequest owner, MedicationRequest.MedicationRequestRequesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("agent")) {
            res.setAgent(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationRequest.MedicationRequestDispenseRequestComponent parseMedicationRequestMedicationRequestDispenseRequestComponent(XmlPullParser xpp, MedicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationRequest.MedicationRequestDispenseRequestComponent res = new MedicationRequest.MedicationRequestDispenseRequestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationRequestMedicationRequestDispenseRequestComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationRequestMedicationRequestDispenseRequestComponentContent(int eventType, XmlPullParser xpp, MedicationRequest owner, MedicationRequest.MedicationRequestDispenseRequestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("validityPeriod")) {
            res.setValidityPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfRepeatsAllowed")) {
            res.setNumberOfRepeatsAllowedElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expectedSupplyDuration")) {
            res.setExpectedSupplyDuration(this.parseDuration(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationRequest.MedicationRequestSubstitutionComponent parseMedicationRequestMedicationRequestSubstitutionComponent(XmlPullParser xpp, MedicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationRequest.MedicationRequestSubstitutionComponent res = new MedicationRequest.MedicationRequestSubstitutionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationRequestMedicationRequestSubstitutionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationRequestMedicationRequestSubstitutionComponentContent(int eventType, XmlPullParser xpp, MedicationRequest owner, MedicationRequest.MedicationRequestSubstitutionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("allowed")) {
            res.setAllowedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationStatement parseMedicationStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationStatement res = new MedicationStatement();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationStatementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationStatementContent(int eventType, XmlPullParser xpp, MedicationStatement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, MedicationStatement.MedicationStatementStatus.NULL, new MedicationStatement.MedicationStatementStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
            res.setMedication(this.parseType("medication", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
            res.setEffective(this.parseType("effective", xpp));
        } else if (eventType == 2 && xpp.getName().equals("dateAsserted")) {
            res.setDateAssertedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("informationSource")) {
            res.setInformationSource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("derivedFrom")) {
            res.getDerivedFrom().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("taken")) {
            res.setTakenElement(this.parseEnumeration(xpp, MedicationStatement.MedicationStatementTaken.NULL, new MedicationStatement.MedicationStatementTakenEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("reasonNotTaken")) {
            res.getReasonNotTaken().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dosage")) {
            res.getDosage().add(this.parseDosage(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MessageDefinition parseMessageDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageDefinition res = new MessageDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMessageDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMessageDefinitionContent(int eventType, XmlPullParser xpp, MessageDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("base")) {
            res.setBase(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parent")) {
            res.getParent().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("replaces")) {
            res.getReplaces().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("event")) {
            res.setEvent(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategoryElement(this.parseEnumeration(xpp, MessageDefinition.MessageSignificanceCategory.NULL, new MessageDefinition.MessageSignificanceCategoryEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("focus")) {
            res.getFocus().add(this.parseMessageDefinitionMessageDefinitionFocusComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("responseRequired")) {
            res.setResponseRequiredElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("allowedResponse")) {
            res.getAllowedResponse().add(this.parseMessageDefinitionMessageDefinitionAllowedResponseComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MessageDefinition.MessageDefinitionFocusComponent parseMessageDefinitionMessageDefinitionFocusComponent(XmlPullParser xpp, MessageDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageDefinition.MessageDefinitionFocusComponent res = new MessageDefinition.MessageDefinitionFocusComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMessageDefinitionMessageDefinitionFocusComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMessageDefinitionMessageDefinitionFocusComponentContent(int eventType, XmlPullParser xpp, MessageDefinition owner, MessageDefinition.MessageDefinitionFocusComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfile(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MessageDefinition.MessageDefinitionAllowedResponseComponent parseMessageDefinitionMessageDefinitionAllowedResponseComponent(XmlPullParser xpp, MessageDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageDefinition.MessageDefinitionAllowedResponseComponent res = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMessageDefinitionMessageDefinitionAllowedResponseComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMessageDefinitionMessageDefinitionAllowedResponseComponentContent(int eventType, XmlPullParser xpp, MessageDefinition owner, MessageDefinition.MessageDefinitionAllowedResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("message")) {
            res.setMessage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("situation")) {
            res.setSituationElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MessageHeader parseMessageHeader(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader res = new MessageHeader();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMessageHeaderContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMessageHeaderContent(int eventType, XmlPullParser xpp, MessageHeader res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("event")) {
            res.setEvent(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("destination")) {
            res.getDestination().add(this.parseMessageHeaderMessageDestinationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("receiver")) {
            res.setReceiver(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sender")) {
            res.setSender(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("timestamp")) {
            res.setTimestampElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enterer")) {
            res.setEnterer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseMessageHeaderMessageSourceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("responsible")) {
            res.setResponsible(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("response")) {
            res.setResponse(this.parseMessageHeaderMessageHeaderResponseComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("focus")) {
            res.getFocus().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader.MessageDestinationComponent res = new MessageHeader.MessageDestinationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMessageHeaderMessageDestinationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMessageHeaderMessageDestinationComponentContent(int eventType, XmlPullParser xpp, MessageHeader owner, MessageHeader.MessageDestinationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTarget(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.setEndpointElement(this.parseUri(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader.MessageSourceComponent res = new MessageHeader.MessageSourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMessageHeaderMessageSourceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMessageHeaderMessageSourceComponentContent(int eventType, XmlPullParser xpp, MessageHeader owner, MessageHeader.MessageSourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("software")) {
            res.setSoftwareElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.setContact(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.setEndpointElement(this.parseUri(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MessageHeader.MessageHeaderResponseComponent parseMessageHeaderMessageHeaderResponseComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader.MessageHeaderResponseComponent res = new MessageHeader.MessageHeaderResponseComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMessageHeaderMessageHeaderResponseComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMessageHeaderMessageHeaderResponseComponentContent(int eventType, XmlPullParser xpp, MessageHeader owner, MessageHeader.MessageHeaderResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifierElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, MessageHeader.ResponseType.NULL, new MessageHeader.ResponseTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("details")) {
            res.setDetails(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NamingSystem parseNamingSystem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        NamingSystem res = new NamingSystem();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNamingSystemContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNamingSystemContent(int eventType, XmlPullParser xpp, NamingSystem res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, NamingSystem.NamingSystemType.NULL, new NamingSystem.NamingSystemTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("responsible")) {
            res.setResponsibleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.setUsageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("uniqueId")) {
            res.getUniqueId().add(this.parseNamingSystemNamingSystemUniqueIdComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("replacedBy")) {
            res.setReplacedBy(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NamingSystem.NamingSystemUniqueIdComponent parseNamingSystemNamingSystemUniqueIdComponent(XmlPullParser xpp, NamingSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NamingSystem.NamingSystemUniqueIdComponent res = new NamingSystem.NamingSystemUniqueIdComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNamingSystemNamingSystemUniqueIdComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNamingSystemNamingSystemUniqueIdComponentContent(int eventType, XmlPullParser xpp, NamingSystem owner, NamingSystem.NamingSystemUniqueIdComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, NamingSystem.NamingSystemIdentifierType.NULL, new NamingSystem.NamingSystemIdentifierTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preferred")) {
            res.setPreferredElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NutritionOrder parseNutritionOrder(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder res = new NutritionOrder();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNutritionOrderContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNutritionOrderContent(int eventType, XmlPullParser xpp, NutritionOrder res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, NutritionOrder.NutritionOrderStatus.NULL, new NutritionOrder.NutritionOrderStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dateTime")) {
            res.setDateTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("orderer")) {
            res.setOrderer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("allergyIntolerance")) {
            res.getAllergyIntolerance().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("foodPreferenceModifier")) {
            res.getFoodPreferenceModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("excludeFoodModifier")) {
            res.getExcludeFoodModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("oralDiet")) {
            res.setOralDiet(this.parseNutritionOrderNutritionOrderOralDietComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("supplement")) {
            res.getSupplement().add(this.parseNutritionOrderNutritionOrderSupplementComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("enteralFormula")) {
            res.setEnteralFormula(this.parseNutritionOrderNutritionOrderEnteralFormulaComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NutritionOrder.NutritionOrderOralDietComponent parseNutritionOrderNutritionOrderOralDietComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietComponent res = new NutritionOrder.NutritionOrderOralDietComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNutritionOrderNutritionOrderOralDietComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNutritionOrderNutritionOrderOralDietComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("schedule")) {
            res.getSchedule().add(this.parseTiming(xpp));
        } else if (eventType == 2 && xpp.getName().equals("nutrient")) {
            res.getNutrient().add(this.parseNutritionOrderNutritionOrderOralDietNutrientComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("texture")) {
            res.getTexture().add(this.parseNutritionOrderNutritionOrderOralDietTextureComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("fluidConsistencyType")) {
            res.getFluidConsistencyType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instruction")) {
            res.setInstructionElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NutritionOrder.NutritionOrderOralDietNutrientComponent parseNutritionOrderNutritionOrderOralDietNutrientComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietNutrientComponent res = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNutritionOrderNutritionOrderOralDietNutrientComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNutritionOrderNutritionOrderOralDietNutrientComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietNutrientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.setModifier(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseSimpleQuantity(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NutritionOrder.NutritionOrderOralDietTextureComponent parseNutritionOrderNutritionOrderOralDietTextureComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietTextureComponent res = new NutritionOrder.NutritionOrderOralDietTextureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNutritionOrderNutritionOrderOralDietTextureComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNutritionOrderNutritionOrderOralDietTextureComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietTextureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.setModifier(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("foodType")) {
            res.setFoodType(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NutritionOrder.NutritionOrderSupplementComponent parseNutritionOrderNutritionOrderSupplementComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderSupplementComponent res = new NutritionOrder.NutritionOrderSupplementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNutritionOrderNutritionOrderSupplementComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNutritionOrderNutritionOrderSupplementComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderSupplementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productName")) {
            res.setProductNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("schedule")) {
            res.getSchedule().add(this.parseTiming(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instruction")) {
            res.setInstructionElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NutritionOrder.NutritionOrderEnteralFormulaComponent parseNutritionOrderNutritionOrderEnteralFormulaComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderEnteralFormulaComponent res = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNutritionOrderNutritionOrderEnteralFormulaComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNutritionOrderNutritionOrderEnteralFormulaComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderEnteralFormulaComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("baseFormulaType")) {
            res.setBaseFormulaType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("baseFormulaProductName")) {
            res.setBaseFormulaProductNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("additiveType")) {
            res.setAdditiveType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("additiveProductName")) {
            res.setAdditiveProductNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("caloricDensity")) {
            res.setCaloricDensity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("routeofAdministration")) {
            res.setRouteofAdministration(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("administration")) {
            res.getAdministration().add(this.parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("maxVolumeToDeliver")) {
            res.setMaxVolumeToDeliver(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("administrationInstruction")) {
            res.setAdministrationInstructionElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("schedule")) {
            res.setSchedule(this.parseTiming(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
            res.setRate(this.parseType("rate", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Observation parseObservation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Observation res = new Observation();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseObservationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseObservationContent(int eventType, XmlPullParser xpp, Observation res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Observation.ObservationStatus.NULL, new Observation.ObservationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
            res.setEffective(this.parseType("effective", xpp));
        } else if (eventType == 2 && xpp.getName().equals("issued")) {
            res.setIssuedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("dataAbsentReason")) {
            res.setDataAbsentReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("interpretation")) {
            res.setInterpretation(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("method")) {
            res.setMethod(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specimen")) {
            res.setSpecimen(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.setDevice(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceRange")) {
            res.getReferenceRange().add(this.parseObservationObservationReferenceRangeComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("related")) {
            res.getRelated().add(this.parseObservationObservationRelatedComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("component")) {
            res.getComponent().add(this.parseObservationObservationComponentComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Observation.ObservationReferenceRangeComponent parseObservationObservationReferenceRangeComponent(XmlPullParser xpp, Observation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Observation.ObservationReferenceRangeComponent res = new Observation.ObservationReferenceRangeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseObservationObservationReferenceRangeComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseObservationObservationReferenceRangeComponentContent(int eventType, XmlPullParser xpp, Observation owner, Observation.ObservationReferenceRangeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("low")) {
            res.setLow(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("high")) {
            res.setHigh(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("appliesTo")) {
            res.getAppliesTo().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("age")) {
            res.setAge(this.parseRange(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Observation.ObservationRelatedComponent parseObservationObservationRelatedComponent(XmlPullParser xpp, Observation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Observation.ObservationRelatedComponent res = new Observation.ObservationRelatedComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseObservationObservationRelatedComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseObservationObservationRelatedComponentContent(int eventType, XmlPullParser xpp, Observation owner, Observation.ObservationRelatedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Observation.ObservationRelationshipType.NULL, new Observation.ObservationRelationshipTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTarget(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Observation.ObservationComponentComponent parseObservationObservationComponentComponent(XmlPullParser xpp, Observation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Observation.ObservationComponentComponent res = new Observation.ObservationComponentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseObservationObservationComponentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseObservationObservationComponentComponentContent(int eventType, XmlPullParser xpp, Observation owner, Observation.ObservationComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("dataAbsentReason")) {
            res.setDataAbsentReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("interpretation")) {
            res.setInterpretation(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceRange")) {
            res.getReferenceRange().add(this.parseObservationObservationReferenceRangeComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected OperationDefinition parseOperationDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationDefinition res = new OperationDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseOperationDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseOperationDefinitionContent(int eventType, XmlPullParser xpp, OperationDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, OperationDefinition.OperationKind.NULL, new OperationDefinition.OperationKindEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("idempotent")) {
            res.setIdempotentElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("base")) {
            res.setBase(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.getResource().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instance")) {
            res.setInstanceElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parameter")) {
            res.getParameter().add(this.parseOperationDefinitionOperationDefinitionParameterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("overload")) {
            res.getOverload().add(this.parseOperationDefinitionOperationDefinitionOverloadComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected OperationDefinition.OperationDefinitionParameterComponent parseOperationDefinitionOperationDefinitionParameterComponent(XmlPullParser xpp, OperationDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionParameterComponent res = new OperationDefinition.OperationDefinitionParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseOperationDefinitionOperationDefinitionParameterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseOperationDefinitionOperationDefinitionParameterComponentContent(int eventType, XmlPullParser xpp, OperationDefinition owner, OperationDefinition.OperationDefinitionParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, OperationDefinition.OperationParameterUse.NULL, new OperationDefinition.OperationParameterUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("searchType")) {
            res.setSearchTypeElement(this.parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfile(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("binding")) {
            res.setBinding(this.parseOperationDefinitionOperationDefinitionParameterBindingComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("part")) {
            res.getPart().add(this.parseOperationDefinitionOperationDefinitionParameterComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected OperationDefinition.OperationDefinitionParameterBindingComponent parseOperationDefinitionOperationDefinitionParameterBindingComponent(XmlPullParser xpp, OperationDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionParameterBindingComponent res = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseOperationDefinitionOperationDefinitionParameterBindingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseOperationDefinitionOperationDefinitionParameterBindingComponentContent(int eventType, XmlPullParser xpp, OperationDefinition owner, OperationDefinition.OperationDefinitionParameterBindingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("strength")) {
            res.setStrengthElement(this.parseEnumeration(xpp, Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "valueSet")) {
            res.setValueSet(this.parseType("valueSet", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected OperationDefinition.OperationDefinitionOverloadComponent parseOperationDefinitionOperationDefinitionOverloadComponent(XmlPullParser xpp, OperationDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionOverloadComponent res = new OperationDefinition.OperationDefinitionOverloadComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseOperationDefinitionOperationDefinitionOverloadComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseOperationDefinitionOperationDefinitionOverloadComponentContent(int eventType, XmlPullParser xpp, OperationDefinition owner, OperationDefinition.OperationDefinitionOverloadComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("parameterName")) {
            res.getParameterName().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected OperationOutcome parseOperationOutcome(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationOutcome res = new OperationOutcome();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseOperationOutcomeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseOperationOutcomeContent(int eventType, XmlPullParser xpp, OperationOutcome res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("issue")) {
            res.getIssue().add(this.parseOperationOutcomeOperationOutcomeIssueComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected OperationOutcome.OperationOutcomeIssueComponent parseOperationOutcomeOperationOutcomeIssueComponent(XmlPullParser xpp, OperationOutcome owner) throws XmlPullParserException, IOException, FHIRFormatError {
        OperationOutcome.OperationOutcomeIssueComponent res = new OperationOutcome.OperationOutcomeIssueComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseOperationOutcomeOperationOutcomeIssueComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseOperationOutcomeOperationOutcomeIssueComponentContent(int eventType, XmlPullParser xpp, OperationOutcome owner, OperationOutcome.OperationOutcomeIssueComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverityElement(this.parseEnumeration(xpp, OperationOutcome.IssueSeverity.NULL, new OperationOutcome.IssueSeverityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, OperationOutcome.IssueType.NULL, new OperationOutcome.IssueTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("details")) {
            res.setDetails(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnostics")) {
            res.setDiagnosticsElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.getLocation().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.getExpression().add(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Organization parseOrganization(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Organization res = new Organization();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseOrganizationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseOrganizationContent(int eventType, XmlPullParser xpp, Organization res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("alias")) {
            res.getAlias().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.getAddress().add(this.parseAddress(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.setPartOf(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseOrganizationOrganizationContactComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Organization.OrganizationContactComponent parseOrganizationOrganizationContactComponent(XmlPullParser xpp, Organization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Organization.OrganizationContactComponent res = new Organization.OrganizationContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseOrganizationOrganizationContactComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseOrganizationOrganizationContactComponentContent(int eventType, XmlPullParser xpp, Organization owner, Organization.OrganizationContactComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurpose(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setName(this.parseHumanName(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.setAddress(this.parseAddress(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Patient parsePatient(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Patient res = new Patient();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePatientContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePatientContent(int eventType, XmlPullParser xpp, Patient res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.getName().add(this.parseHumanName(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("gender")) {
            res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("birthDate")) {
            res.setBirthDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "deceased")) {
            res.setDeceased(this.parseType("deceased", xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.getAddress().add(this.parseAddress(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maritalStatus")) {
            res.setMaritalStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "multipleBirth")) {
            res.setMultipleBirth(this.parseType("multipleBirth", xpp));
        } else if (eventType == 2 && xpp.getName().equals("photo")) {
            res.getPhoto().add(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parsePatientContactComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("animal")) {
            res.setAnimal(this.parsePatientAnimalComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("communication")) {
            res.getCommunication().add(this.parsePatientPatientCommunicationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("generalPractitioner")) {
            res.getGeneralPractitioner().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parsePatientPatientLinkComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Patient.ContactComponent parsePatientContactComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Patient.ContactComponent res = new Patient.ContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePatientContactComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePatientContactComponentContent(int eventType, XmlPullParser xpp, Patient owner, Patient.ContactComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.getRelationship().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setName(this.parseHumanName(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.setAddress(this.parseAddress(xpp));
        } else if (eventType == 2 && xpp.getName().equals("gender")) {
            res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.setOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Patient.AnimalComponent parsePatientAnimalComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Patient.AnimalComponent res = new Patient.AnimalComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePatientAnimalComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePatientAnimalComponentContent(int eventType, XmlPullParser xpp, Patient owner, Patient.AnimalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("species")) {
            res.setSpecies(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("breed")) {
            res.setBreed(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("genderStatus")) {
            res.setGenderStatus(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Patient.PatientCommunicationComponent parsePatientPatientCommunicationComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Patient.PatientCommunicationComponent res = new Patient.PatientCommunicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePatientPatientCommunicationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePatientPatientCommunicationComponentContent(int eventType, XmlPullParser xpp, Patient owner, Patient.PatientCommunicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preferred")) {
            res.setPreferredElement(this.parseBoolean(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Patient.PatientLinkComponent parsePatientPatientLinkComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Patient.PatientLinkComponent res = new Patient.PatientLinkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePatientPatientLinkComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePatientPatientLinkComponentContent(int eventType, XmlPullParser xpp, Patient owner, Patient.PatientLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("other")) {
            res.setOther(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Patient.LinkType.NULL, new Patient.LinkTypeEnumFactory()));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PaymentNotice parsePaymentNotice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PaymentNotice res = new PaymentNotice();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePaymentNoticeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePaymentNoticeContent(int eventType, XmlPullParser xpp, PaymentNotice res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, PaymentNotice.PaymentNoticeStatus.NULL, new PaymentNotice.PaymentNoticeStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("response")) {
            res.setResponse(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("statusDate")) {
            res.setStatusDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTarget(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.setOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("paymentStatus")) {
            res.setPaymentStatus(this.parseCodeableConcept(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PaymentReconciliation parsePaymentReconciliation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PaymentReconciliation res = new PaymentReconciliation();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePaymentReconciliationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePaymentReconciliationContent(int eventType, XmlPullParser xpp, PaymentReconciliation res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, PaymentReconciliation.PaymentReconciliationStatus.NULL, new PaymentReconciliation.PaymentReconciliationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.setOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("disposition")) {
            res.setDispositionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestProvider")) {
            res.setRequestProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parsePaymentReconciliationDetailsComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("form")) {
            res.setForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("total")) {
            res.setTotal(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("processNote")) {
            res.getProcessNote().add(this.parsePaymentReconciliationNotesComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PaymentReconciliation.DetailsComponent parsePaymentReconciliationDetailsComponent(XmlPullParser xpp, PaymentReconciliation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PaymentReconciliation.DetailsComponent res = new PaymentReconciliation.DetailsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePaymentReconciliationDetailsComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePaymentReconciliationDetailsComponentContent(int eventType, XmlPullParser xpp, PaymentReconciliation owner, PaymentReconciliation.DetailsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("response")) {
            res.setResponse(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("submitter")) {
            res.setSubmitter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payee")) {
            res.setPayee(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PaymentReconciliation.NotesComponent parsePaymentReconciliationNotesComponent(XmlPullParser xpp, PaymentReconciliation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PaymentReconciliation.NotesComponent res = new PaymentReconciliation.NotesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePaymentReconciliationNotesComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePaymentReconciliationNotesComponentContent(int eventType, XmlPullParser xpp, PaymentReconciliation owner, PaymentReconciliation.NotesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Person parsePerson(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Person res = new Person();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePersonContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePersonContent(int eventType, XmlPullParser xpp, Person res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.getName().add(this.parseHumanName(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("gender")) {
            res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("birthDate")) {
            res.setBirthDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.getAddress().add(this.parseAddress(xpp));
        } else if (eventType == 2 && xpp.getName().equals("photo")) {
            res.setPhoto(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parsePersonPersonLinkComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Person.PersonLinkComponent parsePersonPersonLinkComponent(XmlPullParser xpp, Person owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Person.PersonLinkComponent res = new Person.PersonLinkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePersonPersonLinkComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePersonPersonLinkComponentContent(int eventType, XmlPullParser xpp, Person owner, Person.PersonLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTarget(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("assurance")) {
            res.setAssuranceElement(this.parseEnumeration(xpp, Person.IdentityAssuranceLevel.NULL, new Person.IdentityAssuranceLevelEnumFactory()));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PlanDefinition parsePlanDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PlanDefinition res = new PlanDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePlanDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePlanDefinitionContent(int eventType, XmlPullParser xpp, PlanDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.setUsageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributor")) {
            res.getContributor().add(this.parseContributor(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("library")) {
            res.getLibrary().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("goal")) {
            res.getGoal().add(this.parsePlanDefinitionPlanDefinitionGoalComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parsePlanDefinitionPlanDefinitionActionComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PlanDefinition.PlanDefinitionGoalComponent parsePlanDefinitionPlanDefinitionGoalComponent(XmlPullParser xpp, PlanDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PlanDefinition.PlanDefinitionGoalComponent res = new PlanDefinition.PlanDefinitionGoalComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePlanDefinitionPlanDefinitionGoalComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePlanDefinitionPlanDefinitionGoalComponentContent(int eventType, XmlPullParser xpp, PlanDefinition owner, PlanDefinition.PlanDefinitionGoalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescription(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStart(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("addresses")) {
            res.getAddresses().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.getDocumentation().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.getTarget().add(this.parsePlanDefinitionPlanDefinitionGoalTargetComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PlanDefinition.PlanDefinitionGoalTargetComponent parsePlanDefinitionPlanDefinitionGoalTargetComponent(XmlPullParser xpp, PlanDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PlanDefinition.PlanDefinitionGoalTargetComponent res = new PlanDefinition.PlanDefinitionGoalTargetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePlanDefinitionPlanDefinitionGoalTargetComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePlanDefinitionPlanDefinitionGoalTargetComponentContent(int eventType, XmlPullParser xpp, PlanDefinition owner, PlanDefinition.PlanDefinitionGoalTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("measure")) {
            res.setMeasure(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "detail")) {
            res.setDetail(this.parseType("detail", xpp));
        } else if (eventType == 2 && xpp.getName().equals("due")) {
            res.setDue(this.parseDuration(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PlanDefinition.PlanDefinitionActionComponent parsePlanDefinitionPlanDefinitionActionComponent(XmlPullParser xpp, PlanDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PlanDefinition.PlanDefinitionActionComponent res = new PlanDefinition.PlanDefinitionActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePlanDefinitionPlanDefinitionActionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePlanDefinitionPlanDefinitionActionComponentContent(int eventType, XmlPullParser xpp, PlanDefinition owner, PlanDefinition.PlanDefinitionActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("label")) {
            res.setLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("textEquivalent")) {
            res.setTextEquivalentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.getDocumentation().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("goalId")) {
            res.getGoalId().add(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("triggerDefinition")) {
            res.getTriggerDefinition().add(this.parseTriggerDefinition(xpp));
        } else if (eventType == 2 && xpp.getName().equals("condition")) {
            res.getCondition().add(this.parsePlanDefinitionPlanDefinitionActionConditionComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("input")) {
            res.getInput().add(this.parseDataRequirement(xpp));
        } else if (eventType == 2 && xpp.getName().equals("output")) {
            res.getOutput().add(this.parseDataRequirement(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedAction")) {
            res.getRelatedAction().add(this.parsePlanDefinitionPlanDefinitionActionRelatedActionComponent(xpp, owner));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parsePlanDefinitionPlanDefinitionActionParticipantComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupingBehavior")) {
            res.setGroupingBehaviorElement(this.parseEnumeration(xpp, PlanDefinition.ActionGroupingBehavior.NULL, new PlanDefinition.ActionGroupingBehaviorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("selectionBehavior")) {
            res.setSelectionBehaviorElement(this.parseEnumeration(xpp, PlanDefinition.ActionSelectionBehavior.NULL, new PlanDefinition.ActionSelectionBehaviorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("requiredBehavior")) {
            res.setRequiredBehaviorElement(this.parseEnumeration(xpp, PlanDefinition.ActionRequiredBehavior.NULL, new PlanDefinition.ActionRequiredBehaviorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("precheckBehavior")) {
            res.setPrecheckBehaviorElement(this.parseEnumeration(xpp, PlanDefinition.ActionPrecheckBehavior.NULL, new PlanDefinition.ActionPrecheckBehaviorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("cardinalityBehavior")) {
            res.setCardinalityBehaviorElement(this.parseEnumeration(xpp, PlanDefinition.ActionCardinalityBehavior.NULL, new PlanDefinition.ActionCardinalityBehaviorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinition(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("transform")) {
            res.setTransform(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dynamicValue")) {
            res.getDynamicValue().add(this.parsePlanDefinitionPlanDefinitionActionDynamicValueComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parsePlanDefinitionPlanDefinitionActionComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PlanDefinition.PlanDefinitionActionConditionComponent parsePlanDefinitionPlanDefinitionActionConditionComponent(XmlPullParser xpp, PlanDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PlanDefinition.PlanDefinitionActionConditionComponent res = new PlanDefinition.PlanDefinitionActionConditionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePlanDefinitionPlanDefinitionActionConditionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePlanDefinitionPlanDefinitionActionConditionComponentContent(int eventType, XmlPullParser xpp, PlanDefinition owner, PlanDefinition.PlanDefinitionActionConditionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, PlanDefinition.ActionConditionKind.NULL, new PlanDefinition.ActionConditionKindEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PlanDefinition.PlanDefinitionActionRelatedActionComponent parsePlanDefinitionPlanDefinitionActionRelatedActionComponent(XmlPullParser xpp, PlanDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PlanDefinition.PlanDefinitionActionRelatedActionComponent res = new PlanDefinition.PlanDefinitionActionRelatedActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePlanDefinitionPlanDefinitionActionRelatedActionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePlanDefinitionPlanDefinitionActionRelatedActionComponentContent(int eventType, XmlPullParser xpp, PlanDefinition owner, PlanDefinition.PlanDefinitionActionRelatedActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("actionId")) {
            res.setActionIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationshipElement(this.parseEnumeration(xpp, PlanDefinition.ActionRelationshipType.NULL, new PlanDefinition.ActionRelationshipTypeEnumFactory()));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "offset")) {
            res.setOffset(this.parseType("offset", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PlanDefinition.PlanDefinitionActionParticipantComponent parsePlanDefinitionPlanDefinitionActionParticipantComponent(XmlPullParser xpp, PlanDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PlanDefinition.PlanDefinitionActionParticipantComponent res = new PlanDefinition.PlanDefinitionActionParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePlanDefinitionPlanDefinitionActionParticipantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePlanDefinitionPlanDefinitionActionParticipantComponentContent(int eventType, XmlPullParser xpp, PlanDefinition owner, PlanDefinition.PlanDefinitionActionParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, PlanDefinition.ActionParticipantType.NULL, new PlanDefinition.ActionParticipantTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PlanDefinition.PlanDefinitionActionDynamicValueComponent parsePlanDefinitionPlanDefinitionActionDynamicValueComponent(XmlPullParser xpp, PlanDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PlanDefinition.PlanDefinitionActionDynamicValueComponent res = new PlanDefinition.PlanDefinitionActionDynamicValueComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePlanDefinitionPlanDefinitionActionDynamicValueComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePlanDefinitionPlanDefinitionActionDynamicValueComponentContent(int eventType, XmlPullParser xpp, PlanDefinition owner, PlanDefinition.PlanDefinitionActionDynamicValueComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Practitioner parsePractitioner(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Practitioner res = new Practitioner();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePractitionerContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePractitionerContent(int eventType, XmlPullParser xpp, Practitioner res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.getName().add(this.parseHumanName(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.getAddress().add(this.parseAddress(xpp));
        } else if (eventType == 2 && xpp.getName().equals("gender")) {
            res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("birthDate")) {
            res.setBirthDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("photo")) {
            res.getPhoto().add(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("qualification")) {
            res.getQualification().add(this.parsePractitionerPractitionerQualificationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("communication")) {
            res.getCommunication().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Practitioner.PractitionerQualificationComponent parsePractitionerPractitionerQualificationComponent(XmlPullParser xpp, Practitioner owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Practitioner.PractitionerQualificationComponent res = new Practitioner.PractitionerQualificationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePractitionerPractitionerQualificationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePractitionerPractitionerQualificationComponentContent(int eventType, XmlPullParser xpp, Practitioner owner, Practitioner.PractitionerQualificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issuer")) {
            res.setIssuer(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PractitionerRole parsePractitionerRole(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PractitionerRole res = new PractitionerRole();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePractitionerRoleContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePractitionerRoleContent(int eventType, XmlPullParser xpp, PractitionerRole res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("practitioner")) {
            res.setPractitioner(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.setOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialty")) {
            res.getSpecialty().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.getLocation().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("healthcareService")) {
            res.getHealthcareService().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("availableTime")) {
            res.getAvailableTime().add(this.parsePractitionerRolePractitionerRoleAvailableTimeComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("notAvailable")) {
            res.getNotAvailable().add(this.parsePractitionerRolePractitionerRoleNotAvailableComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("availabilityExceptions")) {
            res.setAvailabilityExceptionsElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PractitionerRole.PractitionerRoleAvailableTimeComponent parsePractitionerRolePractitionerRoleAvailableTimeComponent(XmlPullParser xpp, PractitionerRole owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PractitionerRole.PractitionerRoleAvailableTimeComponent res = new PractitionerRole.PractitionerRoleAvailableTimeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePractitionerRolePractitionerRoleAvailableTimeComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePractitionerRolePractitionerRoleAvailableTimeComponentContent(int eventType, XmlPullParser xpp, PractitionerRole owner, PractitionerRole.PractitionerRoleAvailableTimeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("daysOfWeek")) {
            res.getDaysOfWeek().add(this.parseEnumeration(xpp, PractitionerRole.DaysOfWeek.NULL, new PractitionerRole.DaysOfWeekEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("allDay")) {
            res.setAllDayElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("availableStartTime")) {
            res.setAvailableStartTimeElement(this.parseTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("availableEndTime")) {
            res.setAvailableEndTimeElement(this.parseTime(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PractitionerRole.PractitionerRoleNotAvailableComponent parsePractitionerRolePractitionerRoleNotAvailableComponent(XmlPullParser xpp, PractitionerRole owner) throws XmlPullParserException, IOException, FHIRFormatError {
        PractitionerRole.PractitionerRoleNotAvailableComponent res = new PractitionerRole.PractitionerRoleNotAvailableComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePractitionerRolePractitionerRoleNotAvailableComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePractitionerRolePractitionerRoleNotAvailableComponentContent(int eventType, XmlPullParser xpp, PractitionerRole owner, PractitionerRole.PractitionerRoleNotAvailableComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("during")) {
            res.setDuring(this.parsePeriod(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Procedure parseProcedure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Procedure res = new Procedure();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseProcedureContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseProcedureContent(int eventType, XmlPullParser xpp, Procedure res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.getDefinition().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Procedure.ProcedureStatus.NULL, new Procedure.ProcedureStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("notDone")) {
            res.setNotDoneElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("notDoneReason")) {
            res.setNotDoneReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "performed")) {
            res.setPerformed(this.parseType("performed", xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseProcedureProcedurePerformerComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.getBodySite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("report")) {
            res.getReport().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("complication")) {
            res.getComplication().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("complicationDetail")) {
            res.getComplicationDetail().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("followUp")) {
            res.getFollowUp().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("focalDevice")) {
            res.getFocalDevice().add(this.parseProcedureProcedureFocalDeviceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("usedReference")) {
            res.getUsedReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usedCode")) {
            res.getUsedCode().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Procedure.ProcedurePerformerComponent parseProcedureProcedurePerformerComponent(XmlPullParser xpp, Procedure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Procedure.ProcedurePerformerComponent res = new Procedure.ProcedurePerformerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseProcedureProcedurePerformerComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseProcedureProcedurePerformerComponentContent(int eventType, XmlPullParser xpp, Procedure owner, Procedure.ProcedurePerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Procedure.ProcedureFocalDeviceComponent parseProcedureProcedureFocalDeviceComponent(XmlPullParser xpp, Procedure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Procedure.ProcedureFocalDeviceComponent res = new Procedure.ProcedureFocalDeviceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseProcedureProcedureFocalDeviceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseProcedureProcedureFocalDeviceComponentContent(int eventType, XmlPullParser xpp, Procedure owner, Procedure.ProcedureFocalDeviceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("action")) {
            res.setAction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manipulated")) {
            res.setManipulated(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ProcedureRequest parseProcedureRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcedureRequest res = new ProcedureRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseProcedureRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseProcedureRequestContent(int eventType, XmlPullParser xpp, ProcedureRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.getDefinition().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("replaces")) {
            res.getReplaces().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requisition")) {
            res.setRequisition(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ProcedureRequest.ProcedureRequestStatus.NULL, new ProcedureRequest.ProcedureRequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntentElement(this.parseEnumeration(xpp, ProcedureRequest.ProcedureRequestIntent.NULL, new ProcedureRequest.ProcedureRequestIntentEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, ProcedureRequest.ProcedureRequestPriority.NULL, new ProcedureRequest.ProcedureRequestPriorityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "asNeeded")) {
            res.setAsNeeded(this.parseType("asNeeded", xpp));
        } else if (eventType == 2 && xpp.getName().equals("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requester")) {
            res.setRequester(this.parseProcedureRequestProcedureRequestRequesterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("performerType")) {
            res.setPerformerType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specimen")) {
            res.getSpecimen().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.getBodySite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relevantHistory")) {
            res.getRelevantHistory().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ProcedureRequest.ProcedureRequestRequesterComponent parseProcedureRequestProcedureRequestRequesterComponent(XmlPullParser xpp, ProcedureRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcedureRequest.ProcedureRequestRequesterComponent res = new ProcedureRequest.ProcedureRequestRequesterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseProcedureRequestProcedureRequestRequesterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseProcedureRequestProcedureRequestRequesterComponentContent(int eventType, XmlPullParser xpp, ProcedureRequest owner, ProcedureRequest.ProcedureRequestRequesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("agent")) {
            res.setAgent(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ProcessRequest parseProcessRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcessRequest res = new ProcessRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseProcessRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseProcessRequestContent(int eventType, XmlPullParser xpp, ProcessRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ProcessRequest.ProcessRequestStatus.NULL, new ProcessRequest.ProcessRequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.setActionElement(this.parseEnumeration(xpp, ProcessRequest.ActionList.NULL, new ProcessRequest.ActionListEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTarget(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.setOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("response")) {
            res.setResponse(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("nullify")) {
            res.setNullifyElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReferenceElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseProcessRequestItemsComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("include")) {
            res.getInclude().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("exclude")) {
            res.getExclude().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ProcessRequest.ItemsComponent parseProcessRequestItemsComponent(XmlPullParser xpp, ProcessRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcessRequest.ItemsComponent res = new ProcessRequest.ItemsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseProcessRequestItemsComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseProcessRequestItemsComponentContent(int eventType, XmlPullParser xpp, ProcessRequest owner, ProcessRequest.ItemsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parseInteger(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ProcessResponse parseProcessResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcessResponse res = new ProcessResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseProcessResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseProcessResponseContent(int eventType, XmlPullParser xpp, ProcessResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ProcessResponse.ProcessResponseStatus.NULL, new ProcessResponse.ProcessResponseStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.setOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("disposition")) {
            res.setDispositionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestProvider")) {
            res.setRequestProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("form")) {
            res.setForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("processNote")) {
            res.getProcessNote().add(this.parseProcessResponseProcessResponseProcessNoteComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("error")) {
            res.getError().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("communicationRequest")) {
            res.getCommunicationRequest().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ProcessResponse.ProcessResponseProcessNoteComponent parseProcessResponseProcessResponseProcessNoteComponent(XmlPullParser xpp, ProcessResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ProcessResponse.ProcessResponseProcessNoteComponent res = new ProcessResponse.ProcessResponseProcessNoteComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseProcessResponseProcessResponseProcessNoteComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseProcessResponseProcessResponseProcessNoteComponentContent(int eventType, XmlPullParser xpp, ProcessResponse owner, ProcessResponse.ProcessResponseProcessNoteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Provenance parseProvenance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Provenance res = new Provenance();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseProvenanceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseProvenanceContent(int eventType, XmlPullParser xpp, Provenance res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("target")) {
            res.getTarget().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recorded")) {
            res.setRecordedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("policy")) {
            res.getPolicy().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("activity")) {
            res.setActivity(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("agent")) {
            res.getAgent().add(this.parseProvenanceProvenanceAgentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("entity")) {
            res.getEntity().add(this.parseProvenanceProvenanceEntityComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("signature")) {
            res.getSignature().add(this.parseSignature(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Provenance.ProvenanceAgentComponent parseProvenanceProvenanceAgentComponent(XmlPullParser xpp, Provenance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Provenance.ProvenanceAgentComponent res = new Provenance.ProvenanceAgentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseProvenanceProvenanceAgentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseProvenanceProvenanceAgentComponentContent(int eventType, XmlPullParser xpp, Provenance owner, Provenance.ProvenanceAgentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.getRole().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "who")) {
            res.setWho(this.parseType("who", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "onBehalfOf")) {
            res.setOnBehalfOf(this.parseType("onBehalfOf", xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedAgentType")) {
            res.setRelatedAgentType(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Provenance.ProvenanceEntityComponent parseProvenanceProvenanceEntityComponent(XmlPullParser xpp, Provenance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Provenance.ProvenanceEntityComponent res = new Provenance.ProvenanceEntityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseProvenanceProvenanceEntityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseProvenanceProvenanceEntityComponentContent(int eventType, XmlPullParser xpp, Provenance owner, Provenance.ProvenanceEntityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRoleElement(this.parseEnumeration(xpp, Provenance.ProvenanceEntityRole.NULL, new Provenance.ProvenanceEntityRoleEnumFactory()));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "what")) {
            res.setWhat(this.parseType("what", xpp));
        } else if (eventType == 2 && xpp.getName().equals("agent")) {
            res.getAgent().add(this.parseProvenanceProvenanceAgentComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Questionnaire parseQuestionnaire(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Questionnaire res = new Questionnaire();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseQuestionnaireContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseQuestionnaireContent(int eventType, XmlPullParser xpp, Questionnaire res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subjectType")) {
            res.getSubjectType().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseQuestionnaireQuestionnaireItemComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Questionnaire.QuestionnaireItemComponent parseQuestionnaireQuestionnaireItemComponent(XmlPullParser xpp, Questionnaire owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Questionnaire.QuestionnaireItemComponent res = new Questionnaire.QuestionnaireItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseQuestionnaireQuestionnaireItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseQuestionnaireQuestionnaireItemComponentContent(int eventType, XmlPullParser xpp, Questionnaire owner, Questionnaire.QuestionnaireItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("linkId")) {
            res.setLinkIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("prefix")) {
            res.setPrefixElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Questionnaire.QuestionnaireItemType.NULL, new Questionnaire.QuestionnaireItemTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("enableWhen")) {
            res.getEnableWhen().add(this.parseQuestionnaireQuestionnaireItemEnableWhenComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("required")) {
            res.setRequiredElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("repeats")) {
            res.setRepeatsElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("readOnly")) {
            res.setReadOnlyElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxLength")) {
            res.setMaxLengthElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("options")) {
            res.setOptions(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("option")) {
            res.getOption().add(this.parseQuestionnaireQuestionnaireItemOptionComponent(xpp, owner));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "initial")) {
            res.setInitial(this.parseType("initial", xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseQuestionnaireQuestionnaireItemComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Questionnaire.QuestionnaireItemEnableWhenComponent parseQuestionnaireQuestionnaireItemEnableWhenComponent(XmlPullParser xpp, Questionnaire owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Questionnaire.QuestionnaireItemEnableWhenComponent res = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseQuestionnaireQuestionnaireItemEnableWhenComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseQuestionnaireQuestionnaireItemEnableWhenComponentContent(int eventType, XmlPullParser xpp, Questionnaire owner, Questionnaire.QuestionnaireItemEnableWhenComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("question")) {
            res.setQuestionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hasAnswer")) {
            res.setHasAnswerElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "answer")) {
            res.setAnswer(this.parseType("answer", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Questionnaire.QuestionnaireItemOptionComponent parseQuestionnaireQuestionnaireItemOptionComponent(XmlPullParser xpp, Questionnaire owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Questionnaire.QuestionnaireItemOptionComponent res = new Questionnaire.QuestionnaireItemOptionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseQuestionnaireQuestionnaireItemOptionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseQuestionnaireQuestionnaireItemOptionComponentContent(int eventType, XmlPullParser xpp, Questionnaire owner, Questionnaire.QuestionnaireItemOptionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected QuestionnaireResponse parseQuestionnaireResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        QuestionnaireResponse res = new QuestionnaireResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseQuestionnaireResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseQuestionnaireResponseContent(int eventType, XmlPullParser xpp, QuestionnaireResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parent")) {
            res.getParent().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("questionnaire")) {
            res.setQuestionnaire(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, QuestionnaireResponse.QuestionnaireResponseStatus.NULL, new QuestionnaireResponse.QuestionnaireResponseStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authored")) {
            res.setAuthoredElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseQuestionnaireResponseQuestionnaireResponseItemComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected QuestionnaireResponse.QuestionnaireResponseItemComponent parseQuestionnaireResponseQuestionnaireResponseItemComponent(XmlPullParser xpp, QuestionnaireResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        QuestionnaireResponse.QuestionnaireResponseItemComponent res = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseQuestionnaireResponseQuestionnaireResponseItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseQuestionnaireResponseQuestionnaireResponseItemComponentContent(int eventType, XmlPullParser xpp, QuestionnaireResponse owner, QuestionnaireResponse.QuestionnaireResponseItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("linkId")) {
            res.setLinkIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("answer")) {
            res.getAnswer().add(this.parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseQuestionnaireResponseQuestionnaireResponseItemComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(XmlPullParser xpp, QuestionnaireResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent res = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponentContent(int eventType, XmlPullParser xpp, QuestionnaireResponse owner, QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseQuestionnaireResponseQuestionnaireResponseItemComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ReferralRequest parseReferralRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ReferralRequest res = new ReferralRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseReferralRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseReferralRequestContent(int eventType, XmlPullParser xpp, ReferralRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.getDefinition().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("replaces")) {
            res.getReplaces().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ReferralRequest.ReferralRequestStatus.NULL, new ReferralRequest.ReferralRequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntentElement(this.parseEnumeration(xpp, ReferralRequest.ReferralCategory.NULL, new ReferralRequest.ReferralCategoryEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, ReferralRequest.ReferralPriority.NULL, new ReferralRequest.ReferralPriorityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("serviceRequested")) {
            res.getServiceRequested().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requester")) {
            res.setRequester(this.parseReferralRequestReferralRequestRequesterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("specialty")) {
            res.setSpecialty(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recipient")) {
            res.getRecipient().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relevantHistory")) {
            res.getRelevantHistory().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ReferralRequest.ReferralRequestRequesterComponent parseReferralRequestReferralRequestRequesterComponent(XmlPullParser xpp, ReferralRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ReferralRequest.ReferralRequestRequesterComponent res = new ReferralRequest.ReferralRequestRequesterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseReferralRequestReferralRequestRequesterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseReferralRequestReferralRequestRequesterComponentContent(int eventType, XmlPullParser xpp, ReferralRequest owner, ReferralRequest.ReferralRequestRequesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("agent")) {
            res.setAgent(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected RelatedPerson parseRelatedPerson(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        RelatedPerson res = new RelatedPerson();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRelatedPersonContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRelatedPersonContent(int eventType, XmlPullParser xpp, RelatedPerson res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.getName().add(this.parseHumanName(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("gender")) {
            res.setGenderElement(this.parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("birthDate")) {
            res.setBirthDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.getAddress().add(this.parseAddress(xpp));
        } else if (eventType == 2 && xpp.getName().equals("photo")) {
            res.getPhoto().add(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected RequestGroup parseRequestGroup(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        RequestGroup res = new RequestGroup();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRequestGroupContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRequestGroupContent(int eventType, XmlPullParser xpp, RequestGroup res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.getDefinition().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("replaces")) {
            res.getReplaces().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, RequestGroup.RequestStatus.NULL, new RequestGroup.RequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntentElement(this.parseEnumeration(xpp, RequestGroup.RequestIntent.NULL, new RequestGroup.RequestIntentEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, RequestGroup.RequestPriority.NULL, new RequestGroup.RequestPriorityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "reason")) {
            res.setReason(this.parseType("reason", xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parseRequestGroupRequestGroupActionComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected RequestGroup.RequestGroupActionComponent parseRequestGroupRequestGroupActionComponent(XmlPullParser xpp, RequestGroup owner) throws XmlPullParserException, IOException, FHIRFormatError {
        RequestGroup.RequestGroupActionComponent res = new RequestGroup.RequestGroupActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRequestGroupRequestGroupActionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRequestGroupRequestGroupActionComponentContent(int eventType, XmlPullParser xpp, RequestGroup owner, RequestGroup.RequestGroupActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("label")) {
            res.setLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("textEquivalent")) {
            res.setTextEquivalentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.getDocumentation().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("condition")) {
            res.getCondition().add(this.parseRequestGroupRequestGroupActionConditionComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("relatedAction")) {
            res.getRelatedAction().add(this.parseRequestGroupRequestGroupActionRelatedActionComponent(xpp, owner));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupingBehavior")) {
            res.setGroupingBehaviorElement(this.parseEnumeration(xpp, RequestGroup.ActionGroupingBehavior.NULL, new RequestGroup.ActionGroupingBehaviorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("selectionBehavior")) {
            res.setSelectionBehaviorElement(this.parseEnumeration(xpp, RequestGroup.ActionSelectionBehavior.NULL, new RequestGroup.ActionSelectionBehaviorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("requiredBehavior")) {
            res.setRequiredBehaviorElement(this.parseEnumeration(xpp, RequestGroup.ActionRequiredBehavior.NULL, new RequestGroup.ActionRequiredBehaviorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("precheckBehavior")) {
            res.setPrecheckBehaviorElement(this.parseEnumeration(xpp, RequestGroup.ActionPrecheckBehavior.NULL, new RequestGroup.ActionPrecheckBehaviorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("cardinalityBehavior")) {
            res.setCardinalityBehaviorElement(this.parseEnumeration(xpp, RequestGroup.ActionCardinalityBehavior.NULL, new RequestGroup.ActionCardinalityBehaviorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parseRequestGroupRequestGroupActionComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected RequestGroup.RequestGroupActionConditionComponent parseRequestGroupRequestGroupActionConditionComponent(XmlPullParser xpp, RequestGroup owner) throws XmlPullParserException, IOException, FHIRFormatError {
        RequestGroup.RequestGroupActionConditionComponent res = new RequestGroup.RequestGroupActionConditionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRequestGroupRequestGroupActionConditionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRequestGroupRequestGroupActionConditionComponentContent(int eventType, XmlPullParser xpp, RequestGroup owner, RequestGroup.RequestGroupActionConditionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, RequestGroup.ActionConditionKind.NULL, new RequestGroup.ActionConditionKindEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected RequestGroup.RequestGroupActionRelatedActionComponent parseRequestGroupRequestGroupActionRelatedActionComponent(XmlPullParser xpp, RequestGroup owner) throws XmlPullParserException, IOException, FHIRFormatError {
        RequestGroup.RequestGroupActionRelatedActionComponent res = new RequestGroup.RequestGroupActionRelatedActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRequestGroupRequestGroupActionRelatedActionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRequestGroupRequestGroupActionRelatedActionComponentContent(int eventType, XmlPullParser xpp, RequestGroup owner, RequestGroup.RequestGroupActionRelatedActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("actionId")) {
            res.setActionIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationshipElement(this.parseEnumeration(xpp, RequestGroup.ActionRelationshipType.NULL, new RequestGroup.ActionRelationshipTypeEnumFactory()));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "offset")) {
            res.setOffset(this.parseType("offset", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ResearchStudy parseResearchStudy(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ResearchStudy res = new ResearchStudy();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseResearchStudyContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseResearchStudyContent(int eventType, XmlPullParser xpp, ResearchStudy res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("protocol")) {
            res.getProtocol().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ResearchStudy.ResearchStudyStatus.NULL, new ResearchStudy.ResearchStudyStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("focus")) {
            res.getFocus().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("keyword")) {
            res.getKeyword().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enrollment")) {
            res.getEnrollment().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sponsor")) {
            res.setSponsor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("principalInvestigator")) {
            res.setPrincipalInvestigator(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("site")) {
            res.getSite().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonStopped")) {
            res.setReasonStopped(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("arm")) {
            res.getArm().add(this.parseResearchStudyResearchStudyArmComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ResearchStudy.ResearchStudyArmComponent parseResearchStudyResearchStudyArmComponent(XmlPullParser xpp, ResearchStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ResearchStudy.ResearchStudyArmComponent res = new ResearchStudy.ResearchStudyArmComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseResearchStudyResearchStudyArmComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseResearchStudyResearchStudyArmComponentContent(int eventType, XmlPullParser xpp, ResearchStudy owner, ResearchStudy.ResearchStudyArmComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ResearchSubject parseResearchSubject(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ResearchSubject res = new ResearchSubject();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseResearchSubjectContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseResearchSubjectContent(int eventType, XmlPullParser xpp, ResearchSubject res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ResearchSubject.ResearchSubjectStatus.NULL, new ResearchSubject.ResearchSubjectStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("study")) {
            res.setStudy(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("individual")) {
            res.setIndividual(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("assignedArm")) {
            res.setAssignedArmElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actualArm")) {
            res.setActualArmElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("consent")) {
            res.setConsent(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected RiskAssessment parseRiskAssessment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        RiskAssessment res = new RiskAssessment();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRiskAssessmentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRiskAssessmentContent(int eventType, XmlPullParser xpp, RiskAssessment res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.setBasedOn(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parent")) {
            res.setParent(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, RiskAssessment.RiskAssessmentStatus.NULL, new RiskAssessment.RiskAssessmentStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("method")) {
            res.setMethod(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("condition")) {
            res.setCondition(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "reason")) {
            res.setReason(this.parseType("reason", xpp));
        } else if (eventType == 2 && xpp.getName().equals("basis")) {
            res.getBasis().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("prediction")) {
            res.getPrediction().add(this.parseRiskAssessmentRiskAssessmentPredictionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("mitigation")) {
            res.setMitigationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected RiskAssessment.RiskAssessmentPredictionComponent parseRiskAssessmentRiskAssessmentPredictionComponent(XmlPullParser xpp, RiskAssessment owner) throws XmlPullParserException, IOException, FHIRFormatError {
        RiskAssessment.RiskAssessmentPredictionComponent res = new RiskAssessment.RiskAssessmentPredictionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRiskAssessmentRiskAssessmentPredictionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRiskAssessmentRiskAssessmentPredictionComponentContent(int eventType, XmlPullParser xpp, RiskAssessment owner, RiskAssessment.RiskAssessmentPredictionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "probability")) {
            res.setProbability(this.parseType("probability", xpp));
        } else if (eventType == 2 && xpp.getName().equals("qualitativeRisk")) {
            res.setQualitativeRisk(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relativeRisk")) {
            res.setRelativeRiskElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "when")) {
            res.setWhen(this.parseType("when", xpp));
        } else if (eventType == 2 && xpp.getName().equals("rationale")) {
            res.setRationaleElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Schedule parseSchedule(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Schedule res = new Schedule();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseScheduleContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseScheduleContent(int eventType, XmlPullParser xpp, Schedule res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serviceCategory")) {
            res.setServiceCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serviceType")) {
            res.getServiceType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialty")) {
            res.getSpecialty().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.getActor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("planningHorizon")) {
            res.setPlanningHorizon(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected SearchParameter parseSearchParameter(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SearchParameter res = new SearchParameter();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSearchParameterContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSearchParameterContent(int eventType, XmlPullParser xpp, SearchParameter res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("base")) {
            res.getBase().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("derivedFrom")) {
            res.setDerivedFromElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("xpath")) {
            res.setXpathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("xpathUsage")) {
            res.setXpathUsageElement(this.parseEnumeration(xpp, SearchParameter.XPathUsageType.NULL, new SearchParameter.XPathUsageTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.getTarget().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comparator")) {
            res.getComparator().add(this.parseEnumeration(xpp, SearchParameter.SearchComparator.NULL, new SearchParameter.SearchComparatorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseEnumeration(xpp, SearchParameter.SearchModifierCode.NULL, new SearchParameter.SearchModifierCodeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("chain")) {
            res.getChain().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("component")) {
            res.getComponent().add(this.parseSearchParameterSearchParameterComponentComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected SearchParameter.SearchParameterComponentComponent parseSearchParameterSearchParameterComponentComponent(XmlPullParser xpp, SearchParameter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        SearchParameter.SearchParameterComponentComponent res = new SearchParameter.SearchParameterComponentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSearchParameterSearchParameterComponentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSearchParameterSearchParameterComponentComponentContent(int eventType, XmlPullParser xpp, SearchParameter owner, SearchParameter.SearchParameterComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinition(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Sequence parseSequence(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Sequence res = new Sequence();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSequenceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSequenceContent(int eventType, XmlPullParser xpp, Sequence res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Sequence.SequenceType.NULL, new Sequence.SequenceTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("coordinateSystem")) {
            res.setCoordinateSystemElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specimen")) {
            res.setSpecimen(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.setDevice(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceSeq")) {
            res.setReferenceSeq(this.parseSequenceSequenceReferenceSeqComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("variant")) {
            res.getVariant().add(this.parseSequenceSequenceVariantComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("observedSeq")) {
            res.setObservedSeqElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quality")) {
            res.getQuality().add(this.parseSequenceSequenceQualityComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("readCoverage")) {
            res.setReadCoverageElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("repository")) {
            res.getRepository().add(this.parseSequenceSequenceRepositoryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("pointer")) {
            res.getPointer().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Sequence.SequenceReferenceSeqComponent parseSequenceSequenceReferenceSeqComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Sequence.SequenceReferenceSeqComponent res = new Sequence.SequenceReferenceSeqComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSequenceSequenceReferenceSeqComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSequenceSequenceReferenceSeqComponentContent(int eventType, XmlPullParser xpp, Sequence owner, Sequence.SequenceReferenceSeqComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("chromosome")) {
            res.setChromosome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("genomeBuild")) {
            res.setGenomeBuildElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceSeqId")) {
            res.setReferenceSeqId(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceSeqPointer")) {
            res.setReferenceSeqPointer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceSeqString")) {
            res.setReferenceSeqStringElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("strand")) {
            res.setStrandElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("windowStart")) {
            res.setWindowStartElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("windowEnd")) {
            res.setWindowEndElement(this.parseInteger(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Sequence.SequenceVariantComponent parseSequenceSequenceVariantComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Sequence.SequenceVariantComponent res = new Sequence.SequenceVariantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSequenceSequenceVariantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSequenceSequenceVariantComponentContent(int eventType, XmlPullParser xpp, Sequence owner, Sequence.SequenceVariantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("observedAllele")) {
            res.setObservedAlleleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceAllele")) {
            res.setReferenceAlleleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("cigar")) {
            res.setCigarElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("variantPointer")) {
            res.setVariantPointer(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Sequence.SequenceQualityComponent parseSequenceSequenceQualityComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Sequence.SequenceQualityComponent res = new Sequence.SequenceQualityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSequenceSequenceQualityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSequenceSequenceQualityComponentContent(int eventType, XmlPullParser xpp, Sequence owner, Sequence.SequenceQualityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Sequence.QualityType.NULL, new Sequence.QualityTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("standardSequence")) {
            res.setStandardSequence(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("score")) {
            res.setScore(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("method")) {
            res.setMethod(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("truthTP")) {
            res.setTruthTPElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("queryTP")) {
            res.setQueryTPElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("truthFN")) {
            res.setTruthFNElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("queryFP")) {
            res.setQueryFPElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("gtFP")) {
            res.setGtFPElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("precision")) {
            res.setPrecisionElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recall")) {
            res.setRecallElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fScore")) {
            res.setFScoreElement(this.parseDecimal(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Sequence.SequenceRepositoryComponent parseSequenceSequenceRepositoryComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Sequence.SequenceRepositoryComponent res = new Sequence.SequenceRepositoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSequenceSequenceRepositoryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSequenceSequenceRepositoryComponentContent(int eventType, XmlPullParser xpp, Sequence owner, Sequence.SequenceRepositoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Sequence.RepositoryType.NULL, new Sequence.RepositoryTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("datasetId")) {
            res.setDatasetIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("variantsetId")) {
            res.setVariantsetIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("readsetId")) {
            res.setReadsetIdElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ServiceDefinition parseServiceDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ServiceDefinition res = new ServiceDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseServiceDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseServiceDefinitionContent(int eventType, XmlPullParser xpp, ServiceDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.setUsageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributor")) {
            res.getContributor().add(this.parseContributor(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("trigger")) {
            res.getTrigger().add(this.parseTriggerDefinition(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dataRequirement")) {
            res.getDataRequirement().add(this.parseDataRequirement(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operationDefinition")) {
            res.setOperationDefinition(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Slot parseSlot(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Slot res = new Slot();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSlotContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSlotContent(int eventType, XmlPullParser xpp, Slot res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serviceCategory")) {
            res.setServiceCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serviceType")) {
            res.getServiceType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialty")) {
            res.getSpecialty().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("appointmentType")) {
            res.setAppointmentType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("schedule")) {
            res.setSchedule(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Slot.SlotStatus.NULL, new Slot.SlotStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("overbooked")) {
            res.setOverbookedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Specimen parseSpecimen(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Specimen res = new Specimen();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSpecimenContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSpecimenContent(int eventType, XmlPullParser xpp, Specimen res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("accessionIdentifier")) {
            res.setAccessionIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Specimen.SpecimenStatus.NULL, new Specimen.SpecimenStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("receivedTime")) {
            res.setReceivedTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parent")) {
            res.getParent().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.getRequest().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("collection")) {
            res.setCollection(this.parseSpecimenSpecimenCollectionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("processing")) {
            res.getProcessing().add(this.parseSpecimenSpecimenProcessingComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("container")) {
            res.getContainer().add(this.parseSpecimenSpecimenContainerComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Specimen.SpecimenCollectionComponent parseSpecimenSpecimenCollectionComponent(XmlPullParser xpp, Specimen owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Specimen.SpecimenCollectionComponent res = new Specimen.SpecimenCollectionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSpecimenSpecimenCollectionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSpecimenSpecimenCollectionComponentContent(int eventType, XmlPullParser xpp, Specimen owner, Specimen.SpecimenCollectionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("collector")) {
            res.setCollector(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "collected")) {
            res.setCollected(this.parseType("collected", xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("method")) {
            res.setMethod(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Specimen.SpecimenProcessingComponent parseSpecimenSpecimenProcessingComponent(XmlPullParser xpp, Specimen owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Specimen.SpecimenProcessingComponent res = new Specimen.SpecimenProcessingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSpecimenSpecimenProcessingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSpecimenSpecimenProcessingComponentContent(int eventType, XmlPullParser xpp, Specimen owner, Specimen.SpecimenProcessingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedure")) {
            res.setProcedure(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("additive")) {
            res.getAdditive().add(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "time")) {
            res.setTime(this.parseType("time", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Specimen.SpecimenContainerComponent parseSpecimenSpecimenContainerComponent(XmlPullParser xpp, Specimen owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Specimen.SpecimenContainerComponent res = new Specimen.SpecimenContainerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSpecimenSpecimenContainerComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSpecimenSpecimenContainerComponentContent(int eventType, XmlPullParser xpp, Specimen owner, Specimen.SpecimenContainerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("capacity")) {
            res.setCapacity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specimenQuantity")) {
            res.setSpecimenQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "additive")) {
            res.setAdditive(this.parseType("additive", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected StructureDefinition parseStructureDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureDefinition res = new StructureDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseStructureDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseStructureDefinitionContent(int eventType, XmlPullParser xpp, StructureDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("keyword")) {
            res.getKeyword().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fhirVersion")) {
            res.setFhirVersionElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mapping")) {
            res.getMapping().add(this.parseStructureDefinitionStructureDefinitionMappingComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, StructureDefinition.StructureDefinitionKind.NULL, new StructureDefinition.StructureDefinitionKindEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("abstract")) {
            res.setAbstractElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contextType")) {
            res.setContextTypeElement(this.parseEnumeration(xpp, StructureDefinition.ExtensionContext.NULL, new StructureDefinition.ExtensionContextEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.getContext().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contextInvariant")) {
            res.getContextInvariant().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("baseDefinition")) {
            res.setBaseDefinitionElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("derivation")) {
            res.setDerivationElement(this.parseEnumeration(xpp, StructureDefinition.TypeDerivationRule.NULL, new StructureDefinition.TypeDerivationRuleEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("snapshot")) {
            res.setSnapshot(this.parseStructureDefinitionStructureDefinitionSnapshotComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("differential")) {
            res.setDifferential(this.parseStructureDefinitionStructureDefinitionDifferentialComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected StructureDefinition.StructureDefinitionMappingComponent parseStructureDefinitionStructureDefinitionMappingComponent(XmlPullParser xpp, StructureDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionMappingComponent res = new StructureDefinition.StructureDefinitionMappingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseStructureDefinitionStructureDefinitionMappingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseStructureDefinitionStructureDefinitionMappingComponentContent(int eventType, XmlPullParser xpp, StructureDefinition owner, StructureDefinition.StructureDefinitionMappingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identity")) {
            res.setIdentityElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("uri")) {
            res.setUriElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected StructureDefinition.StructureDefinitionSnapshotComponent parseStructureDefinitionStructureDefinitionSnapshotComponent(XmlPullParser xpp, StructureDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionSnapshotComponent res = new StructureDefinition.StructureDefinitionSnapshotComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseStructureDefinitionStructureDefinitionSnapshotComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseStructureDefinitionStructureDefinitionSnapshotComponentContent(int eventType, XmlPullParser xpp, StructureDefinition owner, StructureDefinition.StructureDefinitionSnapshotComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("element")) {
            res.getElement().add(this.parseElementDefinition(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected StructureDefinition.StructureDefinitionDifferentialComponent parseStructureDefinitionStructureDefinitionDifferentialComponent(XmlPullParser xpp, StructureDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionDifferentialComponent res = new StructureDefinition.StructureDefinitionDifferentialComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseStructureDefinitionStructureDefinitionDifferentialComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseStructureDefinitionStructureDefinitionDifferentialComponentContent(int eventType, XmlPullParser xpp, StructureDefinition owner, StructureDefinition.StructureDefinitionDifferentialComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("element")) {
            res.getElement().add(this.parseElementDefinition(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected StructureMap parseStructureMap(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap res = new StructureMap();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseStructureMapContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseStructureMapContent(int eventType, XmlPullParser xpp, StructureMap res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("structure")) {
            res.getStructure().add(this.parseStructureMapStructureMapStructureComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("import")) {
            res.getImport().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("group")) {
            res.getGroup().add(this.parseStructureMapStructureMapGroupComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected StructureMap.StructureMapStructureComponent parseStructureMapStructureMapStructureComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapStructureComponent res = new StructureMap.StructureMapStructureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseStructureMapStructureMapStructureComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseStructureMapStructureMapStructureComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapStructureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, StructureMap.StructureMapModelMode.NULL, new StructureMap.StructureMapModelModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("alias")) {
            res.setAliasElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected StructureMap.StructureMapGroupComponent parseStructureMapStructureMapGroupComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapGroupComponent res = new StructureMap.StructureMapGroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseStructureMapStructureMapGroupComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseStructureMapStructureMapGroupComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("extends")) {
            res.setExtendsElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("typeMode")) {
            res.setTypeModeElement(this.parseEnumeration(xpp, StructureMap.StructureMapGroupTypeMode.NULL, new StructureMap.StructureMapGroupTypeModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("input")) {
            res.getInput().add(this.parseStructureMapStructureMapGroupInputComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("rule")) {
            res.getRule().add(this.parseStructureMapStructureMapGroupRuleComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected StructureMap.StructureMapGroupInputComponent parseStructureMapStructureMapGroupInputComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapGroupInputComponent res = new StructureMap.StructureMapGroupInputComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseStructureMapStructureMapGroupInputComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseStructureMapStructureMapGroupInputComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapGroupInputComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, StructureMap.StructureMapInputMode.NULL, new StructureMap.StructureMapInputModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected StructureMap.StructureMapGroupRuleComponent parseStructureMapStructureMapGroupRuleComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapGroupRuleComponent res = new StructureMap.StructureMapGroupRuleComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseStructureMapStructureMapGroupRuleComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseStructureMapStructureMapGroupRuleComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapGroupRuleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.getSource().add(this.parseStructureMapStructureMapGroupRuleSourceComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.getTarget().add(this.parseStructureMapStructureMapGroupRuleTargetComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("rule")) {
            res.getRule().add(this.parseStructureMapStructureMapGroupRuleComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("dependent")) {
            res.getDependent().add(this.parseStructureMapStructureMapGroupRuleDependentComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected StructureMap.StructureMapGroupRuleSourceComponent parseStructureMapStructureMapGroupRuleSourceComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapGroupRuleSourceComponent res = new StructureMap.StructureMapGroupRuleSourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseStructureMapStructureMapGroupRuleSourceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseStructureMapStructureMapGroupRuleSourceComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapGroupRuleSourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContextElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "defaultValue")) {
            res.setDefaultValue(this.parseType("defaultValue", xpp));
        } else if (eventType == 2 && xpp.getName().equals("element")) {
            res.setElementElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("listMode")) {
            res.setListModeElement(this.parseEnumeration(xpp, StructureMap.StructureMapSourceListMode.NULL, new StructureMap.StructureMapSourceListModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("variable")) {
            res.setVariableElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("condition")) {
            res.setConditionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("check")) {
            res.setCheckElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected StructureMap.StructureMapGroupRuleTargetComponent parseStructureMapStructureMapGroupRuleTargetComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapGroupRuleTargetComponent res = new StructureMap.StructureMapGroupRuleTargetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseStructureMapStructureMapGroupRuleTargetComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseStructureMapStructureMapGroupRuleTargetComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapGroupRuleTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContextElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contextType")) {
            res.setContextTypeElement(this.parseEnumeration(xpp, StructureMap.StructureMapContextType.NULL, new StructureMap.StructureMapContextTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("element")) {
            res.setElementElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("variable")) {
            res.setVariableElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("listMode")) {
            res.getListMode().add(this.parseEnumeration(xpp, StructureMap.StructureMapTargetListMode.NULL, new StructureMap.StructureMapTargetListModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("listRuleId")) {
            res.setListRuleIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("transform")) {
            res.setTransformElement(this.parseEnumeration(xpp, StructureMap.StructureMapTransform.NULL, new StructureMap.StructureMapTransformEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("parameter")) {
            res.getParameter().add(this.parseStructureMapStructureMapGroupRuleTargetParameterComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected StructureMap.StructureMapGroupRuleTargetParameterComponent parseStructureMapStructureMapGroupRuleTargetParameterComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapGroupRuleTargetParameterComponent res = new StructureMap.StructureMapGroupRuleTargetParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseStructureMapStructureMapGroupRuleTargetParameterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseStructureMapStructureMapGroupRuleTargetParameterComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapGroupRuleTargetParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected StructureMap.StructureMapGroupRuleDependentComponent parseStructureMapStructureMapGroupRuleDependentComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        StructureMap.StructureMapGroupRuleDependentComponent res = new StructureMap.StructureMapGroupRuleDependentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseStructureMapStructureMapGroupRuleDependentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseStructureMapStructureMapGroupRuleDependentComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapGroupRuleDependentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("variable")) {
            res.getVariable().add(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Subscription parseSubscription(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Subscription res = new Subscription();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSubscriptionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSubscriptionContent(int eventType, XmlPullParser xpp, Subscription res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Subscription.SubscriptionStatus.NULL, new Subscription.SubscriptionStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReasonElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("criteria")) {
            res.setCriteriaElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("error")) {
            res.setErrorElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("channel")) {
            res.setChannel(this.parseSubscriptionSubscriptionChannelComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("tag")) {
            res.getTag().add(this.parseCoding(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Subscription.SubscriptionChannelComponent parseSubscriptionSubscriptionChannelComponent(XmlPullParser xpp, Subscription owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Subscription.SubscriptionChannelComponent res = new Subscription.SubscriptionChannelComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSubscriptionSubscriptionChannelComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSubscriptionSubscriptionChannelComponentContent(int eventType, XmlPullParser xpp, Subscription owner, Subscription.SubscriptionChannelComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Subscription.SubscriptionChannelType.NULL, new Subscription.SubscriptionChannelTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.setEndpointElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payload")) {
            res.setPayloadElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("header")) {
            res.getHeader().add(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Substance parseSubstance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Substance res = new Substance();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSubstanceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSubstanceContent(int eventType, XmlPullParser xpp, Substance res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Substance.FHIRSubstanceStatus.NULL, new Substance.FHIRSubstanceStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instance")) {
            res.getInstance().add(this.parseSubstanceSubstanceInstanceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("ingredient")) {
            res.getIngredient().add(this.parseSubstanceSubstanceIngredientComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Substance.SubstanceInstanceComponent parseSubstanceSubstanceInstanceComponent(XmlPullParser xpp, Substance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Substance.SubstanceInstanceComponent res = new Substance.SubstanceInstanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSubstanceSubstanceInstanceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSubstanceSubstanceInstanceComponentContent(int eventType, XmlPullParser xpp, Substance owner, Substance.SubstanceInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expiry")) {
            res.setExpiryElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Substance.SubstanceIngredientComponent parseSubstanceSubstanceIngredientComponent(XmlPullParser xpp, Substance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Substance.SubstanceIngredientComponent res = new Substance.SubstanceIngredientComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSubstanceSubstanceIngredientComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSubstanceSubstanceIngredientComponentContent(int eventType, XmlPullParser xpp, Substance owner, Substance.SubstanceIngredientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseRatio(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "substance")) {
            res.setSubstance(this.parseType("substance", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected SupplyDelivery parseSupplyDelivery(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SupplyDelivery res = new SupplyDelivery();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSupplyDeliveryContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSupplyDeliveryContent(int eventType, XmlPullParser xpp, SupplyDelivery res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, SupplyDelivery.SupplyDeliveryStatus.NULL, new SupplyDelivery.SupplyDeliveryStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("suppliedItem")) {
            res.setSuppliedItem(this.parseSupplyDeliverySupplyDeliverySuppliedItemComponent(xpp, res));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("supplier")) {
            res.setSupplier(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("destination")) {
            res.setDestination(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("receiver")) {
            res.getReceiver().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected SupplyDelivery.SupplyDeliverySuppliedItemComponent parseSupplyDeliverySupplyDeliverySuppliedItemComponent(XmlPullParser xpp, SupplyDelivery owner) throws XmlPullParserException, IOException, FHIRFormatError {
        SupplyDelivery.SupplyDeliverySuppliedItemComponent res = new SupplyDelivery.SupplyDeliverySuppliedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSupplyDeliverySupplyDeliverySuppliedItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSupplyDeliverySupplyDeliverySuppliedItemComponentContent(int eventType, XmlPullParser xpp, SupplyDelivery owner, SupplyDelivery.SupplyDeliverySuppliedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "item")) {
            res.setItem(this.parseType("item", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected SupplyRequest parseSupplyRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SupplyRequest res = new SupplyRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSupplyRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSupplyRequestContent(int eventType, XmlPullParser xpp, SupplyRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, SupplyRequest.SupplyRequestStatus.NULL, new SupplyRequest.SupplyRequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, SupplyRequest.RequestPriority.NULL, new SupplyRequest.RequestPriorityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("orderedItem")) {
            res.setOrderedItem(this.parseSupplyRequestSupplyRequestOrderedItemComponent(xpp, res));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requester")) {
            res.setRequester(this.parseSupplyRequestSupplyRequestRequesterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("supplier")) {
            res.getSupplier().add(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "reason")) {
            res.setReason(this.parseType("reason", xpp));
        } else if (eventType == 2 && xpp.getName().equals("deliverFrom")) {
            res.setDeliverFrom(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("deliverTo")) {
            res.setDeliverTo(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected SupplyRequest.SupplyRequestOrderedItemComponent parseSupplyRequestSupplyRequestOrderedItemComponent(XmlPullParser xpp, SupplyRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        SupplyRequest.SupplyRequestOrderedItemComponent res = new SupplyRequest.SupplyRequestOrderedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSupplyRequestSupplyRequestOrderedItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSupplyRequestSupplyRequestOrderedItemComponentContent(int eventType, XmlPullParser xpp, SupplyRequest owner, SupplyRequest.SupplyRequestOrderedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "item")) {
            res.setItem(this.parseType("item", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected SupplyRequest.SupplyRequestRequesterComponent parseSupplyRequestSupplyRequestRequesterComponent(XmlPullParser xpp, SupplyRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        SupplyRequest.SupplyRequestRequesterComponent res = new SupplyRequest.SupplyRequestRequesterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSupplyRequestSupplyRequestRequesterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSupplyRequestSupplyRequestRequesterComponentContent(int eventType, XmlPullParser xpp, SupplyRequest owner, SupplyRequest.SupplyRequestRequesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("agent")) {
            res.setAgent(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Task parseTask(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Task res = new Task();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTaskContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTaskContent(int eventType, XmlPullParser xpp, Task res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "definition")) {
            res.setDefinition(this.parseType("definition", xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Task.TaskStatus.NULL, new Task.TaskStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("businessStatus")) {
            res.setBusinessStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntentElement(this.parseEnumeration(xpp, Task.TaskIntent.NULL, new Task.TaskIntentEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, Task.TaskPriority.NULL, new Task.TaskPriorityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("focus")) {
            res.setFocus(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("for")) {
            res.setFor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("executionPeriod")) {
            res.setExecutionPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastModified")) {
            res.setLastModifiedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requester")) {
            res.setRequester(this.parseTaskTaskRequesterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("performerType")) {
            res.getPerformerType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("owner")) {
            res.setOwner(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relevantHistory")) {
            res.getRelevantHistory().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("restriction")) {
            res.setRestriction(this.parseTaskTaskRestrictionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("input")) {
            res.getInput().add(this.parseTaskParameterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("output")) {
            res.getOutput().add(this.parseTaskTaskOutputComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Task.TaskRequesterComponent parseTaskTaskRequesterComponent(XmlPullParser xpp, Task owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Task.TaskRequesterComponent res = new Task.TaskRequesterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTaskTaskRequesterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTaskTaskRequesterComponentContent(int eventType, XmlPullParser xpp, Task owner, Task.TaskRequesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("agent")) {
            res.setAgent(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Task.TaskRestrictionComponent parseTaskTaskRestrictionComponent(XmlPullParser xpp, Task owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Task.TaskRestrictionComponent res = new Task.TaskRestrictionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTaskTaskRestrictionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTaskTaskRestrictionComponentContent(int eventType, XmlPullParser xpp, Task owner, Task.TaskRestrictionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("repetitions")) {
            res.setRepetitionsElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recipient")) {
            res.getRecipient().add(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Task.ParameterComponent parseTaskParameterComponent(XmlPullParser xpp, Task owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Task.ParameterComponent res = new Task.ParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTaskParameterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTaskParameterComponentContent(int eventType, XmlPullParser xpp, Task owner, Task.ParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Task.TaskOutputComponent parseTaskTaskOutputComponent(XmlPullParser xpp, Task owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Task.TaskOutputComponent res = new Task.TaskOutputComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTaskTaskOutputComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTaskTaskOutputComponentContent(int eventType, XmlPullParser xpp, Task owner, Task.TaskOutputComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestReport parseTestReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TestReport res = new TestReport();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestReportContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestReportContent(int eventType, XmlPullParser xpp, TestReport res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, TestReport.TestReportStatus.NULL, new TestReport.TestReportStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("testScript")) {
            res.setTestScript(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("result")) {
            res.setResultElement(this.parseEnumeration(xpp, TestReport.TestReportResult.NULL, new TestReport.TestReportResultEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("score")) {
            res.setScoreElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tester")) {
            res.setTesterElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issued")) {
            res.setIssuedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseTestReportTestReportParticipantComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("setup")) {
            res.setSetup(this.parseTestReportTestReportSetupComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("test")) {
            res.getTest().add(this.parseTestReportTestReportTestComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("teardown")) {
            res.setTeardown(this.parseTestReportTestReportTeardownComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestReport.TestReportParticipantComponent parseTestReportTestReportParticipantComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestReport.TestReportParticipantComponent res = new TestReport.TestReportParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestReportTestReportParticipantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestReportTestReportParticipantComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.TestReportParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, TestReport.TestReportParticipantType.NULL, new TestReport.TestReportParticipantTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("uri")) {
            res.setUriElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestReport.TestReportSetupComponent parseTestReportTestReportSetupComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestReport.TestReportSetupComponent res = new TestReport.TestReportSetupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestReportTestReportSetupComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestReportTestReportSetupComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.TestReportSetupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parseTestReportSetupActionComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestReport.SetupActionComponent parseTestReportSetupActionComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestReport.SetupActionComponent res = new TestReport.SetupActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestReportSetupActionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestReportSetupActionComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.SetupActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("operation")) {
            res.setOperation(this.parseTestReportSetupActionOperationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("assert")) {
            res.setAssert(this.parseTestReportSetupActionAssertComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestReport.SetupActionOperationComponent parseTestReportSetupActionOperationComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestReport.SetupActionOperationComponent res = new TestReport.SetupActionOperationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestReportSetupActionOperationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestReportSetupActionOperationComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.SetupActionOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("result")) {
            res.setResultElement(this.parseEnumeration(xpp, TestReport.TestReportActionResult.NULL, new TestReport.TestReportActionResultEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("message")) {
            res.setMessageElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.setDetailElement(this.parseUri(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestReport.SetupActionAssertComponent parseTestReportSetupActionAssertComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestReport.SetupActionAssertComponent res = new TestReport.SetupActionAssertComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestReportSetupActionAssertComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestReportSetupActionAssertComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.SetupActionAssertComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("result")) {
            res.setResultElement(this.parseEnumeration(xpp, TestReport.TestReportActionResult.NULL, new TestReport.TestReportActionResultEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("message")) {
            res.setMessageElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.setDetailElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestReport.TestReportTestComponent parseTestReportTestReportTestComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestReport.TestReportTestComponent res = new TestReport.TestReportTestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestReportTestReportTestComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestReportTestReportTestComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.TestReportTestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parseTestReportTestActionComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestReport.TestActionComponent parseTestReportTestActionComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestReport.TestActionComponent res = new TestReport.TestActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestReportTestActionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestReportTestActionComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.TestActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("operation")) {
            res.setOperation(this.parseTestReportSetupActionOperationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("assert")) {
            res.setAssert(this.parseTestReportSetupActionAssertComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestReport.TestReportTeardownComponent parseTestReportTestReportTeardownComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestReport.TestReportTeardownComponent res = new TestReport.TestReportTeardownComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestReportTestReportTeardownComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestReportTestReportTeardownComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.TestReportTeardownComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parseTestReportTeardownActionComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestReport.TeardownActionComponent parseTestReportTeardownActionComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestReport.TeardownActionComponent res = new TestReport.TeardownActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestReportTeardownActionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestReportTeardownActionComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.TeardownActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("operation")) {
            res.setOperation(this.parseTestReportSetupActionOperationComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestScript parseTestScript(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript res = new TestScript();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestScriptContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestScriptContent(int eventType, XmlPullParser xpp, TestScript res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("origin")) {
            res.getOrigin().add(this.parseTestScriptTestScriptOriginComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("destination")) {
            res.getDestination().add(this.parseTestScriptTestScriptDestinationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("metadata")) {
            res.setMetadata(this.parseTestScriptTestScriptMetadataComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("fixture")) {
            res.getFixture().add(this.parseTestScriptTestScriptFixtureComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.getProfile().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("variable")) {
            res.getVariable().add(this.parseTestScriptTestScriptVariableComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("rule")) {
            res.getRule().add(this.parseTestScriptTestScriptRuleComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("ruleset")) {
            res.getRuleset().add(this.parseTestScriptTestScriptRulesetComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("setup")) {
            res.setSetup(this.parseTestScriptTestScriptSetupComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("test")) {
            res.getTest().add(this.parseTestScriptTestScriptTestComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("teardown")) {
            res.setTeardown(this.parseTestScriptTestScriptTeardownComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestScript.TestScriptOriginComponent parseTestScriptTestScriptOriginComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptOriginComponent res = new TestScript.TestScriptOriginComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestScriptTestScriptOriginComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestScriptTestScriptOriginComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptOriginComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("index")) {
            res.setIndexElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfile(this.parseCoding(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestScript.TestScriptDestinationComponent parseTestScriptTestScriptDestinationComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptDestinationComponent res = new TestScript.TestScriptDestinationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestScriptTestScriptDestinationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestScriptTestScriptDestinationComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptDestinationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("index")) {
            res.setIndexElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfile(this.parseCoding(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestScript.TestScriptMetadataComponent parseTestScriptTestScriptMetadataComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptMetadataComponent res = new TestScript.TestScriptMetadataComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestScriptTestScriptMetadataComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestScriptTestScriptMetadataComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptMetadataComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parseTestScriptTestScriptMetadataLinkComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("capability")) {
            res.getCapability().add(this.parseTestScriptTestScriptMetadataCapabilityComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestScript.TestScriptMetadataLinkComponent parseTestScriptTestScriptMetadataLinkComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptMetadataLinkComponent res = new TestScript.TestScriptMetadataLinkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestScriptTestScriptMetadataLinkComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestScriptTestScriptMetadataLinkComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptMetadataLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestScript.TestScriptMetadataCapabilityComponent parseTestScriptTestScriptMetadataCapabilityComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptMetadataCapabilityComponent res = new TestScript.TestScriptMetadataCapabilityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestScriptTestScriptMetadataCapabilityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestScriptTestScriptMetadataCapabilityComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptMetadataCapabilityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("required")) {
            res.setRequiredElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("validated")) {
            res.setValidatedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("origin")) {
            res.getOrigin().add(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("destination")) {
            res.setDestinationElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("capabilities")) {
            res.setCapabilities(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestScript.TestScriptFixtureComponent parseTestScriptTestScriptFixtureComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptFixtureComponent res = new TestScript.TestScriptFixtureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestScriptTestScriptFixtureComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestScriptTestScriptFixtureComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptFixtureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("autocreate")) {
            res.setAutocreateElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("autodelete")) {
            res.setAutodeleteElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseReference(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestScript.TestScriptVariableComponent parseTestScriptTestScriptVariableComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptVariableComponent res = new TestScript.TestScriptVariableComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestScriptTestScriptVariableComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestScriptTestScriptVariableComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptVariableComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("defaultValue")) {
            res.setDefaultValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("headerField")) {
            res.setHeaderFieldElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hint")) {
            res.setHintElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sourceId")) {
            res.setSourceIdElement(this.parseId(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestScript.TestScriptRuleComponent parseTestScriptTestScriptRuleComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptRuleComponent res = new TestScript.TestScriptRuleComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestScriptTestScriptRuleComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestScriptTestScriptRuleComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptRuleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("param")) {
            res.getParam().add(this.parseTestScriptRuleParamComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestScript.RuleParamComponent parseTestScriptRuleParamComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.RuleParamComponent res = new TestScript.RuleParamComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestScriptRuleParamComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestScriptRuleParamComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.RuleParamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestScript.TestScriptRulesetComponent parseTestScriptTestScriptRulesetComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptRulesetComponent res = new TestScript.TestScriptRulesetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestScriptTestScriptRulesetComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestScriptTestScriptRulesetComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptRulesetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rule")) {
            res.getRule().add(this.parseTestScriptRulesetRuleComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestScript.RulesetRuleComponent parseTestScriptRulesetRuleComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.RulesetRuleComponent res = new TestScript.RulesetRuleComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestScriptRulesetRuleComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestScriptRulesetRuleComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.RulesetRuleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("ruleId")) {
            res.setRuleIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("param")) {
            res.getParam().add(this.parseTestScriptRulesetRuleParamComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestScript.RulesetRuleParamComponent parseTestScriptRulesetRuleParamComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.RulesetRuleParamComponent res = new TestScript.RulesetRuleParamComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestScriptRulesetRuleParamComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestScriptRulesetRuleParamComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.RulesetRuleParamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestScript.TestScriptSetupComponent parseTestScriptTestScriptSetupComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.TestScriptSetupComponent res = new TestScript.TestScriptSetupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestScriptTestScriptSetupComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestScriptTestScriptSetupComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptSetupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parseTestScriptSetupActionComponent(xpp, owner));
        } else if (!this.parseBackboneContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestScript.SetupActionComponent parseTestScriptSetupActionComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
        TestScript.SetupActionComponent res = new TestScript.SetupActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestScriptSetupActionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestScriptSetupActionComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.SetupActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("operation")) {
  