/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3PatientImportance {
    BM,
    DFM,
    DR,
    FD,
    FOR,
    GOVT,
    SFM,
    STF,
    VIP,
    NULL;


    public static V3PatientImportance fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("BM".equals(codeString)) {
            return BM;
        }
        if ("DFM".equals(codeString)) {
            return DFM;
        }
        if ("DR".equals(codeString)) {
            return DR;
        }
        if ("FD".equals(codeString)) {
            return FD;
        }
        if ("FOR".equals(codeString)) {
            return FOR;
        }
        if ("GOVT".equals(codeString)) {
            return GOVT;
        }
        if ("SFM".equals(codeString)) {
            return SFM;
        }
        if ("STF".equals(codeString)) {
            return STF;
        }
        if ("VIP".equals(codeString)) {
            return VIP;
        }
        throw new FHIRException("Unknown V3PatientImportance code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case BM: {
                return "BM";
            }
            case DFM: {
                return "DFM";
            }
            case DR: {
                return "DR";
            }
            case FD: {
                return "FD";
            }
            case FOR: {
                return "FOR";
            }
            case GOVT: {
                return "GOVT";
            }
            case SFM: {
                return "SFM";
            }
            case STF: {
                return "STF";
            }
            case VIP: {
                return "VIP";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/v3/PatientImportance";
    }

    public String getDefinition() {
        switch (this) {
            case BM: {
                return "Board member of health care organization";
            }
            case DFM: {
                return "Family member of staff physician";
            }
            case DR: {
                return "Member of the health care organization physician staff";
            }
            case FD: {
                return "Financial donor to the health care organization";
            }
            case FOR: {
                return "Foreign citizen dignitary of interest to the health care organization";
            }
            case GOVT: {
                return "Government dignitary of interest to the organization";
            }
            case SFM: {
                return "Family member of staff member";
            }
            case STF: {
                return "Staff member of the health care organization";
            }
            case VIP: {
                return "Very important person of interest to the health care organization";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case BM: {
                return "Board Member";
            }
            case DFM: {
                return "Physician Family Member";
            }
            case DR: {
                return "Staff Physician";
            }
            case FD: {
                return "Financial Donor";
            }
            case FOR: {
                return "Foreign Dignitary";
            }
            case GOVT: {
                return "Government Dignitary";
            }
            case SFM: {
                return "Staff Family Member";
            }
            case STF: {
                return "Staff Member";
            }
            case VIP: {
                return "Very Important Person";
            }
        }
        return "?";
    }
}

