/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum Slotstatus {
    BUSY,
    FREE,
    BUSYUNAVAILABLE,
    BUSYTENTATIVE,
    NULL;


    public static Slotstatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("busy".equals(codeString)) {
            return BUSY;
        }
        if ("free".equals(codeString)) {
            return FREE;
        }
        if ("busy-unavailable".equals(codeString)) {
            return BUSYUNAVAILABLE;
        }
        if ("busy-tentative".equals(codeString)) {
            return BUSYTENTATIVE;
        }
        throw new FHIRException("Unknown Slotstatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case BUSY: {
                return "busy";
            }
            case FREE: {
                return "free";
            }
            case BUSYUNAVAILABLE: {
                return "busy-unavailable";
            }
            case BUSYTENTATIVE: {
                return "busy-tentative";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/slotstatus";
    }

    public String getDefinition() {
        switch (this) {
            case BUSY: {
                return "Indicates that the time interval is busy because one  or more events have been scheduled for that interval.";
            }
            case FREE: {
                return "Indicates that the time interval is free for scheduling.";
            }
            case BUSYUNAVAILABLE: {
                return "Indicates that the time interval is busy and that the interval can not be scheduled.";
            }
            case BUSYTENTATIVE: {
                return "Indicates that the time interval is busy because one or more events have been tentatively scheduled for that interval.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case BUSY: {
                return "Busy";
            }
            case FREE: {
                return "Free";
            }
            case BUSYUNAVAILABLE: {
                return "Busy (Unavailable)";
            }
            case BUSYTENTATIVE: {
                return "Busy (Tentative)";
            }
        }
        return "?";
    }
}

