/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ServicePlace {
    EMERGENCY,
    CLINIC,
    NULL;


    public static ServicePlace fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("emergency".equals(codeString)) {
            return EMERGENCY;
        }
        if ("clinic".equals(codeString)) {
            return CLINIC;
        }
        throw new FHIRException("Unknown ServicePlace code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case EMERGENCY: {
                return "emergency";
            }
            case CLINIC: {
                return "clinic";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-serviceplace";
    }

    public String getDefinition() {
        switch (this) {
            case EMERGENCY: {
                return "Emergency Department";
            }
            case CLINIC: {
                return "Clinic";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case EMERGENCY: {
                return "Emergency Department";
            }
            case CLINIC: {
                return "Clinic";
            }
        }
        return "?";
    }
}

