/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum QicoreObservationVerification {
    _1,
    _2,
    NULL;


    public static QicoreObservationVerification fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("1".equals(codeString)) {
            return _1;
        }
        if ("2".equals(codeString)) {
            return _2;
        }
        throw new FHIRException("Unknown QicoreObservationVerification code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _1: {
                return "1";
            }
            case _2: {
                return "2";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/qicore-observation-verification-method";
    }

    public String getDefinition() {
        switch (this) {
            case _1: {
                return "The observation was reviewed and verified by a person";
            }
            case _2: {
                return "The observation was verified against a sliding average";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _1: {
                return "Human review";
            }
            case _2: {
                return "Sliding average";
            }
        }
        return "?";
    }
}

