/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NehtaServiceBookingStatusValues {
    APT,
    ARQ,
    EVN,
    INT,
    PRMS,
    PRP,
    RQO,
    NULL;


    public static NehtaServiceBookingStatusValues fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("APT".equals(codeString)) {
            return APT;
        }
        if ("ARQ".equals(codeString)) {
            return ARQ;
        }
        if ("EVN".equals(codeString)) {
            return EVN;
        }
        if ("INT".equals(codeString)) {
            return INT;
        }
        if ("PRMS".equals(codeString)) {
            return PRMS;
        }
        if ("PRP".equals(codeString)) {
            return PRP;
        }
        if ("RQO".equals(codeString)) {
            return RQO;
        }
        throw new FHIRException("Unknown NehtaServiceBookingStatusValues code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case APT: {
                return "APT";
            }
            case ARQ: {
                return "ARQ";
            }
            case EVN: {
                return "EVN";
            }
            case INT: {
                return "INT";
            }
            case PRMS: {
                return "PRMS";
            }
            case PRP: {
                return "PRP";
            }
            case RQO: {
                return "RQO";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/service-booking-status-values";
    }

    public String getDefinition() {
        switch (this) {
            case APT: {
                return "Planned act for specific time and place";
            }
            case ARQ: {
                return "Request for Booking of an Appointment";
            }
            case EVN: {
                return "Service actually happens or happened or is ongoing";
            }
            case INT: {
                return "Plan to perform a service";
            }
            case PRMS: {
                return "An intent to perform a service";
            }
            case PRP: {
                return "Non-mandated intent to perform an act";
            }
            case RQO: {
                return "Request or Order for a service";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case APT: {
                return "Appointment";
            }
            case ARQ: {
                return "Appointment Request";
            }
            case EVN: {
                return "Event";
            }
            case INT: {
                return "Intent";
            }
            case PRMS: {
                return "Promise";
            }
            case PRP: {
                return "Proposal";
            }
            case RQO: {
                return "Request";
            }
        }
        return "?";
    }
}

