/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationStatementStatus {
    ACTIVE,
    COMPLETED,
    ENTEREDINERROR,
    INTENDED,
    NULL;


    public static MedicationStatementStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("intended".equals(codeString)) {
            return INTENDED;
        }
        throw new FHIRException("Unknown MedicationStatementStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case INTENDED: {
                return "intended";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/medication-statement-status";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "The medication is still being taken.";
            }
            case COMPLETED: {
                return "The medication is no longer being taken.";
            }
            case ENTEREDINERROR: {
                return "The statement was entered in error.";
            }
            case INTENDED: {
                return "The medication may be taken at some time in the future.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case INTENDED: {
                return "Intended";
            }
        }
        return "?";
    }
}

